import sys
from sympy.external import import_module
matchpy = import_module("matchpy")

if not matchpy:
    #bin/test will not execute any tests now
    disabled = True

if sys.version_info[:2] < (3, 6):
    disabled = True

from sympy.integrals.rubi.rubi import rubi_integrate
from sympy.functions import log, sqrt, exp, cos, sin, tan, sec, csc, cot
from sympy.functions.elementary.hyperbolic import atanh, asinh, acosh
from sympy.functions.elementary.hyperbolic import atanh as arctanh
from sympy.functions.elementary.hyperbolic import asinh as arcsinh
from sympy.functions.elementary.hyperbolic import acosh as arccosh
from sympy.functions.elementary.trigonometric import atan, asin, acos
from sympy.functions.elementary.trigonometric import atan as arctan
from sympy.functions.elementary.trigonometric import asin as arcsin
from sympy.functions.elementary.trigonometric import acos as arccos
from sympy.integrals.rubi.utility_function import (EllipticE, EllipticF,
    hypergeom, rubi_test, AppellF1, EllipticPi, Log, Sqrt, ArcTan, ArcTanh, ArcSin, Hypergeometric2F1)
from sympy import pi as Pi, elliptic_e, elliptic_f, elliptic_pi, Mod
from sympy import S, hyper, I, simplify, exp_polar, symbols, sqrt
from sympy.testing.pytest import SKIP

a, b, c, d, e, f, m, n, x, u , k, p, j, l , i= symbols('a b c d e f m n x u k p j l i1')
A, B, C, a, b, c, d, e, f, g, h, y, z, m, n, p, q, u, v, w, F = symbols('A B C a b c d e f g h y z m n p q u v w F', real=True, imaginary=False)


def test_1():

    assert rubi_test(rubi_integrate(x**m*(b*x**S(2) + c*x**S(4)), x), x, b*x**(m + S(3))/(m + S(3)) + c*x**(m + S(5))/(m + S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(b*x**S(2) + c*x**S(4)), x), x, b*x**S(5)/S(5) + c*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(b*x**S(2) + c*x**S(4)), x), x, b*x**S(4)/S(4) + c*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(b*x**S(2) + c*x**S(4), x), x, b*x**S(3)/S(3) + c*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x, x), x, b*x**S(2)/S(2) + c*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(2), x), x, b*x + c*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(3), x), x, b*log(x) + c*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(4), x), x, -b/x + c*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(5), x), x, -b/(S(2)*x**S(2)) + c*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(6), x), x, -b/(S(3)*x**S(3)) - c/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(7), x), x, -b/(S(4)*x**S(4)) - c/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**S(8), x), x, -b/(S(5)*x**S(5)) - c/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*(b*x**S(2) + c*x**S(4))**S(2), x), x, b**S(2)*x**(m + S(5))/(m + S(5)) + S(2)*b*c*x**(m + S(7))/(m + S(7)) + c**S(2)*x**(m + S(9))/(m + S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2), x), x, b**S(2)*x**S(5)/S(5) + S(2)*b*c*x**S(7)/S(7) + c**S(2)*x**S(9)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x, x), x, b**S(2)*x**S(4)/S(4) + b*c*x**S(6)/S(3) + c**S(2)*x**S(8)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(2), x), x, b**S(2)*x**S(3)/S(3) + S(2)*b*c*x**S(5)/S(5) + c**S(2)*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(3), x), x, (b + c*x**S(2))**S(3)/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(4), x), x, b**S(2)*x + S(2)*b*c*x**S(3)/S(3) + c**S(2)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(5), x), x, b**S(2)*log(x) + b*c*x**S(2) + c**S(2)*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(6), x), x, -b**S(2)/x + S(2)*b*c*x + c**S(2)*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(7), x), x, -b**S(2)/(S(2)*x**S(2)) + S(2)*b*c*log(x) + c**S(2)*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(8), x), x, -b**S(2)/(S(3)*x**S(3)) - S(2)*b*c/x + c**S(2)*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(9), x), x, -b**S(2)/(S(4)*x**S(4)) - b*c/x**S(2) + c**S(2)*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(10), x), x, -b**S(2)/(S(5)*x**S(5)) - S(2)*b*c/(S(3)*x**S(3)) - c**S(2)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(11), x), x, -(b + c*x**S(2))**S(3)/(S(6)*b*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**S(12), x), x, -b**S(2)/(S(7)*x**S(7)) - S(2)*b*c/(S(5)*x**S(5)) - c**S(2)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*(b*x**S(2) + c*x**S(4))**S(3), x), x, b**S(3)*x**(m + S(7))/(m + S(7)) + S(3)*b**S(2)*c*x**(m + S(9))/(m + S(9)) + S(3)*b*c**S(2)*x**(m + S(11))/(m + S(11)) + c**S(3)*x**(m + S(13))/(m + S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(2), x), x, b**S(3)*x**S(5)/S(5) + S(3)*b**S(2)*c*x**S(7)/S(7) + b*c**S(2)*x**S(9)/S(3) + c**S(3)*x**S(11)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(3), x), x, -b*(b + c*x**S(2))**S(4)/(S(8)*c**S(2)) + (b + c*x**S(2))**S(5)/(S(10)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(4), x), x, b**S(3)*x**S(3)/S(3) + S(3)*b**S(2)*c*x**S(5)/S(5) + S(3)*b*c**S(2)*x**S(7)/S(7) + c**S(3)*x**S(9)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(5), x), x, (b + c*x**S(2))**S(4)/(S(8)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(6), x), x, b**S(3)*x + b**S(2)*c*x**S(3) + S(3)*b*c**S(2)*x**S(5)/S(5) + c**S(3)*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(7), x), x, b**S(3)*log(x) + S(3)*b**S(2)*c*x**S(2)/S(2) + S(3)*b*c**S(2)*x**S(4)/S(4) + c**S(3)*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(8), x), x, -b**S(3)/x + S(3)*b**S(2)*c*x + b*c**S(2)*x**S(3) + c**S(3)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(9), x), x, -b**S(3)/(S(2)*x**S(2)) + S(3)*b**S(2)*c*log(x) + S(3)*b*c**S(2)*x**S(2)/S(2) + c**S(3)*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(10), x), x, -b**S(3)/(S(3)*x**S(3)) - S(3)*b**S(2)*c/x + S(3)*b*c**S(2)*x + c**S(3)*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(11), x), x, -b**S(3)/(S(4)*x**S(4)) - S(3)*b**S(2)*c/(S(2)*x**S(2)) + S(3)*b*c**S(2)*log(x) + c**S(3)*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(12), x), x, -b**S(3)/(S(5)*x**S(5)) - b**S(2)*c/x**S(3) - S(3)*b*c**S(2)/x + c**S(3)*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(13), x), x, -b**S(3)/(S(6)*x**S(6)) - S(3)*b**S(2)*c/(S(4)*x**S(4)) - S(3)*b*c**S(2)/(S(2)*x**S(2)) + c**S(3)*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(14), x), x, -b**S(3)/(S(7)*x**S(7)) - S(3)*b**S(2)*c/(S(5)*x**S(5)) - b*c**S(2)/x**S(3) - c**S(3)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(15), x), x, -(b + c*x**S(2))**S(4)/(S(8)*b*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(16), x), x, -b**S(3)/(S(9)*x**S(9)) - S(3)*b**S(2)*c/(S(7)*x**S(7)) - S(3)*b*c**S(2)/(S(5)*x**S(5)) - c**S(3)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**S(17), x), x, -b**S(3)/(S(10)*x**S(10)) - S(3)*b**S(2)*c/(S(8)*x**S(8)) - b*c**S(2)/(S(2)*x**S(6)) - c**S(3)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(b*x**S(2) + c*x**S(4)), x), x, b**(S(7)/2)*atan(sqrt(c)*x/sqrt(b))/c**(S(9)/2) - b**S(3)*x/c**S(4) + b**S(2)*x**S(3)/(S(3)*c**S(3)) - b*x**S(5)/(S(5)*c**S(2)) + x**S(7)/(S(7)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(b*x**S(2) + c*x**S(4)), x), x, -b**S(3)*log(b + c*x**S(2))/(S(2)*c**S(4)) + b**S(2)*x**S(2)/(S(2)*c**S(3)) - b*x**S(4)/(S(4)*c**S(2)) + x**S(6)/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(b*x**S(2) + c*x**S(4)), x), x, -b**(S(5)/2)*atan(sqrt(c)*x/sqrt(b))/c**(S(7)/2) + b**S(2)*x/c**S(3) - b*x**S(3)/(S(3)*c**S(2)) + x**S(5)/(S(5)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(b*x**S(2) + c*x**S(4)), x), x, b**S(2)*log(b + c*x**S(2))/(S(2)*c**S(3)) - b*x**S(2)/(S(2)*c**S(2)) + x**S(4)/(S(4)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(b*x**S(2) + c*x**S(4)), x), x, b**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/c**(S(5)/2) - b*x/c**S(2) + x**S(3)/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(b*x**S(2) + c*x**S(4)), x), x, -b*log(b + c*x**S(2))/(S(2)*c**S(2)) + x**S(2)/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(b*x**S(2) + c*x**S(4)), x), x, -sqrt(b)*atan(sqrt(c)*x/sqrt(b))/c**(S(3)/2) + x/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(b*x**S(2) + c*x**S(4)), x), x, log(b + c*x**S(2))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(b*x**S(2) + c*x**S(4)), x), x, atan(sqrt(c)*x/sqrt(b))/(sqrt(b)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(b*x**S(2) + c*x**S(4)), x), x, log(x)/b - log(b + c*x**S(2))/(S(2)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(b*x**S(2) + c*x**S(4)), x), x, -S(1)/(b*x) - sqrt(c)*atan(sqrt(c)*x/sqrt(b))/b**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(2)*b*x**S(2)) - c*log(x)/b**S(2) + c*log(b + c*x**S(2))/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(3)*b*x**S(3)) + c/(b**S(2)*x) + c**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/b**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(4)*b*x**S(4)) + c/(S(2)*b**S(2)*x**S(2)) + c**S(2)*log(x)/b**S(3) - c**S(2)*log(b + c*x**S(2))/(S(2)*b**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(5)*b*x**S(5)) + c/(S(3)*b**S(2)*x**S(3)) - c**S(2)/(b**S(3)*x) - c**(S(5)/2)*atan(sqrt(c)*x/sqrt(b))/b**(S(7)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(6)*b*x**S(6)) + c/(S(4)*b**S(2)*x**S(4)) - c**S(2)/(S(2)*b**S(3)*x**S(2)) - c**S(3)*log(x)/b**S(4) + c**S(3)*log(b + c*x**S(2))/(S(2)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -S(7)*b**(S(5)/2)*atan(sqrt(c)*x/sqrt(b))/(S(2)*c**(S(9)/2)) + S(7)*b**S(2)*x/(S(2)*c**S(4)) - S(7)*b*x**S(3)/(S(6)*c**S(3)) - x**S(7)/(S(2)*c*(b + c*x**S(2))) + S(7)*x**S(5)/(S(10)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(b*x**S(2) + c*x**S(4))**S(2), x), x, b**S(3)/(S(2)*c**S(4)*(b + c*x**S(2))) + S(3)*b**S(2)*log(b + c*x**S(2))/(S(2)*c**S(4)) - b*x**S(2)/c**S(3) + x**S(4)/(S(4)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(5)*b**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/(S(2)*c**(S(7)/2)) - S(5)*b*x/(S(2)*c**S(3)) - x**S(5)/(S(2)*c*(b + c*x**S(2))) + S(5)*x**S(3)/(S(6)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -b**S(2)/(S(2)*c**S(3)*(b + c*x**S(2))) - b*log(b + c*x**S(2))/c**S(3) + x**S(2)/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -S(3)*sqrt(b)*atan(sqrt(c)*x/sqrt(b))/(S(2)*c**(S(5)/2)) - x**S(3)/(S(2)*c*(b + c*x**S(2))) + S(3)*x/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(b*x**S(2) + c*x**S(4))**S(2), x), x, b/(S(2)*c**S(2)*(b + c*x**S(2))) + log(b + c*x**S(2))/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -x/(S(2)*c*(b + c*x**S(2))) + atan(sqrt(c)*x/sqrt(b))/(S(2)*sqrt(b)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -S(1)/(S(2)*c*(b + c*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(b*x**S(2) + c*x**S(4))**S(2), x), x, x/(S(2)*b*(b + c*x**S(2))) + atan(sqrt(c)*x/sqrt(b))/(S(2)*b**(S(3)/2)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(1)/(S(2)*b*(b + c*x**S(2))) + log(x)/b**S(2) - log(b + c*x**S(2))/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(1)/(S(2)*b*x*(b + c*x**S(2))) - S(3)/(S(2)*b**S(2)*x) - S(3)*sqrt(c)*atan(sqrt(c)*x/sqrt(b))/(S(2)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(b*x**S(2) + c*x**S(4))**S(2), x), x, -c/(S(2)*b**S(2)*(b + c*x**S(2))) - S(1)/(S(2)*b**S(2)*x**S(2)) - S(2)*c*log(x)/b**S(3) + c*log(b + c*x**S(2))/b**S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(-2)), x), x, S(1)/(S(2)*b*x**S(3)*(b + c*x**S(2))) - S(5)/(S(6)*b**S(2)*x**S(3)) + S(5)*c/(S(2)*b**S(3)*x) + S(5)*c**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/(S(2)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(b*x**S(2) + c*x**S(4))**S(2)), x), x, -S(1)/(S(4)*b**S(2)*x**S(4)) + c**S(2)/(S(2)*b**S(3)*(b + c*x**S(2))) + c/(b**S(3)*x**S(2)) + S(3)*c**S(2)*log(x)/b**S(4) - S(3)*c**S(2)*log(b + c*x**S(2))/(S(2)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(b*x**S(2) + c*x**S(4))**S(2)), x), x, S(1)/(S(2)*b*x**S(5)*(b + c*x**S(2))) - S(7)/(S(10)*b**S(2)*x**S(5)) + S(7)*c/(S(6)*b**S(3)*x**S(3)) - S(7)*c**S(2)/(S(2)*b**S(4)*x) - S(7)*c**(S(5)/2)*atan(sqrt(c)*x/sqrt(b))/(S(2)*b**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(14)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(35)*b**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/(S(8)*c**(S(9)/2)) - S(35)*b*x/(S(8)*c**S(4)) - x**S(7)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(7)*x**S(5)/(S(8)*c**S(2)*(b + c*x**S(2))) + S(35)*x**S(3)/(S(24)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(13)/(b*x**S(2) + c*x**S(4))**S(3), x), x, b**S(3)/(S(4)*c**S(4)*(b + c*x**S(2))**S(2)) - S(3)*b**S(2)/(S(2)*c**S(4)*(b + c*x**S(2))) - S(3)*b*log(b + c*x**S(2))/(S(2)*c**S(4)) + x**S(2)/(S(2)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -S(15)*sqrt(b)*atan(sqrt(c)*x/sqrt(b))/(S(8)*c**(S(7)/2)) - x**S(5)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(5)*x**S(3)/(S(8)*c**S(2)*(b + c*x**S(2))) + S(15)*x/(S(8)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -b**S(2)/(S(4)*c**S(3)*(b + c*x**S(2))**S(2)) + b/(c**S(3)*(b + c*x**S(2))) + log(b + c*x**S(2))/(S(2)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -x**S(3)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(3)*x/(S(8)*c**S(2)*(b + c*x**S(2))) + S(3)*atan(sqrt(c)*x/sqrt(b))/(S(8)*sqrt(b)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(b*x**S(2) + c*x**S(4))**S(3), x), x, x**S(4)/(S(4)*b*(b + c*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -x/(S(4)*c*(b + c*x**S(2))**S(2)) + x/(S(8)*b*c*(b + c*x**S(2))) + atan(sqrt(c)*x/sqrt(b))/(S(8)*b**(S(3)/2)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -S(1)/(S(4)*c*(b + c*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(b*x**S(2) + c*x**S(4))**S(3), x), x, x/(S(4)*b*(b + c*x**S(2))**S(2)) + S(3)*x/(S(8)*b**S(2)*(b + c*x**S(2))) + S(3)*atan(sqrt(c)*x/sqrt(b))/(S(8)*b**(S(5)/2)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*(b + c*x**S(2))**S(2)) + S(1)/(S(2)*b**S(2)*(b + c*x**S(2))) + log(x)/b**S(3) - log(b + c*x**S(2))/(S(2)*b**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x*(b + c*x**S(2))**S(2)) + S(5)/(S(8)*b**S(2)*x*(b + c*x**S(2))) - S(15)/(S(8)*b**S(3)*x) - S(15)*sqrt(c)*atan(sqrt(c)*x/sqrt(b))/(S(8)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -c/(S(4)*b**S(2)*(b + c*x**S(2))**S(2)) - c/(b**S(3)*(b + c*x**S(2))) - S(1)/(S(2)*b**S(3)*x**S(2)) - S(3)*c*log(x)/b**S(4) + S(3)*c*log(b + c*x**S(2))/(S(2)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x**S(3)*(b + c*x**S(2))**S(2)) + S(7)/(S(8)*b**S(2)*x**S(3)*(b + c*x**S(2))) - S(35)/(S(24)*b**S(3)*x**S(3)) + S(35)*c/(S(8)*b**S(4)*x) + S(35)*c**(S(3)/2)*atan(sqrt(c)*x/sqrt(b))/(S(8)*b**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(b*x**S(2) + c*x**S(4))**S(3), x), x, c**S(2)/(S(4)*b**S(3)*(b + c*x**S(2))**S(2)) - S(1)/(S(4)*b**S(3)*x**S(4)) + S(3)*c**S(2)/(S(2)*b**S(4)*(b + c*x**S(2))) + S(3)*c/(S(2)*b**S(4)*x**S(2)) + S(6)*c**S(2)*log(x)/b**S(5) - S(3)*c**S(2)*log(b + c*x**S(2))/b**S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(-3)), x), x, S(1)/(S(4)*b*x**S(5)*(b + c*x**S(2))**S(2)) + S(9)/(S(8)*b**S(2)*x**S(5)*(b + c*x**S(2))) - S(63)/(S(40)*b**S(3)*x**S(5)) + S(21)*c/(S(8)*b**S(4)*x**S(3)) - S(63)*c**S(2)/(S(8)*b**S(5)*x) - S(63)*c**(S(5)/2)*atan(sqrt(c)*x/sqrt(b))/(S(8)*b**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(b*x**S(2) + c*x**S(4))**S(3)), x), x, -S(1)/(S(6)*b**S(3)*x**S(6)) - c**S(3)/(S(4)*b**S(4)*(b + c*x**S(2))**S(2)) + S(3)*c/(S(4)*b**S(4)*x**S(4)) - S(2)*c**S(3)/(b**S(5)*(b + c*x**S(2))) - S(3)*c**S(2)/(b**S(5)*x**S(2)) - S(10)*c**S(3)*log(x)/b**S(6) + S(5)*c**S(3)*log(b + c*x**S(2))/b**S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(5)*b**S(4)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(128)*c**(S(7)/2)) + S(5)*b**S(2)*(b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(128)*c**S(3)) - S(5)*b*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(48)*c**S(2)) + x**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(8)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*sqrt(b*x**S(2) + c*x**S(4)), x), x, b**S(3)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(16)*c**(S(5)/2)) - b*(b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*c**S(2)) + (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(b*x**S(2) + c*x**S(4)), x), x, -b**S(2)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*c**(S(3)/2)) + (b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x, x), x, b*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*sqrt(c)) + sqrt(b*x**S(2) + c*x**S(4))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(3), x), x, sqrt(c)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4))) - sqrt(b*x**S(2) + c*x**S(4))/x**S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(5), x), x, -(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*b*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(7), x), x, -(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(5)*b*x**S(8)) + S(2)*c*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(15)*b**S(2)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(9), x), x, -(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(7)*b*x**S(10)) + S(4)*c*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(35)*b**S(2)*x**S(8)) - S(8)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(105)*b**S(3)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(11), x), x, -(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(9)*b*x**S(12)) + S(2)*c*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(21)*b**S(2)*x**S(10)) - S(8)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(105)*b**S(3)*x**S(8)) + S(16)*c**S(3)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(315)*b**S(4)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(13), x), x, -(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(11)*b*x**S(14)) + S(8)*c*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(99)*b**S(2)*x**S(12)) - S(16)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(231)*b**S(3)*x**S(10)) + S(64)*c**S(3)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(1155)*b**S(4)*x**S(8)) - S(128)*c**S(4)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3465)*b**S(5)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*sqrt(b*x**S(2) + c*x**S(4)), x), x, S(8)*b**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(105)*c**S(3)*x**S(3)) - S(4)*b*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(35)*c**S(2)*x) + x*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(7)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(2)*b*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(15)*c**S(2)*x**S(3)) + (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(5)*c*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4)), x), x, (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*c*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(2), x), x, -sqrt(b)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4))) + sqrt(b*x**S(2) + c*x**S(4))/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(4), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(2)*x**S(3)) - c*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(6), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(4)*x**S(5)) - c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*b*x**S(3)) + c**S(2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**S(8), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(6)*x**S(7)) - c*sqrt(b*x**S(2) + c*x**S(4))/(S(24)*b*x**S(5)) + c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*b**S(2)*x**S(3)) - c**S(3)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(16)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(3)*b**S(5)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(256)*c**(S(7)/2)) + S(3)*b**S(3)*(b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(256)*c**S(3)) - b*(b + S(2)*c*x**S(2))*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(32)*c**S(2)) + (b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(10)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(3)*b**S(4)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(128)*c**(S(5)/2)) - S(3)*b**S(2)*(b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(128)*c**S(2)) + (b + S(2)*c*x**S(2))*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(16)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x, x), x, -b**S(3)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(16)*c**(S(3)/2)) + b*(b + S(2)*c*x**S(2))*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*c) + (b*x**S(2) + c*x**S(4))**(S(3)/2)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(3), x), x, S(3)*b**S(2)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*sqrt(c)) + S(3)*b*sqrt(b*x**S(2) + c*x**S(4))/S(8) + (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(5), x), x, S(3)*b*sqrt(c)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/S(2) + S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/S(2) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(7), x), x, c**(S(3)/2)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4))) - c*sqrt(b*x**S(2) + c*x**S(4))/x**S(2) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(9), x), x, -(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(5)*b*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(11), x), x, -(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(7)*b*x**S(12)) + S(2)*c*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(35)*b**S(2)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(13), x), x, -(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(9)*b*x**S(14)) + S(4)*c*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(63)*b**S(2)*x**S(12)) - S(8)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(315)*b**S(3)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(15), x), x, -(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(11)*b*x**S(16)) + S(2)*c*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(33)*b**S(2)*x**S(14)) - S(8)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(231)*b**S(3)*x**S(12)) + S(16)*c**S(3)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(1155)*b**S(4)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(17), x), x, -(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(13)*b*x**S(18)) + S(8)*c*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(143)*b**S(2)*x**S(16)) - S(16)*c**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(429)*b**S(3)*x**S(14)) + S(64)*c**S(3)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(3003)*b**S(4)*x**S(12)) - S(128)*c**S(4)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(15015)*b**S(5)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(128)*b**S(4)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(15015)*c**S(5)*x**S(5)) - S(64)*b**S(3)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(3003)*c**S(4)*x**S(3)) + S(16)*b**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(429)*c**S(3)*x) - S(8)*b*x*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(143)*c**S(2)) + x**S(3)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(13)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(16)*b**S(3)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(1155)*c**S(4)*x**S(5)) + S(8)*b**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(231)*c**S(3)*x**S(3)) - S(2)*b*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(33)*c**S(2)*x) + x*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(11)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(8)*b**S(2)*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(315)*c**S(3)*x**S(5)) - S(4)*b*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(63)*c**S(2)*x**S(3)) + (b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(9)*c*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(2)*b*(b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(35)*c**S(2)*x**S(5)) + (b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(7)*c*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(2), x), x, (b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(5)*c*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(4), x), x, -b**(S(3)/2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4))) + b*sqrt(b*x**S(2) + c*x**S(4))/x + (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(6), x), x, -S(3)*sqrt(b)*c*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/S(2) + S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(2)*x) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(2)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(8), x), x, -S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*x**S(3)) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(4)*x**S(7)) - S(3)*c**S(2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(10), x), x, -c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*x**S(5)) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(6)*x**S(9)) - c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*b*x**S(3)) + c**S(3)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(16)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(12), x), x, -c*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*x**S(7)) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(8)*x**S(11)) - c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(64)*b*x**S(5)) + S(3)*c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(128)*b**S(2)*x**S(3)) - S(3)*c**S(4)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(128)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(14), x), x, -S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(80)*x**S(9)) - (b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(10)*x**S(13)) - c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(160)*b*x**S(7)) + c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(128)*b**S(2)*x**S(5)) - S(3)*c**S(4)*sqrt(b*x**S(2) + c*x**S(4))/(S(256)*b**S(3)*x**S(3)) + S(3)*c**S(5)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(256)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(5)*b**S(3)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(16)*c**(S(7)/2)) + S(5)*b**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(16)*c**S(3)) - S(5)*b*x**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(24)*c**S(2)) + x**S(4)*sqrt(b*x**S(2) + c*x**S(4))/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/sqrt(b*x**S(2) + c*x**S(4)), x), x, S(3)*b**S(2)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*c**(S(5)/2)) - S(3)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*c**S(2)) + x**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(4)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -b*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*c**(S(3)/2)) + sqrt(b*x**S(2) + c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(b*x**S(2) + c*x**S(4)), x), x, atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/sqrt(c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(b*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b*x**S(4)) + S(2)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b**S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b*x**S(6)) + S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b**S(2)*x**S(4)) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b**S(3)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(7)*b*x**S(8)) + S(6)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(2)*x**S(6)) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(3)*x**S(4)) + S(16)*c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(2)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c**S(2)*x) + x*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, sqrt(b*x**S(2) + c*x**S(4))/(c*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/sqrt(b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(2)*b*x**S(3)) + c*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(4)*b*x**S(5)) + S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*b**S(2)*x**S(3)) - S(3)*c**S(2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(15)*b**S(2)*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*c**(S(7)/2)) - S(15)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*c**S(3)) - x**S(6)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(5)*x**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(4)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(3)*b*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*c**(S(5)/2)) - x**S(4)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -x**S(2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/c**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, x**S(2)/(b*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -(b + S(2)*c*x**S(2))/(b**S(2)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**S(2)*sqrt(b*x**S(2) + c*x**S(4))) - S(4)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b**S(2)*x**S(4)) + S(8)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b**S(3)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**S(4)*sqrt(b*x**S(2) + c*x**S(4))) - S(6)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(2)*x**S(6)) + S(8)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(3)*x**S(4)) - S(16)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**S(6)*sqrt(b*x**S(2) + c*x**S(4))) - S(8)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*b**S(2)*x**S(8)) + S(48)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(3)*x**S(6)) - S(64)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(4)*x**S(4)) + S(128)*c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(35)*b**S(5)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -x**S(3)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*sqrt(b*x**S(2) + c*x**S(4))/(c**S(2)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -x/(c*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, x/(b*sqrt(b*x**S(2) + c*x**S(4))) - atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/b**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(-3)/2), x), x, S(1)/(b*x*sqrt(b*x**S(2) + c*x**S(4))) - S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(2)*b**S(2)*x**S(3)) + S(3)*c*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**S(3)*sqrt(b*x**S(2) + c*x**S(4))) - S(5)*sqrt(b*x**S(2) + c*x**S(4))/(S(4)*b**S(2)*x**S(5)) + S(15)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*b**S(3)*x**S(3)) - S(15)*c**S(2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(-S(4)*x**S(4) + S(3)*x**S(2)), x), x, -sqrt(-S(4)*x**S(4) + S(3)*x**S(2))/S(8) + S(3)*asin(S(8)*x**S(2)/S(3) + S(-1))/S(32), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(-S(4)*x**S(4) - S(3)*x**S(2)), x), x, -sqrt(-S(4)*x**S(4) - S(3)*x**S(2))/S(8) - S(3)*asin(S(8)*x**S(2)/S(3) + S(1))/S(32), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(S(4)*x**S(4) + S(3)*x**S(2)), x), x, sqrt(S(4)*x**S(4) + S(3)*x**S(2))/S(8) - S(3)*atanh(S(2)*x**S(2)/sqrt(S(4)*x**S(4) + S(3)*x**S(2)))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(S(4)*x**S(4) - S(3)*x**S(2)), x), x, sqrt(S(4)*x**S(4) - S(3)*x**S(2))/S(8) + S(3)*atanh(S(2)*x**S(2)/sqrt(S(4)*x**S(4) - S(3)*x**S(2)))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a*x**S(2) + b*x**S(4)), x), x, -a*atanh(sqrt(b)*x**S(2)/sqrt(a*x**S(2) + b*x**S(4)))/(S(2)*b**(S(3)/2)) + sqrt(a*x**S(2) + b*x**S(4))/(S(2)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a*x**S(2) - b*x**S(4)), x), x, a*atan(sqrt(b)*x**S(2)/sqrt(a*x**S(2) - b*x**S(4)))/(S(2)*b**(S(3)/2)) - sqrt(a*x**S(2) - b*x**S(4))/(S(2)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)*(b*x**S(2) + c*x**S(4)), x), x, S(2)*b*x**(S(13)/2)/S(13) + S(2)*c*x**(S(17)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(b*x**S(2) + c*x**S(4)), x), x, S(2)*b*x**(S(11)/2)/S(11) + S(2)*c*x**(S(15)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(b*x**S(2) + c*x**S(4)), x), x, S(2)*b*x**(S(9)/2)/S(9) + S(2)*c*x**(S(13)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(b*x**S(2) + c*x**S(4)), x), x, S(2)*b*x**(S(7)/2)/S(7) + S(2)*c*x**(S(11)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/sqrt(x), x), x, S(2)*b*x**(S(5)/2)/S(5) + S(2)*c*x**(S(9)/2)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**(S(3)/2), x), x, S(2)*b*x**(S(3)/2)/S(3) + S(2)*c*x**(S(7)/2)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**(S(5)/2), x), x, S(2)*b*sqrt(x) + S(2)*c*x**(S(5)/2)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))/x**(S(7)/2), x), x, -S(2)*b/sqrt(x) + S(2)*c*x**(S(3)/2)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)*(b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*b**S(2)*x**(S(17)/2)/S(17) + S(4)*b*c*x**(S(21)/2)/S(21) + S(2)*c**S(2)*x**(S(25)/2)/S(25), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*b**S(2)*x**(S(15)/2)/S(15) + S(4)*b*c*x**(S(19)/2)/S(19) + S(2)*c**S(2)*x**(S(23)/2)/S(23), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*b**S(2)*x**(S(13)/2)/S(13) + S(4)*b*c*x**(S(17)/2)/S(17) + S(2)*c**S(2)*x**(S(21)/2)/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*b**S(2)*x**(S(11)/2)/S(11) + S(4)*b*c*x**(S(15)/2)/S(15) + S(2)*c**S(2)*x**(S(19)/2)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/sqrt(x), x), x, S(2)*b**S(2)*x**(S(9)/2)/S(9) + S(4)*b*c*x**(S(13)/2)/S(13) + S(2)*c**S(2)*x**(S(17)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**(S(3)/2), x), x, S(2)*b**S(2)*x**(S(7)/2)/S(7) + S(4)*b*c*x**(S(11)/2)/S(11) + S(2)*c**S(2)*x**(S(15)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**(S(5)/2), x), x, S(2)*b**S(2)*x**(S(5)/2)/S(5) + S(4)*b*c*x**(S(9)/2)/S(9) + S(2)*c**S(2)*x**(S(13)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(2)/x**(S(7)/2), x), x, S(2)*b**S(2)*x**(S(3)/2)/S(3) + S(4)*b*c*x**(S(7)/2)/S(7) + S(2)*c**S(2)*x**(S(11)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)*(b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*b**S(3)*x**(S(21)/2)/S(21) + S(6)*b**S(2)*c*x**(S(25)/2)/S(25) + S(6)*b*c**S(2)*x**(S(29)/2)/S(29) + S(2)*c**S(3)*x**(S(33)/2)/S(33), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*b**S(3)*x**(S(19)/2)/S(19) + S(6)*b**S(2)*c*x**(S(23)/2)/S(23) + S(2)*b*c**S(2)*x**(S(27)/2)/S(9) + S(2)*c**S(3)*x**(S(31)/2)/S(31), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*b**S(3)*x**(S(17)/2)/S(17) + S(2)*b**S(2)*c*x**(S(21)/2)/S(7) + S(6)*b*c**S(2)*x**(S(25)/2)/S(25) + S(2)*c**S(3)*x**(S(29)/2)/S(29), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*b**S(3)*x**(S(15)/2)/S(15) + S(6)*b**S(2)*c*x**(S(19)/2)/S(19) + S(6)*b*c**S(2)*x**(S(23)/2)/S(23) + S(2)*c**S(3)*x**(S(27)/2)/S(27), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/sqrt(x), x), x, S(2)*b**S(3)*x**(S(13)/2)/S(13) + S(6)*b**S(2)*c*x**(S(17)/2)/S(17) + S(2)*b*c**S(2)*x**(S(21)/2)/S(7) + S(2)*c**S(3)*x**(S(25)/2)/S(25), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**(S(3)/2), x), x, S(2)*b**S(3)*x**(S(11)/2)/S(11) + S(2)*b**S(2)*c*x**(S(15)/2)/S(5) + S(6)*b*c**S(2)*x**(S(19)/2)/S(19) + S(2)*c**S(3)*x**(S(23)/2)/S(23), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**(S(5)/2), x), x, S(2)*b**S(3)*x**(S(9)/2)/S(9) + S(6)*b**S(2)*c*x**(S(13)/2)/S(13) + S(6)*b*c**S(2)*x**(S(17)/2)/S(17) + S(2)*c**S(3)*x**(S(21)/2)/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**S(3)/x**(S(7)/2), x), x, S(2)*b**S(3)*x**(S(7)/2)/S(7) + S(6)*b**S(2)*c*x**(S(11)/2)/S(11) + S(2)*b*c**S(2)*x**(S(15)/2)/S(5) + S(2)*c**S(3)*x**(S(19)/2)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(b*x**S(2) + c*x**S(4)), x), x, sqrt(S(2))*b**(S(7)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(11)/4)) - sqrt(S(2))*b**(S(7)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(11)/4)) - sqrt(S(2))*b**(S(7)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(11)/4)) + sqrt(S(2))*b**(S(7)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(11)/4)) - S(2)*b*x**(S(3)/2)/(S(3)*c**S(2)) + S(2)*x**(S(7)/2)/(S(7)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*b**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(9)/4)) + sqrt(S(2))*b**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(9)/4)) - sqrt(S(2))*b**(S(5)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(9)/4)) + sqrt(S(2))*b**(S(5)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(9)/4)) - S(2)*b*sqrt(x)/c**S(2) + S(2)*x**(S(5)/2)/(S(5)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*b**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(7)/4)) + sqrt(S(2))*b**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(7)/4)) + sqrt(S(2))*b**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(7)/4)) - sqrt(S(2))*b**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(7)/4)) + S(2)*x**(S(3)/2)/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(b*x**S(2) + c*x**S(4)), x), x, sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(5)/4)) - sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*c**(S(5)/4)) + sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(5)/4)) - sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*c**(S(5)/4)) + S(2)*sqrt(x)/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(b*x**S(2) + c*x**S(4)), x), x, sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(1)/4)*c**(S(3)/4)) - sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(1)/4)*c**(S(3)/4)) - sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(1)/4)*c**(S(3)/4)) + sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(1)/4)*c**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(3)/4)*c**(S(1)/4)) + sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(3)/4)*c**(S(1)/4)) - sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(3)/4)*c**(S(1)/4)) + sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(3)/4)*c**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(b*x**S(2) + c*x**S(4)), x), x, -S(2)/(b*sqrt(x)) - sqrt(S(2))*c**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(5)/4)) + sqrt(S(2))*c**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(5)/4)) + sqrt(S(2))*c**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(5)/4)) - sqrt(S(2))*c**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(b*x**S(2) + c*x**S(4))), x), x, -S(2)/(S(3)*b*x**(S(3)/2)) + sqrt(S(2))*c**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(7)/4)) - sqrt(S(2))*c**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(7)/4)) + sqrt(S(2))*c**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(7)/4)) - sqrt(S(2))*c**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))), x), x, -S(2)/(S(5)*b*x**(S(5)/2)) + S(2)*c/(b**S(2)*sqrt(x)) + sqrt(S(2))*c**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(9)/4)) - sqrt(S(2))*c**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(9)/4)) - sqrt(S(2))*c**(S(5)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(9)/4)) + sqrt(S(2))*c**(S(5)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(9)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(5)/2)*(b*x**S(2) + c*x**S(4))), x), x, -S(2)/(S(7)*b*x**(S(7)/2)) + S(2)*c/(S(3)*b**S(2)*x**(S(3)/2)) - sqrt(S(2))*c**(S(7)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(11)/4)) + sqrt(S(2))*c**(S(7)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(11)/4)) - sqrt(S(2))*c**(S(7)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(11)/4)) + sqrt(S(2))*c**(S(7)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(11)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(7)/2)*(b*x**S(2) + c*x**S(4))), x), x, -S(2)/(S(9)*b*x**(S(9)/2)) + S(2)*c/(S(5)*b**S(2)*x**(S(5)/2)) - S(2)*c**S(2)/(b**S(3)*sqrt(x)) - sqrt(S(2))*c**(S(9)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(13)/4)) + sqrt(S(2))*c**(S(9)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(4)*b**(S(13)/4)) + sqrt(S(2))*c**(S(9)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(13)/4)) - sqrt(S(2))*c**(S(9)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(2)*b**(S(13)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(19)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -S(9)*sqrt(S(2))*b**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(13)/4)) + S(9)*sqrt(S(2))*b**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(13)/4)) - S(9)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(13)/4)) + S(9)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(13)/4)) - S(9)*b*sqrt(x)/(S(2)*c**S(3)) - x**(S(9)/2)/(S(2)*c*(b + c*x**S(2))) + S(9)*x**(S(5)/2)/(S(10)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(17)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -S(7)*sqrt(S(2))*b**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(11)/4)) + S(7)*sqrt(S(2))*b**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(11)/4)) + S(7)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(11)/4)) - S(7)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(11)/4)) - x**(S(7)/2)/(S(2)*c*(b + c*x**S(2))) + S(7)*x**(S(3)/2)/(S(6)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(15)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(5)*sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(9)/4)) - S(5)*sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*c**(S(9)/4)) + S(5)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(9)/4)) - S(5)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*c**(S(9)/4)) - x**(S(5)/2)/(S(2)*c*(b + c*x**S(2))) + S(5)*sqrt(x)/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -x**(S(3)/2)/(S(2)*c*(b + c*x**S(2))) + S(3)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(1)/4)*c**(S(7)/4)) - S(3)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(1)/4)*c**(S(7)/4)) - S(3)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(1)/4)*c**(S(7)/4)) + S(3)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(1)/4)*c**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, -sqrt(x)/(S(2)*c*(b + c*x**S(2))) - sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(3)/4)*c**(S(5)/4)) + sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(3)/4)*c**(S(5)/4)) - sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(3)/4)*c**(S(5)/4)) + sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(3)/4)*c**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, x**(S(3)/2)/(S(2)*b*(b + c*x**S(2))) + sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(5)/4)*c**(S(3)/4)) - sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(5)/4)*c**(S(3)/4)) - sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(5)/4)*c**(S(3)/4)) + sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(5)/4)*c**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, sqrt(x)/(S(2)*b*(b + c*x**S(2))) - S(3)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(7)/4)*c**(S(1)/4)) + S(3)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(7)/4)*c**(S(1)/4)) - S(3)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(7)/4)*c**(S(1)/4)) + S(3)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(7)/4)*c**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(1)/(S(2)*b*sqrt(x)*(b + c*x**S(2))) - S(5)/(S(2)*b**S(2)*sqrt(x)) - S(5)*sqrt(S(2))*c**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(9)/4)) + S(5)*sqrt(S(2))*c**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(9)/4)) + S(5)*sqrt(S(2))*c**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(9)/4)) - S(5)*sqrt(S(2))*c**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(9)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(1)/(S(2)*b*x**(S(3)/2)*(b + c*x**S(2))) - S(7)/(S(6)*b**S(2)*x**(S(3)/2)) + S(7)*sqrt(S(2))*c**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(11)/4)) - S(7)*sqrt(S(2))*c**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(11)/4)) + S(7)*sqrt(S(2))*c**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(11)/4)) - S(7)*sqrt(S(2))*c**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(11)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(b*x**S(2) + c*x**S(4))**S(2), x), x, S(1)/(S(2)*b*x**(S(5)/2)*(b + c*x**S(2))) - S(9)/(S(10)*b**S(2)*x**(S(5)/2)) + S(9)*c/(S(2)*b**S(3)*sqrt(x)) + S(9)*sqrt(S(2))*c**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(13)/4)) - S(9)*sqrt(S(2))*c**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(13)/4)) - S(9)*sqrt(S(2))*c**(S(5)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(13)/4)) + S(9)*sqrt(S(2))*c**(S(5)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(13)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(b*x**S(2) + c*x**S(4))**S(2)), x), x, S(1)/(S(2)*b*x**(S(7)/2)*(b + c*x**S(2))) - S(11)/(S(14)*b**S(2)*x**(S(7)/2)) + S(11)*c/(S(6)*b**S(3)*x**(S(3)/2)) - S(11)*sqrt(S(2))*c**(S(7)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(15)/4)) + S(11)*sqrt(S(2))*c**(S(7)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(15)/4)) - S(11)*sqrt(S(2))*c**(S(7)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(15)/4)) + S(11)*sqrt(S(2))*c**(S(7)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(15)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**S(2)), x), x, S(1)/(S(2)*b*x**(S(9)/2)*(b + c*x**S(2))) - S(13)/(S(18)*b**S(2)*x**(S(9)/2)) + S(13)*c/(S(10)*b**S(3)*x**(S(5)/2)) - S(13)*c**S(2)/(S(2)*b**S(4)*sqrt(x)) - S(13)*sqrt(S(2))*c**(S(9)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(17)/4)) + S(13)*sqrt(S(2))*c**(S(9)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(16)*b**(S(17)/4)) + S(13)*sqrt(S(2))*c**(S(9)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(17)/4)) - S(13)*sqrt(S(2))*c**(S(9)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(8)*b**(S(17)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(23)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(45)*sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*c**(S(13)/4)) - S(45)*sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*c**(S(13)/4)) + S(45)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*c**(S(13)/4)) - S(45)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*c**(S(13)/4)) - x**(S(9)/2)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(9)*x**(S(5)/2)/(S(16)*c**S(2)*(b + c*x**S(2))) + S(45)*sqrt(x)/(S(16)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(21)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -x**(S(7)/2)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(7)*x**(S(3)/2)/(S(16)*c**S(2)*(b + c*x**S(2))) + S(21)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(1)/4)*c**(S(11)/4)) - S(21)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(1)/4)*c**(S(11)/4)) - S(21)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(1)/4)*c**(S(11)/4)) + S(21)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(1)/4)*c**(S(11)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(19)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -x**(S(5)/2)/(S(4)*c*(b + c*x**S(2))**S(2)) - S(5)*sqrt(x)/(S(16)*c**S(2)*(b + c*x**S(2))) - S(5)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(3)/4)*c**(S(9)/4)) + S(5)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(3)/4)*c**(S(9)/4)) - S(5)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(3)/4)*c**(S(9)/4)) + S(5)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(3)/4)*c**(S(9)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(17)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -x**(S(3)/2)/(S(4)*c*(b + c*x**S(2))**S(2)) + S(3)*x**(S(3)/2)/(S(16)*b*c*(b + c*x**S(2))) + S(3)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(5)/4)*c**(S(7)/4)) - S(3)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(5)/4)*c**(S(7)/4)) - S(3)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(5)/4)*c**(S(7)/4)) + S(3)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(5)/4)*c**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(15)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, -sqrt(x)/(S(4)*c*(b + c*x**S(2))**S(2)) + sqrt(x)/(S(16)*b*c*(b + c*x**S(2))) - S(3)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(7)/4)*c**(S(5)/4)) + S(3)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(7)/4)*c**(S(5)/4)) - S(3)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(7)/4)*c**(S(5)/4)) + S(3)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(7)/4)*c**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, x**(S(3)/2)/(S(4)*b*(b + c*x**S(2))**S(2)) + S(5)*x**(S(3)/2)/(S(16)*b**S(2)*(b + c*x**S(2))) + S(5)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(9)/4)*c**(S(3)/4)) - S(5)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(9)/4)*c**(S(3)/4)) - S(5)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(9)/4)*c**(S(3)/4)) + S(5)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(9)/4)*c**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, sqrt(x)/(S(4)*b*(b + c*x**S(2))**S(2)) + S(7)*sqrt(x)/(S(16)*b**S(2)*(b + c*x**S(2))) - S(21)*sqrt(S(2))*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(11)/4)*c**(S(1)/4)) + S(21)*sqrt(S(2))*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(11)/4)*c**(S(1)/4)) - S(21)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(11)/4)*c**(S(1)/4)) + S(21)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(11)/4)*c**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*sqrt(x)*(b + c*x**S(2))**S(2)) + S(9)/(S(16)*b**S(2)*sqrt(x)*(b + c*x**S(2))) - S(45)/(S(16)*b**S(3)*sqrt(x)) - S(45)*sqrt(S(2))*c**(S(1)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(13)/4)) + S(45)*sqrt(S(2))*c**(S(1)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(13)/4)) + S(45)*sqrt(S(2))*c**(S(1)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(13)/4)) - S(45)*sqrt(S(2))*c**(S(1)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(13)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x**(S(3)/2)*(b + c*x**S(2))**S(2)) + S(11)/(S(16)*b**S(2)*x**(S(3)/2)*(b + c*x**S(2))) - S(77)/(S(48)*b**S(3)*x**(S(3)/2)) + S(77)*sqrt(S(2))*c**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(15)/4)) - S(77)*sqrt(S(2))*c**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(15)/4)) + S(77)*sqrt(S(2))*c**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(15)/4)) - S(77)*sqrt(S(2))*c**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(15)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x**(S(5)/2)*(b + c*x**S(2))**S(2)) + S(13)/(S(16)*b**S(2)*x**(S(5)/2)*(b + c*x**S(2))) - S(117)/(S(80)*b**S(3)*x**(S(5)/2)) + S(117)*c/(S(16)*b**S(4)*sqrt(x)) + S(117)*sqrt(S(2))*c**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(17)/4)) - S(117)*sqrt(S(2))*c**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(17)/4)) - S(117)*sqrt(S(2))*c**(S(5)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(17)/4)) + S(117)*sqrt(S(2))*c**(S(5)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(17)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x**(S(7)/2)*(b + c*x**S(2))**S(2)) + S(15)/(S(16)*b**S(2)*x**(S(7)/2)*(b + c*x**S(2))) - S(165)/(S(112)*b**S(3)*x**(S(7)/2)) + S(55)*c/(S(16)*b**S(4)*x**(S(3)/2)) - S(165)*sqrt(S(2))*c**(S(7)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(19)/4)) + S(165)*sqrt(S(2))*c**(S(7)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(19)/4)) - S(165)*sqrt(S(2))*c**(S(7)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(19)/4)) + S(165)*sqrt(S(2))*c**(S(7)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(19)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(b*x**S(2) + c*x**S(4))**S(3), x), x, S(1)/(S(4)*b*x**(S(9)/2)*(b + c*x**S(2))**S(2)) + S(17)/(S(16)*b**S(2)*x**(S(9)/2)*(b + c*x**S(2))) - S(221)/(S(144)*b**S(3)*x**(S(9)/2)) + S(221)*c/(S(80)*b**S(4)*x**(S(5)/2)) - S(221)*c**S(2)/(S(16)*b**S(5)*sqrt(x)) - S(221)*sqrt(S(2))*c**(S(9)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(21)/4)) + S(221)*sqrt(S(2))*c**(S(9)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(21)/4)) + S(221)*sqrt(S(2))*c**(S(9)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(21)/4)) - S(221)*sqrt(S(2))*c**(S(9)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(21)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(b*x**S(2) + c*x**S(4))**S(3)), x), x, S(1)/(S(4)*b*x**(S(11)/2)*(b + c*x**S(2))**S(2)) + S(19)/(S(16)*b**S(2)*x**(S(11)/2)*(b + c*x**S(2))) - S(285)/(S(176)*b**S(3)*x**(S(11)/2)) + S(285)*c/(S(112)*b**S(4)*x**(S(7)/2)) - S(95)*c**S(2)/(S(16)*b**S(5)*x**(S(3)/2)) + S(285)*sqrt(S(2))*c**(S(11)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(23)/4)) - S(285)*sqrt(S(2))*c**(S(11)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*sqrt(x) + sqrt(b) + sqrt(c)*x)/(S(128)*b**(S(23)/4)) + S(285)*sqrt(S(2))*c**(S(11)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(23)/4)) - S(285)*sqrt(S(2))*c**(S(11)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*sqrt(x)/b**(S(1)/4))/(S(64)*b**(S(23)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(28)*b**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(195)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(14)*b**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(195)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(28)*b**S(3)*x**(S(3)/2)*(b + c*x**S(2))/(S(195)*c**(S(5)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(28)*b**S(2)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(585)*c**S(2)) + S(4)*b*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(117)*c) + S(2)*x**(S(9)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4)), x), x, S(10)*b**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(231)*c**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(20)*b**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(231)*c**S(2)*sqrt(x)) + S(4)*b*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*c) + S(2)*x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4)), x), x, S(4)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(2)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(4)*b**S(2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*c**(S(3)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(45)*c) + S(2)*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(2)*b**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(21)*c**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(21)*c*sqrt(x)) + S(2)*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/sqrt(x), x), x, -S(4)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*sqrt(c)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(3)/2), x), x, S(2)*b**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(3)*c**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*sqrt(x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(5)/2), x), x, -S(4)*b**(S(1)/4)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/sqrt(b*x**S(2) + c*x**S(4)) + S(2)*b**(S(1)/4)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/sqrt(b*x**S(2) + c*x**S(4)) + S(4)*sqrt(c)*x**(S(3)/2)*(b + c*x**S(2))/((sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(2)*sqrt(b*x**S(2) + c*x**S(4))/x**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(7)/2), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*x**(S(5)/2)) + S(2)*c**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(3)*b**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(9)/2), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*x**(S(7)/2)) + S(4)*c**(S(3)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*b*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b*x**(S(3)/2)) - S(4)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(11)/2), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*x**(S(9)/2)) - S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(21)*b*x**(S(5)/2)) - S(2)*c**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(21)*b**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(13)/2), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(9)*x**(S(11)/2)) - S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(45)*b*x**(S(7)/2)) - S(4)*c**(S(5)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*b**S(2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b**S(2)*x**(S(3)/2)) + S(4)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(2)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(b*x**S(2) + c*x**S(4))/x**(S(15)/2), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(11)*x**(S(13)/2)) - S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*b*x**(S(9)/2)) + S(20)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(231)*b**S(2)*x**(S(5)/2)) + S(10)*c**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(231)*b**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(56)*b**(S(17)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(1105)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(28)*b**(S(17)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(1105)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(56)*b**S(4)*x**(S(3)/2)*(b + c*x**S(2))/(S(1105)*c**(S(5)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(56)*b**S(3)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(3315)*c**S(2)) + S(8)*b**S(2)*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(663)*c) + S(12)*b*x**(S(9)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(221) + S(2)*x**(S(5)/2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(4)*b**(S(15)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(231)*c**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(8)*b**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(231)*c**S(2)*sqrt(x)) + S(8)*b**S(2)*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(385)*c) + S(4)*b*x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(55) + S(2)*x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/sqrt(x), x), x, S(8)*b**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(65)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(4)*b**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(65)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(8)*b**S(3)*x**(S(3)/2)*(b + c*x**S(2))/(S(65)*c**(S(3)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(8)*b**S(2)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(195)*c) + S(4)*b*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(39) + S(2)*sqrt(x)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(3)/2), x), x, -S(4)*b**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(77)*c**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(8)*b**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*c*sqrt(x)) + S(12)*b*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/S(77) + S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(11)*sqrt(x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(5)/2), x), x, -S(8)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(8)*b**S(2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*sqrt(c)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/S(15) + S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(9)*x**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(7)/2), x), x, S(4)*b**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(7)*c**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*sqrt(x)) + S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(7)*x**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(9)/2), x), x, -S(24)*b**(S(5)/4)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*sqrt(b*x**S(2) + c*x**S(4))) + S(12)*b**(S(5)/4)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*sqrt(b*x**S(2) + c*x**S(4))) + S(24)*b*sqrt(c)*x**(S(3)/2)*(b + c*x**S(2))/((S(5)*sqrt(b) + S(5)*sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(12)*c*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/S(5) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(7)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(11)/2), x), x, S(4)*b**(S(3)/4)*c**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(3)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*sqrt(x)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*x**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(13)/2), x), x, -S(24)*b**(S(1)/4)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*sqrt(b*x**S(2) + c*x**S(4))) + S(12)*b**(S(1)/4)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*sqrt(b*x**S(2) + c*x**S(4))) + S(24)*c**(S(3)/2)*x**(S(3)/2)*(b + c*x**S(2))/((S(5)*sqrt(b) + S(5)*sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(12)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*x**(S(3)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(5)*x**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(15)/2), x), x, -S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*x**(S(5)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(7)*x**(S(13)/2)) + S(4)*c**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(7)*b**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(17)/2), x), x, -S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*x**(S(7)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(9)*x**(S(15)/2)) + S(8)*c**(S(5)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*b*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b*x**(S(3)/2)) - S(8)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(4)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(19)/2), x), x, -S(12)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*x**(S(9)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(11)*x**(S(17)/2)) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*b*x**(S(5)/2)) - S(4)*c**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(77)*b**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(21)/2), x), x, -S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(39)*x**(S(11)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(13)*x**(S(19)/2)) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(195)*b*x**(S(7)/2)) - S(8)*c**(S(7)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(65)*b**S(2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(8)*c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(65)*b**S(2)*x**(S(3)/2)) + S(8)*c**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(65)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(4)*c**(S(13)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(65)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + c*x**S(4))**(S(3)/2)/x**(S(23)/2), x), x, -S(4)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(55)*x**(S(13)/2)) - S(2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(15)*x**(S(21)/2)) - S(8)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(385)*b*x**(S(9)/2)) + S(8)*c**S(3)*sqrt(b*x**S(2) + c*x**S(4))/(S(231)*b**S(2)*x**(S(5)/2)) + S(4)*c**(S(15)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(231)*b**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(15)*b**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(77)*c**(S(13)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(30)*b**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*c**S(3)*sqrt(x)) - S(18)*b*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*c**S(2)) + S(2)*x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(11)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(14)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(7)*b**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(14)*b**S(2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*c**(S(5)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(14)*b*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(45)*c**S(2)) + S(2)*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(9)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, S(5)*b**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(21)*c**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(10)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(21)*c**S(2)*sqrt(x)) + S(2)*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, S(6)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(3)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(6)*b*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*c**(S(3)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -b**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(3)*c**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c*sqrt(x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(2)*b**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + b**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(2)*x**(S(3)/2)*(b + c*x**S(2))/(sqrt(c)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/sqrt(b*x**S(2) + c*x**S(4)), x), x, x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(b**(S(1)/4)*c**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))), x), x, S(2)*sqrt(c)*x**(S(3)/2)*(b + c*x**S(2))/(b*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(2)*sqrt(b*x**S(2) + c*x**S(4))/(b*x**(S(3)/2)) - S(2)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) + c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(b**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b*x**(S(5)/2)) - c**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(3)*b**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b*x**(S(7)/2)) - S(6)*c**(S(3)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*b**S(2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(6)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(2)*x**(S(3)/2)) + S(6)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(3)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*b*x**(S(9)/2)) + S(10)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(21)*b**S(2)*x**(S(5)/2)) + S(5)*c**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(21)*b**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(9)/2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(9)*b*x**(S(11)/2)) + S(14)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(45)*b**S(2)*x**(S(7)/2)) + S(14)*c**(S(5)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*b**S(3)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(14)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b**S(3)*x**(S(3)/2)) - S(14)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(7)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(11)/2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(11)*b*x**(S(13)/2)) + S(18)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*b**S(2)*x**(S(9)/2)) - S(30)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(77)*b**S(3)*x**(S(5)/2)) - S(15)*c**(S(11)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(77)*b**(S(13)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(17)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(15)*b**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(14)*c**(S(13)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(15)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*c**S(3)*sqrt(x)) - x**(S(11)/2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(9)*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(15)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(21)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(21)*b**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(10)*c**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(21)*b*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*c**(S(5)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - x**(S(9)/2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(7)*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(5)*b**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(6)*c**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))) - x**(S(7)/2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(5)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c**S(2)*sqrt(x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(3)*b**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(3)*b**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(2)*c**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) - x**(S(5)/2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + S(3)*x**(S(3)/2)*(b + c*x**S(2))/(c**(S(3)/2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -x**(S(3)/2)/(c*sqrt(b*x**S(2) + c*x**S(4))) + x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(2)*b**(S(1)/4)*c**(S(5)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, x**(S(5)/2)/(b*sqrt(b*x**S(2) + c*x**S(4))) - x**(S(3)/2)*(b + c*x**S(2))/(b*sqrt(c)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(b**(S(3)/4)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))) - x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(2)*b**(S(3)/4)*c**(S(3)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, x**(S(3)/2)/(b*sqrt(b*x**S(2) + c*x**S(4))) + x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(2)*b**(S(5)/4)*c**(S(1)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, sqrt(x)/(b*sqrt(b*x**S(2) + c*x**S(4))) + S(3)*sqrt(c)*x**(S(3)/2)*(b + c*x**S(2))/(b**S(2)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(3)*sqrt(b*x**S(2) + c*x**S(4))/(b**S(2)*x**(S(3)/2)) - S(3)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(3)*c**(S(1)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(2)*b**(S(7)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(1)/(b*sqrt(x)*sqrt(b*x**S(2) + c*x**S(4))) - S(5)*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b**S(2)*x**(S(5)/2)) - S(5)*c**(S(3)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(6)*b**(S(9)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**(S(3)/2)*sqrt(b*x**S(2) + c*x**S(4))) - S(7)*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(2)*x**(S(7)/2)) - S(21)*c**(S(3)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(5)*b**S(3)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) + S(21)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(5)*b**S(3)*x**(S(3)/2)) + S(21)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(5)*b**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))) - S(21)*c**(S(5)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(10)*b**(S(11)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**(S(5)/2)*sqrt(b*x**S(2) + c*x**S(4))) - S(9)*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*b**S(2)*x**(S(9)/2)) + S(15)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(7)*b**S(3)*x**(S(5)/2)) + S(15)*c**(S(7)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(14)*b**(S(13)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(5)/2)*(b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(1)/(b*x**(S(7)/2)*sqrt(b*x**S(2) + c*x**S(4))) - S(11)*sqrt(b*x**S(2) + c*x**S(4))/(S(9)*b**S(2)*x**(S(11)/2)) + S(77)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(45)*b**S(3)*x**(S(7)/2)) + S(77)*c**(S(5)/2)*x**(S(3)/2)*(b + c*x**S(2))/(S(15)*b**S(4)*(sqrt(b) + sqrt(c)*x)*sqrt(b*x**S(2) + c*x**S(4))) - S(77)*c**S(2)*sqrt(b*x**S(2) + c*x**S(4))/(S(15)*b**S(4)*x**(S(3)/2)) - S(77)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_e(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(15)*b**(S(15)/4)*sqrt(b*x**S(2) + c*x**S(4))) + S(77)*c**(S(9)/4)*x*sqrt((b + c*x**S(2))/(sqrt(b) + sqrt(c)*x)**S(2))*(sqrt(b) + sqrt(c)*x)*elliptic_f(S(2)*atan(c**(S(1)/4)*sqrt(x)/b**(S(1)/4)), S(1)/2)/(S(30)*b**(S(15)/4)*sqrt(b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(2)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(2)*a*b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + b**S(2)*(d*x)**(m + S(5))/(d**S(5)*(m + S(5))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(2)*x**S(4)/S(4) + a*b*x**S(6)/S(3) + b**S(2)*x**S(8)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(2)*x**S(3)/S(3) + S(2)*a*b*x**S(5)/S(5) + b**S(2)*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(2)*x**S(2)/S(2) + a*b*x**S(4)/S(2) + b**S(2)*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4), x), x, a**S(2)*x + S(2)*a*b*x**S(3)/S(3) + b**S(2)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x, x), x, a**S(2)*log(x) + a*b*x**S(2) + b**S(2)*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(2), x), x, -a**S(2)/x + S(2)*a*b*x + b**S(2)*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(3), x), x, -a**S(2)/(S(2)*x**S(2)) + S(2)*a*b*log(x) + b**S(2)*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(4), x), x, -a**S(2)/(S(3)*x**S(3)) - S(2)*a*b/x + b**S(2)*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(5), x), x, -a**S(2)/(S(4)*x**S(4)) - a*b/x**S(2) + b**S(2)*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(6), x), x, -a**S(2)/(S(5)*x**S(5)) - S(2)*a*b/(S(3)*x**S(3)) - b**S(2)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(7), x), x, -a**S(2)/(S(6)*x**S(6)) - a*b/(S(2)*x**S(4)) - b**S(2)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(8), x), x, -a**S(2)/(S(7)*x**S(7)) - S(2)*a*b/(S(5)*x**S(5)) - b**S(2)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(4)*a**S(3)*b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + S(6)*a**S(2)*b**S(2)*(d*x)**(m + S(5))/(d**S(5)*(m + S(5))) + S(4)*a*b**S(3)*(d*x)**(m + S(7))/(d**S(7)*(m + S(7))) + b**S(4)*(d*x)**(m + S(9))/(d**S(9)*(m + S(9))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*x**S(7)/S(7) + S(4)*a**S(3)*b*x**S(9)/S(9) + S(6)*a**S(2)*b**S(2)*x**S(11)/S(11) + S(4)*a*b**S(3)*x**S(13)/S(13) + b**S(4)*x**S(15)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*x**S(6)/S(6) + a**S(3)*b*x**S(8)/S(2) + S(3)*a**S(2)*b**S(2)*x**S(10)/S(5) + a*b**S(3)*x**S(12)/S(3) + b**S(4)*x**S(14)/S(14), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*x**S(5)/S(5) + S(4)*a**S(3)*b*x**S(7)/S(7) + S(2)*a**S(2)*b**S(2)*x**S(9)/S(3) + S(4)*a*b**S(3)*x**S(11)/S(11) + b**S(4)*x**S(13)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -a*(a + b*x**S(2))**S(5)/(S(10)*b**S(2)) + (a + b*x**S(2))**S(6)/(S(12)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*x**S(3)/S(3) + S(4)*a**S(3)*b*x**S(5)/S(5) + S(6)*a**S(2)*b**S(2)*x**S(7)/S(7) + S(4)*a*b**S(3)*x**S(9)/S(9) + b**S(4)*x**S(11)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, (a + b*x**S(2))**S(5)/(S(10)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(4)*x + S(4)*a**S(3)*b*x**S(3)/S(3) + S(6)*a**S(2)*b**S(2)*x**S(5)/S(5) + S(4)*a*b**S(3)*x**S(7)/S(7) + b**S(4)*x**S(9)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x, x), x, a**S(4)*log(x) + S(2)*a**S(3)*b*x**S(2) + S(3)*a**S(2)*b**S(2)*x**S(4)/S(2) + S(2)*a*b**S(3)*x**S(6)/S(3) + b**S(4)*x**S(8)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(2), x), x, -a**S(4)/x + S(4)*a**S(3)*b*x + S(2)*a**S(2)*b**S(2)*x**S(3) + S(4)*a*b**S(3)*x**S(5)/S(5) + b**S(4)*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(3), x), x, -a**S(4)/(S(2)*x**S(2)) + S(4)*a**S(3)*b*log(x) + S(3)*a**S(2)*b**S(2)*x**S(2) + a*b**S(3)*x**S(4) + b**S(4)*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(4), x), x, -a**S(4)/(S(3)*x**S(3)) - S(4)*a**S(3)*b/x + S(6)*a**S(2)*b**S(2)*x + S(4)*a*b**S(3)*x**S(3)/S(3) + b**S(4)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(5), x), x, -a**S(4)/(S(4)*x**S(4)) - S(2)*a**S(3)*b/x**S(2) + S(6)*a**S(2)*b**S(2)*log(x) + S(2)*a*b**S(3)*x**S(2) + b**S(4)*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(6), x), x, -a**S(4)/(S(5)*x**S(5)) - S(4)*a**S(3)*b/(S(3)*x**S(3)) - S(6)*a**S(2)*b**S(2)/x + S(4)*a*b**S(3)*x + b**S(4)*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(7), x), x, -a**S(4)/(S(6)*x**S(6)) - a**S(3)*b/x**S(4) - S(3)*a**S(2)*b**S(2)/x**S(2) + S(4)*a*b**S(3)*log(x) + b**S(4)*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(8), x), x, -a**S(4)/(S(7)*x**S(7)) - S(4)*a**S(3)*b/(S(5)*x**S(5)) - S(2)*a**S(2)*b**S(2)/x**S(3) - S(4)*a*b**S(3)/x + b**S(4)*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(9), x), x, -a**S(4)/(S(8)*x**S(8)) - S(2)*a**S(3)*b/(S(3)*x**S(6)) - S(3)*a**S(2)*b**S(2)/(S(2)*x**S(4)) - S(2)*a*b**S(3)/x**S(2) + b**S(4)*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(10), x), x, -a**S(4)/(S(9)*x**S(9)) - S(4)*a**S(3)*b/(S(7)*x**S(7)) - S(6)*a**S(2)*b**S(2)/(S(5)*x**S(5)) - S(4)*a*b**S(3)/(S(3)*x**S(3)) - b**S(4)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(11), x), x, -(a + b*x**S(2))**S(5)/(S(10)*a*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(12), x), x, -a**S(4)/(S(11)*x**S(11)) - S(4)*a**S(3)*b/(S(9)*x**S(9)) - S(6)*a**S(2)*b**S(2)/(S(7)*x**S(7)) - S(4)*a*b**S(3)/(S(5)*x**S(5)) - b**S(4)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(13), x), x, -(a + b*x**S(2))**S(5)/(S(12)*a*x**S(12)) + b*(a + b*x**S(2))**S(5)/(S(60)*a**S(2)*x**S(10)), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(13), x), x, -a**S(4)/(S(12)*x**S(12)) - S(2)*a**S(3)*b/(S(5)*x**S(10)) - S(3)*a**S(2)*b**S(2)/(S(4)*x**S(8)) - S(2)*a*b**S(3)/(S(3)*x**S(6)) - b**S(4)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(14), x), x, -a**S(4)/(S(13)*x**S(13)) - S(4)*a**S(3)*b/(S(11)*x**S(11)) - S(2)*a**S(2)*b**S(2)/(S(3)*x**S(9)) - S(4)*a*b**S(3)/(S(7)*x**S(7)) - b**S(4)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(15), x), x, -a**S(4)/(S(14)*x**S(14)) - a**S(3)*b/(S(3)*x**S(12)) - S(3)*a**S(2)*b**S(2)/(S(5)*x**S(10)) - a*b**S(3)/(S(2)*x**S(8)) - b**S(4)/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/x**S(16), x), x, -a**S(4)/(S(15)*x**S(15)) - S(4)*a**S(3)*b/(S(13)*x**S(13)) - S(6)*a**S(2)*b**S(2)/(S(11)*x**S(11)) - S(4)*a*b**S(3)/(S(9)*x**S(9)) - b**S(4)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(6)*a**S(5)*b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + S(15)*a**S(4)*b**S(2)*(d*x)**(m + S(5))/(d**S(5)*(m + S(5))) + S(20)*a**S(3)*b**S(3)*(d*x)**(m + S(7))/(d**S(7)*(m + S(7))) + S(15)*a**S(2)*b**S(4)*(d*x)**(m + S(9))/(d**S(9)*(m + S(9))) + S(6)*a*b**S(5)*(d*x)**(m + S(11))/(d**S(11)*(m + S(11))) + b**S(6)*(d*x)**(m + S(13))/(d**S(13)*(m + S(13))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x**S(9)/S(9) + S(6)*a**S(5)*b*x**S(11)/S(11) + S(15)*a**S(4)*b**S(2)*x**S(13)/S(13) + S(4)*a**S(3)*b**S(3)*x**S(15)/S(3) + S(15)*a**S(2)*b**S(4)*x**S(17)/S(17) + S(6)*a*b**S(5)*x**S(19)/S(19) + b**S(6)*x**S(21)/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x**S(8)/S(8) + S(3)*a**S(5)*b*x**S(10)/S(5) + S(5)*a**S(4)*b**S(2)*x**S(12)/S(4) + S(10)*a**S(3)*b**S(3)*x**S(14)/S(7) + S(15)*a**S(2)*b**S(4)*x**S(16)/S(16) + a*b**S(5)*x**S(18)/S(3) + b**S(6)*x**S(20)/S(20), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x**S(7)/S(7) + S(2)*a**S(5)*b*x**S(9)/S(3) + S(15)*a**S(4)*b**S(2)*x**S(11)/S(11) + S(20)*a**S(3)*b**S(3)*x**S(13)/S(13) + a**S(2)*b**S(4)*x**S(15) + S(6)*a*b**S(5)*x**S(17)/S(17) + b**S(6)*x**S(19)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(2)*(a + b*x**S(2))**S(7)/(S(14)*b**S(3)) - a*(a + b*x**S(2))**S(8)/(S(8)*b**S(3)) + (a + b*x**S(2))**S(9)/(S(18)*b**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x**S(5)/S(5) + S(6)*a**S(5)*b*x**S(7)/S(7) + S(5)*a**S(4)*b**S(2)*x**S(9)/S(3) + S(20)*a**S(3)*b**S(3)*x**S(11)/S(11) + S(15)*a**S(2)*b**S(4)*x**S(13)/S(13) + S(2)*a*b**S(5)*x**S(15)/S(5) + b**S(6)*x**S(17)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -a*(a + b*x**S(2))**S(7)/(S(14)*b**S(2)) + (a + b*x**S(2))**S(8)/(S(16)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x**S(3)/S(3) + S(6)*a**S(5)*b*x**S(5)/S(5) + S(15)*a**S(4)*b**S(2)*x**S(7)/S(7) + S(20)*a**S(3)*b**S(3)*x**S(9)/S(9) + S(15)*a**S(2)*b**S(4)*x**S(11)/S(11) + S(6)*a*b**S(5)*x**S(13)/S(13) + b**S(6)*x**S(15)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, (a + b*x**S(2))**S(7)/(S(14)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(6)*x + S(2)*a**S(5)*b*x**S(3) + S(3)*a**S(4)*b**S(2)*x**S(5) + S(20)*a**S(3)*b**S(3)*x**S(7)/S(7) + S(5)*a**S(2)*b**S(4)*x**S(9)/S(3) + S(6)*a*b**S(5)*x**S(11)/S(11) + b**S(6)*x**S(13)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x, x), x, a**S(6)*log(x) + S(3)*a**S(5)*b*x**S(2) + S(15)*a**S(4)*b**S(2)*x**S(4)/S(4) + S(10)*a**S(3)*b**S(3)*x**S(6)/S(3) + S(15)*a**S(2)*b**S(4)*x**S(8)/S(8) + S(3)*a*b**S(5)*x**S(10)/S(5) + b**S(6)*x**S(12)/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(2), x), x, -a**S(6)/x + S(6)*a**S(5)*b*x + S(5)*a**S(4)*b**S(2)*x**S(3) + S(4)*a**S(3)*b**S(3)*x**S(5) + S(15)*a**S(2)*b**S(4)*x**S(7)/S(7) + S(2)*a*b**S(5)*x**S(9)/S(3) + b**S(6)*x**S(11)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(3), x), x, -a**S(6)/(S(2)*x**S(2)) + S(6)*a**S(5)*b*log(x) + S(15)*a**S(4)*b**S(2)*x**S(2)/S(2) + S(5)*a**S(3)*b**S(3)*x**S(4) + S(5)*a**S(2)*b**S(4)*x**S(6)/S(2) + S(3)*a*b**S(5)*x**S(8)/S(4) + b**S(6)*x**S(10)/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(4), x), x, -a**S(6)/(S(3)*x**S(3)) - S(6)*a**S(5)*b/x + S(15)*a**S(4)*b**S(2)*x + S(20)*a**S(3)*b**S(3)*x**S(3)/S(3) + S(3)*a**S(2)*b**S(4)*x**S(5) + S(6)*a*b**S(5)*x**S(7)/S(7) + b**S(6)*x**S(9)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(5), x), x, -a**S(6)/(S(4)*x**S(4)) - S(3)*a**S(5)*b/x**S(2) + S(15)*a**S(4)*b**S(2)*log(x) + S(10)*a**S(3)*b**S(3)*x**S(2) + S(15)*a**S(2)*b**S(4)*x**S(4)/S(4) + a*b**S(5)*x**S(6) + b**S(6)*x**S(8)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(6), x), x, -a**S(6)/(S(5)*x**S(5)) - S(2)*a**S(5)*b/x**S(3) - S(15)*a**S(4)*b**S(2)/x + S(20)*a**S(3)*b**S(3)*x + S(5)*a**S(2)*b**S(4)*x**S(3) + S(6)*a*b**S(5)*x**S(5)/S(5) + b**S(6)*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(7), x), x, -a**S(6)/(S(6)*x**S(6)) - S(3)*a**S(5)*b/(S(2)*x**S(4)) - S(15)*a**S(4)*b**S(2)/(S(2)*x**S(2)) + S(20)*a**S(3)*b**S(3)*log(x) + S(15)*a**S(2)*b**S(4)*x**S(2)/S(2) + S(3)*a*b**S(5)*x**S(4)/S(2) + b**S(6)*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(8), x), x, -a**S(6)/(S(7)*x**S(7)) - S(6)*a**S(5)*b/(S(5)*x**S(5)) - S(5)*a**S(4)*b**S(2)/x**S(3) - S(20)*a**S(3)*b**S(3)/x + S(15)*a**S(2)*b**S(4)*x + S(2)*a*b**S(5)*x**S(3) + b**S(6)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(9), x), x, -a**S(6)/(S(8)*x**S(8)) - a**S(5)*b/x**S(6) - S(15)*a**S(4)*b**S(2)/(S(4)*x**S(4)) - S(10)*a**S(3)*b**S(3)/x**S(2) + S(15)*a**S(2)*b**S(4)*log(x) + S(3)*a*b**S(5)*x**S(2) + b**S(6)*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(10), x), x, -a**S(6)/(S(9)*x**S(9)) - S(6)*a**S(5)*b/(S(7)*x**S(7)) - S(3)*a**S(4)*b**S(2)/x**S(5) - S(20)*a**S(3)*b**S(3)/(S(3)*x**S(3)) - S(15)*a**S(2)*b**S(4)/x + S(6)*a*b**S(5)*x + b**S(6)*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(11), x), x, -a**S(6)/(S(10)*x**S(10)) - S(3)*a**S(5)*b/(S(4)*x**S(8)) - S(5)*a**S(4)*b**S(2)/(S(2)*x**S(6)) - S(5)*a**S(3)*b**S(3)/x**S(4) - S(15)*a**S(2)*b**S(4)/(S(2)*x**S(2)) + S(6)*a*b**S(5)*log(x) + b**S(6)*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(12), x), x, -a**S(6)/(S(11)*x**S(11)) - S(2)*a**S(5)*b/(S(3)*x**S(9)) - S(15)*a**S(4)*b**S(2)/(S(7)*x**S(7)) - S(4)*a**S(3)*b**S(3)/x**S(5) - S(5)*a**S(2)*b**S(4)/x**S(3) - S(6)*a*b**S(5)/x + b**S(6)*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(13), x), x, -a**S(6)/(S(12)*x**S(12)) - S(3)*a**S(5)*b/(S(5)*x**S(10)) - S(15)*a**S(4)*b**S(2)/(S(8)*x**S(8)) - S(10)*a**S(3)*b**S(3)/(S(3)*x**S(6)) - S(15)*a**S(2)*b**S(4)/(S(4)*x**S(4)) - S(3)*a*b**S(5)/x**S(2) + b**S(6)*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(14), x), x, -a**S(6)/(S(13)*x**S(13)) - S(6)*a**S(5)*b/(S(11)*x**S(11)) - S(5)*a**S(4)*b**S(2)/(S(3)*x**S(9)) - S(20)*a**S(3)*b**S(3)/(S(7)*x**S(7)) - S(3)*a**S(2)*b**S(4)/x**S(5) - S(2)*a*b**S(5)/x**S(3) - b**S(6)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(15), x), x, -(a + b*x**S(2))**S(7)/(S(14)*a*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(16), x), x, -a**S(6)/(S(15)*x**S(15)) - S(6)*a**S(5)*b/(S(13)*x**S(13)) - S(15)*a**S(4)*b**S(2)/(S(11)*x**S(11)) - S(20)*a**S(3)*b**S(3)/(S(9)*x**S(9)) - S(15)*a**S(2)*b**S(4)/(S(7)*x**S(7)) - S(6)*a*b**S(5)/(S(5)*x**S(5)) - b**S(6)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(17), x), x, -(a + b*x**S(2))**S(7)/(S(16)*a*x**S(16)) + b*(a + b*x**S(2))**S(7)/(S(112)*a**S(2)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(18), x), x, -a**S(6)/(S(17)*x**S(17)) - S(2)*a**S(5)*b/(S(5)*x**S(15)) - S(15)*a**S(4)*b**S(2)/(S(13)*x**S(13)) - S(20)*a**S(3)*b**S(3)/(S(11)*x**S(11)) - S(5)*a**S(2)*b**S(4)/(S(3)*x**S(9)) - S(6)*a*b**S(5)/(S(7)*x**S(7)) - b**S(6)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(19), x), x, -(a + b*x**S(2))**S(7)/(S(18)*a*x**S(18)) + b*(a + b*x**S(2))**S(7)/(S(72)*a**S(2)*x**S(16)) - b**S(2)*(a + b*x**S(2))**S(7)/(S(504)*a**S(3)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(20), x), x, -a**S(6)/(S(19)*x**S(19)) - S(6)*a**S(5)*b/(S(17)*x**S(17)) - a**S(4)*b**S(2)/x**S(15) - S(20)*a**S(3)*b**S(3)/(S(13)*x**S(13)) - S(15)*a**S(2)*b**S(4)/(S(11)*x**S(11)) - S(2)*a*b**S(5)/(S(3)*x**S(9)) - b**S(6)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(21), x), x, -a**S(6)/(S(20)*x**S(20)) - a**S(5)*b/(S(3)*x**S(18)) - S(15)*a**S(4)*b**S(2)/(S(16)*x**S(16)) - S(10)*a**S(3)*b**S(3)/(S(7)*x**S(14)) - S(5)*a**S(2)*b**S(4)/(S(4)*x**S(12)) - S(3)*a*b**S(5)/(S(5)*x**S(10)) - b**S(6)/(S(8)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/x**S(22), x), x, -a**S(6)/(S(21)*x**S(21)) - S(6)*a**S(5)*b/(S(19)*x**S(19)) - S(15)*a**S(4)*b**S(2)/(S(17)*x**S(17)) - S(4)*a**S(3)*b**S(3)/(S(3)*x**S(15)) - S(15)*a**S(2)*b**S(4)/(S(13)*x**S(13)) - S(6)*a*b**S(5)/(S(11)*x**S(11)) - b**S(6)/(S(9)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (d*x)**(m + S(1))*hyper((S(2), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a**S(2)*d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(5)/(S(2)*b**S(6)*(a + b*x**S(2))) + S(5)*a**S(4)*log(a + b*x**S(2))/(S(2)*b**S(6)) - S(2)*a**S(3)*x**S(2)/b**S(5) + S(3)*a**S(2)*x**S(4)/(S(4)*b**S(4)) - a*x**S(6)/(S(3)*b**S(3)) + x**S(8)/(S(8)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -a**S(4)/(S(2)*b**S(5)*(a + b*x**S(2))) - S(2)*a**S(3)*log(a + b*x**S(2))/b**S(5) + S(3)*a**S(2)*x**S(2)/(S(2)*b**S(4)) - a*x**S(4)/(S(2)*b**S(3)) + x**S(6)/(S(6)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**S(3)/(S(2)*b**S(4)*(a + b*x**S(2))) + S(3)*a**S(2)*log(a + b*x**S(2))/(S(2)*b**S(4)) - a*x**S(2)/b**S(3) + x**S(4)/(S(4)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -a**S(2)/(S(2)*b**S(3)*(a + b*x**S(2))) - a*log(a + b*x**S(2))/b**S(3) + x**S(2)/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a/(S(2)*b**S(2)*(a + b*x**S(2))) + log(a + b*x**S(2))/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -S(1)/(S(2)*b*(a + b*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*(a + b*x**S(2))) + log(x)/a**S(2) - log(a + b*x**S(2))/(S(2)*a**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -b/(S(2)*a**S(2)*(a + b*x**S(2))) - S(1)/(S(2)*a**S(2)*x**S(2)) - S(2)*b*log(x)/a**S(3) + b*log(a + b*x**S(2))/a**S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -S(1)/(S(4)*a**S(2)*x**S(4)) + b**S(2)/(S(2)*a**S(3)*(a + b*x**S(2))) + b/(a**S(3)*x**S(2)) + S(3)*b**S(2)*log(x)/a**S(4) - S(3)*b**S(2)*log(a + b*x**S(2))/(S(2)*a**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(9)*a**(S(7)/2)*atan(sqrt(b)*x/sqrt(a))/(S(2)*b**(S(11)/2)) - S(9)*a**S(3)*x/(S(2)*b**S(5)) + S(3)*a**S(2)*x**S(3)/(S(2)*b**S(4)) - S(9)*a*x**S(5)/(S(10)*b**S(3)) - x**S(9)/(S(2)*b*(a + b*x**S(2))) + S(9)*x**S(7)/(S(14)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -S(7)*a**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(2)*b**(S(9)/2)) + S(7)*a**S(2)*x/(S(2)*b**S(4)) - S(7)*a*x**S(3)/(S(6)*b**S(3)) - x**S(7)/(S(2)*b*(a + b*x**S(2))) + S(7)*x**S(5)/(S(10)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(5)*a**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(2)*b**(S(7)/2)) - S(5)*a*x/(S(2)*b**S(3)) - x**S(5)/(S(2)*b*(a + b*x**S(2))) + S(5)*x**S(3)/(S(6)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -S(3)*sqrt(a)*atan(sqrt(b)*x/sqrt(a))/(S(2)*b**(S(5)/2)) - x**S(3)/(S(2)*b*(a + b*x**S(2))) + S(3)*x/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -x/(S(2)*b*(a + b*x**S(2))) + atan(sqrt(b)*x/sqrt(a))/(S(2)*sqrt(a)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, x/(S(2)*a*(a + b*x**S(2))) + atan(sqrt(b)*x/sqrt(a))/(S(2)*a**(S(3)/2)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*x*(a + b*x**S(2))) - S(3)/(S(2)*a**S(2)*x) - S(3)*sqrt(b)*atan(sqrt(b)*x/sqrt(a))/(S(2)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*x**S(3)*(a + b*x**S(2))) - S(5)/(S(6)*a**S(2)*x**S(3)) + S(5)*b/(S(2)*a**S(3)*x) + S(5)*b**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(2)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*x**S(5)*(a + b*x**S(2))) - S(7)/(S(10)*a**S(2)*x**S(5)) + S(7)*b/(S(6)*a**S(3)*x**S(3)) - S(7)*b**S(2)/(S(2)*a**S(4)*x) - S(7)*b**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(2)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, (d*x)**(m + S(1))*hyper((S(4), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a**S(4)*d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(5)/(S(6)*b**S(6)*(a + b*x**S(2))**S(3)) - S(5)*a**S(4)/(S(4)*b**S(6)*(a + b*x**S(2))**S(2)) + S(5)*a**S(3)/(b**S(6)*(a + b*x**S(2))) + S(5)*a**S(2)*log(a + b*x**S(2))/b**S(6) - S(2)*a*x**S(2)/b**S(5) + x**S(4)/(S(4)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -a**S(4)/(S(6)*b**S(5)*(a + b*x**S(2))**S(3)) + a**S(3)/(b**S(5)*(a + b*x**S(2))**S(2)) - S(3)*a**S(2)/(b**S(5)*(a + b*x**S(2))) - S(2)*a*log(a + b*x**S(2))/b**S(5) + x**S(2)/(S(2)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a**S(3)/(S(6)*b**S(4)*(a + b*x**S(2))**S(3)) - S(3)*a**S(2)/(S(4)*b**S(4)*(a + b*x**S(2))**S(2)) + S(3)*a/(S(2)*b**S(4)*(a + b*x**S(2))) + log(a + b*x**S(2))/(S(2)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, x**S(6)/(S(6)*a*(a + b*x**S(2))**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, a/(S(6)*b**S(2)*(a + b*x**S(2))**S(3)) - S(1)/(S(4)*b**S(2)*(a + b*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -S(1)/(S(6)*b*(a + b*x**S(2))**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*(a + b*x**S(2))**S(3)) + S(1)/(S(4)*a**S(2)*(a + b*x**S(2))**S(2)) + S(1)/(S(2)*a**S(3)*(a + b*x**S(2))) + log(x)/a**S(4) - log(a + b*x**S(2))/(S(2)*a**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, -b/(S(6)*a**S(2)*(a + b*x**S(2))**S(3)) - b/(S(2)*a**S(3)*(a + b*x**S(2))**S(2)) - S(3)*b/(S(2)*a**S(4)*(a + b*x**S(2))) - S(1)/(S(2)*a**S(4)*x**S(2)) - S(4)*b*log(x)/a**S(5) + S(2)*b*log(a + b*x**S(2))/a**S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, b**S(2)/(S(6)*a**S(3)*(a + b*x**S(2))**S(3)) + S(3)*b**S(2)/(S(4)*a**S(4)*(a + b*x**S(2))**S(2)) - S(1)/(S(4)*a**S(4)*x**S(4)) + S(3)*b**S(2)/(a**S(5)*(a + b*x**S(2))) + S(2)*b/(a**S(5)*x**S(2)) + S(10)*b**S(2)*log(x)/a**S(6) - S(5)*b**S(2)*log(a + b*x**S(2))/a**S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -S(231)*a**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(16)*b**(S(13)/2)) + S(231)*a**S(2)*x/(S(16)*b**S(6)) - S(77)*a*x**S(3)/(S(16)*b**S(5)) - x**S(11)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(11)*x**S(9)/(S(24)*b**S(2)*(a + b*x**S(2))**S(2)) - S(33)*x**S(7)/(S(16)*b**S(3)*(a + b*x**S(2))) + S(231)*x**S(5)/(S(80)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, S(105)*a**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(16)*b**(S(11)/2)) - S(105)*a*x/(S(16)*b**S(5)) - x**S(9)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(3)*x**S(7)/(S(8)*b**S(2)*(a + b*x**S(2))**S(2)) - S(21)*x**S(5)/(S(16)*b**S(3)*(a + b*x**S(2))) + S(35)*x**S(3)/(S(16)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -S(35)*sqrt(a)*atan(sqrt(b)*x/sqrt(a))/(S(16)*b**(S(9)/2)) - x**S(7)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(7)*x**S(5)/(S(24)*b**S(2)*(a + b*x**S(2))**S(2)) - S(35)*x**S(3)/(S(48)*b**S(3)*(a + b*x**S(2))) + S(35)*x/(S(16)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -x**S(5)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(5)*x**S(3)/(S(24)*b**S(2)*(a + b*x**S(2))**S(2)) - S(5)*x/(S(16)*b**S(3)*(a + b*x**S(2))) + S(5)*atan(sqrt(b)*x/sqrt(a))/(S(16)*sqrt(a)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -x**S(3)/(S(6)*b*(a + b*x**S(2))**S(3)) - x/(S(8)*b**S(2)*(a + b*x**S(2))**S(2)) + x/(S(16)*a*b**S(2)*(a + b*x**S(2))) + atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(3)/2)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -x/(S(6)*b*(a + b*x**S(2))**S(3)) + x/(S(24)*a*b*(a + b*x**S(2))**S(2)) + x/(S(16)*a**S(2)*b*(a + b*x**S(2))) + atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(5)/2)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(-2)), x), x, x/(S(6)*a*(a + b*x**S(2))**S(3)) + S(5)*x/(S(24)*a**S(2)*(a + b*x**S(2))**S(2)) + S(5)*x/(S(16)*a**S(3)*(a + b*x**S(2))) + S(5)*atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(7)/2)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*x*(a + b*x**S(2))**S(3)) + S(7)/(S(24)*a**S(2)*x*(a + b*x**S(2))**S(2)) + S(35)/(S(48)*a**S(3)*x*(a + b*x**S(2))) - S(35)/(S(16)*a**S(4)*x) - S(35)*sqrt(b)*atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*x**S(3)*(a + b*x**S(2))**S(3)) + S(3)/(S(8)*a**S(2)*x**S(3)*(a + b*x**S(2))**S(2)) + S(21)/(S(16)*a**S(3)*x**S(3)*(a + b*x**S(2))) - S(35)/(S(16)*a**S(4)*x**S(3)) + S(105)*b/(S(16)*a**S(5)*x) + S(105)*b**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*x**S(5)*(a + b*x**S(2))**S(3)) + S(11)/(S(24)*a**S(2)*x**S(5)*(a + b*x**S(2))**S(2)) + S(33)/(S(16)*a**S(3)*x**S(5)*(a + b*x**S(2))) - S(231)/(S(80)*a**S(4)*x**S(5)) + S(77)*b/(S(16)*a**S(5)*x**S(3)) - S(231)*b**S(2)/(S(16)*a**S(6)*x) - S(231)*b**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(16)*a**(S(13)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, (d*x)**(m + S(1))*hyper((S(6), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a**S(6)*d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(15)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(7)/(S(10)*b**S(8)*(a + b*x**S(2))**S(5)) - S(7)*a**S(6)/(S(8)*b**S(8)*(a + b*x**S(2))**S(4)) + S(7)*a**S(5)/(S(2)*b**S(8)*(a + b*x**S(2))**S(3)) - S(35)*a**S(4)/(S(4)*b**S(8)*(a + b*x**S(2))**S(2)) + S(35)*a**S(3)/(S(2)*b**S(8)*(a + b*x**S(2))) + S(21)*a**S(2)*log(a + b*x**S(2))/(S(2)*b**S(8)) - S(3)*a*x**S(2)/b**S(7) + x**S(4)/(S(4)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(13)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -a**S(6)/(S(10)*b**S(7)*(a + b*x**S(2))**S(5)) + S(3)*a**S(5)/(S(4)*b**S(7)*(a + b*x**S(2))**S(4)) - S(5)*a**S(4)/(S(2)*b**S(7)*(a + b*x**S(2))**S(3)) + S(5)*a**S(3)/(b**S(7)*(a + b*x**S(2))**S(2)) - S(15)*a**S(2)/(S(2)*b**S(7)*(a + b*x**S(2))) - S(3)*a*log(a + b*x**S(2))/b**S(7) + x**S(2)/(S(2)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a**S(5)/(S(10)*b**S(6)*(a + b*x**S(2))**S(5)) - S(5)*a**S(4)/(S(8)*b**S(6)*(a + b*x**S(2))**S(4)) + S(5)*a**S(3)/(S(3)*b**S(6)*(a + b*x**S(2))**S(3)) - S(5)*a**S(2)/(S(2)*b**S(6)*(a + b*x**S(2))**S(2)) + S(5)*a/(S(2)*b**S(6)*(a + b*x**S(2))) + log(a + b*x**S(2))/(S(2)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, x**S(10)/(S(10)*a*(a + b*x**S(2))**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, x**S(8)/(S(10)*a*(a + b*x**S(2))**S(5)) + x**S(8)/(S(40)*a**S(2)*(a + b*x**S(2))**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -a**S(2)/(S(10)*b**S(3)*(a + b*x**S(2))**S(5)) + a/(S(4)*b**S(3)*(a + b*x**S(2))**S(4)) - S(1)/(S(6)*b**S(3)*(a + b*x**S(2))**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, a/(S(10)*b**S(2)*(a + b*x**S(2))**S(5)) - S(1)/(S(8)*b**S(2)*(a + b*x**S(2))**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -S(1)/(S(10)*b*(a + b*x**S(2))**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*(a + b*x**S(2))**S(5)) + S(1)/(S(8)*a**S(2)*(a + b*x**S(2))**S(4)) + S(1)/(S(6)*a**S(3)*(a + b*x**S(2))**S(3)) + S(1)/(S(4)*a**S(4)*(a + b*x**S(2))**S(2)) + S(1)/(S(2)*a**S(5)*(a + b*x**S(2))) + log(x)/a**S(6) - log(a + b*x**S(2))/(S(2)*a**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, -b/(S(10)*a**S(2)*(a + b*x**S(2))**S(5)) - b/(S(4)*a**S(3)*(a + b*x**S(2))**S(4)) - b/(S(2)*a**S(4)*(a + b*x**S(2))**S(3)) - b/(a**S(5)*(a + b*x**S(2))**S(2)) - S(5)*b/(S(2)*a**S(6)*(a + b*x**S(2))) - S(1)/(S(2)*a**S(6)*x**S(2)) - S(6)*b*log(x)/a**S(7) + S(3)*b*log(a + b*x**S(2))/a**S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, b**S(2)/(S(10)*a**S(3)*(a + b*x**S(2))**S(5)) + S(3)*b**S(2)/(S(8)*a**S(4)*(a + b*x**S(2))**S(4)) + b**S(2)/(a**S(5)*(a + b*x**S(2))**S(3)) + S(5)*b**S(2)/(S(2)*a**S(6)*(a + b*x**S(2))**S(2)) - S(1)/(S(4)*a**S(6)*x**S(4)) + S(15)*b**S(2)/(S(2)*a**S(7)*(a + b*x**S(2))) + S(3)*b/(a**S(7)*x**S(2)) + S(21)*b**S(2)*log(x)/a**S(8) - S(21)*b**S(2)*log(a + b*x**S(2))/(S(2)*a**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(16)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -S(9009)*a**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(256)*b**(S(17)/2)) + S(9009)*a**S(2)*x/(S(256)*b**S(8)) - S(3003)*a*x**S(3)/(S(256)*b**S(7)) - x**S(15)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(3)*x**S(13)/(S(16)*b**S(2)*(a + b*x**S(2))**S(4)) - S(13)*x**S(11)/(S(32)*b**S(3)*(a + b*x**S(2))**S(3)) - S(143)*x**S(9)/(S(128)*b**S(4)*(a + b*x**S(2))**S(2)) - S(1287)*x**S(7)/(S(256)*b**S(5)*(a + b*x**S(2))) + S(9009)*x**S(5)/(S(1280)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(14)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, S(3003)*a**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(256)*b**(S(15)/2)) - S(3003)*a*x/(S(256)*b**S(7)) - x**S(13)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(13)*x**S(11)/(S(80)*b**S(2)*(a + b*x**S(2))**S(4)) - S(143)*x**S(9)/(S(480)*b**S(3)*(a + b*x**S(2))**S(3)) - S(429)*x**S(7)/(S(640)*b**S(4)*(a + b*x**S(2))**S(2)) - S(3003)*x**S(5)/(S(1280)*b**S(5)*(a + b*x**S(2))) + S(1001)*x**S(3)/(S(256)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -S(693)*sqrt(a)*atan(sqrt(b)*x/sqrt(a))/(S(256)*b**(S(13)/2)) - x**S(11)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(11)*x**S(9)/(S(80)*b**S(2)*(a + b*x**S(2))**S(4)) - S(33)*x**S(7)/(S(160)*b**S(3)*(a + b*x**S(2))**S(3)) - S(231)*x**S(5)/(S(640)*b**S(4)*(a + b*x**S(2))**S(2)) - S(231)*x**S(3)/(S(256)*b**S(5)*(a + b*x**S(2))) + S(693)*x/(S(256)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -x**S(9)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(9)*x**S(7)/(S(80)*b**S(2)*(a + b*x**S(2))**S(4)) - S(21)*x**S(5)/(S(160)*b**S(3)*(a + b*x**S(2))**S(3)) - S(21)*x**S(3)/(S(128)*b**S(4)*(a + b*x**S(2))**S(2)) - S(63)*x/(S(256)*b**S(5)*(a + b*x**S(2))) + S(63)*atan(sqrt(b)*x/sqrt(a))/(S(256)*sqrt(a)*b**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -x**S(7)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(7)*x**S(5)/(S(80)*b**S(2)*(a + b*x**S(2))**S(4)) - S(7)*x**S(3)/(S(96)*b**S(3)*(a + b*x**S(2))**S(3)) - S(7)*x/(S(128)*b**S(4)*(a + b*x**S(2))**S(2)) + S(7)*x/(S(256)*a*b**S(4)*(a + b*x**S(2))) + S(7)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(3)/2)*b**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -x**S(5)/(S(10)*b*(a + b*x**S(2))**S(5)) - x**S(3)/(S(16)*b**S(2)*(a + b*x**S(2))**S(4)) - x/(S(32)*b**S(3)*(a + b*x**S(2))**S(3)) + x/(S(128)*a*b**S(3)*(a + b*x**S(2))**S(2)) + S(3)*x/(S(256)*a**S(2)*b**S(3)*(a + b*x**S(2))) + S(3)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(5)/2)*b**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -x**S(3)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(3)*x/(S(80)*b**S(2)*(a + b*x**S(2))**S(4)) + x/(S(160)*a*b**S(2)*(a + b*x**S(2))**S(3)) + x/(S(128)*a**S(2)*b**S(2)*(a + b*x**S(2))**S(2)) + S(3)*x/(S(256)*a**S(3)*b**S(2)*(a + b*x**S(2))) + S(3)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(7)/2)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -x/(S(10)*b*(a + b*x**S(2))**S(5)) + x/(S(80)*a*b*(a + b*x**S(2))**S(4)) + S(7)*x/(S(480)*a**S(2)*b*(a + b*x**S(2))**S(3)) + S(7)*x/(S(384)*a**S(3)*b*(a + b*x**S(2))**S(2)) + S(7)*x/(S(256)*a**S(4)*b*(a + b*x**S(2))) + S(7)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(9)/2)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(-3)), x), x, x/(S(10)*a*(a + b*x**S(2))**S(5)) + S(9)*x/(S(80)*a**S(2)*(a + b*x**S(2))**S(4)) + S(21)*x/(S(160)*a**S(3)*(a + b*x**S(2))**S(3)) + S(21)*x/(S(128)*a**S(4)*(a + b*x**S(2))**S(2)) + S(63)*x/(S(256)*a**S(5)*(a + b*x**S(2))) + S(63)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(11)/2)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*x*(a + b*x**S(2))**S(5)) + S(11)/(S(80)*a**S(2)*x*(a + b*x**S(2))**S(4)) + S(33)/(S(160)*a**S(3)*x*(a + b*x**S(2))**S(3)) + S(231)/(S(640)*a**S(4)*x*(a + b*x**S(2))**S(2)) + S(231)/(S(256)*a**S(5)*x*(a + b*x**S(2))) - S(693)/(S(256)*a**S(6)*x) - S(693)*sqrt(b)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(13)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*x**S(3)*(a + b*x**S(2))**S(5)) + S(13)/(S(80)*a**S(2)*x**S(3)*(a + b*x**S(2))**S(4)) + S(143)/(S(480)*a**S(3)*x**S(3)*(a + b*x**S(2))**S(3)) + S(429)/(S(640)*a**S(4)*x**S(3)*(a + b*x**S(2))**S(2)) + S(3003)/(S(1280)*a**S(5)*x**S(3)*(a + b*x**S(2))) - S(1001)/(S(256)*a**S(6)*x**S(3)) + S(3003)*b/(S(256)*a**S(7)*x) + S(3003)*b**(S(3)/2)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(15)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*x**S(5)*(a + b*x**S(2))**S(5)) + S(3)/(S(16)*a**S(2)*x**S(5)*(a + b*x**S(2))**S(4)) + S(13)/(S(32)*a**S(3)*x**S(5)*(a + b*x**S(2))**S(3)) + S(143)/(S(128)*a**S(4)*x**S(5)*(a + b*x**S(2))**S(2)) + S(1287)/(S(256)*a**S(5)*x**S(5)*(a + b*x**S(2))) - S(9009)/(S(1280)*a**S(6)*x**S(5)) + S(3003)*b/(S(256)*a**S(7)*x**S(3)) - S(9009)*b**S(2)/(S(256)*a**S(8)*x) - S(9009)*b**(S(5)/2)*atan(sqrt(b)*x/sqrt(a))/(S(256)*a**(S(17)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, x/(S(2)*x**S(2) + S(2)) + atan(x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, -S(1)/(S(2)*x**S(2) + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, -x/(S(2)*x**S(2) + S(2)) + atan(x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, log(x**S(2) + S(1))/S(2) + S(1)/(S(2)*x**S(2) + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(4) - S(18)*x**S(2) + S(81)), x), x, S(1)/(-S(2)*x**S(2) + S(18)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(4) - S(8)*x**S(2) + S(16)), x), x, log(-x**S(2) + S(4))/S(2) + S(2)/(-x**S(2) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a*(d*x)**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*(a + b*x**S(2))*(m**S(2) + S(4)*m + S(3))) + (d*x)**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*(m + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a*x**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(24)*a + S(24)*b*x**S(2)) + x**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*a + S(35)*b*x**S(2)) + x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(12)*a + S(12)*b*x**S(2)) + x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*a + S(15)*b*x**S(2)) + x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*a + S(3)*b*x**S(2)) + x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x, x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(2), x), x, -S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(x*(a + b*x**S(2))) + sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(3), x), x, -a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*x**S(2)*(a + b*x**S(2))) + b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(4), x), x, S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*x**S(3)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(5), x), x, -(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*a*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(6), x), x, S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*x**S(5)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(7), x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(12)*x**S(6)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(8), x), x, S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*x**S(7)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(9), x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(24)*x**S(8)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(6)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(10), x), x, S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x**S(9)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(11), x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(40)*x**S(10)*(a + b*x**S(2))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(8)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a**S(3)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(560)*a + S(560)*b*x**S(2)) + a**S(2)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(112) + S(3)*a*x**S(10)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(112) + x**S(10)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(16)*a**S(3)*x**S(9)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(6435)*a + S(6435)*b*x**S(2)) + S(8)*a**S(2)*x**S(9)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(715) + S(2)*a*x**S(9)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(65) + x**S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a**S(3)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(280)*a + S(280)*b*x**S(2)) + a**S(2)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(70) + a*x**S(8)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(28) + x**S(8)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(14), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(16)*a**S(3)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3003)*a + S(3003)*b*x**S(2)) + S(8)*a**S(2)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(429) + S(6)*a*x**S(7)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(143) + x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a**S(2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(24)*b**S(3)) - a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(30)*b**S(3)) + x**S(4)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(12)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(16)*a**S(3)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1155)*a + S(1155)*b*x**S(2)) + S(8)*a**S(2)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(231) + S(2)*a*x**S(5)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(33) + x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, -a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*b**S(2)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(10)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(16)*a**S(3)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(315)*a + S(315)*b*x**S(2)) + S(8)*a**S(2)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(105) + S(2)*a*x**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(21) + x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, (a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(16)*a**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*a + S(35)*b*x**S(2)) + S(8)*a**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(35) + S(6)*a*x*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(35) + x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x, x), x, a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) + a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(4) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(2), x), x, -S(16)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x*(a + b*x**S(2))) + S(8)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(5)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(3), x), x, S(3)*a**S(2)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(3)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) - S(3)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(2)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(4), x), x, S(16)*a*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*a + S(3)*b*x**S(2)) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/x**S(3) + S(8)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(3) - S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(5), x), x, S(3)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(3)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(4)) + S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) - (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(6), x), x, -S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x*(a + b*x**S(2))) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x**S(5)) + S(8)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*x) - S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(7), x), x, -a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*x**S(2)*(a + b*x**S(2))) + a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(6)) + b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) - S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(12)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(8), x), x, S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*x**S(3)*(a + b*x**S(2))) + S(6)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*x**S(7)) - S(24)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*x**S(3)) - S(11)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(35)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(9), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*a*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(10), x), x, S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(315)*x**S(5)*(a + b*x**S(2))) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(21)*x**S(9)) - S(8)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x**S(5)) - S(13)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(63)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(11), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*a*x**S(10)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(40)*a**S(2)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(12), x), x, S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1155)*x**S(7)*(a + b*x**S(2))) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(33)*x**S(11)) - S(8)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(165)*x**S(7)) - S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(33)*x**S(11)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(13), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(12)*a*x**S(12)) + b*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(24)*a**S(2)*x**S(10)) - b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(120)*a**S(3)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(14), x), x, S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3003)*x**S(9)*(a + b*x**S(2))) + S(6)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(143)*x**S(13)) - S(24)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1001)*x**S(9)) - S(17)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(143)*x**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(15), x), x, a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(280)*x**S(10)*(a + b*x**S(2))) + a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(28)*x**S(14)) - b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(56)*x**S(10)) - S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(28)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(16), x), x, S(16)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(6435)*x**S(11)*(a + b*x**S(2))) + S(2)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(65)*x**S(15)) - S(8)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(585)*x**S(11)) - S(19)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(195)*x**S(15)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/x**S(17), x), x, a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(560)*x**S(12)*(a + b*x**S(2))) + S(3)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(112)*x**S(16)) - S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(280)*x**S(12)) - S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(56)*x**S(16)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(13)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a**S(5)*x**S(14)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(11088)*a + S(11088)*b*x**S(2)) + a**S(4)*x**S(14)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(1584) + a**S(3)*x**S(14)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(396) + a**S(2)*x**S(14)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(132) + S(5)*a*x**S(14)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(264) + x**S(14)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(24), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(13)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2028117)*a + S(2028117)*b*x**S(2)) + S(128)*a**S(4)*x**S(13)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(156009) + S(160)*a**S(3)*x**S(13)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(52003) + S(80)*a**S(2)*x**S(13)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(9177) + S(10)*a*x**S(13)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(483) + x**S(13)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(23), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a**S(5)*x**S(12)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5544)*a + S(5544)*b*x**S(2)) + a**S(4)*x**S(12)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(924) + a**S(3)*x**S(12)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(264) + a**S(2)*x**S(12)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(99) + a*x**S(12)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(44) + x**S(12)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(22), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(11)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(969969)*a + S(969969)*b*x**S(2)) + S(128)*a**S(4)*x**S(11)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(88179) + S(32)*a**S(3)*x**S(11)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(6783) + S(80)*a**S(2)*x**S(11)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(6783) + S(10)*a*x**S(11)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(399) + x**S(11)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a**S(4)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(360)*b**S(5)) - a**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(420)*b**S(5)) + a**S(2)*x**S(4)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(120)*b**S(3)) - a*x**S(6)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(45)*b**S(2)) + x**S(8)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(20)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(9)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(415701)*a + S(415701)*b*x**S(2)) + S(128)*a**S(4)*x**S(9)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(46189) + S(32)*a**S(3)*x**S(9)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(4199) + S(16)*a**S(2)*x**S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(969) + S(10)*a*x**S(9)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(323) + x**S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, -a**S(3)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(144)*b**S(4)) + a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(168)*b**S(4)) - a*x**S(4)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(48)*b**S(2)) + x**S(6)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(18)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(153153)*a + S(153153)*b*x**S(2)) + S(128)*a**S(4)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(21879) + S(32)*a**S(3)*x**S(7)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2431) + S(16)*a**S(2)*x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(663) + S(2)*a*x**S(7)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(51) + x**S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a**S(2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(48)*b**S(3)) - a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(56)*b**S(3)) + x**S(4)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(16)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(45045)*a + S(45045)*b*x**S(2)) + S(128)*a**S(4)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(9009) + S(32)*a**S(3)*x**S(5)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(1287) + S(16)*a**S(2)*x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(429) + S(2)*a*x**S(5)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(39) + x**S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, -a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(12)*b**S(2)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(14)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(9009)*a + S(9009)*b*x**S(2)) + S(128)*a**S(4)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(3003) + S(160)*a**S(3)*x**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(3003) + S(80)*a**S(2)*x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(1287) + S(10)*a*x**S(3)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(143) + x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, (a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(12)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(256)*a**S(5)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(693)*a + S(693)*b*x**S(2)) + S(128)*a**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(693) + S(32)*a**S(3)*x*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(231) + S(80)*a**S(2)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(693) + S(10)*a*x*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(99) + x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x, x), x, a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) + a**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(4) + a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(6) + a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(8) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(2), x), x, -S(256)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x*(a + b*x**S(2))) + S(128)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x) + S(32)*a**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x) + S(16)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(63)*x) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(63)*x) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(9)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(3), x), x, S(5)*a**S(4)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(5)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) + S(5)*a**S(2)*b*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(4) + S(5)*a*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(6) - S(5)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*x**S(2)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(8)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(4), x), x, S(256)*a**S(3)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(21)*a + S(21)*b*x**S(2)) + S(128)*a**S(2)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(21) + S(32)*a*b**S(2)*x*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(7) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(3)*x**S(3)) + S(80)*b**S(2)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(21) - S(11)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(5), x), x, S(10)*a**S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(5)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)) + S(5)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) + S(5)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(4)*x**S(4)) + S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/S(3) - S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(2)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(6), x), x, -S(256)*a**S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*x*(a + b*x**S(2))) + S(128)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*x) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*x) + S(2)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(3)*x**S(5)) + S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(15)*x) - S(13)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(15)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(7), x), x, S(10)*a**S(2)*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(5)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)) - S(5)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*x**S(2)) + S(5)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(12)*x**S(6)) + S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(6)*x**S(2)) - S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(12)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(8), x), x, S(256)*a*b**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(21)*a + S(21)*b*x**S(2)) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7)*x**S(3)) + S(2)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(7)*x**S(7)) + S(128)*b**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(21) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(3)*x**S(3)) - S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(9), x), x, S(5)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) + S(5)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(4)) + S(5)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(24)*x**S(8)) + S(5)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/S(2) - S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(3)*x**S(4)) - (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(3)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(10), x), x, -S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x**S(5)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(63)*x**S(9)) + S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(63)*x) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(21)*x**S(5)) - S(17)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(63)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(11), x), x, -a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*x**S(2)*(a + b*x**S(2))) + a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4)*x**S(6)) + a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(8)*x**S(10)) + b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))*log(x)/(a + b*x**S(2)) - S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(12)*x**S(6)) - S(9)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(40)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(12), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(693)*x**S(3)*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(231)*x**S(7)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(99)*x**S(11)) - S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(231)*x**S(3)) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(63)*x**S(7)) - S(19)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(99)*x**S(11)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(13), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(12)*a*x**S(12)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(14), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(9009)*x**S(5)*(a + b*x**S(2))) + S(160)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3003)*x**S(9)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(143)*x**S(13)) - S(640)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(9009)*x**S(5)) - S(80)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(693)*x**S(9)) - S(21)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(143)*x**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(15), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(12)*a*x**S(14)) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(84)*a**S(2)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(16), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(45045)*x**S(7)*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1287)*x**S(11)) + S(2)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(39)*x**S(15)) - S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(6435)*x**S(7)) - S(80)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(1287)*x**S(11)) - S(23)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(195)*x**S(15)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(17), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(16)*a*x**S(16)) + b*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(48)*a**S(2)*x**S(14)) - b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(336)*a**S(3)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(18), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(153153)*x**S(9)*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2431)*x**S(13)) + S(2)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(51)*x**S(17)) - S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(17017)*x**S(9)) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(429)*x**S(13)) - S(5)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(51)*x**S(17)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(19), x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(18)*a*x**S(18)) + b*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(48)*a**S(2)*x**S(16)) - b**S(2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(144)*a**S(3)*x**S(14)) + b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(7)/2)/(S(1008)*a**S(4)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(20), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(415701)*x**S(11)*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4199)*x**S(15)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(323)*x**S(19)) - S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(37791)*x**S(11)) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(663)*x**S(15)) - S(27)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(323)*x**S(19)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(21), x), x, a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2520)*x**S(12)*(a + b*x**S(2))) + a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(168)*x**S(16)) + a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(36)*x**S(20)) - b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(420)*x**S(12)) - S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(252)*x**S(16)) - S(7)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(90)*x**S(20)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(22), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(969969)*x**S(13)*(a + b*x**S(2))) + S(32)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(6783)*x**S(17)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(399)*x**S(21)) - S(128)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(74613)*x**S(13)) - S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(969)*x**S(17)) - S(29)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(399)*x**S(21)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(23), x), x, a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5544)*x**S(14)*(a + b*x**S(2))) + a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(264)*x**S(18)) + a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(44)*x**S(22)) - b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(792)*x**S(14)) - b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(72)*x**S(18)) - S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(44)*x**S(22)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(24), x), x, S(256)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2028117)*x**S(15)*(a + b*x**S(2))) + S(160)*a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(52003)*x**S(19)) + S(10)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(483)*x**S(23)) - S(640)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(676039)*x**S(15)) - S(80)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(6783)*x**S(19)) - S(31)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(483)*x**S(23)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/x**S(25), x), x, a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(11088)*x**S(16)*(a + b*x**S(2))) + a*b**S(2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(396)*x**S(20)) + S(5)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(264)*x**S(24)) - b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1386)*x**S(16)) - b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(99)*x**S(20)) - S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(33)*x**S(24)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (d*x)**(m + S(1))*(a + b*x**S(2))*hyper((S(1), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a*d*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, a**(S(3)/2)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(b**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - a*x*(a + b*x**S(2))/(b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + x**S(3)*(a + b*x**S(2))/(S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -a*(a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -sqrt(a)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(b**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + x*(a + b*x**S(2))/(b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(sqrt(a)*sqrt(b)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, (a + b*x**S(2))*log(x)/(a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -(a + b*x**S(2))/(a*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(b)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(a**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -b*(a + b*x**S(2))*log(x)/(a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + b*(a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*a**S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -(a + b*x**S(2))/(S(3)*a*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + b*(a + b*x**S(2))/(a**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + b**(S(3)/2)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(a**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, (d*x)**(m + S(1))*(a + b*x**S(2))*hyper((S(3), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a**S(3)*d*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a*x*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(5)*x/(S(8)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(3)*a + S(3)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(8)*sqrt(a)*b**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, x**S(4)*(a + b*x**S(2))/(S(4)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, x**S(3)*(a + b*x**S(2))/(S(4)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - x/(S(8)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(8)*a**(S(3)/2)*b**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, -(a + b*x**S(2))/(S(4)*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(-3)/2), x), x, x*(a + b*x**S(2))/(S(4)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(3)*x/(S(8)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(3)*a + S(3)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(8)*a**(S(5)/2)*sqrt(b)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(1)/(S(2)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (a + b*x**S(2))*log(x)/(a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)/(S(8)*a**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(15)*a + S(15)*b*x**S(2))/(S(8)*a**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(15)*sqrt(b)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(8)*a**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(3)/(S(4)*a**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*b*(a + b*x**S(2))*log(x)/(a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3)*b*(a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*a**S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(7)/(S(8)*a**S(2)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(35)*a + S(35)*b*x**S(2))/(S(24)*a**S(3)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*b*(a + b*x**S(2))/(S(8)*a**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*b**(S(3)/2)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(8)*a**(S(9)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, (d*x)**(m + S(1))*(a + b*x**S(2))*hyper((S(5), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a**S(5)*d*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*x**S(3)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(11)*x**S(3)/(S(48)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)*x**S(3)*(a + b*x**S(2))/(S(64)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(5)*x/(S(128)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(5)*a + S(5)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(3)/2)*b**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, x**S(6)*(a + b*x**S(2))/(S(8)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + x**S(6)/(S(24)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*x*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(3)*x/(S(16)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + x*(a + b*x**S(2))/(S(64)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(3)*x/(S(128)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(3)*a + S(3)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(5)/2)*b**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(1)/(S(6)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, x**S(3)*(a + b*x**S(2))/(S(8)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(5)*x/(S(48)*a*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)*x*(a + b*x**S(2))/(S(192)*a**S(2)*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)*x/(S(128)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(5)*a + S(5)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(7)/2)*b**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, -(a + b*x**S(2))/(S(8)*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(-5)/2), x), x, x*(a + b*x**S(2))/(S(8)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(7)*x/(S(48)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(35)*x*(a + b*x**S(2))/(S(192)*a**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(35)*x/(S(128)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (S(35)*a + S(35)*b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(9)/2)*sqrt(b)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(1)/(S(6)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (a + b*x**S(2))/(S(4)*a**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(1)/(S(2)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + (a + b*x**S(2))*log(x)/(a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(3)/(S(16)*a**S(2)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(21)*a + S(21)*b*x**S(2))/(S(64)*a**S(3)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(105)/(S(128)*a**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(315)*a + S(315)*b*x**S(2))/(S(128)*a**S(5)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(315)*sqrt(b)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(11)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(5)/(S(24)*a**S(2)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(5)*a + S(5)*b*x**S(2))/(S(12)*a**S(3)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)/(S(4)*a**S(4)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*b*(a + b*x**S(2))*log(x)/(a**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(5)*b*(a + b*x**S(2))*log(a + b*x**S(2))/(S(2)*a**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(2)*a**S(6)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(11)/(S(48)*a**S(2)*x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(33)*a + S(33)*b*x**S(2))/(S(64)*a**S(3)*x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(231)/(S(128)*a**S(4)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(385)*a + S(385)*b*x**S(2))/(S(128)*a**S(5)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(1155)*b*(a + b*x**S(2))/(S(128)*a**S(6)*x*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(1155)*b**(S(3)/2)*(a + b*x**S(2))*atan(sqrt(b)*x/sqrt(a))/(S(128)*a**(S(13)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a**S(2)*(d*x)**(S(7)/2)/(S(7)*d) + S(4)*a*b*(d*x)**(S(11)/2)/(S(11)*d**S(3)) + S(2)*b**S(2)*(d*x)**(S(15)/2)/(S(15)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a**S(2)*(d*x)**(S(5)/2)/(S(5)*d) + S(4)*a*b*(d*x)**(S(9)/2)/(S(9)*d**S(3)) + S(2)*b**S(2)*(d*x)**(S(13)/2)/(S(13)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(2)*a**S(2)*(d*x)**(S(3)/2)/(S(3)*d) + S(4)*a*b*(d*x)**(S(7)/2)/(S(7)*d**S(3)) + S(2)*b**S(2)*(d*x)**(S(11)/2)/(S(11)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/sqrt(d*x), x), x, S(2)*a**S(2)*sqrt(d*x)/d + S(4)*a*b*(d*x)**(S(5)/2)/(S(5)*d**S(3)) + S(2)*b**S(2)*(d*x)**(S(9)/2)/(S(9)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(3)/2), x), x, -S(2)*a**S(2)/(d*sqrt(d*x)) + S(4)*a*b*(d*x)**(S(3)/2)/(S(3)*d**S(3)) + S(2)*b**S(2)*(d*x)**(S(7)/2)/(S(7)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(5)/2), x), x, -S(2)*a**S(2)/(S(3)*d*(d*x)**(S(3)/2)) + S(4)*a*b*sqrt(d*x)/d**S(3) + S(2)*b**S(2)*(d*x)**(S(5)/2)/(S(5)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(7)/2), x), x, -S(2)*a**S(2)/(S(5)*d*(d*x)**(S(5)/2)) - S(4)*a*b/(d**S(3)*sqrt(d*x)) + S(2)*b**S(2)*(d*x)**(S(3)/2)/(S(3)*d**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, S(2)*a**S(4)*(d*x)**(S(7)/2)/(S(7)*d) + S(8)*a**S(3)*b*(d*x)**(S(11)/2)/(S(11)*d**S(3)) + S(4)*a**S(2)*b**S(2)*(d*x)**(S(15)/2)/(S(5)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(19)/2)/(S(19)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(23)/2)/(S(23)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, S(2)*a**S(4)*(d*x)**(S(5)/2)/(S(5)*d) + S(8)*a**S(3)*b*(d*x)**(S(9)/2)/(S(9)*d**S(3)) + S(12)*a**S(2)*b**S(2)*(d*x)**(S(13)/2)/(S(13)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(17)/2)/(S(17)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(21)/2)/(S(21)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, S(2)*a**S(4)*(d*x)**(S(3)/2)/(S(3)*d) + S(8)*a**S(3)*b*(d*x)**(S(7)/2)/(S(7)*d**S(3)) + S(12)*a**S(2)*b**S(2)*(d*x)**(S(11)/2)/(S(11)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(15)/2)/(S(15)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(19)/2)/(S(19)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/sqrt(d*x), x), x, S(2)*a**S(4)*sqrt(d*x)/d + S(8)*a**S(3)*b*(d*x)**(S(5)/2)/(S(5)*d**S(3)) + S(4)*a**S(2)*b**S(2)*(d*x)**(S(9)/2)/(S(3)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(13)/2)/(S(13)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(17)/2)/(S(17)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/(d*x)**(S(3)/2), x), x, -S(2)*a**S(4)/(d*sqrt(d*x)) + S(8)*a**S(3)*b*(d*x)**(S(3)/2)/(S(3)*d**S(3)) + S(12)*a**S(2)*b**S(2)*(d*x)**(S(7)/2)/(S(7)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(11)/2)/(S(11)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(15)/2)/(S(15)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/(d*x)**(S(5)/2), x), x, -S(2)*a**S(4)/(S(3)*d*(d*x)**(S(3)/2)) + S(8)*a**S(3)*b*sqrt(d*x)/d**S(3) + S(12)*a**S(2)*b**S(2)*(d*x)**(S(5)/2)/(S(5)*d**S(5)) + S(8)*a*b**S(3)*(d*x)**(S(9)/2)/(S(9)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(13)/2)/(S(13)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)/(d*x)**(S(7)/2), x), x, -S(2)*a**S(4)/(S(5)*d*(d*x)**(S(5)/2)) - S(8)*a**S(3)*b/(d**S(3)*sqrt(d*x)) + S(4)*a**S(2)*b**S(2)*(d*x)**(S(3)/2)/d**S(5) + S(8)*a*b**S(3)*(d*x)**(S(7)/2)/(S(7)*d**S(7)) + S(2)*b**S(4)*(d*x)**(S(11)/2)/(S(11)*d**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, S(2)*a**S(6)*(d*x)**(S(7)/2)/(S(7)*d) + S(12)*a**S(5)*b*(d*x)**(S(11)/2)/(S(11)*d**S(3)) + S(2)*a**S(4)*b**S(2)*(d*x)**(S(15)/2)/d**S(5) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(19)/2)/(S(19)*d**S(7)) + S(30)*a**S(2)*b**S(4)*(d*x)**(S(23)/2)/(S(23)*d**S(9)) + S(4)*a*b**S(5)*(d*x)**(S(27)/2)/(S(9)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(31)/2)/(S(31)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, S(2)*a**S(6)*(d*x)**(S(5)/2)/(S(5)*d) + S(4)*a**S(5)*b*(d*x)**(S(9)/2)/(S(3)*d**S(3)) + S(30)*a**S(4)*b**S(2)*(d*x)**(S(13)/2)/(S(13)*d**S(5)) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(17)/2)/(S(17)*d**S(7)) + S(10)*a**S(2)*b**S(4)*(d*x)**(S(21)/2)/(S(7)*d**S(9)) + S(12)*a*b**S(5)*(d*x)**(S(25)/2)/(S(25)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(29)/2)/(S(29)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, S(2)*a**S(6)*(d*x)**(S(3)/2)/(S(3)*d) + S(12)*a**S(5)*b*(d*x)**(S(7)/2)/(S(7)*d**S(3)) + S(30)*a**S(4)*b**S(2)*(d*x)**(S(11)/2)/(S(11)*d**S(5)) + S(8)*a**S(3)*b**S(3)*(d*x)**(S(15)/2)/(S(3)*d**S(7)) + S(30)*a**S(2)*b**S(4)*(d*x)**(S(19)/2)/(S(19)*d**S(9)) + S(12)*a*b**S(5)*(d*x)**(S(23)/2)/(S(23)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(27)/2)/(S(27)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/sqrt(d*x), x), x, S(2)*a**S(6)*sqrt(d*x)/d + S(12)*a**S(5)*b*(d*x)**(S(5)/2)/(S(5)*d**S(3)) + S(10)*a**S(4)*b**S(2)*(d*x)**(S(9)/2)/(S(3)*d**S(5)) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(13)/2)/(S(13)*d**S(7)) + S(30)*a**S(2)*b**S(4)*(d*x)**(S(17)/2)/(S(17)*d**S(9)) + S(4)*a*b**S(5)*(d*x)**(S(21)/2)/(S(7)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(25)/2)/(S(25)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/(d*x)**(S(3)/2), x), x, -S(2)*a**S(6)/(d*sqrt(d*x)) + S(4)*a**S(5)*b*(d*x)**(S(3)/2)/d**S(3) + S(30)*a**S(4)*b**S(2)*(d*x)**(S(7)/2)/(S(7)*d**S(5)) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(11)/2)/(S(11)*d**S(7)) + S(2)*a**S(2)*b**S(4)*(d*x)**(S(15)/2)/d**S(9) + S(12)*a*b**S(5)*(d*x)**(S(19)/2)/(S(19)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(23)/2)/(S(23)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/(d*x)**(S(5)/2), x), x, -S(2)*a**S(6)/(S(3)*d*(d*x)**(S(3)/2)) + S(12)*a**S(5)*b*sqrt(d*x)/d**S(3) + S(6)*a**S(4)*b**S(2)*(d*x)**(S(5)/2)/d**S(5) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(9)/2)/(S(9)*d**S(7)) + S(30)*a**S(2)*b**S(4)*(d*x)**(S(13)/2)/(S(13)*d**S(9)) + S(12)*a*b**S(5)*(d*x)**(S(17)/2)/(S(17)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(21)/2)/(S(21)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)/(d*x)**(S(7)/2), x), x, -S(2)*a**S(6)/(S(5)*d*(d*x)**(S(5)/2)) - S(12)*a**S(5)*b/(d**S(3)*sqrt(d*x)) + S(10)*a**S(4)*b**S(2)*(d*x)**(S(3)/2)/d**S(5) + S(40)*a**S(3)*b**S(3)*(d*x)**(S(7)/2)/(S(7)*d**S(7)) + S(30)*a**S(2)*b**S(4)*(d*x)**(S(11)/2)/(S(11)*d**S(9)) + S(4)*a*b**S(5)*(d*x)**(S(15)/2)/(S(5)*d**S(11)) + S(2)*b**S(6)*(d*x)**(S(19)/2)/(S(19)*d**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(11)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -S(9)*sqrt(S(2))*a**(S(5)/4)*d**(S(11)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(13)/4)) + S(9)*sqrt(S(2))*a**(S(5)/4)*d**(S(11)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(13)/4)) - S(9)*sqrt(S(2))*a**(S(5)/4)*d**(S(11)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(13)/4)) + S(9)*sqrt(S(2))*a**(S(5)/4)*d**(S(11)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(13)/4)) - S(9)*a*d**S(5)*sqrt(d*x)/(S(2)*b**S(3)) - d*(d*x)**(S(9)/2)/(S(2)*b*(a + b*x**S(2))) + S(9)*d**S(3)*(d*x)**(S(5)/2)/(S(10)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(9)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -S(7)*sqrt(S(2))*a**(S(3)/4)*d**(S(9)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(11)/4)) + S(7)*sqrt(S(2))*a**(S(3)/4)*d**(S(9)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(11)/4)) + S(7)*sqrt(S(2))*a**(S(3)/4)*d**(S(9)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(11)/4)) - S(7)*sqrt(S(2))*a**(S(3)/4)*d**(S(9)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(11)/4)) - d*(d*x)**(S(7)/2)/(S(2)*b*(a + b*x**S(2))) + S(7)*d**S(3)*(d*x)**(S(3)/2)/(S(6)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(5)*sqrt(S(2))*a**(S(1)/4)*d**(S(7)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(9)/4)) - S(5)*sqrt(S(2))*a**(S(1)/4)*d**(S(7)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*b**(S(9)/4)) + S(5)*sqrt(S(2))*a**(S(1)/4)*d**(S(7)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(9)/4)) - S(5)*sqrt(S(2))*a**(S(1)/4)*d**(S(7)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*b**(S(9)/4)) - d*(d*x)**(S(5)/2)/(S(2)*b*(a + b*x**S(2))) + S(5)*d**S(3)*sqrt(d*x)/(S(2)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -d*(d*x)**(S(3)/2)/(S(2)*b*(a + b*x**S(2))) + S(3)*sqrt(S(2))*d**(S(5)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(1)/4)*b**(S(7)/4)) - S(3)*sqrt(S(2))*d**(S(5)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(1)/4)*b**(S(7)/4)) - S(3)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(1)/4)*b**(S(7)/4)) + S(3)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(1)/4)*b**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -d*sqrt(d*x)/(S(2)*b*(a + b*x**S(2))) - sqrt(S(2))*d**(S(3)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(3)/4)*b**(S(5)/4)) + sqrt(S(2))*d**(S(3)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(3)/4)*b**(S(5)/4)) - sqrt(S(2))*d**(S(3)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(3)/4)*b**(S(5)/4)) + sqrt(S(2))*d**(S(3)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(3)/4)*b**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, (d*x)**(S(3)/2)/(S(2)*a*d*(a + b*x**S(2))) + sqrt(S(2))*sqrt(d)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(5)/4)*b**(S(3)/4)) - sqrt(S(2))*sqrt(d)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(5)/4)*b**(S(3)/4)) - sqrt(S(2))*sqrt(d)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(5)/4)*b**(S(3)/4)) + sqrt(S(2))*sqrt(d)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(5)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, sqrt(d*x)/(S(2)*a*d*(a + b*x**S(2))) - S(3)*sqrt(S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(7)/4)*b**(S(1)/4)*sqrt(d)) + S(3)*sqrt(S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(7)/4)*b**(S(1)/4)*sqrt(d)) - S(3)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(7)/4)*b**(S(1)/4)*sqrt(d)) + S(3)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(7)/4)*b**(S(1)/4)*sqrt(d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*d*sqrt(d*x)*(a + b*x**S(2))) - S(5)/(S(2)*a**S(2)*d*sqrt(d*x)) - S(5)*sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(9)/4)*d**(S(3)/2)) + S(5)*sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(9)/4)*d**(S(3)/2)) + S(5)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(9)/4)*d**(S(3)/2)) - S(5)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(9)/4)*d**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) - S(7)/(S(6)*a**S(2)*d*(d*x)**(S(3)/2)) + S(7)*sqrt(S(2))*b**(S(3)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(11)/4)*d**(S(5)/2)) - S(7)*sqrt(S(2))*b**(S(3)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(11)/4)*d**(S(5)/2)) + S(7)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(11)/4)*d**(S(5)/2)) - S(7)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(11)/4)*d**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, S(1)/(S(2)*a*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(9)/(S(10)*a**S(2)*d*(d*x)**(S(5)/2)) + S(9)*b/(S(2)*a**S(3)*d**S(3)*sqrt(d*x)) + S(9)*sqrt(S(2))*b**(S(5)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(13)/4)*d**(S(7)/2)) - S(9)*sqrt(S(2))*b**(S(5)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(16)*a**(S(13)/4)*d**(S(7)/2)) - S(9)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(13)/4)*d**(S(7)/2)) + S(9)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(8)*a**(S(13)/4)*d**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(19)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -S(663)*sqrt(S(2))*a**(S(5)/4)*d**(S(19)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(21)/4)) + S(663)*sqrt(S(2))*a**(S(5)/4)*d**(S(19)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(21)/4)) - S(663)*sqrt(S(2))*a**(S(5)/4)*d**(S(19)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(21)/4)) + S(663)*sqrt(S(2))*a**(S(5)/4)*d**(S(19)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(21)/4)) - S(663)*a*d**S(9)*sqrt(d*x)/(S(64)*b**S(5)) - d*(d*x)**(S(17)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(17)*d**S(3)*(d*x)**(S(13)/2)/(S(48)*b**S(2)*(a + b*x**S(2))**S(2)) - S(221)*d**S(5)*(d*x)**(S(9)/2)/(S(192)*b**S(3)*(a + b*x**S(2))) + S(663)*d**S(7)*(d*x)**(S(5)/2)/(S(320)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(17)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -S(385)*sqrt(S(2))*a**(S(3)/4)*d**(S(17)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(19)/4)) + S(385)*sqrt(S(2))*a**(S(3)/4)*d**(S(17)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(19)/4)) + S(385)*sqrt(S(2))*a**(S(3)/4)*d**(S(17)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(19)/4)) - S(385)*sqrt(S(2))*a**(S(3)/4)*d**(S(17)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(19)/4)) - d*(d*x)**(S(15)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(5)*d**S(3)*(d*x)**(S(11)/2)/(S(16)*b**S(2)*(a + b*x**S(2))**S(2)) - S(55)*d**S(5)*(d*x)**(S(7)/2)/(S(64)*b**S(3)*(a + b*x**S(2))) + S(385)*d**S(7)*(d*x)**(S(3)/2)/(S(192)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(15)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, S(195)*sqrt(S(2))*a**(S(1)/4)*d**(S(15)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(17)/4)) - S(195)*sqrt(S(2))*a**(S(1)/4)*d**(S(15)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*b**(S(17)/4)) + S(195)*sqrt(S(2))*a**(S(1)/4)*d**(S(15)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(17)/4)) - S(195)*sqrt(S(2))*a**(S(1)/4)*d**(S(15)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*b**(S(17)/4)) - d*(d*x)**(S(13)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(13)*d**S(3)*(d*x)**(S(9)/2)/(S(48)*b**S(2)*(a + b*x**S(2))**S(2)) - S(39)*d**S(5)*(d*x)**(S(5)/2)/(S(64)*b**S(3)*(a + b*x**S(2))) + S(195)*d**S(7)*sqrt(d*x)/(S(64)*b**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(13)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*(d*x)**(S(11)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(11)*d**S(3)*(d*x)**(S(7)/2)/(S(48)*b**S(2)*(a + b*x**S(2))**S(2)) - S(77)*d**S(5)*(d*x)**(S(3)/2)/(S(192)*b**S(3)*(a + b*x**S(2))) + S(77)*sqrt(S(2))*d**(S(13)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(1)/4)*b**(S(15)/4)) - S(77)*sqrt(S(2))*d**(S(13)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(1)/4)*b**(S(15)/4)) - S(77)*sqrt(S(2))*d**(S(13)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(1)/4)*b**(S(15)/4)) + S(77)*sqrt(S(2))*d**(S(13)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(1)/4)*b**(S(15)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(11)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*(d*x)**(S(9)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(3)*d**S(3)*(d*x)**(S(5)/2)/(S(16)*b**S(2)*(a + b*x**S(2))**S(2)) - S(15)*d**S(5)*sqrt(d*x)/(S(64)*b**S(3)*(a + b*x**S(2))) - S(15)*sqrt(S(2))*d**(S(11)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(3)/4)*b**(S(13)/4)) + S(15)*sqrt(S(2))*d**(S(11)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(3)/4)*b**(S(13)/4)) - S(15)*sqrt(S(2))*d**(S(11)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(3)/4)*b**(S(13)/4)) + S(15)*sqrt(S(2))*d**(S(11)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(3)/4)*b**(S(13)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(9)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*(d*x)**(S(7)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(7)*d**S(3)*(d*x)**(S(3)/2)/(S(48)*b**S(2)*(a + b*x**S(2))**S(2)) + S(7)*d**S(3)*(d*x)**(S(3)/2)/(S(64)*a*b**S(2)*(a + b*x**S(2))) + S(7)*sqrt(S(2))*d**(S(9)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(5)/4)*b**(S(11)/4)) - S(7)*sqrt(S(2))*d**(S(9)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(5)/4)*b**(S(11)/4)) - S(7)*sqrt(S(2))*d**(S(9)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(5)/4)*b**(S(11)/4)) + S(7)*sqrt(S(2))*d**(S(9)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(5)/4)*b**(S(11)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*(d*x)**(S(5)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) - S(5)*d**S(3)*sqrt(d*x)/(S(48)*b**S(2)*(a + b*x**S(2))**S(2)) + S(5)*d**S(3)*sqrt(d*x)/(S(192)*a*b**S(2)*(a + b*x**S(2))) - S(5)*sqrt(S(2))*d**(S(7)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(7)/4)*b**(S(9)/4)) + S(5)*sqrt(S(2))*d**(S(7)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(7)/4)*b**(S(9)/4)) - S(5)*sqrt(S(2))*d**(S(7)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(7)/4)*b**(S(9)/4)) + S(5)*sqrt(S(2))*d**(S(7)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(7)/4)*b**(S(9)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*(d*x)**(S(3)/2)/(S(6)*b*(a + b*x**S(2))**S(3)) + d*(d*x)**(S(3)/2)/(S(16)*a*b*(a + b*x**S(2))**S(2)) + S(5)*d*(d*x)**(S(3)/2)/(S(64)*a**S(2)*b*(a + b*x**S(2))) + S(5)*sqrt(S(2))*d**(S(5)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(9)/4)*b**(S(7)/4)) - S(5)*sqrt(S(2))*d**(S(5)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(9)/4)*b**(S(7)/4)) - S(5)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(9)/4)*b**(S(7)/4)) + S(5)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(9)/4)*b**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, -d*sqrt(d*x)/(S(6)*b*(a + b*x**S(2))**S(3)) + d*sqrt(d*x)/(S(48)*a*b*(a + b*x**S(2))**S(2)) + S(7)*d*sqrt(d*x)/(S(192)*a**S(2)*b*(a + b*x**S(2))) - S(7)*sqrt(S(2))*d**(S(3)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(11)/4)*b**(S(5)/4)) + S(7)*sqrt(S(2))*d**(S(3)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(11)/4)*b**(S(5)/4)) - S(7)*sqrt(S(2))*d**(S(3)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(11)/4)*b**(S(5)/4)) + S(7)*sqrt(S(2))*d**(S(3)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(11)/4)*b**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2), x), x, (d*x)**(S(3)/2)/(S(6)*a*d*(a + b*x**S(2))**S(3)) + S(3)*(d*x)**(S(3)/2)/(S(16)*a**S(2)*d*(a + b*x**S(2))**S(2)) + S(15)*(d*x)**(S(3)/2)/(S(64)*a**S(3)*d*(a + b*x**S(2))) + S(15)*sqrt(S(2))*sqrt(d)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(13)/4)*b**(S(3)/4)) - S(15)*sqrt(S(2))*sqrt(d)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(13)/4)*b**(S(3)/4)) - S(15)*sqrt(S(2))*sqrt(d)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(13)/4)*b**(S(3)/4)) + S(15)*sqrt(S(2))*sqrt(d)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(13)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, sqrt(d*x)/(S(6)*a*d*(a + b*x**S(2))**S(3)) + S(11)*sqrt(d*x)/(S(48)*a**S(2)*d*(a + b*x**S(2))**S(2)) + S(77)*sqrt(d*x)/(S(192)*a**S(3)*d*(a + b*x**S(2))) - S(77)*sqrt(S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(15)/4)*b**(S(1)/4)*sqrt(d)) + S(77)*sqrt(S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(15)/4)*b**(S(1)/4)*sqrt(d)) - S(77)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(15)/4)*b**(S(1)/4)*sqrt(d)) + S(77)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(15)/4)*b**(S(1)/4)*sqrt(d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*d*sqrt(d*x)*(a + b*x**S(2))**S(3)) + S(13)/(S(48)*a**S(2)*d*sqrt(d*x)*(a + b*x**S(2))**S(2)) + S(39)/(S(64)*a**S(3)*d*sqrt(d*x)*(a + b*x**S(2))) - S(195)/(S(64)*a**S(4)*d*sqrt(d*x)) - S(195)*sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(17)/4)*d**(S(3)/2)) + S(195)*sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(17)/4)*d**(S(3)/2)) + S(195)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(17)/4)*d**(S(3)/2)) - S(195)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(17)/4)*d**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(3)) + S(5)/(S(16)*a**S(2)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(2)) + S(55)/(S(64)*a**S(3)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) - S(385)/(S(192)*a**S(4)*d*(d*x)**(S(3)/2)) + S(385)*sqrt(S(2))*b**(S(3)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(19)/4)*d**(S(5)/2)) - S(385)*sqrt(S(2))*b**(S(3)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(19)/4)*d**(S(5)/2)) + S(385)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(19)/4)*d**(S(5)/2)) - S(385)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(19)/4)*d**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(2)), x), x, S(1)/(S(6)*a*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(3)) + S(17)/(S(48)*a**S(2)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(2)) + S(221)/(S(192)*a**S(3)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(663)/(S(320)*a**S(4)*d*(d*x)**(S(5)/2)) + S(663)*b/(S(64)*a**S(5)*d**S(3)*sqrt(d*x)) + S(663)*sqrt(S(2))*b**(S(5)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(21)/4)*d**(S(7)/2)) - S(663)*sqrt(S(2))*b**(S(5)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(512)*a**(S(21)/4)*d**(S(7)/2)) - S(663)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(21)/4)*d**(S(7)/2)) + S(663)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(256)*a**(S(21)/4)*d**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(27)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -S(69615)*sqrt(S(2))*a**(S(5)/4)*d**(S(27)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(29)/4)) + S(69615)*sqrt(S(2))*a**(S(5)/4)*d**(S(27)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(29)/4)) - S(69615)*sqrt(S(2))*a**(S(5)/4)*d**(S(27)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(29)/4)) + S(69615)*sqrt(S(2))*a**(S(5)/4)*d**(S(27)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(29)/4)) - S(69615)*a*d**S(13)*sqrt(d*x)/(S(4096)*b**S(7)) - d*(d*x)**(S(25)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(5)*d**S(3)*(d*x)**(S(21)/2)/(S(32)*b**S(2)*(a + b*x**S(2))**S(4)) - S(35)*d**S(5)*(d*x)**(S(17)/2)/(S(128)*b**S(3)*(a + b*x**S(2))**S(3)) - S(595)*d**S(7)*(d*x)**(S(13)/2)/(S(1024)*b**S(4)*(a + b*x**S(2))**S(2)) - S(7735)*d**S(9)*(d*x)**(S(9)/2)/(S(4096)*b**S(5)*(a + b*x**S(2))) + S(13923)*d**S(11)*(d*x)**(S(5)/2)/(S(4096)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(25)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -S(33649)*sqrt(S(2))*a**(S(3)/4)*d**(S(25)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(27)/4)) + S(33649)*sqrt(S(2))*a**(S(3)/4)*d**(S(25)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(27)/4)) + S(33649)*sqrt(S(2))*a**(S(3)/4)*d**(S(25)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(27)/4)) - S(33649)*sqrt(S(2))*a**(S(3)/4)*d**(S(25)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(27)/4)) - d*(d*x)**(S(23)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(23)*d**S(3)*(d*x)**(S(19)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(437)*d**S(5)*(d*x)**(S(15)/2)/(S(1920)*b**S(3)*(a + b*x**S(2))**S(3)) - S(437)*d**S(7)*(d*x)**(S(11)/2)/(S(1024)*b**S(4)*(a + b*x**S(2))**S(2)) - S(4807)*d**S(9)*(d*x)**(S(7)/2)/(S(4096)*b**S(5)*(a + b*x**S(2))) + S(33649)*d**S(11)*(d*x)**(S(3)/2)/(S(12288)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(23)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, S(13923)*sqrt(S(2))*a**(S(1)/4)*d**(S(23)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(25)/4)) - S(13923)*sqrt(S(2))*a**(S(1)/4)*d**(S(23)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*b**(S(25)/4)) + S(13923)*sqrt(S(2))*a**(S(1)/4)*d**(S(23)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(25)/4)) - S(13923)*sqrt(S(2))*a**(S(1)/4)*d**(S(23)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*b**(S(25)/4)) - d*(d*x)**(S(21)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(21)*d**S(3)*(d*x)**(S(17)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(119)*d**S(5)*(d*x)**(S(13)/2)/(S(640)*b**S(3)*(a + b*x**S(2))**S(3)) - S(1547)*d**S(7)*(d*x)**(S(9)/2)/(S(5120)*b**S(4)*(a + b*x**S(2))**S(2)) - S(13923)*d**S(9)*(d*x)**(S(5)/2)/(S(20480)*b**S(5)*(a + b*x**S(2))) + S(13923)*d**S(11)*sqrt(d*x)/(S(4096)*b**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(21)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(19)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(19)*d**S(3)*(d*x)**(S(15)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(19)*d**S(5)*(d*x)**(S(11)/2)/(S(128)*b**S(3)*(a + b*x**S(2))**S(3)) - S(209)*d**S(7)*(d*x)**(S(7)/2)/(S(1024)*b**S(4)*(a + b*x**S(2))**S(2)) - S(1463)*d**S(9)*(d*x)**(S(3)/2)/(S(4096)*b**S(5)*(a + b*x**S(2))) + S(4389)*sqrt(S(2))*d**(S(21)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(1)/4)*b**(S(23)/4)) - S(4389)*sqrt(S(2))*d**(S(21)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(1)/4)*b**(S(23)/4)) - S(4389)*sqrt(S(2))*d**(S(21)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(1)/4)*b**(S(23)/4)) + S(4389)*sqrt(S(2))*d**(S(21)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(1)/4)*b**(S(23)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(19)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(17)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(17)*d**S(3)*(d*x)**(S(13)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(221)*d**S(5)*(d*x)**(S(9)/2)/(S(1920)*b**S(3)*(a + b*x**S(2))**S(3)) - S(663)*d**S(7)*(d*x)**(S(5)/2)/(S(5120)*b**S(4)*(a + b*x**S(2))**S(2)) - S(663)*d**S(9)*sqrt(d*x)/(S(4096)*b**S(5)*(a + b*x**S(2))) - S(663)*sqrt(S(2))*d**(S(19)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(3)/4)*b**(S(21)/4)) + S(663)*sqrt(S(2))*d**(S(19)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(3)/4)*b**(S(21)/4)) - S(663)*sqrt(S(2))*d**(S(19)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(3)/4)*b**(S(21)/4)) + S(663)*sqrt(S(2))*d**(S(19)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(3)/4)*b**(S(21)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(17)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(15)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(3)*d**S(3)*(d*x)**(S(11)/2)/(S(32)*b**S(2)*(a + b*x**S(2))**S(4)) - S(11)*d**S(5)*(d*x)**(S(7)/2)/(S(128)*b**S(3)*(a + b*x**S(2))**S(3)) - S(77)*d**S(7)*(d*x)**(S(3)/2)/(S(1024)*b**S(4)*(a + b*x**S(2))**S(2)) + S(231)*d**S(7)*(d*x)**(S(3)/2)/(S(4096)*a*b**S(4)*(a + b*x**S(2))) + S(231)*sqrt(S(2))*d**(S(17)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(5)/4)*b**(S(19)/4)) - S(231)*sqrt(S(2))*d**(S(17)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(5)/4)*b**(S(19)/4)) - S(231)*sqrt(S(2))*d**(S(17)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(5)/4)*b**(S(19)/4)) + S(231)*sqrt(S(2))*d**(S(17)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(5)/4)*b**(S(19)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(15)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(13)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(13)*d**S(3)*(d*x)**(S(9)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(39)*d**S(5)*(d*x)**(S(5)/2)/(S(640)*b**S(3)*(a + b*x**S(2))**S(3)) - S(39)*d**S(7)*sqrt(d*x)/(S(1024)*b**S(4)*(a + b*x**S(2))**S(2)) + S(39)*d**S(7)*sqrt(d*x)/(S(4096)*a*b**S(4)*(a + b*x**S(2))) - S(117)*sqrt(S(2))*d**(S(15)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(7)/4)*b**(S(17)/4)) + S(117)*sqrt(S(2))*d**(S(15)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(7)/4)*b**(S(17)/4)) - S(117)*sqrt(S(2))*d**(S(15)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(7)/4)*b**(S(17)/4)) + S(117)*sqrt(S(2))*d**(S(15)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(7)/4)*b**(S(17)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(13)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(11)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(11)*d**S(3)*(d*x)**(S(7)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(77)*d**S(5)*(d*x)**(S(3)/2)/(S(1920)*b**S(3)*(a + b*x**S(2))**S(3)) + S(77)*d**S(5)*(d*x)**(S(3)/2)/(S(5120)*a*b**S(3)*(a + b*x**S(2))**S(2)) + S(77)*d**S(5)*(d*x)**(S(3)/2)/(S(4096)*a**S(2)*b**S(3)*(a + b*x**S(2))) + S(77)*sqrt(S(2))*d**(S(13)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(9)/4)*b**(S(15)/4)) - S(77)*sqrt(S(2))*d**(S(13)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(9)/4)*b**(S(15)/4)) - S(77)*sqrt(S(2))*d**(S(13)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(9)/4)*b**(S(15)/4)) + S(77)*sqrt(S(2))*d**(S(13)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(9)/4)*b**(S(15)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(11)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(9)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(9)*d**S(3)*(d*x)**(S(5)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) - S(3)*d**S(5)*sqrt(d*x)/(S(128)*b**S(3)*(a + b*x**S(2))**S(3)) + S(3)*d**S(5)*sqrt(d*x)/(S(1024)*a*b**S(3)*(a + b*x**S(2))**S(2)) + S(21)*d**S(5)*sqrt(d*x)/(S(4096)*a**S(2)*b**S(3)*(a + b*x**S(2))) - S(63)*sqrt(S(2))*d**(S(11)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(11)/4)*b**(S(13)/4)) + S(63)*sqrt(S(2))*d**(S(11)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(11)/4)*b**(S(13)/4)) - S(63)*sqrt(S(2))*d**(S(11)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(11)/4)*b**(S(13)/4)) + S(63)*sqrt(S(2))*d**(S(11)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(11)/4)*b**(S(13)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(9)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(7)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - S(7)*d**S(3)*(d*x)**(S(3)/2)/(S(160)*b**S(2)*(a + b*x**S(2))**S(4)) + S(7)*d**S(3)*(d*x)**(S(3)/2)/(S(640)*a*b**S(2)*(a + b*x**S(2))**S(3)) + S(63)*d**S(3)*(d*x)**(S(3)/2)/(S(5120)*a**S(2)*b**S(2)*(a + b*x**S(2))**S(2)) + S(63)*d**S(3)*(d*x)**(S(3)/2)/(S(4096)*a**S(3)*b**S(2)*(a + b*x**S(2))) + S(63)*sqrt(S(2))*d**(S(9)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(13)/4)*b**(S(11)/4)) - S(63)*sqrt(S(2))*d**(S(9)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(13)/4)*b**(S(11)/4)) - S(63)*sqrt(S(2))*d**(S(9)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(13)/4)*b**(S(11)/4)) + S(63)*sqrt(S(2))*d**(S(9)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(13)/4)*b**(S(11)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(5)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) - d**S(3)*sqrt(d*x)/(S(32)*b**S(2)*(a + b*x**S(2))**S(4)) + d**S(3)*sqrt(d*x)/(S(384)*a*b**S(2)*(a + b*x**S(2))**S(3)) + S(11)*d**S(3)*sqrt(d*x)/(S(3072)*a**S(2)*b**S(2)*(a + b*x**S(2))**S(2)) + S(77)*d**S(3)*sqrt(d*x)/(S(12288)*a**S(3)*b**S(2)*(a + b*x**S(2))) - S(77)*sqrt(S(2))*d**(S(7)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(15)/4)*b**(S(9)/4)) + S(77)*sqrt(S(2))*d**(S(7)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(15)/4)*b**(S(9)/4)) - S(77)*sqrt(S(2))*d**(S(7)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(15)/4)*b**(S(9)/4)) + S(77)*sqrt(S(2))*d**(S(7)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(15)/4)*b**(S(9)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*(d*x)**(S(3)/2)/(S(10)*b*(a + b*x**S(2))**S(5)) + S(3)*d*(d*x)**(S(3)/2)/(S(160)*a*b*(a + b*x**S(2))**S(4)) + S(13)*d*(d*x)**(S(3)/2)/(S(640)*a**S(2)*b*(a + b*x**S(2))**S(3)) + S(117)*d*(d*x)**(S(3)/2)/(S(5120)*a**S(3)*b*(a + b*x**S(2))**S(2)) + S(117)*d*(d*x)**(S(3)/2)/(S(4096)*a**S(4)*b*(a + b*x**S(2))) + S(117)*sqrt(S(2))*d**(S(5)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(17)/4)*b**(S(7)/4)) - S(117)*sqrt(S(2))*d**(S(5)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(17)/4)*b**(S(7)/4)) - S(117)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(17)/4)*b**(S(7)/4)) + S(117)*sqrt(S(2))*d**(S(5)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(17)/4)*b**(S(7)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, -d*sqrt(d*x)/(S(10)*b*(a + b*x**S(2))**S(5)) + d*sqrt(d*x)/(S(160)*a*b*(a + b*x**S(2))**S(4)) + d*sqrt(d*x)/(S(128)*a**S(2)*b*(a + b*x**S(2))**S(3)) + S(11)*d*sqrt(d*x)/(S(1024)*a**S(3)*b*(a + b*x**S(2))**S(2)) + S(77)*d*sqrt(d*x)/(S(4096)*a**S(4)*b*(a + b*x**S(2))) - S(231)*sqrt(S(2))*d**(S(3)/2)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(19)/4)*b**(S(5)/4)) + S(231)*sqrt(S(2))*d**(S(3)/2)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(19)/4)*b**(S(5)/4)) - S(231)*sqrt(S(2))*d**(S(3)/2)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(19)/4)*b**(S(5)/4)) + S(231)*sqrt(S(2))*d**(S(3)/2)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(19)/4)*b**(S(5)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3), x), x, (d*x)**(S(3)/2)/(S(10)*a*d*(a + b*x**S(2))**S(5)) + S(17)*(d*x)**(S(3)/2)/(S(160)*a**S(2)*d*(a + b*x**S(2))**S(4)) + S(221)*(d*x)**(S(3)/2)/(S(1920)*a**S(3)*d*(a + b*x**S(2))**S(3)) + S(663)*(d*x)**(S(3)/2)/(S(5120)*a**S(4)*d*(a + b*x**S(2))**S(2)) + S(663)*(d*x)**(S(3)/2)/(S(4096)*a**S(5)*d*(a + b*x**S(2))) + S(663)*sqrt(S(2))*sqrt(d)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(21)/4)*b**(S(3)/4)) - S(663)*sqrt(S(2))*sqrt(d)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(21)/4)*b**(S(3)/4)) - S(663)*sqrt(S(2))*sqrt(d)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(21)/4)*b**(S(3)/4)) + S(663)*sqrt(S(2))*sqrt(d)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(21)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, sqrt(d*x)/(S(10)*a*d*(a + b*x**S(2))**S(5)) + S(19)*sqrt(d*x)/(S(160)*a**S(2)*d*(a + b*x**S(2))**S(4)) + S(19)*sqrt(d*x)/(S(128)*a**S(3)*d*(a + b*x**S(2))**S(3)) + S(209)*sqrt(d*x)/(S(1024)*a**S(4)*d*(a + b*x**S(2))**S(2)) + S(1463)*sqrt(d*x)/(S(4096)*a**S(5)*d*(a + b*x**S(2))) - S(4389)*sqrt(S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(23)/4)*b**(S(1)/4)*sqrt(d)) + S(4389)*sqrt(S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(23)/4)*b**(S(1)/4)*sqrt(d)) - S(4389)*sqrt(S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(23)/4)*b**(S(1)/4)*sqrt(d)) + S(4389)*sqrt(S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(23)/4)*b**(S(1)/4)*sqrt(d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*d*sqrt(d*x)*(a + b*x**S(2))**S(5)) + S(21)/(S(160)*a**S(2)*d*sqrt(d*x)*(a + b*x**S(2))**S(4)) + S(119)/(S(640)*a**S(3)*d*sqrt(d*x)*(a + b*x**S(2))**S(3)) + S(1547)/(S(5120)*a**S(4)*d*sqrt(d*x)*(a + b*x**S(2))**S(2)) + S(13923)/(S(20480)*a**S(5)*d*sqrt(d*x)*(a + b*x**S(2))) - S(13923)/(S(4096)*a**S(6)*d*sqrt(d*x)) - S(13923)*sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(25)/4)*d**(S(3)/2)) + S(13923)*sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(25)/4)*d**(S(3)/2)) + S(13923)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(25)/4)*d**(S(3)/2)) - S(13923)*sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(25)/4)*d**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(5)) + S(23)/(S(160)*a**S(2)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(4)) + S(437)/(S(1920)*a**S(3)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(3)) + S(437)/(S(1024)*a**S(4)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))**S(2)) + S(4807)/(S(4096)*a**S(5)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) - S(33649)/(S(12288)*a**S(6)*d*(d*x)**(S(3)/2)) + S(33649)*sqrt(S(2))*b**(S(3)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(27)/4)*d**(S(5)/2)) - S(33649)*sqrt(S(2))*b**(S(3)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(27)/4)*d**(S(5)/2)) + S(33649)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(27)/4)*d**(S(5)/2)) - S(33649)*sqrt(S(2))*b**(S(3)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(27)/4)*d**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**S(3)), x), x, S(1)/(S(10)*a*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(5)) + S(5)/(S(32)*a**S(2)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(4)) + S(35)/(S(128)*a**S(3)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(3)) + S(595)/(S(1024)*a**S(4)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))**S(2)) + S(7735)/(S(4096)*a**S(5)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(13923)/(S(4096)*a**S(6)*d*(d*x)**(S(5)/2)) + S(69615)*b/(S(4096)*a**S(7)*d**S(3)*sqrt(d*x)) + S(69615)*sqrt(S(2))*b**(S(5)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(29)/4)*d**(S(7)/2)) - S(69615)*sqrt(S(2))*b**(S(5)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(32768)*a**(S(29)/4)*d**(S(7)/2)) - S(69615)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(29)/4)*d**(S(7)/2)) + S(69615)*sqrt(S(2))*b**(S(5)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(16384)*a**(S(29)/4)*d**(S(7)/2)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(8)*a*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(77)*d*(a + b*x**S(2))) + S(2)*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(11)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(8)*a*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(45)*d*(a + b*x**S(2))) + S(2)*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(9)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, S(8)*a*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(21)*d*(a + b*x**S(2))) + S(2)*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/sqrt(d*x), x), x, S(8)*a*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*d*(a + b*x**S(2))) + S(2)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(3)/2), x), x, -S(8)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*d*sqrt(d*x)*(a + b*x**S(2))) + S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*d*sqrt(d*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(5)/2), x), x, -S(8)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) + S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*(d*x)**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*x)**(S(7)/2), x), x, S(8)*a*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(5)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(d*(d*x)**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(256)*a**S(3)*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7315)*d*(a + b*x**S(2))) + S(64)*a**S(2)*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1045)*d) + S(8)*a*(d*x)**(S(7)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(95)*d) + S(2)*(d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(19)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(256)*a**S(3)*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(3315)*d*(a + b*x**S(2))) + S(64)*a**S(2)*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(663)*d) + S(24)*a*(d*x)**(S(5)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(221)*d) + S(2)*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(17)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(256)*a**S(3)*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1155)*d*(a + b*x**S(2))) + S(64)*a**S(2)*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(385)*d) + S(8)*a*(d*x)**(S(3)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(55)*d) + S(2)*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(15)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/sqrt(d*x), x), x, S(256)*a**S(3)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(195)*d*(a + b*x**S(2))) + S(64)*a**S(2)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(195)*d) + S(8)*a*sqrt(d*x)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(39)*d) + S(2)*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(13)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(d*x)**(S(3)/2), x), x, -S(256)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(77)*d*sqrt(d*x)*(a + b*x**S(2))) + S(64)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(77)*d*sqrt(d*x)) + S(24)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(77)*d*sqrt(d*x)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(11)*d*sqrt(d*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(d*x)**(S(5)/2), x), x, -S(256)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(45)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) + S(64)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*d*(d*x)**(S(3)/2)) + S(8)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(15)*d*(d*x)**(S(3)/2)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(9)*d*(d*x)**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(d*x)**(S(7)/2), x), x, S(256)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(35)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(64)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7)*d*(d*x)**(S(5)/2)) + S(8)*a*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7)*d*(d*x)**(S(5)/2)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(7)*d*(d*x)**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(16384)*a**S(5)*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(908523)*d*(a + b*x**S(2))) + S(4096)*a**S(4)*(d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(129789)*d) + S(512)*a**S(3)*(d*x)**(S(7)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(11799)*d) + S(640)*a**S(2)*(d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(11799)*d) + S(40)*a*(d*x)**(S(7)/2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(621)*d) + S(2)*(d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(27)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(16384)*a**S(5)*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(348075)*d*(a + b*x**S(2))) + S(4096)*a**S(4)*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(69615)*d) + S(512)*a**S(3)*(d*x)**(S(5)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(7735)*d) + S(128)*a**S(2)*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(1785)*d) + S(8)*a*(d*x)**(S(5)/2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(105)*d) + S(2)*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(25)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(16384)*a**S(5)*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(100947)*d*(a + b*x**S(2))) + S(4096)*a**S(4)*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(33649)*d) + S(512)*a**S(3)*(d*x)**(S(3)/2)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4807)*d) + S(128)*a**S(2)*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(1311)*d) + S(40)*a*(d*x)**(S(3)/2)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(437)*d) + S(2)*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(23)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/sqrt(d*x), x), x, S(16384)*a**S(5)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(13923)*d*(a + b*x**S(2))) + S(4096)*a**S(4)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(13923)*d) + S(2560)*a**S(3)*sqrt(d*x)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(13923)*d) + S(640)*a**S(2)*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(4641)*d) + S(40)*a*sqrt(d*x)*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(357)*d) + S(2)*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(21)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(d*x)**(S(3)/2), x), x, -S(16384)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4389)*d*sqrt(d*x)*(a + b*x**S(2))) + S(4096)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(4389)*d*sqrt(d*x)) + S(512)*a**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1463)*d*sqrt(d*x)) + S(128)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(627)*d*sqrt(d*x)) + S(8)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(57)*d*sqrt(d*x)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(19)*d*sqrt(d*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(d*x)**(S(5)/2), x), x, -S(16384)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1989)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))) + S(4096)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(663)*d*(d*x)**(S(3)/2)) + S(512)*a**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(663)*d*(d*x)**(S(3)/2)) + S(640)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(1989)*d*(d*x)**(S(3)/2)) + S(40)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(221)*d*(d*x)**(S(3)/2)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(17)*d*(d*x)**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(d*x)**(S(7)/2), x), x, S(16384)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(1155)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))) - S(4096)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(231)*d*(d*x)**(S(5)/2)) + S(512)*a**S(3)*(a + b*x**S(2))*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))/(S(231)*d*(d*x)**(S(5)/2)) + S(128)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(231)*d*(d*x)**(S(5)/2)) + S(8)*a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)/(S(33)*d*(d*x)**(S(5)/2)) + S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)/(S(15)*d*(d*x)**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -sqrt(S(2))*a**(S(5)/4)*d**(S(7)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*a**(S(5)/4)*d**(S(7)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*a**(S(5)/4)*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*a**(S(5)/4)*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(2)*a*d**S(3)*sqrt(d*x)*(a + b*x**S(2))/(b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(2)*d*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(5)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, -sqrt(S(2))*a**(S(3)/4)*d**(S(5)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*a**(S(3)/4)*d**(S(5)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*a**(S(3)/4)*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*a**(S(3)/4)*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(2)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, sqrt(S(2))*a**(S(1)/4)*d**(S(3)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*a**(S(1)/4)*d**(S(3)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*a**(S(1)/4)*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*a**(S(1)/4)*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(2)*d*sqrt(d*x)*(a + b*x**S(2))/(b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4)), x), x, sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(1)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(1)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(1)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(1)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, -sqrt(S(2))*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(3)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(3)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(3)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(3)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, (-S(2)*a - S(2)*b*x**S(2))/(a*d*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(5)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(5)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(5)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(5)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, (-S(2)*a - S(2)*b*x**S(2))/(S(3)*a*d*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(7)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(7)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(7)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(7)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), x), x, (-S(2)*a - S(2)*b*x**S(2))/(S(5)*a*d*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(2)*b*(a + b*x**S(2))/(a**S(2)*d**S(3)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(9)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(4)*a**(S(9)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(9)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(2)*a**(S(9)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(15)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, -S(117)*sqrt(S(2))*a**(S(5)/4)*d**(S(15)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*sqrt(S(2))*a**(S(5)/4)*d**(S(15)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(117)*sqrt(S(2))*a**(S(5)/4)*d**(S(15)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*sqrt(S(2))*a**(S(5)/4)*d**(S(15)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(9)/2)*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(117)*a*d**S(7)*sqrt(d*x)*(a + b*x**S(2))/(S(16)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(17)*d**S(3)*(d*x)**(S(9)/2)/(S(16)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*d**S(5)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(80)*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(13)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, -S(77)*sqrt(S(2))*a**(S(3)/4)*d**(S(13)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*a**(S(3)/4)*d**(S(13)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*a**(S(3)/4)*d**(S(13)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*a**(S(3)/4)*d**(S(13)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(7)/2)*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(15)*d**S(3)*(d*x)**(S(7)/2)/(S(16)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*d**S(5)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(48)*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(11)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, S(45)*sqrt(S(2))*a**(S(1)/4)*d**(S(11)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*a**(S(1)/4)*d**(S(11)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*a**(S(1)/4)*d**(S(11)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*a**(S(1)/4)*d**(S(11)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(13)*d**S(3)*(d*x)**(S(5)/2)/(S(16)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*d**S(5)*sqrt(d*x)*(a + b*x**S(2))/(S(16)*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(9)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a*d**S(3)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(11)*d**S(3)*(d*x)**(S(3)/2)/(S(16)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(21)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(1)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(21)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(1)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(21)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(1)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(21)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(1)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, a*d**S(3)*sqrt(d*x)*(a + b*x**S(2))/(S(4)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(9)*d**S(3)*sqrt(d*x)/(S(16)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(3)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(5)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(3)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(3)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(5)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(3)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, (d*x)**(S(7)/2)*(a + b*x**S(2))/(S(4)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - d*(d*x)**(S(3)/2)/(S(16)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(5)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(5)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(5)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(5)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, (d*x)**(S(5)/2)*(a + b*x**S(2))/(S(4)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(3)*d*sqrt(d*x)/(S(16)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(7)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(7)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(7)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(7)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2), x), x, (d*x)**(S(3)/2)*(a + b*x**S(2))/(S(4)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)*(d*x)**(S(3)/2)/(S(16)*a**S(2)*d*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(5)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(9)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(9)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(5)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(9)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(5)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(9)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, sqrt(d*x)*(a + b*x**S(2))/(S(4)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(7)*sqrt(d*x)/(S(16)*a**S(2)*d*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*(S(21)*a + S(21)*b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(11)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(S(21)*a + S(21)*b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(11)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*(S(21)*a + S(21)*b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(11)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(S(21)*a + S(21)*b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(11)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*d*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(9)/(S(16)*a**S(2)*d*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(45)*a + S(45)*b*x**S(2))/(S(16)*a**S(3)*d*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(13)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(13)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(13)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(13)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*d*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(11)/(S(16)*a**S(2)*d*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(77)*a + S(77)*b*x**S(2))/(S(48)*a**S(3)*d*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(15)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(15)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(15)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(15)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)), x), x, (a + b*x**S(2))/(S(4)*a*d*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(13)/(S(16)*a**S(2)*d*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(117)*a + S(117)*b*x**S(2))/(S(80)*a**S(3)*d*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*b*(a + b*x**S(2))/(S(16)*a**S(4)*d**S(3)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(17)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(117)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(128)*a**(S(17)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(117)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(17)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(117)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(64)*a**(S(17)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(23)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, -S(13923)*sqrt(S(2))*a**(S(5)/4)*d**(S(23)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(25)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*sqrt(S(2))*a**(S(5)/4)*d**(S(23)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(25)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(13923)*sqrt(S(2))*a**(S(5)/4)*d**(S(23)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(25)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*sqrt(S(2))*a**(S(5)/4)*d**(S(23)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(25)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(17)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(119)*a*d**S(7)*(d*x)**(S(9)/2)*(a + b*x**S(2))/(S(256)*b**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(13923)*a*d**S(11)*sqrt(d*x)*(a + b*x**S(2))/(S(1024)*b**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(11)*d**S(3)*(d*x)**(S(17)/2)/(S(32)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(2023)*d**S(7)*(d*x)**(S(9)/2)/(S(1024)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*d**S(9)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(5120)*b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(21)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, -S(7315)*sqrt(S(2))*a**(S(3)/4)*d**(S(21)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(23)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(7315)*sqrt(S(2))*a**(S(3)/4)*d**(S(21)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(23)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(7315)*sqrt(S(2))*a**(S(3)/4)*d**(S(21)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(23)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(7315)*sqrt(S(2))*a**(S(3)/4)*d**(S(21)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(23)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(15)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(95)*a*d**S(7)*(d*x)**(S(7)/2)*(a + b*x**S(2))/(S(256)*b**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(31)*d**S(3)*(d*x)**(S(15)/2)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(1425)*d**S(7)*(d*x)**(S(7)/2)/(S(1024)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(7315)*d**S(9)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(3072)*b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(19)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, S(3315)*sqrt(S(2))*a**(S(1)/4)*d**(S(19)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(21)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3315)*sqrt(S(2))*a**(S(1)/4)*d**(S(19)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*b**(S(21)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3315)*sqrt(S(2))*a**(S(1)/4)*d**(S(19)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(21)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3315)*sqrt(S(2))*a**(S(1)/4)*d**(S(19)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*b**(S(21)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + a*d**S(3)*(d*x)**(S(13)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(221)*a*d**S(7)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(768)*b**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(29)*d**S(3)*(d*x)**(S(13)/2)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(2873)*d**S(7)*(d*x)**(S(5)/2)/(S(3072)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3315)*d**S(9)*sqrt(d*x)*(a + b*x**S(2))/(S(1024)*b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(17)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*(d*x)**(S(11)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(55)*a*d**S(7)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(256)*b**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(9)*d**S(3)*(d*x)**(S(11)/2)/(S(32)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(605)*d**S(7)*(d*x)**(S(3)/2)/(S(1024)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(1155)*sqrt(S(2))*d**(S(17)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(1)/4)*b**(S(19)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(1155)*sqrt(S(2))*d**(S(17)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(1)/4)*b**(S(19)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(1155)*sqrt(S(2))*d**(S(17)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(1)/4)*b**(S(19)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(1155)*sqrt(S(2))*d**(S(17)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(1)/4)*b**(S(19)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(15)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*(d*x)**(S(9)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(39)*a*d**S(7)*sqrt(d*x)*(a + b*x**S(2))/(S(256)*b**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(25)*d**S(3)*(d*x)**(S(9)/2)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(351)*d**S(7)*sqrt(d*x)/(S(1024)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(195)*sqrt(S(2))*d**(S(15)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(3)/4)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(195)*sqrt(S(2))*d**(S(15)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(3)/4)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(195)*sqrt(S(2))*d**(S(15)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(3)/4)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(195)*sqrt(S(2))*d**(S(15)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(3)/4)*b**(S(17)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(13)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*(d*x)**(S(7)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(23)*d**S(3)*(d*x)**(S(7)/2)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(77)*d**S(3)*(d*x)**(S(7)/2)*(a + b*x**S(2))/(S(768)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(77)*d**S(5)*(d*x)**(S(3)/2)/(S(3072)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*d**(S(13)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(5)/4)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*d**(S(13)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(5)/4)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*d**(S(13)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(5)/4)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*d**(S(13)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(5)/4)*b**(S(15)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(11)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(7)*d**S(3)*(d*x)**(S(5)/2)/(S(32)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(15)*d**S(3)*(d*x)**(S(5)/2)*(a + b*x**S(2))/(S(256)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) - S(45)*d**S(5)*sqrt(d*x)/(S(1024)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*d**(S(11)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(7)/4)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*d**(S(11)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(7)/4)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*d**(S(11)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(7)/4)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*d**(S(11)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(7)/4)*b**(S(13)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(9)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(19)*d**S(3)*(d*x)**(S(3)/2)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(7)*d**S(3)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(256)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(35)*d**S(3)*(d*x)**(S(3)/2)/(S(1024)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(9)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(35)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(9)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(35)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(9)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*sqrt(S(2))*d**(S(9)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(9)/4)*b**(S(11)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(7)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, a*d**S(3)*sqrt(d*x)*(a + b*x**S(2))/(S(8)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(17)*d**S(3)*sqrt(d*x)/(S(96)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(5)*d**S(3)*sqrt(d*x)*(a + b*x**S(2))/(S(768)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(35)*d**S(3)*sqrt(d*x)/(S(3072)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(35)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(11)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(11)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(35)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(11)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(35)*sqrt(S(2))*d**(S(7)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(11)/4)*b**(S(9)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(5)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, (d*x)**(S(7)/2)*(a + b*x**S(2))/(S(8)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(3)*d*(d*x)**(S(3)/2)/(S(32)*a*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(9)*d*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(256)*a**S(2)*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(45)*d*(d*x)**(S(3)/2)/(S(1024)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(13)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(13)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(45)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(13)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(45)*sqrt(S(2))*d**(S(5)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(13)/4)*b**(S(7)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, (d*x)**(S(5)/2)*(a + b*x**S(2))/(S(8)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) - S(11)*d*sqrt(d*x)/(S(96)*a*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(11)*d*sqrt(d*x)*(a + b*x**S(2))/(S(768)*a**S(2)*b*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(77)*d*sqrt(d*x)/(S(3072)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(15)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(15)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(77)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(15)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(77)*sqrt(S(2))*d**(S(3)/2)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(15)/4)*b**(S(5)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2), x), x, (d*x)**(S(3)/2)*(a + b*x**S(2))/(S(8)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(13)*(d*x)**(S(3)/2)/(S(96)*a**S(2)*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(39)*(d*x)**(S(3)/2)*(a + b*x**S(2))/(S(256)*a**S(3)*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(195)*(d*x)**(S(3)/2)/(S(1024)*a**S(4)*d*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(195)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(17)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(195)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(17)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(195)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(17)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(195)*sqrt(S(2))*sqrt(d)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(17)/4)*b**(S(3)/4)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, sqrt(d*x)*(a + b*x**S(2))/(S(8)*a*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(5)*sqrt(d*x)/(S(32)*a**S(2)*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(55)*sqrt(d*x)*(a + b*x**S(2))/(S(256)*a**S(3)*d*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(385)*sqrt(d*x)/(S(1024)*a**S(4)*d*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*(S(1155)*a + S(1155)*b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(19)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(S(1155)*a + S(1155)*b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(19)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - sqrt(S(2))*(S(1155)*a + S(1155)*b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(19)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + sqrt(S(2))*(S(1155)*a + S(1155)*b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(19)/4)*b**(S(1)/4)*sqrt(d)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*d*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(17)/(S(96)*a**S(2)*d*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(221)*a + S(221)*b*x**S(2))/(S(768)*a**S(3)*d*sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(663)/(S(1024)*a**S(4)*d*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(3315)*a + S(3315)*b*x**S(2))/(S(1024)*a**S(5)*d*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3315)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(21)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3315)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(21)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(3315)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(21)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(3315)*sqrt(S(2))*b**(S(1)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(21)/4)*d**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*d*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(19)/(S(96)*a**S(2)*d*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(95)*a + S(95)*b*x**S(2))/(S(256)*a**S(3)*d*(d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(1045)/(S(1024)*a**S(4)*d*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(7315)*a + S(7315)*b*x**S(2))/(S(3072)*a**S(5)*d*(d*x)**(S(3)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(7315)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(23)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(7315)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(23)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(7315)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(23)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(7315)*sqrt(S(2))*b**(S(3)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(23)/4)*d**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(7)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)), x), x, (a + b*x**S(2))/(S(8)*a*d*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(5)/2)) + S(7)/(S(32)*a**S(2)*d*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + (S(119)*a + S(119)*b*x**S(2))/(S(256)*a**S(3)*d*(d*x)**(S(5)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(3)/2)) + S(1547)/(S(1024)*a**S(4)*d*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - (S(13923)*a + S(13923)*b*x**S(2))/(S(5120)*a**S(5)*d*(d*x)**(S(5)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*b*(a + b*x**S(2))/(S(1024)*a**S(6)*d**S(3)*sqrt(d*x)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(25)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(13923)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*sqrt(d*x) + sqrt(a)*sqrt(d) + sqrt(b)*sqrt(d)*x)/(S(8192)*a**(S(25)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) - S(13923)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(25)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))) + S(13923)*sqrt(S(2))*b**(S(5)/4)*(a + b*x**S(2))*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*sqrt(d*x)/(a**(S(1)/4)*sqrt(d)))/(S(4096)*a**(S(25)/4)*d**(S(7)/2)*sqrt(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(4)/3)), x), x, S(3)/(S(10)*a*x*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(1)/3)) + S(39)/(S(40)*a**S(2)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(1)/3)) - (S(91)*a + S(91)*b*x**S(2))/(S(40)*a**S(3)*x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(1)/3)) + S(91)*S(3)**(S(3)/4)*sqrt((a**(S(2)/3)*b**(S(2)/3) + a**(S(1)/3)*b**(S(1)/3)*(a*b + b**S(2)*x**S(2))**(S(1)/3) + (a*b + b**S(2)*x**S(2))**(S(2)/3))/(a**(S(1)/3)*b**(S(1)/3)*(-sqrt(S(3)) + S(1)) - (a*b + b**S(2)*x**S(2))**(S(1)/3))**S(2))*sqrt(-sqrt(S(3)) + S(2))*(a**(S(1)/3)*b**(S(1)/3) - (a*b + b**S(2)*x**S(2))**(S(1)/3))*(a*b + b**S(2)*x**S(2))**(S(2)/3)*elliptic_f(asin((a**(S(1)/3)*b**(S(1)/3)*(S(1) + sqrt(S(3))) - (a*b + b**S(2)*x**S(2))**(S(1)/3))/(a**(S(1)/3)*b**(S(1)/3)*(-sqrt(S(3)) + S(1)) - (a*b + b**S(2)*x**S(2))**(S(1)/3))), S(-7) + S(4)*sqrt(S(3)))/(S(120)*a**S(3)*b*x*sqrt(-a**(S(1)/3)*b**(S(1)/3)*(a**(S(1)/3)*b**(S(1)/3) - (a*b + b**S(2)*x**S(2))**(S(1)/3))/(a**(S(1)/3)*b**(S(1)/3)*(-sqrt(S(3)) + S(1)) - (a*b + b**S(2)*x**S(2))**(S(1)/3))**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, (d*x)**(m + S(1))*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(1), m/S(2) + S(2)*p + S(3)/2), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(a*d*(m + S(1))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, (d*x)**(m + S(1))*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((m/S(2) + S(1)/2, -S(2)*p), (m/S(2) + S(3)/2,), -b*x**S(2)/a)/(d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, -a*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/(S(2)*b**S(2)*(S(2)*p + S(1))) + (a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**(p + S(1))/(S(4)*b**S(2)*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, (a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/(S(2)*b*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/x, x), x, -(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(1), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**S(2)/a)/(S(2)*a*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/x**S(3), x), x, b*(a + b*x**S(2))*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(2), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**S(2)/a)/(S(2)*a**S(2)*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, x**S(5)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(5)/2, -S(2)*p), (S(7)/2,), -b*x**S(2)/a)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, x**S(3)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(3)/2, -S(2)*p), (S(5)/2,), -b*x**S(2)/a)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, x*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(1)/2, -S(2)*p), (S(3)/2,), -b*x**S(2)/a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/x**S(2), x), x, -(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(-1)/2, -S(2)*p), (S(1)/2,), -b*x**S(2)/a)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/x**S(4), x), x, -(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(-3)/2, -S(2)*p), (S(-1)/2,), -b*x**S(2)/a)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, S(2)*(d*x)**(S(5)/2)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(5)/4, -S(2)*p), (S(9)/4,), -b*x**S(2)/a)/(S(5)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p, x), x, S(2)*(d*x)**(S(3)/2)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(3)/4, -S(2)*p), (S(7)/4,), -b*x**S(2)/a)/(S(3)*d), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/sqrt(d*x), x), x, S(2)*sqrt(d*x)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(1)/4, -S(2)*p), (S(5)/4,), -b*x**S(2)/a)/d, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/(d*x)**(S(3)/2), x), x, -S(2)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(-1)/4, -S(2)*p), (S(3)/4,), -b*x**S(2)/a)/(d*sqrt(d*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p/(d*x)**(S(5)/2), x), x, -S(2)*(S(1) + b*x**S(2)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(2) + b**S(2)*x**S(4))**p*hyper((S(-3)/4, -S(2)*p), (S(1)/4,), -b*x**S(2)/a)/(S(3)*d*(d*x)**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(2) + c*x**S(4)), x), x, a*x**S(3)/S(3) + b*x**S(5)/S(5) + c*x**S(7)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(2) + c*x**S(4)), x), x, a*x**S(2)/S(2) + b*x**S(4)/S(4) + c*x**S(6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(a + b*x**S(2) + c*x**S(4), x), x, a*x + b*x**S(3)/S(3) + c*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x, x), x, a*log(x) + b*x**S(2)/S(2) + c*x**S(4)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(2), x), x, -a/x + b*x + c*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(3), x), x, -a/(S(2)*x**S(2)) + b*log(x) + c*x**S(2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(4), x), x, -a/(S(3)*x**S(3)) - b/x + c*x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(5), x), x, -a/(S(4)*x**S(4)) - b/(S(2)*x**S(2)) + c*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(6), x), x, -a/(S(5)*x**S(5)) - b/(S(3)*x**S(3)) - c/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(7), x), x, -a/(S(6)*x**S(6)) - b/(S(4)*x**S(4)) - c/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**S(8), x), x, -a/(S(7)*x**S(7)) - b/(S(5)*x**S(5)) - c/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*x**S(3)/S(3) + S(2)*a*b*x**S(5)/S(5) + S(2)*b*c*x**S(9)/S(9) + c**S(2)*x**S(11)/S(11) + x**S(7)*(S(2)*a*c/S(7) + b**S(2)/S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*x**S(2)/S(2) + a*b*x**S(4)/S(2) + b*c*x**S(8)/S(4) + c**S(2)*x**S(10)/S(10) + x**S(6)*(a*c/S(3) + b**S(2)/S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*x + S(2)*a*b*x**S(3)/S(3) + S(2)*b*c*x**S(7)/S(7) + c**S(2)*x**S(9)/S(9) + x**S(5)*(S(2)*a*c/S(5) + b**S(2)/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x, x), x, a**S(2)*log(x) + a*b*x**S(2) + b*c*x**S(6)/S(3) + c**S(2)*x**S(8)/S(8) + x**S(4)*(a*c/S(2) + b**S(2)/S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(2), x), x, -a**S(2)/x + S(2)*a*b*x + S(2)*b*c*x**S(5)/S(5) + c**S(2)*x**S(7)/S(7) + x**S(3)*(S(2)*a*c/S(3) + b**S(2)/S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(3), x), x, -a**S(2)/(S(2)*x**S(2)) + S(2)*a*b*log(x) + b*c*x**S(4)/S(2) + c**S(2)*x**S(6)/S(6) + x**S(2)*(a*c + b**S(2)/S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(4), x), x, -a**S(2)/(S(3)*x**S(3)) - S(2)*a*b/x + S(2)*b*c*x**S(3)/S(3) + c**S(2)*x**S(5)/S(5) + x*(S(2)*a*c + b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(5), x), x, -a**S(2)/(S(4)*x**S(4)) - a*b/x**S(2) + b*c*x**S(2) + c**S(2)*x**S(4)/S(4) + (S(2)*a*c + b**S(2))*log(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(6), x), x, -a**S(2)/(S(5)*x**S(5)) - S(2)*a*b/(S(3)*x**S(3)) + S(2)*b*c*x + c**S(2)*x**S(3)/S(3) - (S(2)*a*c + b**S(2))/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(7), x), x, -a**S(2)/(S(6)*x**S(6)) - a*b/(S(2)*x**S(4)) + S(2)*b*c*log(x) + c**S(2)*x**S(2)/S(2) - (S(2)*a*c + b**S(2))/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(8), x), x, -a**S(2)/(S(7)*x**S(7)) - S(2)*a*b/(S(5)*x**S(5)) - S(2)*b*c/x + c**S(2)*x - (S(2)*a*c + b**S(2))/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(9), x), x, -a**S(2)/(S(8)*x**S(8)) - a*b/(S(3)*x**S(6)) - b*c/x**S(2) + c**S(2)*log(x) - (S(2)*a*c + b**S(2))/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(10), x), x, -a**S(2)/(S(9)*x**S(9)) - S(2)*a*b/(S(7)*x**S(7)) - S(2)*b*c/(S(3)*x**S(3)) - c**S(2)/x - (S(2)*a*c + b**S(2))/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(11), x), x, -a**S(2)/(S(10)*x**S(10)) - a*b/(S(4)*x**S(8)) - b*c/(S(2)*x**S(4)) - c**S(2)/(S(2)*x**S(2)) - (S(2)*a*c + b**S(2))/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(12), x), x, -a**S(2)/(S(11)*x**S(11)) - S(2)*a*b/(S(9)*x**S(9)) - S(2)*b*c/(S(5)*x**S(5)) - c**S(2)/(S(3)*x**S(3)) - (S(2)*a*c + b**S(2))/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**S(13), x), x, -a**S(2)/(S(12)*x**S(12)) - a*b/(S(5)*x**S(10)) - b*c/(S(3)*x**S(6)) - c**S(2)/(S(4)*x**S(4)) - (S(2)*a*c + b**S(2))/(S(8)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, a**S(3)*x**S(3)/S(3) + S(3)*a**S(2)*b*x**S(5)/S(5) + S(3)*a*x**S(7)*(a*c + b**S(2))/S(7) + S(3)*b*c**S(2)*x**S(13)/S(13) + b*x**S(9)*(S(6)*a*c + b**S(2))/S(9) + c**S(3)*x**S(15)/S(15) + S(3)*c*x**S(11)*(a*c + b**S(2))/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, a**S(3)*x**S(2)/S(2) + S(3)*a**S(2)*b*x**S(4)/S(4) + a*x**S(6)*(a*c + b**S(2))/S(2) + b*c**S(2)*x**S(12)/S(4) + b*x**S(8)*(S(6)*a*c + b**S(2))/S(8) + c**S(3)*x**S(14)/S(14) + S(3)*c*x**S(10)*(a*c + b**S(2))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3), x), x, a**S(3)*x + a**S(2)*b*x**S(3) + S(3)*a*x**S(5)*(a*c + b**S(2))/S(5) + S(3)*b*c**S(2)*x**S(11)/S(11) + b*x**S(7)*(S(6)*a*c + b**S(2))/S(7) + c**S(3)*x**S(13)/S(13) + c*x**S(9)*(a*c + b**S(2))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x, x), x, a**S(3)*log(x) + S(3)*a**S(2)*b*x**S(2)/S(2) + S(3)*a*x**S(4)*(a*c + b**S(2))/S(4) + S(3)*b*c**S(2)*x**S(10)/S(10) + b*x**S(6)*(S(6)*a*c + b**S(2))/S(6) + c**S(3)*x**S(12)/S(12) + S(3)*c*x**S(8)*(a*c + b**S(2))/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**S(2), x), x, -a**S(3)/x + S(3)*a**S(2)*b*x + a*x**S(3)*(a*c + b**S(2)) + b*c**S(2)*x**S(9)/S(3) + b*x**S(5)*(S(6)*a*c + b**S(2))/S(5) + c**S(3)*x**S(11)/S(11) + S(3)*c*x**S(7)*(a*c + b**S(2))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**S(3), x), x, -a**S(3)/(S(2)*x**S(2)) + S(3)*a**S(2)*b*log(x) + S(3)*a*x**S(2)*(a*c + b**S(2))/S(2) + S(3)*b*c**S(2)*x**S(8)/S(8) + b*x**S(4)*(S(6)*a*c + b**S(2))/S(4) + c**S(3)*x**S(10)/S(10) + c*x**S(6)*(a*c + b**S(2))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**S(4), x), x, -a**S(3)/(S(3)*x**S(3)) - S(3)*a**S(2)*b/x + S(3)*a*x*(a*c + b**S(2)) + S(3)*b*c**S(2)*x**S(7)/S(7) + b*x**S(3)*(S(6)*a*c + b**S(2))/S(3) + c**S(3)*x**S(9)/S(9) + S(3)*c*x**S(5)*(a*c + b**S(2))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(2) + c*x**S(4)), x), x, -b*x**S(2)/(S(2)*c**S(2)) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c**S(3)*sqrt(-S(4)*a*c + b**S(2))) + x**S(4)/(S(4)*c) + (-a*c + b**S(2))*log(a + b*x**S(2) + c*x**S(4))/(S(4)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(2) + c*x**S(4)), x), x, -b*log(a + b*x**S(2) + c*x**S(4))/(S(4)*c**S(2)) + x**S(2)/(S(2)*c) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(2) + c*x**S(4)), x), x, b*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*x**S(2) + c*x**S(4))/(S(4)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(2) + c*x**S(4)), x), x, -atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(2) + c*x**S(4))), x), x, b*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a + b*x**S(2) + c*x**S(4))/(S(4)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(2)*a*x**S(2)) - b*log(x)/a**S(2) + b*log(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(2)) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(4)*a*x**S(4)) + b/(S(2)*a**S(2)*x**S(2)) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(3)*sqrt(-S(4)*a*c + b**S(2))) + (-a*c + b**S(2))*log(x)/a**S(3) - (-a*c + b**S(2))*log(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(2) + c*x**S(4)), x), x, -b*x/c**S(2) + x**S(3)/(S(3)*c) + sqrt(S(2))*(-a*c + b**S(2) + b*(-S(3)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(5)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(-a*c + b**S(2) - b*(-S(3)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(5)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(2) + c*x**S(4)), x), x, x/c - sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a + b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(S(2))*sqrt(c)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*sqrt(c)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - S(1)/(a*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(3)*a*x**S(3)) + b/(a**S(2)*x) + sqrt(S(2))*sqrt(c)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*sqrt(c)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*x**S(2)/(S(2)*c*(-S(4)*a*c + b**S(2))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + x**S(4)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + log(a + b*x**S(2) + c*x**S(4))/(S(4)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*a*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) + x**S(2)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) + (S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*c*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) - (b + S(2)*c*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + log(x)/a**S(2) - log(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*x**S(2)*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) - (-S(3)*a*c + b**S(2))/(a**S(2)*x**S(2)*(-S(4)*a*c + b**S(2))) - S(2)*b*log(x)/a**S(3) + b*log(a + b*x**S(2) + c*x**S(4))/(S(2)*a**S(3)) - (S(6)*a**S(2)*c**S(2) - S(6)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*x**S(3)/(S(2)*c*(-S(4)*a*c + b**S(2))) + x**S(5)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + x*(-S(10)*a*c + S(3)*b**S(2))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))) - sqrt(S(2))*(-S(13)*a*b*c + S(3)*b**S(3) + (S(20)*a**S(2)*c**S(2) - S(19)*a*b**S(2)*c + S(3)*b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(5)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) - sqrt(S(2))*(-S(13)*a*b*c + S(3)*b**S(3) - (S(20)*a**S(2)*c**S(2) - S(19)*a*b**S(2)*c + S(3)*b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(5)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*x/(S(2)*c*(-S(4)*a*c + b**S(2))) + x**S(3)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*(-S(6)*a*c + b**S(2) + b*(-S(8)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + sqrt(S(2))*(-S(6)*a*c + b**S(2) - b*(-S(8)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, x*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*(b - (S(4)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + sqrt(S(2))*(S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -sqrt(S(2))*sqrt(c)*(S(2)*b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(S(2)*b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - x*(b + S(2)*c*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(-2)), x), x, -sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + x*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*x*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) - (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) + (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - (-S(10)*a*c + S(3)*b**S(2))/(S(2)*a**S(2)*x*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -b*x**S(2)*(-S(7)*a*c + b**S(2))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))**S(2)) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c**S(3)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x**S(8)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + x**S(4)*(a*(-S(16)*a*c + b**S(2)) + b*x**S(2)*(-S(10)*a*c + b**S(2)))/(S(4)*c*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + log(a + b*x**S(2) + c*x**S(4))/(S(4)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -S(6)*a**S(2)*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) - S(3)*a*x**S(2)*(S(2)*a + b*x**S(2))/(S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + x**S(6)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(3)*a*b*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) + S(3)*b*x**S(2)*(S(2)*a + b*x**S(2))/(S(4)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - x**S(6)*(b + S(2)*c*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**S(2)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + (S(3)*a*b + x**S(2)*(S(2)*a*c + b**S(2)))/(S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - (S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(3)*b*c*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) - S(3)*b*(b + S(2)*c*x**S(2))/(S(4)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + (S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -S(6)*c**S(2)*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) + S(3)*c*(b + S(2)*c*x**S(2))/(S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - (b + S(2)*c*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(2) + c*x**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + (S(16)*a**S(2)*c**S(2) - S(15)*a*b**S(2)*c + S(2)*b**S(4) + S(2)*b*c*x**S(2)*(-S(7)*a*c + b**S(2)))/(S(4)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(3)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + log(x)/a**S(3) - log(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(2) + c*x**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*x**S(2)*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + (S(20)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4) + S(3)*b*c*x**S(2)*(-S(6)*a*c + b**S(2)))/(S(4)*a**S(2)*x**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - (S(30)*a**S(2)*c**S(2) - S(21)*a*b**S(2)*c + S(3)*b**S(4))/(S(2)*a**S(3)*x**S(2)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*b*log(x)/a**S(4) + S(3)*b*log(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(4)) - (-S(60)*a**S(3)*c**S(3) + S(90)*a**S(2)*b**S(2)*c**S(2) - S(30)*a*b**S(4)*c + S(3)*b**S(6))*atanh((b + S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(4)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -S(3)*b*x*(-S(8)*a*c + b**S(2))/(S(8)*c**S(2)*(-S(4)*a*c + b**S(2))**S(2)) + x**S(7)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + x**S(5)*(S(12)*a*b - x**S(2)*(-S(28)*a*c + b**S(2)))/(S(8)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + x**S(3)*(-S(28)*a*c + b**S(2))/(S(8)*c*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*(S(84)*a**S(2)*c**S(2) - S(27)*a*b**S(2)*c + S(3)*b**S(4) + S(3)*(S(44)*a**S(2)*b*c**S(2) - S(11)*a*b**S(3)*c + b**S(5))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*c**(S(5)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*(S(84)*a**S(2)*c**S(2) - S(27)*a*b**S(2)*c + S(3)*b**S(4) - S(3)*b*(S(44)*a**S(2)*c**S(2) - S(11)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*c**(S(5)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**S(5)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + x**S(3)*(S(12)*a*b + x**S(2)*(S(20)*a*c + b**S(2)))/(S(8)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - x*(S(20)*a*c + b**S(2))/(S(8)*c*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*(-S(16)*a*b*c + b**S(3) + (-S(40)*a**S(2)*c**S(2) - S(18)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*(-S(16)*a*b*c + b**S(3) - (-S(40)*a**S(2)*c**S(2) - S(18)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**S(3)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + S(3)*x*(S(4)*a*b + x**S(2)*(S(4)*a*c + b**S(2)))/(S(8)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*(S(12)*a*c + S(3)*b**S(2) + S(3)*b*(S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*sqrt(c)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*(S(12)*a*c + S(3)*b**S(2) - S(3)*b*(S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*sqrt(c)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -S(3)*sqrt(S(2))*sqrt(c)*(S(4)*a*c + S(3)*b**S(2) + S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(8)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*sqrt(S(2))*sqrt(c)*(S(4)*a*c + S(3)*b**S(2) - S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(8)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) - x*(-S(4)*a*c + S(7)*b**S(2) + S(12)*b*c*x**S(2))/(S(8)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -x*(b + S(2)*c*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + sqrt(S(2))*sqrt(c)*(S(20)*a*c + b**S(2) - b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*(S(20)*a*c + b**S(2) + b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + x*(b*(S(8)*a*c + b**S(2)) + c*x**S(2)*(S(20)*a*c + b**S(2)))/(S(8)*a*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(-3)), x), x, x*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + S(3)*sqrt(S(2))*sqrt(c)*(-S(8)*a*b*c + b**S(3) - (S(56)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + S(3)*sqrt(S(2))*sqrt(c)*(S(56)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4) + b*(-S(8)*a*c + b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x*(S(3)*b*c*x**S(2)*(-S(8)*a*c + b**S(2)) + (-S(7)*a*c + b**S(2))*(-S(4)*a*c + S(3)*b**S(2)))/(S(8)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(2) + c*x**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*x*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + (S(36)*a**S(2)*c**S(2) - S(35)*a*b**S(2)*c + S(5)*b**S(4) + b*c*x**S(2)*(-S(32)*a*c + S(5)*b**S(2)))/(S(8)*a**S(2)*x*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - S(3)*sqrt(S(2))*sqrt(c)*((-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)) - (S(124)*a**S(2)*b*c**S(2) - S(47)*a*b**S(3)*c + S(5)*b**S(5))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*sqrt(S(2))*sqrt(c)*(b*(S(124)*a**S(2)*c**S(2) - S(47)*a*b**S(2)*c + S(5)*b**S(4))/sqrt(-S(4)*a*c + b**S(2)) + (-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - (-S(36)*a*c + S(15)*b**S(2))*(-S(5)*a*c + b**S(2))/(S(8)*a**S(3)*x*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a - b*x**S(2) + c*x**S(4)), x), x, b*log(a - b*x**S(2) + c*x**S(4))/(S(4)*c**S(2)) + x**S(2)/(S(2)*c) + (-S(2)*a*c + b**S(2))*atanh((b - S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a - b*x**S(2) + c*x**S(4)), x), x, b*atanh((b - S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*sqrt(-S(4)*a*c + b**S(2))) + log(a - b*x**S(2) + c*x**S(4))/(S(4)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a - b*x**S(2) + c*x**S(4)), x), x, atanh((b - S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a - b*x**S(2) + c*x**S(4))), x), x, b*atanh((b - S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a - b*x**S(2) + c*x**S(4))/(S(4)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a - b*x**S(2) + c*x**S(4))), x), x, -S(1)/(S(2)*a*x**S(2)) + b*log(x)/a**S(2) - b*log(a - b*x**S(2) + c*x**S(4))/(S(4)*a**S(2)) + (-S(2)*a*c + b**S(2))*atanh((b - S(2)*c*x**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a - b*x**S(2) + c*x**S(4)), x), x, x/c - sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a - b*x**S(2) + c*x**S(4)), x), x, sqrt(S(2))*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))) - sqrt(S(2))*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a - b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*sqrt(c)*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(c)*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a - b*x**S(2) + c*x**S(4))), x), x, sqrt(S(2))*sqrt(c)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*sqrt(c)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - S(1)/(a*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, x**S(2)/(S(2)*a) - log(a*x**S(4) + S(2)*a*x**S(2) + a + b)/(S(2)*a) + (a - b)*atan(sqrt(a)*(x**S(2) + S(1))/sqrt(b))/(S(2)*a**(S(3)/2)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, log(a*x**S(4) + S(2)*a*x**S(2) + a + b)/(S(4)*a) - atan(sqrt(a)*(x**S(2) + S(1))/sqrt(b))/(S(2)*sqrt(a)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, atan(sqrt(a)*(x**S(2) + S(1))/sqrt(b))/(S(2)*sqrt(a)*sqrt(b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a*x**S(4) + S(2)*a*x**S(2) + a + b)), x), x, -sqrt(a)*atan(sqrt(a)*(x**S(2) + S(1))/sqrt(b))/(S(2)*sqrt(b)*(a + b)) - log(a*x**S(4) + S(2)*a*x**S(2) + a + b)/(S(4)*a + S(4)*b) + log(x)/(a + b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a*x**S(4) + S(2)*a*x**S(2) + a + b)), x), x, sqrt(a)*(a - b)*atan(sqrt(a)*(x**S(2) + S(1))/sqrt(b))/(S(2)*sqrt(b)*(a + b)**S(2)) - S(2)*a*log(x)/(a + b)**S(2) + a*log(a*x**S(4) + S(2)*a*x**S(2) + a + b)/(S(2)*(a + b)**S(2)) - S(1)/(x**S(2)*(S(2)*a + S(2)*b)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, (S(2)*sqrt(-a) + (a - b)/sqrt(b))*atan(x*(-a)**(S(1)/4)/sqrt(-sqrt(b) + sqrt(-a)))/(S(2)*(-a)**(S(5)/4)*sqrt(-sqrt(b) + sqrt(-a))) - (a - S(2)*sqrt(b)*sqrt(-a) - b)*atan(x*(-a)**(S(1)/4)/sqrt(sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(-a)**(S(5)/4)*sqrt(sqrt(b) + sqrt(-a))) + x/a, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, sqrt(-sqrt(b) + sqrt(-a))*atan(x*(-a)**(S(1)/4)/sqrt(-sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(-a)**(S(3)/4)) - sqrt(sqrt(b) + sqrt(-a))*atan(x*(-a)**(S(1)/4)/sqrt(sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(-a)**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a*x**S(4) + S(2)*a*x**S(2) + a + b), x), x, atan(x*(-a)**(S(1)/4)/sqrt(sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(-a)**(S(1)/4)*sqrt(sqrt(b) + sqrt(-a))) - atan(x*(-a)**(S(1)/4)/sqrt(-sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(-a)**(S(1)/4)*sqrt(-sqrt(b) + sqrt(-a))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a*x**S(4) + S(2)*a*x**S(2) + a + b)), x), x, -S(1)/(x*(a + b)) + (-a)**(S(1)/4)*(-sqrt(b) + sqrt(-a))*atan(x*(-a)**(S(1)/4)/sqrt(sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(a + b)*sqrt(sqrt(b) + sqrt(-a))) - (-a)**(S(1)/4)*(sqrt(b) + sqrt(-a))*atan(x*(-a)**(S(1)/4)/sqrt(-sqrt(b) + sqrt(-a)))/(S(2)*sqrt(b)*(a + b)*sqrt(-sqrt(b) + sqrt(-a))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a**S(2) + S(2)*a*x**S(2) + b + x**S(4)), x), x, -atan(x/sqrt(a + sqrt(-b)))/(S(2)*sqrt(-b)*sqrt(a + sqrt(-b))) + atan(x/sqrt(a - sqrt(-b)))/(S(2)*sqrt(-b)*sqrt(a - sqrt(-b))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a**S(2) + S(2)*a*x**S(2) + x**S(4) + S(-1)), x), x, -atan(x/sqrt(a + S(1)))/(S(2)*sqrt(a + S(1))) - atanh(x/sqrt(-a + S(1)))/(S(2)*sqrt(-a + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a**S(2) + S(2)*a*x**S(2) + x**S(4) + S(1)), x), x, -sqrt(S(2))*atan((-sqrt(S(2))*x + sqrt(-a + sqrt(a**S(2) + S(1))))/sqrt(a + sqrt(a**S(2) + S(1))))/(S(4)*sqrt(a + sqrt(a**S(2) + S(1)))*sqrt(a**S(2) + S(1))) + sqrt(S(2))*atan((sqrt(S(2))*x + sqrt(-a + sqrt(a**S(2) + S(1))))/sqrt(a + sqrt(a**S(2) + S(1))))/(S(4)*sqrt(a + sqrt(a**S(2) + S(1)))*sqrt(a**S(2) + S(1))) - sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x*sqrt(-a + sqrt(a**S(2) + S(1))) + sqrt(a**S(2) + S(1)))/(S(8)*sqrt(-a + sqrt(a**S(2) + S(1)))*sqrt(a**S(2) + S(1))) + sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x*sqrt(-a + sqrt(a**S(2) + S(1))) + sqrt(a**S(2) + S(1)))/(S(8)*sqrt(-a + sqrt(a**S(2) + S(1)))*sqrt(a**S(2) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) - S(5)*x**S(2) + S(4)), x), x, -atanh(x/S(2))/S(6) + atanh(x)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) + S(4)*x**S(2) + S(3)), x), x, atan(x)/S(2) - sqrt(S(3))*atan(sqrt(S(3))*x/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) + S(5)*x**S(2) + S(9)), x), x, -log(x**S(2) - x + S(3))/S(12) + log(x**S(2) + x + S(3))/S(12) - sqrt(S(11))*atan(sqrt(S(11))*(-S(2)*x + S(1))/S(11))/S(66) + sqrt(S(11))*atan(sqrt(S(11))*(S(2)*x + S(1))/S(11))/S(66), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) - x**S(2) + S(1)), x), x, -sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(12) + sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(12) + atan(S(2)*x - sqrt(S(3)))/S(2) + atan(S(2)*x + sqrt(S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4) + S(2)*x**S(2) + S(2)), x), x, -log(x**S(2) - x*sqrt(S(-2) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(8)*sqrt(S(-1) + sqrt(S(2)))) + log(x**S(2) + x*sqrt(S(-2) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(8)*sqrt(S(-1) + sqrt(S(2)))) - sqrt(S(-1) + sqrt(S(2)))*atan((-S(2)*x + sqrt(S(-2) + S(2)*sqrt(S(2))))/sqrt(S(2) + S(2)*sqrt(S(2))))/S(4) + sqrt(S(-1) + sqrt(S(2)))*atan((S(2)*x + sqrt(S(-2) + S(2)*sqrt(S(2))))/sqrt(S(2) + S(2)*sqrt(S(2))))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(4) + x**S(2) + S(1)), x), x, sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(4) + S(2)*x**S(2) + S(10)), x), x, atan(x**S(2)/S(3) + S(1)/3)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(4) + S(9)*x**S(2) + S(20)), x), x, -S(2)*atan(x/S(2)) + sqrt(S(5))*atan(sqrt(S(5))*x/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(4) - x**S(2) + S(1)), x), x, sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(12) + atan(S(2)*x - sqrt(S(3)))/S(2) + atan(S(2)*x + sqrt(S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(4) - S(2)*x**S(2) + S(2)), x), x, log(x**S(2) - x*sqrt(S(2) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(4)*sqrt(S(2) + S(2)*sqrt(S(2)))) - log(x**S(2) + x*sqrt(S(2) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(4)*sqrt(S(2) + S(2)*sqrt(S(2)))) - sqrt(S(1)/2 + sqrt(S(2))/S(2))*atan((-S(2)*x + sqrt(S(2) + S(2)*sqrt(S(2))))/sqrt(S(-2) + S(2)*sqrt(S(2))))/S(2) + sqrt(S(1)/2 + sqrt(S(2))/S(2))*atan((S(2)*x + sqrt(S(2) + S(2)*sqrt(S(2))))/sqrt(S(-2) + S(2)*sqrt(S(2))))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -b*(b + S(2)*c*x**S(2))*(-S(12)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(256)*c**S(4)) + b*(-S(12)*a*c + S(7)*b**S(2))*(-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(512)*c**(S(9)/2)) + x**S(4)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(10)*c) + (a + b*x**S(2) + c*x**S(4))**(S(3)/2)*(-S(32)*a*c + S(35)*b**S(2) - S(42)*b*c*x**S(2))/(S(480)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -S(5)*b*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(48)*c**S(2)) + x**S(2)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(8)*c) + (b + S(2)*c*x**S(2))*(-S(4)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(128)*c**S(3)) - (-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(5)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(256)*c**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -b*(b + S(2)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(16)*c**S(2)) + b*(-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*c**(S(5)/2)) + (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, (b + S(2)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*c) - (-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x, x), x, -sqrt(a)*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(2) + b*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*sqrt(c)) + sqrt(a + b*x**S(2) + c*x**S(4))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(3), x), x, sqrt(c)*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(2) - sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*x**S(2)) - b*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(5), x), x, -(S(2)*a + b*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*a*x**S(4)) + (-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(7), x), x, -(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(6)*a*x**S(6)) + b*(S(2)*a + b*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(16)*a**S(2)*x**S(4)) - b*(-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(9), x), x, -(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(8)*a*x**S(8)) + S(5)*b*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(48)*a**S(2)*x**S(6)) - (S(2)*a + b*x**S(2))*(-S(4)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(128)*a**S(3)*x**S(4)) + (-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(5)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(256)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(11), x), x, -(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(10)*a*x**S(10)) + S(7)*b*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(80)*a**S(2)*x**S(8)) - (-S(32)*a*c + S(35)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(480)*a**S(3)*x**S(6)) + b*(S(2)*a + b*x**S(2))*(-S(12)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(256)*a**S(4)*x**S(4)) - b*(-S(12)*a*c + S(7)*b**S(2))*(-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(512)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(29)*a*c + S(8)*b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(105)*c**(S(11)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(2)*sqrt(a)*sqrt(c)*(-S(5)*a*c + S(2)*b**S(2)) - S(29)*a*b*c + S(8)*b**S(3))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(210)*c**(S(11)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + b*x*(-S(29)*a*c + S(8)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(105)*c**(S(5)/2)*(sqrt(a) + sqrt(c)*x**S(2))) + x**S(3)*(b + S(5)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*c) - x*(-S(10)*a*c + S(4)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(105)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(3)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(15)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*b*sqrt(c) - S(6)*a*c + S(2)*b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(30)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + x*(b + S(3)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*c) - x*(-S(6)*a*c + S(2)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(2)*sqrt(a)*sqrt(c) + b)*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + b*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))) + x*sqrt(a + b*x**S(2) + c*x**S(4))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(2), x), x, -S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/sqrt(a + b*x**S(2) + c*x**S(4)) + S(2)*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2)) - sqrt(a + b*x**S(2) + c*x**S(4))/x + sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(2)*sqrt(a)*sqrt(c) + b)*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(4), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*x**S(3)) + b*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*a*(sqrt(a) + sqrt(c)*x**S(2))) - b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*a*x) - b*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(2)*sqrt(a)*sqrt(c) + b)*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/x**S(6), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*x**S(5)) - b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*a*x**S(3)) - S(2)*sqrt(c)*x*(-S(3)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*a**S(2)*(sqrt(a) + sqrt(c)*x**S(2))) + (-S(6)*a*c + S(2)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*a**S(2)*x) + S(2)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(3)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(15)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*b*sqrt(c) - S(6)*a*c + S(2)*b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(30)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -b*(b + S(2)*c*x**S(2))*(-S(4)*a*c + S(3)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(256)*c**S(4)) + S(3)*b*(b + S(2)*c*x**S(2))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(2048)*c**S(5)) - S(3)*b*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4096)*c**(S(11)/2)) + x**S(4)*(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(14)*c) + (a + b*x**S(2) + c*x**S(4))**(S(5)/2)*(-S(16)*a*c + S(21)*b**S(2) - S(30)*b*c*x**S(2))/(S(560)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(7)*b*(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(120)*c**S(2)) + x**S(2)*(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(12)*c) + (b + S(2)*c*x**S(2))*(-S(4)*a*c + S(7)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(384)*c**S(3)) - (b + S(2)*c*x**S(2))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(1024)*c**S(4)) + (-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(7)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2048)*c**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -b*(b + S(2)*c*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(32)*c**S(2)) + S(3)*b*(b + S(2)*c*x**S(2))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(256)*c**S(3)) - S(3)*b*(-S(4)*a*c + b**S(2))**S(2)*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(512)*c**(S(7)/2)) + (a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(10)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, (b + S(2)*c*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(16)*c) - (b + S(2)*c*x**S(2))*(-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(128)*c**S(2)) + S(3)*(-S(4)*a*c + b**S(2))**S(2)*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(256)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x, x), x, -a**(S(3)/2)*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(2) - b*(-S(12)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*c**(S(3)/2)) + (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/S(6) + sqrt(a + b*x**S(2) + c*x**S(4))*(S(8)*a*c + b**S(2) + S(2)*b*c*x**S(2))/(S(16)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(3), x), x, -S(3)*sqrt(a)*b*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(4) + (S(9)*b/S(8) + S(3)*c*x**S(2)/S(4))*sqrt(a + b*x**S(2) + c*x**S(4)) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(2)*x**S(2)) + (S(12)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(5), x), x, S(3)*b*sqrt(c)*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(4) - (S(3)*b - S(6)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*x**S(2)) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(4)*x**S(4)) - (S(12)*a*c + S(3)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(7), x), x, c**(S(3)/2)*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/S(2) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(6)*x**S(6)) - (S(2)*a*b + x**S(2)*(S(8)*a*c + b**S(2)))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(16)*a*x**S(4)) + b*(-S(12)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(9), x), x, -(S(2)*a + b*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(16)*a*x**S(8)) + (S(2)*a + b*x**S(2))*(-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(128)*a**S(2)*x**S(4)) - S(3)*(-S(4)*a*c + b**S(2))**S(2)*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(256)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(11), x), x, -(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(10)*a*x**S(10)) + b*(S(2)*a + b*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(32)*a**S(2)*x**S(8)) - S(3)*b*(S(2)*a + b*x**S(2))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(256)*a**S(3)*x**S(4)) + S(3)*b*(-S(4)*a*c + b**S(2))**S(2)*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(512)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(13), x), x, -(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(12)*a*x**S(12)) + S(7)*b*(a + b*x**S(2) + c*x**S(4))**(S(5)/2)/(S(120)*a**S(2)*x**S(10)) - (S(2)*a + b*x**S(2))*(-S(4)*a*c + S(7)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(384)*a**S(3)*x**S(8)) + (S(2)*a + b*x**S(2))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(1024)*a**S(4)*x**S(4)) - (-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(7)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2048)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(8)*a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(9)*a*c + S(2)*b**S(2))*(-S(3)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(1155)*c**(S(15)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*sqrt(c)*(S(60)*a**S(2)*c**S(2) - S(51)*a*b**S(2)*c + S(8)*b**S(4)) + S(8)*b*(-S(9)*a*c + S(2)*b**S(2))*(-S(3)*a*c + b**S(2)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2310)*c**(S(15)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - S(8)*b*x*(-S(9)*a*c + S(2)*b**S(2))*(-S(3)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(1155)*c**(S(7)/2)*(sqrt(a) + sqrt(c)*x**S(2))) + x**S(3)*(b + S(3)*c*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(33)*c) - x**S(3)*(b*(a*c + S(2)*b**S(2)) + S(10)*c*x**S(2)*(-S(3)*a*c + b**S(2)))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(385)*c**S(2)) + x*sqrt(a + b*x**S(2) + c*x**S(4))*(S(60)*a**S(2)*c**S(2) - S(51)*a*b**S(2)*c + S(8)*b**S(4))/(S(1155)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(84)*a**S(2)*c**S(2) - S(57)*a*b**S(2)*c + S(8)*b**S(4))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(315)*c**(S(11)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(4)*sqrt(a)*b*sqrt(c)*(-S(6)*a*c + b**S(2)) + S(84)*a**S(2)*c**S(2) - S(57)*a*b**S(2)*c + S(8)*b**S(4))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(630)*c**(S(11)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + x*(S(3)*b + S(7)*c*x**S(2))*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(63)*c) - x*(b*(-S(9)*a*c + S(4)*b**S(2)) + S(6)*c*x**S(2)*(-S(7)*a*c + S(2)*b**S(2)))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(315)*c**S(2)) + x*sqrt(a + b*x**S(2) + c*x**S(4))*(S(84)*a**S(2)*c**S(2) - S(57)*a*b**S(2)*c + S(8)*b**S(4))/(S(315)*c**(S(5)/2)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(2)*a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(8)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(35)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*sqrt(c)*(-S(20)*a*c + b**S(2)) + S(2)*b*(-S(8)*a*c + b**S(2)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(70)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - S(2)*b*x*(-S(8)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))) + x*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)/S(7) + x*sqrt(a + b*x**S(2) + c*x**S(4))*(S(10)*a*c + b**S(2) + S(3)*b*c*x**S(2))/(S(35)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(2), x), x, -a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(12)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(5)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(8)*sqrt(a)*b*sqrt(c) + S(12)*a*c + b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(10)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + x*(S(7)*b + S(6)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/S(5) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x + x*(S(12)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(4), x), x, -S(8)*a**(S(1)/4)*b*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*sqrt(a + b*x**S(2) + c*x**S(4))) + S(8)*b*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*sqrt(a) + S(3)*sqrt(c)*x**S(2)) - (S(3)*b - S(2)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*x) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(3)*x**S(3)) + sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(8)*sqrt(a)*b*sqrt(c) + S(4)*a*c + S(3)*b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*a**(S(1)/4)*c**(S(1)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(6), x), x, -(b - S(6)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*x**S(3)) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(5)*x**S(5)) + sqrt(c)*x*(S(12)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*a*(sqrt(a) + sqrt(c)*x**S(2))) - (S(12)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*a*x) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(12)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(5)*a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(8)*sqrt(a)*b*sqrt(c) + S(12)*a*c + b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(10)*a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/x**S(8), x), x, -(S(3)*b + S(30)*c*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*x**S(5)) - (a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(S(7)*x**S(7)) - (-S(20)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*a*x**S(3)) - S(2)*b*sqrt(c)*x*(-S(8)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*a**S(2)*(sqrt(a) + sqrt(c)*x**S(2))) + S(2)*b*(-S(8)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(35)*a**S(2)*x) + S(2)*b*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(8)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(35)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*sqrt(c)*(-S(20)*a*c + b**S(2)) + S(2)*b*(-S(8)*a*c + b**S(2)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(70)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(-x**S(4) - S(2)*x**S(2) + S(3)), x), x, x*sqrt(-x**S(4) - S(2)*x**S(2) + S(3))/S(3) - S(2)*sqrt(S(3))*elliptic_e(asin(x), S(-1)/3)/S(3) + S(4)*sqrt(S(3))*elliptic_f(asin(x), S(-1)/3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -b*(-S(12)*a*c + S(5)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*c**(S(7)/2)) + x**S(4)*sqrt(a + b*x**S(2) + c*x**S(4))/(S(6)*c) + sqrt(a + b*x**S(2) + c*x**S(4))*(-S(16)*a*c + S(15)*b**S(2) - S(10)*b*c*x**S(2))/(S(48)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -S(3)*b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*c**S(2)) + x**S(2)*sqrt(a + b*x**S(2) + c*x**S(4))/(S(4)*c) + (-S(4)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -b*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*c**(S(3)/2)) + sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*a*x**S(2)) + b*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(4)*a*x**S(4)) + S(3)*b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*a**S(2)*x**S(2)) - (-S(4)*a*c + S(3)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(6)*a*x**S(6)) + S(5)*b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(24)*a**S(2)*x**S(4)) - (-S(16)*a*c + S(15)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(48)*a**S(3)*x**S(2)) + b*(-S(12)*a*c + S(5)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(32)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*sqrt(c) + S(2)*b)*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - S(2)*b*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))) + x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + x*sqrt(a + b*x**S(2) + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(a*(sqrt(a) + sqrt(c)*x**S(2))) - sqrt(a + b*x**S(2) + c*x**S(4))/(a*x) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*a*x**S(3)) - S(2)*b*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*a**S(2)*(sqrt(a) + sqrt(c)*x**S(2))) + S(2)*b*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*a**S(2)*x) + S(2)*b*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*sqrt(c) + S(2)*b)*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*a**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -b*(S(12)*a*c + S(5)*b**S(2))*atan((b - S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))))/(S(32)*c**(S(7)/2)) - x**S(4)*sqrt(a + b*x**S(2) - c*x**S(4))/(S(6)*c) - sqrt(a + b*x**S(2) - c*x**S(4))*(S(16)*a*c + S(15)*b**S(2) + S(10)*b*c*x**S(2))/(S(48)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -S(3)*b*sqrt(a + b*x**S(2) - c*x**S(4))/(S(8)*c**S(2)) - x**S(2)*sqrt(a + b*x**S(2) - c*x**S(4))/(S(4)*c) - (S(4)*a*c + S(3)*b**S(2))*atan((b - S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))))/(S(16)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -b*atan((b - S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))))/(S(4)*c**(S(3)/2)) - sqrt(a + b*x**S(2) - c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -atan((b - S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))))/(S(2)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, -atan((S(2)*a - b*x**S(2))/(S(2)*sqrt(a)*sqrt(-a + b*x**S(2) + c*x**S(4))))/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, sqrt(-a + b*x**S(2) + c*x**S(4))/(S(2)*a*x**S(2)) - b*atan((S(2)*a - b*x**S(2))/(S(2)*sqrt(a)*sqrt(-a + b*x**S(2) + c*x**S(4))))/(S(4)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, sqrt(-a + b*x**S(2) + c*x**S(4))/(S(4)*a*x**S(4)) + S(3)*b*sqrt(-a + b*x**S(2) + c*x**S(4))/(S(8)*a**S(2)*x**S(2)) - (S(4)*a*c + S(3)*b**S(2))*atan((S(2)*a - b*x**S(2))/(S(2)*sqrt(a)*sqrt(-a + b*x**S(2) + c*x**S(4))))/(S(16)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, sqrt(-a + b*x**S(2) + c*x**S(4))/(S(6)*a*x**S(6)) + S(5)*b*sqrt(-a + b*x**S(2) + c*x**S(4))/(S(24)*a**S(2)*x**S(4)) + (S(16)*a*c + S(15)*b**S(2))*sqrt(-a + b*x**S(2) + c*x**S(4))/(S(48)*a**S(3)*x**S(2)) - b*(S(12)*a*c + S(5)*b**S(2))*atan((S(2)*a - b*x**S(2))/(S(2)*sqrt(a)*sqrt(-a + b*x**S(2) + c*x**S(4))))/(S(32)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -sqrt(S(2))*b*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*c**(S(5)/2)*sqrt(a + b*x**S(2) - c*x**S(4))) - x*sqrt(a + b*x**S(2) - c*x**S(4))/(S(3)*c) + sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*(a*c + b**S(2) - b*sqrt(S(4)*a*c + b**S(2)))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*c**(S(5)/2)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -sqrt(S(2))*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(a + b*x**S(2) - c*x**S(4))) + sqrt(S(2))*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + b*x**S(2) - c*x**S(4))), x), x, -sqrt(a + b*x**S(2) - c*x**S(4))/(a*x) + sqrt(S(2))*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))) - sqrt(S(2))*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a + b*x**S(2) - c*x**S(4))), x), x, -sqrt(a + b*x**S(2) - c*x**S(4))/(S(3)*a*x**S(3)) + S(2)*b*sqrt(a + b*x**S(2) - c*x**S(4))/(S(3)*a**S(2)*x) - sqrt(S(2))*b*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*a**S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))) + sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*(a*c + b**S(2) - b*sqrt(S(4)*a*c + b**S(2)))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*a**S(2)*sqrt(c)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -b*x**S(4)*sqrt(a + b*x**S(2) + c*x**S(4))/(c*(-S(4)*a*c + b**S(2))) + x**S(6)*(S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - (b*(-S(52)*a*c + S(15)*b**S(2)) - S(2)*c*x**S(2)*(-S(12)*a*c + S(5)*b**S(2)))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*c**S(3)*(-S(4)*a*c + b**S(2))) + (-S(12)*a*c + S(15)*b**S(2))*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*c**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(3)*b*atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*c**(S(5)/2)) + x**S(4)*(S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + sqrt(a + b*x**S(2) + c*x**S(4))*(-S(8)*a*c + S(3)*b**S(2) - S(2)*b*c*x**S(2))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -b*sqrt(a + b*x**S(2) + c*x**S(4))/(c*(-S(4)*a*c + b**S(2))) + x**S(2)*(S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + atanh((b + S(2)*c*x**S(2))/(S(2)*sqrt(c)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, (S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -(b + S(2)*c*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(a*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(2)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(a*x**S(2)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - (-S(8)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*a**S(2)*x**S(2)*(-S(4)*a*c + b**S(2))) + S(3)*b*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(4)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(a*x**S(4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - (-S(12)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(4)*a**S(2)*x**S(4)*(-S(4)*a*c + b**S(2))) + b*(-S(52)*a*c + S(15)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(S(8)*a**S(3)*x**S(2)*(-S(4)*a*c + b**S(2))) - (-S(12)*a*c + S(15)*b**S(2))*atanh((S(2)*a + b*x**S(2))/(S(2)*sqrt(a)*sqrt(a + b*x**S(2) + c*x**S(4))))/(S(16)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(2)*a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(3)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(7)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*b*sqrt(c) - S(6)*a*c + S(2)*b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*c**(S(7)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - b*x*sqrt(a + b*x**S(2) + c*x**S(4))/(c*(-S(4)*a*c + b**S(2))) + x**S(3)*(S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + x*(-S(6)*a*c + S(2)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, a**(S(1)/4)*b*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(3)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(3)/4)*(-S(4)*sqrt(a)*sqrt(c) + S(2)*b)*sqrt(a + b*x**S(2) + c*x**S(4))) - b*x*sqrt(a + b*x**S(2) + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))*(-S(4)*a*c + b**S(2))) + x*(S(2)*a + b*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, -S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + S(2)*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/((sqrt(a) + sqrt(c)*x**S(2))*(-S(4)*a*c + b**S(2))) - x*(b + S(2)*c*x**S(2))/((-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*c**(S(1)/4)*(-S(2)*sqrt(a)*sqrt(c) + b)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(-3)/2), x), x, -b*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(a*(sqrt(a) + sqrt(c)*x**S(2))*(-S(4)*a*c + b**S(2))) + x*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(a*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + b*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(a**(S(3)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) - c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(3)/4)*(-S(2)*sqrt(a)*sqrt(c) + b)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(a*x*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + S(2)*sqrt(c)*x*(-S(3)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(a**S(2)*(sqrt(a) + sqrt(c)*x**S(2))*(-S(4)*a*c + b**S(2))) - (-S(6)*a*c + S(2)*b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))/(a**S(2)*x*(-S(4)*a*c + b**S(2))) - S(2)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(3)*a*c + b**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(a**(S(7)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(sqrt(a)*b*sqrt(c) - S(6)*a*c + S(2)*b**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(7)/4)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, elliptic_f(asin(sqrt(S(2))*x/S(2)), S(-6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(4)*x**S(2) + S(2)), x), x, sqrt(S(1)/3 + sqrt(S(10))/S(6))*elliptic_f(asin(x*sqrt(S(-1) + sqrt(S(10))/S(2))), S(-7)/3 - S(2)*sqrt(S(10))/S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(3)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(sqrt(S(6))*x/sqrt(S(3) + sqrt(S(33)))), S(-7)/4 - sqrt(S(33))/S(4))/sqrt(S(-3) + sqrt(S(33))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(2)*x**S(2) + S(2)), x), x, elliptic_f(asin(sqrt(S(3))*x/sqrt(S(1) + sqrt(S(7)))), S(-4)/3 - sqrt(S(7))/S(3))/sqrt(S(-1) + sqrt(S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(x), S(-3)/2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(2)), x), x, S(6)**(S(3)/4)*elliptic_f(asin(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), S(-1))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - x**S(2) + S(2)), x), x, sqrt(S(3))*elliptic_f(asin(sqrt(S(6))*x/S(2)), S(-2)/3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(2)*x**S(2) + S(2)), x), x, elliptic_f(asin(sqrt(S(3))*x/sqrt(S(-1) + sqrt(S(7)))), S(-4)/3 + sqrt(S(7))/S(3))/sqrt(S(1) + sqrt(S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(3)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(sqrt(S(6))*x/sqrt(S(-3) + sqrt(S(33)))), S(-7)/4 + sqrt(S(33))/S(4))/sqrt(S(3) + sqrt(S(33))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(4)*x**S(2) + S(2)), x), x, sqrt(S(-1)/3 + sqrt(S(10))/S(6))*elliptic_f(asin(x*sqrt(S(1) + sqrt(S(10))/S(2))), S(-7)/3 + S(2)*sqrt(S(10))/S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(5)*x**S(2) + S(2)), x), x, sqrt(S(6))*elliptic_f(asin(sqrt(S(3))*x), S(-1)/6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(7)*x**S(2) + S(3)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*x/sqrt(S(7) + sqrt(S(73)))), S(-61)/12 - S(7)*sqrt(S(73))/S(12))/sqrt(S(-7) + sqrt(S(73))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(6)*x**S(2) + S(3)), x), x, sqrt(S(1)/2 + sqrt(S(15))/S(6))*elliptic_f(asin(x*sqrt(S(-1) + sqrt(S(15))/S(3))), S(-4) - sqrt(S(15))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(5)*x**S(2) + S(3)), x), x, elliptic_f(asin(sqrt(S(3))*x/S(3)), S(-6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(4)*x**S(2) + S(3)), x), x, elliptic_f(asin(sqrt(S(2))*x/sqrt(S(2) + sqrt(S(10)))), S(-7)/3 - S(2)*sqrt(S(10))/S(3))/sqrt(S(-2) + sqrt(S(10))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(3)*x**S(2) + S(3)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*x/sqrt(S(3) + sqrt(S(33)))), S(-7)/4 - sqrt(S(33))/S(4))/sqrt(S(-3) + sqrt(S(33))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(2)*x**S(2) + S(3)), x), x, elliptic_f(asin(sqrt(S(2))*x/sqrt(S(1) + sqrt(S(7)))), S(-4)/3 - sqrt(S(7))/S(3))/sqrt(S(-1) + sqrt(S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + x**S(2) + S(3)), x), x, sqrt(S(2))*elliptic_f(asin(sqrt(S(6))*x/S(3)), S(-3)/2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(3)), x), x, S(6)**(S(3)/4)*elliptic_f(asin(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(-1))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - x**S(2) + S(3)), x), x, sqrt(S(3))*elliptic_f(asin(x), S(-2)/3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(2)*x**S(2) + S(3)), x), x, elliptic_f(asin(sqrt(S(2))*x/sqrt(S(-1) + sqrt(S(7)))), S(-4)/3 + sqrt(S(7))/S(3))/sqrt(S(1) + sqrt(S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(3)*x**S(2) + S(3)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*x/sqrt(S(-3) + sqrt(S(33)))), S(-7)/4 + sqrt(S(33))/S(4))/sqrt(S(3) + sqrt(S(33))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(4)*x**S(2) + S(3)), x), x, elliptic_f(asin(sqrt(S(2))*x/sqrt(S(-2) + sqrt(S(10)))), S(-7)/3 + S(2)*sqrt(S(10))/S(3))/sqrt(S(2) + sqrt(S(10))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(5)*x**S(2) + S(3)), x), x, sqrt(S(6))*elliptic_f(asin(sqrt(S(2))*x), S(-1)/6)/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(6)*x**S(2) + S(3)), x), x, sqrt(S(-1)/2 + sqrt(S(15))/S(6))*elliptic_f(asin(x*sqrt(S(1) + sqrt(S(15))/S(3))), S(-4) + sqrt(S(15))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(7)*x**S(2) + S(3)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*x/sqrt(S(-7) + sqrt(S(73)))), S(-61)/12 + S(7)*sqrt(S(73))/S(12))/sqrt(S(7) + sqrt(S(73))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(-2)), x), x, sqrt(S(7))*sqrt(x**S(2) + S(2))*sqrt(S(3)*x**S(2) + S(-1))*elliptic_f(asin(sqrt(S(14))*x/(S(2)*sqrt(S(3)*x**S(2) + S(-1)))), S(6)/7)/(S(7)*sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(4)*x**S(2) + S(-2)), x), x, S(10)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(10)) + S(2)) + S(2))/(-x**S(2)*(S(2) + sqrt(S(10))) + S(2)))*sqrt(x**S(2)*(S(2) + sqrt(S(10))) + S(-2))*elliptic_f(asin(S(2)**(S(3)/4)*S(5)**(S(1)/4)*x/sqrt(x**S(2)*(S(2) + sqrt(S(10))) + S(-2))), sqrt(S(10))/S(10) + S(1)/2)/(S(20)*sqrt(S(3)*x**S(4) + S(4)*x**S(2) + S(-2))*sqrt(S(1)/(-x**S(2)*(S(2) + sqrt(S(10))) + S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(3)*x**S(2) + S(-2)), x), x, sqrt(S(2))*S(33)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(33)) + S(3)) + S(4))/(-x**S(2)*(S(3) + sqrt(S(33))) + S(4)))*sqrt(x**S(2)*(S(3) + sqrt(S(33))) + S(-4))*elliptic_f(asin(sqrt(S(2))*S(33)**(S(1)/4)*x/sqrt(x**S(2)*(S(3) + sqrt(S(33))) + S(-4))), sqrt(S(33))/S(22) + S(1)/2)/(S(132)*sqrt(S(3)*x**S(4) + S(3)*x**S(2) + S(-2))*sqrt(S(1)/(-x**S(2)*(S(3) + sqrt(S(33))) + S(4)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(2)*x**S(2) + S(-2)), x), x, S(7)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(7)) + S(1)) + S(2))/(-x**S(2)*(S(1) + sqrt(S(7))) + S(2)))*sqrt(x**S(2)*(S(1) + sqrt(S(7))) + S(-2))*elliptic_f(asin(sqrt(S(2))*S(7)**(S(1)/4)*x/sqrt(x**S(2)*(S(1) + sqrt(S(7))) + S(-2))), sqrt(S(7))/S(14) + S(1)/2)/(S(14)*sqrt(S(3)*x**S(4) + S(2)*x**S(2) + S(-2))*sqrt(S(1)/(-x**S(2)*(S(1) + sqrt(S(7))) + S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + x**S(2) + S(-2)), x), x, sqrt(S(5))*sqrt(x**S(2) + S(1))*sqrt(S(3)*x**S(2) + S(-2))*elliptic_f(asin(sqrt(S(5))*x/sqrt(S(3)*x**S(2) + S(-2))), S(3)/5)/(S(5)*sqrt(S(3)*x**S(4) + x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((sqrt(S(6))*x**S(2) + S(2))/(-sqrt(S(6))*x**S(2) + S(2)))*sqrt(sqrt(S(6))*x**S(2) + S(-2))*elliptic_f(asin(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/sqrt(sqrt(S(6))*x**S(2) + S(-2))), S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + S(-2))*sqrt(S(1)/(-sqrt(S(6))*x**S(2) + S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - x**S(2) + S(-2)), x), x, sqrt(S(5))*sqrt(x**S(2) + S(-1))*sqrt(S(3)*x**S(2) + S(2))*elliptic_f(asin(sqrt(S(10))*x/(S(2)*sqrt(x**S(2) + S(-1)))), S(2)/5)/(S(5)*sqrt(S(3)*x**S(4) - x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(2)*x**S(2) + S(-2)), x), x, S(7)**(S(3)/4)*sqrt((x**S(2)*(S(1) + sqrt(S(7))) + S(2))/(x**S(2)*(-sqrt(S(7)) + S(1)) + S(2)))*sqrt(-x**S(2)*(-sqrt(S(7)) + S(1)) + S(-2))*elliptic_f(asin(sqrt(S(2))*S(7)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(7)) + S(1)) + S(-2))), -sqrt(S(7))/S(14) + S(1)/2)/(S(14)*sqrt(S(3)*x**S(4) - S(2)*x**S(2) + S(-2))*sqrt(S(1)/(x**S(2)*(-sqrt(S(7)) + S(1)) + S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(3)*x**S(2) + S(-2)), x), x, sqrt(S(2))*S(33)**(S(3)/4)*sqrt((x**S(2)*(S(3) + sqrt(S(33))) + S(4))/(x**S(2)*(-sqrt(S(33)) + S(3)) + S(4)))*sqrt(-x**S(2)*(-sqrt(S(33)) + S(3)) + S(-4))*elliptic_f(asin(sqrt(S(2))*S(33)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(33)) + S(3)) + S(-4))), -sqrt(S(33))/S(22) + S(1)/2)/(S(132)*sqrt(S(3)*x**S(4) - S(3)*x**S(2) + S(-2))*sqrt(S(1)/(x**S(2)*(-sqrt(S(33)) + S(3)) + S(4)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(4)*x**S(2) + S(-2)), x), x, S(10)**(S(3)/4)*sqrt((x**S(2)*(S(2) + sqrt(S(10))) + S(2))/(x**S(2)*(-sqrt(S(10)) + S(2)) + S(2)))*sqrt(-x**S(2)*(-sqrt(S(10)) + S(2)) + S(-2))*elliptic_f(asin(S(2)**(S(3)/4)*S(5)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(10)) + S(2)) + S(-2))), -sqrt(S(10))/S(10) + S(1)/2)/(S(20)*sqrt(S(3)*x**S(4) - S(4)*x**S(2) + S(-2))*sqrt(S(1)/(x**S(2)*(-sqrt(S(10)) + S(2)) + S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(5)*x**S(2) + S(-2)), x), x, sqrt(S(7))*sqrt(x**S(2) + S(-2))*sqrt(S(3)*x**S(2) + S(1))*elliptic_f(asin(sqrt(S(7))*x/sqrt(x**S(2) + S(-2))), S(1)/7)/(S(7)*sqrt(S(3)*x**S(4) - S(5)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(7)*x**S(2) + S(-3)), x), x, sqrt(S(3))*S(73)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(73)) + S(7)) + S(6))/(-x**S(2)*(S(7) + sqrt(S(73))) + S(6)))*sqrt(x**S(2)*(S(7) + sqrt(S(73))) + S(-6))*elliptic_f(asin(sqrt(S(2))*S(73)**(S(1)/4)*x/sqrt(x**S(2)*(S(7) + sqrt(S(73))) + S(-6))), S(7)*sqrt(S(73))/S(146) + S(1)/2)/(S(438)*sqrt(S(2)*x**S(4) + S(7)*x**S(2) + S(-3))*sqrt(S(1)/(-x**S(2)*(S(7) + sqrt(S(73))) + S(6)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(6)*x**S(2) + S(-3)), x), x, sqrt(S(2))*S(3)**(S(1)/4)*S(5)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(15)) + S(3)) + S(3))/(-x**S(2)*(S(3) + sqrt(S(15))) + S(3)))*sqrt(x**S(2)*(S(3) + sqrt(S(15))) + S(-3))*elliptic_f(asin(S(15)**(S(1)/4)*sqrt(S(2))*x/sqrt(x**S(2)*(S(3) + sqrt(S(15))) + S(-3))), sqrt(S(15))/S(10) + S(1)/2)/(S(30)*sqrt(S(2)*x**S(4) + S(6)*x**S(2) + S(-3))*sqrt(S(1)/(-x**S(2)*(S(3) + sqrt(S(15))) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(-3)), x), x, sqrt(S(7))*sqrt(x**S(2) + S(3))*sqrt(S(2)*x**S(2) + S(-1))*elliptic_f(asin(sqrt(S(21))*x/(S(3)*sqrt(S(2)*x**S(2) + S(-1)))), S(6)/7)/(S(7)*sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(4)*x**S(2) + S(-3)), x), x, S(2)**(S(1)/4)*sqrt(S(3))*S(5)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(10)) + S(2)) + S(3))/(-x**S(2)*(S(2) + sqrt(S(10))) + S(3)))*sqrt(x**S(2)*(S(2) + sqrt(S(10))) + S(-3))*elliptic_f(asin(S(2)**(S(3)/4)*S(5)**(S(1)/4)*x/sqrt(x**S(2)*(S(2) + sqrt(S(10))) + S(-3))), sqrt(S(10))/S(10) + S(1)/2)/(S(30)*sqrt(S(2)*x**S(4) + S(4)*x**S(2) + S(-3))*sqrt(S(1)/(-x**S(2)*(S(2) + sqrt(S(10))) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(3)*x**S(2) + S(-3)), x), x, S(11)**(S(3)/4)*S(3)**(S(1)/4)*sqrt((-x**S(2)*(-sqrt(S(33)) + S(3)) + S(6))/(-x**S(2)*(S(3) + sqrt(S(33))) + S(6)))*sqrt(x**S(2)*(S(3) + sqrt(S(33))) + S(-6))*elliptic_f(asin(sqrt(S(2))*S(33)**(S(1)/4)*x/sqrt(x**S(2)*(S(3) + sqrt(S(33))) + S(-6))), sqrt(S(33))/S(22) + S(1)/2)/(S(66)*sqrt(S(2)*x**S(4) + S(3)*x**S(2) + S(-3))*sqrt(S(1)/(-x**S(2)*(S(3) + sqrt(S(33))) + S(6)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(2)*x**S(2) + S(-3)), x), x, sqrt(S(6))*S(7)**(S(3)/4)*sqrt((-x**S(2)*(-sqrt(S(7)) + S(1)) + S(3))/(-x**S(2)*(S(1) + sqrt(S(7))) + S(3)))*sqrt(x**S(2)*(S(1) + sqrt(S(7))) + S(-3))*elliptic_f(asin(sqrt(S(2))*S(7)**(S(1)/4)*x/sqrt(x**S(2)*(S(1) + sqrt(S(7))) + S(-3))), sqrt(S(7))/S(14) + S(1)/2)/(S(42)*sqrt(S(2)*x**S(4) + S(2)*x**S(2) + S(-3))*sqrt(S(1)/(-x**S(2)*(S(1) + sqrt(S(7))) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + x**S(2) + S(-3)), x), x, sqrt(S(5))*sqrt(x**S(2) + S(-1))*sqrt(S(2)*x**S(2) + S(3))*elliptic_f(asin(sqrt(S(15))*x/(S(3)*sqrt(x**S(2) + S(-1)))), S(3)/5)/(S(5)*sqrt(S(2)*x**S(4) + x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(-3)), x), x, S(6)**(S(1)/4)*sqrt((sqrt(S(6))*x**S(2) + S(3))/(-sqrt(S(6))*x**S(2) + S(3)))*sqrt(sqrt(S(6))*x**S(2) + S(-3))*elliptic_f(asin(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/sqrt(sqrt(S(6))*x**S(2) + S(-3))), S(1)/2)/(S(6)*sqrt(S(2)*x**S(4) + S(-3))*sqrt(S(1)/(-sqrt(S(6))*x**S(2) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - x**S(2) + S(-3)), x), x, sqrt(S(5))*sqrt(x**S(2) + S(1))*sqrt(S(2)*x**S(2) + S(-3))*elliptic_f(asin(sqrt(S(5))*x/sqrt(S(2)*x**S(2) + S(-3))), S(2)/5)/(S(5)*sqrt(S(2)*x**S(4) - x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(2)*x**S(2) + S(-3)), x), x, sqrt(S(6))*S(7)**(S(3)/4)*sqrt((x**S(2)*(S(1) + sqrt(S(7))) + S(3))/(x**S(2)*(-sqrt(S(7)) + S(1)) + S(3)))*sqrt(-x**S(2)*(-sqrt(S(7)) + S(1)) + S(-3))*elliptic_f(asin(sqrt(S(2))*S(7)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(7)) + S(1)) + S(-3))), -sqrt(S(7))/S(14) + S(1)/2)/(S(42)*sqrt(S(2)*x**S(4) - S(2)*x**S(2) + S(-3))*sqrt(S(1)/(x**S(2)*(-sqrt(S(7)) + S(1)) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(3)*x**S(2) + S(-3)), x), x, S(11)**(S(3)/4)*S(3)**(S(1)/4)*sqrt((x**S(2)*(S(3) + sqrt(S(33))) + S(6))/(x**S(2)*(-sqrt(S(33)) + S(3)) + S(6)))*sqrt(-x**S(2)*(-sqrt(S(33)) + S(3)) + S(-6))*elliptic_f(asin(sqrt(S(2))*S(33)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(33)) + S(3)) + S(-6))), -sqrt(S(33))/S(22) + S(1)/2)/(S(66)*sqrt(S(2)*x**S(4) - S(3)*x**S(2) + S(-3))*sqrt(S(1)/(x**S(2)*(-sqrt(S(33)) + S(3)) + S(6)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(4)*x**S(2) + S(-3)), x), x, S(2)**(S(1)/4)*sqrt(S(3))*S(5)**(S(3)/4)*sqrt((x**S(2)*(S(2) + sqrt(S(10))) + S(3))/(x**S(2)*(-sqrt(S(10)) + S(2)) + S(3)))*sqrt(-x**S(2)*(-sqrt(S(10)) + S(2)) + S(-3))*elliptic_f(asin(S(2)**(S(3)/4)*S(5)**(S(1)/4)*x/sqrt(-x**S(2)*(-sqrt(S(10)) + S(2)) + S(-3))), -sqrt(S(10))/S(10) + S(1)/2)/(S(30)*sqrt(S(2)*x**S(4) - S(4)*x**S(2) + S(-3))*sqrt(S(1)/(x**S(2)*(-sqrt(S(10)) + S(2)) + S(3)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(5)*x**S(2) + S(-3)), x), x, sqrt(S(7))*sqrt(x**S(2) + S(-3))*sqrt(S(2)*x**S(2) + S(1))*elliptic_f(asin(sqrt(S(7))*x/sqrt(x**S(2) + S(-3))), S(1)/7)/(S(7)*sqrt(S(2)*x**S(4) - S(5)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*sqrt((S(3)*x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(-1)/2)/(S(2)*sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(4)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(4)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + S(4)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(3)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(2)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(2)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + S(2)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) - x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(2)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(2)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) - S(2)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(3)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(3)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) - S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(4)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(4)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(S(3)*x**S(4) - S(4)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(5)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(5)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), S(1)/2 + S(5)*sqrt(S(6))/S(24))/(S(12)*sqrt(S(3)*x**S(4) - S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) - S(6)*x**S(2) + S(2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(6)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), S(1)/2 + sqrt(S(6))/S(4))/(S(12)*sqrt(S(3)*x**S(4) - S(6)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(9)*x**S(2) + S(3)), x), x, sqrt((x**S(2)*(-sqrt(S(57)) + S(9)) + S(6))/(x**S(2)*(sqrt(S(57)) + S(9)) + S(6)))*(x**S(2)*(sqrt(S(57)) + S(9)) + S(6))*elliptic_f(atan(x*sqrt(sqrt(S(57))/S(6) + S(3)/2)), S(-19)/4 + S(3)*sqrt(S(57))/S(4))/(sqrt(S(6)*sqrt(S(57)) + S(54))*sqrt(S(2)*x**S(4) + S(9)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(8)*x**S(2) + S(3)), x), x, sqrt((x**S(2)*(-sqrt(S(10)) + S(4)) + S(3))/(x**S(2)*(sqrt(S(10)) + S(4)) + S(3)))*(x**S(2)*(sqrt(S(10)) + S(4)) + S(3))*elliptic_f(atan(x*sqrt(sqrt(S(10))/S(3) + S(4)/3)), S(-10)/3 + S(4)*sqrt(S(10))/S(3))/(sqrt(S(3)*sqrt(S(10)) + S(12))*sqrt(S(2)*x**S(4) + S(8)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(7)*x**S(2) + S(3)), x), x, sqrt(S(6))*sqrt((x**S(2) + S(3))/(S(2)*x**S(2) + S(1)))*(S(2)*x**S(2) + S(1))*elliptic_f(atan(sqrt(S(2))*x), S(5)/6)/(S(6)*sqrt(S(2)*x**S(4) + S(7)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(6)*x**S(2) + S(3)), x), x, sqrt((x**S(2)*(-sqrt(S(3)) + S(3)) + S(3))/(x**S(2)*(sqrt(S(3)) + S(3)) + S(3)))*(x**S(2)*(sqrt(S(3)) + S(3)) + S(3))*elliptic_f(atan(x*sqrt(sqrt(S(3))/S(3) + S(1))), S(-1) + sqrt(S(3)))/(sqrt(S(3)*sqrt(S(3)) + S(9))*sqrt(S(2)*x**S(4) + S(6)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(3)), x), x, sqrt(S(3))*sqrt((S(2)*x**S(2) + S(3))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/3)/(S(3)*sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(4)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(4)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) + S(4)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(3)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(3)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) + S(3)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(2)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(2)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) + S(2)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) + x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) - x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(2)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(2)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) - S(2)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(3)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(3)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) - S(3)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(4)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(4)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(S(2)*x**S(4) - S(4)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(5)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(5)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(1)/2 + S(5)*sqrt(S(6))/S(24))/(S(12)*sqrt(S(2)*x**S(4) - S(5)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(6)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(6)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(1)/2 + sqrt(S(6))/S(4))/(S(12)*sqrt(S(2)*x**S(4) - S(6)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) - S(7)*x**S(2) + S(3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(7)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(1)/2 + S(7)*sqrt(S(6))/S(24))/(S(12)*sqrt(S(2)*x**S(4) - S(7)*x**S(2) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(7)*x**S(2) + S(-3)), x), x, -sqrt(S(5))*elliptic_f(acos(sqrt(S(3))*x/S(3)), S(6)/5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(6)*x**S(2) + S(-3)), x), x, -sqrt(S(2))*S(3)**(S(3)/4)*elliptic_f(acos(x*sqrt(-sqrt(S(3))/S(3) + S(1))), S(1)/2 + sqrt(S(3))/S(2))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(5)*x**S(2) + S(-3)), x), x, -elliptic_f(acos(sqrt(S(6))*x/S(3)), S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(4)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(4)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) + S(4)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(3)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(3)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) + S(3)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(2)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - S(2)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) + S(2)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) - x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) + x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) - x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(2)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(2)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) - S(2)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(3)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(3)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) - S(3)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(4)*x**S(2) + S(-3)), x), x, S(6)**(S(3)/4)*sqrt((S(2)*x**S(4) + S(4)*x**S(2) + S(3))/(sqrt(S(6))*x**S(2) + S(3))**S(2))*(sqrt(S(6))*x**S(2) + S(3))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*S(3)**(S(3)/4)*x/S(3)), -sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(-S(2)*x**S(4) - S(4)*x**S(2) + S(-3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) - S(5)*x**S(2) + S(-3)), x), x, sqrt(S(3))*sqrt(S(2)*x**S(2) + S(3))*elliptic_f(atan(x), S(1)/3)/(S(3)*sqrt((S(2)*x**S(2) + S(3))/(x**S(2) + S(1)))*sqrt(-x**S(2) + S(-1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(6)*x**S(2) + S(-2)), x), x, -sqrt(S(2))*S(3)**(S(3)/4)*elliptic_f(acos(sqrt(S(3))*x/sqrt(sqrt(S(3)) + S(3))), S(1)/2 + sqrt(S(3))/S(2))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(5)*x**S(2) + S(-2)), x), x, -elliptic_f(acos(x), S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(4)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(4)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) + S(4)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(3)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(3)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) + S(3)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(2)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - S(2)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) + S(2)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) - x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) + x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(24) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) - x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(2)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(2)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(12) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) - S(2)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(3)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(3)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(8) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) - S(3)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(4)*x**S(2) + S(-2)), x), x, S(6)**(S(3)/4)*sqrt((S(3)*x**S(4) + S(4)*x**S(2) + S(2))/(sqrt(S(6))*x**S(2) + S(2))**S(2))*(sqrt(S(6))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(3)**(S(1)/4)*x/S(2)), -sqrt(S(6))/S(6) + S(1)/2)/(S(12)*sqrt(-S(3)*x**S(4) - S(4)*x**S(2) + S(-2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) - S(5)*x**S(2) + S(-2)), x), x, -sqrt(S(2))*sqrt(-S(3)*x**S(2) + S(-2))*elliptic_f(atan(x), S(-1)/2)/(S(2)*sqrt((S(3)*x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(2) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(5)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, S(10)**(S(3)/4)*sqrt((S(5)*x**S(4) + S(5)*x**S(2) + S(2))/(sqrt(S(10))*x**S(2) + S(2))**S(2))*(sqrt(S(10))*x**S(2) + S(2))*elliptic_f(S(2)*atan(S(2)**(S(3)/4)*S(5)**(S(1)/4)*x/S(2)), -sqrt(S(10))/S(8) + S(1)/2)/(S(20)*sqrt(S(5)*x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(4)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, S(2)**(S(1)/4)*sqrt((S(4)*x**S(4) + S(5)*x**S(2) + S(2))/(sqrt(S(2))*x**S(2) + S(1))**S(2))*(sqrt(S(2))*x**S(2) + S(1))*elliptic_f(S(2)*atan(S(2)**(S(1)/4)*x), -S(5)*sqrt(S(2))/S(16) + S(1)/2)/(S(4)*sqrt(S(4)*x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*sqrt((S(3)*x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(-1)/2)/(S(2)*sqrt(S(3)*x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt((x**S(2) + S(2))/(S(2)*x**S(2) + S(1)))*(S(2)*x**S(2) + S(1))*elliptic_f(atan(sqrt(S(2))*x), S(3)/4)/(S(2)*sqrt(S(2)*x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt((x**S(2)*(-sqrt(S(17)) + S(5)) + S(4))/(x**S(2)*(sqrt(S(17)) + S(5)) + S(4)))*(x**S(2)*(sqrt(S(17)) + S(5)) + S(4))*elliptic_f(atan(x*sqrt(sqrt(S(17)) + S(5))/S(2)), S(-17)/4 + S(5)*sqrt(S(17))/S(4))/(S(2)*sqrt(sqrt(S(17)) + S(5))*sqrt(x**S(4) + S(5)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(sqrt(S(2))*x/sqrt(S(5) + sqrt(S(33)))), S(-29)/4 - S(5)*sqrt(S(33))/S(4))/sqrt(S(-5) + sqrt(S(33))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(2)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*x/sqrt(S(5) + sqrt(S(41)))), S(-33)/8 - S(5)*sqrt(S(41))/S(8))/sqrt(S(-5) + sqrt(S(41))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(3)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, elliptic_f(asin(sqrt(S(2))*x/S(2)), S(-6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(4)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*sqrt(S(2))*x/sqrt(S(5) + sqrt(S(57)))), S(-41)/16 - S(5)*sqrt(S(57))/S(16))/sqrt(S(-5) + sqrt(S(57))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(5)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(sqrt(S(10))*x/sqrt(S(5) + sqrt(S(65)))), S(-9)/4 - sqrt(S(65))/S(4))/sqrt(S(-5) + sqrt(S(65))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(6)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(S(2)*sqrt(S(3))*x/sqrt(S(5) + sqrt(S(73)))), S(-49)/24 - S(5)*sqrt(S(73))/S(24))/sqrt(S(-5) + sqrt(S(73))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(7)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(x), S(-7)/2)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(8)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(S(4)*x/sqrt(S(5) + sqrt(S(89)))), S(-57)/32 - S(5)*sqrt(S(89))/S(32))/sqrt(S(-5) + sqrt(S(89))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-S(9)*x**S(4) + S(5)*x**S(2) + S(2)), x), x, sqrt(S(2))*elliptic_f(asin(S(3)*sqrt(S(2))*x/sqrt(S(5) + sqrt(S(97)))), S(-61)/36 - S(5)*sqrt(S(97))/S(36))/sqrt(S(-5) + sqrt(S(97))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -S(2)*b*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c**S(2)*x) + x*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -b*atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*c**(S(3)/2)) + sqrt(b*x**S(2) + c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(b*x**S(2) + c*x**S(4)), x), x, sqrt(b*x**S(2) + c*x**S(4))/(c*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(b*x**S(2) + c*x**S(4)), x), x, atanh(sqrt(c)*x**S(2)/sqrt(b*x**S(2) + c*x**S(4)))/sqrt(c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(b*x**S(2) + c*x**S(4)), x), x, -atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/sqrt(b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(b*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(2)*b*x**S(3)) + c*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(2)*b**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b*x**S(4)) + S(2)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(3)*b**S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(b*x**S(2) + c*x**S(4))), x), x, -sqrt(b*x**S(2) + c*x**S(4))/(S(4)*b*x**S(5)) + S(3)*c*sqrt(b*x**S(2) + c*x**S(4))/(S(8)*b**S(2)*x**S(3)) - S(3)*c**S(2)*atanh(sqrt(b)*x/sqrt(b*x**S(2) + c*x**S(4)))/(S(8)*b**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a + c*x**S(4)), x), x, -a**(S(3)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(6)*c**(S(5)/4)*sqrt(a + c*x**S(4))) + x*sqrt(a + c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + c*x**S(4)), x), x, sqrt(a + c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + c*x**S(4)), x), x, -a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(a + c*x**S(4))) + a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*c**(S(3)/4)*sqrt(a + c*x**S(4))) + x*sqrt(a + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + c*x**S(4)), x), x, atanh(sqrt(c)*x**S(2)/sqrt(a + c*x**S(4)))/(S(2)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + c*x**S(4)), x), x, sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt(a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a + c*x**S(4))), x), x, -atanh(sqrt(a + c*x**S(4))/sqrt(a))/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + c*x**S(4))), x), x, sqrt(c)*x*sqrt(a + c*x**S(4))/(a*(sqrt(a) + sqrt(c)*x**S(2))) - sqrt(a + c*x**S(4))/(a*x) - c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(a**(S(3)/4)*sqrt(a + c*x**S(4))) + c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*a**(S(3)/4)*sqrt(a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a + c*x**S(4))), x), x, -sqrt(a + c*x**S(4))/(S(2)*a*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a + c*x**S(4))), x), x, -sqrt(a + c*x**S(4))/(S(3)*a*x**S(3)) - c**(S(3)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(6)*a**(S(5)/4)*sqrt(a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a + b*x**S(2)), x), x, S(3)*a**S(2)*atanh(sqrt(b)*x/sqrt(a + b*x**S(2)))/(S(8)*b**(S(5)/2)) - S(3)*a*x*sqrt(a + b*x**S(2))/(S(8)*b**S(2)) + x**S(3)*sqrt(a + b*x**S(2))/(S(4)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + b*x**S(2)), x), x, -a*sqrt(a + b*x**S(2))/b**S(2) + (a + b*x**S(2))**(S(3)/2)/(S(3)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*x**S(2)), x), x, -a*atanh(sqrt(b)*x/sqrt(a + b*x**S(2)))/(S(2)*b**(S(3)/2)) + x*sqrt(a + b*x**S(2))/(S(2)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*x**S(2)), x), x, sqrt(a + b*x**S(2))/b, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b*x**S(2)), x), x, atanh(sqrt(b)*x/sqrt(a + b*x**S(2)))/sqrt(b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a + b*x**S(2))), x), x, -atanh(sqrt(a + b*x**S(2))/sqrt(a))/sqrt(a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + b*x**S(2))), x), x, -sqrt(a + b*x**S(2))/(a*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a + b*x**S(2))), x), x, -sqrt(a + b*x**S(2))/(S(2)*a*x**S(2)) + b*atanh(sqrt(a + b*x**S(2))/sqrt(a))/(S(2)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a + b*x**S(2))), x), x, -sqrt(a + b*x**S(2))/(S(3)*a*x**S(3)) + S(2)*b*sqrt(a + b*x**S(2))/(S(3)*a**S(2)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(c*x**S(4)), x), x, x*sqrt(c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(c*x**S(4)), x), x, sqrt(c*x**S(4))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(c*x**S(4)), x), x, x**S(3)/sqrt(c*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(c*x**S(4)), x), x, x**S(2)*log(x)/sqrt(c*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(c*x**S(4)), x), x, -x/sqrt(c*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(c*x**S(4))), x), x, -S(1)/(S(2)*sqrt(c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(c*x**S(4))), x), x, -S(1)/(S(3)*x*sqrt(c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(c*x**S(4))), x), x, -S(1)/(S(4)*x**S(2)*sqrt(c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(c*x**S(4))), x), x, -S(1)/(S(5)*x**S(3)*sqrt(c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a), x), x, x**S(5)/(S(5)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a), x), x, x**S(4)/(S(4)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a), x), x, x**S(3)/(S(3)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a), x), x, x**S(2)/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a), x), x, x/sqrt(a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a)*x), x), x, log(x)/sqrt(a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a)*x**S(2)), x), x, -S(1)/(sqrt(a)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a)*x**S(3)), x), x, -S(1)/(S(2)*sqrt(a)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a)*x**S(4)), x), x, -S(1)/(S(3)*sqrt(a)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-x**S(4) - S(2)*x**S(2) + S(3)), x), x, sqrt(S(3))*elliptic_f(asin(x), S(-1)/3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(-x**S(4) + S(5)*x**S(2) + S(-1)), x), x, -S(21)**(S(3)/4)*elliptic_f(acos(sqrt(S(2))*x/sqrt(sqrt(S(21)) + S(5))), S(1)/2 + S(5)*sqrt(S(21))/S(42))/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*a*x**(S(7)/2)/S(7) + S(2)*b*x**(S(11)/2)/S(11) + S(2)*c*x**(S(15)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*a*x**(S(5)/2)/S(5) + S(2)*b*x**(S(9)/2)/S(9) + S(2)*c*x**(S(13)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*a*x**(S(3)/2)/S(3) + S(2)*b*x**(S(7)/2)/S(7) + S(2)*c*x**(S(11)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/sqrt(x), x), x, S(2)*a*sqrt(x) + S(2)*b*x**(S(5)/2)/S(5) + S(2)*c*x**(S(9)/2)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**(S(3)/2), x), x, -S(2)*a/sqrt(x) + S(2)*b*x**(S(3)/2)/S(3) + S(2)*c*x**(S(7)/2)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**(S(5)/2), x), x, -S(2)*a/(S(3)*x**(S(3)/2)) + S(2)*b*sqrt(x) + S(2)*c*x**(S(5)/2)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/x**(S(7)/2), x), x, -S(2)*a/(S(5)*x**(S(5)/2)) - S(2)*b/sqrt(x) + S(2)*c*x**(S(3)/2)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*a**S(2)*x**(S(7)/2)/S(7) + S(4)*a*b*x**(S(11)/2)/S(11) + S(4)*b*c*x**(S(19)/2)/S(19) + S(2)*c**S(2)*x**(S(23)/2)/S(23) + x**(S(15)/2)*(S(4)*a*c/S(15) + S(2)*b**S(2)/S(15)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*a**S(2)*x**(S(5)/2)/S(5) + S(4)*a*b*x**(S(9)/2)/S(9) + S(4)*b*c*x**(S(17)/2)/S(17) + S(2)*c**S(2)*x**(S(21)/2)/S(21) + x**(S(13)/2)*(S(4)*a*c/S(13) + S(2)*b**S(2)/S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)*a**S(2)*x**(S(3)/2)/S(3) + S(4)*a*b*x**(S(7)/2)/S(7) + S(4)*b*c*x**(S(15)/2)/S(15) + S(2)*c**S(2)*x**(S(19)/2)/S(19) + x**(S(11)/2)*(S(4)*a*c/S(11) + S(2)*b**S(2)/S(11)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/sqrt(x), x), x, S(2)*a**S(2)*sqrt(x) + S(4)*a*b*x**(S(5)/2)/S(5) + S(4)*b*c*x**(S(13)/2)/S(13) + S(2)*c**S(2)*x**(S(17)/2)/S(17) + x**(S(9)/2)*(S(4)*a*c/S(9) + S(2)*b**S(2)/S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**(S(3)/2), x), x, -S(2)*a**S(2)/sqrt(x) + S(4)*a*b*x**(S(3)/2)/S(3) + S(4)*b*c*x**(S(11)/2)/S(11) + S(2)*c**S(2)*x**(S(15)/2)/S(15) + x**(S(7)/2)*(S(4)*a*c/S(7) + S(2)*b**S(2)/S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**(S(5)/2), x), x, -S(2)*a**S(2)/(S(3)*x**(S(3)/2)) + S(4)*a*b*sqrt(x) + S(4)*b*c*x**(S(9)/2)/S(9) + S(2)*c**S(2)*x**(S(13)/2)/S(13) + x**(S(5)/2)*(S(4)*a*c/S(5) + S(2)*b**S(2)/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/x**(S(7)/2), x), x, -S(2)*a**S(2)/(S(5)*x**(S(5)/2)) - S(4)*a*b/sqrt(x) + S(4)*b*c*x**(S(7)/2)/S(7) + S(2)*c**S(2)*x**(S(11)/2)/S(11) + x**(S(3)/2)*(S(4)*a*c/S(3) + S(2)*b**S(2)/S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*a**S(3)*x**(S(7)/2)/S(7) + S(6)*a**S(2)*b*x**(S(11)/2)/S(11) + S(2)*a*x**(S(15)/2)*(a*c + b**S(2))/S(5) + S(2)*b*c**S(2)*x**(S(27)/2)/S(9) + S(2)*b*x**(S(19)/2)*(S(6)*a*c + b**S(2))/S(19) + S(2)*c**S(3)*x**(S(31)/2)/S(31) + S(6)*c*x**(S(23)/2)*(a*c + b**S(2))/S(23), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*a**S(3)*x**(S(5)/2)/S(5) + S(2)*a**S(2)*b*x**(S(9)/2)/S(3) + S(6)*a*x**(S(13)/2)*(a*c + b**S(2))/S(13) + S(6)*b*c**S(2)*x**(S(25)/2)/S(25) + S(2)*b*x**(S(17)/2)*(S(6)*a*c + b**S(2))/S(17) + S(2)*c**S(3)*x**(S(29)/2)/S(29) + S(2)*c*x**(S(21)/2)*(a*c + b**S(2))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(2)*a**S(3)*x**(S(3)/2)/S(3) + S(6)*a**S(2)*b*x**(S(7)/2)/S(7) + S(6)*a*x**(S(11)/2)*(a*c + b**S(2))/S(11) + S(6)*b*c**S(2)*x**(S(23)/2)/S(23) + S(2)*b*x**(S(15)/2)*(S(6)*a*c + b**S(2))/S(15) + S(2)*c**S(3)*x**(S(27)/2)/S(27) + S(6)*c*x**(S(19)/2)*(a*c + b**S(2))/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/sqrt(x), x), x, S(2)*a**S(3)*sqrt(x) + S(6)*a**S(2)*b*x**(S(5)/2)/S(5) + S(2)*a*x**(S(9)/2)*(a*c + b**S(2))/S(3) + S(2)*b*c**S(2)*x**(S(21)/2)/S(7) + S(2)*b*x**(S(13)/2)*(S(6)*a*c + b**S(2))/S(13) + S(2)*c**S(3)*x**(S(25)/2)/S(25) + S(6)*c*x**(S(17)/2)*(a*c + b**S(2))/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**(S(3)/2), x), x, -S(2)*a**S(3)/sqrt(x) + S(2)*a**S(2)*b*x**(S(3)/2) + S(6)*a*x**(S(7)/2)*(a*c + b**S(2))/S(7) + S(6)*b*c**S(2)*x**(S(19)/2)/S(19) + S(2)*b*x**(S(11)/2)*(S(6)*a*c + b**S(2))/S(11) + S(2)*c**S(3)*x**(S(23)/2)/S(23) + S(2)*c*x**(S(15)/2)*(a*c + b**S(2))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**(S(5)/2), x), x, -S(2)*a**S(3)/(S(3)*x**(S(3)/2)) + S(6)*a**S(2)*b*sqrt(x) + S(6)*a*x**(S(5)/2)*(a*c + b**S(2))/S(5) + S(6)*b*c**S(2)*x**(S(17)/2)/S(17) + S(2)*b*x**(S(9)/2)*(S(6)*a*c + b**S(2))/S(9) + S(2)*c**S(3)*x**(S(21)/2)/S(21) + S(6)*c*x**(S(13)/2)*(a*c + b**S(2))/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(3)/x**(S(7)/2), x), x, -S(2)*a**S(3)/(S(5)*x**(S(5)/2)) - S(6)*a**S(2)*b/sqrt(x) + S(2)*a*x**(S(3)/2)*(a*c + b**S(2)) + S(2)*b*c**S(2)*x**(S(15)/2)/S(5) + S(2)*b*x**(S(7)/2)*(S(6)*a*c + b**S(2))/S(7) + S(2)*c**S(3)*x**(S(19)/2)/S(19) + S(6)*c*x**(S(11)/2)*(a*c + b**S(2))/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*x**(S(3)/2)/(S(3)*c) - S(2)**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*sqrt(x)/c + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(a + b*x**S(2) + c*x**S(4)), x), x, -S(2)**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(a + b*x**S(2) + c*x**S(4)), x), x, S(2)**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(a + b*x**S(2) + c*x**S(4)), x), x, S(2)**(S(1)/4)*c**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*c**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/((-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(2)**(S(1)/4)*c**(S(1)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*c**(S(1)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*c**(S(1)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*c**(S(1)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)/(a*sqrt(x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(5)/2)*(a + b*x**S(2) + c*x**S(4))), x), x, S(2)**(S(3)/4)*c**(S(3)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) - S(2)/(S(3)*a*x**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(7)/2)*(a + b*x**S(2) + c*x**S(4))), x), x, -S(2)/(S(5)*a*x**(S(5)/2)) + S(2)*b/(a**S(2)*sqrt(x)) + S(2)**(S(1)/4)*c**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*c**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*c**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*c**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*x**(S(3)/2)/(S(2)*c*(-S(4)*a*c + b**S(2))) + x**(S(7)/2)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) - S(2)**(S(1)/4)*(-S(20)*a*b*c + S(3)*b**S(3) - (-S(14)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(1)/4)*(-S(20)*a*b*c + S(3)*b**S(3) - (-S(14)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(1)/4)*(-S(20)*a*b*c + S(3)*b**S(3) + (-S(14)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(1)/4)*(-S(20)*a*b*c + S(3)*b**S(3) + (-S(14)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -b*sqrt(x)/(S(2)*c*(-S(4)*a*c + b**S(2))) + x**(S(5)/2)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) - S(2)**(S(3)/4)*(-S(10)*a*c + b**S(2) - b*(-S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-S(10)*a*c + b**S(2) - b*(-S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-S(10)*a*c + b**S(2) + b*(-S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-S(10)*a*c + b**S(2) + b*(-S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, x**(S(3)/2)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + S(2)**(S(1)/4)*(b - (S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*(b - (S(12)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*(S(12)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(1)/4)*(S(12)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, sqrt(x)*(S(2)*a + b*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))) + S(2)**(S(3)/4)*(S(4)*a*c + S(3)*b**S(2) - S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(3)/4)*(S(4)*a*c + S(3)*b**S(2) - S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(3)/4)*(S(4)*a*c + S(3)*b**S(2) + S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(3)/4)*(S(4)*a*c + S(3)*b**S(2) + S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*c**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)**(S(1)/4)*c**(S(1)/4)*(S(4)*b - sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(1)/4)*c**(S(1)/4)*(S(4)*b - sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(1)/4)*c**(S(1)/4)*(S(4)*b + sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(1)/4)*c**(S(1)/4)*(S(4)*b + sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - x**(S(3)/2)*(b + S(2)*c*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)**(S(3)/4)*c**(S(3)/4)*(-S(4)*b/sqrt(-S(4)*a*c + b**S(2)) + S(3))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*(-S(4)*b/sqrt(-S(4)*a*c + b**S(2)) + S(3))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*(S(4)*b/sqrt(-S(4)*a*c + b**S(2)) + S(3))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*(S(4)*b/sqrt(-S(4)*a*c + b**S(2)) + S(3))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))) - sqrt(x)*(b + S(2)*c*x**S(2))/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, S(2)**(S(1)/4)*c**(S(1)/4)*(b + (-S(20)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*(b + (-S(20)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*c**(S(1)/4)*(b - (-S(20)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*(b - (-S(20)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))) + x**(S(3)/2)*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, -S(2)**(S(3)/4)*c**(S(3)/4)*(-S(28)*a*c + S(3)*b**S(2) + S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(3)/4)*c**(S(3)/4)*(-S(28)*a*c + S(3)*b**S(2) + S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-S(28)*a*c + S(3)*b**S(2) - S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-S(28)*a*c + S(3)*b**S(2) - S(3)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(x)*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*sqrt(x)*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) - S(2)**(S(1)/4)*c**(S(1)/4)*(-S(28)*a*b*c + S(5)*b**S(3) + (-S(18)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(1)/4)*c**(S(1)/4)*(-S(28)*a*b*c + S(5)*b**S(3) + (-S(18)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + S(2)**(S(1)/4)*c**(S(1)/4)*(-S(28)*a*b*c + S(5)*b**S(3) - (-S(18)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - S(2)**(S(1)/4)*c**(S(1)/4)*(-S(28)*a*b*c + S(5)*b**S(3) - (-S(18)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(8)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) - (-S(18)*a*c + S(5)*b**S(2))/(S(2)*a**S(2)*sqrt(x)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(15)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**(S(9)/2)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + S(3)*x**(S(5)/2)*(S(8)*a*b + x**S(2)*(S(12)*a*c + b**S(2)))/(S(16)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - sqrt(x)*(S(36)*a*c + S(3)*b**S(2))/(S(16)*c*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(-S(84)*a*b*c + S(3)*b**S(3) - S(3)*(-S(24)*a**S(2)*c**S(2) - S(30)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(-S(84)*a*b*c + S(3)*b**S(3) - S(3)*(-S(24)*a**S(2)*c**S(2) - S(30)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(-S(84)*a*b*c + S(3)*b**S(3) + S(3)*(-S(24)*a**S(2)*c**S(2) - S(30)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(-S(84)*a*b*c + S(3)*b**S(3) + S(3)*(-S(24)*a**S(2)*c**S(2) - S(30)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(13)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**(S(7)/2)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + x**(S(3)/2)*(S(24)*a*b + x**S(2)*(S(28)*a*c + S(5)*b**S(2)))/(S(16)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) + S(2)**(S(1)/4)*(S(28)*a*c + S(5)*b**S(2) - (S(172)*a*b*c + S(5)*b**S(3))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(1)/4)*(S(28)*a*c + S(5)*b**S(2) - (S(172)*a*b*c + S(5)*b**S(3))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**S(2)) + S(2)**(S(1)/4)*(S(172)*a*b*c + S(5)*b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(28)*a*c + S(5)*b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(2)**(S(1)/4)*(S(172)*a*b*c + S(5)*b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(28)*a*c + S(5)*b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(11)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**(S(5)/2)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + sqrt(x)*(S(24)*a*b + x**S(2)*(S(20)*a*c + S(7)*b**S(2)))/(S(16)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))) - S(2)**(S(3)/4)*(S(60)*a*c + S(21)*b**S(2) - S(3)*(S(36)*a*b*c + S(7)*b**S(3))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(S(60)*a*c + S(21)*b**S(2) - S(3)*(S(36)*a*b*c + S(7)*b**S(3))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(2)**(S(3)/4)*(S(108)*a*b*c + S(21)*b**S(3) + S(3)*sqrt(-S(4)*a*c + b**S(2))*(S(20)*a*c + S(7)*b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(2)**(S(3)/4)*(S(108)*a*b*c + S(21)*b**S(3) + S(3)*sqrt(-S(4)*a*c + b**S(2))*(S(20)*a*c + S(7)*b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*c**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(9)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(20)*a*c + S(11)*b**S(2) - S(4)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(20)*a*c + S(11)*b**S(2) - S(4)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(20)*a*c + S(11)*b**S(2) + S(4)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(20)*a*c + S(11)*b**S(2) + S(4)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x**(S(3)/2)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) - S(3)*x**(S(3)/2)*(-S(4)*a*c + S(5)*b**S(2) + S(8)*b*c*x**S(2))/(S(16)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(7)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -S(2)**(S(3)/4)*c**(S(3)/4)*(S(28)*a*c + S(41)*b**S(2) - S(36)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(2)**(S(3)/4)*c**(S(3)/4)*(S(28)*a*c + S(41)*b**S(2) - S(36)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(2)**(S(3)/4)*c**(S(3)/4)*(S(28)*a*c + S(41)*b**S(2) + S(36)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(2)**(S(3)/4)*c**(S(3)/4)*(S(28)*a*c + S(41)*b**S(2) + S(36)*b*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(32)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + sqrt(x)*(S(2)*a + b*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) - sqrt(x)*(-S(4)*a*c + S(13)*b**S(2) + S(24)*b*c*x**S(2))/(S(16)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(5)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -x**(S(3)/2)*(b + S(2)*c*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(-S(68)*a*b*c + b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(12)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(-S(68)*a*b*c + b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(12)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(68)*a*b*c/sqrt(-S(4)*a*c + b**S(2)) + S(12)*a*c - b**S(3)/sqrt(-S(4)*a*c + b**S(2)) + b**S(2))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*S(2)**(S(1)/4)*c**(S(1)/4)*(S(68)*a*b*c/sqrt(-S(4)*a*c + b**S(2)) + S(12)*a*c - b**S(3)/sqrt(-S(4)*a*c + b**S(2)) + b**S(2))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**S(2)) + S(3)*x**(S(3)/2)*(b*(S(4)*a*c + b**S(2)) + c*x**S(2)*(S(12)*a*c + b**S(2)))/(S(16)*a*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)/2)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, -sqrt(x)*(b + S(2)*c*x**S(2))/((-S(16)*a*c + S(4)*b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(-S(68)*a*b*c + b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(44)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(-S(68)*a*b*c + b**S(3) + sqrt(-S(4)*a*c + b**S(2))*(S(44)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(68)*a*b*c/sqrt(-S(4)*a*c + b**S(2)) + S(44)*a*c - b**S(3)/sqrt(-S(4)*a*c + b**S(2)) + b**S(2))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(68)*a*b*c/sqrt(-S(4)*a*c + b**S(2)) + S(44)*a*c - b**S(3)/sqrt(-S(4)*a*c + b**S(2)) + b**S(2))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(x)*(b*(S(20)*a*c + b**S(2)) + c*x**S(2)*(S(44)*a*c + b**S(2)))/(S(16)*a*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x)/(a + b*x**S(2) + c*x**S(4))**S(3), x), x, x**(S(3)/2)*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) + S(2)**(S(1)/4)*c**(S(1)/4)*(S(520)*a**S(2)*c**S(2) - S(54)*a*b**S(2)*c + S(5)*b**S(4) + b*(-S(44)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(2)**(S(1)/4)*c**(S(1)/4)*(S(520)*a**S(2)*c**S(2) - S(54)*a*b**S(2)*c + S(5)*b**S(4) + b*(-S(44)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(2)**(S(1)/4)*c**(S(1)/4)*(S(520)*a**S(2)*c**S(2) - S(54)*a*b**S(2)*c + S(5)*b**S(4) - b*(-S(44)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(2)**(S(1)/4)*c**(S(1)/4)*(S(520)*a**S(2)*c**S(2) - S(54)*a*b**S(2)*c + S(5)*b**S(4) - b*(-S(44)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x**(S(3)/2)*(S(52)*a**S(2)*c**S(2) - S(45)*a*b**S(2)*c + S(5)*b**S(4) + b*c*x**S(2)*(-S(44)*a*c + S(5)*b**S(2)))/(S(16)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(x)*(a + b*x**S(2) + c*x**S(4))**S(3)), x), x, sqrt(x)*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(4)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(280)*a**S(2)*c**S(2) - S(66)*a*b**S(2)*c + S(7)*b**S(4) + b*(-S(52)*a*c + S(7)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(280)*a**S(2)*c**S(2) - S(66)*a*b**S(2)*c + S(7)*b**S(4) + b*(-S(52)*a*c + S(7)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(280)*a**S(2)*c**S(2) - S(66)*a*b**S(2)*c + S(7)*b**S(4) - b*(-S(52)*a*c + S(7)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*S(2)**(S(3)/4)*c**(S(3)/4)*(S(280)*a**S(2)*c**S(2) - S(66)*a*b**S(2)*c + S(7)*b**S(4) - b*(-S(52)*a*c + S(7)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*sqrt(x)/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(64)*a**S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + sqrt(x)*(S(60)*a**S(2)*c**S(2) - S(55)*a*b**S(2)*c + S(7)*b**S(4) + b*c*x**S(2)*(-S(52)*a*c + S(7)*b**S(2)))/(S(16)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*(d*x)**(S(5)/2)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(5)/4, S(-1)/2, S(-1)/2, S(9)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(5)*d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*(d*x)**(S(3)/2)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(3)/4, S(-1)/2, S(-1)/2, S(7)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/sqrt(d*x), x), x, S(2)*sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(1)/4, S(-1)/2, S(-1)/2, S(5)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(2) + c*x**S(4))/(d*x)**(S(3)/2), x), x, -S(2)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(-1)/4, S(-1)/2, S(-1)/2, S(3)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(d*x)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(2)*a*(d*x)**(S(5)/2)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(5)/4, S(-3)/2, S(-3)/2, S(9)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(5)*d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(2)*a*(d*x)**(S(3)/2)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(3)/4, S(-3)/2, S(-3)/2, S(7)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/sqrt(d*x), x), x, S(2)*a*sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(1)/4, S(-3)/2, S(-3)/2, S(5)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(3)/2)/(d*x)**(S(3)/2), x), x, -S(2)*a*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(S(-1)/4, S(-3)/2, S(-3)/2, S(3)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(d*x)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*(d*x)**(S(5)/2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(5)/4, S(1)/2, S(1)/2, S(9)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(5)*d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, S(2)*(d*x)**(S(3)/2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(3)/4, S(1)/2, S(1)/2, S(7)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, S(2)*sqrt(d*x)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/4, S(1)/2, S(1)/2, S(5)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, -S(2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-1)/4, S(1)/2, S(1)/2, S(3)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**(S(3)/2)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(2)*(d*x)**(S(5)/2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(5)/4, S(3)/2, S(3)/2, S(9)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(5)*a*d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d*x)/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, S(2)*(d*x)**(S(3)/2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(3)/4, S(3)/2, S(3)/2, S(7)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*a*d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d*x)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, S(2)*sqrt(d*x)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/4, S(3)/2, S(3)/2, S(5)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*x)**(S(3)/2)*(a + b*x**S(2) + c*x**S(4))**(S(3)/2)), x), x, -S(2)*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-1)/4, S(3)/2, S(3)/2, S(3)/4, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*sqrt(d*x)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(2) + c*x**S(4))**S(3), x), x, a**S(3)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(3)*a**S(2)*b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + S(3)*a*(d*x)**(m + S(5))*(a*c + b**S(2))/(d**S(5)*(m + S(5))) + S(3)*b*c**S(2)*(d*x)**(m + S(11))/(d**S(11)*(m + S(11))) + b*(d*x)**(m + S(7))*(S(6)*a*c + b**S(2))/(d**S(7)*(m + S(7))) + c**S(3)*(d*x)**(m + S(13))/(d**S(13)*(m + S(13))) + S(3)*c*(d*x)**(m + S(9))*(a*c + b**S(2))/(d**S(9)*(m + S(9))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(2)*a*b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + S(2)*b*c*(d*x)**(m + S(7))/(d**S(7)*(m + S(7))) + c**S(2)*(d*x)**(m + S(9))/(d**S(9)*(m + S(9))) + (d*x)**(m + S(5))*(S(2)*a*c + b**S(2))/(d**S(5)*(m + S(5))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(2) + c*x**S(4)), x), x, a*(d*x)**(m + S(1))/(d*(m + S(1))) + b*(d*x)**(m + S(3))/(d**S(3)*(m + S(3))) + c*(d*x)**(m + S(5))/(d**S(5)*(m + S(5))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(2) + c*x**S(4)), x), x, -S(2)*c*(d*x)**(m + S(1))*hyper((S(1), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))) + S(2)*c*(d*x)**(m + S(1))*hyper((S(1), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))))/(d*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, -c*(d*x)**(m + S(1))*(-S(4)*a*c*(-m + S(3)) + b**S(2)*(-m + S(1)) - b*(-m + S(1))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*d*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + c*(d*x)**(m + S(1))*(-S(4)*a*c*(-m + S(3)) + b**S(2)*(-m + S(1)) + b*(-m + S(1))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), m/S(2) + S(1)/2), (m/S(2) + S(3)/2,), -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*d*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (d*x)**(m + S(1))*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*d*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p/x, x), x, S(4)**(p + S(-1))*((b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*((b + S(2)*c*x**S(2) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(-S(2)*p, -p, -p, -S(2)*p + S(1), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)))/p, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p/x**S(3), x), x, -S(2)**(S(2)*p + S(-1))*((b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*((b + S(2)*c*x**S(2) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(-S(2)*p + S(1), -p, -p, -S(2)*p + S(2), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)))/(x**S(2)*(-S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p/x**S(5), x), x, -S(4)**(p + S(-1))*((b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*((b + S(2)*c*x**S(2) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(2)))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(-S(2)*p + S(2), -p, -p, -S(2)*p + S(3), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(2)))/(x**S(4)*(-p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a + b*x**S(2) + c*x**S(4))**p, x), x, x**S(5)*(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(S(5)/2, -p, -p, S(7)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(2) + c*x**S(4))**p, x), x, x**S(3)*(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(S(3)/2, -p, -p, S(5)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p, x), x, x*(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(S(1)/2, -p, -p, S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p/x**S(2), x), x, -(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(S(-1)/2, -p, -p, S(1)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**p/x**S(4), x), x, -(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(S(-3)/2, -p, -p, S(-1)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, a*(d*x)**(m + S(1))*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(m/S(2) + S(1)/2, S(-3)/2, S(-3)/2, m/S(2) + S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*sqrt(a + b*x**S(2) + c*x**S(4)), x), x, (d*x)**(m + S(1))*sqrt(a + b*x**S(2) + c*x**S(4))*AppellF1(m/S(2) + S(1)/2, S(-1)/2, S(-1)/2, m/S(2) + S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(m/S(2) + S(1)/2, S(1)/2, S(1)/2, m/S(2) + S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(2) + c*x**S(4))**(S(3)/2), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(m/S(2) + S(1)/2, S(3)/2, S(3)/2, m/S(2) + S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*(m + S(1))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(2) + c*x**S(4))**p, x), x, (d*x)**(m + S(1))*(S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(2) + c*x**S(4))**p*AppellF1(m/S(2) + S(1)/2, -p, -p, m/S(2) + S(3)/2, -S(2)*c*x**S(2)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(2)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(3)*(a + b*x**S(2) + c*x**S(4))**p, x), x, S(2)**(p + S(-1))*b*(-(b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)))**(-p + S(-1))*(a + b*x**S(2) + c*x**S(4))**(p + S(1))*hyper((-p, p + S(1)), (p + S(2),), (b + S(2)*c*x**S(2) + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*sqrt(-S(4)*a*c + b**S(2))))/(c*(p + S(1))*sqrt(-S(4)*a*c + b**S(2))) + (a + b*x**S(2) + c*x**S(4))**(p + S(1))/(S(4)*c*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(2) + c*x**S(4))**p, x), x, -S(2)**p*(-(b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)))**(-p + S(-1))*(a + b*x**S(2) + c*x**S(4))**(p + S(1))*hyper((-p, p + S(1)), (p + S(2),), (b + S(2)*c*x**S(2) + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*sqrt(-S(4)*a*c + b**S(2))))/((p + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a*x**S(3) + b*x**S(6))**(S(5)/3), x), x, -S(3)*a*(a*x**S(3) + b*x**S(6))**(S(8)/3)/(S(88)*b**S(2)*x**S(8)) + (a*x**S(3) + b*x**S(6))**(S(8)/3)/(S(11)*b*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a*x**S(3) + b*x**S(6))**(S(2)/3), x), x, (a*x**S(3) + b*x**S(6))**(S(5)/3)/(S(5)*b*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a*x**S(3) + b*x**S(6))**(S(-2)/3), x), x, -(a*x**S(3) + b*x**S(6))**(S(1)/3)/(a*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a*x**S(3) + b*x**S(6))**(S(-5)/3), x), x, S(1)/(S(2)*a*x**S(2)*(a*x**S(3) + b*x**S(6))**(S(2)/3)) - S(3)*(a*x**S(3) + b*x**S(6))**(S(1)/3)/(S(4)*a**S(2)*x**S(5)) + S(9)*b*(a*x**S(3) + b*x**S(6))**(S(1)/3)/(S(4)*a**S(3)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6) - x**S(3)), x), x, log(-x + S(1))/S(3) - log(x**S(2) + x + S(1))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(3) + S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, S(3)*a*x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((a + b*x**S(3))*(m**S(2) + S(5)*m + S(4))) + x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(m + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, a*x**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(18)*a + S(18)*b*x**S(3)) + x**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, S(3)*a*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*a + S(40)*b*x**S(3)) + x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, S(3)*a*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*a + S(28)*b*x**S(3)) + x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, (a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, S(3)*a*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(10)*a + S(10)*b*x**S(3)) + x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, S(3)*a*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(4)*a + S(4)*b*x**S(3)) + x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x, x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(2), x), x, -S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x*(a + b*x**S(3))) + sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(3), x), x, -S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x**S(2)*(a + b*x**S(3))) + sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(4), x), x, -a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*x**S(3)*(a + b*x**S(3))) + b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(5), x), x, S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(4)*x**S(4)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(6), x), x, S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(10)*x**S(5)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(7), x), x, -(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*a*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(8), x), x, S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x**S(7)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(4)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(9), x), x, S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x**S(8)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(10), x), x, a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(18)*x**S(9)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/x**S(11), x), x, S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(70)*x**S(10)*(a + b*x**S(3))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(7)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(162)*a**S(3)*x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((a + b*x**S(3))*(m + S(7))*(m + S(10))*(m**S(2) + S(5)*m + S(4))) + S(54)*a**S(2)*x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((m + S(4))*(m + S(7))*(m + S(10))) + S(9)*a*x**(m + S(1))*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(m**S(2) + S(17)*m + S(70)) + x**(m + S(1))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(m + S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(19760)*a + S(19760)*b*x**S(3)) + S(27)*a**S(2)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(1976) + S(9)*a*x**S(10)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(304) + x**S(10)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, a**S(2)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(36)*b**S(3)) - a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(45)*b**S(3)) + x**S(6)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(18)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(10472)*a + S(10472)*b*x**S(3)) + S(27)*a**S(2)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(1309) + S(9)*a*x**S(8)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(238) + x**S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(7280)*a + S(7280)*b*x**S(3)) + S(27)*a**S(2)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(1040) + S(9)*a*x**S(7)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(208) + x**S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, -a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*b**S(2)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(15)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3080)*a + S(3080)*b*x**S(3)) + S(27)*a**S(2)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(616) + S(9)*a*x**S(5)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(154) + x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(14), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1820)*a + S(1820)*b*x**S(3)) + S(27)*a**S(2)*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(455) + S(9)*a*x**S(4)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(130) + x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(13), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, (a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(440)*a + S(440)*b*x**S(3)) + S(27)*a**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(220) + S(9)*a*x**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(88) + x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(11), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, S(81)*a**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(140)*a + S(140)*b*x**S(3)) + S(27)*a**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(140) + S(9)*a*x*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(70) + x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x, x), x, a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) + a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(6) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(2), x), x, -S(81)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x*(a + b*x**S(3))) + S(27)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(8)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(3), x), x, -S(81)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x**S(2)*(a + b*x**S(3))) + S(27)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(14)*x**S(2)) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x**S(2)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(7)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(4), x), x, S(3)*a**S(2)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + a*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)) - a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x**S(3)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(6)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(5), x), x, S(81)*a*b**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(20)*a + S(20)*b*x**S(3)) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(4)*x**S(4)) + S(27)*b**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(10) - S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(2)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(6), x), x, S(81)*a*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(20)*a + S(20)*b*x**S(3)) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(10)*x**S(5)) + S(27)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(20) - S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(10)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(7), x), x, S(3)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2)*x**S(6)) + b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)) - S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(3)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(8), x), x, -S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x**S(7)) + S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x) - S(13)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(28)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(9), x), x, -S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x**S(2)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(40)*x**S(8)) + S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(20)*x**S(2)) - S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(20)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(10), x), x, -a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*x**S(3)*(a + b*x**S(3))) + a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*x**S(9)) + b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) - S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(18)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(11), x), x, S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(140)*x**S(4)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(70)*x**S(10)) - S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(35)*x**S(4)) - S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(35)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(12), x), x, S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(440)*x**S(5)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(88)*x**S(11)) - S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(88)*x**S(5)) - S(17)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(88)*x**S(11)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(13), x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*a*x**S(12)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(14), x), x, S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1820)*x**S(7)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(130)*x**S(13)) - S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(260)*x**S(7)) - S(19)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(130)*x**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(15), x), x, S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3080)*x**S(8)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(154)*x**S(14)) - S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(385)*x**S(8)) - S(10)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(77)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(16), x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*a*x**S(15)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(60)*a**S(2)*x**S(15)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/x**S(17), x), x, S(81)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(7280)*x**S(10)*(a + b*x**S(3))) + S(9)*a*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(208)*x**S(16)) - S(27)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(728)*x**S(10)) - S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(104)*x**S(16)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(29160)*a**S(5)*x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((a + b*x**S(3))*(m + S(7))*(m + S(10))*(m + S(13))*(m + S(16))*(m**S(2) + S(5)*m + S(4))) + S(9720)*a**S(4)*x**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((m + S(4))*(m + S(7))*(m + S(10))*(m + S(13))*(m + S(16))) + S(1620)*a**S(3)*x**(m + S(1))*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/((m + S(13))*(m + S(16))*(m**S(2) + S(17)*m + S(70))) + S(180)*a**S(2)*x**(m + S(1))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/((m + S(10))*(m + S(13))*(m + S(16))) + S(15)*a*x**(m + S(1))*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(m**S(2) + S(29)*m + S(208)) + x**(m + S(1))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(m + S(16)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(13)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(14)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2063698)*a + S(2063698)*b*x**S(3)) + S(243)*a**S(4)*x**S(14)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(147407) + S(81)*a**S(3)*x**S(14)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(17342) + S(90)*a**S(2)*x**S(14)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(8671) + S(15)*a*x**S(14)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(754) + x**S(14)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(29), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(12)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(13)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1521520)*a + S(1521520)*b*x**S(3)) + S(243)*a**S(4)*x**S(13)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(117040) + S(81)*a**S(3)*x**S(13)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(14630) + S(9)*a**S(2)*x**S(13)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(770) + S(3)*a*x**S(13)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(140) + x**S(13)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(28), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, -a**S(3)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(216)*b**S(4)) + a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(7)/2)/(S(252)*b**S(4)) - a*x**S(6)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(72)*b**S(2)) + x**S(9)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(27)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(11)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(782782)*a + S(782782)*b*x**S(3)) + S(243)*a**S(4)*x**S(11)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(71162) + S(81)*a**S(3)*x**S(11)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(10166) + S(9)*a**S(2)*x**S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(598) + S(15)*a*x**S(11)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(598) + x**S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(26), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(543400)*a + S(543400)*b*x**S(3)) + S(243)*a**S(4)*x**S(10)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(54340) + S(81)*a**S(3)*x**S(10)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(8360) + S(18)*a**S(2)*x**S(10)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(1045) + S(3)*a*x**S(10)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(110) + x**S(10)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(25), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, a**S(2)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(72)*b**S(3)) - a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(7)/2)/(S(84)*b**S(3)) + x**S(6)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(24)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(240856)*a + S(240856)*b*x**S(3)) + S(243)*a**S(4)*x**S(8)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(30107) + S(81)*a**S(3)*x**S(8)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(5474) + S(9)*a**S(2)*x**S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(391) + S(3)*a*x**S(8)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(92) + x**S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(23), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(152152)*a + S(152152)*b*x**S(3)) + S(243)*a**S(4)*x**S(7)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(21736) + S(405)*a**S(3)*x**S(7)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(21736) + S(45)*a**S(2)*x**S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(1672) + S(15)*a*x**S(7)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(418) + x**S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(22), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, -a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(18)*b**S(2)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(7)/2)/(S(21)*b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(52360)*a + S(52360)*b*x**S(3)) + S(243)*a**S(4)*x**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(10472) + S(81)*a**S(3)*x**S(5)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(2618) + S(9)*a**S(2)*x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(238) + S(3)*a*x**S(5)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(68) + x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(20), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(27664)*a + S(27664)*b*x**S(3)) + S(243)*a**S(4)*x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(6916) + S(81)*a**S(3)*x**S(4)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(1976) + S(45)*a**S(2)*x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(988) + S(15)*a*x**S(4)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(304) + x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(19), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, (a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(18)*b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5236)*a + S(5236)*b*x**S(3)) + S(243)*a**S(4)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(2618) + S(405)*a**S(3)*x**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(5236) + S(90)*a**S(2)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(1309) + S(15)*a*x**S(2)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(238) + x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(17), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, S(729)*a**S(5)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1456)*a + S(1456)*b*x**S(3)) + S(243)*a**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(1456) + S(81)*a**S(3)*x*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(728) + S(9)*a**S(2)*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(104) + S(15)*a*x*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(208) + x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x, x), x, a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) + a**S(3)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(6) + a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(9) + a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(12) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(2), x), x, -S(729)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(308)*x*(a + b*x**S(3))) + S(243)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(308)*x) + S(81)*a**S(3)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(308)*x) + S(45)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(308)*x) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(154)*x) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(14)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(3), x), x, -S(729)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(182)*x**S(2)*(a + b*x**S(3))) + S(243)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(91)*x**S(2)) + S(81)*a**S(3)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(182)*x**S(2)) + S(18)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(91)*x**S(2)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(26)*x**S(2)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(13)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(4), x), x, S(5)*a**S(4)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + S(5)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) + S(5)*a**S(2)*b*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(6) + S(5)*a*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(9) - S(5)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*x**S(3)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(12)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(5), x), x, S(729)*a**S(3)*b**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(88)*a + S(88)*b*x**S(3)) + S(243)*a**S(2)*b**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(44) + S(405)*a*b**S(2)*x**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(88) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(4)*x**S(4)) + S(45)*b**S(2)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(11) - S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(6), x), x, S(729)*a**S(3)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(70)*a + S(70)*b*x**S(3)) + S(243)*a**S(2)*b**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(70) + S(81)*a*b**S(2)*x*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(35) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(2)*x**S(5)) + S(9)*b**S(2)*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(5) - S(17)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(10)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(7), x), x, S(10)*a**S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + S(10)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) + S(5)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) + S(5)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(6)*x**S(6)) + S(10)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/S(9) - (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(8), x), x, -S(729)*a**S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(56)*x*(a + b*x**S(3))) + S(243)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(56)*x) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(56)*x) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(28)*x**S(7)) + S(45)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(56)*x) - S(19)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(28)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(9), x), x, -S(729)*a**S(3)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(56)*x**S(2)*(a + b*x**S(3))) + S(243)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(28)*x**S(2)) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(56)*x**S(2)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(8)*x**S(8)) + S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(14)*x**S(2)) - (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(2)*x**S(8)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(10), x), x, S(10)*a**S(2)*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + S(10)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) - S(5)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*x**S(3)) + S(5)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(18)*x**S(9)) + S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(9)*x**S(3)) - S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(18)*x**S(9)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(11), x), x, S(729)*a*b**S(4)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(70)*a + S(70)*b*x**S(3)) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(14)*x**S(4)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(14)*x**S(10)) + S(243)*b**S(4)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(35) - S(45)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(7)*x**S(4)) - S(11)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(35)*x**S(10)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(12), x), x, S(729)*a*b**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(88)*a + S(88)*b*x**S(3)) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(44)*x**S(5)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(88)*x**S(11)) + S(243)*b**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(88) - S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(4)*x**S(5)) - S(23)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(88)*x**S(11)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(13), x), x, S(5)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) + S(5)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*x**S(6)) + S(5)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(36)*x**S(12)) + S(5)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/S(3) - S(10)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(9)*x**S(6)) - S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(9)*x**S(12)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(14), x), x, -S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(182)*x*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(182)*x**S(7)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(26)*x**S(13)) + S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(182)*x) - S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(14)*x**S(7)) - S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(26)*x**S(13)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(15), x), x, -S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(308)*x**S(2)*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(308)*x**S(8)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(154)*x**S(14)) + S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(154)*x**S(2)) - S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(22)*x**S(8)) - S(13)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(77)*x**S(14)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(16), x), x, -a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*x**S(3)*(a + b*x**S(3))) + a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6)*x**S(9)) + a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(12)*x**S(15)) + b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))*log(x)/(a + b*x**S(3)) - S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(18)*x**S(9)) - S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(20)*x**S(15)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(17), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1456)*x**S(4)*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(728)*x**S(10)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(208)*x**S(16)) - S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(364)*x**S(4)) - S(18)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(91)*x**S(10)) - S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(52)*x**S(16)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(18), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5236)*x**S(5)*(a + b*x**S(3))) + S(405)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5236)*x**S(11)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(238)*x**S(17)) - S(1215)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5236)*x**S(5)) - S(45)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(308)*x**S(11)) - S(29)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(238)*x**S(17)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(19), x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(18)*a*x**S(18)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(20), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(27664)*x**S(7)*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(1976)*x**S(13)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(304)*x**S(19)) - S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3952)*x**S(7)) - S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(104)*x**S(13)) - S(31)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(304)*x**S(19)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(21), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(52360)*x**S(8)*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(2618)*x**S(14)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(68)*x**S(20)) - S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(6545)*x**S(8)) - S(90)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(1309)*x**S(14)) - S(8)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(85)*x**S(20)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(22), x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(18)*a*x**S(21)) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(7)/2)/(S(126)*a**S(2)*x**S(21)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(23), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(152152)*x**S(10)*(a + b*x**S(3))) + S(405)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(21736)*x**S(16)) + S(15)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(418)*x**S(22)) - S(1215)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(76076)*x**S(10)) - S(45)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(988)*x**S(16)) - S(17)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(209)*x**S(22)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(24), x), x, S(729)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(240856)*x**S(11)*(a + b*x**S(3))) + S(81)*a*b**S(2)*(a + b*x**S(3))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(5474)*x**S(17)) + S(3)*a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(92)*x**S(23)) - S(243)*b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(21896)*x**S(11)) - S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)/(S(238)*x**S(17)) - S(7)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(92)*x**S(23)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/x**S(25), x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(24)*a*x**S(24)) + b*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)/(S(72)*a**S(2)*x**S(21)) - b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(7)/2)/(S(504)*a**S(3)*x**S(21)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, x**(m + S(1))*(a + b*x**S(3))*hyper((S(1), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -b*x**S(3)/a)/(a*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, a**(S(2)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - a**(S(2)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + sqrt(S(3))*a**(S(2)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + x**S(2)*(a + b*x**S(3))/(S(2)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, -a**(S(1)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + a**(S(1)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + sqrt(S(3))*a**(S(1)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + x*(a + b*x**S(3))/(b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, (a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, -(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*a**(S(1)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*a**(S(1)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6)), x), x, (a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*a**(S(2)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*a**(S(2)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*a**(S(2)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), x), x, (a + b*x**S(3))*log(x)/(a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), x), x, -(a + b*x**S(3))/(a*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*a**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*a**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + sqrt(S(3))*b**(S(1)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*a**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), x), x, (-a - b*x**S(3))/(S(2)*a*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(3)*a**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(6)*a**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + sqrt(S(3))*b**(S(2)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(3)*a**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), x), x, -b*(a + b*x**S(3))*log(x)/(a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + b*(a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*a**S(2)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, x**(m + S(1))*(a + b*x**S(3))*hyper((S(3), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -b*x**S(3)/a)/(a**S(3)*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, x**S(5)*(a + b*x**S(3))/(S(6)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) - x**S(2)/(S(18)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(4)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(54)*a**(S(4)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(4)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, x**S(4)*(a + b*x**S(3))/(S(6)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) - x/(S(9)*a*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(5)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(54)*a**(S(5)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(5)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, (-a - b*x**S(3))/(S(6)*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2), x), x, x**S(2)*(a + b*x**S(3))/(S(6)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(2)*x**S(2)/(S(9)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(27)*a**(S(7)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(2)*a + S(2)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(7)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(2)*a + S(2)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(7)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(-3)/2), x), x, x*(a + b*x**S(3))/(S(6)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(5)*x/(S(18)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(5)*a + S(5)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(8)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(5)*a + S(5)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(54)*a**(S(8)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(5)*a + S(5)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(8)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), x), x, (a + b*x**S(3))/(S(6)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(1)/(S(3)*a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(x)/(a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), x), x, (a + b*x**S(3))/(S(6)*a*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(7)/(S(18)*a**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(14)*a + S(14)*b*x**S(3))/(S(9)*a**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(14)*b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(10)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(7)*b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(27)*a**(S(10)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(14)*sqrt(S(3))*b**(S(1)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(10)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), x), x, (a + b*x**S(3))/(S(6)*a*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(4)/(S(9)*a**S(2)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(10)*a + S(10)*b*x**S(3))/(S(9)*a**S(3)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(20)*b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(27)*a**(S(11)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(10)*b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(27)*a**(S(11)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(20)*sqrt(S(3))*b**(S(2)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(27)*a**(S(11)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), x), x, (a + b*x**S(3))/(S(6)*a*x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(1)/(S(2)*a**S(2)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(3)*b*(a + b*x**S(3))*log(x)/(a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + b*(a + b*x**S(3))*log(a + b*x**S(3))/(a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(a**S(4)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, x**(m + S(1))*(a + b*x**S(3))*hyper((S(5), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -b*x**S(3)/a)/(a**S(5)*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, a*x*(a + b*x**S(3))/(S(12)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) - S(13)*x/(S(108)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + x*(a + b*x**S(3))/(S(162)*a*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(5)*x/(S(486)*a**S(2)*b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(5)*a + S(5)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(8)/3)*b**(S(7)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(5)*a + S(5)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(1458)*a**(S(8)/3)*b**(S(7)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(5)*a + S(5)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(8)/3)*b**(S(7)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, a*(a + b*x**S(3))/(S(12)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) - S(1)/(S(9)*b**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, x**S(5)*(a + b*x**S(3))/(S(12)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) - S(7)*x**S(2)/(S(108)*a*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(7)*x**S(2)*(a + b*x**S(3))/(S(324)*a**S(2)*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(7)*x**S(2)/(S(243)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(7)*a + S(7)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(10)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(7)*a + S(7)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(1458)*a**(S(10)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(7)*a + S(7)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(10)/3)*b**(S(5)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, x**S(4)*(a + b*x**S(3))/(S(12)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) - S(2)*x/(S(27)*a*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + x*(a + b*x**S(3))/(S(81)*a**S(2)*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(5)*x/(S(243)*a**S(3)*b*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(5)*a + S(5)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(729)*a**(S(11)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(10)*a + S(10)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(11)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(10)*a + S(10)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(11)/3)*b**(S(4)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, (-a - b*x**S(3))/(S(12)*b*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2), x), x, x**S(2)*(a + b*x**S(3))/(S(12)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(5)*x**S(2)/(S(54)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(35)*x**S(2)*(a + b*x**S(3))/(S(324)*a**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(35)*x**S(2)/(S(243)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(35)*a + S(35)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(13)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(35)*a + S(35)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(1458)*a**(S(13)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(35)*a + S(35)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(13)/3)*b**(S(2)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(-5)/2), x), x, x*(a + b*x**S(3))/(S(12)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(11)*x/(S(108)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(11)*x*(a + b*x**S(3))/(S(81)*a**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(55)*x/(S(243)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(55)*a + S(55)*b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(729)*a**(S(14)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (S(110)*a + S(110)*b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(14)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - sqrt(S(3))*(S(110)*a + S(110)*b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(14)/3)*b**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)), x), x, (a + b*x**S(3))/(S(12)*a*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(1)/(S(9)*a**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + (a + b*x**S(3))/(S(6)*a**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(1)/(S(3)*a**S(4)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + (a + b*x**S(3))*log(x)/(a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*a**S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)), x), x, (a + b*x**S(3))/(S(12)*a*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(13)/(S(108)*a**S(2)*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + (S(65)*a + S(65)*b*x**S(3))/(S(324)*a**S(3)*x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(455)/(S(972)*a**S(4)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(455)*a + S(455)*b*x**S(3))/(S(243)*a**S(5)*x*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(455)*b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(16)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(455)*b**(S(1)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(1458)*a**(S(16)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(455)*sqrt(S(3))*b**(S(1)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(16)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)), x), x, (a + b*x**S(3))/(S(12)*a*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(7)/(S(54)*a**S(2)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + (S(77)*a + S(77)*b*x**S(3))/(S(324)*a**S(3)*x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(154)/(S(243)*a**S(4)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - (S(385)*a + S(385)*b*x**S(3))/(S(243)*a**S(5)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(770)*b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(1)/3) + b**(S(1)/3)*x)/(S(729)*a**(S(17)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(385)*b**(S(2)/3)*(a + b*x**S(3))*log(a**(S(2)/3) - a**(S(1)/3)*b**(S(1)/3)*x + b**(S(2)/3)*x**S(2))/(S(729)*a**(S(17)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(770)*sqrt(S(3))*b**(S(2)/3)*(a + b*x**S(3))*atan(sqrt(S(3))*(a**(S(1)/3) - S(2)*b**(S(1)/3)*x)/(S(3)*a**(S(1)/3)))/(S(729)*a**(S(17)/3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)), x), x, (a + b*x**S(3))/(S(12)*a*x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(5)/2)) + S(5)/(S(36)*a**S(2)*x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + (S(5)*a + S(5)*b*x**S(3))/(S(18)*a**S(3)*x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(S(3)/2)) + S(5)/(S(6)*a**S(4)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(5)*b*(a + b*x**S(3))*log(x)/(a**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) + S(5)*b*(a + b*x**S(3))*log(a + b*x**S(3))/(S(3)*a**S(6)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))) - S(5)*sqrt(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))/(S(3)*a**S(6)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**(m + S(1))*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(1), m/S(3) + S(2)*p + S(4)/3), (m/S(3) + S(4)/3,), -b*x**S(3)/a)/(a*(m + S(1))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(x**m*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**(m + S(1))*(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((m/S(3) + S(1)/3, -S(2)*p), (m/S(3) + S(4)/3,), -b*x**S(3)/a)/(m + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, -a*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/(S(3)*b**S(2)*(S(2)*p + S(1))) + (a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**(p + S(1))/(S(6)*b**S(2)*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**S(5)*(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(5)/3, -S(2)*p), (S(8)/3,), -b*x**S(3)/a)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**S(4)*(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(4)/3, -S(2)*p), (S(7)/3,), -b*x**S(3)/a)/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, (a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/(S(3)*b*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**S(2)*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(1), S(2)*p + S(5)/3), (S(5)/3,), -b*x**S(3)/a)/(S(2)*a), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x**S(2)*(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(2)/3, -S(2)*p), (S(5)/3,), -b*x**S(3)/a)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(1), S(2)*p + S(4)/3), (S(4)/3,), -b*x**S(3)/a)/a, expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p, x), x, x*(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(1)/3, -S(2)*p), (S(4)/3,), -b*x**S(3)/a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/x, x), x, -(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(1), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**S(3)/a)/(S(3)*a*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/x**S(2), x), x, -(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(-1)/3, -S(2)*p), (S(2)/3,), -b*x**S(3)/a)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/x**S(3), x), x, -(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(-2)/3, -S(2)*p), (S(1)/3,), -b*x**S(3)/a)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/x**S(4), x), x, b*(a + b*x**S(3))*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(2), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**S(3)/a)/(S(3)*a**S(2)*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p/x**S(5), x), x, -(S(1) + b*x**S(3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**S(3) + b**S(2)*x**S(6))**p*hyper((S(-4)/3, -S(2)*p), (S(-1)/3,), -b*x**S(3)/a)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a + b*x**S(3) + c*x**S(6)), x), x, -b*log(a + b*x**S(3) + c*x**S(6))/(S(6)*c**S(2)) + x**S(3)/(S(3)*c) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/sqrt(-S(4)*a*c + b**S(2)))/(S(3)*c**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(3) + c*x**S(6)), x), x, b*atanh((b + S(2)*c*x**S(3))/sqrt(-S(4)*a*c + b**S(2)))/(S(3)*c*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*x**S(3) + c*x**S(6))/(S(6)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(3) + c*x**S(6)), x), x, -S(2)*atanh((b + S(2)*c*x**S(3))/sqrt(-S(4)*a*c + b**S(2)))/(S(3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(3) + c*x**S(6))), x), x, b*atanh((b + S(2)*c*x**S(3))/sqrt(-S(4)*a*c + b**S(2)))/(S(3)*a*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a + b*x**S(3) + c*x**S(6))/(S(6)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a + b*x**S(3) + c*x**S(6))), x), x, -S(1)/(S(3)*a*x**S(3)) - b*log(x)/a**S(2) + b*log(a + b*x**S(3) + c*x**S(6))/(S(6)*a**S(2)) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/sqrt(-S(4)*a*c + b**S(2)))/(S(3)*a**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(3) + c*x**S(6)), x), x, x**S(2)/(S(2)*c) + S(2)**(S(1)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(5)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) - S(2)**(S(1)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(5)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*sqrt(S(3))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(5)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(5)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) - S(2)**(S(1)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(5)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*sqrt(S(3))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(5)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(3) + c*x**S(6)), x), x, x/c - S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(3) + c*x**S(6)), x), x, S(2)**(S(1)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/3)*sqrt(S(3))*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*sqrt(S(3))*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(3) + c*x**S(6)), x), x, -S(2)**(S(2)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*sqrt(S(3))*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*sqrt(S(3))*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(3) + c*x**S(6)), x), x, S(2)**(S(1)/3)*c**(S(1)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*c**(S(1)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(6)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/3)*sqrt(S(3))*c**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*c**(S(1)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/3)*c**(S(1)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(6)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/3)*sqrt(S(3))*c**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a + b*x**S(3) + c*x**S(6)), x), x, -S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(6)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(6)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(3) + c*x**S(6))), x), x, S(2)**(S(1)/3)*c**(S(1)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) - S(2)**(S(1)/3)*c**(S(1)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*sqrt(S(3))*c**(S(1)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*c**(S(1)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) - S(2)**(S(1)/3)*c**(S(1)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) + S(2)**(S(1)/3)*sqrt(S(3))*c**(S(1)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3)) - S(1)/(a*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(3) + c*x**S(6))), x), x, -S(2)**(S(2)/3)*c**(S(2)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*c**(S(2)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*a*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*c**(S(2)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*c**(S(2)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*a*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(1)/(S(2)*a*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x**S(6)/S(6) - S(4)*x**S(3)/S(3) - log(x**S(3) + S(1))/S(6) + S(9)*log(x**S(3) + S(3))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x**S(3)/S(3) + log(x**S(3) + S(1))/S(6) - S(3)*log(x**S(3) + S(3))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, -log(x**S(3) + S(1))/S(6) + log(x**S(3) + S(3))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, -atanh(x**S(3) + S(2))/S(3), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(x**S(2)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, log(x**S(3) + S(1))/S(6) - log(x**S(3) + S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, log(x)/S(3) - log(x**S(3) + S(1))/S(6) + log(x**S(3) + S(3))/S(18), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, -S(4)*log(x)/S(9) + log(x**S(3) + S(1))/S(6) - log(x**S(3) + S(3))/S(54) - S(1)/(S(9)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, S(13)*log(x)/S(27) - log(x**S(3) + S(1))/S(6) + log(x**S(3) + S(3))/S(162) + S(4)/(S(27)*x**S(3)) - S(1)/(S(18)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x**S(5)/S(5) - S(2)*x**S(2) + log(x + S(1))/S(6) - S(3)*S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(2) - log(x**S(2) - x + S(1))/S(12) + S(3)*S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(4) - S(9)*S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(2) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x**S(4)/S(4) - S(4)*x - log(x + S(1))/S(6) + S(3)*S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(2) + log(x**S(2) - x + S(1))/S(12) - S(3)*S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(4) - S(3)*S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(2) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x**S(2)/S(2) - log(x + S(1))/S(6) + S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(2) + log(x**S(2) - x + S(1))/S(12) - S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(4) + S(3)*S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(2) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, x + log(x + S(1))/S(6) - S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(2) - log(x**S(2) - x + S(1))/S(12) + S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(4) + S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(2) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, log(x + S(1))/S(6) - S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(6) - log(x**S(2) - x + S(1))/S(12) + S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(12) - S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(2) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, -log(x + S(1))/S(6) + S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(6) + log(x**S(2) - x + S(1))/S(12) - S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(12) - S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, -log(x + S(1))/S(6) + S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(18) + log(x**S(2) - x + S(1))/S(12) - S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(36) + S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6) + S(4)*x**S(3) + S(3)), x), x, log(x + S(1))/S(6) - S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(18) - log(x**S(2) - x + S(1))/S(12) + S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(36) + S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(18) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, log(x + S(1))/S(6) - S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(54) - log(x**S(2) - x + S(1))/S(12) + S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(108) - S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(18) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) - S(1)/(S(3)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, -log(x + S(1))/S(6) + S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(54) + log(x**S(2) - x + S(1))/S(12) - S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(108) - S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(54) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) - S(1)/(S(6)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, -log(x + S(1))/S(6) + S(3)**(S(2)/3)*log(x + S(3)**(S(1)/3))/S(162) + log(x**S(2) - x + S(1))/S(12) - S(3)**(S(2)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(324) + S(3)**(S(1)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(54) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + S(4)/(S(9)*x) - S(1)/(S(12)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(6) + S(4)*x**S(3) + S(3))), x), x, log(x + S(1))/S(6) - S(3)**(S(1)/3)*log(x + S(3)**(S(1)/3))/S(162) - log(x**S(2) - x + S(1))/S(12) + S(3)**(S(1)/3)*log(x**S(2) - S(3)**(S(1)/3)*x + S(3)**(S(2)/3))/S(324) + S(3)**(S(5)/6)*atan(S(3)**(S(1)/6)*(-S(2)*x + S(3)**(S(1)/3))/S(3))/S(162) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + S(2)/(S(9)*x**S(2)) - S(1)/(S(15)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(6) - x**S(3) + S(1)), x), x, x + S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(6) - x**S(3) + S(1)), x), x, log(x**S(6) - x**S(3) + S(1))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(3) + S(1))/S(3))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(6) - x**S(3) + S(1)), x), x, S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(6) - x**S(3) + S(1)), x), x, S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(6) - x**S(3) + S(1)), x), x, -S(2)*sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(3) + S(1))/S(3))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(6) - x**S(3) + S(1)), x), x, sqrt(S(3))*I*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(9)*(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3)) - sqrt(S(3))*I*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(9)*(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3)) - S(2)**(S(1)/3)*sqrt(S(3))*I*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*sqrt(S(3))*I*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) + I*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(3)*(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3)) - I*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(3)*(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6) - x**S(3) + S(1)), x), x, -(S(-1))**(S(5)/18)*sqrt(S(3))*(S(3)*log(-x + (S(-1))**(S(1)/9)) + log(S(2)))/S(27) + (S(-1))**(S(13)/18)*sqrt(S(3))*log(-S(2)**(S(1)/3)*(x + (S(-1))**(S(8)/9)))/S(9) - (S(-1))**(S(13)/18)*sqrt(S(3))*log(-S(2)**(S(2)/3)*(x*(-x + (S(-1))**(S(8)/9)) + (S(-1))**(S(7)/9)))/S(18) + (S(-1))**(S(5)/18)*sqrt(S(3))*log(S(2)**(S(2)/3)*(x*(x + (S(-1))**(S(1)/9)) + (S(-1))**(S(2)/9)))/S(18) - (S(-1))**(S(13)/18)*atan(sqrt(S(3))*(S(2)*(S(-1))**(S(1)/9)*x + S(1))/S(3))/S(3) + (S(-1))**(S(5)/18)*atan(sqrt(S(3))*(-S(2)*(S(-1))**(S(8)/9)*x + S(1))/S(3))/S(3), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/(x**S(6) - x**S(3) + S(1)), x), x, sqrt(S(3))*I*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(9)*(S(1)/2 - sqrt(S(3))*I/S(2))**(S(2)/3)) - sqrt(S(3))*I*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(9)*(S(1)/2 + sqrt(S(3))*I/S(2))**(S(2)/3)) - S(2)**(S(2)/3)*sqrt(S(3))*I*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*I*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - I*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(3)*(S(1)/2 - sqrt(S(3))*I/S(2))**(S(2)/3)) + I*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(3)*(S(1)/2 + sqrt(S(3))*I/S(2))**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(6) - x**S(3) + S(1))), x), x, log(x) - log(x**S(6) - x**S(3) + S(1))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(3) + S(1))/S(3))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(6) - x**S(3) + S(1))), x), x, -S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) - S(1)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(6) - x**S(3) + S(1))), x), x, -S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(2)/3)) - S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(6) - x**S(3) + S(1))), x), x, log(x) - log(x**S(6) - x**S(3) + S(1))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(3) + S(1))/S(3))/S(9) - S(1)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(6) - x**S(3) + S(1))), x), x, -S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) - sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(-S(2)**(S(1)/3)*x + (S(1) + sqrt(S(3))*I)**(S(1)/3))/(S(18)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(S(3) + sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) - S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) - sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(S(3) - sqrt(S(3))*I)*log(S(2)**(S(2)/3)*x**S(2) + x*(S(2) + S(2)*sqrt(S(3))*I)**(S(1)/3) + (S(1) + sqrt(S(3))*I)**(S(2)/3))/(S(36)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) - S(2)**(S(1)/3)*(sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 - sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) - sqrt(S(3))*I)**(S(1)/3)) + S(2)**(S(1)/3)*(-sqrt(S(3)) + I)*atan(sqrt(S(3))*(S(2)*x/(S(1)/2 + sqrt(S(3))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(6)*(S(1) + sqrt(S(3))*I)**(S(1)/3)) - S(1)/x - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6) + x**S(3) + S(2)), x), x, -sqrt(S(7))*I*log(S(2)**(S(1)/3)*x + (S(1) - sqrt(S(7))*I)**(S(1)/3))/(S(21)*(S(1)/2 - sqrt(S(7))*I/S(2))**(S(2)/3)) + sqrt(S(7))*I*log(S(2)**(S(1)/3)*x + (S(1) + sqrt(S(7))*I)**(S(1)/3))/(S(21)*(S(1)/2 + sqrt(S(7))*I/S(2))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(7))*I*log(S(2)**(S(2)/3)*x**S(2) - x*(S(2) - S(2)*sqrt(S(7))*I)**(S(1)/3) + (S(1) - sqrt(S(7))*I)**(S(2)/3))/(S(42)*(S(1) - sqrt(S(7))*I)**(S(2)/3)) - S(2)**(S(2)/3)*sqrt(S(7))*I*log(S(2)**(S(2)/3)*x**S(2) - x*(S(2) + S(2)*sqrt(S(7))*I)**(S(1)/3) + (S(1) + sqrt(S(7))*I)**(S(2)/3))/(S(42)*(S(1) + sqrt(S(7))*I)**(S(2)/3)) + sqrt(S(21))*I*atan(sqrt(S(3))*(-S(2)*x/(S(1)/2 - sqrt(S(7))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(21)*(S(1)/2 - sqrt(S(7))*I/S(2))**(S(2)/3)) - sqrt(S(21))*I*atan(sqrt(S(3))*(-S(2)*x/(S(1)/2 + sqrt(S(7))*I/S(2))**(S(1)/3) + S(1))/S(3))/(S(21)*(S(1)/2 + sqrt(S(7))*I/S(2))**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(6) + x**S(3) + S(2)), x), x, S(2)*sqrt(S(7))*atan(sqrt(S(7))*(S(2)*x**S(3) + S(1))/S(7))/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(6) + x**S(3) + S(2)), x), x, S(2)**(S(2)/3)*(S(7) + sqrt(S(7))*I)*log(S(2)**(S(1)/3)*x + (S(1) - sqrt(S(7))*I)**(S(1)/3))/(S(42)*(S(1) - sqrt(S(7))*I)**(S(2)/3)) + S(2)**(S(2)/3)*(S(7) - sqrt(S(7))*I)*log(S(2)**(S(1)/3)*x + (S(1) + sqrt(S(7))*I)**(S(1)/3))/(S(42)*(S(1) + sqrt(S(7))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(7) + sqrt(S(7))*I)*log(S(2)**(S(2)/3)*x**S(2) - x*(S(2) - S(2)*sqrt(S(7))*I)**(S(1)/3) + (S(1) - sqrt(S(7))*I)**(S(2)/3))/(S(84)*(S(1) - sqrt(S(7))*I)**(S(2)/3)) - S(2)**(S(2)/3)*(S(7) - sqrt(S(7))*I)*log(S(2)**(S(2)/3)*x**S(2) - x*(S(2) + S(2)*sqrt(S(7))*I)**(S(1)/3) + (S(1) + sqrt(S(7))*I)**(S(2)/3))/(S(84)*(S(1) + sqrt(S(7))*I)**(S(2)/3)) - sqrt(S(21))*I*(S(1)/2 - sqrt(S(7))*I/S(2))**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*x/(S(1)/2 - sqrt(S(7))*I/S(2))**(S(1)/3) + S(1))/S(3))/S(21) + sqrt(S(21))*I*(S(1)/2 + sqrt(S(7))*I/S(2))**(S(1)/3)*atan(sqrt(S(3))*(-S(2)*x/(S(1)/2 + sqrt(S(7))*I/S(2))**(S(1)/3) + S(1))/S(3))/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(14)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*x**S(6)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(20)*c**S(2)) + x**S(9)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(18)*c) - (S(7)*b*(-S(28)*a*c + S(15)*b**S(2)) - S(6)*c*x**S(3)*(-S(20)*a*c + S(21)*b**S(2)))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(2880)*c**S(4)) + (b + S(2)*c*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))*(S(16)*a**S(2)*c**S(2) - S(56)*a*b**S(2)*c + S(21)*b**S(4))/(S(1536)*c**S(5)) - (-S(4)*a*c + b**S(2))*(S(16)*a**S(2)*c**S(2) - S(56)*a*b**S(2)*c + S(21)*b**S(4))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3072)*c**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*(b + S(2)*c*x**S(3))*(-S(12)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(384)*c**S(4)) + b*(-S(12)*a*c + S(7)*b**S(2))*(-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(768)*c**(S(9)/2)) + x**S(6)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(15)*c) + (a + b*x**S(3) + c*x**S(6))**(S(3)/2)*(-S(32)*a*c + S(35)*b**S(2) - S(42)*b*c*x**S(3))/(S(720)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -S(5)*b*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(72)*c**S(2)) + x**S(3)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(12)*c) + (b + S(2)*c*x**S(3))*(-S(4)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(192)*c**S(3)) - (-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(5)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(384)*c**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*(b + S(2)*c*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(24)*c**S(2)) + b*(-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*c**(S(5)/2)) + (a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(9)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, (b + S(2)*c*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*c) - (-S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(24)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x, x), x, -sqrt(a)*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(3) + b*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(6)*sqrt(c)) + sqrt(a + b*x**S(3) + c*x**S(6))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(4), x), x, sqrt(c)*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(3) - sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*x**S(3)) - b*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(6)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(7), x), x, -(S(2)*a + b*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*a*x**S(6)) + (-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(24)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(10), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(9)*a*x**S(9)) + b*(S(2)*a + b*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(24)*a**S(2)*x**S(6)) - b*(-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(13), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(12)*a*x**S(12)) + S(5)*b*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(72)*a**S(2)*x**S(9)) - (S(2)*a + b*x**S(3))*(-S(4)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(192)*a**S(3)*x**S(6)) + (-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(5)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(384)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(16), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(15)*a*x**S(15)) + S(7)*b*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(120)*a**S(2)*x**S(12)) - (-S(32)*a*c + S(35)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(720)*a**S(3)*x**S(9)) + b*(S(2)*a + b*x**S(3))*(-S(12)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(384)*a**S(4)*x**S(6)) - b*(-S(12)*a*c + S(7)*b**S(2))*(-S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(768)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(3)*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x**S(4)*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(4)/3, S(-1)/2, S(-1)/2, S(7)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(2)/3, S(-1)/2, S(-1)/2, S(5)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(1)/3, S(-1)/2, S(-1)/2, S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(2), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(-1)/3, S(-1)/2, S(-1)/2, S(2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**S(3) + c*x**S(6))/x**S(3), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(-2)/3, S(-1)/2, S(-1)/2, S(1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(3)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, a*x**S(4)*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(4)/3, S(-3)/2, S(-3)/2, S(7)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, a*x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(2)/3, S(-3)/2, S(-3)/2, S(5)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, a*x*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(1)/3, S(-3)/2, S(-3)/2, S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(2), x), x, -a*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(-1)/3, S(-3)/2, S(-3)/2, S(2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(3), x), x, -a*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(S(-2)/3, S(-3)/2, S(-3)/2, S(1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x**S(4)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(4)/3, S(1)/2, S(1)/2, S(7)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x**S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/3, S(1)/2, S(1)/2, S(5)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, x*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/3, S(1)/2, S(1)/2, S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/sqrt(a + b*x**S(3) + c*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-1)/3, S(1)/2, S(1)/2, S(2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-2)/3, S(1)/2, S(1)/2, S(1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, x**S(4)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(4)/3, S(3)/2, S(3)/2, S(7)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, x**S(2)*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/3, S(3)/2, S(3)/2, S(5)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(-3)/2), x), x, x*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/3, S(3)/2, S(3)/2, S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, -sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-1)/3, S(3)/2, S(3)/2, S(2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*x*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, -sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(-2)/3, S(3)/2, S(3)/2, S(1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*x**S(2)*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, a*(d*x)**(m + S(1))*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(m/S(3) + S(1)/3, S(-3)/2, S(-3)/2, m/S(3) + S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*sqrt(a + b*x**S(3) + c*x**S(6)), x), x, (d*x)**(m + S(1))*sqrt(a + b*x**S(3) + c*x**S(6))*AppellF1(m/S(3) + S(1)/3, S(-1)/2, S(-1)/2, m/S(3) + S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(m/S(3) + S(1)/3, S(1)/2, S(1)/2, m/S(3) + S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(m/S(3) + S(1)/3, S(3)/2, S(3)/2, m/S(3) + S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*(m + S(1))*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(3) + c*x**S(6))**p, x), x, (d*x)**(m + S(1))*(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(m/S(3) + S(1)/3, -p, -p, m/S(3) + S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)*(a + b*x**S(3) + c*x**S(6))**p, x), x, x**S(5)*(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(5)/3, -p, -p, S(8)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a + b*x**S(3) + c*x**S(6))**p, x), x, x**S(4)*(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(4)/3, -p, -p, S(7)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**S(3) + c*x**S(6))**p, x), x, x**S(2)*(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(2)/3, -p, -p, S(5)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p, x), x, x*(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(1)/3, -p, -p, S(4)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x, x), x, S(2)**(S(2)*p + S(-1))*((b + S(2)*c*x**S(3) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*((b + S(2)*c*x**S(3) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(-S(2)*p, -p, -p, -S(2)*p + S(1), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)))/(S(3)*p), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(2), x), x, -(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(-1)/3, -p, -p, S(2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(3), x), x, -(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(-2)/3, -p, -p, S(1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(4), x), x, -S(4)**p*((b + S(2)*c*x**S(3) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*((b + S(2)*c*x**S(3) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(-S(2)*p + S(1), -p, -p, -S(2)*p + S(2), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)))/(x**S(3)*(-S(6)*p + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(5), x), x, -(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(-4)/3, -p, -p, S(-1)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(6), x), x, -(S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(S(-5)/3, -p, -p, S(-2)/3, -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**p/x**S(7), x), x, -S(2)**(S(2)*p + S(-1))*((b + S(2)*c*x**S(3) - sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*((b + S(2)*c*x**S(3) + sqrt(-S(4)*a*c + b**S(2)))/(c*x**S(3)))**(-p)*(a + b*x**S(3) + c*x**S(6))**p*AppellF1(-S(2)*p + S(2), -p, -p, -S(2)*p + S(3), -(b - sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)), -(b + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*x**S(3)))/(x**S(6)*(-S(3)*p + S(3))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(14)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -S(11)*b*x**S(6)*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(336)*c**S(2)) + x**S(9)*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(24)*c) - (S(3)*b*(-S(124)*a*c + S(77)*b**S(2)) - S(10)*c*x**S(3)*(-S(28)*a*c + S(33)*b**S(2)))*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(13440)*c**S(4)) + (b + S(2)*c*x**S(3))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)*(S(16)*a**S(2)*c**S(2) - S(72)*a*b**S(2)*c + S(33)*b**S(4))/(S(6144)*c**S(5)) - (b + S(2)*c*x**S(3))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))*(S(16)*a**S(2)*c**S(2) - S(72)*a*b**S(2)*c + S(33)*b**S(4))/(S(16384)*c**S(6)) + (-S(4)*a*c + b**S(2))**S(2)*(S(16)*a**S(2)*c**S(2) - S(72)*a*b**S(2)*c + S(33)*b**S(4))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(32768)*c**(S(13)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -b*(b + S(2)*c*x**S(3))*(-S(4)*a*c + S(3)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(384)*c**S(4)) + b*(b + S(2)*c*x**S(3))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(1024)*c**S(5)) - b*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(2048)*c**(S(11)/2)) + x**S(6)*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(21)*c) + (a + b*x**S(3) + c*x**S(6))**(S(5)/2)*(-S(16)*a*c + S(21)*b**S(2) - S(30)*b*c*x**S(3))/(S(840)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -S(7)*b*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(180)*c**S(2)) + x**S(3)*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(18)*c) + (b + S(2)*c*x**S(3))*(-S(4)*a*c + S(7)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(576)*c**S(3)) - (b + S(2)*c*x**S(3))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(1536)*c**S(4)) + (-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(7)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3072)*c**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -b*(b + S(2)*c*x**S(3))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(48)*c**S(2)) + b*(b + S(2)*c*x**S(3))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(128)*c**S(3)) - b*(-S(4)*a*c + b**S(2))**S(2)*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(256)*c**(S(7)/2)) + (a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(15)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, (b + S(2)*c*x**S(3))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(24)*c) - (b + S(2)*c*x**S(3))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(64)*c**S(2)) + (-S(4)*a*c + b**S(2))**S(2)*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(128)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x, x), x, -a**(S(3)/2)*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(3) - b*(-S(12)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*c**(S(3)/2)) + (a + b*x**S(3) + c*x**S(6))**(S(3)/2)/S(9) + sqrt(a + b*x**S(3) + c*x**S(6))*(S(8)*a*c + b**S(2) + S(2)*b*c*x**S(3))/(S(24)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(4), x), x, -sqrt(a)*b*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(2) + (S(3)*b/S(4) + c*x**S(3)/S(2))*sqrt(a + b*x**S(3) + c*x**S(6)) - (a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(3)*x**S(3)) + (S(4)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(8)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(7), x), x, b*sqrt(c)*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(2) - (b - S(2)*c*x**S(3))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(4)*x**S(3)) - (a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(6)*x**S(6)) - (S(4)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(8)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(10), x), x, c**(S(3)/2)*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/S(3) - (a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(9)*x**S(9)) - (S(2)*a*b + x**S(3)*(S(8)*a*c + b**S(2)))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(24)*a*x**S(6)) + b*(-S(12)*a*c + b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(13), x), x, -(S(2)*a + b*x**S(3))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(24)*a*x**S(12)) + (S(2)*a + b*x**S(3))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(64)*a**S(2)*x**S(6)) - (-S(4)*a*c + b**S(2))**S(2)*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(128)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(16), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(15)*a*x**S(15)) + b*(S(2)*a + b*x**S(3))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(48)*a**S(2)*x**S(12)) - b*(S(2)*a + b*x**S(3))*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(128)*a**S(3)*x**S(6)) + b*(-S(4)*a*c + b**S(2))**S(2)*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(256)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(19), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(18)*a*x**S(18)) + S(7)*b*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(180)*a**S(2)*x**S(15)) - (S(2)*a + b*x**S(3))*(-S(4)*a*c + S(7)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(576)*a**S(3)*x**S(12)) + (S(2)*a + b*x**S(3))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(1536)*a**S(4)*x**S(6)) - (-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(7)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3072)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(3) + c*x**S(6))**(S(3)/2)/x**S(22), x), x, -(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(21)*a*x**S(21)) + b*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(28)*a**S(2)*x**S(18)) - (-S(16)*a*c + S(21)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(5)/2)/(S(840)*a**S(3)*x**S(15)) + b*(S(2)*a + b*x**S(3))*(-S(4)*a*c + S(3)*b**S(2))*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)/(S(384)*a**S(4)*x**S(12)) - b*(S(2)*a + b*x**S(3))*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(1024)*a**S(5)*x**S(6)) + b*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + S(3)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(2048)*a**(S(11)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, x**(m + S(1))*hyper((S(2), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -x**S(4))/(m + S(1)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(14)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -S(7)*b*x**S(6)*sqrt(a + b*x**S(3) + c*x**S(6))/(S(72)*c**S(2)) + x**S(9)*sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*c) - (S(5)*b*(-S(44)*a*c + S(21)*b**S(2)) - S(2)*c*x**S(3)*(-S(36)*a*c + S(35)*b**S(2)))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(576)*c**S(4)) + (S(48)*a**S(2)*c**S(2) - S(120)*a*b**S(2)*c + S(35)*b**S(4))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(384)*c**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*(-S(12)*a*c + S(5)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*c**(S(7)/2)) + x**S(6)*sqrt(a + b*x**S(3) + c*x**S(6))/(S(9)*c) + sqrt(a + b*x**S(3) + c*x**S(6))*(-S(16)*a*c + S(15)*b**S(2) - S(10)*b*c*x**S(3))/(S(72)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*sqrt(a + b*x**S(3) + c*x**S(6))/(S(4)*c**S(2)) + x**S(3)*sqrt(a + b*x**S(3) + c*x**S(6))/(S(6)*c) + (-S(4)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(24)*c**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, -b*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(6)*c**(S(3)/2)) + sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*x**S(3) + c*x**S(6)), x), x, atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*a*x**S(3)) + b*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(6)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))/(S(6)*a*x**S(6)) + b*sqrt(a + b*x**S(3) + c*x**S(6))/(S(4)*a**S(2)*x**S(3)) - (-S(4)*a*c + S(3)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(24)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(10)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))/(S(9)*a*x**S(9)) + S(5)*b*sqrt(a + b*x**S(3) + c*x**S(6))/(S(36)*a**S(2)*x**S(6)) - (-S(16)*a*c + S(15)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(72)*a**S(3)*x**S(3)) + b*(-S(12)*a*c + S(5)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(13)*sqrt(a + b*x**S(3) + c*x**S(6))), x), x, -sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*a*x**S(12)) + S(7)*b*sqrt(a + b*x**S(3) + c*x**S(6))/(S(72)*a**S(2)*x**S(9)) - (-S(36)*a*c + S(35)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(288)*a**S(3)*x**S(6)) + S(5)*b*(-S(44)*a*c + S(21)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(576)*a**S(4)*x**S(3)) - (S(48)*a**S(2)*c**S(2) - S(120)*a*b**S(2)*c + S(35)*b**S(4))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(384)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(14)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -S(2)*b*x**S(6)*sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*c*(-S(4)*a*c + b**S(2))) + S(2)*x**S(9)*(S(2)*a + b*x**S(3))/((-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) - (b*(-S(52)*a*c + S(15)*b**S(2)) - S(2)*c*x**S(3)*(-S(12)*a*c + S(5)*b**S(2)))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*c**S(3)*(-S(4)*a*c + b**S(2))) + (-S(4)*a*c + S(5)*b**S(2))*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(8)*c**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -b*atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(2)*c**(S(5)/2)) + S(2)*x**S(6)*(S(2)*a + b*x**S(3))/((-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) + sqrt(a + b*x**S(3) + c*x**S(6))*(-S(8)*a*c + S(3)*b**S(2) - S(2)*b*c*x**S(3))/(S(3)*c**S(2)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -S(2)*b*sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*c*(-S(4)*a*c + b**S(2))) + S(2)*x**S(3)*(S(2)*a + b*x**S(3))/((-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) + atanh((b + S(2)*c*x**S(3))/(S(2)*sqrt(c)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, (S(4)*a + S(2)*b*x**S(3))/((-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(3) + c*x**S(6))**(S(3)/2), x), x, -(S(2)*b + S(4)*c*x**S(3))/((-S(12)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, (-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c*x**S(3))/(S(3)*a*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) - atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(3)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, (-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c*x**S(3))/(S(3)*a*x**S(3)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) - (-S(8)*a*c + S(3)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(3)*a**S(2)*x**S(3)*(-S(4)*a*c + b**S(2))) + b*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(2)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, (-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c*x**S(3))/(S(3)*a*x**S(6)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) - (-S(12)*a*c + S(5)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(6)*a**S(2)*x**S(6)*(-S(4)*a*c + b**S(2))) + b*(-S(52)*a*c + S(15)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(12)*a**S(3)*x**S(3)*(-S(4)*a*c + b**S(2))) - (-S(4)*a*c + S(5)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(8)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(10)*(a + b*x**S(3) + c*x**S(6))**(S(3)/2)), x), x, (-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c*x**S(3))/(S(3)*a*x**S(9)*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))) - (-S(16)*a*c + S(7)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(9)*a**S(2)*x**S(9)*(-S(4)*a*c + b**S(2))) + b*(-S(116)*a*c + S(35)*b**S(2))*sqrt(a + b*x**S(3) + c*x**S(6))/(S(36)*a**S(3)*x**S(6)*(-S(4)*a*c + b**S(2))) - sqrt(a + b*x**S(3) + c*x**S(6))*(S(256)*a**S(2)*c**S(2) - S(460)*a*b**S(2)*c + S(105)*b**S(4))/(S(72)*a**S(4)*x**S(3)*(-S(4)*a*c + b**S(2))) + S(5)*b*(-S(12)*a*c + S(7)*b**S(2))*atanh((S(2)*a + b*x**S(3))/(S(2)*sqrt(a)*sqrt(a + b*x**S(3) + c*x**S(6))))/(S(48)*a**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(3) + c*x**S(6))**S(2), x), x, a**S(2)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(2)*a*b*(d*x)**(m + S(4))/(d**S(4)*(m + S(4))) + S(2)*b*c*(d*x)**(m + S(10))/(d**S(10)*(m + S(10))) + c**S(2)*(d*x)**(m + S(13))/(d**S(13)*(m + S(13))) + (d*x)**(m + S(7))*(S(2)*a*c + b**S(2))/(d**S(7)*(m + S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**S(3) + c*x**S(6)), x), x, a*(d*x)**(m + S(1))/(d*(m + S(1))) + b*(d*x)**(m + S(4))/(d**S(4)*(m + S(4))) + c*(d*x)**(m + S(7))/(d**S(7)*(m + S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(3) + c*x**S(6)), x), x, -S(2)*c*(d*x)**(m + S(1))*hyper((S(1), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))) + S(2)*c*(d*x)**(m + S(1))*hyper((S(1), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))))/(d*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**S(3) + c*x**S(6))**S(2), x), x, -c*(d*x)**(m + S(1))*(-S(4)*a*c*(-m + S(5)) + b**S(2)*(-m + S(2)) - b*(-m + S(2))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -S(2)*c*x**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*a*d*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + c*(d*x)**(m + S(1))*(-S(4)*a*c*(-m + S(5)) + b**S(2)*(-m + S(2)) + b*(-m + S(2))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), m/S(3) + S(1)/3), (m/S(3) + S(4)/3,), -S(2)*c*x**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(3)*a*d*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (d*x)**(m + S(1))*(-S(2)*a*c + b**S(2) + b*c*x**S(3))/(S(3)*a*d*(-S(4)*a*c + b**S(2))*(a + b*x**S(3) + c*x**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)*(a + b*x**S(3) + c*x**S(6))**p, x), x, S(2)**p*b*(-(b + S(2)*c*x**S(3) - sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)))**(-p + S(-1))*(a + b*x**S(3) + c*x**S(6))**(p + S(1))*hyper((-p, p + S(1)), (p + S(2),), (b + S(2)*c*x**S(3) + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*sqrt(-S(4)*a*c + b**S(2))))/(S(3)*c*(p + S(1))*sqrt(-S(4)*a*c + b**S(2))) + (a + b*x**S(3) + c*x**S(6))**(p + S(1))/(S(6)*c*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**S(3) + c*x**S(6))**p, x), x, -S(2)**(p + S(1))*(-(b + S(2)*c*x**S(3) - sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)))**(-p + S(-1))*(a + b*x**S(3) + c*x**S(6))**(p + S(1))*hyper((-p, p + S(1)), (p + S(2),), (b + S(2)*c*x**S(3) + sqrt(-S(4)*a*c + b**S(2)))/(S(2)*sqrt(-S(4)*a*c + b**S(2))))/(S(3)*(p + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -x**S(6)/(S(4)*x**S(4) + S(4)) + S(3)*x**S(2)/S(4) - S(3)*atan(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, log(x**S(4) + S(1))/S(4) + S(1)/(S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -x**S(2)/(S(4)*x**S(4) + S(4)) + atan(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -S(1)/(S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, x**S(2)/(S(4)*x**S(4) + S(4)) + atan(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, log(x) - log(x**S(4) + S(1))/S(4) + S(1)/(S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, -S(3)*atan(x**S(2))/S(4) - S(3)/(S(4)*x**S(2)) + S(1)/(S(4)*x**S(2)*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, -S(2)*log(x) + log(x**S(4) + S(1))/S(2) - S(1)/(S(4)*x**S(4) + S(4)) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, S(5)*atan(x**S(2))/S(4) + S(5)/(S(4)*x**S(2)) - S(5)/(S(12)*x**S(6)) + S(1)/(S(4)*x**S(6)*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -x**S(5)/(S(4)*x**S(4) + S(4)) + S(5)*x/S(4) + S(5)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) - S(5)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) - S(5)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) - S(5)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -x**S(3)/(S(4)*x**S(4) + S(4)) + S(3)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) - S(3)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + S(3)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + S(3)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, -x/(S(4)*x**S(4) + S(4)) - sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) + sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, x**S(3)/(S(4)*x**S(4) + S(4)) + sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) - sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8) + S(2)*x**S(4) + S(1)), x), x, x/(S(4)*x**S(4) + S(4)) - S(3)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) + S(3)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + S(3)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + S(3)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, -S(5)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) + S(5)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) - S(5)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) - S(5)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16) - S(5)/(S(4)*x) + S(1)/(S(4)*x*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, S(7)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) - S(7)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) - S(7)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) - S(7)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16) - S(7)/(S(12)*x**S(3)) + S(1)/(S(4)*x**S(3)*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, S(9)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) - S(9)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + S(9)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + S(9)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16) + S(9)/(S(4)*x) - S(9)/(S(20)*x**S(5)) + S(1)/(S(4)*x**S(5)*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(x**S(8) + S(2)*x**S(4) + S(1))), x), x, -S(11)*sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(32) + S(11)*sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(32) + S(11)*sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(16) + S(11)*sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(16) + S(11)/(S(12)*x**S(3)) - S(11)/(S(28)*x**S(7)) + S(1)/(S(4)*x**S(7)*(x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**(m + S(1))*hyper((S(2), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), x**S(4))/(m + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(6)/(-S(4)*x**S(4) + S(4)) + S(3)*x**S(2)/S(4) - S(3)*atanh(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, log(-x**S(4) + S(1))/S(4) + S(1)/(-S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(2)/(-S(4)*x**S(4) + S(4)) - atanh(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, S(1)/(-S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(2)/(-S(4)*x**S(4) + S(4)) + atanh(x**S(2))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, log(x) - log(-x**S(4) + S(1))/S(4) + S(1)/(-S(4)*x**S(4) + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, S(3)*atanh(x**S(2))/S(4) - S(3)/(S(4)*x**S(2)) + S(1)/(S(4)*x**S(2)*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, S(2)*log(x) - log(-x**S(4) + S(1))/S(2) + S(1)/(-S(4)*x**S(4) + S(4)) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, S(5)*atanh(x**S(2))/S(4) - S(5)/(S(4)*x**S(2)) - S(5)/(S(12)*x**S(6)) + S(1)/(S(4)*x**S(6)*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(5)/(-S(4)*x**S(4) + S(4)) + S(5)*x/S(4) - S(5)*atan(x)/S(8) - S(5)*atanh(x)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(3)/(-S(4)*x**S(4) + S(4)) + S(3)*atan(x)/S(8) - S(3)*atanh(x)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x/(-S(4)*x**S(4) + S(4)) - atan(x)/S(8) - atanh(x)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x**S(3)/(-S(4)*x**S(4) + S(4)) - atan(x)/S(8) + atanh(x)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8) - S(2)*x**S(4) + S(1)), x), x, x/(-S(4)*x**S(4) + S(4)) + S(3)*atan(x)/S(8) + S(3)*atanh(x)/S(8), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, -S(5)*atan(x)/S(8) + S(5)*atanh(x)/S(8) - S(5)/(S(4)*x) + S(1)/(S(4)*x*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, S(7)*atan(x)/S(8) + S(7)*atanh(x)/S(8) - S(7)/(S(12)*x**S(3)) + S(1)/(S(4)*x**S(3)*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, -S(9)*atan(x)/S(8) + S(9)*atanh(x)/S(8) - S(9)/(S(4)*x) - S(9)/(S(20)*x**S(5)) + S(1)/(S(4)*x**S(5)*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(x**S(8) - S(2)*x**S(4) + S(1))), x), x, S(11)*atan(x)/S(8) + S(11)*atanh(x)/S(8) - S(11)/(S(12)*x**S(3)) - S(11)/(S(28)*x**S(7)) + S(1)/(S(4)*x**S(7)*(-x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(a + b*x**S(4) + c*x**S(8)), x), x, -S(2)*c*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*c*x**S(4)/(b + sqrt(-S(4)*a*c + b**S(2))))/((b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))) + S(2)*c*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*c*x**S(4)/(b - sqrt(-S(4)*a*c + b**S(2))))/((b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(a + b*x**S(4) + c*x**S(8)), x), x, -b*log(a + b*x**S(4) + c*x**S(8))/(S(8)*c**S(2)) + x**S(4)/(S(4)*c) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(4))/sqrt(-S(4)*a*c + b**S(2)))/(S(4)*c**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(a + b*x**S(4) + c*x**S(8)), x), x, x**S(2)/(S(2)*c) - sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(a + b*x**S(4) + c*x**S(8)), x), x, b*atanh((b + S(2)*c*x**S(4))/sqrt(-S(4)*a*c + b**S(2)))/(S(4)*c*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*x**S(4) + c*x**S(8))/(S(8)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(a + b*x**S(4) + c*x**S(8)), x), x, -sqrt(S(2))*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**S(4) + c*x**S(8)), x), x, -atanh((b + S(2)*c*x**S(4))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**S(4) + c*x**S(8)), x), x, -sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**S(4) + c*x**S(8))), x), x, b*atanh((b + S(2)*c*x**S(4))/sqrt(-S(4)*a*c + b**S(2)))/(S(4)*a*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a + b*x**S(4) + c*x**S(8))/(S(8)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**S(4) + c*x**S(8))), x), x, -sqrt(S(2))*sqrt(c)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*sqrt(c)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*x**S(2)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - S(1)/(S(2)*a*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a + b*x**S(4) + c*x**S(8))), x), x, -S(1)/(S(4)*a*x**S(4)) - b*log(x)/a**S(2) + b*log(a + b*x**S(4) + c*x**S(8))/(S(8)*a**S(2)) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**S(4))/sqrt(-S(4)*a*c + b**S(2)))/(S(4)*a**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(10)/(a + b*x**S(4) + c*x**S(8)), x), x, x**S(3)/(S(3)*c) - S(2)**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(7)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(7)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(a + b*x**S(4) + c*x**S(8)), x), x, x/c + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(a + b*x**S(4) + c*x**S(8)), x), x, -S(2)**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(a + b*x**S(4) + c*x**S(8)), x), x, S(2)**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**S(4) + c*x**S(8)), x), x, S(2)**(S(1)/4)*c**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(1)/4)*c**(S(1)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(1)/4)*c**(S(1)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a + b*x**S(4) + c*x**S(8)), x), x, -S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(2)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**S(4) + c*x**S(8))), x), x, -S(2)**(S(1)/4)*c**(S(1)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*c**(S(1)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(2)**(S(1)/4)*c**(S(1)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) + S(2)**(S(1)/4)*c**(S(1)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4)) - S(1)/(a*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a + b*x**S(4) + c*x**S(8))), x), x, S(2)**(S(3)/4)*c**(S(3)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*c**(S(3)/4)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*a*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) - S(1)/(S(3)*a*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) + x**S(4) + S(1)), x), x, S(2)*sqrt(S(3))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*x**S(4)/(S(1) - sqrt(S(3))*I))/(S(3)*(sqrt(S(3)) + I)*(m + S(1))) - S(2)*sqrt(S(3))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*x**S(4)/(S(1) + sqrt(S(3))*I))/(S(3)*(-sqrt(S(3)) + I)*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(8) + x**S(4) + S(1)), x), x, x**S(4)/S(4) - log(x**S(8) + x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) + x**S(4) + S(1)), x), x, x**S(2)/S(2) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(2) + S(1))/S(3))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) + x**S(4) + S(1)), x), x, log(x**S(8) + x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) + x**S(4) + S(1)), x), x, log(x**S(4) - x**S(2) + S(1))/S(8) - log(x**S(4) + x**S(2) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(2) + S(1))/S(3))/S(12) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) + x**S(4) + S(1)), x), x, sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(4) + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) + x**S(4) + S(1)), x), x, -log(x**S(4) - x**S(2) + S(1))/S(8) + log(x**S(4) + x**S(2) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(2) + S(1))/S(3))/S(12) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) + x**S(4) + S(1))), x), x, log(x) - log(x**S(8) + x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) + x**S(4) + S(1))), x), x, sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(2) + S(1))/S(3))/S(6) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(6) - S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) + x**S(4) + S(1))), x), x, -log(x) + log(x**S(8) + x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(4) + S(1))/S(3))/S(12) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) + x**S(4) + S(1))), x), x, log(x**S(4) - x**S(2) + S(1))/S(8) - log(x**S(4) + x**S(2) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(2) + S(1))/S(3))/S(12) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(2) + S(1))/S(3))/S(12) + S(1)/(S(2)*x**S(2)) - S(1)/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(8) + x**S(4) + S(1)), x), x, x + log(x**S(2) - x + S(1))/S(8) - log(x**S(2) + x + S(1))/S(8) + sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) - atan(S(2)*x - sqrt(S(3)))/S(4) - atan(S(2)*x + sqrt(S(3)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(8) + x**S(4) + S(1)), x), x, sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(8) + x**S(4) + S(1)), x), x, -log(x**S(2) - x + S(1))/S(8) + log(x**S(2) + x + S(1))/S(8) + sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) + atan(S(2)*x - sqrt(S(3)))/S(4) + atan(S(2)*x + sqrt(S(3)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(8) + x**S(4) + S(1)), x), x, log(x**S(2) - x + S(1))/S(8) - log(x**S(2) + x + S(1))/S(8) - sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) + atan(S(2)*x - sqrt(S(3)))/S(4) + atan(S(2)*x + sqrt(S(3)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8) + x**S(4) + S(1)), x), x, -sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(12) + sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(8) + x**S(4) + S(1))), x), x, -log(x**S(2) - x + S(1))/S(8) + log(x**S(2) + x + S(1))/S(8) - sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) - atan(S(2)*x - sqrt(S(3)))/S(4) - atan(S(2)*x + sqrt(S(3)))/S(4) - S(1)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(8) + x**S(4) + S(1))), x), x, log(x**S(2) - x + S(1))/S(8) - log(x**S(2) + x + S(1))/S(8) + sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) - atan(S(2)*x - sqrt(S(3)))/S(4) - atan(S(2)*x + sqrt(S(3)))/S(4) - S(1)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(8) + x**S(4) + S(1))), x), x, sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(6) + S(1)/x - S(1)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(x**S(8) + x**S(4) + S(1))), x), x, -log(x**S(2) - x + S(1))/S(8) + log(x**S(2) + x + S(1))/S(8) + sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(24) - sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(24) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(12) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(12) + atan(S(2)*x - sqrt(S(3)))/S(4) + atan(S(2)*x + sqrt(S(3)))/S(4) + S(1)/(S(3)*x**S(3)) - S(1)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) - x**S(4) + S(1)), x), x, S(2)*sqrt(S(3))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), S(2)*x**S(4)/(S(1) - sqrt(S(3))*I))/(S(3)*(sqrt(S(3)) + I)*(m + S(1))) - S(2)*sqrt(S(3))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), S(2)*x**S(4)/(S(1) + sqrt(S(3))*I))/(S(3)*(-sqrt(S(3)) + I)*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(8) - x**S(4) + S(1)), x), x, x**S(4)/S(4) + log(x**S(8) - x**S(4) + S(1))/S(8) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) - x**S(4) + S(1)), x), x, x**S(2)/S(2) + sqrt(S(3))*log(x**S(4) - sqrt(S(3))*x**S(2) + S(1))/S(12) - sqrt(S(3))*log(x**S(4) + sqrt(S(3))*x**S(2) + S(1))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) - x**S(4) + S(1)), x), x, log(x**S(8) - x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) - x**S(4) + S(1)), x), x, sqrt(S(3))*log(x**S(4) - sqrt(S(3))*x**S(2) + S(1))/S(24) - sqrt(S(3))*log(x**S(4) + sqrt(S(3))*x**S(2) + S(1))/S(24) + atan(S(2)*x**S(2) - sqrt(S(3)))/S(4) + atan(S(2)*x**S(2) + sqrt(S(3)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) - x**S(4) + S(1)), x), x, -sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(4) + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) - x**S(4) + S(1)), x), x, -sqrt(S(3))*log(x**S(4) - sqrt(S(3))*x**S(2) + S(1))/S(24) + sqrt(S(3))*log(x**S(4) + sqrt(S(3))*x**S(2) + S(1))/S(24) + atan(S(2)*x**S(2) - sqrt(S(3)))/S(4) + atan(S(2)*x**S(2) + sqrt(S(3)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) - x**S(4) + S(1))), x), x, log(x) - log(x**S(8) - x**S(4) + S(1))/S(8) - sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(4) + S(1))/S(3))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) - x**S(4) + S(1))), x), x, -sqrt(S(3))*log(x**S(4) - sqrt(S(3))*x**S(2) + S(1))/S(12) + sqrt(S(3))*log(x**S(4) + sqrt(S(3))*x**S(2) + S(1))/S(12) - S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) - x**S(4) + S(1))), x), x, log(x) - log(x**S(8) - x**S(4) + S(1))/S(8) + sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x**S(4) + S(1))/S(3))/S(12) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) - x**S(4) + S(1))), x), x, -sqrt(S(3))*log(x**S(4) - sqrt(S(3))*x**S(2) + S(1))/S(24) + sqrt(S(3))*log(x**S(4) + sqrt(S(3))*x**S(2) + S(1))/S(24) - atan(S(2)*x**S(2) - sqrt(S(3)))/S(4) - atan(S(2)*x**S(2) + sqrt(S(3)))/S(4) - S(1)/(S(2)*x**S(2)) - S(1)/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(8) - x**S(4) + S(1)), x), x, x - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) - atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))) + atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))) + atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))) - atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(8) - x**S(4) + S(1)), x), x, sqrt(S(6))*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) + sqrt(S(6))*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) - sqrt(S(6))*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12) + sqrt(S(6))*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(8) - x**S(4) + S(1)), x), x, -log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(-S(3)*sqrt(S(3)) + S(6))) + log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(-S(3)*sqrt(S(3)) + S(6))) + log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(S(3)*sqrt(S(3)) + S(6))) - log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(S(3)*sqrt(S(3)) + S(6))) - atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))) + atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))) + atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))) - atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(8) - x**S(4) + S(1)), x), x, log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(-S(3)*sqrt(S(3)) + S(6))) - log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(-S(3)*sqrt(S(3)) + S(6))) - log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(S(3)*sqrt(S(3)) + S(6))) + log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/(S(8)*sqrt(S(3)*sqrt(S(3)) + S(6))) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) + sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8) - x**S(4) + S(1)), x), x, -sqrt(S(6))*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) + sqrt(S(6))*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) - sqrt(S(6))*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12) + sqrt(S(6))*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(8) - x**S(4) + S(1))), x), x, sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) - atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))) + atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/(S(4)*sqrt(S(3)*sqrt(S(3)) + S(6))) + atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))) - atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/(S(4)*sqrt(-S(3)*sqrt(S(3)) + S(6))) - S(1)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(x**S(8) - x**S(4) + S(1))), x), x, sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4) - S(1)/(S(3)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(8) - x**S(4) + S(1))), x), x, -sqrt(S(6))*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(24) - sqrt(S(6))*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(24) + sqrt(S(6))*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) - sqrt(S(6))*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(12) + sqrt(S(6))*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12) - sqrt(S(6))*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(12) - S(1)/x - S(1)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(x**S(8) - x**S(4) + S(1))), x), x, sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(-sqrt(S(3)) + S(2)) + S(1))/S(8) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) - x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(-sqrt(S(3))/S(3) + S(2)/3)*log(x**S(2) + x*sqrt(sqrt(S(3)) + S(2)) + S(1))/S(8) + sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) - sqrt(sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(sqrt(S(3)) + S(2)))/sqrt(-sqrt(S(3)) + S(2)))/S(4) - sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((-S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4) + sqrt(-sqrt(S(3))/S(3) + S(2)/3)*atan((S(2)*x + sqrt(-sqrt(S(3)) + S(2)))/sqrt(sqrt(S(3)) + S(2)))/S(4) - S(1)/(S(3)*x**S(3)) - S(1)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, S(2)*sqrt(S(5))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*x**S(4)/(-sqrt(S(5)) + S(3)))/(S(5)*(-sqrt(S(5)) + S(3))*(m + S(1))) - S(2)*sqrt(S(5))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), -S(2)*x**S(4)/(sqrt(S(5)) + S(3)))/(S(5)*(sqrt(S(5)) + S(3))*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, x**S(4)/S(4) - (-S(7)*sqrt(S(5))/S(40) + S(3)/8)*log(S(2)*x**S(4) - sqrt(S(5)) + S(3)) - (S(3)/8 + S(7)*sqrt(S(5))/S(40))*log(S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, x**S(2)/S(2) + sqrt(-S(4)*sqrt(S(5))/S(5) + S(9)/5)*atan(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - sqrt(S(4)*sqrt(S(5))/S(5) + S(9)/5)*atan(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, (-S(3)*sqrt(S(5))/S(40) + S(1)/8)*log(S(2)*x**S(4) - sqrt(S(5)) + S(3)) + (S(1)/8 + S(3)*sqrt(S(5))/S(40))*log(S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, -sqrt(-sqrt(S(5))/S(10) + S(3)/10)*atan(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) + sqrt(sqrt(S(5))/S(10) + S(3)/10)*atan(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, -sqrt(S(5))*atanh(sqrt(S(5))*(S(2)*x**S(4) + S(3))/S(5))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) + S(3)*x**S(4) + S(1)), x), x, sqrt(sqrt(S(5))/S(10) + S(3)/10)*atan(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - atan(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/sqrt(S(10)*sqrt(S(5)) + S(30)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) + S(3)*x**S(4) + S(1))), x), x, log(x) - (S(1)/8 + S(3)*sqrt(S(5))/S(40))*log(S(2)*x**S(4) - sqrt(S(5)) + S(3)) - (-S(3)*sqrt(S(5))/S(40) + S(1)/8)*log(S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) + S(3)*x**S(4) + S(1))), x), x, -sqrt(S(10))*(sqrt(S(5)) + S(3))**(S(3)/2)*atan(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(40) + sqrt(-S(4)*sqrt(S(5))/S(5) + S(9)/5)*atan(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2) - S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) + S(3)*x**S(4) + S(1))), x), x, -S(3)*log(x) + (S(3)/8 + S(7)*sqrt(S(5))/S(40))*log(S(2)*x**S(4) - sqrt(S(5)) + S(3)) + (-S(7)*sqrt(S(5))/S(40) + S(3)/8)*log(S(2)*x**S(4) + sqrt(S(5)) + S(3)) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) + S(3)*x**S(4) + S(1))), x), x, sqrt(S(11)*sqrt(S(5))/S(2) + S(123)/10)*atan(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - sqrt(-S(11)*sqrt(S(5))/S(2) + S(123)/10)*atan(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2) + S(3)/(S(2)*x**S(2)) - S(1)/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**m/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, S(2)*sqrt(S(5))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), S(2)*x**S(4)/(-sqrt(S(5)) + S(3)))/(S(5)*(-sqrt(S(5)) + S(3))*(m + S(1))) - S(2)*sqrt(S(5))*x**(m + S(1))*hyper((S(1), m/S(4) + S(1)/4), (m/S(4) + S(5)/4,), S(2)*x**S(4)/(sqrt(S(5)) + S(3)))/(S(5)*(sqrt(S(5)) + S(3))*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, x**S(4)/S(4) + (-S(7)*sqrt(S(5))/S(40) + S(3)/8)*log(-S(2)*x**S(4) - sqrt(S(5)) + S(3)) + (S(3)/8 + S(7)*sqrt(S(5))/S(40))*log(-S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, x**S(2)/S(2) + sqrt(-S(4)*sqrt(S(5))/S(5) + S(9)/5)*atanh(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - sqrt(S(4)*sqrt(S(5))/S(5) + S(9)/5)*atanh(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(7)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, (-S(3)*sqrt(S(5))/S(40) + S(1)/8)*log(-S(2)*x**S(4) - sqrt(S(5)) + S(3)) + (S(1)/8 + S(3)*sqrt(S(5))/S(40))*log(-S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(5)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, sqrt(-sqrt(S(5))/S(10) + S(3)/10)*atanh(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - sqrt(sqrt(S(5))/S(10) + S(3)/10)*atanh(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, sqrt(S(5))*atanh(sqrt(S(5))*(-S(2)*x**S(4) + S(3))/S(5))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, sqrt(sqrt(S(5))/S(10) + S(3)/10)*atanh(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - atanh(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/sqrt(S(10)*sqrt(S(5)) + S(30)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, log(x) - (S(1)/8 + S(3)*sqrt(S(5))/S(40))*log(-S(2)*x**S(4) - sqrt(S(5)) + S(3)) - (-S(3)*sqrt(S(5))/S(40) + S(1)/8)*log(-S(2)*x**S(4) + sqrt(S(5)) + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, sqrt(S(10))*(sqrt(S(5)) + S(3))**(S(3)/2)*atanh(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(40) - sqrt(-S(4)*sqrt(S(5))/S(5) + S(9)/5)*atanh(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2) - S(1)/(S(2)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, S(3)*log(x) - (S(3)/8 + S(7)*sqrt(S(5))/S(40))*log(-S(2)*x**S(4) - sqrt(S(5)) + S(3)) - (-S(7)*sqrt(S(5))/S(40) + S(3)/8)*log(-S(2)*x**S(4) + sqrt(S(5)) + S(3)) - S(1)/(S(4)*x**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, sqrt(S(11)*sqrt(S(5))/S(2) + S(123)/10)*atanh(x**S(2)*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(2) - sqrt(-S(11)*sqrt(S(5))/S(2) + S(123)/10)*atanh(sqrt(S(2))*x**S(2)/sqrt(sqrt(S(5)) + S(3)))/S(2) - S(3)/(S(2)*x**S(2)) - S(1)/(S(6)*x**S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(8)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, x + sqrt(S(5))*(-S(440)*sqrt(S(5)) + S(984))**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(20) - sqrt(S(5))*(S(55)*sqrt(S(5))/S(2) + S(123)/2)**(S(1)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) + sqrt(S(5))*(-S(440)*sqrt(S(5)) + S(984))**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(20) - sqrt(S(5))*(S(55)*sqrt(S(5))/S(2) + S(123)/2)**(S(1)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(6)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, -sqrt(S(5))*(-S(64)*sqrt(S(5)) + S(144))**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(20) + S(2)**(S(1)/4)*sqrt(S(5))*(sqrt(S(5)) + S(3))**(S(3)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(20) + sqrt(S(5))*(-S(64)*sqrt(S(5)) + S(144))**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(20) - S(2)**(S(1)/4)*sqrt(S(5))*(sqrt(S(5)) + S(3))**(S(3)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(20), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, sqrt(S(5))*(-sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - sqrt(S(5))*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) + sqrt(S(5))*(-sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - sqrt(S(5))*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, sqrt(S(-10) + S(10)*sqrt(S(5)))*atan(x*sqrt(S(-2) + S(2)*sqrt(S(5)))/S(2))/S(20) - sqrt(S(10) + S(10)*sqrt(S(5)))*atan(x*sqrt(S(2) + S(2)*sqrt(S(5)))/S(2))/S(20) - sqrt(S(-10) + S(10)*sqrt(S(5)))*atanh(x*sqrt(S(-2) + S(2)*sqrt(S(5)))/S(2))/S(20) + sqrt(S(10) + S(10)*sqrt(S(5)))*atanh(x*sqrt(S(2) + S(2)*sqrt(S(5)))/S(2))/S(20), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(x**S(2)/(x**S(8) - S(3)*x**S(4) + S(1)), x), x, -sqrt(S(5))*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) + S(2)**(S(1)/4)*sqrt(S(5))*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/(S(10)*(sqrt(S(5)) + S(3))**(S(1)/4)) + sqrt(S(5))*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - S(2)**(S(1)/4)*sqrt(S(5))*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/(S(10)*(sqrt(S(5)) + S(3))**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, -S(2)**(S(3)/4)*sqrt(S(5))*(sqrt(S(5)) + S(3))**(S(5)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(40) + sqrt(S(5))*(-S(440)*sqrt(S(5)) + S(984))**(S(1)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(20) + S(2)**(S(3)/4)*sqrt(S(5))*(sqrt(S(5)) + S(3))**(S(5)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(40) - sqrt(S(5))*(-S(440)*sqrt(S(5)) + S(984))**(S(1)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(20) - S(1)/x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, -sqrt(S(5))*(S(1292)*sqrt(S(5)) + S(2889))**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) + sqrt(S(5))*(-S(1292)*sqrt(S(5)) + S(2889))**(S(1)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) + sqrt(S(5))*(S(1292)*sqrt(S(5)) + S(2889))**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - sqrt(S(5))*(-S(1292)*sqrt(S(5)) + S(2889))**(S(1)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) - S(3)/x - S(1)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(x**S(8) - S(3)*x**S(4) + S(1))), x), x, sqrt(S(5))*(S(17711)*sqrt(S(5))/S(2) + S(39603)/2)**(S(1)/4)*atan(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - sqrt(S(5))*(-S(17711)*sqrt(S(5))/S(2) + S(39603)/2)**(S(1)/4)*atan(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) + sqrt(S(5))*(S(17711)*sqrt(S(5))/S(2) + S(39603)/2)**(S(1)/4)*atanh(x*(sqrt(S(5))/S(2) + S(3)/2)**(S(1)/4))/S(10) - sqrt(S(5))*(-S(17711)*sqrt(S(5))/S(2) + S(39603)/2)**(S(1)/4)*atanh(S(2)**(S(1)/4)*x/(sqrt(S(5)) + S(3))**(S(1)/4))/S(10) - S(1)/x**S(3) - S(1)/(S(7)*x**S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(x**S(8) + S(3)*x**S(4) + S(2)), x), x, -atanh(S(2)*x**S(4) + S(3))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(11)/(x**S(8) + S(3)*x**S(4) + S(2)), x), x, x**S(4)/S(4) + log(x**S(4) + S(1))/S(4) - log(x**S(4) + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(9)/(x**S(10) + x**S(5) + S(2)), x), x, log(x**S(10) + x**S(5) + S(2))/S(10) - sqrt(S(7))*atan(sqrt(S(7))*(S(2)*x**S(5) + S(1))/S(7))/S(35), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(4)/(x**S(10) + x**S(5) + S(2)), x), x, S(2)*sqrt(S(7))*atan(sqrt(S(7))*(S(2)*x**S(5) + S(1))/S(7))/S(35), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(x**S(10) + x**S(5) + S(1))), x), x, log(x) - log(x**S(10) + x**S(5) + S(1))/S(10) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(5) + S(1))/S(3))/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(x**S(10) + x**S(5) + S(1))), x), x, -log(x) + log(x**S(10) + x**S(5) + S(1))/S(10) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(5) + S(1))/S(3))/S(15) - S(1)/(S(5)*x**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(11) + x**S(6) + x), x), x, log(x) - log(x**S(10) + x**S(5) + S(1))/S(10) - sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x**S(5) + S(1))/S(3))/S(15), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a/x**S(2) + b/x + c), x), x, -b*x**S(3)/(S(3)*c**S(2)) - b*x*(-S(2)*a*c + b**S(2))/c**S(4) + b*(S(5)*a**S(2)*c**S(2) - S(5)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(5)*sqrt(-S(4)*a*c + b**S(2))) + x**S(4)/(S(4)*c) + x**S(2)*(-a*c + b**S(2))/(S(2)*c**S(3)) + (a**S(2)*c**S(2) - S(3)*a*b**S(2)*c + b**S(4))*log(a + b*x + c*x**S(2))/(S(2)*c**S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a/x**S(2) + b/x + c), x), x, -b*x**S(2)/(S(2)*c**S(2)) - b*(-S(2)*a*c + b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*c**S(4)) + x**S(3)/(S(3)*c) + x*(-a*c + b**S(2))/c**S(3) - (S(2)*a**S(2)*c**S(2) - S(4)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a/x**S(2) + b/x + c), x), x, -b*x/c**S(2) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(3)*sqrt(-S(4)*a*c + b**S(2))) + x**S(2)/(S(2)*c) + (-a*c + b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a/x**S(2) + b/x + c), x), x, -b*log(a + b*x + c*x**S(2))/(S(2)*c**S(2)) + x/c - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a/x**S(2) + b/x + c)), x), x, b*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*x + c*x**S(2))/(S(2)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a/x**S(2) + b/x + c)), x), x, S(2)*atanh((S(2)*a/x + b)/sqrt(-S(4)*a*c + b**S(2)))/sqrt(-S(4)*a*c + b**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a/x**S(2) + b/x + c)), x), x, b*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a + b*x + c*x**S(2))/(S(2)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a/x**S(2) + b/x + c)), x), x, -S(1)/(a*x) - b*log(x)/a**S(2) + b*log(a + b*x + c*x**S(2))/(S(2)*a**S(2)) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(2)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a/x**S(2) + b/x + c)), x), x, -S(1)/(S(2)*a*x**S(2)) + b/(a**S(2)*x) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*sqrt(-S(4)*a*c + b**S(2))) + (-a*c + b**S(2))*log(x)/a**S(3) - (-a*c + b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*a**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a/x**S(2) + b/x + c)), x), x, -S(1)/(S(3)*a*x**S(3)) + b/(S(2)*a**S(2)*x**S(2)) - (-a*c + b**S(2))/(a**S(3)*x) - b*(-S(2)*a*c + b**S(2))*log(x)/a**S(4) + b*(-S(2)*a*c + b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*a**S(4)) - (S(2)*a**S(2)*c**S(2) - S(4)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a/x**S(2) + b/x + c)**S(2), x), x, -b*x**S(3)/(c*(-S(4)*a*c + b**S(2))) - b*x*(-S(11)*a*c + S(3)*b**S(2))/(c**S(3)*(-S(4)*a*c + b**S(2))) + b*(S(30)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + x**S(4)*(S(2)*a + b*x)/((-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) + x**S(2)*(-S(8)*a*c + S(3)*b**S(2))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))) + (-S(2)*a*c + S(3)*b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*c**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a/x**S(2) + b/x + c)**(S(-2)), x), x, -b*x**S(2)/(c*(-S(4)*a*c + b**S(2))) - b*log(a + b*x + c*x**S(2))/c**S(3) + x**S(3)*(S(2)*a + b*x)/((-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) + x*(-S(6)*a*c + S(2)*b**S(2))/(c**S(2)*(-S(4)*a*c + b**S(2))) - (S(12)*a**S(2)*c**S(2) - S(12)*a*b**S(2)*c + S(2)*b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(3)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a/x**S(2) + b/x + c)**S(2)), x), x, -b*x/(c*(-S(4)*a*c + b**S(2))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(2)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + x**S(2)*(S(2)*a + b*x)/((-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) + log(a + b*x + c*x**S(2))/(S(2)*c**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a/x**S(2) + b/x + c)**S(2)), x), x, -S(4)*a*atanh((S(2)*a/x + b)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) + (S(2)*a/x + b)/((-S(4)*a*c + b**S(2))*(a/x**S(2) + b/x + c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a/x**S(2) + b/x + c)**S(2)), x), x, -S(2)*b*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) + (S(2)*a + b*x)/((-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a/x**S(2) + b/x + c)**S(2)), x), x, S(4)*c*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(3)/2) - (b + S(2)*c*x)/((-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a/x**S(2) + b/x + c)**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x)/(a*(-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(2)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + log(x)/a**S(2) - log(a + b*x + c*x**S(2))/(S(2)*a**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a/x**S(2) + b/x + c)**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x)/(a*x*(-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) + (S(6)*a*c - S(2)*b**S(2))/(a**S(2)*x*(-S(4)*a*c + b**S(2))) - S(2)*b*log(x)/a**S(3) + b*log(a + b*x + c*x**S(2))/a**S(3) - (S(12)*a**S(2)*c**S(2) - S(12)*a*b**S(2)*c + S(2)*b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(a/x**S(2) + b/x + c)**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*x)/(a*x**S(2)*(-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))) - (-S(8)*a*c + S(3)*b**S(2))/(S(2)*a**S(2)*x**S(2)*(-S(4)*a*c + b**S(2))) + b*(-S(11)*a*c + S(3)*b**S(2))/(a**S(3)*x*(-S(4)*a*c + b**S(2))) + b*(S(30)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(4)*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (-S(2)*a*c + S(3)*b**S(2))*log(x)/a**S(4) - (-S(2)*a*c + S(3)*b**S(2))*log(a + b*x + c*x**S(2))/(S(2)*a**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a/x**S(2) + b/x + c)**(S(-3)), x), x, -S(3)*b*x**S(2)*(-S(6)*a*c + b**S(2))/(S(2)*c**S(2)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*b*log(a + b*x + c*x**S(2))/(S(2)*c**S(4)) + x**S(5)*(S(2)*a + b*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)) + x**S(3)*(a*(-S(10)*a*c + b**S(2)) + b*x*(-S(7)*a*c + b**S(2)))/(c*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) + x*(S(30)*a**S(2)*c**S(2) - S(21)*a*b**S(2)*c + S(3)*b**S(4))/(c**S(3)*(-S(4)*a*c + b**S(2))**S(2)) - (-S(60)*a**S(3)*c**S(3) + S(90)*a**S(2)*b**S(2)*c**S(2) - S(30)*a*b**S(4)*c + S(3)*b**S(6))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(4)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a/x**S(2) + b/x + c)**S(3)), x), x, -b*x*(-S(7)*a*c + b**S(2))/(c**S(2)*(-S(4)*a*c + b**S(2))**S(2)) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(3)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + x**S(4)*(S(2)*a + b*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)) + x**S(2)*(a*(-S(16)*a*c + b**S(2)) + b*x*(-S(10)*a*c + b**S(2)))/(S(2)*c*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) + log(a + b*x + c*x**S(2))/(S(2)*c**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a/x**S(2) + b/x + c)**S(3)), x), x, S(12)*a**S(2)*atanh((S(2)*a/x + b)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) - S(3)*a*(S(2)*a/x + b)/((-S(4)*a*c + b**S(2))**S(2)*(a/x**S(2) + b/x + c)) + (S(2)*a/x + b)/((-S(8)*a*c + S(2)*b**S(2))*(a/x**S(2) + b/x + c)**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a/x**S(2) + b/x + c)**S(3)), x), x, S(6)*a*b*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) + S(3)*b*x*(S(2)*a + b*x)/(S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) - x**S(3)*(b + S(2)*c*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(a/x**S(2) + b/x + c)**S(3)), x), x, x*(S(2)*a + b*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)) + (S(3)*a*b + x*(S(2)*a*c + b**S(2)))/((-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) - (S(4)*a*c + S(2)*b**S(2))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(a/x**S(2) + b/x + c)**S(3)), x), x, S(6)*b*c*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) - S(3)*b*(b + S(2)*c*x)/(S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) + (S(2)*a + b*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(a/x**S(2) + b/x + c)**S(3)), x), x, -S(12)*c**S(2)*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(-S(4)*a*c + b**S(2))**(S(5)/2) + S(3)*c*(b + S(2)*c*x)/((-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) + (-b - S(2)*c*x)/((-S(8)*a*c + S(2)*b**S(2))*(a + b*x + c*x**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(7)*(a/x**S(2) + b/x + c)**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*x)/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))**S(2)) + (S(16)*a**S(2)*c**S(2) - S(15)*a*b**S(2)*c + S(2)*b**S(4) + S(2)*b*c*x*(-S(7)*a*c + b**S(2)))/(S(2)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*(-S(4)*a*c + b**S(2))**(S(5)/2)) + log(x)/a**S(3) - log(a + b*x + c*x**S(2))/(S(2)*a**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(8)*(a/x**S(2) + b/x + c)**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*x)/(S(2)*a*x*(-S(4)*a*c + b**S(2))*(a + b*x + c*x**S(2))**S(2)) + (S(20)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4) + S(3)*b*c*x*(-S(6)*a*c + b**S(2)))/(S(2)*a**S(2)*x*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x + c*x**S(2))) - (S(30)*a**S(2)*c**S(2) - S(21)*a*b**S(2)*c + S(3)*b**S(4))/(a**S(3)*x*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*b*log(x)/a**S(4) + S(3)*b*log(a + b*x + c*x**S(2))/(S(2)*a**S(4)) - (-S(60)*a**S(3)*c**S(3) + S(90)*a**S(2)*b**S(2)*c**S(2) - S(30)*a*b**S(4)*c + S(3)*b**S(6))*atanh((b + S(2)*c*x)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(4)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(S(15) + S(13)/x + S(2)/x**S(2)), x), x, x**S(3)/S(45) - S(13)*x**S(2)/S(450) + S(139)*x/S(3375) - S(16)*log(S(3)*x + S(2))/S(567) + log(S(5)*x + S(1))/S(4375), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(S(15) + S(13)/x + S(2)/x**S(2)), x), x, x**S(2)/S(30) - S(13)*x/S(225) + S(8)*log(S(3)*x + S(2))/S(189) - log(S(5)*x + S(1))/S(875), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(S(15) + S(13)/x + S(2)/x**S(2)), x), x, x/S(15) - S(4)*log(S(3)*x + S(2))/S(63) + log(S(5)*x + S(1))/S(175), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, S(2)*log(S(3)*x + S(2))/S(21) - log(S(5)*x + S(1))/S(35), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, -log(S(3) + S(2)/x)/S(7) + log(S(5) + S(1)/x)/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, log(x)/S(2) + S(3)*log(S(3)*x + S(2))/S(14) - S(5)*log(S(5)*x + S(1))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(4)*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, -S(13)*log(x)/S(4) - S(9)*log(S(3)*x + S(2))/S(28) + S(25)*log(S(5)*x + S(1))/S(7) - S(1)/(S(2)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(5)*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, S(139)*log(x)/S(8) + S(27)*log(S(3)*x + S(2))/S(56) - S(125)*log(S(5)*x + S(1))/S(7) + S(13)/(S(4)*x) - S(1)/(S(4)*x**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(6)*(S(15) + S(13)/x + S(2)/x**S(2))), x), x, -S(1417)*log(x)/S(16) - S(81)*log(S(3)*x + S(2))/S(112) + S(625)*log(S(5)*x + S(1))/S(7) - S(139)/(S(8)*x) + S(13)/(S(8)*x**S(2)) - S(1)/(S(6)*x**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b/x + c/x**S(2))**(S(5)/2), x), x, S(5)*a**(S(3)/2)*b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/S(2) + x*(a + b/x + c/x**S(2))**(S(5)/2) - S(5)*(S(7)*b + S(6)*c/x)*(a + b/x + c/x**S(2))**(S(3)/2)/S(24) - S(5)*(b*(S(44)*a*c + b**S(2)) + S(2)*c*(S(12)*a*c + b**S(2))/x)*sqrt(a + b/x + c/x**S(2))/(S(64)*c) + (-S(240)*a**S(2)*c**S(2) - S(120)*a*b**S(2)*c + S(5)*b**S(4))*atanh((b + S(2)*c/x)/(S(2)*sqrt(c)*sqrt(a + b/x + c/x**S(2))))/(S(128)*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b/x + c/x**S(2))**(S(3)/2), x), x, S(3)*sqrt(a)*b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/S(2) + x*(a + b/x + c/x**S(2))**(S(3)/2) - S(3)*(S(3)*b + S(2)*c/x)*sqrt(a + b/x + c/x**S(2))/S(4) - (S(12)*a*c + S(3)*b**S(2))*atanh((b + S(2)*c/x)/(S(2)*sqrt(c)*sqrt(a + b/x + c/x**S(2))))/(S(8)*sqrt(c)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b/x + c/x**S(2)), x), x, -sqrt(c)*atanh((b + S(2)*c/x)/(S(2)*sqrt(c)*sqrt(a + b/x + c/x**S(2)))) + x*sqrt(a + b/x + c/x**S(2)) + b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b/x + c/x**S(2)), x), x, x*sqrt(a + b/x + c/x**S(2))/a - b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/(S(2)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b/x + c/x**S(2))**(S(-3)/2), x), x, -x*(-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c/x)/(a*(-S(4)*a*c + b**S(2))*sqrt(a + b/x + c/x**S(2))) + x*(-S(8)*a*c + S(3)*b**S(2))*sqrt(a + b/x + c/x**S(2))/(a**S(2)*(-S(4)*a*c + b**S(2))) - S(3)*b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/(S(2)*a**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b/x + c/x**S(2))**(S(-5)/2), x), x, -x*(-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c/x)/(S(3)*a*(-S(4)*a*c + b**S(2))*(a + b/x + c/x**S(2))**(S(3)/2)) - x*(S(64)*a**S(2)*c**S(2) - S(64)*a*b**S(2)*c + S(10)*b**S(4) + S(2)*b*c*(-S(28)*a*c + S(5)*b**S(2))/x)/(S(3)*a**S(2)*(-S(4)*a*c + b**S(2))**S(2)*sqrt(a + b/x + c/x**S(2))) + x*sqrt(a + b/x + c/x**S(2))*(S(128)*a**S(2)*c**S(2) - S(100)*a*b**S(2)*c + S(15)*b**S(4))/(S(3)*a**S(3)*(-S(4)*a*c + b**S(2))**S(2)) - S(5)*b*atanh((S(2)*a + b/x)/(S(2)*sqrt(a)*sqrt(a + b/x + c/x**S(2))))/(S(2)*a**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b/x + b**S(2)/x**S(2)), x), x, a*x*sqrt(a**S(2) + S(2)*a*b/x + b**S(2)/x**S(2))/(a + b/x) + b*sqrt(a**S(2) + S(2)*a*b/x + b**S(2)/x**S(2))*log(x)/(a + b/x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a/x**S(4) + b/x**S(2) + c), x), x, x/c - sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a/x**S(6) + b/x**S(3) + c), x), x, x/c - S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(4)/3)*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*c**(S(1)/3)*x + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(6)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**S(2) - S(2)**(S(1)/3)*c**(S(1)/3)*x*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(12)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*sqrt(S(3))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(6)*c**(S(4)/3)*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a/x**S(8) + b/x**S(4) + c), x), x, x/c + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) + S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(S(4)*c**(S(5)/4)*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*sqrt(x) + c*x)/x, x), x, -S(2)*sqrt(a)*atanh((S(2)*a + b*sqrt(x))/(S(2)*sqrt(a)*sqrt(a + b*sqrt(x) + c*x))) + b*atanh((b + S(2)*c*sqrt(x))/(S(2)*sqrt(c)*sqrt(a + b*sqrt(x) + c*x)))/sqrt(c) + S(2)*sqrt(a + b*sqrt(x) + c*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b**S(2)/(S(4)*c) + b*sqrt(x) + c*x)**S(2), x), x, -b*(b + S(2)*c*sqrt(x))**S(5)/(S(160)*c**S(4)) + (b + S(2)*c*sqrt(x))**S(6)/(S(192)*c**S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b*sqrt(x) + b**S(2)*x), x), x, -S(2)*a*(a + b*sqrt(x))*log(a + b*sqrt(x))/(b**S(2)*sqrt(a**S(2) + S(2)*a*b*sqrt(x) + b**S(2)*x)) + S(2)*sqrt(a**S(2) + S(2)*a*b*sqrt(x) + b**S(2)*x)/b**S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p, x), x, x*(d*x)**m*(S(1) + b*x**(S(1)/3)/a)**(-S(2)*p)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p*hyper((S(3)*m + S(3), -S(2)*p), (S(3)*m + S(4),), -b*x**(S(1)/3)/a)/(m + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p, x), x, S(3)*a**S(8)*(a + b*x**(S(1)/3))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(9)*(S(2)*p + S(1))) - S(12)*a**S(7)*(a*b + b**S(2)*x**(S(1)/3))**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(11)*(p + S(1))) + S(84)*a**S(6)*(a*b + b**S(2)*x**(S(1)/3))**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(12)*(S(2)*p + S(3))) - S(84)*a**S(5)*(a*b + b**S(2)*x**(S(1)/3))**S(4)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(13)*(p + S(2))) + S(210)*a**S(4)*(a*b + b**S(2)*x**(S(1)/3))**S(5)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(14)*(S(2)*p + S(5))) - S(84)*a**S(3)*(a*b + b**S(2)*x**(S(1)/3))**S(6)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(15)*(p + S(3))) + S(84)*a**S(2)*(a*b + b**S(2)*x**(S(1)/3))**S(7)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(16)*(S(2)*p + S(7))) - S(12)*a*(a*b + b**S(2)*x**(S(1)/3))**S(8)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(17)*(p + S(4))) + S(3)*(a*b + b**S(2)*x**(S(1)/3))**S(9)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(18)*(S(2)*p + S(9))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p, x), x, -S(3)*a**S(5)*(a + b*x**(S(1)/3))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(6)*(S(2)*p + S(1))) + S(15)*a**S(4)*(a*b + b**S(2)*x**(S(1)/3))**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(S(2)*b**S(8)*(p + S(1))) - S(30)*a**S(3)*(a*b + b**S(2)*x**(S(1)/3))**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(9)*(S(2)*p + S(3))) + S(15)*a**S(2)*(a*b + b**S(2)*x**(S(1)/3))**S(4)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(10)*(p + S(2))) - S(15)*a*(a*b + b**S(2)*x**(S(1)/3))**S(5)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(b**S(11)*(S(2)*p + S(5))) + S(3)*(a*b + b**S(2)*x**(S(1)/3))**S(6)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(S(2)*b**S(12)*(p + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/x, x), x, -(S(3)*a + S(3)*b*x**(S(1)/3))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p*hyper((S(1), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**(S(1)/3)/a)/(a*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/x**S(2), x), x, (S(3)*a*b**S(3) + S(3)*b**S(4)*x**(S(1)/3))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p*hyper((S(4), S(2)*p + S(1)), (S(2)*p + S(2),), S(1) + b*x**(S(1)/3)/a)/(a**S(4)*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/x**S(2) - S(2)*b**S(3)*p*(-S(2)*p + S(1))*(-p + S(1))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(S(3)*a**S(3)*x), x), x, -(a + b*x**(S(1)/3))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(a*x) + b*(a + b*x**(S(1)/3))*(-p + S(1))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(a**S(2)*x**(S(2)/3)) - b**S(2)*(a + b*x**(S(1)/3))*(-S(2)*p + S(1))*(-p + S(1))*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**p/(a**S(3)*x**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/4) + b**S(2)*sqrt(x))**(S(-3)/2), x), x, -S(12)*a*(a + b*x**(S(1)/4))*log(a + b*x**(S(1)/4))/(b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/4) + b**S(2)*sqrt(x))) - x**(S(3)/4)*(S(2)*a + S(2)*b*x**(S(1)/4))/(b*(a**S(2) + S(2)*a*b*x**(S(1)/4) + b**S(2)*sqrt(x))**(S(3)/2)) - S(6)*sqrt(x)/(b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/4) + b**S(2)*sqrt(x))) + S(12)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/4) + b**S(2)*sqrt(x))/b**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))**(S(-5)/2), x), x, -S(30)*a*(a + b*x**(S(1)/6))*log(a + b*x**(S(1)/6))/(b**S(6)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))) - x**(S(5)/6)*(S(3)*a + S(3)*b*x**(S(1)/6))/(S(2)*b*(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))**(S(5)/2)) - S(5)*x**(S(2)/3)/(S(2)*b**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))**(S(3)/2)) - sqrt(x)*(S(5)*a + S(5)*b*x**(S(1)/6))/(b**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))**(S(3)/2)) - S(15)*x**(S(1)/3)/(b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))) + S(30)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/6) + b**S(2)*x**(S(1)/3))/b**S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/sqrt(x) + b**S(2)/x)**(S(3)/2), x), x, -S(6)*a*b**S(2)*sqrt(a**S(2) + S(2)*a*b/sqrt(x) + b**S(2)/x)*log(S(1)/sqrt(x))/(a + b/sqrt(x)) - S(6)*b**S(2)*sqrt(a**S(2) + S(2)*a*b/sqrt(x) + b**S(2)/x) + S(3)*b*sqrt(x)*(a + b/sqrt(x))*sqrt(a**S(2) + S(2)*a*b/sqrt(x) + b**S(2)/x) + x*(a**S(2) + S(2)*a*b/sqrt(x) + b**S(2)/x)**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(7)/2), x), x, -S(105)*a**S(4)*b**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))*log(x**(S(-1)/3))/(a + b/x**(S(1)/3)) - S(105)*a**S(3)*b**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)) - S(105)*a**S(2)*b**S(3)*(a + b/x**(S(1)/3))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/S(2) - S(35)*a*b**S(3)*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2) - S(105)*b**S(3)*(a + b/x**(S(1)/3))*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2)/S(4) + S(21)*b**S(2)*x**(S(1)/3)*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(5)/2) + S(7)*b*x**(S(2)/3)*(a + b/x**(S(1)/3))*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(5)/2)/S(2) + x*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(7)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(5)/2), x), x, -S(30)*a**S(2)*b**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))*log(x**(S(-1)/3))/(a + b/x**(S(1)/3)) - S(30)*a*b**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)) - S(15)*b**S(3)*(a + b/x**(S(1)/3))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)) + S(10)*b**S(2)*x**(S(1)/3)*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2) + S(5)*b*x**(S(2)/3)*(a + b/x**(S(1)/3))*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2)/S(2) + x*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2), x), x, S(3)*a*b**S(2)*x**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/(a + b/x**(S(1)/3)) - S(3)*b**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))*log(x**(S(-1)/3))/(a + b/x**(S(1)/3)) + S(3)*b*x**(S(2)/3)*(a + b/x**(S(1)/3))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/S(2) + x*(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))**(S(3)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)), x), x, -a*x*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/(S(2)*a + S(2)*b/x**(S(1)/3)) + S(3)*x*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)), x), x, x*(a + b/x**(S(1)/3))/(a*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) - S(3)*b*x**(S(2)/3)*(a + b/x**(S(1)/3))/(S(2)*a**S(2)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) + S(3)*b**S(2)*x**(S(1)/3)*(a + b/x**(S(1)/3))/(a**S(3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) - S(3)*b**S(3)*(a + b/x**(S(1)/3))*log(a*x**(S(1)/3) + b)/(a**S(4)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3)), x), x, x*(a + b/x**(S(1)/3))/(a*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) - S(3)*b*x**(S(2)/3)*(a + b/x**(S(1)/3))/(S(2)*a**S(2)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) + S(3)*b**S(3)*(a + b/x**(S(1)/3))*log(x**(S(-1)/3))/(a**S(4)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) - S(3)*b**S(3)*(a + b/x**(S(1)/3))*log(a + b/x**(S(1)/3))/(a**S(4)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))) + S(3)*b**S(2)*x**(S(1)/3)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/3) + b**S(2)/x**(S(2)/3))/a**S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(-3)/2), x), x, -x**(S(2)/3)*(S(3)*a + S(3)*b*x**(S(1)/3))/(S(2)*b*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(3)/2)) - S(3)*x**(S(1)/3)/(b**S(2)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))) + (S(3)*a + S(3)*b*x**(S(1)/3))*log(a + b*x**(S(1)/3))/(b**S(3)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(-5)/2), x), x, x*(S(3)*a + S(3)*b*x**(S(1)/3))/(S(4)*a*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(5)/2)) + x/(S(4)*a**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(-7)/2), x), x, -x**(S(2)/3)*(a + b*x**(S(1)/3))/(S(2)*b*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(7)/2)) - x**(S(1)/3)/(S(5)*b**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(5)/2)) - (a + b*x**(S(1)/3))/(S(20)*b**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(-9)/2), x), x, -x**(S(2)/3)*(S(3)*a + S(3)*b*x**(S(1)/3))/(S(8)*b*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(9)/2)) - S(3)*x**(S(1)/3)/(S(28)*b**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(7)/2)) - (a + b*x**(S(1)/3))/(S(56)*b**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(7)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(-11)/2), x), x, -x**(S(2)/3)*(S(3)*a + S(3)*b*x**(S(1)/3))/(S(10)*b*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(11)/2)) - x**(S(1)/3)/(S(15)*b**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(9)/2)) - (a + b*x**(S(1)/3))/(S(120)*b**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/3) + b**S(2)*x**(S(2)/3))**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x))**(S(5)/2), x), x, -S(20)*a*b**S(4)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x))*log(x**(S(-1)/4))/(a + b/x**(S(1)/4)) - S(20)*b**S(4)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x)) + S(10)*b**S(3)*x**(S(1)/4)*(a + b/x**(S(1)/4))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x)) + S(10)*b**S(2)*sqrt(x)*(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x))**(S(3)/2)/S(3) + S(5)*b*x**(S(3)/4)*(a + b/x**(S(1)/4))*(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x))**(S(3)/2)/S(3) + x*(a**S(2) + S(2)*a*b/x**(S(1)/4) + b**S(2)/sqrt(x))**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))**(S(5)/2), x), x, S(5)*a*b**S(4)*x**(S(1)/5)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))/(a + b/x**(S(1)/5)) - S(5)*b**S(5)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))*log(x**(S(-1)/5))/(a + b/x**(S(1)/5)) + S(5)*b**S(3)*x**(S(2)/5)*(a + b/x**(S(1)/5))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))/S(2) + S(5)*b**S(2)*x**(S(3)/5)*(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))**(S(3)/2)/S(3) + S(5)*b*x**(S(4)/5)*(a + b/x**(S(1)/5))*(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))**(S(3)/2)/S(4) + x*(a**S(2) + S(2)*a*b/x**(S(1)/5) + b**S(2)/x**(S(2)/5))**(S(5)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))**(S(-5)/2), x), x, -x**(S(4)/5)*(S(5)*a + S(5)*b*x**(S(1)/5))/(S(4)*b*(a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))**(S(5)/2)) - S(5)*x**(S(3)/5)/(S(3)*b**S(2)*(a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))**(S(3)/2)) - x**(S(2)/5)*(S(5)*a + S(5)*b*x**(S(1)/5))/(S(2)*b**S(3)*(a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))**(S(3)/2)) - S(5)*x**(S(1)/5)/(b**S(4)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))) + (S(5)*a + S(5)*b*x**(S(1)/5))*log(a + b*x**(S(1)/5))/(b**S(5)*sqrt(a**S(2) + S(2)*a*b*x**(S(1)/5) + b**S(2)*x**(S(2)/5))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(7)/2), x), x, -S(42)*a*b**S(6)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))*log(x**(S(-1)/6))/(a + b/x**(S(1)/6)) - S(42)*b**S(6)*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3)) + S(21)*b**S(5)*x**(S(1)/6)*(a + b/x**(S(1)/6))*sqrt(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3)) + S(7)*b**S(4)*x**(S(1)/3)*(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(3)/2) + S(7)*b**S(3)*sqrt(x)*(a + b/x**(S(1)/6))*(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(3)/2)/S(2) + S(21)*b**S(2)*x**(S(2)/3)*(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(5)/2)/S(10) + S(7)*b*x**(S(5)/6)*(a + b/x**(S(1)/6))*(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(5)/2)/S(5) + x*(a**S(2) + S(2)*a*b/x**(S(1)/6) + b**S(2)/x**(S(1)/3))**(S(7)/2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(4)*n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, b**S(2)*log(b + c*x**n)/(c**S(3)*n) - b*x**n/(c**S(2)*n) + x**(S(2)*n)/(S(2)*c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)*n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -b*log(b + c*x**n)/(c**S(2)*n) + x**n/(c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, log(b + c*x**n)/(c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, log(x)/b - log(b + c*x**n)/(b*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -x**(-S(2)*n)/(S(2)*b*n) + c*x**(-n)/(b**S(2)*n) + c**S(2)*log(x)/b**S(3) - c**S(2)*log(b + c*x**n)/(b**S(3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-S(2)*n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -x**(-S(3)*n)/(S(3)*b*n) + c*x**(-S(2)*n)/(S(2)*b**S(2)*n) - c**S(2)*x**(-n)/(b**S(3)*n) - c**S(3)*log(x)/b**S(4) + c**S(3)*log(b + c*x**n)/(b**S(4)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-S(3)*n + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -x**(-S(4)*n)/(S(4)*b*n) + c*x**(-S(3)*n)/(S(3)*b**S(2)*n) - c**S(2)*x**(-S(2)*n)/(S(2)*b**S(3)*n) + c**S(3)*x**(-n)/(b**S(4)*n) + c**S(4)*log(x)/b**S(5) - c**S(4)*log(b + c*x**n)/(b**S(5)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(4) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(4)*x**(-S(3)*n/S(4))/(S(3)*b*n) + sqrt(S(2))*c**(S(3)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*x**(n/S(4)) + sqrt(b) + sqrt(c)*x**(n/S(2)))/(S(2)*b**(S(7)/4)*n) - sqrt(S(2))*c**(S(3)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*x**(n/S(4)) + sqrt(b) + sqrt(c)*x**(n/S(2)))/(S(2)*b**(S(7)/4)*n) + sqrt(S(2))*c**(S(3)/4)*atan(S(1) - sqrt(S(2))*c**(S(1)/4)*x**(n/S(4))/b**(S(1)/4))/(b**(S(7)/4)*n) - sqrt(S(2))*c**(S(3)/4)*atan(S(1) + sqrt(S(2))*c**(S(1)/4)*x**(n/S(4))/b**(S(1)/4))/(b**(S(7)/4)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(3) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(3)*x**(-S(2)*n/S(3))/(S(2)*b*n) - c**(S(2)/3)*log(b**(S(1)/3) + c**(S(1)/3)*x**(n/S(3)))/(b**(S(5)/3)*n) + c**(S(2)/3)*log(b**(S(2)/3) - b**(S(1)/3)*c**(S(1)/3)*x**(n/S(3)) + c**(S(2)/3)*x**(S(2)*n/S(3)))/(S(2)*b**(S(5)/3)*n) + sqrt(S(3))*c**(S(2)/3)*atan(sqrt(S(3))*(b**(S(1)/3) - S(2)*c**(S(1)/3)*x**(n/S(3)))/(S(3)*b**(S(1)/3)))/(b**(S(5)/3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(2) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(2)*x**(-n/S(2))/(b*n) + S(2)*sqrt(c)*atan(sqrt(b)*x**(-n/S(2))/sqrt(c))/(b**(S(3)/2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(2) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(2)*x**(-S(3)*n/S(2))/(S(3)*b*n) + S(2)*c*x**(-n/S(2))/(b**S(2)*n) - S(2)*c**(S(3)/2)*atan(sqrt(b)*x**(-n/S(2))/sqrt(c))/(b**(S(5)/2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(3) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(3)*x**(-S(4)*n/S(3))/(S(4)*b*n) + S(3)*c*x**(-n/S(3))/(b**S(2)*n) - c**(S(4)/3)*log(b**(S(1)/3)*x**(-n/S(3)) + c**(S(1)/3))/(b**(S(7)/3)*n) + c**(S(4)/3)*log(b**(S(2)/3)*x**(-S(2)*n/S(3)) - b**(S(1)/3)*c**(S(1)/3)*x**(-n/S(3)) + c**(S(2)/3))/(S(2)*b**(S(7)/3)*n) + sqrt(S(3))*c**(S(4)/3)*atan(sqrt(S(3))*(-S(2)*b**(S(1)/3)*x**(-n/S(3)) + c**(S(1)/3))/(S(3)*c**(S(1)/3)))/(b**(S(7)/3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(4) + S(-1))/(b*x**n + c*x**(S(2)*n)), x), x, -S(4)*x**(-S(5)*n/S(4))/(S(5)*b*n) + S(4)*c*x**(-n/S(4))/(b**S(2)*n) + sqrt(S(2))*c**(S(5)/4)*log(-sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*x**(-n/S(4)) + sqrt(b)*x**(-n/S(2)) + sqrt(c))/(S(2)*b**(S(9)/4)*n) - sqrt(S(2))*c**(S(5)/4)*log(sqrt(S(2))*b**(S(1)/4)*c**(S(1)/4)*x**(-n/S(4)) + sqrt(b)*x**(-n/S(2)) + sqrt(c))/(S(2)*b**(S(9)/4)*n) - sqrt(S(2))*c**(S(5)/4)*atan(sqrt(S(2))*b**(S(1)/4)*x**(-n/S(4))/c**(S(1)/4) + S(-1))/(b**(S(9)/4)*n) - sqrt(S(2))*c**(S(5)/4)*atan(sqrt(S(2))*b**(S(1)/4)*x**(-n/S(4))/c**(S(1)/4) + S(1))/(b**(S(9)/4)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n*(p + S(-1)) + S(-1))*(b*x**n + c*x**(S(2)*n))**p, x), x, x**(-n*(p + S(1)))*(b*x**n + c*x**(S(2)*n))**(p + S(1))/(c*n*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n*(S(2)*p + S(1)) + S(-1))*(b*x**n + c*x**(S(2)*n))**p, x), x, -x**(-S(2)*n*(p + S(1)))*(b*x**n + c*x**(S(2)*n))**(p + S(1))/(b*n*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**p, x), x, -a*(a + b*x**n)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**p/(b**S(2)*n*(S(2)*p + S(1))) + (a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(p + S(1))/(S(2)*b**S(2)*n*(p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2), x), x, -a*(a + b*x**n)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2)/(S(6)*b**S(2)*n) + (a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(7)/2)/(S(7)*b**S(2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, -a*(a + b*x**n)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/(S(4)*b**S(2)*n) + (a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2)/(S(5)*b**S(2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, a*x**(S(2)*n)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(6)*n*(a + b*x**n)) + x**(S(2)*n)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, -a*(a + b*x**n)*log(a + b*x**n)/(b**S(2)*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))) + sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(b**S(2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, x**(S(2)*n)*(a + b*x**n)/(S(2)*a*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2), x), x, a*(a + b*x**n)/(S(4)*b**S(2)*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2)) - S(1)/(S(3)*b**S(2)*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(7)/2), x), x, a*(a + b*x**n)/(S(6)*b**S(2)*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(7)/2)) - S(1)/(S(5)*b**S(2)*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, a*n*(d*x)**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(d*(a + b*x**n)*(m + S(1))*(m + n + S(1))) + (d*x)**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(d*(m + n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, a*n*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a + b*x**n)*(S(3)*n + S(9))) + x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(n + S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, a*n*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a + b*x**n)*(S(2)*n + S(4))) + x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(n + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, a*n*x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a + b*x**n)*(n + S(1))) + x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/x, x), x, a*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))*log(x)/(a + b*x**n) + sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/n, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/x**S(2), x), x, a*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(x*(a + b*x**n)*(-n + S(1))) - sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(x*(-n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/x**S(3), x), x, a*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(x**S(2)*(a + b*x**n)*(-S(2)*n + S(4))) - sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(x**S(2)*(-n + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, a**S(3)*(d*x)**(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(d*(a + b*x**n)*(m + S(1))) + S(3)*a**S(2)*b**S(2)*x**(n + S(1))*(d*x)**m*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a*b + b**S(2)*x**n)*(m + n + S(1))) + S(3)*a*b**S(3)*x**(S(2)*n + S(1))*(d*x)**m*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a*b + b**S(2)*x**n)*(m + S(2)*n + S(1))) + b**S(4)*x**(S(3)*n + S(1))*(d*x)**m*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a*b + b**S(2)*x**n)*(m + S(3)*n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, a**S(3)*x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(3)*a + S(3)*b*x**n) + S(3)*a**S(2)*b**S(2)*x**(n + S(3))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((n + S(3))*(a*b + b**S(2)*x**n)) + S(3)*a*b**S(3)*x**(S(2)*n + S(3))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((S(2)*n + S(3))*(a*b + b**S(2)*x**n)) + b**S(4)*x**(S(3)*n + S(3))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((S(3)*n + S(3))*(a*b + b**S(2)*x**n)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, a**S(3)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(2)*a + S(2)*b*x**n) + S(3)*a**S(2)*b**S(2)*x**(n + S(2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((n + S(2))*(a*b + b**S(2)*x**n)) + S(3)*a*b**S(3)*x**(S(2)*n + S(2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((S(2)*n + S(2))*(a*b + b**S(2)*x**n)) + b**S(4)*x**(S(3)*n + S(2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((S(3)*n + S(2))*(a*b + b**S(2)*x**n)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, S(6)*a**S(3)*n**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((a + b*x**n)*(S(6)*n**S(3) + S(11)*n**S(2) + S(6)*n + S(1))) + S(6)*a**S(2)*n**S(2)*x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(6)*n**S(3) + S(11)*n**S(2) + S(6)*n + S(1)) + S(3)*n*x*(a**S(2) + a*b*x**n)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(6)*n**S(2) + S(5)*n + S(1)) + x*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/(S(3)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/x, x), x, a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))*log(x)/(a + b*x**n) + a**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/n + (a**S(2) + a*b*x**n)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(2)*n) + (a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/(S(3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/x**S(2), x), x, -a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(x*(a + b*x**n)) - S(3)*a**S(2)*b**S(2)*x**(n + S(-1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-n + S(1))*(a*b + b**S(2)*x**n)) - S(3)*a*b**S(3)*x**(S(2)*n + S(-1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-S(2)*n + S(1))*(a*b + b**S(2)*x**n)) - b**S(4)*x**(S(3)*n + S(-1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-S(3)*n + S(1))*(a*b + b**S(2)*x**n)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)/x**S(3), x), x, -a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/(S(2)*x**S(2)*(a + b*x**n)) - S(3)*a**S(2)*b**S(2)*x**(n + S(-2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-n + S(2))*(a*b + b**S(2)*x**n)) - S(3)*a*b**S(3)*x**(S(2)*n + S(-2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-S(2)*n + S(2))*(a*b + b**S(2)*x**n)) - b**S(4)*x**(S(3)*n + S(-2))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))/((-S(3)*n + S(2))*(a*b + b**S(2)*x**n)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, (d*x)**(m + S(1))*(a + b*x**n)*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -b*x**n/a)/(a*d*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, x**S(3)*(a + b*x**n)*hyper((S(1), S(3)/n), ((n + S(3))/n,), -b*x**n/a)/(S(3)*a*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, x**S(2)*(a + b*x**n)*hyper((S(1), S(2)/n), ((n + S(2))/n,), -b*x**n/a)/(S(2)*a*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n)), x), x, x*(a + b*x**n)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -b*x**n/a)/(a*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), x), x, (a + b*x**n)*log(x)/(a*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))) - (a + b*x**n)*log(a + b*x**n)/(a*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), x), x, -(a + b*x**n)*hyper((S(1), -S(1)/n), (-(-n + S(1))/n,), -b*x**n/a)/(a*x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), x), x, -(a + b*x**n)*hyper((S(1), -S(2)/n), (-(-n + S(2))/n,), -b*x**n/a)/(S(2)*a*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, (d*x)**(m + S(1))*(a + b*x**n)*hyper((S(3), (m + S(1))/n), ((m + n + S(1))/n,), -b*x**n/a)/(a**S(3)*d*(m + S(1))*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, x**S(3)*(a + b*x**n)*hyper((S(3), S(3)/n), ((n + S(3))/n,), -b*x**n/a)/(S(3)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2), x), x, x**S(2)*(a + b*x**n)*hyper((S(3), S(2)/n), ((n + S(2))/n,), -b*x**n/a)/(S(2)*a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(-3)/2), x), x, x*(a + b*x**n)*hyper((S(3), S(1)/n), (S(1) + S(1)/n,), -b*x**n/a)/(a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)), x), x, (a + b*x**n)/(S(2)*a*n*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)) + S(1)/(a**S(2)*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))) + (a + b*x**n)*log(x)/(a**S(3)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))) - (a + b*x**n)*log(a + b*x**n)/(a**S(3)*n*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)), x), x, -(a + b*x**n)*hyper((S(3), -S(1)/n), (-(-n + S(1))/n,), -b*x**n/a)/(a**S(3)*x*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(3)/2)), x), x, -(a + b*x**n)*hyper((S(3), -S(2)/n), (-(-n + S(2))/n,), -b*x**n/a)/(S(2)*a**S(3)*x**S(2)*sqrt(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(-S(1)/(S(2)*p + S(1))) + b**S(2)*x**(-S(2)/(S(2)*p + S(1))))**p, x), x, x*(a + b*x**(S(1)/(-S(2)*p + S(-1))))*(a**S(2) + S(2)*a*b*x**(S(1)/(-S(2)*p + S(-1))) + b**S(2)*x**(-S(2)/(S(2)*p + S(1))))**p/a, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**((-n + S(-1))/(S(2)*n)), x), x, x*(a + b*x**n)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(-(n + S(1))/(S(2)*n))/a, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**(-S(1)/(S(2)*p + S(2))) + b**S(2)*x**(-S(1)/(p + S(1))))**p, x), x, x*(a + b*x**(-S(1)/(S(2)*p + S(2))))*(S(2)*p + S(2))*(a**S(2) + S(2)*a*b*x**(-S(1)/(S(2)*p + S(2))) + b**S(2)*x**(-S(1)/(p + S(1))))**p/(a*(S(2)*p + S(1))) - x*(a**S(2) + S(2)*a*b*x**(-S(1)/(S(2)*p + S(2))) + b**S(2)*x**(-S(1)/(p + S(1))))**(p + S(1))/(a**S(2)*(S(2)*p + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**((-S(2)*n + S(-1))/(S(2)*n)), x), x, x*(a + b*x**n)*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(S(-1) - S(1)/(S(2)*n))/(a*(n + S(1))) + n*x*(a**S(2) + S(2)*a*b*x**n + b**S(2)*x**(S(2)*n))**(-S(1)/(S(2)*n))/(a**S(2)*(n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(4)*n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -b*x**n/(c**S(2)*n) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(3)*n*sqrt(-S(4)*a*c + b**S(2))) + x**(S(2)*n)/(S(2)*c*n) + (-a*c + b**S(2))*log(a + b*x**n + c*x**(S(2)*n))/(S(2)*c**S(3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(3)*n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -b*log(a + b*x**n + c*x**(S(2)*n))/(S(2)*c**S(2)*n) + x**n/(c*n) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(c**S(2)*n*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(S(2)*n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, b*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(c*n*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*x**n + c*x**(S(2)*n))/(S(2)*c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(n*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -x**(-n)/(a*n) - b*log(x)/a**S(2) + b*log(a + b*x**n + c*x**(S(2)*n))/(S(2)*a**S(2)*n) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(2)*n*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-S(2)*n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -x**(-S(2)*n)/(S(2)*a*n) + b*x**(-n)/(a**S(2)*n) + b*(-S(3)*a*c + b**S(2))*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*n*sqrt(-S(4)*a*c + b**S(2))) + (-a*c + b**S(2))*log(x)/a**S(3) - (-a*c + b**S(2))*log(a + b*x**n + c*x**(S(2)*n))/(S(2)*a**S(3)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-S(3)*n + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -x**(-S(3)*n)/(S(3)*a*n) + b*x**(-S(2)*n)/(S(2)*a**S(2)*n) - x**(-n)*(-a*c + b**S(2))/(a**S(3)*n) - b*(-S(2)*a*c + b**S(2))*log(x)/a**S(4) + b*(-S(2)*a*c + b**S(2))*log(a + b*x**n + c*x**(S(2)*n))/(S(2)*a**S(4)*n) - (S(2)*a**S(2)*c**S(2) - S(4)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(a**S(4)*n*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(4) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x**(n/S(4))/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(n*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) - S(2)*S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x**(n/S(4))/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(n*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)*S(2)**(S(3)/4)*c**(S(3)/4)*atan(S(2)**(S(1)/4)*c**(S(1)/4)*x**(n/S(4))/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(n*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))) + S(2)*S(2)**(S(3)/4)*c**(S(3)/4)*atanh(S(2)**(S(1)/4)*c**(S(1)/4)*x**(n/S(4))/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(n*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(3) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3)) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**(S(2)*n/S(3)) - S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3))*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(2)*n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3))/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) + S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3)) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*c**(S(2)/3)*log(S(2)**(S(2)/3)*c**(S(2)/3)*x**(S(2)*n/S(3)) - S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3))*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(2)*n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))) - S(2)**(S(2)/3)*sqrt(S(3))*c**(S(2)/3)*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*c**(S(1)/3)*x**(n/S(3))/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(n/S(2) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x**(n/S(2))/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(n*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))) + S(2)*sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x**(n/S(2))/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(n*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(2) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*x**(-n/S(2))/(a*n) + sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(a)*x**(-n/S(2))/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(a**(S(3)/2)*n*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(a)*x**(-n/S(2))/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(a**(S(3)/2)*n*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(3) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(3)*x**(-n/S(3))/(a*n) + S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3)) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(2)*a**(S(4)/3)*n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*a**(S(2)/3)*x**(-S(2)*n/S(3)) - S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3))*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(4)*a**(S(4)/3)*n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*sqrt(S(3))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3))/(b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(2)*a**(S(4)/3)*n*(b - sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) + S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3)) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3))/(S(2)*a**(S(4)/3)*n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*log(S(2)**(S(2)/3)*a**(S(2)/3)*x**(-S(2)*n/S(3)) - S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3))*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + (b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3))/(S(4)*a**(S(4)/3)*n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)) - S(2)**(S(2)/3)*sqrt(S(3))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(3))*(-S(2)*S(2)**(S(1)/3)*a**(S(1)/3)*x**(-n/S(3))/(b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/3) + S(1))/S(3))/(S(2)*a**(S(4)/3)*n*(b + sqrt(-S(4)*a*c + b**S(2)))**(S(2)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**(-n/S(4) + S(-1))/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(4)*x**(-n/S(4))/(a*n) - S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*a**(S(1)/4)*x**(-n/S(4))/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(a**(S(5)/4)*n*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) - S(2)**(S(3)/4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*a**(S(1)/4)*x**(-n/S(4))/(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(a**(S(5)/4)*n*(-b + sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) - S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(S(2)**(S(1)/4)*a**(S(1)/4)*x**(-n/S(4))/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(a**(S(5)/4)*n*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)) - S(2)**(S(3)/4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atanh(S(2)**(S(1)/4)*a**(S(1)/4)*x**(-n/S(4))/(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(1)/4))/(a**(S(5)/4)*n*(-b - sqrt(-S(4)*a*c + b**S(2)))**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*c*x**S(3)*hyper((S(1), S(3)/n), ((n + S(3))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(-S(12)*a*c + S(3)*b**S(2) + S(3)*b*sqrt(-S(4)*a*c + b**S(2))) - S(2)*c*x**S(3)*hyper((S(1), S(3)/n), ((n + S(3))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(-S(12)*a*c + S(3)*b**S(2) - S(3)*b*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**n + c*x**(S(2)*n)), x), x, -c*x**S(2)*hyper((S(1), S(2)/n), ((n + S(2))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2))) - c*x**S(2)*hyper((S(1), S(2)/n), ((n + S(2))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*c*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2))) - S(2)*c*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**n + c*x**(S(2)*n))), x), x, b*atanh((b + S(2)*c*x**n)/sqrt(-S(4)*a*c + b**S(2)))/(a*n*sqrt(-S(4)*a*c + b**S(2))) + log(x)/a - log(a + b*x**n + c*x**(S(2)*n))/(S(2)*a*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**n + c*x**(S(2)*n))), x), x, S(2)*c*hyper((S(1), -S(1)/n), (-(-n + S(1))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) + S(2)*c*hyper((S(1), -S(1)/n), (-(-n + S(1))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(x*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**n + c*x**(S(2)*n))), x), x, c*hyper((S(1), -S(2)/n), (-(-n + S(2))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(x**S(2)*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) + c*hyper((S(1), -S(2)/n), (-(-n + S(2))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(x**S(2)*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(3)*sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(4)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(4)/n, S(-1)/2, S(-1)/2, (n + S(4))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(3)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(3)/n, S(-1)/2, S(-1)/2, (n + S(3))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(2)/n, S(-1)/2, S(-1)/2, (n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1)/n, S(-1)/2, S(-1)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**n + c*x**(S(2)*n))/x**S(2), x), x, -sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(-S(1)/n, S(-1)/2, S(-1)/2, -(-n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**n + c*x**(S(2)*n))/x**S(3), x), x, -sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(-S(2)/n, S(-1)/2, S(-1)/2, -(-n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*x**S(4)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(4)/n, S(-3)/2, S(-3)/2, (n + S(4))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*x**S(3)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(3)/n, S(-3)/2, S(-3)/2, (n + S(3))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(2)/n, S(-3)/2, S(-3)/2, (n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*x*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1)/n, S(-3)/2, S(-3)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**n + c*x**(S(2)*n))**(S(3)/2)/x**S(2), x), x, -a*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(-S(1)/n, S(-3)/2, S(-3)/2, -(-n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((a + b*x**n + c*x**(S(2)*n))**(S(3)/2)/x**S(3), x), x, -a*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(-S(2)/n, S(-3)/2, S(-3)/2, -(-n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(4)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(4)/n, S(1)/2, S(1)/2, (n + S(4))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(3)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(3)/n, S(1)/2, S(1)/2, (n + S(3))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x**S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/n, S(1)/2, S(1)/2, (n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(S(1)/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/n, S(1)/2, S(1)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/sqrt(a + b*x**n + c*x**(S(2)*n)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, x**S(3)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(3)/n, S(3)/2, S(3)/2, (n + S(3))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(3)*a*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, x**S(2)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/n, S(3)/2, S(3)/2, (n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**n + c*x**(S(2)*n))**(S(-3)/2), x), x, x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/n, S(3)/2, S(3)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2)), x), x, (-S(4)*a*c + S(2)*b**S(2) + S(2)*b*c*x**n)/(a*n*(-S(4)*a*c + b**S(2))*sqrt(a + b*x**n + c*x**(S(2)*n))) - atanh((S(2)*a + b*x**n)/(S(2)*sqrt(a)*sqrt(a + b*x**n + c*x**(S(2)*n))))/(a**(S(3)/2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2)), x), x, -sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(-S(1)/n, S(3)/2, S(3)/2, -(-n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*x*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2)), x), x, -sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(-S(2)/n, S(3)/2, S(3)/2, -(-n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))), x), x, -sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(-S(1)/n, S(1)/2, S(1)/2, -(-n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(x*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x**S(3)*sqrt(a + b*x**n + c*x**(S(2)*n))), x), x, -sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(-S(2)/n, S(1)/2, S(1)/2, -(-n + S(2))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*x**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(3)/(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, x**S(4)*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(4)/n, S(3)/2, S(3)/2, (n + S(4))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*(d*x)**(m + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1((m + S(1))/n, S(-3)/2, S(-3)/2, (m + n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, (d*x)**(m + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1((m + S(1))/n, S(-1)/2, S(-1)/2, (m + n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1((m + S(1))/n, S(1)/2, S(1)/2, (m + n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, (d*x)**(m + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1((m + S(1))/n, S(3)/2, S(3)/2, (m + n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*(m + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**n + c*x**(S(2)*n))**p, x), x, (d*x)**(m + S(1))*(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**n + c*x**(S(2)*n))**p*AppellF1((m + S(1))/n, -p, -p, (m + n + S(1))/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(m + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x/sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6)), x), x, -d*(d + e*x)*sqrt(S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/3, S(1)/2, S(1)/2, S(4)/3, -S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(e**S(2)*sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6))) + (d + e*x)**S(2)*sqrt(S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/3, S(1)/2, S(1)/2, S(5)/3, -S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*e**S(2)*sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(x**S(2)/sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6)), x), x, d**S(2)*(d + e*x)*sqrt(S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/3, S(1)/2, S(1)/2, S(4)/3, -S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(e**S(3)*sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6))) - d*(d + e*x)**S(2)*sqrt(S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(2)/3, S(1)/2, S(1)/2, S(5)/3, -S(2)*c*(d + e*x)**S(3)/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*(d + e*x)**S(3)/(b + sqrt(-S(4)*a*c + b**S(2))))/(e**S(3)*sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6))) + atanh((b + S(2)*c*(d + e*x)**S(3))/(S(2)*sqrt(c)*sqrt(a + b*(d + e*x)**S(3) + c*(d + e*x)**S(6))))/(S(3)*sqrt(c)*e**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(a + b*x**n + c*x**(S(2)*n))/x, x), x, -sqrt(a)*atanh((S(2)*a + b*x**n)/(S(2)*sqrt(a)*sqrt(a + b*x**n + c*x**(S(2)*n))))/n + b*atanh((b + S(2)*c*x**n)/(S(2)*sqrt(c)*sqrt(a + b*x**n + c*x**(S(2)*n))))/(S(2)*sqrt(c)*n) + sqrt(a + b*x**n + c*x**(S(2)*n))/n, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**n + c*x**(S(2)*n))**(S(3)/2)/x, x), x, -a**(S(3)/2)*atanh((S(2)*a + b*x**n)/(S(2)*sqrt(a)*sqrt(a + b*x**n + c*x**(S(2)*n))))/n - b*(-S(12)*a*c + b**S(2))*atanh((b + S(2)*c*x**n)/(S(2)*sqrt(c)*sqrt(a + b*x**n + c*x**(S(2)*n))))/(S(16)*c**(S(3)/2)*n) + (a + b*x**n + c*x**(S(2)*n))**(S(3)/2)/(S(3)*n) + sqrt(a + b*x**n + c*x**(S(2)*n))*(S(8)*a*c + b**S(2) + S(2)*b*c*x**n)/(S(8)*c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(x*sqrt(a + b*x**n + c*x**(S(2)*n))), x), x, -atanh((S(2)*a + b*x**n)/(S(2)*sqrt(a)*sqrt(a + b*x**n + c*x**(S(2)*n))))/(sqrt(a)*n), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, a**S(3)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(3)*a**S(2)*b*x**(n + S(1))*(d*x)**m/(m + n + S(1)) + S(3)*a*x**(S(2)*n + S(1))*(d*x)**m*(a*c + b**S(2))/(m + S(2)*n + S(1)) + S(3)*b*c**S(2)*x**(S(5)*n + S(1))*(d*x)**m/(m + S(5)*n + S(1)) + b*x**(S(3)*n + S(1))*(d*x)**m*(S(6)*a*c + b**S(2))/(m + S(3)*n + S(1)) + c**S(3)*x**(S(6)*n + S(1))*(d*x)**m/(m + S(6)*n + S(1)) + S(3)*c*x**(S(4)*n + S(1))*(d*x)**m*(a*c + b**S(2))/(m + S(4)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, a**S(2)*(d*x)**(m + S(1))/(d*(m + S(1))) + S(2)*a*b*x**(n + S(1))*(d*x)**m/(m + n + S(1)) + S(2)*b*c*x**(S(3)*n + S(1))*(d*x)**m/(m + S(3)*n + S(1)) + c**S(2)*x**(S(4)*n + S(1))*(d*x)**m/(m + S(4)*n + S(1)) + x**(S(2)*n + S(1))*(d*x)**m*(S(2)*a*c + b**S(2))/(m + S(2)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m*(a + b*x**n + c*x**(S(2)*n)), x), x, a*(d*x)**(m + S(1))/(d*(m + S(1))) + b*x**(n + S(1))*(d*x)**m/(m + n + S(1)) + c*x**(S(2)*n + S(1))*(d*x)**m/(m + S(2)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**n + c*x**(S(2)*n)), x), x, -S(2)*c*(d*x)**(m + S(1))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(d*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))) + S(2)*c*(d*x)**(m + S(1))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(d*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, -c*(d*x)**(m + S(1))*(S(4)*a*c*(m - S(2)*n + S(1)) - b**S(2)*(m - n + S(1)) + b*sqrt(-S(4)*a*c + b**S(2))*(m - n + S(1)))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*d*n*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + c*(d*x)**(m + S(1))*(-b*(m - n + S(1)) + (S(4)*a*c*(m - S(2)*n + S(1)) - b**S(2)*(m - n + S(1)))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*d*n*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))) + (d*x)**(m + S(1))*(-S(2)*a*c + b**S(2) + b*c*x**n)/(a*d*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*x)**m/(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, (d*x)**(m + S(1))*(-S(2)*a*c + b**S(2) + b*c*x**n)/(S(2)*a*d*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)) - c*(d*x)**(m + S(1))*(S(8)*a**S(2)*c**S(2)*(m**S(2) + m*(-S(6)*n + S(2)) + S(8)*n**S(2) - S(6)*n + S(1)) - S(6)*a*b**S(2)*c*(m**S(2) + m*(-S(4)*n + S(2)) + S(3)*n**S(2) - S(4)*n + S(1)) + b**S(4)*(m**S(2) + m*(-S(3)*n + S(2)) + S(2)*n**S(2) - S(3)*n + S(1)) + b*sqrt(-S(4)*a*c + b**S(2))*(S(2)*a*c*(S(2)*m - S(7)*n + S(2)) - b**S(2)*(m - S(2)*n + S(1)))*(m - n + S(1)))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*d*n**S(2)*(b + sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(5)/2)) - c*(d*x)**(m + S(1))*(-S(8)*a**S(2)*c**S(2)*(m**S(2) + m*(-S(6)*n + S(2)) + S(8)*n**S(2) - S(6)*n + S(1)) + S(6)*a*b**S(2)*c*(m**S(2) + m*(-S(4)*n + S(2)) + S(3)*n**S(2) - S(4)*n + S(1)) - b**S(4)*(m**S(2) + m*(-S(3)*n + S(2)) + S(2)*n**S(2) - S(3)*n + S(1)) + b*sqrt(-S(4)*a*c + b**S(2))*(S(2)*a*c*(S(2)*m - S(7)*n + S(2)) - b**S(2)*(m - S(2)*n + S(1)))*(m - n + S(1)))*hyper((S(1), (m + S(1))/n), ((m + n + S(1))/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*d*n**S(2)*(b - sqrt(-S(4)*a*c + b**S(2)))*(m + S(1))*(-S(4)*a*c + b**S(2))**(S(5)/2)) - (d*x)**(m + S(1))*(S(4)*a**S(2)*c**S(2)*(m - S(4)*n + S(1)) - S(5)*a*b**S(2)*c*(m - S(3)*n + S(1)) + b**S(4)*(m - S(2)*n + S(1)) - b*c*x**n*(S(2)*a*c*(S(2)*m - S(7)*n + S(2)) - b**S(2)*(m - S(2)*n + S(1))))/(S(2)*a**S(2)*d*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, a*(d + e*x)**S(4)/(S(4)*e) + b*(d + e*x)**S(6)/(S(6)*e) + c*(d + e*x)**S(8)/(S(8)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, a**S(2)*(d + e*x)**S(4)/(S(4)*e) + a*b*(d + e*x)**S(6)/(S(3)*e) + b*c*(d + e*x)**S(10)/(S(5)*e) + c**S(2)*(d + e*x)**S(12)/(S(12)*e) + (d + e*x)**S(8)*(S(2)*a*c + b**S(2))/(S(8)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, a**S(3)*(d + e*x)**S(4)/(S(4)*e) + a**S(2)*b*(d + e*x)**S(6)/(S(2)*e) + S(3)*a*(d + e*x)**S(8)*(a*c + b**S(2))/(S(8)*e) + S(3)*b*c**S(2)*(d + e*x)**S(14)/(S(14)*e) + b*(d + e*x)**S(10)*(S(6)*a*c + b**S(2))/(S(10)*e) + c**S(3)*(d + e*x)**S(16)/(S(16)*e) + c*(d + e*x)**S(12)*(a*c + b**S(2))/(S(4)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, a*f**S(3)*(d + e*x)**S(4)/(S(4)*e) + b*f**S(3)*(d + e*x)**S(6)/(S(6)*e) + c*f**S(3)*(d + e*x)**S(8)/(S(8)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, a**S(2)*f**S(3)*(d + e*x)**S(4)/(S(4)*e) + a*b*f**S(3)*(d + e*x)**S(6)/(S(3)*e) + b*c*f**S(3)*(d + e*x)**S(10)/(S(5)*e) + c**S(2)*f**S(3)*(d + e*x)**S(12)/(S(12)*e) + f**S(3)*(d + e*x)**S(8)*(S(2)*a*c + b**S(2))/(S(8)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, a**S(3)*f**S(3)*(d + e*x)**S(4)/(S(4)*e) + a**S(2)*b*f**S(3)*(d + e*x)**S(6)/(S(2)*e) + S(3)*a*f**S(3)*(d + e*x)**S(8)*(a*c + b**S(2))/(S(8)*e) + S(3)*b*c**S(2)*f**S(3)*(d + e*x)**S(14)/(S(14)*e) + b*f**S(3)*(d + e*x)**S(10)*(S(6)*a*c + b**S(2))/(S(10)*e) + c**S(3)*f**S(3)*(d + e*x)**S(16)/(S(16)*e) + c*f**S(3)*(d + e*x)**S(12)*(a*c + b**S(2))/(S(4)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, x/c - sqrt(S(2))*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, b*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*e*sqrt(-S(4)*a*c + b**S(2))) + log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*c*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, -sqrt(S(2))*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*e*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*e*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, -atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, b*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a*e*sqrt(-S(4)*a*c + b**S(2))) + log(d + e*x)/(a*e) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -sqrt(S(2))*sqrt(c)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*sqrt(c)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - S(1)/(a*e*(d + e*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -S(1)/(S(2)*a*e*(d + e*x)**S(2)) - b*log(d + e*x)/(a**S(2)*e) + b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(2)*e) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*e*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(4)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -S(1)/(S(3)*a*e*(d + e*x)**S(3)) + b/(a**S(2)*e*(d + e*x)) + sqrt(S(2))*sqrt(c)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*sqrt(c)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, (S(2)*a + b*(d + e*x)**S(2))*(d + e*x)/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + sqrt(S(2))*(b - (S(4)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + sqrt(S(2))*(S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, -b*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (S(2)*a + b*(d + e*x)**S(2))/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, -sqrt(S(2))*sqrt(c)*(S(2)*b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(S(2)*b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - (b + S(2)*c*(d + e*x)**S(2))*(d + e*x)/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, S(2)*c*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (-b - S(2)*c*(d + e*x)**S(2))/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**(S(-2)), x), x, -sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + (d + e*x)*(-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*e*(-S(4)*a*c + b**S(2))**(S(3)/2)) + log(d + e*x)/(a**S(2)*e) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(2)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*(d + e*x)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) - (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) + (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - (-S(10)*a*c + S(3)*b**S(2))/(S(2)*a**S(2)*e*(d + e*x)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (-S(3)*a*c + b**S(2))/(a**S(2)*e*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))) - S(2)*b*log(d + e*x)/(a**S(3)*e) + b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(2)*a**S(3)*e) - (S(6)*a**S(2)*c**S(2) - S(6)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*e*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(4)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*(d + e*x)**S(3)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (-S(14)*a*c + S(5)*b**S(2))/(S(6)*a**S(2)*e*(d + e*x)**S(3)*(-S(4)*a*c + b**S(2))) + b*(-S(19)*a*c + S(5)*b**S(2))/(S(2)*a**S(3)*e*(d + e*x)*(-S(4)*a*c + b**S(2))) - sqrt(S(2))*sqrt(c)*(S(28)*a**S(2)*c**S(2) - S(29)*a*b**S(2)*c + S(5)*b**S(4) - b*(-S(19)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(3)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(S(28)*a**S(2)*c**S(2) - S(29)*a*b**S(2)*c + S(5)*b**S(4) + b*(-S(19)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(3)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -S(3)*sqrt(S(2))*sqrt(c)*(S(4)*a*c + S(3)*b**S(2) + S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(8)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*sqrt(S(2))*sqrt(c)*(S(4)*a*c + S(3)*b**S(2) - S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(8)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + (S(2)*a + b*(d + e*x)**S(2))*(d + e*x)/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) - (d + e*x)*(-S(4)*a*c + S(7)*b**S(2) + S(12)*b*c*(d + e*x)**S(2))/(S(8)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, S(3)*b*c*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*b*(b + S(2)*c*(d + e*x)**S(2))/(S(4)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + (S(2)*a + b*(d + e*x)**S(2))/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -(b + S(2)*c*(d + e*x)**S(2))*(d + e*x)/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + sqrt(S(2))*sqrt(c)*(S(20)*a*c + b**S(2) - b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*(S(20)*a*c + b**S(2) + b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + (d + e*x)*(b*(S(8)*a*c + b**S(2)) + c*(d + e*x)**S(2)*(S(20)*a*c + b**S(2)))/(S(8)*a*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -S(6)*c**S(2)*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*c*(b + S(2)*c*(d + e*x)**S(2))/(S(2)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + (-b - S(2)*c*(d + e*x)**S(2))/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**(S(-3)), x), x, (d + e*x)*(-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + S(3)*sqrt(S(2))*sqrt(c)*(-S(8)*a*b*c + b**S(3) - (S(56)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + S(3)*sqrt(S(2))*sqrt(c)*(S(56)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4) + b*(-S(8)*a*c + b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + (d + e*x)*(S(3)*b*c*(d + e*x)**S(2)*(-S(8)*a*c + b**S(2)) + (-S(7)*a*c + b**S(2))*(-S(4)*a*c + S(3)*b**S(2)))/(S(8)*a**S(2)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(16)*a**S(2)*c**S(2) - S(15)*a*b**S(2)*c + S(2)*b**S(4) + S(2)*b*c*(d + e*x)**S(2)*(-S(7)*a*c + b**S(2)))/(S(4)*a**S(2)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(3)*e*(-S(4)*a*c + b**S(2))**(S(5)/2)) + log(d + e*x)/(a**S(3)*e) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(3)*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*(d + e*x)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(36)*a**S(2)*c**S(2) - S(35)*a*b**S(2)*c + S(5)*b**S(4) + b*c*(d + e*x)**S(2)*(-S(32)*a*c + S(5)*b**S(2)))/(S(8)*a**S(2)*e*(d + e*x)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - S(3)*sqrt(S(2))*sqrt(c)*((-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)) - (S(124)*a**S(2)*b*c**S(2) - S(47)*a*b**S(3)*c + S(5)*b**S(5))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*sqrt(S(2))*sqrt(c)*(b*(S(124)*a**S(2)*c**S(2) - S(47)*a*b**S(2)*c + S(5)*b**S(4))/sqrt(-S(4)*a*c + b**S(2)) + (-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - (-S(36)*a*c + S(15)*b**S(2))*(-S(5)*a*c + b**S(2))/(S(8)*a**S(3)*e*(d + e*x)*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(20)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4) + S(3)*b*c*(d + e*x)**S(2)*(-S(6)*a*c + b**S(2)))/(S(4)*a**S(2)*e*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (S(30)*a**S(2)*c**S(2) - S(21)*a*b**S(2)*c + S(3)*b**S(4))/(S(2)*a**S(3)*e*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*b*log(d + e*x)/(a**S(4)*e) + S(3)*b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(4)*e) - (-S(60)*a**S(3)*c**S(3) + S(90)*a**S(2)*b**S(2)*c**S(2) - S(30)*a*b**S(4)*c + S(3)*b**S(6))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(4)*e*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, f**S(4)*x/c - sqrt(S(2))*f**S(4)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*f**S(4)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, b*f**S(3)*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*c*e*sqrt(-S(4)*a*c + b**S(2))) + f**S(3)*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*c*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, -sqrt(S(2))*f**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*e*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*f**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*e*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4)), x), x, -f*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, b*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a*e*f*sqrt(-S(4)*a*c + b**S(2))) + log(d + e*x)/(a*e*f) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a*e*f), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -sqrt(S(2))*sqrt(c)*(-b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*e*f**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) - sqrt(S(2))*sqrt(c)*(b/sqrt(-S(4)*a*c + b**S(2)) + S(1))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a*e*f**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))) - S(1)/(a*e*f**S(2)*(d + e*x)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -S(1)/(S(2)*a*e*f**S(3)*(d + e*x)**S(2)) - b*log(d + e*x)/(a**S(2)*e*f**S(3)) + b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(2)*e*f**S(3)) - (-S(2)*a*c + b**S(2))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*e*f**S(3)*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(4)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), x), x, -S(1)/(S(3)*a*e*f**S(4)*(d + e*x)**S(3)) + b/(a**S(2)*e*f**S(4)*(d + e*x)) + sqrt(S(2))*sqrt(c)*(b - (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*e*f**S(4)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*sqrt(c)*(b + (-S(2)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*e*f**S(4)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, f**S(4)*(S(2)*a + b*(d + e*x)**S(2))*(d + e*x)/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + sqrt(S(2))*f**S(4)*(b - (S(4)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + sqrt(S(2))*f**S(4)*(S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, -b*f**S(3)*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(3)/2)) + f**S(3)*(S(2)*a + b*(d + e*x)**S(2))/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, -sqrt(S(2))*sqrt(c)*f**S(2)*(S(2)*b + sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*f**S(2)*(S(2)*b - sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - f**S(2)*(b + S(2)*c*(d + e*x)**S(2))*(d + e*x)/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2), x), x, S(2)*c*f*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(3)/2)) - f*(b + S(2)*c*(d + e*x)**S(2))/(e*(-S(8)*a*c + S(2)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*f*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + b*(-S(6)*a*c + b**S(2))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(2)*e*f*(-S(4)*a*c + b**S(2))**(S(3)/2)) + log(d + e*x)/(a**S(2)*e*f) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(2)*e*f), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*f**S(2)*(d + e*x)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) - (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*e*f**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - sqrt(S(2))*sqrt(c)*(-S(16)*a*b*c + S(3)*b**S(3) + (-S(10)*a*c + S(3)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(2)*e*f**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - (-S(10)*a*c + S(3)*b**S(2))/(S(2)*a**S(2)*e*f**S(2)*(d + e*x)*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*f**S(3)*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (-S(3)*a*c + b**S(2))/(a**S(2)*e*f**S(3)*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))) - S(2)*b*log(d + e*x)/(a**S(3)*e*f**S(3)) + b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(2)*a**S(3)*e*f**S(3)) - (S(6)*a**S(2)*c**S(2) - S(6)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(a**S(3)*e*f**S(3)*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(4)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(2)*a*e*f**S(4)*(d + e*x)**S(3)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (-S(14)*a*c + S(5)*b**S(2))/(S(6)*a**S(2)*e*f**S(4)*(d + e*x)**S(3)*(-S(4)*a*c + b**S(2))) + b*(-S(19)*a*c + S(5)*b**S(2))/(S(2)*a**S(3)*e*f**S(4)*(d + e*x)*(-S(4)*a*c + b**S(2))) - sqrt(S(2))*sqrt(c)*(S(28)*a**S(2)*c**S(2) - S(29)*a*b**S(2)*c + S(5)*b**S(4) - b*(-S(19)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(3)*e*f**S(4)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(S(28)*a**S(2)*c**S(2) - S(29)*a*b**S(2)*c + S(5)*b**S(4) + b*(-S(19)*a*c + S(5)*b**S(2))*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a**S(3)*e*f**S(4)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(4)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -S(3)*sqrt(S(2))*sqrt(c)*f**S(4)*(S(4)*a*c + S(3)*b**S(2) + S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(8)*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*sqrt(S(2))*sqrt(c)*f**S(4)*(S(4)*a*c + S(3)*b**S(2) - S(2)*b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(8)*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(5)/2)) + f**S(4)*(S(2)*a + b*(d + e*x)**S(2))*(d + e*x)/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) - f**S(4)*(d + e*x)*(-S(4)*a*c + S(7)*b**S(2) + S(12)*b*c*(d + e*x)**S(2))/(S(8)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(3)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, S(3)*b*c*f**S(3)*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(5)/2)) - S(3)*b*f**S(3)*(b + S(2)*c*(d + e*x)**S(2))/(S(4)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + f**S(3)*(S(2)*a + b*(d + e*x)**S(2))/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)**S(2)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -f**S(2)*(b + S(2)*c*(d + e*x)**S(2))*(d + e*x)/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + sqrt(S(2))*sqrt(c)*f**S(2)*(S(20)*a*c + b**S(2) - b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*e*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*f**S(2)*(S(20)*a*c + b**S(2) + b*(-S(52)*a*c + b**S(2))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a*e*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + f**S(2)*(d + e*x)*(b*(S(8)*a*c + b**S(2)) + c*(d + e*x)**S(2)*(S(20)*a*c + b**S(2)))/(S(8)*a*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d*f + e*f*x)/(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3), x), x, -S(6)*c**S(2)*f*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(e*(-S(4)*a*c + b**S(2))**(S(5)/2)) + S(3)*c*f*(b + S(2)*c*(d + e*x)**S(2))/(S(2)*e*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - f*(b + S(2)*c*(d + e*x)**S(2))/(e*(-S(16)*a*c + S(4)*b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*f*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(16)*a**S(2)*c**S(2) - S(15)*a*b**S(2)*c + S(2)*b**S(4) + S(2)*b*c*(d + e*x)**S(2)*(-S(7)*a*c + b**S(2)))/(S(4)*a**S(2)*e*f*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) + b*(S(30)*a**S(2)*c**S(2) - S(10)*a*b**S(2)*c + b**S(4))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(3)*e*f*(-S(4)*a*c + b**S(2))**(S(5)/2)) + log(d + e*x)/(a**S(3)*e*f) - log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(3)*e*f), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*f**S(2)*(d + e*x)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(36)*a**S(2)*c**S(2) - S(35)*a*b**S(2)*c + S(5)*b**S(4) + b*c*(d + e*x)**S(2)*(-S(32)*a*c + S(5)*b**S(2)))/(S(8)*a**S(2)*e*f**S(2)*(d + e*x)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - S(3)*sqrt(S(2))*sqrt(c)*((-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)) - (S(124)*a**S(2)*b*c**S(2) - S(47)*a*b**S(3)*c + S(5)*b**S(5))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*e*f**S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*sqrt(S(2))*sqrt(c)*(b*(S(124)*a**S(2)*c**S(2) - S(47)*a*b**S(2)*c + S(5)*b**S(4))/sqrt(-S(4)*a*c + b**S(2)) + (-S(12)*a*c + S(5)*b**S(2))*(-S(5)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*(d + e*x)/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(16)*a**S(3)*e*f**S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - (-S(36)*a*c + S(15)*b**S(2))*(-S(5)*a*c + b**S(2))/(S(8)*a**S(3)*e*f**S(2)*(d + e*x)*(-S(4)*a*c + b**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d*f + e*f*x)**S(3)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(3)), x), x, (-S(2)*a*c + b**S(2) + b*c*(d + e*x)**S(2))/(S(4)*a*e*f**S(3)*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))**S(2)) + (S(20)*a**S(2)*c**S(2) - S(20)*a*b**S(2)*c + S(3)*b**S(4) + S(3)*b*c*(d + e*x)**S(2)*(-S(6)*a*c + b**S(2)))/(S(4)*a**S(2)*e*f**S(3)*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))) - (S(30)*a**S(2)*c**S(2) - S(21)*a*b**S(2)*c + S(3)*b**S(4))/(S(2)*a**S(3)*e*f**S(3)*(d + e*x)**S(2)*(-S(4)*a*c + b**S(2))**S(2)) - S(3)*b*log(d + e*x)/(a**S(4)*e*f**S(3)) + S(3)*b*log(a + b*(d + e*x)**S(2) + c*(d + e*x)**S(4))/(S(4)*a**S(4)*e*f**S(3)) - (-S(60)*a**S(3)*c**S(3) + S(90)*a**S(2)*b**S(2)*c**S(2) - S(30)*a*b**S(4)*c + S(3)*b**S(6))*atanh((b + S(2)*c*(d + e*x)**S(2))/sqrt(-S(4)*a*c + b**S(2)))/(S(2)*a**S(4)*e*f**S(3)*(-S(4)*a*c + b**S(2))**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(3)*x + S(2))**S(6)*((S(3)*x + S(2))**S(14) + (S(3)*x + S(2))**S(7) + S(1)), x), x, (S(3)*x + S(2))**S(21)/S(63) + (S(3)*x + S(2))**S(14)/S(42) + (S(3)*x + S(2))**S(7)/S(21), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(3)*x + S(2))**S(6)*((S(3)*x + S(2))**S(14) + (S(3)*x + S(2))**S(7) + S(1))**S(2), x), x, (S(3)*x + S(2))**S(35)/S(105) + (S(3)*x + S(2))**S(28)/S(42) + (S(3)*x + S(2))**S(21)/S(21) + (S(3)*x + S(2))**S(14)/S(21) + (S(3)*x + S(2))**S(7)/S(21), expand=True, _diff=True, _numerical=True)


def test_2():

    assert rubi_test(rubi_integrate((c + d*x**S(2))/(a + b*x**S(4)), x), x, -sqrt(S(2))*(-sqrt(a)*d + sqrt(b)*c)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(8)*a**(S(3)/4)*b**(S(3)/4)) + sqrt(S(2))*(-sqrt(a)*d + sqrt(b)*c)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(8)*a**(S(3)/4)*b**(S(3)/4)) - sqrt(S(2))*(sqrt(a)*d + sqrt(b)*c)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(4)*a**(S(3)/4)*b**(S(3)/4)) + sqrt(S(2))*(sqrt(a)*d + sqrt(b)*c)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(4)*a**(S(3)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((c - d*x**S(2))/(a + b*x**S(4)), x), x, -sqrt(S(2))*(-sqrt(a)*d + sqrt(b)*c)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(4)*a**(S(3)/4)*b**(S(3)/4)) + sqrt(S(2))*(-sqrt(a)*d + sqrt(b)*c)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(4)*a**(S(3)/4)*b**(S(3)/4)) - sqrt(S(2))*(sqrt(a)*d + sqrt(b)*c)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(8)*a**(S(3)/4)*b**(S(3)/4)) + sqrt(S(2))*(sqrt(a)*d + sqrt(b)*c)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(8)*a**(S(3)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((c + d*x**S(2))/(a - b*x**S(4)), x), x, (-sqrt(a)*d + sqrt(b)*c)*atan(b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(3)/4)*b**(S(3)/4)) + (sqrt(a)*d + sqrt(b)*c)*atanh(b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(3)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((c - d*x**S(2))/(a - b*x**S(4)), x), x, (-sqrt(a)*d + sqrt(b)*c)*atanh(b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(3)/4)*b**(S(3)/4)) + (sqrt(a)*d + sqrt(b)*c)*atan(b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(3)/4)*b**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(3)*x**S(2) + S(2))/(S(9)*x**S(4) + S(4)), x), x, sqrt(S(3))*atan(sqrt(S(3))*x + S(-1))/S(6) + sqrt(S(3))*atan(sqrt(S(3))*x + S(1))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(3)*x**S(2) + S(2))/(S(9)*x**S(4) + S(4)), x), x, -sqrt(S(3))*log(S(3)*x**S(2) - S(2)*sqrt(S(3))*x + S(2))/S(12) + sqrt(S(3))*log(S(3)*x**S(2) + S(2)*sqrt(S(3))*x + S(2))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(3)*x**S(2) + S(2))/(-S(9)*x**S(4) + S(4)), x), x, sqrt(S(6))*atanh(sqrt(S(6))*x/S(2))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(3)*x**S(2) + S(2))/(-S(9)*x**S(4) + S(4)), x), x, sqrt(S(6))*atan(sqrt(S(6))*x/S(2))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((sqrt(a)*sqrt(b) + b*x**S(2))/(a + b*x**S(4)), x), x, -sqrt(S(2))*b**(S(1)/4)*atan(S(1) - sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(1)/4)) + sqrt(S(2))*b**(S(1)/4)*atan(S(1) + sqrt(S(2))*b**(S(1)/4)*x/a**(S(1)/4))/(S(2)*a**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((sqrt(a)*sqrt(b) - b*x**S(2))/(a + b*x**S(4)), x), x, -sqrt(S(2))*b**(S(1)/4)*log(-sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(4)*a**(S(1)/4)) + sqrt(S(2))*b**(S(1)/4)*log(sqrt(S(2))*a**(S(1)/4)*b**(S(1)/4)*x + sqrt(a) + sqrt(b)*x**S(2))/(S(4)*a**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(d**S(2) + e**S(2)*x**S(4)), x), x, -sqrt(S(2))*atan(S(1) - sqrt(S(2))*sqrt(e)*x/sqrt(d))/(S(2)*sqrt(d)*sqrt(e)) + sqrt(S(2))*atan(S(1) + sqrt(S(2))*sqrt(e)*x/sqrt(d))/(S(2)*sqrt(d)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(d**S(2) + e**S(2)*x**S(4)), x), x, -sqrt(S(2))*log(-sqrt(S(2))*sqrt(d)*sqrt(e)*x + d + e*x**S(2))/(S(4)*sqrt(d)*sqrt(e)) + sqrt(S(2))*log(sqrt(S(2))*sqrt(d)*sqrt(e)*x + d + e*x**S(2))/(S(4)*sqrt(d)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(5))/(x**S(4) + S(-1)), x), x, -S(3)*atan(x)/S(2) - S(7)*atanh(x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/sqrt(a + c*x**S(4)), x), x, -S(3)*a**(S(1)/4)*e*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-a*e**S(2) + S(5)*c*d**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(5)*c**(S(7)/4)*sqrt(a + c*x**S(4))) + a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(3)*a*e**S(3) + S(15)*c*d**S(2)*e + S(5)*sqrt(c)*d*(-a*e**S(2) + c*d**S(2))/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(10)*c**(S(7)/4)*sqrt(a + c*x**S(4))) + d*e**S(2)*x*sqrt(a + c*x**S(4))/c + e**S(3)*x**S(3)*sqrt(a + c*x**S(4))/(S(5)*c) + S(3)*e*x*sqrt(a + c*x**S(4))*(-a*e**S(2) + S(5)*c*d**S(2))/(S(5)*c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/sqrt(a + c*x**S(4)), x), x, -S(2)*a**(S(1)/4)*d*e*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(a + c*x**S(4))) + e**S(2)*x*sqrt(a + c*x**S(4))/(S(3)*c) + S(2)*d*e*x*sqrt(a + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))) + sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(6)*sqrt(a)*sqrt(c)*d*e - a*e**S(2) + S(3)*c*d**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(6)*a**(S(1)/4)*c**(S(5)/4)*sqrt(a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(a + c*x**S(4)), x), x, -a**(S(1)/4)*e*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(a + c*x**S(4))) + a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*c**(S(3)/4)*sqrt(a + c*x**S(4))) + e*x*sqrt(a + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a + c*x**S(4))*(d + e*x**S(2))), x), x, atan(x*sqrt(a*e/d + c*d/e)/sqrt(a + c*x**S(4)))/(S(2)*d*sqrt(a*e/d + c*d/e)) + c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*a**(S(1)/4)*sqrt(a + c*x**S(4))*(-sqrt(a)*e + sqrt(c)*d)) - sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_pi(-sqrt(a)*(-e + sqrt(c)*d/sqrt(a))**S(2)/(S(4)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(4)*a**(S(1)/4)*c**(S(1)/4)*d*sqrt(a + c*x**S(4))*(-e + sqrt(c)*d/sqrt(a))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a + c*x**S(4))*(d + e*x**S(2))**S(2)), x), x, a**(S(1)/4)*c**(S(1)/4)*e*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*d*sqrt(a + c*x**S(4))*(a*e**S(2) + c*d**S(2))) - a**(S(1)/4)*c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(4)*d*sqrt(a + c*x**S(4))*(a*e**S(2) + c*d**S(2))) - a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*(a*e**S(2) + S(3)*c*d**S(2))*elliptic_pi(-(-sqrt(a)*e + sqrt(c)*d)**S(2)/(S(4)*sqrt(a)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(8)*c**(S(1)/4)*d**S(2)*sqrt(a + c*x**S(4))*(-sqrt(a)*e + sqrt(c)*d)*(a*e**S(2) + c*d**S(2))) - sqrt(c)*e*x*sqrt(a + c*x**S(4))/(S(2)*d*(sqrt(a) + sqrt(c)*x**S(2))*(a*e**S(2) + c*d**S(2))) + e**S(2)*x*sqrt(a + c*x**S(4))/(S(2)*d*(d + e*x**S(2))*(a*e**S(2) + c*d**S(2))) + (a*e**S(2) + S(3)*c*d**S(2))*atan(x*sqrt(a*e/d + c*d/e)/sqrt(a + c*x**S(4)))/(S(4)*d**S(3)*e*(a*e/d + c*d/e)**(S(3)/2)) + c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(a*e**S(2) + S(3)*c*d**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(4)*a**(S(1)/4)*d*sqrt(a + c*x**S(4))*(-sqrt(a)*e + sqrt(c)*d)*(a*e**S(2) + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/sqrt(a - c*x**S(4)), x), x, S(3)*a**(S(3)/4)*e*sqrt(S(1) - c*x**S(4)/a)*(a*e**S(2) + S(5)*c*d**S(2))*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(5)*c**(S(7)/4)*sqrt(a - c*x**S(4))) - a**(S(3)/4)*sqrt(S(1) - c*x**S(4)/a)*(S(3)*a*e**S(3) + S(15)*c*d**S(2)*e - S(5)*sqrt(c)*d*(a*e**S(2) + c*d**S(2))/sqrt(a))*elliptic_f(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(5)*c**(S(7)/4)*sqrt(a - c*x**S(4))) - d*e**S(2)*x*sqrt(a - c*x**S(4))/c - e**S(3)*x**S(3)*sqrt(a - c*x**S(4))/(S(5)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/sqrt(a - c*x**S(4)), x), x, S(2)*a**(S(3)/4)*d*e*sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(3)/4)*sqrt(a - c*x**S(4))) + a**(S(1)/4)*sqrt(S(1) - c*x**S(4)/a)*(-S(6)*sqrt(a)*sqrt(c)*d*e + a*e**S(2) + S(3)*c*d**S(2))*elliptic_f(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(3)*c**(S(5)/4)*sqrt(a - c*x**S(4))) - e**S(2)*x*sqrt(a - c*x**S(4))/(S(3)*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(a - c*x**S(4)), x), x, a**(S(3)/4)*e*sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(3)/4)*sqrt(a - c*x**S(4))) + a**(S(3)/4)*sqrt(S(1) - c*x**S(4)/a)*(-e + sqrt(c)*d/sqrt(a))*elliptic_f(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(3)/4)*sqrt(a - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a - c*x**S(4))*(d + e*x**S(2))), x), x, a**(S(1)/4)*sqrt(S(1) - c*x**S(4)/a)*elliptic_pi(-sqrt(a)*e/(sqrt(c)*d), asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(1)/4)*d*sqrt(a - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(a - c*x**S(4))*(d + e*x**S(2))**S(2)), x), x, -a**(S(3)/4)*c**(S(1)/4)*e*sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(2)*d*sqrt(a - c*x**S(4))*(-a*e**S(2) + c*d**S(2))) - a**(S(1)/4)*c**(S(1)/4)*sqrt(S(1) - c*x**S(4)/a)*elliptic_f(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(2)*d*sqrt(a - c*x**S(4))*(sqrt(a)*e + sqrt(c)*d)) + a**(S(1)/4)*sqrt(S(1) - c*x**S(4)/a)*(-a*e**S(2) + S(3)*c*d**S(2))*elliptic_pi(-sqrt(a)*e/(sqrt(c)*d), asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(S(2)*c**(S(1)/4)*d**S(2)*sqrt(a - c*x**S(4))*(-a*e**S(2) + c*d**S(2))) - e**S(2)*x*sqrt(a - c*x**S(4))/(S(2)*d*(d + e*x**S(2))*(-a*e**S(2) + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(-a + c*x**S(4)), x), x, a**(S(3)/4)*e*sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(3)/4)*sqrt(-a + c*x**S(4))) + a**(S(3)/4)*sqrt(S(1) - c*x**S(4)/a)*(-e + sqrt(c)*d/sqrt(a))*elliptic_f(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(3)/4)*sqrt(-a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(-a + c*x**S(4))*(d + e*x**S(2))), x), x, a**(S(1)/4)*sqrt(S(1) - c*x**S(4)/a)*elliptic_pi(-sqrt(a)*e/(sqrt(c)*d), asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(1)/4)*d*sqrt(-a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((sqrt(a) + sqrt(c)*x**S(2))/sqrt(-a + c*x**S(4)), x), x, a**(S(3)/4)*sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(c**(S(1)/4)*x/a**(S(1)/4)), S(-1))/(c**(S(1)/4)*sqrt(-a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2)*sqrt(c/a) + S(1))/sqrt(-a + c*x**S(4)), x), x, sqrt(S(1) - c*x**S(4)/a)*elliptic_e(asin(x*(c/a)**(S(1)/4)), S(-1))/((c/a)**(S(1)/4)*sqrt(-a + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(-a - c*x**S(4)), x), x, -a**(S(1)/4)*e*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(c**(S(3)/4)*sqrt(-a - c*x**S(4))) + a**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*c**(S(3)/4)*sqrt(-a - c*x**S(4))) - e*x*sqrt(-a - c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(-a - c*x**S(4))*(d + e*x**S(2))), x), x, atan(x*sqrt(-a*e/d - c*d/e)/sqrt(-a - c*x**S(4)))/(S(2)*d*sqrt(-a*e/d - c*d/e)) + c**(S(1)/4)*sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(2)*a**(S(1)/4)*sqrt(-a - c*x**S(4))*(-sqrt(a)*e + sqrt(c)*d)) - sqrt((a + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_pi(-sqrt(a)*(-e + sqrt(c)*d/sqrt(a))**S(2)/(S(4)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2)/(S(4)*a**(S(1)/4)*c**(S(1)/4)*d*sqrt(-a - c*x**S(4))*(-e + sqrt(c)*d/sqrt(a))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((a + b*x**S(2))*sqrt(-S(5)*x**S(4) + S(4))), x), x, sqrt(S(2))*S(5)**(S(3)/4)*elliptic_pi(-S(2)*sqrt(S(5))*b/(S(5)*a), asin(sqrt(S(2))*S(5)**(S(1)/4)*x/S(2)), S(-1))/(S(10)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((a + b*x**S(2))*sqrt(S(5)*x**S(4) + S(4))), x), x, sqrt(S(2))*S(5)**(S(1)/4)*sqrt((S(5)*x**S(4) + S(4))/(sqrt(S(5))*x**S(2) + S(2))**S(2))*(sqrt(S(5))*x**S(2) + S(2))*elliptic_f(S(2)*atan(sqrt(S(2))*S(5)**(S(1)/4)*x/S(2)), S(1)/2)/(S(4)*sqrt(S(5)*x**S(4) + S(4))*(sqrt(S(5))*a - S(2)*b)) - sqrt(S(2))*S(5)**(S(3)/4)*sqrt((S(5)*x**S(4) + S(4))/(sqrt(S(5))*x**S(2) + S(2))**S(2))*(sqrt(S(5))*a + S(2)*b)*(sqrt(S(5))*x**S(2) + S(2))*elliptic_pi(-sqrt(S(5))*(sqrt(S(5))*a - S(2)*b)**S(2)/(S(40)*a*b), S(2)*atan(sqrt(S(2))*S(5)**(S(1)/4)*x/S(2)), S(1)/2)/(S(40)*a*sqrt(S(5)*x**S(4) + S(4))*(sqrt(S(5))*a - S(2)*b)) + atan(x*sqrt(S(5)*a/b + S(4)*b/a)/sqrt(S(5)*x**S(4) + S(4)))/(S(2)*a*sqrt(S(5)*a/b + S(4)*b/a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((a + b*x**S(2))*sqrt(-d*x**S(4) + S(4))), x), x, sqrt(S(2))*elliptic_pi(-S(2)*b/(a*sqrt(d)), asin(sqrt(S(2))*d**(S(1)/4)*x/S(2)), S(-1))/(S(2)*a*d**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((a + b*x**S(2))*sqrt(d*x**S(4) + S(4))), x), x, -sqrt(S(2))*d**(S(1)/4)*sqrt((d*x**S(4) + S(4))/(sqrt(d)*x**S(2) + S(2))**S(2))*(sqrt(d)*x**S(2) + S(2))*elliptic_f(S(2)*atan(sqrt(S(2))*d**(S(1)/4)*x/S(2)), S(1)/2)/(S(4)*(-a*sqrt(d) + S(2)*b)*sqrt(d*x**S(4) + S(4))) + atan(x*sqrt(a*d/b + S(4)*b/a)/sqrt(d*x**S(4) + S(4)))/(S(2)*a*sqrt(a*d/b + S(4)*b/a)) + sqrt(S(2))*sqrt((d*x**S(4) + S(4))/(sqrt(d)*x**S(2) + S(2))**S(2))*(a*sqrt(d) + S(2)*b)*(sqrt(d)*x**S(2) + S(2))*elliptic_pi(-(-a*sqrt(d) + S(2)*b)**S(2)/(S(8)*a*b*sqrt(d)), S(2)*atan(sqrt(S(2))*d**(S(1)/4)*x/S(2)), S(1)/2)/(S(8)*a*d**(S(1)/4)*(-a*sqrt(d) + S(2)*b)*sqrt(d*x**S(4) + S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(c**S(2)*x**S(2) + S(1))/sqrt(-c**S(2)*x**S(2) + S(1)), x), x, elliptic_e(asin(c*x), S(-1))/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((c**S(2)*x**S(2) + S(1))/sqrt(-c**S(4)*x**S(4) + S(1)), x), x, elliptic_e(asin(c*x), S(-1))/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(-c**S(2)*x**S(2) + S(1))/sqrt(c**S(2)*x**S(2) + S(1)), x), x, -elliptic_e(asin(c*x), S(-1))/c + S(2)*elliptic_f(asin(c*x), S(-1))/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-c**S(2)*x**S(2) + S(1))/sqrt(-c**S(4)*x**S(4) + S(1)), x), x, -elliptic_e(asin(c*x), S(-1))/c + S(2)*elliptic_f(asin(c*x), S(-1))/c, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + S(1))/sqrt(-b**S(2)*x**S(4) + S(1)), x), x, elliptic_e(asin(sqrt(b)*x), S(-1))/sqrt(b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-b*x**S(2) + S(1))/sqrt(-b**S(2)*x**S(4) + S(1)), x), x, -elliptic_e(asin(sqrt(b)*x), S(-1))/sqrt(b) + S(2)*elliptic_f(asin(sqrt(b)*x), S(-1))/sqrt(b), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + S(1))/sqrt(b**S(2)*x**S(4) + S(-1)), x), x, sqrt(-b**S(2)*x**S(4) + S(1))*elliptic_e(asin(sqrt(b)*x), S(-1))/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(-1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-b*x**S(2) + S(1))/sqrt(b**S(2)*x**S(4) + S(-1)), x), x, -sqrt(-b**S(2)*x**S(4) + S(1))*elliptic_e(asin(sqrt(b)*x), S(-1))/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(-1))) + S(2)*sqrt(-b**S(2)*x**S(4) + S(1))*elliptic_f(asin(sqrt(b)*x), S(-1))/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(-1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-b*x**S(2) + S(1))/sqrt(b**S(2)*x**S(4) + S(1)), x), x, -x*sqrt(b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1)) + sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_e(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + S(1))/sqrt(b**S(2)*x**S(4) + S(1)), x), x, x*sqrt(b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1)) - sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_e(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(1))) + sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_f(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(b**S(2)*x**S(4) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-b*x**S(2) + S(1))/sqrt(-b**S(2)*x**S(4) + S(-1)), x), x, x*sqrt(-b**S(2)*x**S(4) + S(-1))/(b*x**S(2) + S(1)) + sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_e(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(-b**S(2)*x**S(4) + S(-1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b*x**S(2) + S(1))/sqrt(-b**S(2)*x**S(4) + S(-1)), x), x, -x*sqrt(-b**S(2)*x**S(4) + S(-1))/(b*x**S(2) + S(1)) - sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_e(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(-b**S(2)*x**S(4) + S(-1))) + sqrt((b**S(2)*x**S(4) + S(1))/(b*x**S(2) + S(1))**S(2))*(b*x**S(2) + S(1))*elliptic_f(S(2)*atan(sqrt(b)*x), S(1)/2)/(sqrt(b)*sqrt(-b**S(2)*x**S(4) + S(-1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(4)/(-d**S(2) + e**S(2)*x**S(4)), x), x, -S(8)*d**(S(5)/2)*atanh(sqrt(e)*x/sqrt(d))/sqrt(e) + S(7)*d**S(2)*x + S(4)*d*e*x**S(3)/S(3) + e**S(2)*x**S(5)/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/(-d**S(2) + e**S(2)*x**S(4)), x), x, -S(4)*d**(S(3)/2)*atanh(sqrt(e)*x/sqrt(d))/sqrt(e) + S(3)*d*x + e*x**S(3)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/(-d**S(2) + e**S(2)*x**S(4)), x), x, -S(2)*sqrt(d)*atanh(sqrt(e)*x/sqrt(d))/sqrt(e) + x, expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(-d**S(2) + e**S(2)*x**S(4)), x), x, -atanh(sqrt(e)*x/sqrt(d))/(sqrt(d)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*(-d**S(2) + e**S(2)*x**S(4))), x), x, -x/(S(4)*d**S(2)*(d + e*x**S(2))) - atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(5)/2)*sqrt(e)) - atanh(sqrt(e)*x/sqrt(d))/(S(4)*d**(S(5)/2)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*(-d**S(2) + e**S(2)*x**S(4))), x), x, -x/(S(8)*d**S(2)*(d + e*x**S(2))**S(2)) - S(5)*x/(S(16)*d**S(3)*(d + e*x**S(2))) - S(7)*atan(sqrt(e)*x/sqrt(d))/(S(16)*d**(S(7)/2)*sqrt(e)) - atanh(sqrt(e)*x/sqrt(d))/(S(8)*d**(S(7)/2)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**(S(3)/2)/(-d**S(2) + e**S(2)*x**S(4)), x), x, atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/sqrt(e) - sqrt(S(2))*atanh(sqrt(S(2))*sqrt(e)*x/sqrt(d + e*x**S(2)))/sqrt(e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d + e*x**S(2))/(-d**S(2) + e**S(2)*x**S(4)), x), x, -sqrt(S(2))*atanh(sqrt(S(2))*sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(2)*d*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d + e*x**S(2))*(-d**S(2) + e**S(2)*x**S(4))), x), x, -x/(S(2)*d**S(2)*sqrt(d + e*x**S(2))) - sqrt(S(2))*atanh(sqrt(S(2))*sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(4)*d**S(2)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**(S(3)/2)*(-d**S(2) + e**S(2)*x**S(4))), x), x, -x/(S(6)*d**S(2)*(d + e*x**S(2))**(S(3)/2)) - S(7)*x/(S(12)*d**S(3)*sqrt(d + e*x**S(2))) - sqrt(S(2))*atanh(sqrt(S(2))*sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(8)*d**S(3)*sqrt(e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(4)/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, e**S(2)*x**S(5)/(S(5)*c) + e*x**S(3)*(-b*e + S(4)*c*d)/(S(3)*c**S(2)) + x*(b**S(2)*e**S(2) - S(5)*b*c*d*e + S(7)*c**S(2)*d**S(2))/c**S(3) - (-b*e + S(2)*c*d)**S(3)*atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(c**(S(7)/2)*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, e*x**S(3)/(S(3)*c) + x*(-b*e + S(3)*c*d)/c**S(2) - (-b*e + S(2)*c*d)**S(2)*atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(c**(S(5)/2)*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, x/c - (-b*e + S(2)*c*d)*atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(c**(S(3)/2)*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, -atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(sqrt(c)*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4))), x), x, -c**(S(3)/2)*atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(sqrt(e)*sqrt(-b*e + c*d)*(-b*e + S(2)*c*d)**S(2)) - x/(S(2)*d*(d + e*x**S(2))*(-b*e + S(2)*c*d)) - (-b*e + S(4)*c*d)*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*sqrt(e)*(-b*e + S(2)*c*d)**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4))), x), x, -c**(S(5)/2)*atanh(sqrt(c)*sqrt(e)*x/sqrt(-b*e + c*d))/(sqrt(e)*sqrt(-b*e + c*d)*(-b*e + S(2)*c*d)**S(3)) - x/(S(4)*d*(d + e*x**S(2))**S(2)*(-b*e + S(2)*c*d)) - x*(-S(3)*b*e + S(10)*c*d)/(S(8)*d**S(2)*(d + e*x**S(2))*(-b*e + S(2)*c*d)**S(2)) - (S(3)*b**S(2)*e**S(2) - S(16)*b*c*d*e + S(28)*c**S(2)*d**S(2))*atan(sqrt(e)*x/sqrt(d))/(S(8)*d**(S(5)/2)*sqrt(e)*(-b*e + S(2)*c*d)**S(3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**(S(5)/2)/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, x*sqrt(d + e*x**S(2))/(S(2)*c) + (-S(2)*b*e + S(5)*c*d)*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(2)*c**S(2)*sqrt(e)) - (-b*e + S(2)*c*d)**(S(3)/2)*atanh(sqrt(e)*x*sqrt(-b*e + S(2)*c*d)/(sqrt(d + e*x**S(2))*sqrt(-b*e + c*d)))/(c**S(2)*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**(S(3)/2)/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(c*sqrt(e)) - sqrt(-b*e + S(2)*c*d)*atanh(sqrt(e)*x*sqrt(-b*e + S(2)*c*d)/(sqrt(d + e*x**S(2))*sqrt(-b*e + c*d)))/(c*sqrt(e)*sqrt(-b*e + c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d + e*x**S(2))/(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4)), x), x, -atanh(sqrt(e)*x*sqrt(-b*e + S(2)*c*d)/(sqrt(d + e*x**S(2))*sqrt(-b*e + c*d)))/(sqrt(e)*sqrt(-b*e + c*d)*sqrt(-b*e + S(2)*c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(sqrt(d + e*x**S(2))*(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4))), x), x, -c*atanh(sqrt(e)*x*sqrt(-b*e + S(2)*c*d)/(sqrt(d + e*x**S(2))*sqrt(-b*e + c*d)))/(sqrt(e)*sqrt(-b*e + c*d)*(-b*e + S(2)*c*d)**(S(3)/2)) - x/(d*sqrt(d + e*x**S(2))*(-b*e + S(2)*c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**(S(3)/2)*(b*d*e + b*e**S(2)*x**S(2) - c*d**S(2) + c*e**S(2)*x**S(4))), x), x, -c**S(2)*atanh(sqrt(e)*x*sqrt(-b*e + S(2)*c*d)/(sqrt(d + e*x**S(2))*sqrt(-b*e + c*d)))/(sqrt(e)*sqrt(-b*e + c*d)*(-b*e + S(2)*c*d)**(S(5)/2)) - x/(S(3)*d*(d + e*x**S(2))**(S(3)/2)*(-b*e + S(2)*c*d)) - x*(-S(2)*b*e + S(7)*c*d)/(S(3)*d**S(2)*sqrt(d + e*x**S(2))*(-b*e + S(2)*c*d)**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(b*x**S(2) + d**S(2) + e**S(2)*x**S(4)), x), x, -atan((-S(2)*e*x + sqrt(-b + S(2)*d*e))/sqrt(b + S(2)*d*e))/sqrt(b + S(2)*d*e) + atan((S(2)*e*x + sqrt(-b + S(2)*d*e))/sqrt(b + S(2)*d*e))/sqrt(b + S(2)*d*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(-b*x**S(2) + d**S(2) + e**S(2)*x**S(4)), x), x, atanh((-S(2)*e*x + sqrt(b + S(2)*d*e))/sqrt(b - S(2)*d*e))/sqrt(b - S(2)*d*e) - atanh((S(2)*e*x + sqrt(b + S(2)*d*e))/sqrt(b - S(2)*d*e))/sqrt(b - S(2)*d*e), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(d**S(2) + e**S(2)*x**S(4) + f*x**S(2)), x), x, -atan((-S(2)*e*x + sqrt(S(2)*d*e - f))/sqrt(S(2)*d*e + f))/sqrt(S(2)*d*e + f) + atan((S(2)*e*x + sqrt(S(2)*d*e - f))/sqrt(S(2)*d*e + f))/sqrt(S(2)*d*e + f), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(d**S(2) + e**S(2)*x**S(4) - f*x**S(2)), x), x, -atan((-S(2)*e*x + sqrt(S(2)*d*e + f))/sqrt(S(2)*d*e - f))/sqrt(S(2)*d*e - f) + atan((S(2)*e*x + sqrt(S(2)*d*e + f))/sqrt(S(2)*d*e - f))/sqrt(S(2)*d*e - f), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(b*x**S(2) + d**S(2) + e**S(2)*x**S(4)), x), x, -log(d + e*x**S(2) - x*sqrt(-b + S(2)*d*e))/(S(2)*sqrt(-b + S(2)*d*e)) + log(d + e*x**S(2) + x*sqrt(-b + S(2)*d*e))/(S(2)*sqrt(-b + S(2)*d*e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(-b*x**S(2) + d**S(2) + e**S(2)*x**S(4)), x), x, -log(d + e*x**S(2) - x*sqrt(b + S(2)*d*e))/(S(2)*sqrt(b + S(2)*d*e)) + log(d + e*x**S(2) + x*sqrt(b + S(2)*d*e))/(S(2)*sqrt(b + S(2)*d*e)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(d**S(2) + e**S(2)*x**S(4) + f*x**S(2)), x), x, -log(d + e*x**S(2) - x*sqrt(S(2)*d*e - f))/(S(2)*sqrt(S(2)*d*e - f)) + log(d + e*x**S(2) + x*sqrt(S(2)*d*e - f))/(S(2)*sqrt(S(2)*d*e - f)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(d**S(2) + e**S(2)*x**S(4) - f*x**S(2)), x), x, -log(d + e*x**S(2) - x*sqrt(S(2)*d*e + f))/(S(2)*sqrt(S(2)*d*e + f)) + log(d + e*x**S(2) + x*sqrt(S(2)*d*e + f))/(S(2)*sqrt(S(2)*d*e + f)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d - e*x**S(2))/(b*x**S(2) + c*d**S(2)/e**S(2) + c*x**S(4)), x), x, -e**(S(3)/2)*log(sqrt(c)*d + sqrt(c)*e*x**S(2) - sqrt(e)*x*sqrt(-b*e + S(2)*c*d))/(S(2)*sqrt(c)*sqrt(-b*e + S(2)*c*d)) + e**(S(3)/2)*log(sqrt(c)*d + sqrt(c)*e*x**S(2) + sqrt(e)*x*sqrt(-b*e + S(2)*c*d))/(S(2)*sqrt(c)*sqrt(-b*e + S(2)*c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(b*x**S(2) + c*d**S(2)/e**S(2) + c*x**S(4)), x), x, -e**(S(3)/2)*atan((-S(2)*sqrt(c)*sqrt(e)*x + sqrt(-b*e + S(2)*c*d))/sqrt(b*e + S(2)*c*d))/(sqrt(c)*sqrt(b*e + S(2)*c*d)) + e**(S(3)/2)*atan((S(2)*sqrt(c)*sqrt(e)*x + sqrt(-b*e + S(2)*c*d))/sqrt(b*e + S(2)*c*d))/(sqrt(c)*sqrt(b*e + S(2)*c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(b*x**S(2) + c*(d**S(2)/e**S(2) + x**S(4))), x), x, -e**(S(3)/2)*atan((-S(2)*sqrt(c)*sqrt(e)*x + sqrt(-b*e + S(2)*c*d))/sqrt(b*e + S(2)*c*d))/(sqrt(c)*sqrt(b*e + S(2)*c*d)) + e**(S(3)/2)*atan((S(2)*sqrt(c)*sqrt(e)*x + sqrt(-b*e + S(2)*c*d))/sqrt(b*e + S(2)*c*d))/(sqrt(c)*sqrt(b*e + S(2)*c*d)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a - b*x**S(2))/(a**S(2) + b**S(2)*x**S(4) + x**S(2)*(S(2)*a*b + S(-1))), x), x, -log(a + b*x**S(2) - x)/S(2) + log(a + b*x**S(2) + x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2))/(a**S(2) + b**S(2)*x**S(4) + x**S(2)*(S(2)*a*b + S(-1))), x), x, atanh((-S(2)*b*x + S(1))/sqrt(-S(4)*a*b + S(1)))/sqrt(-S(4)*a*b + S(1)) - atanh((S(2)*b*x + S(1))/sqrt(-S(4)*a*b + S(1)))/sqrt(-S(4)*a*b + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(b*x**S(2) + S(4)*x**S(4) + S(1)), x), x, -atan((-S(4)*x + sqrt(-b + S(4)))/sqrt(b + S(4)))/sqrt(b + S(4)) + atan((S(4)*x + sqrt(-b + S(4)))/sqrt(b + S(4)))/sqrt(b + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(-b*x**S(2) + S(4)*x**S(4) + S(1)), x), x, -atan((-S(4)*x + sqrt(b + S(4)))/sqrt(-b + S(4)))/sqrt(-b + S(4)) + atan((S(4)*x + sqrt(b + S(4)))/sqrt(-b + S(4)))/sqrt(-b + S(4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(6)*x**S(2) + S(1)), x), x, sqrt(S(10))*atan(S(2)*x/sqrt(-sqrt(S(5)) + S(3)))/S(10) + sqrt(S(10))*atan(S(2)*x/sqrt(sqrt(S(5)) + S(3)))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(5)*x**S(2) + S(1)), x), x, atan(x)/S(3) + atan(S(2)*x)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(4)*x**S(2) + S(1)), x), x, sqrt(S(2))*atan(sqrt(S(2))*x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(3)*x**S(2) + S(1)), x), x, -sqrt(S(7))*atan(sqrt(S(7))*(-S(4)*x + S(1))/S(7))/S(7) + sqrt(S(7))*atan(sqrt(S(7))*(S(4)*x + S(1))/S(7))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(2)*x**S(2) + S(1)), x), x, -sqrt(S(6))*atan(sqrt(S(6))*(-S(4)*x + sqrt(S(2)))/S(6))/S(6) + sqrt(S(6))*atan(sqrt(S(6))*(S(4)*x + sqrt(S(2)))/S(6))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + x**S(2) + S(1)), x), x, -sqrt(S(5))*atan(sqrt(S(5))*(-S(4)*x + sqrt(S(3)))/S(5))/S(5) + sqrt(S(5))*atan(sqrt(S(5))*(S(4)*x + sqrt(S(3)))/S(5))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(1)), x), x, atan(S(2)*x + S(-1))/S(2) + atan(S(2)*x + S(1))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - x**S(2) + S(1)), x), x, -sqrt(S(3))*atan(sqrt(S(3))*(-S(4)*x + sqrt(S(5)))/S(3))/S(3) + sqrt(S(3))*atan(sqrt(S(3))*(S(4)*x + sqrt(S(5)))/S(3))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(2)*x**S(2) + S(1)), x), x, -sqrt(S(2))*atan(sqrt(S(2))*(-S(4)*x + sqrt(S(6)))/S(2))/S(2) + sqrt(S(2))*atan(sqrt(S(2))*(S(4)*x + sqrt(S(6)))/S(2))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(3)*x**S(2) + S(1)), x), x, atan(S(4)*x - sqrt(S(7))) + atan(S(4)*x + sqrt(S(7))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(4)*x**S(2) + S(1)), x), x, x/(-S(2)*x**S(2) + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(5)*x**S(2) + S(1)), x), x, -log(-S(2)*x**S(2) - x + S(1))/S(2) + log(-S(2)*x**S(2) + x + S(1))/S(2), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(5)*x**S(2) + S(1)), x), x, -log(-S(2)*x + S(1))/S(2) + log(-x + S(1))/S(2) - log(x + S(1))/S(2) + log(S(2)*x + S(1))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(6)*x**S(2) + S(1)), x), x, -sqrt(S(10))*log(S(2)*x**S(2) - sqrt(S(10))*x + S(1))/S(20) + sqrt(S(10))*log(S(2)*x**S(2) + sqrt(S(10))*x + S(1))/S(20), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(6)*x**S(2) + S(1)), x), x, sqrt(S(2))*atanh(sqrt(S(2))*(-S(4)*x + sqrt(S(10)))/S(2))/S(2) - sqrt(S(2))*atanh(sqrt(S(2))*(S(4)*x + sqrt(S(10)))/S(2))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(b*x**S(2) + S(4)*x**S(4) + S(1)), x), x, -log(S(2)*x**S(2) - x*sqrt(-b + S(4)) + S(1))/(S(2)*sqrt(-b + S(4))) + log(S(2)*x**S(2) + x*sqrt(-b + S(4)) + S(1))/(S(2)*sqrt(-b + S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(6)*x**S(2) + S(1)), x), x, sqrt(S(2))*atan(S(2)*x/sqrt(-sqrt(S(5)) + S(3)))/S(2) - sqrt(S(2))*atan(S(2)*x/sqrt(sqrt(S(5)) + S(3)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(5)*x**S(2) + S(1)), x), x, -atan(x) + atan(S(2)*x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(4)*x**S(2) + S(1)), x), x, x/(S(2)*x**S(2) + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(3)*x**S(2) + S(1)), x), x, -log(S(2)*x**S(2) - x + S(1))/S(2) + log(S(2)*x**S(2) + x + S(1))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(2)*x**S(2) + S(1)), x), x, -sqrt(S(2))*log(S(2)*x**S(2) - sqrt(S(2))*x + S(1))/S(4) + sqrt(S(2))*log(S(2)*x**S(2) + sqrt(S(2))*x + S(1))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + x**S(2) + S(1)), x), x, -sqrt(S(3))*log(S(2)*x**S(2) - sqrt(S(3))*x + S(1))/S(6) + sqrt(S(3))*log(S(2)*x**S(2) + sqrt(S(3))*x + S(1))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) + S(1)), x), x, -log(S(2)*x**S(2) - S(2)*x + S(1))/S(4) + log(S(2)*x**S(2) + S(2)*x + S(1))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - x**S(2) + S(1)), x), x, -sqrt(S(5))*log(S(2)*x**S(2) - sqrt(S(5))*x + S(1))/S(10) + sqrt(S(5))*log(S(2)*x**S(2) + sqrt(S(5))*x + S(1))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(2)*x**S(2) + S(1)), x), x, -sqrt(S(6))*log(S(2)*x**S(2) - sqrt(S(6))*x + S(1))/S(12) + sqrt(S(6))*log(S(2)*x**S(2) + sqrt(S(6))*x + S(1))/S(12), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(3)*x**S(2) + S(1)), x), x, -sqrt(S(7))*log(S(2)*x**S(2) - sqrt(S(7))*x + S(1))/S(14) + sqrt(S(7))*log(S(2)*x**S(2) + sqrt(S(7))*x + S(1))/S(14), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(4)*x**S(2) + S(1)), x), x, sqrt(S(2))*atanh(sqrt(S(2))*x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(5)*x**S(2) + S(1)), x), x, -log(S(2)*x**S(2) - S(3)*x + S(1))/S(6) + log(S(2)*x**S(2) + S(3)*x + S(1))/S(6), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(5)*x**S(2) + S(1)), x), x, atanh(x)/S(3) + atanh(S(2)*x)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(6)*x**S(2) + S(1)), x), x, -sqrt(S(10))*log(S(2)*x**S(2) - sqrt(S(10))*x + S(1))/S(20) + sqrt(S(10))*log(S(2)*x**S(2) + sqrt(S(10))*x + S(1))/S(20), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((-S(2)*x**S(2) + S(1))/(S(4)*x**S(4) - S(6)*x**S(2) + S(1)), x), x, sqrt(S(10))*atanh(S(2)*x/sqrt(-sqrt(S(5)) + S(3)))/S(10) + sqrt(S(10))*atanh(S(2)*x/sqrt(sqrt(S(5)) + S(3)))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(b*x**S(2) + x**S(4) + S(1)), x), x, -atan((-S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/sqrt(b + S(2)) + atan((S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/sqrt(b + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + S(5)*x**S(2) + S(1)), x), x, sqrt(S(7))*atan(x*sqrt(sqrt(S(21))/S(2) + S(5)/2))/S(7) + sqrt(S(7))*atan(sqrt(S(2))*x/sqrt(sqrt(S(21)) + S(5)))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + S(4)*x**S(2) + S(1)), x), x, sqrt(S(6))*atan(x/sqrt(-sqrt(S(3)) + S(2)))/S(6) + sqrt(S(6))*atan(x/sqrt(sqrt(S(3)) + S(2)))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + S(3)*x**S(2) + S(1)), x), x, sqrt(S(5))*atan(x*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(5) + sqrt(S(5))*atan(sqrt(S(2))*x/sqrt(sqrt(S(5)) + S(3)))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, atan(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + x**S(2) + S(1)), x), x, -sqrt(S(3))*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(3) + sqrt(S(3))*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) + S(1)), x), x, sqrt(S(2))*atan(sqrt(S(2))*x + S(-1))/S(2) + sqrt(S(2))*atan(sqrt(S(2))*x + S(1))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - x**S(2) + S(1)), x), x, atan(S(2)*x - sqrt(S(3))) + atan(S(2)*x + sqrt(S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - S(2)*x**S(2) + S(1)), x), x, x/(-x**S(2) + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - S(3)*x**S(2) + S(1)), x), x, atanh(-S(2)*x + sqrt(S(5))) - atanh(S(2)*x + sqrt(S(5))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - S(4)*x**S(2) + S(1)), x), x, sqrt(S(2))*atanh(-sqrt(S(2))*x + sqrt(S(3)))/S(2) - sqrt(S(2))*atanh(sqrt(S(2))*x + sqrt(S(3)))/S(2), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - S(4)*x**S(2) + S(1)), x), x, sqrt(S(2))*atanh(sqrt(S(2))*(-S(2)*x + sqrt(S(6)))/S(2))/S(2) - sqrt(S(2))*atanh(sqrt(S(2))*(S(2)*x + sqrt(S(6)))/S(2))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(1))/(x**S(4) - S(5)*x**S(2) + S(1)), x), x, sqrt(S(3))*atanh(sqrt(S(3))*(-S(2)*x + sqrt(S(7)))/S(3))/S(3) - sqrt(S(3))*atanh(sqrt(S(3))*(S(2)*x + sqrt(S(7)))/S(3))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(b*x**S(2) + x**S(4) + S(1)), x), x, -log(x**S(2) - x*sqrt(-b + S(2)) + S(1))/(S(2)*sqrt(-b + S(2))) + log(x**S(2) + x*sqrt(-b + S(2)) + S(1))/(S(2)*sqrt(-b + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + S(5)*x**S(2) + S(1)), x), x, sqrt(S(3))*atan(x*sqrt(sqrt(S(21))/S(2) + S(5)/2))/S(3) - sqrt(S(3))*atan(sqrt(S(2))*x/sqrt(sqrt(S(21)) + S(5)))/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + S(4)*x**S(2) + S(1)), x), x, sqrt(S(2))*atan(x/sqrt(-sqrt(S(3)) + S(2)))/S(2) - sqrt(S(2))*atan(x/sqrt(sqrt(S(3)) + S(2)))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + S(3)*x**S(2) + S(1)), x), x, atan(x*sqrt(sqrt(S(5))/S(2) + S(3)/2)) - atan(sqrt(S(2))*x/sqrt(sqrt(S(5)) + S(3))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + S(2)*x**S(2) + S(1)), x), x, x/(x**S(2) + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + x**S(2) + S(1)), x), x, -log(x**S(2) - x + S(1))/S(2) + log(x**S(2) + x + S(1))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) + S(1)), x), x, -sqrt(S(2))*log(x**S(2) - sqrt(S(2))*x + S(1))/S(4) + sqrt(S(2))*log(x**S(2) + sqrt(S(2))*x + S(1))/S(4), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - x**S(2) + S(1)), x), x, -sqrt(S(3))*log(x**S(2) - sqrt(S(3))*x + S(1))/S(6) + sqrt(S(3))*log(x**S(2) + sqrt(S(3))*x + S(1))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(2)*x**S(2) + S(1)), x), x, atanh(x), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(3)*x**S(2) + S(1)), x), x, -sqrt(S(5))*log(x**S(2) - sqrt(S(5))*x + S(1))/S(10) + sqrt(S(5))*log(x**S(2) + sqrt(S(5))*x + S(1))/S(10), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(3)*x**S(2) + S(1)), x), x, sqrt(S(5))*atanh(x*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(5) + sqrt(S(5))*atanh(sqrt(S(2))*x/sqrt(sqrt(S(5)) + S(3)))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(4)*x**S(2) + S(1)), x), x, -sqrt(S(6))*log(x**S(2) - sqrt(S(6))*x + S(1))/S(12) + sqrt(S(6))*log(x**S(2) + sqrt(S(6))*x + S(1))/S(12), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(4)*x**S(2) + S(1)), x), x, sqrt(S(6))*atanh(x/sqrt(-sqrt(S(3)) + S(2)))/S(6) + sqrt(S(6))*atanh(x/sqrt(sqrt(S(3)) + S(2)))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(5)*x**S(2) + S(1)), x), x, -sqrt(S(7))*log(x**S(2) - sqrt(S(7))*x + S(1))/S(14) + sqrt(S(7))*log(x**S(2) + sqrt(S(7))*x + S(1))/S(14), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate((-x**S(2) + S(1))/(x**S(4) - S(5)*x**S(2) + S(1)), x), x, sqrt(S(7))*atanh(x*sqrt(sqrt(S(21))/S(2) + S(5)/2))/S(7) + sqrt(S(7))*atanh(sqrt(S(2))*x/sqrt(sqrt(S(21)) + S(5)))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(4)*(a + b*x**S(2) + c*x**S(4)), x), x, a*d**S(4)*x + c*e**S(4)*x**S(13)/S(13) + d**S(3)*x**S(3)*(S(4)*a*e + b*d)/S(3) + d**S(2)*x**S(5)*(S(6)*a*e**S(2) + S(4)*b*d*e + c*d**S(2))/S(5) + S(2)*d*e*x**S(7)*(S(2)*c*d**S(2) + e*(S(2)*a*e + S(3)*b*d))/S(7) + e**S(3)*x**S(11)*(b*e + S(4)*c*d)/S(11) + e**S(2)*x**S(9)*(S(6)*c*d**S(2) + e*(a*e + S(4)*b*d))/S(9), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)*(a + b*x**S(2) + c*x**S(4)), x), x, a*d**S(3)*x + c*e**S(3)*x**S(11)/S(11) + d**S(2)*x**S(3)*(S(3)*a*e + b*d)/S(3) + d*x**S(5)*(c*d**S(2) + S(3)*e*(a*e + b*d))/S(5) + e**S(2)*x**S(9)*(b*e + S(3)*c*d)/S(9) + e*x**S(7)*(S(3)*c*d**S(2) + e*(a*e + S(3)*b*d))/S(7), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4)), x), x, a*d**S(2)*x + c*e**S(2)*x**S(9)/S(9) + d*x**S(3)*(S(2)*a*e + b*d)/S(3) + e*x**S(7)*(b*e + S(2)*c*d)/S(7) + x**S(5)*(c*d**S(2) + e*(a*e + S(2)*b*d))/S(5), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))*(a + b*x**S(2) + c*x**S(4)), x), x, a*d*x + c*e*x**S(7)/S(7) + x**S(5)*(b*e + c*d)/S(5) + x**S(3)*(a*e + b*d)/S(3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2)), x), x, c*x**S(3)/(S(3)*e) - x*(-b*e + c*d)/e**S(2) + (a*e**S(2) - b*d*e + c*d**S(2))*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**S(2), x), x, c*x/e**S(2) + x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(2)*d*e**S(2)*(d + e*x**S(2))) - (S(3)*c*d**S(2) - e*(a*e + b*d))*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**S(3), x), x, x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(4)*d*e**S(2)*(d + e*x**S(2))**S(2)) - x*(S(5)*c*d**S(2) - e*(S(3)*a*e + b*d))/(S(8)*d**S(2)*e**S(2)*(d + e*x**S(2))) + (S(3)*c*d**S(2) + e*(S(3)*a*e + b*d))*atan(sqrt(e)*x/sqrt(d))/(S(8)*d**(S(5)/2)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**S(4), x), x, x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(6)*d*e**S(2)*(d + e*x**S(2))**S(3)) - x*(S(7)*c*d**S(2) - e*(S(5)*a*e + b*d))/(S(24)*d**S(2)*e**S(2)*(d + e*x**S(2))**S(2)) + x*(c*d**S(2) + e*(S(5)*a*e + b*d))/(S(16)*d**S(3)*e**S(2)*(d + e*x**S(2))) + (c*d**S(2) + e*(S(5)*a*e + b*d))*atan(sqrt(e)*x/sqrt(d))/(S(16)*d**(S(7)/2)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*d**S(3)*x + a*d**S(2)*x**S(3)*(S(3)*a*e + S(2)*b*d)/S(3) + c**S(2)*e**S(3)*x**S(15)/S(15) + c*e**S(2)*x**S(13)*(S(2)*b*e + S(3)*c*d)/S(13) + d*x**S(5)*(S(6)*a*b*d*e + a*(S(3)*a*e**S(2) + S(2)*c*d**S(2)) + b**S(2)*d**S(2))/S(5) + e*x**S(11)*(b**S(2)*e**S(2) + S(3)*c**S(2)*d**S(2) + S(2)*c*e*(a*e + S(3)*b*d))/S(11) + x**S(9)*(b*e**S(2)*(S(2)*a*e + S(3)*b*d)/S(9) + c**S(2)*d**S(3)/S(9) + S(2)*c*d*e*(a*e + b*d)/S(3)) + x**S(7)*(a**S(2)*e**S(3)/S(7) + S(6)*a*b*d*e**S(2)/S(7) + S(6)*a*c*d**S(2)*e/S(7) + S(3)*b**S(2)*d**S(2)*e/S(7) + S(2)*b*c*d**S(3)/S(7)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*d**S(2)*x + S(2)*a*d*x**S(3)*(a*e + b*d)/S(3) + c**S(2)*e**S(2)*x**S(13)/S(13) + S(2)*c*e*x**S(11)*(b*e + c*d)/S(11) + x**S(9)*(b**S(2)*e**S(2)/S(9) + c**S(2)*d**S(2)/S(9) + S(2)*c*e*(a*e + S(2)*b*d)/S(9)) + x**S(7)*(S(2)*a*b*e**S(2)/S(7) + S(4)*a*c*d*e/S(7) + S(2)*b**S(2)*d*e/S(7) + S(2)*b*c*d**S(2)/S(7)) + x**S(5)*(S(4)*a*b*d*e/S(5) + a*(a*e**S(2) + S(2)*c*d**S(2))/S(5) + b**S(2)*d**S(2)/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*d*x + a*x**S(3)*(a*e + S(2)*b*d)/S(3) + c**S(2)*e*x**S(11)/S(11) + c*x**S(9)*(S(2)*b*e + c*d)/S(9) + x**S(7)*(S(2)*a*c*e/S(7) + b**S(2)*e/S(7) + S(2)*b*c*d/S(7)) + x**S(5)*(S(2)*a*b*e/S(5) + S(2)*a*c*d/S(5) + b**S(2)*d/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2), x), x, a**S(2)*x + S(2)*a*b*x**S(3)/S(3) + S(2)*b*c*x**S(7)/S(7) + c**S(2)*x**S(9)/S(9) + x**S(5)*(S(2)*a*c/S(5) + b**S(2)/S(5)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/(d + e*x**S(2)), x), x, c**S(2)*x**S(7)/(S(7)*e) - c*x**S(5)*(-S(2)*b*e + c*d)/(S(5)*e**S(2)) + x**S(3)*(b**S(2)*e**S(2) + c**S(2)*d**S(2) - S(2)*c*e*(-a*e + b*d))/(S(3)*e**S(3)) - x*(-b*e + c*d)*(c*d**S(2) - e*(-S(2)*a*e + b*d))/e**S(4) + (a*e**S(2) - b*d*e + c*d**S(2))**S(2)*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*e**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/(d + e*x**S(2))**S(2), x), x, c**S(2)*x**S(7)/(S(5)*e*(d + e*x**S(2))) - c*x**S(3)*(-S(10)*b*e + S(7)*c*d)/(S(15)*e**S(3)) + x*(S(5)*b**S(2)*e**S(2) + S(14)*c**S(2)*d**S(2) - S(10)*c*e*(-a*e + S(2)*b*d))/(S(5)*e**S(4)) + x*(S(7)*c**S(2)*d**S(4) - S(10)*c*d**S(2)*e*(-a*e + b*d) + S(5)*e**S(2)*(-a*e + b*d)**S(2))/(S(10)*d*e**S(4)*(d + e*x**S(2))) - (S(7)*c*d**S(2) - e*(a*e + S(3)*b*d))*(a*e**S(2) - b*d*e + c*d**S(2))*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*e**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/(d + e*x**S(2))**S(3), x), x, c**S(2)*x**S(7)/(S(3)*e*(d + e*x**S(2))**S(2)) - c*x*(-S(6)*b*e + S(7)*c*d)/(S(3)*e**S(4)) + x*(S(7)*c**S(2)*d**S(4) - S(6)*c*d**S(2)*e*(-a*e + b*d) + S(3)*e**S(2)*(-a*e + b*d)**S(2))/(S(12)*d*e**S(4)*(d + e*x**S(2))**S(2)) - x*(S(21)*c**S(2)*d**S(4) - S(2)*c*d**S(2)*e*(-S(5)*a*e + S(9)*b*d) + e**S(2)*(-S(3)*a**S(2)*e**S(2) - S(2)*a*b*d*e + S(5)*b**S(2)*d**S(2)))/(S(8)*d**S(2)*e**S(4)*(d + e*x**S(2))) + (S(35)*c**S(2)*d**S(4) - S(6)*c*d**S(2)*e*(-a*e + S(5)*b*d) + e**S(2)*(S(3)*a**S(2)*e**S(2) + S(2)*a*b*d*e + S(3)*b**S(2)*d**S(2)))*atan(sqrt(e)*x/sqrt(d))/(S(8)*d**(S(5)/2)*e**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/(d + e*x**S(2))**S(4), x), x, c**S(2)*x**S(7)/(e*(d + e*x**S(2))**S(3)) + x*(S(7)*c**S(2)*d**S(4) - S(2)*c*d**S(2)*e*(-a*e + b*d) + e**S(2)*(-a*e + b*d)**S(2))/(S(6)*d*e**S(4)*(d + e*x**S(2))**S(3)) - x*(S(91)*c**S(2)*d**S(4) - S(2)*c*d**S(2)*e*(-S(7)*a*e + S(13)*b*d) + e**S(2)*(-S(5)*a**S(2)*e**S(2) - S(2)*a*b*d*e + S(7)*b**S(2)*d**S(2)))/(S(24)*d**S(2)*e**S(4)*(d + e*x**S(2))**S(2)) + x*(S(77)*c**S(2)*d**S(4) - S(2)*c*d**S(2)*e*(-a*e + S(11)*b*d) + e**S(2)*(S(5)*a**S(2)*e**S(2) + S(2)*a*b*d*e + b**S(2)*d**S(2)))/(S(16)*d**S(3)*e**S(4)*(d + e*x**S(2))) - (S(35)*c**S(2)*d**S(4) - S(2)*c*d**S(2)*e*(a*e + S(5)*b*d) - e**S(2)*(S(5)*a**S(2)*e**S(2) + S(2)*a*b*d*e + b**S(2)*d**S(2)))*atan(sqrt(e)*x/sqrt(d))/(S(16)*d**(S(7)/2)*e**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**S(2)/(d + e*x**S(2))**S(5), x), x, -c**S(2)*x**S(7)/(e*(d + e*x**S(2))**S(4)) - x*(S(7)*c**S(2)*d**S(4) + S(2)*c*d**S(2)*e*(-a*e + b*d) - e**S(2)*(-a*e + b*d)**S(2))/(S(8)*d*e**S(4)*(d + e*x**S(2))**S(4)) + x*(S(119)*c**S(2)*d**S(4) + S(2)*c*d**S(2)*e*(-S(9)*a*e + S(17)*b*d) - e**S(2)*(-S(7)*a**S(2)*e**S(2) - S(2)*a*b*d*e + S(9)*b**S(2)*d**S(2)))/(S(48)*d**S(2)*e**S(4)*(d + e*x**S(2))**S(3)) - x*(S(413)*c**S(2)*d**S(4) + S(2)*c*d**S(2)*e*(-S(3)*a*e + S(59)*b*d) - e**S(2)*(S(35)*a**S(2)*e**S(2) + S(10)*a*b*d*e + S(3)*b**S(2)*d**S(2)))/(S(192)*d**S(3)*e**S(4)*(d + e*x**S(2))**S(2)) + x*(S(35)*c**S(2)*d**S(4) + S(2)*c*d**S(2)*e*(S(3)*a*e + S(5)*b*d) + e**S(2)*(S(35)*a**S(2)*e**S(2) + S(10)*a*b*d*e + S(3)*b**S(2)*d**S(2)))/(S(128)*d**S(4)*e**S(4)*(d + e*x**S(2))) + (S(35)*c**S(2)*d**S(4) + S(2)*c*d**S(2)*e*(S(3)*a*e + S(5)*b*d) + e**S(2)*(S(35)*a**S(2)*e**S(2) + S(10)*a*b*d*e + S(3)*b**S(2)*d**S(2)))*atan(sqrt(e)*x/sqrt(d))/(S(128)*d**(S(9)/2)*e**(S(9)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**S(2), x), x, c*x/e**S(2) + x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(2)*d*e**S(2)*(d + e*x**S(2))) - (S(3)*c*d**S(2) - e*(a*e + b*d))*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + x**S(2)*(b + c*x**S(2)))/(d + e*x**S(2))**S(2), x), x, c*x/e**S(2) + x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(2)*d*e**S(2)*(d + e*x**S(2))) - (S(3)*c*d**S(2) - e*(a*e + b*d))*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(4)/(a + b*x**S(2) + c*x**S(4)), x), x, e**S(4)*x**S(5)/(S(5)*c) + e**S(3)*x**S(3)*(-b*e + S(4)*c*d)/(S(3)*c**S(2)) + e**S(2)*x*(b**S(2)*e**S(2) + S(6)*c**S(2)*d**S(2) - c*e*(a*e + S(4)*b*d))/c**S(3) + sqrt(S(2))*(e*(-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d)) - (b**S(4)*e**S(4) - S(4)*b**S(2)*c*e**S(3)*(a*e + b*d) + S(2)*c**S(4)*d**S(4) - S(4)*c**S(3)*d**S(2)*e*(S(3)*a*e + b*d) + S(2)*c**S(2)*e**S(2)*(a**S(2)*e**S(2) + S(6)*a*b*d*e + S(3)*b**S(2)*d**S(2)))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(7)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(e*(-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d)) + (b**S(4)*e**S(4) - S(4)*b**S(2)*c*e**S(3)*(a*e + b*d) + S(2)*c**S(4)*d**S(4) - S(4)*c**S(3)*d**S(2)*e*(S(3)*a*e + b*d) + S(2)*c**S(2)*e**S(2)*(a**S(2)*e**S(2) + S(6)*a*b*d*e + S(3)*b**S(2)*d**S(2)))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(7)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/(a + b*x**S(2) + c*x**S(4)), x), x, e**S(3)*x**S(3)/(S(3)*c) + e**S(2)*x*(-b*e + S(3)*c*d)/c**S(2) + sqrt(S(2))*(e*(b**S(2)*e**S(2) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d)) - (-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + c**S(2)*d**S(2) - c*e*(S(3)*a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(5)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(e*(b**S(2)*e**S(2) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d)) + (-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + c**S(2)*d**S(2) - c*e*(S(3)*a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(5)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/(a + b*x**S(2) + c*x**S(4)), x), x, e**S(2)*x/c + sqrt(S(2))*(e*(-b*e + S(2)*c*d) - (b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(e*(-b*e + S(2)*c*d) + (b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(a + b*x**S(2) + c*x**S(4)), x), x, sqrt(S(2))*(e - (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))) + sqrt(S(2))*(e + (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/(a + b*x**S(2) + c*x**S(4)), x), x, -sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(c)*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(S(2))*sqrt(c)*(e + (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) - sqrt(S(2))*sqrt(c)*(e - (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) + e**(S(3)/2)*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))), x), x, -sqrt(S(2))*sqrt(c)*(b*e**S(2)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d - d*sqrt(-S(4)*a*c + b**S(2))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*(b*e**S(2)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d + d*sqrt(-S(4)*a*c + b**S(2))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(2)*x/(S(2)*d*(d + e*x**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + e**(S(3)/2)*(-b*e + S(2)*c*d)*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**(S(3)/2)*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, x*(-a*b*e*(a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*c*d*(-S(3)*a*e**S(2) + c*d**S(2)) + b**S(2)*c*d**S(3) - x**S(2)*(a*b**S(2)*e**S(3) + S(2)*a*c*e*(-a*e**S(2) + S(3)*c*d**S(2)) - b*c*d*(S(3)*a*e**S(2) + c*d**S(2))))/(S(2)*a*c*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*(a*b**S(3)*e**S(3) + S(6)*a*c*(a*e**S(2) + c*d**S(2))*(S(2)*c*d - e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*(-S(3)*a*c*d*e**S(2) - a*e**S(3)*sqrt(-S(4)*a*c + b**S(2)) + c**S(2)*d**S(3)) + b*c*(a*e**S(2)*(-S(8)*a*e + S(3)*d*sqrt(-S(4)*a*c + b**S(2))) + c*d**S(2)*(-S(12)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*c**(S(3)/2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) - sqrt(S(2))*(a*b**S(3)*e**S(3) + S(6)*a*c*(a*e**S(2) + c*d**S(2))*(S(2)*c*d + e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*(-S(3)*a*c*d*e**S(2) + a*e**S(3)*sqrt(-S(4)*a*c + b**S(2)) + c**S(2)*d**S(3)) - b*c*(a*e**S(2)*(S(8)*a*e + S(3)*d*sqrt(-S(4)*a*c + b**S(2))) + c*d**S(2)*(S(12)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*c**(S(3)/2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, x*(-S(2)*a*b*d*e - S(2)*a*(-a*e**S(2) + c*d**S(2)) + b**S(2)*d**S(2) + x**S(2)*(a*b*e**S(2) - S(4)*a*c*d*e + b*c*d**S(2)))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))) - sqrt(S(2))*(-S(4)*a*c*(S(3)*c*d**S(2) - e*(-a*e + d*sqrt(-S(4)*a*c + b**S(2)))) + b**S(2)*(-a*e**S(2) + c*d**S(2)) - b*(a*e**S(2)*sqrt(-S(4)*a*c + b**S(2)) + c*d*(-S(8)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(c)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*(-S(4)*a*c*(S(3)*c*d**S(2) + e*(a*e + d*sqrt(-S(4)*a*c + b**S(2)))) + b**S(2)*(-a*e**S(2) + c*d**S(2)) + b*(a*e**S(2)*sqrt(-S(4)*a*c + b**S(2)) + c*d*(S(8)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(c)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(a + b*x**S(2) + c*x**S(4))**S(2), x), x, sqrt(S(2))*sqrt(c)*(-S(2)*a*e + b*d - (S(4)*a*b*e - S(12)*a*c*d + b**S(2)*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + sqrt(S(2))*sqrt(c)*(-S(2)*a*e + b*d + (S(4)*a*b*e - S(12)*a*c*d + b**S(2)*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + x*(-a*b*e - S(2)*a*c*d + b**S(2)*d + c*x**S(2)*(-S(2)*a*e + b*d))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))**(S(-2)), x), x, -sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + sqrt(S(2))*sqrt(c)*(-S(12)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)) + x*(-S(2)*a*c + b**S(2) + b*c*x**S(2))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, -sqrt(S(2))*sqrt(c)*e**S(2)*(e + (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - sqrt(S(2))*sqrt(c)*e**S(2)*(e - (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**(S(7)/2)*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*(S(2)*a*c*e - b**S(2)*e + b*c*d - (S(8)*a*b*c*e - S(12)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + sqrt(S(2))*sqrt(c)*(S(2)*a*c*e - b**S(2)*e + b*c*d + (S(8)*a*b*c*e - S(12)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + x*(S(3)*a*b*c*e - S(2)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d + c*x**S(2)*(S(2)*a*c*e - b**S(2)*e + b*c*d))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*(a + b*x**S(2) + c*x**S(4))**S(2)), x), x, -sqrt(S(2))*sqrt(c)*e**S(2)*(b*e**S(2)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d - S(2)*d*sqrt(-S(4)*a*c + b**S(2))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + sqrt(S(2))*sqrt(c)*e**S(2)*(b*e**S(2)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d + S(2)*d*sqrt(-S(4)*a*c + b**S(2))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*sqrt(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**S(4)*x/(S(2)*d*(d + e*x**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + S(2)*e**(S(7)/2)*(-b*e + S(2)*c*d)*atan(sqrt(e)*x/sqrt(d))/(sqrt(d)*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**(S(7)/2)*atan(sqrt(e)*x/sqrt(d))/(S(2)*d**(S(3)/2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - sqrt(S(2))*sqrt(c)*(-S(4)*a*c**S(2)*(S(3)*c*d**S(2) + e*(-S(3)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))) + b**S(4)*e**S(2) - b**S(3)*e*(S(2)*c*d + e*sqrt(-S(4)*a*c + b**S(2))) + b**S(2)*c*(c*d**S(2) + e*(-S(9)*a*e + S(2)*d*sqrt(-S(4)*a*c + b**S(2)))) + b*c*(S(3)*a*e**S(2)*sqrt(-S(4)*a*c + b**S(2)) - c*d*(-S(16)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + sqrt(S(2))*sqrt(c)*(-S(4)*a*c**S(2)*(S(3)*c*d**S(2) - e*(S(3)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))) + b**S(4)*e**S(2) - b**S(3)*e*(S(2)*c*d - e*sqrt(-S(4)*a*c + b**S(2))) + b**S(2)*c*(c*d**S(2) - e*(S(9)*a*e + S(2)*d*sqrt(-S(4)*a*c + b**S(2)))) - b*c*(S(3)*a*e**S(2)*sqrt(-S(4)*a*c + b**S(2)) - c*d*(S(16)*a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*atan(sqrt(S(2))*sqrt(c)*x/sqrt(b - sqrt(-S(4)*a*c + b**S(2))))/(S(4)*a*sqrt(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**(S(3)/2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - x*(-S(6)*a*b*c**S(2)*d*e + S(2)*a*c**S(2)*(-a*e**S(2) + c*d**S(2)) - b**S(4)*e**S(2) + S(2)*b**S(3)*c*d*e - b**S(2)*c*(-S(4)*a*e**S(2) + c*d**S(2)) + c*x**S(2)*(-S(4)*a*c**S(2)*d*e - b**S(3)*e**S(2) + S(2)*b**S(2)*c*d*e - b*c*(-S(3)*a*e**S(2) + c*d**S(2))))/(S(2)*a*(-S(4)*a*c + b**S(2))*(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*x**S(2) + S(3))/(x**S(4) - S(2)*x**S(2) + S(1)), x), x, S(5)*x/(-S(2)*x**S(2) + S(2)) + atanh(x)/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(3)*x**S(2) + S(2))/(S(3)*x**S(4) - S(8)*x**S(2) + S(5)), x), x, S(5)*atanh(x)/S(2) - S(7)*sqrt(S(15))*atanh(sqrt(S(15))*x/S(5))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/(S(3)*x**S(4) - S(8)*x**S(2) + S(5)), x), x, (d/S(2) + e/S(2))*atanh(x) - sqrt(S(15))*(S(3)*d + S(5)*e)*atanh(sqrt(S(15))*x/S(5))/S(30), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(3))/(x**S(4) + S(3)*x**S(2) + S(1)), x), x, sqrt(S(10))*(sqrt(S(5)) + S(3))**(S(3)/2)*atan(x*sqrt(sqrt(S(5))/S(2) + S(3)/2))/S(20) - sqrt(-S(80)*sqrt(S(5)) + S(180))*atan(sqrt(S(2))*x/sqrt(sqrt(S(5)) + S(3)))/S(10), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2))/(x**S(4) + x**S(2) + S(1)), x), x, -(a/S(4) - b/S(4))*log(x**S(2) - x + S(1)) + (a/S(4) - b/S(4))*log(x**S(2) + x + S(1)) - sqrt(S(3))*(a + b)*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(6) + sqrt(S(3))*(a + b)*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(6), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2))/(x**S(4) + x**S(2) + S(1))**S(2), x), x, x*(a + b - x**S(2)*(a - S(2)*b))/(S(6)*x**S(4) + S(6)*x**S(2) + S(6)) - (a/S(4) - b/S(8))*log(x**S(2) - x + S(1)) + (a/S(4) - b/S(8))*log(x**S(2) + x + S(1)) - sqrt(S(3))*(S(4)*a + b)*atan(sqrt(S(3))*(-S(2)*x + S(1))/S(3))/S(36) + sqrt(S(3))*(S(4)*a + b)*atan(sqrt(S(3))*(S(2)*x + S(1))/S(3))/S(36), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2))/(x**S(4) + x**S(2) + S(2)), x), x, -(a - sqrt(S(2))*b)*log(x**S(2) - x*sqrt(S(-1) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(4)*sqrt(S(-2) + S(4)*sqrt(S(2)))) + (a - sqrt(S(2))*b)*log(x**S(2) + x*sqrt(S(-1) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(4)*sqrt(S(-2) + S(4)*sqrt(S(2)))) - sqrt(S(-1)/14 + sqrt(S(2))/S(7))*(a + sqrt(S(2))*b)*atan((-S(2)*x + sqrt(S(-1) + S(2)*sqrt(S(2))))/sqrt(S(1) + S(2)*sqrt(S(2))))/S(2) + sqrt(S(-1)/14 + sqrt(S(2))/S(7))*(a + sqrt(S(2))*b)*atan((S(2)*x + sqrt(S(-1) + S(2)*sqrt(S(2))))/sqrt(S(1) + S(2)*sqrt(S(2))))/S(2), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2))/(x**S(4) + x**S(2) + S(2))**S(2), x), x, x*(S(3)*a + S(2)*b - x**S(2)*(a - S(4)*b))/(S(28)*x**S(4) + S(28)*x**S(2) + S(56)) - sqrt(S(-1)/14 + sqrt(S(2))/S(7))*(a*(-sqrt(S(2)) + S(11)) - b*(-S(4)*sqrt(S(2)) + S(2)))*atan((-S(2)*x + sqrt(S(-1) + S(2)*sqrt(S(2))))/sqrt(S(1) + S(2)*sqrt(S(2))))/S(56) + sqrt(S(-1)/14 + sqrt(S(2))/S(7))*(a*(-sqrt(S(2)) + S(11)) - b*(-S(4)*sqrt(S(2)) + S(2)))*atan((S(2)*x + sqrt(S(-1) + S(2)*sqrt(S(2))))/sqrt(S(1) + S(2)*sqrt(S(2))))/S(56) - (S(11)*a - S(2)*b + sqrt(S(2))*(a - S(4)*b))*log(x**S(2) - x*sqrt(S(-1) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(112)*sqrt(S(-2) + S(4)*sqrt(S(2)))) + (a*(sqrt(S(2)) + S(11)) - S(4)*sqrt(S(2))*b - S(2)*b)*log(x**S(2) + x*sqrt(S(-1) + S(2)*sqrt(S(2))) + sqrt(S(2)))/(S(112)*sqrt(S(-2) + S(4)*sqrt(S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + sqrt(S(2)))/(x**S(4) - sqrt(S(2))*x**S(2) + S(1)), x), x, -sqrt(sqrt(S(2))/S(2) + S(1))*log(x**S(2) - x*sqrt(sqrt(S(2)) + S(2)) + S(1))/S(4) + sqrt(sqrt(S(2))/S(2) + S(1))*log(x**S(2) + x*sqrt(sqrt(S(2)) + S(2)) + S(1))/S(4) - atan((-S(2)*x + sqrt(sqrt(S(2)) + S(2)))/sqrt(-sqrt(S(2)) + S(2)))/(S(2)*sqrt(sqrt(S(2)) + S(2))) + atan((S(2)*x + sqrt(sqrt(S(2)) + S(2)))/sqrt(-sqrt(S(2)) + S(2)))/(S(2)*sqrt(sqrt(S(2)) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + sqrt(S(2)))/(x**S(4) + sqrt(S(2))*x**S(2) + S(1)), x), x, -sqrt(-sqrt(S(2))/S(2) + S(1))*log(x**S(2) - x*sqrt(-sqrt(S(2)) + S(2)) + S(1))/S(4) + sqrt(-sqrt(S(2))/S(2) + S(1))*log(x**S(2) + x*sqrt(-sqrt(S(2)) + S(2)) + S(1))/S(4) - atan((-S(2)*x + sqrt(-sqrt(S(2)) + S(2)))/sqrt(sqrt(S(2)) + S(2)))/(S(2)*sqrt(-sqrt(S(2)) + S(2))) + atan((S(2)*x + sqrt(-sqrt(S(2)) + S(2)))/sqrt(sqrt(S(2)) + S(2)))/(S(2)*sqrt(-sqrt(S(2)) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + sqrt(S(2)))/(b*x**S(2) + x**S(4) + S(1)), x), x, (-sqrt(S(2)) + S(1))*atan((-S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/(S(2)*sqrt(b + S(2))) - (-sqrt(S(2)) + S(1))*atan((S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/(S(2)*sqrt(b + S(2))) - (S(1) + sqrt(S(2)))*log(x**S(2) - x*sqrt(-b + S(2)) + S(1))/(S(4)*sqrt(-b + S(2))) + (S(1) + sqrt(S(2)))*log(x**S(2) + x*sqrt(-b + S(2)) + S(1))/(S(4)*sqrt(-b + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + sqrt(S(2)))/(b*x**S(2) + x**S(4) + S(1)), x), x, -(S(1) + sqrt(S(2)))*atan((-S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/(S(2)*sqrt(b + S(2))) + (S(1) + sqrt(S(2)))*atan((S(2)*x + sqrt(-b + S(2)))/sqrt(b + S(2)))/(S(2)*sqrt(b + S(2))) + (-sqrt(S(2)) + S(1))*log(x**S(2) - x*sqrt(-b + S(2)) + S(1))/(S(4)*sqrt(-b + S(2))) - (-sqrt(S(2)) + S(1))*log(x**S(2) + x*sqrt(-b + S(2)) + S(1))/(S(4)*sqrt(-b + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*a - x**S(2))/(a**S(2) - a*x**S(2) + x**S(4)), x), x, -sqrt(S(3))*log(-sqrt(S(3))*sqrt(a)*x + a + x**S(2))/(S(4)*sqrt(a)) + sqrt(S(3))*log(sqrt(S(3))*sqrt(a)*x + a + x**S(2))/(S(4)*sqrt(a)) - atan((sqrt(S(3))*sqrt(a) - S(2)*x)/sqrt(a))/(S(2)*sqrt(a)) + atan((sqrt(S(3))*sqrt(a) + S(2)*x)/sqrt(a))/(S(2)*sqrt(a)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*sqrt(a) - x**S(2))/(-sqrt(a)*x**S(2) + a + x**S(4)), x), x, -sqrt(S(3))*log(-sqrt(S(3))*a**(S(1)/4)*x + sqrt(a) + x**S(2))/(S(4)*a**(S(1)/4)) + sqrt(S(3))*log(sqrt(S(3))*a**(S(1)/4)*x + sqrt(a) + x**S(2))/(S(4)*a**(S(1)/4)) - atan((sqrt(S(3))*a**(S(1)/4) - S(2)*x)/a**(S(1)/4))/(S(2)*a**(S(1)/4)) + atan((sqrt(S(3))*a**(S(1)/4) + S(2)*x)/a**(S(1)/4))/(S(2)*a**(S(1)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(2)*b**(S(2)/3) + x**S(2))/(b**(S(4)/3) + b**(S(2)/3)*x**S(2) + x**S(4)), x), x, -log(b**(S(2)/3) - b**(S(1)/3)*x + x**S(2))/(S(4)*b**(S(1)/3)) + log(b**(S(2)/3) + b**(S(1)/3)*x + x**S(2))/(S(4)*b**(S(1)/3)) - sqrt(S(3))*atan(sqrt(S(3))*(b**(S(1)/3) - S(2)*x)/(S(3)*b**(S(1)/3)))/(S(2)*b**(S(1)/3)) + sqrt(S(3))*atan(sqrt(S(3))*(b**(S(1)/3) + S(2)*x)/(S(3)*b**(S(1)/3)))/(S(2)*b**(S(1)/3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((A + B*x**S(2))/(a**S(2) - a*x**S(2) + x**S(4)), x), x, -sqrt(S(3))*(A - B*a)*log(-sqrt(S(3))*sqrt(a)*x + a + x**S(2))/(S(12)*a**(S(3)/2)) + sqrt(S(3))*(A - B*a)*log(sqrt(S(3))*sqrt(a)*x + a + x**S(2))/(S(12)*a**(S(3)/2)) - (A + B*a)*atan((sqrt(S(3))*sqrt(a) - S(2)*x)/sqrt(a))/(S(2)*a**(S(3)/2)) + (A + B*a)*atan((sqrt(S(3))*sqrt(a) + S(2)*x)/sqrt(a))/(S(2)*a**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((A + B*x**S(2))/(-sqrt(a)*x**S(2) + a + x**S(4)), x), x, -sqrt(S(3))*(A - B*sqrt(a))*log(-sqrt(S(3))*a**(S(1)/4)*x + sqrt(a) + x**S(2))/(S(12)*a**(S(3)/4)) + sqrt(S(3))*(A - B*sqrt(a))*log(sqrt(S(3))*a**(S(1)/4)*x + sqrt(a) + x**S(2))/(S(12)*a**(S(3)/4)) - (A + B*sqrt(a))*atan((sqrt(S(3))*a**(S(1)/4) - S(2)*x)/a**(S(1)/4))/(S(2)*a**(S(3)/4)) + (A + B*sqrt(a))*atan((sqrt(S(3))*a**(S(1)/4) + S(2)*x)/a**(S(1)/4))/(S(2)*a**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((A + B*x**S(2))/(a + c*x**S(4) - x**S(2)*sqrt(a*c)), x), x, -(A - B*sqrt(a)/sqrt(c))*log(sqrt(a) + sqrt(c)*x**S(2) - x*sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c)))/(S(4)*sqrt(a)*sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c))) + (A - B*sqrt(a)/sqrt(c))*log(sqrt(a) + sqrt(c)*x**S(2) + x*sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c)))/(S(4)*sqrt(a)*sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c))) - (A*sqrt(c) + B*sqrt(a))*atan((-S(2)*sqrt(c)*x + sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c)))/sqrt(S(2)*sqrt(a)*sqrt(c) - sqrt(a*c)))/(S(2)*sqrt(a)*sqrt(c)*sqrt(S(2)*sqrt(a)*sqrt(c) - sqrt(a*c))) + (A*sqrt(c) + B*sqrt(a))*atan((S(2)*sqrt(c)*x + sqrt(S(2)*sqrt(a)*sqrt(c) + sqrt(a*c)))/sqrt(S(2)*sqrt(a)*sqrt(c) - sqrt(a*c)))/(S(2)*sqrt(a)*sqrt(c)*sqrt(S(2)*sqrt(a)*sqrt(c) - sqrt(a*c))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((A + B*x**S(2))/(-sqrt(a)*sqrt(c)*x**S(2) + a + c*x**S(4)), x), x, -sqrt(S(3))*(A - B*sqrt(a)/sqrt(c))*log(-sqrt(S(3))*a**(S(1)/4)*c**(S(1)/4)*x + sqrt(a) + sqrt(c)*x**S(2))/(S(12)*a**(S(3)/4)*c**(S(1)/4)) + sqrt(S(3))*(A - B*sqrt(a)/sqrt(c))*log(sqrt(S(3))*a**(S(1)/4)*c**(S(1)/4)*x + sqrt(a) + sqrt(c)*x**S(2))/(S(12)*a**(S(3)/4)*c**(S(1)/4)) - (A*sqrt(c) + B*sqrt(a))*atan((sqrt(S(3))*a**(S(1)/4) - S(2)*c**(S(1)/4)*x)/a**(S(1)/4))/(S(2)*a**(S(3)/4)*c**(S(3)/4)) + (A*sqrt(c) + B*sqrt(a))*atan((sqrt(S(3))*a**(S(1)/4) + S(2)*c**(S(1)/4)*x)/a**(S(1)/4))/(S(2)*a**(S(3)/4)*c**(S(3)/4)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(125)*x**S(3)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(9) + S(577)*x*(x**S(2) + S(2))/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(757)*x**S(2) + S(2608))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(21) + S(275)*x*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(7) - S(577)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(2945)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(21)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(31)*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + x*(S(114)*x**S(2) + S(407))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(21) + S(25)*x*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(7) - S(31)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(472)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(21)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))*sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(5)*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + x*(S(3)*x**S(2) + S(10))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(3) - S(5)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(11)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(3) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(2)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(5)*x**S(2) + S(7)), x), x, x*(x**S(2) + S(2))/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(3)*x**S(2) + S(3))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(70)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt((x**S(2) + S(2))/(S(2)*x**S(2) + S(2)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(5)*x**S(2) + S(7)), x), x, x*(x**S(2) + S(2))/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(4)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(25)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(3)*x**S(2) + S(3))*elliptic_f(atan(x), S(1)/2)/(S(50)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*(S(3)*x**S(2) + S(6))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(70)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(5)*x**S(2) + S(7))**S(2), x), x, x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(70)*x**S(2) + S(98)) - x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(70)*x**S(2) + S(70)) + sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_e(atan(x), S(1)/2)/(S(70)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))) + S(3)*sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_f(atan(x), S(1)/2)/(S(280)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))) - sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(1960)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(3)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, S(125)*x**S(3)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(5)/2)/S(13) + S(20884)*x*(x**S(2) + S(2))/(S(65)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(65345)*x**S(2) + S(208212))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(3003) + x*(S(297911)*x**S(2) + S(1032541))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(5005) + S(3825)*x*(x**S(4) + S(3)*x**S(2) + S(2))**(S(5)/2)/S(143) - S(20884)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(65)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(1171349)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(5005)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(2)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, S(742)*x*(x**S(2) + S(2))/(S(15)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(2240)*x**S(2) + S(7281))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(693) + x*(S(10643)*x**S(2) + S(36783))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(1155) + S(25)*x*(x**S(4) + S(3)*x**S(2) + S(2))**(S(5)/2)/S(11) - S(742)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(15)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(13879)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(385)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, S(116)*x*(x**S(2) + S(2))/(S(15)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(35)*x**S(2) + S(108))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(63) + x*(S(149)*x**S(2) + S(519))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(105) - S(116)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(15)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(197)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(35)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, S(6)*x*(x**S(2) + S(2))/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(9)*x**S(2) + S(29))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(35) + x*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/S(7) - S(6)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(31)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(35)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/(S(5)*x**S(2) + S(7)), x), x, x**S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(25) + S(24)*x*(x**S(2) + S(2))/(S(125)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(11)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(75) - S(24)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(125)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(47)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(375)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + (S(24)*x**S(2) + S(24))*elliptic_pi(S(-3)/7, atan(sqrt(S(2))*x/S(2)), S(-1))/(S(875)*sqrt((x**S(2) + S(1))/(x**S(2) + S(2)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)/(S(5)*x**S(2) + S(7))**S(2), x), x, x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(75) - S(3)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(875)*x**S(2) + S(1225)) + S(9)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(175)*x**S(2) + S(175)) + S(8)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_pi(S(-3)/7, atan(sqrt(S(2))*x/S(2)), S(-1))/(S(875)*sqrt((x**S(2) + S(1))/(x**S(2) + S(2)))*(x**S(2) + S(2))) - S(9)*sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_e(atan(x), S(1)/2)/(sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(175)*x**S(2) + S(175))) + S(211)*sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_f(atan(x), S(1)/2)/(S(10500)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))) + S(129)*sqrt(S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(24500)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(9)*a*e**S(3)/c + S(8)*b**S(2)*e**S(3)/c**S(2) - S(30)*b*d*e**S(2)/c + S(45)*d**S(2)*e + (S(4)*a*b*e**S(3) - S(15)*a*c*d*e**S(2) + S(15)*c**S(2)*d**S(3))/(sqrt(a)*c**(S(3)/2)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(30)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - a**(S(1)/4)*e*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(8)*b**S(2)*e**S(2) + S(45)*c**S(2)*d**S(2) - S(3)*c*e*(S(3)*a*e + S(10)*b*d))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(15)*c**(S(11)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + e**S(3)*x**S(3)*sqrt(a + b*x**S(2) + c*x**S(4))/(S(5)*c) + e**S(2)*x*(-S(4)*b*e + S(15)*c*d)*sqrt(a + b*x**S(2) + c*x**S(4))/(S(15)*c**S(2)) + e*x*sqrt(a + b*x**S(2) + c*x**S(4))*(S(8)*b**S(2)*e**S(2) + S(45)*c**S(2)*d**S(2) - S(3)*c*e*(S(3)*a*e + S(10)*b*d))/(S(15)*c**(S(5)/2)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-S(2)*b*e**S(2)/c + S(6)*d*e + (-a*e**S(2) + S(3)*c*d**S(2))/(sqrt(a)*sqrt(c)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(6)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) - S(2)*a**(S(1)/4)*e*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(-b*e + S(3)*c*d)*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(3)*c**(S(7)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + e**S(2)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*c) + S(2)*e*x*(-b*e + S(3)*c*d)*sqrt(a + b*x**S(2) + c*x**S(4))/(S(3)*c**(S(3)/2)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -a**(S(1)/4)*e*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*c**(S(3)/4)*sqrt(a + b*x**S(2) + c*x**S(4))) + e*x*sqrt(a + b*x**S(2) + c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, atan(x*sqrt(a*e/d - b + c*d/e)/sqrt(a + b*x**S(2) + c*x**S(4)))/(S(2)*d*sqrt(a*e/d - b + c*d/e)) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*(-sqrt(a)*e + sqrt(c)*d)*sqrt(a + b*x**S(2) + c*x**S(4))) - sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_pi(-sqrt(a)*(-e + sqrt(c)*d/sqrt(a))**S(2)/(S(4)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(4)*a**(S(1)/4)*c**(S(1)/4)*d*(-e + sqrt(c)*d/sqrt(a))*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*sqrt(a + b*x**S(2) + c*x**S(4))), x), x, a**(S(1)/4)*c**(S(1)/4)*e*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*d*sqrt(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))) - a**(S(1)/4)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(4)*d*sqrt(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))) - a**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*(S(3)*c*d**S(2) - e*(-a*e + S(2)*b*d))*elliptic_pi(-(-sqrt(a)*e + sqrt(c)*d)**S(2)/(S(4)*sqrt(a)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(8)*c**(S(1)/4)*d**S(2)*(-sqrt(a)*e + sqrt(c)*d)*sqrt(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))) - sqrt(c)*e*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*d*(sqrt(a) + sqrt(c)*x**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + e**S(2)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(S(2)*d*(d + e*x**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + (S(3)*c*d**S(2) - e*(-a*e + S(2)*b*d))*atan(x*sqrt(a*e/d - b + c*d/e)/sqrt(a + b*x**S(2) + c*x**S(4)))/(S(4)*d**S(3)*e*(a*e/d - b + c*d/e)**(S(3)/2)) + c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(3)*c*d**S(2) - e*(-a*e + S(2)*b*d))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(4)*a**(S(1)/4)*d*(-sqrt(a)*e + sqrt(c)*d)*sqrt(a + b*x**S(2) + c*x**S(4))*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -e**S(3)*x**S(3)*sqrt(a + b*x**S(2) - c*x**S(4))/(S(5)*c) - e**S(2)*x*(S(4)*b*e + S(15)*c*d)*sqrt(a + b*x**S(2) - c*x**S(4))/(S(15)*c**S(2)) + sqrt(S(2))*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*(S(9)*a*e**S(3)/c + S(8)*b**S(2)*e**S(3)/c**S(2) + S(30)*b*d*e**S(2)/c + S(45)*d**S(2)*e + (S(8)*a*b*e**S(3) + S(30)*a*c*d*e**S(2) + S(30)*c**S(2)*d**S(3))/(b*c - c*sqrt(S(4)*a*c + b**S(2))))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(60)*c**(S(3)/2)*sqrt(a + b*x**S(2) - c*x**S(4))) - sqrt(S(2))*e*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*(S(8)*b**S(2)*e**S(2) + S(45)*c**S(2)*d**S(2) + S(3)*c*e*(S(3)*a*e + S(10)*b*d))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(60)*c**(S(7)/2)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -e**S(2)*x*sqrt(a + b*x**S(2) - c*x**S(4))/(S(3)*c) - sqrt(S(2))*e*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(b*e + S(3)*c*d)*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*c**(S(5)/2)*sqrt(a + b*x**S(2) - c*x**S(4))) + sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*(b*e**S(2)*(b - sqrt(S(4)*a*c + b**S(2))) + S(3)*c**S(2)*d**S(2) + c*e*(a*e + S(3)*b*d - S(3)*d*sqrt(S(4)*a*c + b**S(2))))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(6)*c**(S(5)/2)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(a + b*x**S(2) - c*x**S(4)), x), x, -sqrt(S(2))*e*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(a + b*x**S(2) - c*x**S(4))) + sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*d + e*(b - sqrt(S(4)*a*c + b**S(2))))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(a + b*x**S(2) - c*x**S(4))), x), x, sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_pi(-e*(b + sqrt(S(4)*a*c + b**S(2)))/(S(2)*c*d), asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*d*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*sqrt(a + b*x**S(2) - c*x**S(4))), x), x, -e**S(2)*x*sqrt(a + b*x**S(2) - c*x**S(4))/(S(2)*d*(d + e*x**S(2))*(-a*e**S(2) + b*d*e + c*d**S(2))) + sqrt(S(2))*e*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(8)*sqrt(c)*d*(c*d**S(2) + e*(-a*e + b*d))*sqrt(a + b*x**S(2) - c*x**S(4))) - sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*d + e*(b - sqrt(S(4)*a*c + b**S(2))))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(8)*sqrt(c)*d*(c*d**S(2) + e*(-a*e + b*d))*sqrt(a + b*x**S(2) - c*x**S(4))) + sqrt(S(2))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(3)*c*d**S(2) + e*(-a*e + S(2)*b*d))*sqrt(-S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(-S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_pi(-e*(b + sqrt(S(4)*a*c + b**S(2)))/(S(2)*c*d), asin(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), (b + sqrt(S(4)*a*c + b**S(2)))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*sqrt(c)*d**S(2)*(c*d**S(2) + e*(-a*e + b*d))*sqrt(a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(-a + b*x**S(2) + c*x**S(4)), x), x, e*x*(b - sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))/(S(2)*c*sqrt(-a + b*x**S(2) + c*x**S(4))) + sqrt(S(2))*d*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), -S(2)*sqrt(S(4)*a*c + b**S(2))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*sqrt((S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))/(S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1)))*sqrt(-a + b*x**S(2) + c*x**S(4))) - sqrt(S(2))*e*(b - sqrt(S(4)*a*c + b**S(2)))*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_e(atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), -S(2)*sqrt(S(4)*a*c + b**S(2))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(4)*c**(S(3)/2)*sqrt((S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))/(S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1)))*sqrt(-a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, sqrt(S(2))*sqrt(-b + sqrt(S(4)*a*c + b**S(2)))*sqrt(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_pi(e*(b - sqrt(S(4)*a*c + b**S(2)))/(S(2)*c*d), asin(sqrt(S(2))*sqrt(c)*x/sqrt(-b + sqrt(S(4)*a*c + b**S(2)))), (b - sqrt(S(4)*a*c + b**S(2)))/(b + sqrt(S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*d*sqrt(-a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(-a + b*x**S(2) + c*x**S(4))), x), x, sqrt(S(2))*sqrt(c)*sqrt(b + sqrt(S(4)*a*c + b**S(2)))*(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_f(atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), -S(2)*sqrt(S(4)*a*c + b**S(2))/(b - sqrt(S(4)*a*c + b**S(2))))/(sqrt((S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))/(S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1)))*(S(2)*c*d - e*(b + sqrt(S(4)*a*c + b**S(2))))*sqrt(-a + b*x**S(2) + c*x**S(4))) - sqrt(S(2))*e*(b + sqrt(S(4)*a*c + b**S(2)))**(S(3)/2)*(S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))*elliptic_pi(S(1) - e*(b + sqrt(S(4)*a*c + b**S(2)))/(S(2)*c*d), atan(sqrt(S(2))*sqrt(c)*x/sqrt(b + sqrt(S(4)*a*c + b**S(2)))), -S(2)*sqrt(S(4)*a*c + b**S(2))/(b - sqrt(S(4)*a*c + b**S(2))))/(S(2)*sqrt(c)*d*sqrt((S(2)*c*x**S(2)/(b - sqrt(S(4)*a*c + b**S(2))) + S(1))/(S(2)*c*x**S(2)/(b + sqrt(S(4)*a*c + b**S(2))) + S(1)))*(S(2)*c*d - e*(b + sqrt(S(4)*a*c + b**S(2))))*sqrt(-a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(-a + b*x**S(2) - c*x**S(4)), x), x, -a**(S(1)/4)*e*sqrt((a - b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 + b/(S(4)*sqrt(a)*sqrt(c)))/(c**(S(3)/4)*sqrt(-a + b*x**S(2) - c*x**S(4))) + a**(S(1)/4)*sqrt((a - b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 + b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*c**(S(3)/4)*sqrt(-a + b*x**S(2) - c*x**S(4))) - e*x*sqrt(-a + b*x**S(2) - c*x**S(4))/(sqrt(c)*(sqrt(a) + sqrt(c)*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(-a + b*x**S(2) - c*x**S(4))), x), x, atan(x*sqrt(-a*e/d - b - c*d/e)/sqrt(-a + b*x**S(2) - c*x**S(4)))/(S(2)*d*sqrt(-a*e/d - b - c*d/e)) + c**(S(1)/4)*sqrt((a - b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 + b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*(-sqrt(a)*e + sqrt(c)*d)*sqrt(-a + b*x**S(2) - c*x**S(4))) - sqrt((a - b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(e + sqrt(c)*d/sqrt(a))*elliptic_pi(-sqrt(a)*(-e + sqrt(c)*d/sqrt(a))**S(2)/(S(4)*sqrt(c)*d*e), S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 + b/(S(4)*sqrt(a)*sqrt(c)))/(S(4)*a**(S(1)/4)*c**(S(1)/4)*d*(-e + sqrt(c)*d/sqrt(a))*sqrt(-a + b*x**S(2) - c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(3)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, e**S(3)*x**S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(5) + e**S(2)*x*(d - S(4)*e/S(5))*sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(3)*e*x*(x**S(2) + S(2))*(S(5)*d**S(2) - S(10)*d*e + S(6)*e**S(2))/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - S(3)*sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*(S(5)*d**S(2) - S(10)*d*e + S(6)*e**S(2))*elliptic_e(atan(x), S(1)/2)/(S(5)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*(S(5)*d**S(3) - S(10)*d*e**S(2) + S(8)*e**S(3))*elliptic_f(atan(x), S(1)/2)/(S(10)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**S(2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, e**S(2)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(3) + e*x*(S(2)*d - S(2)*e)*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) - S(2)*sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(d - e)*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(3)*d**S(2) - S(2)*e**S(2))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(6)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, sqrt(S(2))*d*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + e*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) - sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_pi(S(1) - e/d, atan(x), S(1)/2)/(S(2)*d*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*e*(x**S(2) + S(2))*elliptic_pi(S(1) - e/d, atan(x), S(1)/2)/(S(2)*d*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, e**S(2)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(2)*d*(d + e*x**S(2))*(d**S(2) - S(3)*d*e + S(2)*e**S(2))) - e*x*(x**S(2) + S(2))/(S(2)*d*(d**S(2) - S(3)*d*e + S(2)*e**S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(2)*d*(d - S(2)*e)*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt((x**S(2) + S(2))/(S(2)*x**S(2) + S(2)))*(S(2)*d - e)*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*d*(d - e)**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*e*(x**S(2) + S(2))*(S(3)*d**S(2) - S(6)*d*e + S(2)*e**S(2))*elliptic_pi(S(1) - e/d, atan(x), S(1)/2)/(S(4)*d**S(2)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(d - S(2)*e)*(d - e)**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/((d + e*x**S(2))**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, -sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(4)*(d - S(2)*e)*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + e**S(2)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(2)*d*(d + e*x**S(2))*(d**S(2) - S(3)*d*e + S(2)*e**S(2))) - e*x*(x**S(2) + S(2))/(S(2)*d*(d**S(2) - S(3)*d*e + S(2)*e**S(2))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*e*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(2)*d*(d - S(2)*e)*(d - e)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*(S(3)*d**S(2) - S(6)*d*e + S(2)*e**S(2))*elliptic_f(atan(x), S(1)/2)/(S(4)*d*(d - S(2)*e)*(d - e)**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*e*(x**S(2) + S(2))*(S(3)*d**S(2) - S(6)*d*e + S(2)*e**S(2))*elliptic_pi(S(1) - e/d, atan(x), S(1)/2)/(S(4)*d**S(2)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(d - S(2)*e)*(d - e)**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(3)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(25)*x**S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(135)*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(75)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2)) - S(135)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(193)*x**S(2) + S(193))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(20)*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + S(25)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/S(3) - S(20)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(97)*x**S(2) + S(97))*elliptic_f(atan(x), S(1)/2)/(S(6)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, S(5)*x*(x**S(2) + S(2))/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) - S(5)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(7)*x**S(2) + S(7))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)), x), x, sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(4)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*(S(5)*x**S(2) + S(10))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(28)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))**S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, S(5)*x*(x**S(2) + S(2))/(S(84)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - S(25)*x*sqrt(x**S(4) + S(3)*x**S(2) + S(2))/(S(420)*x**S(2) + S(588)) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(5)*x**S(2) + S(5))*elliptic_e(atan(x), S(1)/2)/(S(84)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(9)*x**S(2) + S(9))*elliptic_f(atan(x), S(1)/2)/(S(112)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*(S(65)*x**S(2) + S(130))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(2352)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(3)/(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, x*(-S(11)*x**S(2) + S(5))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(261)*x*(x**S(2) + S(2))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(169)*x**S(2) + S(169))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(261)*x**S(2) + S(261))*elliptic_e(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))**S(2)/(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, -S(17)*x*(x**S(2) + S(2))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(17)*x**S(2) + S(25))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + S(6)*sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(17)*x**S(2) + S(17))*elliptic_e(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((S(5)*x**S(2) + S(7))/(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2), x), x, -x*(x**S(2) + S(2))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(x**S(2) + S(5))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(4) + S(3)*x**S(2) + S(2))**(S(-3)/2), x), x, -S(3)*x*(x**S(2) + S(2))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(3)*x**S(2) + S(5))/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_f(atan(x), S(1)/2)/sqrt(x**S(4) + S(3)*x**S(2) + S(2)) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(3)*x**S(2) + S(3))*elliptic_e(atan(x), S(1)/2)/(S(2)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)), x), x, x/(S(6)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(125)*x**S(2) + S(125))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(168)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt((x**S(2) + S(2))/(S(2)*x**S(2) + S(2)))*(S(9)*x**S(2) + S(9))*elliptic_f(atan(x), S(1)/2)/(S(4)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)), x), x, -x*(x**S(2) + S(2))/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + x*(S(2)*x**S(2) + S(5))/(S(6)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(x**S(2) + S(1))*elliptic_e(atan(x), S(1)/2)/(S(3)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(9)*x**S(2) + S(9))*elliptic_f(atan(x), S(1)/2)/(S(8)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*(S(125)*x**S(2) + S(250))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(168)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))**S(2)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)), x), x, S(625)*x*(x**S(2) + S(1))*(x**S(2) + S(2))/((S(2520)*x**S(2) + S(3528))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - S(125)*x*(x**S(2) + S(2))/(S(504)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - x/(S(18)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(31)*x**S(2) + S(31))*elliptic_e(atan(x), S(1)/2)/(S(56)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*(S(375)*x**S(2) + S(375))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(1568)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt((x**S(2) + S(2))/(S(2)*x**S(2) + S(2)))*(S(463)*x**S(2) + S(463))*elliptic_f(atan(x), S(1)/2)/(S(336)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True) or rubi_test(rubi_integrate(S(1)/((S(5)*x**S(2) + S(7))**S(2)*(x**S(4) + S(3)*x**S(2) + S(2))**(S(3)/2)), x), x, S(625)*x*(x**S(2) + S(1))*(x**S(2) + S(2))/((S(2520)*x**S(2) + S(3528))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - S(125)*x*(x**S(2) + S(2))/(S(504)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - x/(S(18)*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + (S(125)*x**S(2) + S(125))*elliptic_pi(S(-3)/7, atan(sqrt(S(2))*x/S(2)), S(-1))/(S(189)*sqrt((x**S(2) + S(1))/(x**S(2) + S(2)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*(S(31)*x**S(2) + S(62))*elliptic_e(atan(x), S(1)/2)/(S(56)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) + sqrt(S(2))*(S(6875)*x**S(2) + S(13750))*elliptic_pi(S(2)/7, atan(x), S(1)/2)/(S(14112)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))) - sqrt(S(2))*(S(7667)*x**S(2) + S(15334))*elliptic_f(atan(x), S(1)/2)/(S(6048)*sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) + x**S(2) + S(3)), x), x, -sqrt(S(-1)/2 + sqrt(S(13))/S(2))*elliptic_e(asin(sqrt(S(2))*x/sqrt(S(1) + sqrt(S(13)))), S(-7)/6 - sqrt(S(13))/S(6)) + sqrt(S(7) + S(2)*sqrt(S(13)))*elliptic_f(asin(sqrt(S(2))*x/sqrt(S(1) + sqrt(S(13)))), S(-7)/6 - sqrt(S(13))/S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) + S(2)*x**S(2) + S(3)), x), x, -elliptic_e(asin(sqrt(S(3))*x/S(3)), S(-3)) + S(4)*elliptic_f(asin(sqrt(S(3))*x/S(3)), S(-3)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) + S(3)*x**S(2) + S(3)), x), x, -sqrt(S(-3)/2 + sqrt(S(21))/S(2))*elliptic_e(asin(sqrt(S(2))*x/sqrt(S(3) + sqrt(S(21)))), S(-5)/2 - sqrt(S(21))/S(2)) + sqrt(S(9) + S(2)*sqrt(S(21)))*elliptic_f(asin(sqrt(S(2))*x/sqrt(S(3) + sqrt(S(21)))), S(-5)/2 - sqrt(S(21))/S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) - x**S(2) + S(3)), x), x, -sqrt(S(1)/2 + sqrt(S(13))/S(2))*elliptic_e(asin(sqrt(S(2))*x/sqrt(S(-1) + sqrt(S(13)))), S(-7)/6 + sqrt(S(13))/S(6)) + sqrt(S(5) + S(2)*sqrt(S(13)))*elliptic_f(asin(sqrt(S(2))*x/sqrt(S(-1) + sqrt(S(13)))), S(-7)/6 + sqrt(S(13))/S(6)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) - S(2)*x**S(2) + S(3)), x), x, -sqrt(S(3))*elliptic_e(asin(x), S(-1)/3) + S(2)*sqrt(S(3))*elliptic_f(asin(x), S(-1)/3), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((-x**S(2) + S(3))/sqrt(-x**S(4) - S(3)*x**S(2) + S(3)), x), x, -sqrt(S(3)/2 + sqrt(S(21))/S(2))*elliptic_e(asin(sqrt(S(2))*x/sqrt(S(-3) + sqrt(S(21)))), S(-5)/2 + sqrt(S(21))/S(2)) + sqrt(S(3) + S(2)*sqrt(S(21)))*elliptic_f(asin(sqrt(S(2))*x/sqrt(S(-3) + sqrt(S(21)))), S(-5)/2 + sqrt(S(21))/S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((b + S(2)*c*x**S(2) - sqrt(-S(4)*a*c + b**S(2)))/sqrt(a + b*x**S(2) + c*x**S(4)), x), x, -S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*elliptic_e(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/sqrt(a + b*x**S(2) + c*x**S(4)) + S(2)*sqrt(c)*x*sqrt(a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2)) + sqrt((a + b*x**S(2) + c*x**S(4))/(sqrt(a) + sqrt(c)*x**S(2))**S(2))*(sqrt(a) + sqrt(c)*x**S(2))*(S(2)*sqrt(a)*sqrt(c) + b - sqrt(-S(4)*a*c + b**S(2)))*elliptic_f(S(2)*atan(c**(S(1)/4)*x/a**(S(1)/4)), S(1)/2 - b/(S(4)*sqrt(a)*sqrt(c)))/(S(2)*a**(S(1)/4)*c**(S(1)/4)*sqrt(a + b*x**S(2) + c*x**S(4))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((x**S(2) + S(2))/((x**S(2) + S(1))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), x), x, sqrt(S(2))*(x**S(2) + S(2))*elliptic_e(atan(x), S(1)/2)/(sqrt((x**S(2) + S(2))/(x**S(2) + S(1)))*sqrt(x**S(4) + S(3)*x**S(2) + S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**(S(5)/2)*(a + b*x**S(2) + c*x**S(4)), x), x, c*x**S(3)*(d + e*x**S(2))**(S(7)/2)/(S(10)*e) + d**S(3)*(S(80)*a*e**S(2) - S(10)*b*d*e + S(3)*c*d**S(2))*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(256)*e**(S(5)/2)) + d**S(2)*x*sqrt(d + e*x**S(2))*(S(80)*a*e**S(2) - S(10)*b*d*e + S(3)*c*d**S(2))/(S(256)*e**S(2)) + d*x*(d + e*x**S(2))**(S(3)/2)*(S(80)*a*e**S(2) - S(10)*b*d*e + S(3)*c*d**S(2))/(S(384)*e**S(2)) - x*(d + e*x**S(2))**(S(7)/2)*(-S(10)*b*e + S(3)*c*d)/(S(80)*e**S(2)) + x*(d + e*x**S(2))**(S(5)/2)*(S(80)*a*e**S(2) - S(10)*b*d*e + S(3)*c*d**S(2))/(S(480)*e**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**S(2))**(S(3)/2)*(a + b*x**S(2) + c*x**S(4)), x), x, c*x**S(3)*(d + e*x**S(2))**(S(5)/2)/(S(8)*e) + d**S(2)*(S(48)*a*e**S(2) - S(8)*b*d*e + S(3)*c*d**S(2))*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(128)*e**(S(5)/2)) + d*x*sqrt(d + e*x**S(2))*(S(48)*a*e**S(2) - S(8)*b*d*e + S(3)*c*d**S(2))/(S(128)*e**S(2)) - x*(d + e*x**S(2))**(S(5)/2)*(-S(8)*b*e + S(3)*c*d)/(S(48)*e**S(2)) + x*(d + e*x**S(2))**(S(3)/2)*(S(48)*a*e**S(2) - S(8)*b*d*e + S(3)*c*d**S(2))/(S(192)*e**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate(sqrt(d + e*x**S(2))*(a + b*x**S(2) + c*x**S(4)), x), x, c*x**S(3)*(d + e*x**S(2))**(S(3)/2)/(S(6)*e) + d*(S(8)*a*e**S(2) - S(2)*b*d*e + c*d**S(2))*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(16)*e**(S(5)/2)) - x*(d + e*x**S(2))**(S(3)/2)*(-S(2)*b*e + c*d)/(S(8)*e**S(2)) + x*sqrt(d + e*x**S(2))*(S(8)*a*e**S(2) - S(2)*b*d*e + c*d**S(2))/(S(16)*e**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/sqrt(d + e*x**S(2)), x), x, c*x**S(3)*sqrt(d + e*x**S(2))/(S(4)*e) - x*sqrt(d + e*x**S(2))*(-S(4)*b*e + S(3)*c*d)/(S(8)*e**S(2)) + (S(8)*a*e**S(2) - S(4)*b*d*e + S(3)*c*d**S(2))*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(8)*e**(S(5)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**(S(3)/2), x), x, c*x*sqrt(d + e*x**S(2))/(S(2)*e**S(2)) - (-S(2)*b*e + S(3)*c*d)*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/(S(2)*e**(S(5)/2)) + x*(a*e**S(2) - b*d*e + c*d**S(2))/(d*e**S(2)*sqrt(d + e*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**(S(5)/2), x), x, c*atanh(sqrt(e)*x/sqrt(d + e*x**S(2)))/e**(S(5)/2) + x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(3)*d*e**S(2)*(d + e*x**S(2))**(S(3)/2)) - x*(S(4)*c*d**S(2) - e*(S(2)*a*e + b*d))/(S(3)*d**S(2)*e**S(2)*sqrt(d + e*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**(S(7)/2), x), x, x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(5)*d*e**S(2)*(d + e*x**S(2))**(S(5)/2)) - x*(c*d**S(2) - S(5)*c*d*e*x**S(2) - e*(S(4)*a*e + b*d))/(S(15)*d**S(2)*e**S(2)*(d + e*x**S(2))**(S(3)/2)) - x*(S(2)*c*d**S(2) - S(2)*e*(S(4)*a*e + b*d))/(S(15)*d**S(3)*e**S(2)*sqrt(d + e*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**(S(9)/2), x), x, x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(7)*d*e**S(2)*(d + e*x**S(2))**(S(7)/2)) - x*(S(8)*c*d**S(2) - e*(S(6)*a*e + b*d))/(S(35)*d**S(2)*e**S(2)*(d + e*x**S(2))**(S(5)/2)) + x*(S(3)*c*d**S(2) + S(4)*e*(S(6)*a*e + b*d))/(S(105)*d**S(3)*e**S(2)*(d + e*x**S(2))**(S(3)/2)) + x*(S(6)*c*d**S(2) + S(8)*e*(S(6)*a*e + b*d))/(S(105)*d**S(4)*e**S(2)*sqrt(d + e*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + b*x**S(2) + c*x**S(4))/(d + e*x**S(2))**(S(11)/2), x), x, x*(a*e**S(2) - b*d*e + c*d**S(2))/(S(9)*d*e**S(2)*(d + e*x**S(2))**(S(9)/2)) - x*(S(10)*c*d**S(2) - e*(S(8)*a*e + b*d))/(S(63)*d**S(2)*e**S(2)*(d + e*x**S(2))**(S(7)/2)) + x*(c*d**S(2) + S(2)*e*(S(8)*a*e + b*d))/(S(105)*d**S(3)*e**S(2)*(d + e*x**S(2))**(S(5)/2)) + x*(S(4)*c*d**S(2) + S(8)*e*(S(8)*a*e + b*d))/(S(315)*d**S(4)*e**S(2)*(d + e*x**S(2))**(S(3)/2)) + x*(S(8)*c*d**S(2) + S(16)*e*(S(8)*a*e + b*d))/(S(315)*d**S(5)*e**S(2)*sqrt(d + e*x**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + c*x**(S(2)*n)), x), x, S(3)*d*e**S(2)*x/c + e**S(3)*x**(n + S(1))/(c*(n + S(1))) - x*(-a*e**S(3) + sqrt(c)*d*(-S(3)*a*e**S(2) + c*d**S(2))/sqrt(-a) + S(3)*c*d**S(2)*e)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*c**(S(3)/2)*sqrt(-a)) + x*(-S(3)*a*sqrt(c)*d*e**S(2) + a*e**S(3)*sqrt(-a) + c**(S(3)/2)*d**S(3) - S(3)*c*d**S(2)*e*sqrt(-a))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*c**(S(3)/2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + c*x**(S(2)*n)), x), x, e**S(2)*x/c + x*(-a*e**S(2) - S(2)*sqrt(c)*d*e*sqrt(-a) + c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*c) + x*(-a*e**S(2) + S(2)*sqrt(c)*d*e*sqrt(-a) + c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*c), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + c*x**(S(2)*n)), x), x, x*(d - e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a) + x*(d + e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a), expand=True, _diff=True, _numerical=True)

    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))*(d + e*x**n)), x), x, e**S(2)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))) + c*x*(d - e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))) + c*x*(d + e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))*(d + e*x**n)**S(2)), x), x, S(2)*c*e**S(2)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(a*e**S(2) + c*d**S(2))**S(2) + e**S(2)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) + c*d**S(2))) + c*x*(-a*e**S(2) - S(2)*sqrt(c)*d*e*sqrt(-a) + c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(2)) + c*x*(-a*e**S(2) + S(2)*sqrt(c)*d*e*sqrt(-a) + c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))*(d + e*x**n)**S(3)), x), x, c**(S(3)/2)*x*(-a*e**S(3) - sqrt(c)*d*(-S(3)*a*e**S(2) + c*d**S(2))/sqrt(-a) + S(3)*c*d**S(2)*e)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*sqrt(-a)*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(2)*x*(-a*e**S(2) + S(3)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(3)) + S(2)*c*e**S(2)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(2)) + e**S(2)*x*hyper((S(3), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(3)*(a*e**S(2) + c*d**S(2))) + c**(S(3)/2)*x*(-S(3)*a*sqrt(c)*d*e**S(2) + c**(S(3)/2)*d**S(3) + S(3)*c*d**S(2)*e*sqrt(-a) + e**S(3)*(-a)**(S(3)/2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(3)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)/(a - c*x**(S(2)*n)), x), x, x*(-sqrt(a)*e/sqrt(c) + d)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(a))/(S(2)*a) + x*(sqrt(a)*e/sqrt(c) + d)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(a))/(S(2)*a), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + c*x**(S(2)*n))**S(2), x), x, -x*(sqrt(c)*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) - (-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*c**(S(3)/2)*n*(-a)**(S(3)/2)) - x*(sqrt(c)*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) + (-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*c**(S(3)/2)*n*(-a)**(S(3)/2)) + e**S(2)*x*(S(3)*d - e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*c) + e**S(2)*x*(S(3)*d + e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*c) + x*(d*(-S(3)*a*e**S(2) + c*d**S(2)) + e*x**n*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(2)*a*c*n*(a + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + c*x**(S(2)*n))**S(2), x), x, e**S(2)*x*hyper((S(1), S(1)/(S(2)*n)), (S(1) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(a*c) + x*(-a*e**S(2) + c*d**S(2) + S(2)*c*d*e*x**n)/(S(2)*a*c*n*(a + c*x**(S(2)*n))) - x*(-a*e**S(2)*(-S(2)*n + S(1)) - S(2)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*c*n) - x*(-a*e**S(2)*(-S(2)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*c*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + c*x**(S(2)*n))**S(2), x), x, x*(d + e*x**n)/(S(2)*a*n*(a + c*x**(S(2)*n))) - x*(sqrt(c)*(-S(2)*d*n + d) + e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*sqrt(c)*n) - x*(sqrt(c)*d*(-S(2)*n + S(1)) - e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*sqrt(c)*n), expand=True, _diff=True, _numerical=True)

    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(2)*(d + e*x**n)), x), x, e**S(4)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(2)) + c*e**S(2)*x*(d - e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(2)) + c*e**S(2)*x*(d + e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(2)) + c*x*(d - e*x**n)/(S(2)*a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))) - sqrt(c)*x*(sqrt(c)*(-S(2)*d*n + d) + e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))) - sqrt(c)*x*(sqrt(c)*d*(-S(2)*n + S(1)) - e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    # apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(2)*(d + e*x**n)**S(2)), x), x, S(4)*c*e**S(4)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(a*e**S(2) + c*d**S(2))**S(3) + e**S(4)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) + c*d**S(2))**S(2)) + c*e**S(2)*x*(-a*e**S(2) - S(4)*sqrt(c)*d*e*sqrt(-a) + S(3)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(2)*x*(-a*e**S(2) + S(4)*sqrt(c)*d*e*sqrt(-a) + S(3)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(3)) + c*x*(-a*e**S(2) + c*d**S(2) - S(2)*c*d*e*x**n)/(S(2)*a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(2)) - c*x*(-a*e**S(2)*(-S(2)*n + S(1)) - S(2)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(2)) - c*x*(-a*e**S(2)*(-S(2)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    # apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(2)*(d + e*x**n)**S(3)), x), x, c**(S(3)/2)*e**S(2)*x*(-a*e**S(3) - S(3)*sqrt(c)*d*(-a*e**S(2) + c*d**S(2))/sqrt(-a) + S(5)*c*d**S(2)*e)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(sqrt(-a)*(a*e**S(2) + c*d**S(2))**S(4)) - c**(S(3)/2)*x*(sqrt(c)*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) - (-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*n*(-a)**(S(3)/2)*(a*e**S(2) + c*d**S(2))**S(3)) - c**(S(3)/2)*x*(sqrt(c)*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) + (-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*n*(-a)**(S(3)/2)*(a*e**S(2) + c*d**S(2))**S(3)) + S(2)*c*e**S(4)*x*(-a*e**S(2) + S(5)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(4)) + S(4)*c*e**S(4)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(3)) + e**S(4)*x*hyper((S(3), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(3)*(a*e**S(2) + c*d**S(2))**S(2)) + c**(S(3)/2)*e**S(2)*x*(-S(3)*a*sqrt(c)*d*e**S(2) + S(3)*c**(S(3)/2)*d**S(3) + S(5)*c*d**S(2)*e*sqrt(-a) + e**S(3)*(-a)**(S(3)/2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(a*(a*e**S(2) + c*d**S(2))**S(4)) + c**S(2)*x*(d*(-S(3)*a*e**S(2) + c*d**S(2)) - e*x**n*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(2)*a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(3)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + c*x**(S(2)*n))**S(3), x), x, -x*(sqrt(c)*(-S(4)*n + S(1))*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) - (-S(3)*n + S(1))*(-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*c**(S(3)/2)*n**S(2)*(-a)**(S(5)/2)) - x*(sqrt(c)*(-S(4)*n + S(1))*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) + (-S(3)*n + S(1))*(-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*c**(S(3)/2)*n**S(2)*(-a)**(S(5)/2)) + e**S(2)*x*(S(3)*d + e*x**n)/(S(2)*a*c*n*(a + c*x**(S(2)*n))) + x*(d*(-S(3)*a*e**S(2) + c*d**S(2)) + e*x**n*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(4)*a*c*n*(a + c*x**(S(2)*n))**S(2)) - x*(d*(-S(4)*n + S(1))*(-S(3)*a*e**S(2) + c*d**S(2)) + e*x**n*(-S(3)*n + S(1))*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(8)*a**S(2)*c*n**S(2)*(a + c*x**(S(2)*n))) - e**S(2)*x*(sqrt(c)*d*(-S(6)*n + S(3)) - e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*c**(S(3)/2)*n) - e**S(2)*x*(sqrt(c)*d*(-S(6)*n + S(3)) + e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*c**(S(3)/2)*n), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + c*x**(S(2)*n))**S(3), x), x, x*(-a*e**S(2) + c*d**S(2) + S(2)*c*d*e*x**n)/(S(4)*a*c*n*(a + c*x**(S(2)*n))**S(2)) + e**S(2)*x*hyper((S(2), S(1)/(S(2)*n)), (S(1) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(a**S(2)*c) - x*(S(2)*c*d*e*x**n*(-S(3)*n + S(1)) + (-S(4)*n + S(1))*(-a*e**S(2) + c*d**S(2)))/(S(8)*a**S(2)*c*n**S(2)*(a + c*x**(S(2)*n))) + x*(-a*e**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)) + c*d**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*c*n**S(2)) - x*(a*e**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)) - c*d**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*c*n**S(2)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + c*x**(S(2)*n))**S(3), x), x, x*(d + e*x**n)/(S(4)*a*n*(a + c*x**(S(2)*n))**S(2)) - x*(d*(-S(4)*n + S(1)) + e*x**n*(-S(3)*n + S(1)))/(S(8)*a**S(2)*n**S(2)*(a + c*x**(S(2)*n))) - x*(-sqrt(c)*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*sqrt(c)*n**S(2)) + x*(sqrt(c)*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*sqrt(c)*n**S(2)), expand=True, _diff=True, _numerical=True)

    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(3)*(d + e*x**n)), x), x, e**S(6)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(4)*x*(d - e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(4)*x*(d + e*sqrt(-a)/sqrt(c))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(2)*x*(d - e*x**n)/(S(2)*a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(2)) + c*x*(d - e*x**n)/(S(4)*a*n*(a + c*x**(S(2)*n))**S(2)*(a*e**S(2) + c*d**S(2))) - sqrt(c)*e**S(2)*x*(sqrt(c)*(-S(2)*d*n + d) + e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(2)) - sqrt(c)*e**S(2)*x*(sqrt(c)*d*(-S(2)*n + S(1)) - e*sqrt(-a)*(-n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(2)) - c*x*(d*(-S(4)*n + S(1)) - e*x**n*(-S(3)*n + S(1)))/(S(8)*a**S(2)*n**S(2)*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))) - sqrt(c)*x*(-sqrt(c)*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*n**S(2)*(a*e**S(2) + c*d**S(2))) + sqrt(c)*x*(sqrt(c)*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*n**S(2)*(a*e**S(2) + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(3)*(d + e*x**n)**S(2)), x), x, S(6)*c*e**S(6)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(a*e**S(2) + c*d**S(2))**S(4) + e**S(6)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) + c*d**S(2))**S(3)) + c*e**S(4)*x*(-a*e**S(2) - S(6)*sqrt(c)*d*e*sqrt(-a) + S(5)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(4)) + c*e**S(4)*x*(-a*e**S(2) + S(6)*sqrt(c)*d*e*sqrt(-a) + S(5)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(4)) + c*e**S(2)*x*(-a*e**S(2) + S(3)*c*d**S(2) - S(4)*c*d*e*x**n)/(S(2)*a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(3)) + c*x*(-a*e**S(2) + c*d**S(2) - S(2)*c*d*e*x**n)/(S(4)*a*n*(a + c*x**(S(2)*n))**S(2)*(a*e**S(2) + c*d**S(2))**S(2)) - c*e**S(2)*x*(-a*e**S(2)*(-S(2)*n + S(1)) - S(4)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + S(3)*c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(3)) - c*e**S(2)*x*(-a*e**S(2)*(-S(2)*n + S(1)) + S(4)*sqrt(c)*d*e*sqrt(-a)*(-n + S(1)) + S(3)*c*d**S(2)*(-S(2)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(4)*a**S(2)*n*(a*e**S(2) + c*d**S(2))**S(3)) - c*x*(-S(2)*c*d*e*x**n*(-S(3)*n + S(1)) + (-S(4)*n + S(1))*(-a*e**S(2) + c*d**S(2)))/(S(8)*a**S(2)*n**S(2)*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(2)) + c*x*(-a*e**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)) + c*d**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*n**S(2)*(a*e**S(2) + c*d**S(2))**S(2)) - c*x*(a*e**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*sqrt(c)*d*e*sqrt(-a)*(S(3)*n**S(2) - S(4)*n + S(1)) - c*d**S(2)*(S(8)*n**S(2) - S(6)*n + S(1)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*a**S(3)*n**S(2)*(a*e**S(2) + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((a + c*x**(S(2)*n))**S(3)*(d + e*x**n)**S(3)), x), x, S(3)*c**(S(3)/2)*e**S(4)*x*(-a*e**S(3) - sqrt(c)*d*(-S(3)*a*e**S(2) + S(5)*c*d**S(2))/sqrt(-a) + S(7)*c*d**S(2)*e)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*sqrt(-a)*(a*e**S(2) + c*d**S(2))**S(5)) - c**(S(3)/2)*e**S(2)*x*(S(3)*sqrt(c)*(-S(2)*n + S(1))*(-a*d*e**S(2) + c*d**S(3))/sqrt(-a) - (-n + S(1))*(-a*e**S(3) + S(5)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(2)*n*(-a)**(S(3)/2)*(a*e**S(2) + c*d**S(2))**S(4)) - c**(S(3)/2)*e**S(2)*x*(S(3)*sqrt(c)*(-S(2)*n + S(1))*(-a*d*e**S(2) + c*d**S(3))/sqrt(-a) + (-n + S(1))*(-a*e**S(3) + S(5)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*n*(-a)**(S(3)/2)*(a*e**S(2) + c*d**S(2))**S(4)) - c**(S(3)/2)*x*(sqrt(c)*(-S(4)*n + S(1))*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) - (-S(3)*n + S(1))*(-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), sqrt(c)*x**n/sqrt(-a))/(S(16)*n**S(2)*(-a)**(S(5)/2)*(a*e**S(2) + c*d**S(2))**S(3)) - c**(S(3)/2)*x*(sqrt(c)*(-S(4)*n + S(1))*(-S(2)*n + S(1))*(-S(3)*a*d*e**S(2) + c*d**S(3))/sqrt(-a) + (-S(3)*n + S(1))*(-n + S(1))*(-a*e**S(3) + S(3)*c*d**S(2)*e))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(16)*n**S(2)*(-a)**(S(5)/2)*(a*e**S(2) + c*d**S(2))**S(3)) + S(3)*c*e**S(6)*x*(-a*e**S(2) + S(7)*c*d**S(2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(5)) + S(6)*c*e**S(6)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) + c*d**S(2))**S(4)) + e**S(6)*x*hyper((S(3), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(3)*(a*e**S(2) + c*d**S(2))**S(3)) + S(3)*c**(S(3)/2)*e**S(4)*x*(-S(3)*a*sqrt(c)*d*e**S(2) + S(5)*c**(S(3)/2)*d**S(3) + S(7)*c*d**S(2)*e*sqrt(-a) + e**S(3)*(-a)**(S(3)/2))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -sqrt(c)*x**n/sqrt(-a))/(S(2)*a*(a*e**S(2) + c*d**S(2))**S(5)) + c**S(2)*e**S(2)*x*(S(3)*d*(-a*e**S(2) + c*d**S(2)) - e*x**n*(-a*e**S(2) + S(5)*c*d**S(2)))/(a*n*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(4)) + c**S(2)*x*(d*(-S(3)*a*e**S(2) + c*d**S(2)) - e*x**n*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(4)*a*n*(a + c*x**(S(2)*n))**S(2)*(a*e**S(2) + c*d**S(2))**S(3)) - c**S(2)*x*(d*(-S(4)*n + S(1))*(-S(3)*a*e**S(2) + c*d**S(2)) - e*x**n*(-S(3)*n + S(1))*(-a*e**S(2) + S(3)*c*d**S(2)))/(S(8)*a**S(2)*n**S(2)*(a + c*x**(S(2)*n))*(a*e**S(2) + c*d**S(2))**S(3)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p*(d + e*x**n)**S(3), x), x, d**S(3)*x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(1)/(S(2)*n), -p), (S(1) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a) + S(3)*d**S(2)*e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper(((n + S(1))/(S(2)*n), -p), (S(3)/2 + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(n + S(1)) + S(3)*d*e**S(2)*x**(S(2)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(1) + S(1)/(S(2)*n), -p), (S(2) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(S(2)*n + S(1)) + e**S(3)*x**(S(3)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(3)/2 + S(1)/(S(2)*n), -p), (S(5)/2 + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(S(3)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p*(d + e*x**n)**S(2), x), x, d**S(2)*x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(1)/(S(2)*n), -p), (S(1) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a) + S(2)*d*e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper(((n + S(1))/(S(2)*n), -p), (S(3)/2 + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(n + S(1)) + e**S(2)*x**(S(2)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(1) + S(1)/(S(2)*n), -p), (S(2) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(S(2)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p*(d + e*x**n), x), x, d*x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper((S(1)/(S(2)*n), -p), (S(1) + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a) + e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*hyper(((n + S(1))/(S(2)*n), -p), (S(3)/2 + S(1)/(S(2)*n),), -c*x**(S(2)*n)/a)/(n + S(1)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n)), x), x, a*d*x + c*e*x**(S(3)*n + S(1))/(S(3)*n + S(1)) + x**(n + S(1))*(a*e + b*d)/(n + S(1)) + x**(S(2)*n + S(1))*(b*e + c*d)/(S(2)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, a**S(2)*d*x + a*x**(n + S(1))*(a*e + S(2)*b*d)/(n + S(1)) + c**S(2)*e*x**(S(5)*n + S(1))/(S(5)*n + S(1)) + c*x**(S(4)*n + S(1))*(S(2)*b*e + c*d)/(S(4)*n + S(1)) + x**(S(2)*n + S(1))*(S(2)*a*b*e + S(2)*a*c*d + b**S(2)*d)/(S(2)*n + S(1)) + x**(S(3)*n + S(1))*(S(2)*a*c*e + b**S(2)*e + S(2)*b*c*d)/(S(3)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, a**S(3)*d*x + a**S(2)*x**(n + S(1))*(a*e + S(3)*b*d)/(n + S(1)) + S(3)*a*x**(S(2)*n + S(1))*(a*b*e + a*c*d + b**S(2)*d)/(S(2)*n + S(1)) + c**S(3)*e*x**(S(7)*n + S(1))/(S(7)*n + S(1)) + c**S(2)*x**(S(6)*n + S(1))*(S(3)*b*e + c*d)/(S(6)*n + S(1)) + S(3)*c*x**(S(5)*n + S(1))*(a*c*e + b**S(2)*e + b*c*d)/(S(5)*n + S(1)) + x**(S(3)*n + S(1))*(S(3)*a**S(2)*c*e + S(3)*a*b**S(2)*e + S(6)*a*b*c*d + b**S(3)*d)/(S(3)*n + S(1)) + x**(S(4)*n + S(1))*(S(6)*a*b*c*e + S(3)*a*c**S(2)*d + b**S(3)*e + S(3)*b**S(2)*c*d)/(S(4)*n + S(1)), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + b*x**n + c*x**(S(2)*n)), x), x, e**S(3)*x**(n + S(1))/(c*(n + S(1))) + e**S(2)*x*(-b*e + S(3)*c*d)/c**S(2) + x*(-a*c*e**S(3) + b**S(2)*e**S(3) - S(3)*b*c*d*e**S(2) + S(3)*c**S(2)*d**S(2)*e - (-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + c**S(2)*d**S(2) - c*e*(S(3)*a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(c**S(2)*(b + sqrt(-S(4)*a*c + b**S(2)))) + x*(-a*c*e**S(3) + b**S(2)*e**S(3) - S(3)*b*c*d*e**S(2) + S(3)*c**S(2)*d**S(2)*e + (-b*e + S(2)*c*d)*(b**S(2)*e**S(2) + c**S(2)*d**S(2) - c*e*(S(3)*a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(c**S(2)*(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + b*x**n + c*x**(S(2)*n)), x), x, e**S(2)*x/c + x*(-b*e**S(2) + S(2)*c*d*e - (b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(c*(b + sqrt(-S(4)*a*c + b**S(2)))) + x*(-b*e**S(2) + S(2)*c*d*e + (b**S(2)*e**S(2) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(c*(b - sqrt(-S(4)*a*c + b**S(2)))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + b*x**n + c*x**(S(2)*n)), x), x, x*(e - (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(b + sqrt(-S(4)*a*c + b**S(2))) + x*(e + (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(b - sqrt(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)

    # Apart assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))), x), x, -c*x*(S(2)*c*d - e*(b + sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) - c*x*(e + (-b*e + S(2)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((b + sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) + e**S(2)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)**S(2)*(a + b*x**n + c*x**(S(2)*n))), x), x, -c*x*(b*e**S(2)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d - d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - c*x*(b*e**S(2)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + b*d + d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(2)*x*(-b*e + S(2)*c*d)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(2)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    # Apart assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)**S(3)*(a + b*x**n + c*x**(S(2)*n))), x), x, -c*x*(-b**S(2)*e**S(3)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(3)*d**S(3) - S(3)*c**S(2)*d*e*(S(2)*a*e + b*d - d*sqrt(-S(4)*a*c + b**S(2))) + c*e**S(2)*(S(3)*a*b*e - a*e*sqrt(-S(4)*a*c + b**S(2)) + S(3)*b**S(2)*d - S(3)*b*d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) - c*x*(-b**S(2)*e**S(3)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(2)*c**S(3)*d**S(3) - S(3)*c**S(2)*d*e*(S(2)*a*e + b*d + d*sqrt(-S(4)*a*c + b**S(2))) + c*e**S(2)*(a*e*sqrt(-S(4)*a*c + b**S(2)) + S(3)*b**S(2)*d + S(3)*b*(a*e + d*sqrt(-S(4)*a*c + b**S(2)))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**S(2)*x*(b**S(2)*e**S(2) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**S(2)*x*(-b*e + S(2)*c*d)*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(2)*x*hyper((S(3), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(3)*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, e**S(2)*x*(e - (-S(3)*b*e + S(6)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(c*(b + sqrt(-S(4)*a*c + b**S(2)))) + e**S(2)*x*(e + (-S(3)*b*e + S(6)*c*d)/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(c*(b - sqrt(-S(4)*a*c + b**S(2)))) + x*(-a*b*e*(a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*c*d*(-S(3)*a*e**S(2) + c*d**S(2)) + b**S(2)*c*d**S(3) - x**n*(a*b**S(2)*e**S(3) + S(2)*a*c*e*(-a*e**S(2) + S(3)*c*d**S(2)) - b*c*d*(S(3)*a*e**S(2) + c*d**S(2))))/(a*c*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))) + x*((-n + S(1))*(a*b**S(2)*e**S(3) + S(2)*a*c*e*(-a*e**S(2) + S(3)*c*d**S(2)) - b*c*d*(S(3)*a*e**S(2) + c*d**S(2))) - (-a*b**S(3)*e**S(3)*(-S(3)*n + S(1)) + S(2)*a*b*c*e*(a*e**S(2)*(-S(5)*n + S(2)) + S(3)*c*d**S(2)*n) + S(4)*a*c**S(2)*d*(-S(2)*n + S(1))*(-S(3)*a*e**S(2) + c*d**S(2)) + b**S(2)*c*d*(S(3)*a*e**S(2)*(-S(3)*n + S(1)) - c*d**S(2)*(-n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*c*n*(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) + x*((-n + S(1))*(a*b**S(2)*e**S(3) + S(2)*a*c*e*(-a*e**S(2) + S(3)*c*d**S(2)) - b*c*d*(S(3)*a*e**S(2) + c*d**S(2))) + (-a*b**S(3)*e**S(3)*(-S(3)*n + S(1)) + S(2)*a*b*c*e*(a*e**S(2)*(-S(5)*n + S(2)) + S(3)*c*d**S(2)*n) + S(4)*a*c**S(2)*d*(-S(2)*n + S(1))*(-S(3)*a*e**S(2) + c*d**S(2)) + b**S(2)*c*d*(S(3)*a*e**S(2)*(-S(3)*n + S(1)) - c*d**S(2)*(-n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*c*n*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, -S(2)*e**S(2)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2))) - S(2)*e**S(2)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2))) + x*(-S(2)*a*b*d*e - S(2)*a*(-a*e**S(2) + c*d**S(2)) + b**S(2)*d**S(2) + x**n*(a*b*e**S(2) - S(4)*a*c*d*e + b*c*d**S(2)))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))) - x*((-n + S(1))*(a*b*e**S(2) - S(4)*a*c*d*e + b*c*d**S(2)) + (S(4)*a*b*c*d*e*n + S(4)*a*c*(-S(2)*n + S(1))*(-a*e**S(2) + c*d**S(2)) + b**S(2)*(a*e**S(2)*(-S(3)*n + S(1)) - c*d**S(2)*(-n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))) - x*((-n + S(1))*(a*b*e**S(2) - S(4)*a*c*d*e + b*c*d**S(2)) - (S(4)*a*b*c*d*e*n + S(4)*a*c*(-S(2)*n + S(1))*(-a*e**S(2) + c*d**S(2)) + b**S(2)*(a*e**S(2)*(-S(3)*n + S(1)) - c*d**S(2)*(-n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + b*x**n + c*x**(S(2)*n))**S(2), x), x, -c*x*(S(2)*a*(c*d*(-S(4)*n + S(2)) - e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*d*(-n + S(1)) + b*(S(2)*a*e*n + d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) - c*x*(S(2)*a*(S(2)*c*d*(-S(2)*n + S(1)) + e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*(-d*n + d) - b*(-S(2)*a*e*n + d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))) + x*(-a*b*e - S(2)*a*c*d + b**S(2)*d + c*x**n*(-S(2)*a*e + b*d))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    #Apart assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))**S(2)), x), x, -c*e**S(2)*x*(S(2)*c*d - e*(b - sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - c*e**S(2)*x*(S(2)*c*d - e*(b + sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(4)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*x*(-S(2)*a*c*(S(2)*c*d*(-S(2)*n + S(1)) + e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(3)*e*(-n + S(1)) + b**S(2)*(-n + S(1))*(c*d + e*sqrt(-S(4)*a*c + b**S(2))) + b*c*(S(2)*a*e*(-S(3)*n + S(2)) - d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) - c*x*((-n + S(1))*(S(2)*a*c*e - b**S(2)*e + b*c*d) + (S(2)*a*b*c*e*(-S(3)*n + S(2)) - S(4)*a*c**S(2)*d*(-S(2)*n + S(1)) - b**S(3)*e*(-n + S(1)) + b**S(2)*c*d*(-n + S(1)))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))*(a*e**S(2) - b*d*e + c*d**S(2))) + x*(S(3)*a*b*c*e - S(2)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d + c*x**n*(S(2)*a*c*e - b**S(2)*e + b*c*d))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    #Apart  assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)**S(2)*(a + b*x**n + c*x**(S(2)*n))**S(2)), x), x, -S(2)*c*e**S(2)*x*(b*e**S(2)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d - S(2)*d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) - S(2)*c*e**S(2)*x*(b*e**S(2)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(3)*c**S(2)*d**S(2) - c*e*(a*e + S(3)*b*d + S(2)*d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + S(2)*e**S(4)*x*(-b*e + S(2)*c*d)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**S(4)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*x*(S(4)*a*c**S(2)*(-c*d**S(2)*(-S(2)*n + S(1)) + e*(a*e*(-S(2)*n + S(1)) - d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b**S(4)*e**S(2)*(-n + S(1)) - b**S(3)*e*(-n + S(1))*(S(2)*c*d + e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*c*(-c*d**S(2)*(-n + S(1)) + e*(a*e*(-S(7)*n + S(5)) - S(2)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b*c*(S(3)*a*e**S(2)*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)) + c*d*(S(4)*a*e*(-S(3)*n + S(2)) - d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*x*(S(4)*a*c**S(2)*(-c*d**S(2)*(-S(2)*n + S(1)) + e*(a*e*(-S(2)*n + S(1)) + d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b**S(4)*e**S(2)*(-n + S(1)) - b**S(3)*e*(-n + S(1))*(S(2)*c*d - e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*c*(-c*d**S(2)*(-n + S(1)) + e*(a*e*(-S(7)*n + S(5)) + S(2)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b*c*(-S(3)*a*e**S(2)*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)) + c*d*(S(4)*a*e*(-S(3)*n + S(2)) + d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - x*(-S(6)*a*b*c**S(2)*d*e + S(2)*a*c**S(2)*(-a*e**S(2) + c*d**S(2)) - b**S(4)*e**S(2) + S(2)*b**S(3)*c*d*e - b**S(2)*c*(-S(4)*a*e**S(2) + c*d**S(2)) + c*x**n*(-S(4)*a*c**S(2)*d*e - b**S(3)*e**S(2) + S(2)*b**S(2)*c*d*e - b*c*(-S(3)*a*e**S(2) + c*d**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)/(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, e**S(2)*x*(-S(2)*a*c*(S(6)*c*d*(-S(2)*n + S(1)) - e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(3)*e*(-n + S(1)) + b**S(2)*(-n + S(1))*(S(3)*c*d + e*sqrt(-S(4)*a*c + b**S(2))) + b*c*(S(2)*a*e*(-S(5)*n + S(2)) - S(3)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*c*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) + e**S(2)*x*(-S(2)*a*c*(S(6)*c*d*(-S(2)*n + S(1)) + e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(3)*e*(-n + S(1)) + b**S(2)*(-n + S(1))*(S(3)*c*d - e*sqrt(-S(4)*a*c + b**S(2))) + b*c*(S(2)*a*e*(-S(5)*n + S(2)) + S(3)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*c*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))) + x*(-a*b*e*(a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*c*d*(-S(3)*a*e**S(2) + c*d**S(2)) + b**S(2)*c*d**S(3) - x**n*(a*b**S(2)*e**S(3) + S(2)*a*c*e*(-a*e**S(2) + S(3)*c*d**S(2)) - b*c*d*(S(3)*a*e**S(2) + c*d**S(2))))/(S(2)*a*c*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)) + e**S(2)*x*(a*b*c*e - S(6)*a*c**S(2)*d - b**S(3)*e + S(3)*b**S(2)*c*d + c*x**n*(-S(2)*a*c*e - b**S(2)*e + S(3)*b*c*d))/(a*c**S(2)*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))) + x*((-n + S(1))*(S(4)*a**S(2)*c**S(2)*e*(-S(3)*n + S(1))*(-a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*b**S(4)*e**S(3)*n - a*b**S(2)*c*e*(-a*e**S(2)*(S(2)*n + S(1)) + S(3)*c*d**S(2)) - S(2)*a*b*c**S(2)*d*(S(3)*a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) + b**S(3)*c*d*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))) + (-S(4)*a**S(2)*b*c**S(2)*e*(a*e**S(2)*(S(19)*n**S(2) - S(11)*n + S(1)) + S(3)*c*d**S(2)*(-S(3)*n**S(2) - n + S(1))) - S(8)*a**S(2)*c**S(3)*d*(-S(3)*a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*a*b**S(5)*e**S(3)*n*(-n + S(1)) + a*b**S(3)*c*e*(a*e**S(2)*(S(30)*n**S(2) - S(19)*n + S(1)) + S(3)*c*d**S(2)*(-n + S(1))) + S(6)*a*b**S(2)*c**S(2)*d*(-a*e**S(2)*(S(15)*n**S(2) - S(10)*n + S(1)) + c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(4)*c*d*(-n + S(1))*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*c*n**S(2)*(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + x*((-n + S(1))*(S(4)*a**S(2)*c**S(2)*e*(-S(3)*n + S(1))*(-a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*b**S(4)*e**S(3)*n - a*b**S(2)*c*e*(-a*e**S(2)*(S(2)*n + S(1)) + S(3)*c*d**S(2)) - S(2)*a*b*c**S(2)*d*(S(3)*a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) + b**S(3)*c*d*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))) - (-S(4)*a**S(2)*b*c**S(2)*e*(a*e**S(2)*(S(19)*n**S(2) - S(11)*n + S(1)) + S(3)*c*d**S(2)*(-S(3)*n**S(2) - n + S(1))) - S(8)*a**S(2)*c**S(3)*d*(-S(3)*a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*a*b**S(5)*e**S(3)*n*(-n + S(1)) + a*b**S(3)*c*e*(a*e**S(2)*(S(30)*n**S(2) - S(19)*n + S(1)) + S(3)*c*d**S(2)*(-n + S(1))) + S(6)*a*b**S(2)*c**S(2)*d*(-a*e**S(2)*(S(15)*n**S(2) - S(10)*n + S(1)) + c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(4)*c*d*(-n + S(1))*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*c*n**S(2)*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - x*(S(2)*a**S(2)*b*c**S(2)*e*(-S(5)*a*e**S(2)*n + S(3)*c*d**S(2)*(-S(3)*n + S(2))) + S(4)*a**S(2)*c**S(3)*d*(-S(4)*n + S(1))*(-S(3)*a*e**S(2) + c*d**S(2)) - S(2)*a*b**S(5)*e**S(3)*n - S(3)*a*b**S(3)*c*e*(-S(3)*a*e**S(2)*n + c*d**S(2)) + a*b**S(2)*c**S(2)*d*(S(3)*a*e**S(2)*(-S(9)*n + S(1)) - S(5)*c*d**S(2)*(-S(3)*n + S(1))) + b**S(4)*c*d*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))) + c*x**n*(S(4)*a**S(2)*c**S(2)*e*(-S(3)*n + S(1))*(-a*e**S(2) + S(3)*c*d**S(2)) - S(2)*a*b**S(4)*e**S(3)*n - a*b**S(2)*c*e*(-a*e**S(2)*(S(2)*n + S(1)) + S(3)*c*d**S(2)) - S(2)*a*b*c**S(2)*d*(S(3)*a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) + b**S(3)*c*d*(S(6)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))))/(S(2)*a**S(2)*c**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(2)/(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, -e**S(2)*x*(S(4)*a*c*(-S(2)*n + S(1)) - b**S(2)*(-n + S(1)) + b*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) - e**S(2)*x*(S(4)*a*c*(-S(2)*n + S(1)) - b**S(2)*(-n + S(1)) - b*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))) + x*(-S(2)*a*b*d*e - S(2)*a*(-a*e**S(2) + c*d**S(2)) + b**S(2)*d**S(2) + x**n*(a*b*e**S(2) - S(4)*a*c*d*e + b*c*d**S(2)))/(S(2)*a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)) + e**S(2)*x*(-S(2)*a*c + b**S(2) + b*c*x**n)/(a*c*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))) - x*((-n + S(1))*(-S(8)*a**S(2)*c**S(2)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c*d*e + S(2)*a*b*c*(a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) - b**S(3)*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))) - (-S(8)*a**S(2)*b*c**S(2)*d*e*(-S(3)*n**S(2) - n + S(1)) - S(8)*a**S(2)*c**S(2)*(-a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*a*b**S(3)*c*d*e*(-n + S(1)) + S(2)*a*b**S(2)*c*(-a*e**S(2)*(S(15)*n**S(2) - S(10)*n + S(1)) + S(3)*c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(4)*(-n + S(1))*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) - x*((-n + S(1))*(-S(8)*a**S(2)*c**S(2)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c*d*e + S(2)*a*b*c*(a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) - b**S(3)*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))) + (-S(8)*a**S(2)*b*c**S(2)*d*e*(-S(3)*n**S(2) - n + S(1)) - S(8)*a**S(2)*c**S(2)*(-a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) + S(2)*a*b**S(3)*c*d*e*(-n + S(1)) + S(2)*a*b**S(2)*c*(-a*e**S(2)*(S(15)*n**S(2) - S(10)*n + S(1)) + S(3)*c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(4)*(-n + S(1))*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)) + x*(-S(4)*a**S(2)*b*c**S(2)*d*e*(-S(3)*n + S(2)) - S(4)*a**S(2)*c**S(2)*(-S(4)*n + S(1))*(-a*e**S(2) + c*d**S(2)) + S(2)*a*b**S(3)*c*d*e - a*b**S(2)*c*(a*e**S(2)*(-S(9)*n + S(1)) - S(5)*c*d**S(2)*(-S(3)*n + S(1))) - b**S(4)*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1))) + c*x**n*(-S(8)*a**S(2)*c**S(2)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c*d*e + S(2)*a*b*c*(a*e**S(2)*n + c*d**S(2)*(-S(7)*n + S(2))) - b**S(3)*(S(2)*a*e**S(2)*n + c*d**S(2)*(-S(2)*n + S(1)))))/(S(2)*a**S(2)*c*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + b*x**n + c*x**(S(2)*n))**S(3), x), x, x*(-a*b*e - S(2)*a*c*d + b**S(2)*d + c*x**n*(-S(2)*a*e + b*d))/(S(2)*a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)) - c*x*(-S(4)*a**S(2)*c*(-S(2)*c*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))*(S(3)*n**S(2) - S(4)*n + S(1))) + a*b**S(2)*(-n + S(1))*(-S(6)*c*d*(-S(3)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))) + S(2)*a*b*c*(S(2)*a*e*(-S(3)*n**S(2) - n + S(1)) + d*sqrt(-S(4)*a*c + b**S(2))*(S(7)*n**S(2) - S(9)*n + S(2))) + b**S(4)*d*(S(2)*n**S(2) - S(3)*n + S(1)) - b**S(3)*(-n + S(1))*(a*e + d*(-S(2)*n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) + c*x*(-S(4)*a**S(2)*c*(S(2)*c*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))*(S(3)*n**S(2) - S(4)*n + S(1))) + a*b**S(2)*(-n + S(1))*(S(6)*c*d*(-S(3)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))) - S(2)*a*b*c*(S(2)*a*e*(-S(3)*n**S(2) - n + S(1)) - d*sqrt(-S(4)*a*c + b**S(2))*(S(7)*n**S(2) - S(9)*n + S(2))) - b**S(4)*d*(S(2)*n**S(2) - S(3)*n + S(1)) + b**S(3)*(-n + S(1))*(a*e - d*(-S(2)*n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))) + x*(-S(2)*a**S(2)*b*c*e*(-S(3)*n + S(2)) - S(4)*a**S(2)*c**S(2)*d*(-S(4)*n + S(1)) + a*b**S(3)*e + S(5)*a*b**S(2)*c*d*(-S(3)*n + S(1)) - b**S(4)*d*(-S(2)*n + S(1)) + c*x**n*(-S(4)*a**S(2)*c*e*(-S(3)*n + S(1)) + a*b**S(2)*e + S(2)*a*b*c*d*(-S(7)*n + S(2)) - b**S(3)*d*(-S(2)*n + S(1))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)

    #Apart# assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))**S(3)), x), x, -c*e**S(4)*x*(S(2)*c*d - e*(b - sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) - c*e**S(4)*x*(S(2)*c*d - e*(b + sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + e**S(6)*x*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + c*e**S(2)*x*(-S(2)*a*c*(S(2)*c*d*(-S(2)*n + S(1)) + e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(3)*e*(-n + S(1)) + b**S(2)*(-n + S(1))*(c*d + e*sqrt(-S(4)*a*c + b**S(2))) + b*c*(S(2)*a*e*(-S(3)*n + S(2)) - d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*e**S(2)*x*(-S(2)*a*c*(S(2)*c*d*(-S(2)*n + S(1)) - e*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))) - b**S(3)*e*(-n + S(1)) + b**S(2)*(-n + S(1))*(c*d - e*sqrt(-S(4)*a*c + b**S(2))) + b*c*(S(2)*a*e*(-S(3)*n + S(2)) + d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + e**S(2)*x*(S(3)*a*b*c*e - S(2)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d + c*x**n*(S(2)*a*c*e - b**S(2)*e + b*c*d))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + x*(S(3)*a*b*c*e - S(2)*a*c**S(2)*d - b**S(3)*e + b**S(2)*c*d + c*x**n*(S(2)*a*c*e - b**S(2)*e + b*c*d))/(S(2)*a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))) - c*x*(-S(4)*a**S(2)*c**S(2)*(-S(2)*c*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))*(S(3)*n**S(2) - S(4)*n + S(1))) + a*b**S(2)*c*(-n + S(1))*(-S(6)*c*d*(-S(3)*n + S(1)) + e*(-S(14)*n + S(5))*sqrt(-S(4)*a*c + b**S(2))) - S(2)*a*b*c**S(2)*(S(2)*a*e*(S(13)*n**S(2) - S(13)*n + S(3)) + d*sqrt(-S(4)*a*c + b**S(2))*(S(7)*n**S(2) - S(9)*n + S(2))) - b**S(5)*e*(S(2)*n**S(2) - S(3)*n + S(1)) + b**S(4)*(c*d - e*sqrt(-S(4)*a*c + b**S(2)))*(S(2)*n**S(2) - S(3)*n + S(1)) + b**S(3)*c*(-n + S(1))*(a*e*(-S(18)*n + S(7)) + d*(-S(2)*n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))) + c*x*(-S(4)*a**S(2)*c**S(2)*(S(2)*c*d*(S(8)*n**S(2) - S(6)*n + S(1)) + e*sqrt(-S(4)*a*c + b**S(2))*(S(3)*n**S(2) - S(4)*n + S(1))) + a*b**S(2)*c*(-n + S(1))*(S(6)*c*d*(-S(3)*n + S(1)) + e*(-S(14)*n + S(5))*sqrt(-S(4)*a*c + b**S(2))) - S(2)*a*b*c**S(2)*(-S(2)*a*e*(S(13)*n**S(2) - S(13)*n + S(3)) + d*sqrt(-S(4)*a*c + b**S(2))*(S(7)*n**S(2) - S(9)*n + S(2))) + b**S(5)*e*(S(2)*n**S(2) - S(3)*n + S(1)) - b**S(4)*(c*d + e*sqrt(-S(4)*a*c + b**S(2)))*(S(2)*n**S(2) - S(3)*n + S(1)) - b**S(3)*c*(-n + S(1))*(a*e*(-S(18)*n + S(7)) - d*(-S(2)*n + S(1))*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(c*d**S(2) - e*(-a*e + b*d))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))) + x*(S(2)*a**S(2)*b*c**S(2)*e*(-S(11)*n + S(4)) - S(4)*a**S(2)*c**S(3)*d*(-S(4)*n + S(1)) - S(3)*a*b**S(3)*c*e*(-S(5)*n + S(2)) + S(5)*a*b**S(2)*c**S(2)*d*(-S(3)*n + S(1)) + b**S(5)*(-S(2)*e*n + e) - b**S(4)*c*d*(-S(2)*n + S(1)) - c*x**n*(-S(4)*a**S(2)*c**S(2)*e*(-S(3)*n + S(1)) + a*b**S(2)*c*e*(-S(14)*n + S(5)) - S(2)*a*b*c**S(2)*d*(-S(7)*n + S(2)) - b**S(4)*e*(-S(2)*n + S(1)) + b**S(3)*c*d*(-S(2)*n + S(1))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))), expand=True, _diff=True, _numerical=True)
    #Apart# assert rubi_test(rubi_integrate(S(1)/((d + e*x**n)**S(2)*(a + b*x**n + c*x**(S(2)*n))**S(3)), x), x, -c*e**S(4)*x*(S(3)*b*e**S(2)*(b - sqrt(-S(4)*a*c + b**S(2))) + S(10)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + S(5)*b*d - S(3)*d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(4)) - c*e**S(4)*x*(S(3)*b*e**S(2)*(b + sqrt(-S(4)*a*c + b**S(2))) + S(10)*c**S(2)*d**S(2) - S(2)*c*e*(a*e + S(5)*b*d + S(3)*d*sqrt(-S(4)*a*c + b**S(2))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/((-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(4)) + S(3)*e**S(6)*x*(-b*e + S(2)*c*d)*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d*(a*e**S(2) - b*d*e + c*d**S(2))**S(4)) + e**S(6)*x*hyper((S(2), S(1)/n), (S(1) + S(1)/n,), -e*x**n/d)/(d**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + c*e**S(2)*x*(S(4)*a*c**S(2)*(-S(3)*c*d**S(2)*(-S(2)*n + S(1)) + e*(a*e*(-S(2)*n + S(1)) - S(2)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + S(2)*b**S(4)*e**S(2)*(-n + S(1)) - b**S(3)*e*(-n + S(1))*(S(5)*c*d + S(2)*e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*c*(-S(3)*c*d**S(2)*(-n + S(1)) + e*(a*e*(-S(13)*n + S(9)) - S(5)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b*c*(S(5)*a*e**S(2)*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)) + c*d*(S(4)*a*e*(-S(8)*n + S(5)) - S(3)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) + b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) + c*e**S(2)*x*(S(4)*a*c**S(2)*(-S(3)*c*d**S(2)*(-S(2)*n + S(1)) + e*(a*e*(-S(2)*n + S(1)) + S(2)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + S(2)*b**S(4)*e**S(2)*(-n + S(1)) - b**S(3)*e*(-n + S(1))*(S(5)*c*d - S(2)*e*sqrt(-S(4)*a*c + b**S(2))) - b**S(2)*c*(-S(3)*c*d**S(2)*(-n + S(1)) + e*(a*e*(-S(13)*n + S(9)) + S(5)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))) + b*c*(-S(5)*a*e**S(2)*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)) + c*d*(S(4)*a*e*(-S(8)*n + S(5)) + S(3)*d*(-n + S(1))*sqrt(-S(4)*a*c + b**S(2)))))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(-S(4)*a*c + b**S(2) - b*sqrt(-S(4)*a*c + b**S(2)))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) - e**S(2)*x*(-S(14)*a*b*c**S(2)*d*e + S(2)*a*c**S(2)*(-a*e**S(2) + S(3)*c*d**S(2)) - S(2)*b**S(4)*e**S(2) + S(5)*b**S(3)*c*d*e - b**S(2)*c*(-S(7)*a*e**S(2) + S(3)*c*d**S(2)) + c*x**n*(-S(8)*a*c**S(2)*d*e - S(2)*b**S(3)*e**S(2) + S(5)*b**S(2)*c*d*e - b*c*(-S(5)*a*e**S(2) + S(3)*c*d**S(2))))/(a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))**S(3)) - x*(-S(6)*a*b*c**S(2)*d*e + S(2)*a*c**S(2)*(-a*e**S(2) + c*d**S(2)) - b**S(4)*e**S(2) + S(2)*b**S(3)*c*d*e - b**S(2)*c*(-S(4)*a*e**S(2) + c*d**S(2)) + c*x**n*(-S(4)*a*c**S(2)*d*e - b**S(3)*e**S(2) + S(2)*b**S(2)*c*d*e - b*c*(-S(3)*a*e**S(2) + c*d**S(2))))/(S(2)*a*n*(-S(4)*a*c + b**S(2))*(a + b*x**n + c*x**(S(2)*n))**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*x*((-n + S(1))*(-S(8)*a**S(2)*c**S(3)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c**S(2)*d*e*(-S(14)*n + S(5)) + S(2)*a*b*c**S(2)*(a*e**S(2)*(-S(13)*n + S(4)) - c*d**S(2)*(-S(7)*n + S(2))) + b**S(5)*e**S(2)*(-S(2)*n + S(1)) - S(2)*b**S(4)*c*d*e*(-S(2)*n + S(1)) - b**S(3)*c*(S(2)*a*e**S(2)*(-S(8)*n + S(3)) - c*d**S(2)*(-S(2)*n + S(1)))) + (S(8)*a**S(2)*b*c**S(3)*d*e*(S(13)*n**S(2) - S(13)*n + S(3)) - S(8)*a**S(2)*c**S(3)*(-a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) - S(2)*a*b**S(3)*c**S(2)*d*e*(S(18)*n**S(2) - S(25)*n + S(7)) + S(2)*a*b**S(2)*c**S(2)*(-a*e**S(2)*(S(35)*n**S(2) - S(38)*n + S(9)) + S(3)*c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(6)*e**S(2)*(S(2)*n**S(2) - S(3)*n + S(1)) + S(2)*b**S(5)*c*d*e*(S(2)*n**S(2) - S(3)*n + S(1)) + b**S(4)*c*(-n + S(1))*(S(4)*a*e**S(2)*(-S(5)*n + S(2)) - c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(b + sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) + c*x*((-n + S(1))*(-S(8)*a**S(2)*c**S(3)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c**S(2)*d*e*(-S(14)*n + S(5)) + S(2)*a*b*c**S(2)*(a*e**S(2)*(-S(13)*n + S(4)) - c*d**S(2)*(-S(7)*n + S(2))) + b**S(5)*e**S(2)*(-S(2)*n + S(1)) - S(2)*b**S(4)*c*d*e*(-S(2)*n + S(1)) - b**S(3)*c*(S(2)*a*e**S(2)*(-S(8)*n + S(3)) - c*d**S(2)*(-S(2)*n + S(1)))) - (S(8)*a**S(2)*b*c**S(3)*d*e*(S(13)*n**S(2) - S(13)*n + S(3)) - S(8)*a**S(2)*c**S(3)*(-a*e**S(2) + c*d**S(2))*(S(8)*n**S(2) - S(6)*n + S(1)) - S(2)*a*b**S(3)*c**S(2)*d*e*(S(18)*n**S(2) - S(25)*n + S(7)) + S(2)*a*b**S(2)*c**S(2)*(-a*e**S(2)*(S(35)*n**S(2) - S(38)*n + S(9)) + S(3)*c*d**S(2)*(S(3)*n**S(2) - S(4)*n + S(1))) - b**S(6)*e**S(2)*(S(2)*n**S(2) - S(3)*n + S(1)) + S(2)*b**S(5)*c*d*e*(S(2)*n**S(2) - S(3)*n + S(1)) + b**S(4)*c*(-n + S(1))*(S(4)*a*e**S(2)*(-S(5)*n + S(2)) - c*d**S(2)*(-S(2)*n + S(1))))/sqrt(-S(4)*a*c + b**S(2)))*hyper((S(1), S(1)/n), (S(1) + S(1)/n,), -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))))/(S(2)*a**S(2)*n**S(2)*(b - sqrt(-S(4)*a*c + b**S(2)))*(-S(4)*a*c + b**S(2))**S(2)*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)) - x*(-S(4)*a**S(2)*b*c**S(3)*d*e*(-S(11)*n + S(4)) + S(4)*a**S(2)*c**S(3)*(-S(4)*n + S(1))*(-a*e**S(2) + c*d**S(2)) + S(6)*a*b**S(3)*c**S(2)*d*e*(-S(5)*n + S(2)) + a*b**S(2)*c**S(2)*(a*e**S(2)*(-S(37)*n + S(13)) - S(5)*c*d**S(2)*(-S(3)*n + S(1))) + b**S(6)*e**S(2)*(-S(2)*n + S(1)) - S(2)*b**S(5)*c*d*e*(-S(2)*n + S(1)) - b**S(4)*c*(a*e**S(2)*(-S(17)*n + S(7)) - c*d**S(2)*(-S(2)*n + S(1))) + c*x**n*(-S(8)*a**S(2)*c**S(3)*d*e*(-S(3)*n + S(1)) + S(2)*a*b**S(2)*c**S(2)*d*e*(-S(14)*n + S(5)) + S(2)*a*b*c**S(2)*(a*e**S(2)*(-S(13)*n + S(4)) - c*d**S(2)*(-S(7)*n + S(2))) + b**S(5)*e**S(2)*(-S(2)*n + S(1)) - S(2)*b**S(4)*c*d*e*(-S(2)*n + S(1)) - b**S(3)*c*(S(2)*a*e**S(2)*(-S(8)*n + S(3)) - c*d**S(2)*(-S(2)*n + S(1)))))/(S(2)*a**S(2)*n**S(2)*(-S(4)*a*c + b**S(2))**S(2)*(a + b*x**n + c*x**(S(2)*n))*(a*e**S(2) - b*d*e + c*d**S(2))**S(2)), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p/(d + e*x**n), x), x, x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(1)/(S(2)*n), -p, S(1), S(1) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/d - e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1((n + S(1))/(S(2)*n), -p, S(1), S(3)/2 + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(2)*(n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p/(d + e*x**n)**S(2), x), x, x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(1)/(S(2)*n), -p, S(2), S(1) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/d**S(2) - S(2)*e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1((n + S(1))/(S(2)*n), -p, S(2), S(3)/2 + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(3)*(n + S(1))) + e**S(2)*x**(S(2)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(1) + S(1)/(S(2)*n), -p, S(2), S(2) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(4)*(S(2)*n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((a + c*x**(S(2)*n))**p/(d + e*x**n)**S(3), x), x, x*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(1)/(S(2)*n), -p, S(3), S(1) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/d**S(3) - S(3)*e*x**(n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1((n + S(1))/(S(2)*n), -p, S(3), S(3)/2 + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(4)*(n + S(1))) + S(3)*e**S(2)*x**(S(2)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(1) + S(1)/(S(2)*n), -p, S(3), S(2) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(5)*(S(2)*n + S(1))) - e**S(3)*x**(S(3)*n + S(1))*(S(1) + c*x**(S(2)*n)/a)**(-p)*(a + c*x**(S(2)*n))**p*AppellF1(S(3)/2 + S(1)/(S(2)*n), -p, S(3), S(5)/2 + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(6)*(S(3)*n + S(1))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate(S(1)/(sqrt(a + c*x**(S(2)*n))*(d + e*x**n)), x), x, x*sqrt(S(1) + c*x**(S(2)*n)/a)*AppellF1(S(1)/(S(2)*n), S(1)/2, S(1), S(1) + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d*sqrt(a + c*x**(S(2)*n))) - e*x**(n + S(1))*sqrt(S(1) + c*x**(S(2)*n)/a)*AppellF1((n + S(1))/(S(2)*n), S(1)/2, S(1), S(3)/2 + S(1)/(S(2)*n), -c*x**(S(2)*n)/a, e**S(2)*x**(S(2)*n)/d**S(2))/(d**S(2)*sqrt(a + c*x**(S(2)*n))*(n + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)*sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, d*x*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1)/n, S(-1)/2, S(-1)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))) + e*x**(n + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1) + S(1)/n, S(-1)/2, S(-1)/2, S(2) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((n + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)*(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, a*d*x*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1)/n, S(-3)/2, S(-3)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))) + a*e*x**(n + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))*AppellF1(S(1) + S(1)/n, S(-3)/2, S(-3)/2, S(2) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((n + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))), expand=True, _diff=True, _numerical=True)

    assert rubi_test(rubi_integrate((d + e*x**n)/sqrt(a + b*x**n + c*x**(S(2)*n)), x), x, d*x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/n, S(1)/2, S(1)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/sqrt(a + b*x**n + c*x**(S(2)*n)) + e*x**(n + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1) + S(1)/n, S(1)/2, S(1)/2, S(2) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/((n + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + b*x**n + c*x**(S(2)*n))**(S(3)/2), x), x, d*x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/n, S(3)/2, S(3)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*sqrt(a + b*x**n + c*x**(S(2)*n))) + e*x**(n + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1) + S(1)/n, S(3)/2, S(3)/2, S(2) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a*(n + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)/(a + b*x**n + c*x**(S(2)*n))**(S(5)/2), x), x, d*x*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1)/n, S(5)/2, S(5)/2, S(1) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a**S(2)*sqrt(a + b*x**n + c*x**(S(2)*n))) + e*x**(n + S(1))*sqrt(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))*sqrt(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))*AppellF1(S(1) + S(1)/n, S(5)/2, S(5)/2, S(2) + S(1)/n, -S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))), -S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))))/(a**S(2)*(n + S(1))*sqrt(a + b*x**n + c*x**(S(2)*n))), expand=True, _diff=True, _numerical=True)
    assert rubi_test(rubi_integrate((d + e*x**n)**S(3)*(a + b*x**n + c*x**(S(2)*n))**p, x), x, d**S(3)*x*(S(2)*c*x**n/(b - sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(S(2)*c*x**n/(b + sqrt(-S(4)*a*c + b**S(2))) + S(1))**(-p)*(a + b*x**n + c*x*