/**
 *  Copyright (c) 2017 Angelo ZERR.
 *
 *  This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Angelo Zerr <angelo.zerr@gmail.com> - Customize different line spacing of StyledText - Bug 522020
 */
package org.eclipse.swt.snippets;

/*
 * example snippet: line spacing provider in action
 *
 * For a list of all SWT example snippets see
 * http://www.eclipse.org/swt/snippets/
 *
 * @since 3.107
 */
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class Snippet369 {

	public static void main(String[] args) throws Exception {
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setText("Snippet 369");
		shell.setLayout(new FillLayout());
		shell.setText("Line spacing provider in action");

		StyledText text = new StyledText(shell, SWT.BORDER | SWT.V_SCROLL);
		text.setText("// Type your custom line spacing \n10\n5\nabcd\n20\nefgh");

		text.setLineSpacingProvider(lineIndex -> {
			String line = text.getLine(lineIndex).trim();
			try {
				return Integer.parseInt(line);
			} catch(NumberFormatException e) {
				return null;
			}
		});

		shell.pack();
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
}
