//------------------------------------------------------------------------------
// GB_mex_generic.h: testing _Generic methods
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, _(c) 2017-2020, All Rights Reserved.
// http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

//------------------------------------------------------------------------------

#ifndef GB_GENERIC_H
#define GB_GENERIC_H

#if GxB_STDC_VERSION >= 201112L

//------------------------------------------------------------------------------
// testing the _Generic versions
//------------------------------------------------------------------------------

// GrB_free:
#define GrB_Type_free_(...)                         GrB_free (__VA_ARGS__)
#define GrB_UnaryOp_free_(...)                      GrB_free (__VA_ARGS__)
#define GrB_BinaryOp_free_(...)                     GrB_free (__VA_ARGS__)
#define GxB_SelectOp_free_(...)                     GrB_free (__VA_ARGS__)
#define GrB_Monoid_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Semiring_free_(...)                     GrB_free (__VA_ARGS__)
#define GxB_Scalar_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Vector_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Matrix_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Descriptor_free_(...)                   GrB_free (__VA_ARGS__)

// GrB_Monoid_new:
#define GrB_Monoid_new_BOOL_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT8_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT16_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT32_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT64_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT8_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT16_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT32_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT64_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_FP32_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_FP64_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GxB_Monoid_new_FC32_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GxB_Monoid_new_FC64_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UDT_(...)                    GrB_Monoid_new (__VA_ARGS__)

// GxB_Monoid_terminal_new:
#define GxB_Monoid_terminal_new_BOOL_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT8_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT16_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT32_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT64_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT8_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT16_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT32_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT64_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP32_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP64_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC32_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC64_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UDT_(...)           GxB_Monoid_terminal_new (__VA_ARGS__)

// GxB_Scalar_setElement:
#define GxB_Scalar_setElement_BOOL_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_INT8_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_INT16_(...)           GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_INT32_(...)           GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_INT64_(...)           GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT8_(...)           GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT16_(...)          GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT32_(...)          GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT64_(...)          GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FP32_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FP64_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FC32_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FC64_(...)            GxB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_UDT_(...)             GxB_Scalar_setElement (__VA_ARGS__)

// GxB_Scalar_extractElement:
#define GxB_Scalar_extractElement_BOOL_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT8_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT16_(...)       GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT32_(...)       GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT64_(...)       GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT8_(...)       GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT16_(...)      GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT32_(...)      GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT64_(...)      GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FP32_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FP64_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC32_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC64_(...)        GxB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_UDT_(...)         GxB_Scalar_extractElement (__VA_ARGS__)

// GrB_Vector_build:
#define GrB_Vector_build_BOOL_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT8_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT16_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT32_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT64_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT8_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT16_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT32_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT64_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_FP32_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_FP64_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GxB_Vector_build_FC32_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GxB_Vector_build_FC64_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UDT_(...)                  GrB_Vector_build (__VA_ARGS__)

// GrB_Vector_setElement:
#define GrB_Vector_setElement_BOOL_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT8_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT16_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT32_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT64_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT8_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT16_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT32_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT64_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_FP32_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_FP64_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GxB_Vector_setElement_FC32_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GxB_Vector_setElement_FC64_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UDT_(...)             GrB_Vector_setElement (__VA_ARGS__)

// GrB_Vector_extractElement:
#define GrB_Vector_extractElement_BOOL_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT8_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT16_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT32_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT64_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT8_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT16_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT32_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT64_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_FP32_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_FP64_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GxB_Vector_extractElement_FC32_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GxB_Vector_extractElement_FC64_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UDT_(...)         GrB_Vector_extractElement (__VA_ARGS__)

// GrB_Vector_extractTuples:
#define GrB_Vector_extractTuples_BOOL_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT8_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT16_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT32_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT64_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT8_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT16_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT32_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT64_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP32_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP64_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC32_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC64_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UDT_(...)          GrB_Vector_extractTuples (__VA_ARGS__)

// GrB_Matrix_build:
#define GrB_Matrix_build_BOOL_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT8_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT16_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT32_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT64_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT8_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT16_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT32_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT64_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_FP32_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_FP64_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GxB_Matrix_build_FC32_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GxB_Matrix_build_FC64_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UDT_(...)                  GrB_Matrix_build (__VA_ARGS__)

// GrB_Matrix_setElement:
#define GrB_Matrix_setElement_BOOL_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT8_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT16_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT32_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT64_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT8_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT16_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT32_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT64_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_FP32_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_FP64_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GxB_Matrix_setElement_FC32_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GxB_Matrix_setElement_FC64_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UDT_(...)             GrB_Matrix_setElement (__VA_ARGS__)

// GrB_Matrix_extractElement:
#define GrB_Matrix_extractElement_BOOL_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT8_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT16_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT32_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT64_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT8_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT16_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT32_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT64_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP32_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP64_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC32_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC64_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UDT_(...)         GrB_Matrix_extractElement (__VA_ARGS__)

// GrB_Matrix_extractTuples:
#define GrB_Matrix_extractTuples_BOOL_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT8_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT16_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT32_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT64_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT8_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT16_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT32_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT64_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP32_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP64_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC32_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC64_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UDT_(...)          GrB_Matrix_extractTuples (__VA_ARGS__)

// GxB_set:
#define GxB_Global_Option_set_(...)                 GxB_set (__VA_ARGS__)
#define GxB_Matrix_Option_set_(...)                 GxB_set (__VA_ARGS__)
#define GrB_Descriptor_set_(...)                    GxB_set (__VA_ARGS__)
#define GxB_Desc_set_(...)                          GxB_set (__VA_ARGS__)

// GxB_get:
#define GxB_Global_Option_get_(...)                 GxB_get (__VA_ARGS__)
#define GxB_Matrix_Option_get_(...)                 GxB_get (__VA_ARGS__)
#define GxB_Descriptor_get_(...)                    GxB_get (__VA_ARGS__)
#define GxB_Desc_get_(...)                          GxB_get (__VA_ARGS__)

// GrB_wait (not yet available as _Generic):
#define GrB_Type_wait_(...)                         GrB_Type_wait (__VA_ARGS__)
#define GrB_UnaryOp_wait_(...)                      GrB_UnaryOp_wait (__VA_ARGS__)
#define GrB_BinaryOp_wait_(...)                     GrB_BinaryOp_wait (__VA_ARGS__)
#define GxB_SelectOp_wait_(...)                     GxB_SelectOp_wait (__VA_ARGS__)
#define GrB_Monoid_wait_(...)                       GrB_Monoid_wait (__VA_ARGS__)
#define GrB_Semiring_wait_(...)                     GrB_Semiring_wait (__VA_ARGS__)
#define GrB_Descriptor_wait_(...)                   GrB_Descriptor_wait (__VA_ARGS__)
#define GxB_Scalar_wait_(...)                       GxB_Scalar_wait (__VA_ARGS__)
#define GrB_Vector_wait_(...)                       GrB_Vector_wait (__VA_ARGS__)
#define GrB_Matrix_wait_(...)                       GrB_Matrix_wait (__VA_ARGS__)

// GrB_eWiseMult:
#define GrB_Vector_eWiseMult_Semiring_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Vector_eWiseMult_Monoid_(...)           GrB_eWiseMult (__VA_ARGS__)
#define GrB_Vector_eWiseMult_BinaryOp_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Semiring_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Monoid_(...)           GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_BinaryOp_(...)         GrB_eWiseMult (__VA_ARGS__)

// GrB_eWiseAdd:
#define GrB_Vector_eWiseAdd_Semiring_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_Monoid_(...)            GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_BinaryOp_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Semiring_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Monoid_(...)            GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_BinaryOp_(...)          GrB_eWiseAdd (__VA_ARGS__)

// GrB_extract:
#define GrB_Vector_extract_(...)                    GrB_extract (__VA_ARGS__)
#define GrB_Matrix_extract_(...)                    GrB_extract (__VA_ARGS__)
#define GrB_Col_extract_(...)                       GrB_extract (__VA_ARGS__)

// GxB_subassign:
#define GxB_Vector_subassign_(...)                  GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_(...)                  GxB_subassign (__VA_ARGS__)
#define GxB_Col_subassign_(...)                     GxB_subassign (__VA_ARGS__)
#define GxB_Row_subassign_(...)                     GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_BOOL_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT8_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT16_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT32_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT64_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT8_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT16_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT32_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT64_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FP32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FP64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FC32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FC64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UDT_(...)              GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_BOOL_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT8_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT16_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT32_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT64_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT8_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT16_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT32_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT64_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FP32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FP64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FC32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FC64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UDT_(...)              GxB_subassign (__VA_ARGS__)

// GrB_assign:
#define GrB_Vector_assign_(...)                     GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_(...)                     GrB_assign (__VA_ARGS__)
#define GrB_Col_assign_(...)                        GrB_assign (__VA_ARGS__)
#define GrB_Row_assign_(...)                        GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_BOOL_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT8_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT16_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT32_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT64_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT8_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT16_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT32_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT64_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_FP32_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_FP64_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Vector_assign_FC32_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Vector_assign_FC64_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UDT_(...)                 GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_BOOL_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT8_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT16_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT32_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT64_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT8_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT16_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT32_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT64_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_FP32_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_FP64_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Matrix_assign_FC32_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Matrix_assign_FC64_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UDT_(...)                 GrB_assign (__VA_ARGS__)

// GrB_apply:
#define GrB_Vector_apply_(...)                      GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_(...)                      GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UDT_(...)      GrB_apply (__VA_ARGS__)

// GxB_select:
#define GxB_Vector_select_(...)                     GxB_select (__VA_ARGS__)
#define GxB_Matrix_select_(...)                     GxB_select (__VA_ARGS__)

// GrB_reduce:
#define GrB_Matrix_reduce_Monoid_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_BinaryOp_(...)            GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_BOOL_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT8_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT16_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT32_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT64_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT8_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT16_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT32_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT64_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_FP32_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_FP64_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Vector_reduce_FC32_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Vector_reduce_FC64_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UDT_(...)                 GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_BOOL_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT8_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT16_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT32_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT64_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT8_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT16_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT32_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT64_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_FP32_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_FP64_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Matrix_reduce_FC32_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Matrix_reduce_FC64_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UDT_(...)                 GrB_reduce (__VA_ARGS__)

// GxB_resize:
#define GrB_Matrix_resize_(...)                     GxB_resize (__VA_ARGS__)
#define GrB_Vector_resize_(...)                     GxB_resize (__VA_ARGS__)

// GrB_kronecker:
#define GrB_Matrix_kronecker_BinaryOp_(...)         GrB_kronecker (__VA_ARGS__)
#define GrB_Matrix_kronecker_Monoid_(...)           GrB_kronecker (__VA_ARGS__)
#define GrB_Matrix_kronecker_Semiring_(...)         GrB_kronecker (__VA_ARGS__)

// GxB_fprint:
#define GxB_Type_fprint_(o,p,f)                     GxB_fprint (o,p,f)
#define GxB_UnaryOp_fprint_(o,p,f)                  GxB_fprint (o,p,f)
#define GxB_BinaryOp_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_SelectOp_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_Monoid_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Semiring_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_Descriptor_fprint_(o,p,f)               GxB_fprint (o,p,f)
#define GxB_Matrix_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Vector_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Scalar_fprint_(o,p,f)                   GxB_fprint (o,p,f)

#else

//------------------------------------------------------------------------------
// testing the non-polymorphic versions
//------------------------------------------------------------------------------

// GrB_free:
#define GrB_Type_free_(...)                         GrB_Type_free (__VA_ARGS__)
#define GrB_UnaryOp_free_(...)                      GrB_UnaryOp_free (__VA_ARGS__)
#define GrB_BinaryOp_free_(...)                     GrB_BinaryOp_free (__VA_ARGS__)
#define GxB_SelectOp_free_(...)                     GxB_SelectOp_free (__VA_ARGS__)
#define GrB_Monoid_free_(...)                       GrB_Monoid_free (__VA_ARGS__)
#define GrB_Semiring_free_(...)                     GrB_Semiring_free (__VA_ARGS__)
#define GxB_Scalar_free_(...)                       GxB_Scalar_free (__VA_ARGS__)
#define GrB_Vector_free_(...)                       GrB_Vector_free (__VA_ARGS__)
#define GrB_Matrix_free_(...)                       GrB_Matrix_free (__VA_ARGS__)
#define GrB_Descriptor_free_(...)                   GrB_Descriptor_free (__VA_ARGS__)

// GrB_Monoid_new:
#define GrB_Monoid_new_BOOL_(...)                   GrB_Monoid_new_BOOL (__VA_ARGS__)
#define GrB_Monoid_new_INT8_(...)                   GrB_Monoid_new_INT8 (__VA_ARGS__)
#define GrB_Monoid_new_INT16_(...)                  GrB_Monoid_new_INT16 (__VA_ARGS__)
#define GrB_Monoid_new_INT32_(...)                  GrB_Monoid_new_INT32 (__VA_ARGS__)
#define GrB_Monoid_new_INT64_(...)                  GrB_Monoid_new_INT64 (__VA_ARGS__)
#define GrB_Monoid_new_UINT8_(...)                  GrB_Monoid_new_UINT8 (__VA_ARGS__)
#define GrB_Monoid_new_UINT16_(...)                 GrB_Monoid_new_UINT16 (__VA_ARGS__)
#define GrB_Monoid_new_UINT32_(...)                 GrB_Monoid_new_UINT32 (__VA_ARGS__)
#define GrB_Monoid_new_UINT64_(...)                 GrB_Monoid_new_UINT64 (__VA_ARGS__)
#define GrB_Monoid_new_FP32_(...)                   GrB_Monoid_new_FP32 (__VA_ARGS__)
#define GrB_Monoid_new_FP64_(...)                   GrB_Monoid_new_FP64 (__VA_ARGS__)
#define GxB_Monoid_new_FC32_(...)                   GxB_Monoid_new_FC32 (__VA_ARGS__)
#define GxB_Monoid_new_FC64_(...)                   GxB_Monoid_new_FC64 (__VA_ARGS__)
#define GrB_Monoid_new_UDT_(...)                    GrB_Monoid_new_UDT (__VA_ARGS__)

// GxB_Monoid_terminal_new:
#define GxB_Monoid_terminal_new_BOOL_(...)          GxB_Monoid_terminal_new_BOOL (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT8_(...)          GxB_Monoid_terminal_new_INT8 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT16_(...)         GxB_Monoid_terminal_new_INT16 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT32_(...)         GxB_Monoid_terminal_new_INT32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT64_(...)         GxB_Monoid_terminal_new_INT64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT8_(...)         GxB_Monoid_terminal_new_UINT8 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT16_(...)        GxB_Monoid_terminal_new_UINT16 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT32_(...)        GxB_Monoid_terminal_new_UINT32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT64_(...)        GxB_Monoid_terminal_new_UINT64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP32_(...)          GxB_Monoid_terminal_new_FP32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP64_(...)          GxB_Monoid_terminal_new_FP64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC32_(...)          GxB_Monoid_terminal_new_FC32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC64_(...)          GxB_Monoid_terminal_new_FC64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UDT_(...)           GxB_Monoid_terminal_new_UDT (__VA_ARGS__)

// GxB_Scalar_setElement:
#define GxB_Scalar_setElement_BOOL_(...)            GxB_Scalar_setElement_BOOL (__VA_ARGS__)
#define GxB_Scalar_setElement_INT8_(...)            GxB_Scalar_setElement_INT8 (__VA_ARGS__)
#define GxB_Scalar_setElement_INT16_(...)           GxB_Scalar_setElement_INT16 (__VA_ARGS__)
#define GxB_Scalar_setElement_INT32_(...)           GxB_Scalar_setElement_INT32 (__VA_ARGS__)
#define GxB_Scalar_setElement_INT64_(...)           GxB_Scalar_setElement_INT64 (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT8_(...)           GxB_Scalar_setElement_UINT8 (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT16_(...)          GxB_Scalar_setElement_UINT16 (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT32_(...)          GxB_Scalar_setElement_UINT32 (__VA_ARGS__)
#define GxB_Scalar_setElement_UINT64_(...)          GxB_Scalar_setElement_UINT64 (__VA_ARGS__)
#define GxB_Scalar_setElement_FP32_(...)            GxB_Scalar_setElement_FP32 (__VA_ARGS__)
#define GxB_Scalar_setElement_FP64_(...)            GxB_Scalar_setElement_FP64 (__VA_ARGS__)
#define GxB_Scalar_setElement_FC32_(...)            GxB_Scalar_setElement_FC32 (__VA_ARGS__)
#define GxB_Scalar_setElement_FC64_(...)            GxB_Scalar_setElement_FC64 (__VA_ARGS__)
#define GxB_Scalar_setElement_UDT_(...)             GxB_Scalar_setElement_UDT (__VA_ARGS__)

// GxB_Scalar_extractElement:
#define GxB_Scalar_extractElement_BOOL_(...)        GxB_Scalar_extractElement_BOOL (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT8_(...)        GxB_Scalar_extractElement_INT8 (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT16_(...)       GxB_Scalar_extractElement_INT16 (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT32_(...)       GxB_Scalar_extractElement_INT32 (__VA_ARGS__)
#define GxB_Scalar_extractElement_INT64_(...)       GxB_Scalar_extractElement_INT64 (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT8_(...)       GxB_Scalar_extractElement_UINT8 (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT16_(...)      GxB_Scalar_extractElement_UINT16 (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT32_(...)      GxB_Scalar_extractElement_UINT32 (__VA_ARGS__)
#define GxB_Scalar_extractElement_UINT64_(...)      GxB_Scalar_extractElement_UINT64 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FP32_(...)        GxB_Scalar_extractElement_FP32 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FP64_(...)        GxB_Scalar_extractElement_FP64 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC32_(...)        GxB_Scalar_extractElement_FC32 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC64_(...)        GxB_Scalar_extractElement_FC64 (__VA_ARGS__)
#define GxB_Scalar_extractElement_UDT_(...)         GxB_Scalar_extractElement_UDT (__VA_ARGS__)

// GrB_Vector_build:
#define GrB_Vector_build_BOOL_(...)                 GrB_Vector_build_BOOL (__VA_ARGS__)
#define GrB_Vector_build_INT8_(...)                 GrB_Vector_build_INT8 (__VA_ARGS__)
#define GrB_Vector_build_INT16_(...)                GrB_Vector_build_INT16 (__VA_ARGS__)
#define GrB_Vector_build_INT32_(...)                GrB_Vector_build_INT32 (__VA_ARGS__)
#define GrB_Vector_build_INT64_(...)                GrB_Vector_build_INT64 (__VA_ARGS__)
#define GrB_Vector_build_UINT8_(...)                GrB_Vector_build_UINT8 (__VA_ARGS__)
#define GrB_Vector_build_UINT16_(...)               GrB_Vector_build_UINT16 (__VA_ARGS__)
#define GrB_Vector_build_UINT32_(...)               GrB_Vector_build_UINT32 (__VA_ARGS__)
#define GrB_Vector_build_UINT64_(...)               GrB_Vector_build_UINT64 (__VA_ARGS__)
#define GrB_Vector_build_FP32_(...)                 GrB_Vector_build_FP32 (__VA_ARGS__)
#define GrB_Vector_build_FP64_(...)                 GrB_Vector_build_FP64 (__VA_ARGS__)
#define GxB_Vector_build_FC32_(...)                 GxB_Vector_build_FC32 (__VA_ARGS__)
#define GxB_Vector_build_FC64_(...)                 GxB_Vector_build_FC64 (__VA_ARGS__)
#define GrB_Vector_build_UDT_(...)                  GrB_Vector_build_UDT (__VA_ARGS__)

// GrB_Vector_setElement:
#define GrB_Vector_setElement_BOOL_(...)            GrB_Vector_setElement_BOOL (__VA_ARGS__)
#define GrB_Vector_setElement_INT8_(...)            GrB_Vector_setElement_INT8 (__VA_ARGS__)
#define GrB_Vector_setElement_INT16_(...)           GrB_Vector_setElement_INT16 (__VA_ARGS__)
#define GrB_Vector_setElement_INT32_(...)           GrB_Vector_setElement_INT32 (__VA_ARGS__)
#define GrB_Vector_setElement_INT64_(...)           GrB_Vector_setElement_INT64 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT8_(...)           GrB_Vector_setElement_UINT8 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT16_(...)          GrB_Vector_setElement_UINT16 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT32_(...)          GrB_Vector_setElement_UINT32 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT64_(...)          GrB_Vector_setElement_UINT64 (__VA_ARGS__)
#define GrB_Vector_setElement_FP32_(...)            GrB_Vector_setElement_FP32 (__VA_ARGS__)
#define GrB_Vector_setElement_FP64_(...)            GrB_Vector_setElement_FP64 (__VA_ARGS__)
#define GxB_Vector_setElement_FC32_(...)            GxB_Vector_setElement_FC32 (__VA_ARGS__)
#define GxB_Vector_setElement_FC64_(...)            GxB_Vector_setElement_FC64 (__VA_ARGS__)
#define GrB_Vector_setElement_UDT_(...)             GrB_Vector_setElement_UDT (__VA_ARGS__)

// GrB_Vector_extractElement:
#define GrB_Vector_extractElement_BOOL_(...)        GrB_Vector_extractElement_BOOL (__VA_ARGS__)
#define GrB_Vector_extractElement_INT8_(...)        GrB_Vector_extractElement_INT8 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT16_(...)       GrB_Vector_extractElement_INT16 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT32_(...)       GrB_Vector_extractElement_INT32 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT64_(...)       GrB_Vector_extractElement_INT64 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT8_(...)       GrB_Vector_extractElement_UINT8 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT16_(...)      GrB_Vector_extractElement_UINT16 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT32_(...)      GrB_Vector_extractElement_UINT32 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT64_(...)      GrB_Vector_extractElement_UINT64 (__VA_ARGS__)
#define GrB_Vector_extractElement_FP32_(...)        GrB_Vector_extractElement_FP32 (__VA_ARGS__)
#define GrB_Vector_extractElement_FP64_(...)        GrB_Vector_extractElement_FP64 (__VA_ARGS__)
#define GxB_Vector_extractElement_FC32_(...)        GxB_Vector_extractElement_FC32 (__VA_ARGS__)
#define GxB_Vector_extractElement_FC64_(...)        GxB_Vector_extractElement_FC64 (__VA_ARGS__)
#define GrB_Vector_extractElement_UDT_(...)         GrB_Vector_extractElement_UDT (__VA_ARGS__)

// GrB_Vector_extractTuples:
#define GrB_Vector_extractTuples_BOOL_(...)         GrB_Vector_extractTuples_BOOL (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT8_(...)         GrB_Vector_extractTuples_INT8 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT16_(...)        GrB_Vector_extractTuples_INT16 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT32_(...)        GrB_Vector_extractTuples_INT32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT64_(...)        GrB_Vector_extractTuples_INT64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT8_(...)        GrB_Vector_extractTuples_UINT8 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT16_(...)       GrB_Vector_extractTuples_UINT16 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT32_(...)       GrB_Vector_extractTuples_UINT32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT64_(...)       GrB_Vector_extractTuples_UINT64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP32_(...)         GrB_Vector_extractTuples_FP32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP64_(...)         GrB_Vector_extractTuples_FP64 (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC32_(...)         GxB_Vector_extractTuples_FC32 (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC64_(...)         GxB_Vector_extractTuples_FC64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UDT_(...)          GrB_Vector_extractTuples_UDT (__VA_ARGS__)

// GrB_Matrix_build:
#define GrB_Matrix_build_BOOL_(...)                 GrB_Matrix_build_BOOL (__VA_ARGS__)
#define GrB_Matrix_build_INT8_(...)                 GrB_Matrix_build_INT8 (__VA_ARGS__)
#define GrB_Matrix_build_INT16_(...)                GrB_Matrix_build_INT16 (__VA_ARGS__)
#define GrB_Matrix_build_INT32_(...)                GrB_Matrix_build_INT32 (__VA_ARGS__)
#define GrB_Matrix_build_INT64_(...)                GrB_Matrix_build_INT64 (__VA_ARGS__)
#define GrB_Matrix_build_UINT8_(...)                GrB_Matrix_build_UINT8 (__VA_ARGS__)
#define GrB_Matrix_build_UINT16_(...)               GrB_Matrix_build_UINT16 (__VA_ARGS__)
#define GrB_Matrix_build_UINT32_(...)               GrB_Matrix_build_UINT32 (__VA_ARGS__)
#define GrB_Matrix_build_UINT64_(...)               GrB_Matrix_build_UINT64 (__VA_ARGS__)
#define GrB_Matrix_build_FP32_(...)                 GrB_Matrix_build_FP32 (__VA_ARGS__)
#define GrB_Matrix_build_FP64_(...)                 GrB_Matrix_build_FP64 (__VA_ARGS__)
#define GxB_Matrix_build_FC32_(...)                 GxB_Matrix_build_FC32 (__VA_ARGS__)
#define GxB_Matrix_build_FC64_(...)                 GxB_Matrix_build_FC64 (__VA_ARGS__)
#define GrB_Matrix_build_UDT_(...)                  GrB_Matrix_build_UDT (__VA_ARGS__)

// GrB_Matrix_setElement:
#define GrB_Matrix_setElement_BOOL_(...)            GrB_Matrix_setElement_BOOL (__VA_ARGS__)
#define GrB_Matrix_setElement_INT8_(...)            GrB_Matrix_setElement_INT8 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT16_(...)           GrB_Matrix_setElement_INT16 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT32_(...)           GrB_Matrix_setElement_INT32 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT64_(...)           GrB_Matrix_setElement_INT64 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT8_(...)           GrB_Matrix_setElement_UINT8 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT16_(...)          GrB_Matrix_setElement_UINT16 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT32_(...)          GrB_Matrix_setElement_UINT32 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT64_(...)          GrB_Matrix_setElement_UINT64 (__VA_ARGS__)
#define GrB_Matrix_setElement_FP32_(...)            GrB_Matrix_setElement_FP32 (__VA_ARGS__)
#define GrB_Matrix_setElement_FP64_(...)            GrB_Matrix_setElement_FP64 (__VA_ARGS__)
#define GxB_Matrix_setElement_FC32_(...)            GxB_Matrix_setElement_FC32 (__VA_ARGS__)
#define GxB_Matrix_setElement_FC64_(...)            GxB_Matrix_setElement_FC64 (__VA_ARGS__)
#define GrB_Matrix_setElement_UDT_(...)             GrB_Matrix_setElement_UDT (__VA_ARGS__)

// GrB_Matrix_extractElement:
#define GrB_Matrix_extractElement_BOOL_(...)        GrB_Matrix_extractElement_BOOL (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT8_(...)        GrB_Matrix_extractElement_INT8 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT16_(...)       GrB_Matrix_extractElement_INT16 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT32_(...)       GrB_Matrix_extractElement_INT32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT64_(...)       GrB_Matrix_extractElement_INT64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT8_(...)       GrB_Matrix_extractElement_UINT8 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT16_(...)      GrB_Matrix_extractElement_UINT16 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT32_(...)      GrB_Matrix_extractElement_UINT32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT64_(...)      GrB_Matrix_extractElement_UINT64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP32_(...)        GrB_Matrix_extractElement_FP32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP64_(...)        GrB_Matrix_extractElement_FP64 (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC32_(...)        GxB_Matrix_extractElement_FC32 (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC64_(...)        GxB_Matrix_extractElement_FC64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UDT_(...)         GrB_Matrix_extractElement_UDT (__VA_ARGS__)

// GrB_Matrix_extractTuples:
#define GrB_Matrix_extractTuples_BOOL_(...)         GrB_Matrix_extractTuples_BOOL (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT8_(...)         GrB_Matrix_extractTuples_INT8 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT16_(...)        GrB_Matrix_extractTuples_INT16 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT32_(...)        GrB_Matrix_extractTuples_INT32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT64_(...)        GrB_Matrix_extractTuples_INT64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT8_(...)        GrB_Matrix_extractTuples_UINT8 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT16_(...)       GrB_Matrix_extractTuples_UINT16 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT32_(...)       GrB_Matrix_extractTuples_UINT32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT64_(...)       GrB_Matrix_extractTuples_UINT64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP32_(...)         GrB_Matrix_extractTuples_FP32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP64_(...)         GrB_Matrix_extractTuples_FP64 (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC32_(...)         GxB_Matrix_extractTuples_FC32 (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC64_(...)         GxB_Matrix_extractTuples_FC64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UDT_(...)          GrB_Matrix_extractTuples_UDT (__VA_ARGS__)

// GxB_Desc_set:
#define GxB_Global_Option_set_(...)                 GxB_Global_Option_set (__VA_ARGS__)
#define GxB_Matrix_Option_set_(...)                 GxB_Matrix_Option_set (__VA_ARGS__)
#define GrB_Descriptor_set_(...)                    GrB_Descriptor_set (__VA_ARGS__)

// GxB_Desc_get:
#define GxB_Global_Option_get_(...)                 GxB_Global_Option_get (__VA_ARGS__)
#define GxB_Matrix_Option_get_(...)                 GxB_Matrix_Option_get (__VA_ARGS__)
#define GxB_Descriptor_get_(...)                    GxB_Descriptor_get (__VA_ARGS__)

// GrB_wait:
#define GrB_Type_wait_(...)                         GrB_Type_wait (__VA_ARGS__)
#define GrB_UnaryOp_wait_(...)                      GrB_UnaryOp_wait (__VA_ARGS__)
#define GrB_BinaryOp_wait_(...)                     GrB_BinaryOp_wait (__VA_ARGS__)
#define GxB_SelectOp_wait_(...)                     GxB_SelectOp_wait (__VA_ARGS__)
#define GrB_Monoid_wait_(...)                       GrB_Monoid_wait (__VA_ARGS__)
#define GrB_Semiring_wait_(...)                     GrB_Semiring_wait (__VA_ARGS__)
#define GrB_Descriptor_wait_(...)                   GrB_Descriptor_wait (__VA_ARGS__)
#define GxB_Scalar_wait_(...)                       GxB_Scalar_wait (__VA_ARGS__)
#define GrB_Vector_wait_(...)                       GrB_Vector_wait (__VA_ARGS__)
#define GrB_Matrix_wait_(...)                       GrB_Matrix_wait (__VA_ARGS__)

// GrB_eWiseMult:
#define GrB_Vector_eWiseMult_Semiring_(...)         GrB_Vector_eWiseMult_Semiring (__VA_ARGS__)
#define GrB_Vector_eWiseMult_Monoid_(...)           GrB_Vector_eWiseMult_Monoid (__VA_ARGS__)
#define GrB_Vector_eWiseMult_BinaryOp_(...)         GrB_Vector_eWiseMult_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Semiring_(...)         GrB_Matrix_eWiseMult_Semiring (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Monoid_(...)           GrB_Matrix_eWiseMult_Monoid (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_BinaryOp_(...)         GrB_Matrix_eWiseMult_BinaryOp (__VA_ARGS__)

// GrB_eWiseAdd:
#define GrB_Vector_eWiseAdd_Semiring_(...)          GrB_Vector_eWiseAdd_Semiring (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_Monoid_(...)            GrB_Vector_eWiseAdd_Monoid (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_BinaryOp_(...)          GrB_Vector_eWiseAdd_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Semiring_(...)          GrB_Matrix_eWiseAdd_Semiring (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Monoid_(...)            GrB_Matrix_eWiseAdd_Monoid (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_BinaryOp_(...)          GrB_Matrix_eWiseAdd_BinaryOp (__VA_ARGS__)

// GrB_extract:
#define GrB_Vector_extract_(...)                    GrB_Vector_extract (__VA_ARGS__)
#define GrB_Matrix_extract_(...)                    GrB_Matrix_extract (__VA_ARGS__)
#define GrB_Col_extract_(...)                       GrB_Col_extract (__VA_ARGS__)

// GxB_subassign:
#define GxB_Vector_subassign_(...)                  GxB_Vector_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_(...)                  GxB_Matrix_subassign (__VA_ARGS__)
#define GxB_Col_subassign_(...)                     GxB_Col_subassign (__VA_ARGS__)
#define GxB_Row_subassign_(...)                     GxB_Row_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_BOOL_(...)             GxB_Vector_subassign_BOOL (__VA_ARGS__)
#define GxB_Vector_subassign_INT8_(...)             GxB_Vector_subassign_INT8 (__VA_ARGS__)
#define GxB_Vector_subassign_INT16_(...)            GxB_Vector_subassign_INT16 (__VA_ARGS__)
#define GxB_Vector_subassign_INT32_(...)            GxB_Vector_subassign_INT32 (__VA_ARGS__)
#define GxB_Vector_subassign_INT64_(...)            GxB_Vector_subassign_INT64 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT8_(...)            GxB_Vector_subassign_UINT8 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT16_(...)           GxB_Vector_subassign_UINT16 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT32_(...)           GxB_Vector_subassign_UINT32 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT64_(...)           GxB_Vector_subassign_UINT64 (__VA_ARGS__)
#define GxB_Vector_subassign_FP32_(...)             GxB_Vector_subassign_FP32 (__VA_ARGS__)
#define GxB_Vector_subassign_FP64_(...)             GxB_Vector_subassign_FP64 (__VA_ARGS__)
#define GxB_Vector_subassign_FC32_(...)             GxB_Vector_subassign_FC32 (__VA_ARGS__)
#define GxB_Vector_subassign_FC64_(...)             GxB_Vector_subassign_FC64 (__VA_ARGS__)
#define GxB_Vector_subassign_UDT_(...)              GxB_Vector_subassign_UDT (__VA_ARGS__)
#define GxB_Matrix_subassign_BOOL_(...)             GxB_Matrix_subassign_BOOL (__VA_ARGS__)
#define GxB_Matrix_subassign_INT8_(...)             GxB_Matrix_subassign_INT8 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT16_(...)            GxB_Matrix_subassign_INT16 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT32_(...)            GxB_Matrix_subassign_INT32 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT64_(...)            GxB_Matrix_subassign_INT64 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT8_(...)            GxB_Matrix_subassign_UINT8 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT16_(...)           GxB_Matrix_subassign_UINT16 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT32_(...)           GxB_Matrix_subassign_UINT32 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT64_(...)           GxB_Matrix_subassign_UINT64 (__VA_ARGS__)
#define GxB_Matrix_subassign_FP32_(...)             GxB_Matrix_subassign_FP32 (__VA_ARGS__)
#define GxB_Matrix_subassign_FP64_(...)             GxB_Matrix_subassign_FP64 (__VA_ARGS__)
#define GxB_Matrix_subassign_FC32_(...)             GxB_Matrix_subassign_FC32 (__VA_ARGS__)
#define GxB_Matrix_subassign_FC64_(...)             GxB_Matrix_subassign_FC64 (__VA_ARGS__)
#define GxB_Matrix_subassign_UDT_(...)              GxB_Matrix_subassign_UDT (__VA_ARGS__)

// GrB_assign:
#define GrB_Vector_assign_(...)                     GrB_Vector_assign (__VA_ARGS__)
#define GrB_Matrix_assign_(...)                     GrB_Matrix_assign (__VA_ARGS__)
#define GrB_Col_assign_(...)                        GrB_Col_assign (__VA_ARGS__)
#define GrB_Row_assign_(...)                        GrB_Row_assign (__VA_ARGS__)
#define GrB_Vector_assign_BOOL_(...)                GrB_Vector_assign_BOOL (__VA_ARGS__)
#define GrB_Vector_assign_INT8_(...)                GrB_Vector_assign_INT8 (__VA_ARGS__)
#define GrB_Vector_assign_INT16_(...)               GrB_Vector_assign_INT16 (__VA_ARGS__)
#define GrB_Vector_assign_INT32_(...)               GrB_Vector_assign_INT32 (__VA_ARGS__)
#define GrB_Vector_assign_INT64_(...)               GrB_Vector_assign_INT64 (__VA_ARGS__)
#define GrB_Vector_assign_UINT8_(...)               GrB_Vector_assign_UINT8 (__VA_ARGS__)
#define GrB_Vector_assign_UINT16_(...)              GrB_Vector_assign_UINT16 (__VA_ARGS__)
#define GrB_Vector_assign_UINT32_(...)              GrB_Vector_assign_UINT32 (__VA_ARGS__)
#define GrB_Vector_assign_UINT64_(...)              GrB_Vector_assign_UINT64 (__VA_ARGS__)
#define GrB_Vector_assign_FP32_(...)                GrB_Vector_assign_FP32 (__VA_ARGS__)
#define GrB_Vector_assign_FP64_(...)                GrB_Vector_assign_FP64 (__VA_ARGS__)
#define GxB_Vector_assign_FC32_(...)                GxB_Vector_assign_FC32 (__VA_ARGS__)
#define GxB_Vector_assign_FC64_(...)                GxB_Vector_assign_FC64 (__VA_ARGS__)
#define GrB_Vector_assign_UDT_(...)                 GrB_Vector_assign_UDT (__VA_ARGS__)
#define GrB_Matrix_assign_BOOL_(...)                GrB_Matrix_assign_BOOL (__VA_ARGS__)
#define GrB_Matrix_assign_INT8_(...)                GrB_Matrix_assign_INT8 (__VA_ARGS__)
#define GrB_Matrix_assign_INT16_(...)               GrB_Matrix_assign_INT16 (__VA_ARGS__)
#define GrB_Matrix_assign_INT32_(...)               GrB_Matrix_assign_INT32 (__VA_ARGS__)
#define GrB_Matrix_assign_INT64_(...)               GrB_Matrix_assign_INT64 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT8_(...)               GrB_Matrix_assign_UINT8 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT16_(...)              GrB_Matrix_assign_UINT16 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT32_(...)              GrB_Matrix_assign_UINT32 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT64_(...)              GrB_Matrix_assign_UINT64 (__VA_ARGS__)
#define GrB_Matrix_assign_FP32_(...)                GrB_Matrix_assign_FP32 (__VA_ARGS__)
#define GrB_Matrix_assign_FP64_(...)                GrB_Matrix_assign_FP64 (__VA_ARGS__)
#define GxB_Matrix_assign_FC32_(...)                GxB_Matrix_assign_FC32 (__VA_ARGS__)
#define GxB_Matrix_assign_FC64_(...)                GxB_Matrix_assign_FC64 (__VA_ARGS__)
#define GrB_Matrix_assign_UDT_(...)                 GrB_Matrix_assign_UDT (__VA_ARGS__)

// GrB_apply:
#define GrB_Vector_apply_(...)                      GrB_Vector_apply (__VA_ARGS__)
#define GrB_Matrix_apply_(...)                      GrB_Matrix_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_(...)          GxB_Vector_apply_BinaryOp1st (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_BOOL_(...)     GrB_Vector_apply_BinaryOp1st_BOOL (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT8_(...)     GrB_Vector_apply_BinaryOp1st_INT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT16_(...)    GrB_Vector_apply_BinaryOp1st_INT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT32_(...)    GrB_Vector_apply_BinaryOp1st_INT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT64_(...)    GrB_Vector_apply_BinaryOp1st_INT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT8_(...)    GrB_Vector_apply_BinaryOp1st_UINT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT16_(...)   GrB_Vector_apply_BinaryOp1st_UINT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT32_(...)   GrB_Vector_apply_BinaryOp1st_UINT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT64_(...)   GrB_Vector_apply_BinaryOp1st_UINT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP32_(...)     GrB_Vector_apply_BinaryOp1st_FP32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP64_(...)     GrB_Vector_apply_BinaryOp1st_FP64 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC32_(...)     GxB_Vector_apply_BinaryOp1st_FC32 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC64_(...)     GxB_Vector_apply_BinaryOp1st_FC64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UDT_(...)      GrB_Vector_apply_BinaryOp1st_UDT (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_(...)          GxB_Vector_apply_BinaryOp2nd (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_BOOL_(...)     GrB_Vector_apply_BinaryOp2nd_BOOL (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT8_(...)     GrB_Vector_apply_BinaryOp2nd_INT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT16_(...)    GrB_Vector_apply_BinaryOp2nd_INT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT32_(...)    GrB_Vector_apply_BinaryOp2nd_INT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT64_(...)    GrB_Vector_apply_BinaryOp2nd_INT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT8_(...)    GrB_Vector_apply_BinaryOp2nd_UINT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT16_(...)   GrB_Vector_apply_BinaryOp2nd_UINT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT32_(...)   GrB_Vector_apply_BinaryOp2nd_UINT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT64_(...)   GrB_Vector_apply_BinaryOp2nd_UINT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP32_(...)     GrB_Vector_apply_BinaryOp2nd_FP32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP64_(...)     GrB_Vector_apply_BinaryOp2nd_FP64 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC32_(...)     GxB_Vector_apply_BinaryOp2nd_FC32 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC64_(...)     GxB_Vector_apply_BinaryOp2nd_FC64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UDT_(...)      GrB_Vector_apply_BinaryOp2nd_UDT (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_(...)          GxB_Matrix_apply_BinaryOp1st (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_BOOL_(...)     GrB_Matrix_apply_BinaryOp1st_BOOL (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT8_(...)     GrB_Matrix_apply_BinaryOp1st_INT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT16_(...)    GrB_Matrix_apply_BinaryOp1st_INT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT32_(...)    GrB_Matrix_apply_BinaryOp1st_INT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT64_(...)    GrB_Matrix_apply_BinaryOp1st_INT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT8_(...)    GrB_Matrix_apply_BinaryOp1st_UINT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT16_(...)   GrB_Matrix_apply_BinaryOp1st_UINT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT32_(...)   GrB_Matrix_apply_BinaryOp1st_UINT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT64_(...)   GrB_Matrix_apply_BinaryOp1st_UINT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP32_(...)     GrB_Matrix_apply_BinaryOp1st_FP32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP64_(...)     GrB_Matrix_apply_BinaryOp1st_FP64 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC32_(...)     GxB_Matrix_apply_BinaryOp1st_FC32 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC64_(...)     GxB_Matrix_apply_BinaryOp1st_FC64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UDT_(...)      GrB_Matrix_apply_BinaryOp1st_UDT (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_(...)          GxB_Matrix_apply_BinaryOp2nd (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_BOOL_(...)     GrB_Matrix_apply_BinaryOp2nd_BOOL (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT8_(...)     GrB_Matrix_apply_BinaryOp2nd_INT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT16_(...)    GrB_Matrix_apply_BinaryOp2nd_INT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT32_(...)    GrB_Matrix_apply_BinaryOp2nd_INT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT64_(...)    GrB_Matrix_apply_BinaryOp2nd_INT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT8_(...)    GrB_Matrix_apply_BinaryOp2nd_UINT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT16_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT32_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT64_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP32_(...)     GrB_Matrix_apply_BinaryOp2nd_FP32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP64_(...)     GrB_Matrix_apply_BinaryOp2nd_FP64 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC32_(...)     GxB_Matrix_apply_BinaryOp2nd_FC32 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC64_(...)     GxB_Matrix_apply_BinaryOp2nd_FC64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UDT_(...)      GrB_Matrix_apply_BinaryOp2nd_UDT (__VA_ARGS__)

// GxB_select:
#define GxB_Vector_select_(...)                     GxB_Vector_select (__VA_ARGS__)
#define GxB_Matrix_select_(...)                     GxB_Matrix_select (__VA_ARGS__)

// GrB_reduce:
#define GrB_Matrix_reduce_Monoid_(...)              GrB_Matrix_reduce_Monoid (__VA_ARGS__)
#define GrB_Matrix_reduce_BinaryOp_(...)            GrB_Matrix_reduce_BinaryOp (__VA_ARGS__)
#define GrB_Vector_reduce_BOOL_(...)                GrB_Vector_reduce_BOOL (__VA_ARGS__)
#define GrB_Vector_reduce_INT8_(...)                GrB_Vector_reduce_INT8 (__VA_ARGS__)
#define GrB_Vector_reduce_INT16_(...)               GrB_Vector_reduce_INT16 (__VA_ARGS__)
#define GrB_Vector_reduce_INT32_(...)               GrB_Vector_reduce_INT32 (__VA_ARGS__)
#define GrB_Vector_reduce_INT64_(...)               GrB_Vector_reduce_INT64 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT8_(...)               GrB_Vector_reduce_UINT8 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT16_(...)              GrB_Vector_reduce_UINT16 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT32_(...)              GrB_Vector_reduce_UINT32 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT64_(...)              GrB_Vector_reduce_UINT64 (__VA_ARGS__)
#define GrB_Vector_reduce_FP32_(...)                GrB_Vector_reduce_FP32 (__VA_ARGS__)
#define GrB_Vector_reduce_FP64_(...)                GrB_Vector_reduce_FP64 (__VA_ARGS__)
#define GxB_Vector_reduce_FC32_(...)                GxB_Vector_reduce_FC32 (__VA_ARGS__)
#define GxB_Vector_reduce_FC64_(...)                GxB_Vector_reduce_FC64 (__VA_ARGS__)
#define GrB_Vector_reduce_UDT_(...)                 GrB_Vector_reduce_UDT (__VA_ARGS__)
#define GrB_Matrix_reduce_BOOL_(...)                GrB_Matrix_reduce_BOOL (__VA_ARGS__)
#define GrB_Matrix_reduce_INT8_(...)                GrB_Matrix_reduce_INT8 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT16_(...)               GrB_Matrix_reduce_INT16 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT32_(...)               GrB_Matrix_reduce_INT32 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT64_(...)               GrB_Matrix_reduce_INT64 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT8_(...)               GrB_Matrix_reduce_UINT8 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT16_(...)              GrB_Matrix_reduce_UINT16 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT32_(...)              GrB_Matrix_reduce_UINT32 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT64_(...)              GrB_Matrix_reduce_UINT64 (__VA_ARGS__)
#define GrB_Matrix_reduce_FP32_(...)                GrB_Matrix_reduce_FP32 (__VA_ARGS__)
#define GrB_Matrix_reduce_FP64_(...)                GrB_Matrix_reduce_FP64 (__VA_ARGS__)
#define GxB_Matrix_reduce_FC32_(...)                GxB_Matrix_reduce_FC32 (__VA_ARGS__)
#define GxB_Matrix_reduce_FC64_(...)                GxB_Matrix_reduce_FC64 (__VA_ARGS__)
#define GrB_Matrix_reduce_UDT_(...)                 GrB_Matrix_reduce_UDT (__VA_ARGS__)

// GxB_resize:
#define GrB_Matrix_resize_(...)                     GrB_Matrix_resize (__VA_ARGS__)
#define GrB_Vector_resize_(...)                     GrB_Vector_resize (__VA_ARGS__)

// GrB_kronecker:
#define GrB_Matrix_kronecker_BinaryOp_(...)         GrB_Matrix_kronecker_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_kronecker_Monoid_(...)           GrB_Matrix_kronecker_Monoid (__VA_ARGS__)
#define GrB_Matrix_kronecker_Semiring_(...)         GrB_Matrix_kronecker_Semiring (__VA_ARGS__)

// GxB_fprint:
#define GxB_Type_fprint_(o,p,f)                     GxB_Type_fprint (o, GB_STR(o), p, f)
#define GxB_UnaryOp_fprint_(o,p,f)                  GxB_UnaryOp_fprint (o, GB_STR(o), p, f)
#define GxB_BinaryOp_fprint_(o,p,f)                 GxB_BinaryOp_fprint (o, GB_STR(o), p, f)
#define GxB_SelectOp_fprint_(o,p,f)                 GxB_SelectOp_fprint (o, GB_STR(o), p, f)
#define GxB_Monoid_fprint_(o,p,f)                   GxB_Monoid_fprint (o, GB_STR(o), p, f)
#define GxB_Semiring_fprint_(o,p,f)                 GxB_Semiring_fprint (o, GB_STR(o), p, f)
#define GxB_Descriptor_fprint_(o,p,f)               GxB_Descriptor_fprint (o, GB_STR(o), p, f)
#define GxB_Matrix_fprint_(o,p,f)                   GxB_Matrix_fprint (o, GB_STR(o), p, f)
#define GxB_Vector_fprint_(o,p,f)                   GxB_Vector_fprint (o, GB_STR(o), p, f)
#define GxB_Scalar_fprint_(o,p,f)                   GxB_Scalar_fprint (o, GB_STR(o), p, f)

#endif
#endif

