function C = gb_emult (A, op, B)
%GB_EMULT C = A.*B, sparse matrix element-wise multiplication.
% C = gb_emult (A, op, B) computes the element-wise multiplication of A
% and B using the operator op, where the op is '*' for C=A.*B.  If both A
% and B are matrices, the pattern of C is the intersection of A and B.  If
% one is a scalar, the pattern of C is the same as the pattern of the one
% matrix.
%
% The input matrices may be either GraphBLAS structs and/or MATLAB matrices,
% in any combination.  C is returned as a GraphBLAS struct.

% SuiteSparse:GraphBLAS, T. A. Davis, (c) 2017-2020, All Rights Reserved.
% http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

if (gb_isscalar (A) || gb_isscalar (B))
    % either A or B are scalars
    C = gbapply2 (A, op, B) ;
else
    % both A and B are matrices
    C = gbemult (A, op, B) ;
end

