/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "AprError.h"
#include "Error.h"


namespace apr
{

sc::String strError( apr_status_t status )
{
  const int size = 256;
  char cbuf[size];

  apr_strerror( status, cbuf, size-1 );

  sc::String msg("apr: ");
  msg += cbuf;

  return msg;
}

const sc::Error* createError( apr_status_t status )
{
  return sc::createError(status,apr::strError(status));
}

} // namespace
