/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFF_SUMMARIZE_LVI_H
#define _SC_DIFF_SUMMARIZE_LVI_H

// sc
#include "svn/DiffSummarizeTypes.h"

// qt
#include <Qt3Support/Q3ListView>


class DiffSummarizeLvi : public Q3ListViewItem
{
  typedef Q3ListViewItem super;

public:
  DiffSummarizeLvi( Q3ListView* parent, svn::DiffSummarizePtr summarize );
  virtual ~DiffSummarizeLvi();

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( Q3ListViewItem * i, int col, bool ascending ) const;

  svn::DiffSummarizePtr getDiffSummarize() const;

private:
  svn::DiffSummarizePtr _summarize;
};

#endif // _SC_DIFF_SUMMARIZE_LVI_H
