/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#include <sofa/simulation/common/ConstraintVisitor.h>

namespace sofa
{

  namespace simulation
  {


    void ConstraintVisitor::processOdeSolver(simulation::Node* /*node*/, core::componentmodel::behavior::OdeSolver* solver)
    {
      solver->solveConstraint(Id, propagateVelocityFromPosition);
      isEnd=RESULT_PRUNE;
      
    }

    Visitor::Result ConstraintVisitor::processNodeTopDown(simulation::Node* node)
    {
      for_each(this, node, node->solver, &ConstraintVisitor::processOdeSolver);      
      return isEnd;
        
    }


    void ConstraintErrorVisitor::processLMConstraint(simulation::Node* /*node*/, core::componentmodel::behavior::BaseLMConstraint* c)
    {
      error += c->getError();     
    }

    Visitor::Result ConstraintErrorVisitor::processNodeTopDown(simulation::Node* node)
    {
      for_each(this, node, node->LMConstraint, &ConstraintErrorVisitor::processLMConstraint);
      return RESULT_CONTINUE;
        
    }

} // namespace simulation

} // namespace sofa
