#!/bin/sh -e

. package/info

echo '#'
echo '# This file has been generated by tools/gen-deps.sh'
echo '#'
echo

for dir in src/include/${package} src/lib* ; do
  for file in $(ls -1 $dir | grep -- \\.h$) ; do
    {
      grep -F "#include <${package}/" < ${dir}/$file | cut -d/ -f2- | cut -d'>' -f1 ;
      grep -- '#include ".*-internal\.h"' < ${dir}/$file | cut -d'"' -f2
    } | sort -u | {
      deps=
      while read dep ; do
        if echo $dep | grep -q -- -internal\\.h$ ; then
          deps="$deps ${dir}/$dep"
        else
          deps="$deps src/include/${package}/$dep"
        fi
      done
      if test -n "$deps" ; then
        echo "${dir}/${file}:${deps}"
      fi
    }
  done
done

for dir in src/lib* ; do
  for file in $(ls -1 $dir | grep -- \\.c$) ; do
    {
      grep -F "#include <${package}/" < ${dir}/$file | cut -d/ -f2- | cut -d'>' -f1 ;
      grep -- '#include ".*-internal\.h"' < ${dir}/$file | cut -d'"' -f2
    } | sort -u | {
      deps=" ${dir}/$file"
      while read dep ; do
        if echo $dep | grep -q -- -internal\\.h$ ; then
          deps="$deps ${dir}/$dep"
        else
          deps="$deps src/include/${package}/$dep"
        fi
      done
      o=$(echo $file | sed s/\\.c$/.o/)
      lo=$(echo $file | sed s/\\.c$/.lo/)
      echo "${dir}/${o} ${dir}/${lo}:${deps}"
    }
  done
done
