/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFStk -- Attribute Filesystem Toolkit Library
 *
 * cache.c -- AtFS toolkit library
 *
 * Authors: Axel Mahler (Axel.Mahler@cs.tu-berlin.de)
 *          Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: cache.c[7.0] Fri Jun 25 16:39:01 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"
#include "atfstk.h"

EXPORT char *atCacheKey (aso)
     Af_key *aso;
{
  static int serial = 1;
  static char keyBuf[AT_CACHEKEYLEN];

  (void) sprintf (keyBuf, "%s=%ld.%d.%d", AT_ATTCACHEKEY,
		  af_rettimeattr (aso, AF_ATTMTIME), getpid (), serial++);
  return (keyBuf);
}

EXPORT int atSaveCache (oldAso, newAso, uniqAttr, storeType)
     Af_key *oldAso, *newAso;
     char *uniqAttr;
     int storeType;
{
  char *cacheKey = atCacheKey (oldAso);
  int retVal;

  af_setattr (oldAso, AF_REPLACE, cacheKey);
  retVal = af_savecache (oldAso, newAso, uniqAttr, storeType);
  return (retVal);
}
