/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef FULLPIPE_CONSTANTS_H
#define FULLPIPE_CONSTANTS_H

namespace Fullpipe {

// Common
#define ANI_FLY 4916
#define ANI_INV_MAP 5321
#define ANI_LIFTBUTTON 2751
#define ANI_MAN 322
#define ANI_PBAR 896
#define MSG_CMN_WINARCADE 4778
#define MSG_DISABLESAVES 5201
#define MSG_ENABLESAVES 5202
#define MSG_HMRKICK_METAL 4764
#define MSG_HMRKICK_STUCCO 4765
#define MSG_MANSHADOWSOFF 5196
#define MSG_MANSHADOWSON 5197
#define MV_FLY_FLY 4917
#define MV_LFT_CLOSE 1053
#define MV_LFT_OPEN 1048
#define MV_MAN_GOLADDER 451
#define MV_MAN_GOLADDER2 2844
#define MV_MAN_HMRKICK 1028
#define MV_MAN_HMRKICK_COINLESS 1445
#define MV_MAN_LIFTDOWN 1052
#define MV_MAN_LIFTUP 1051
#define MV_MAN_LOOKUP 4773
#define rMV_MAN_LOOKUP 4775
#define MV_MAN_TOLADDER 448
#define MV_MAN_TOLADDER2 2841
#define MV_MAN_STARTD 478
#define MV_MAN_STARTLADDER 452
#define MV_MAN_STARTLADDER2 2842
#define MV_MAN_STOPLADDER 454
#define MV_MAN_STOPLADDER2 2845
#define MV_MAN_TURN_LU 486
#define MV_PBAR_RUN 897
#define PIC_CSR_DEFAULT 4891
#define PIC_CSR_DEFAULT_INV 4892
#define PIC_CSR_ITN 4893
#define PIC_CSR_ITN_INV 4894
#define PIC_CSR_ITN_GREEN 5330
#define PIC_CSR_ITN_RED 5329
#define PIC_CSR_GOFAR_L 4895
#define PIC_CSR_GOFAR_R 4896
#define PIC_CSR_ARCADE1 4901
#define PIC_CSR_ARCADE2 4902
#define PIC_CSR_ARCADE2_D 4903
#define PIC_CSR_ARCADE3 4904
#define PIC_CSR_ARCADE4 4905
#define PIC_CSR_ARCADE5 4906
#define PIC_CSR_ARCADE6 4907
#define PIC_CSR_ARCADE6_D 4908
#define PIC_CSR_ARCADE7 4909
#define PIC_CSR_ARCADE7_D 4910
#define PIC_CSR_ARCADE8 4911
#define PIC_CSR_GOD 4900
#define PIC_CSR_GOL 4897
#define PIC_CSR_GOR 4898
#define PIC_CSR_GOU 4899
#define PIC_CSR_HELPERBGR 5331
#define PIC_CSR_LIFT 5176
#define PIC_CSR_MAP 5339
#define PIC_HLP_BGR 3562
#define PIC_IN1_GAMETITLE 5169
#define PIC_IN1_PIPETITLE 5167
#define PIC_INV_MENU 991
#define PIC_MAP_A01 5263
#define PIC_MAP_A02 5264
#define PIC_MAP_A03 5265
#define PIC_MAP_A04 5266
#define PIC_MAP_A05 5267
#define PIC_MAP_A06 5268
#define PIC_MAP_A07 5269
#define PIC_MAP_A08 5270
#define PIC_MAP_A09 5271
#define PIC_MAP_A10 5272
#define PIC_MAP_A11 5273
#define PIC_MAP_A12 5274
#define PIC_MAP_A13 5275
#define PIC_MAP_A14 5276
#define PIC_MAP_I01 5295
#define PIC_MAP_I02 5296
#define PIC_MAP_I03 5395
#define PIC_MAP_P01 5277
#define PIC_MAP_P02 5278
#define PIC_MAP_P03 5279
#define PIC_MAP_P04 5280
#define PIC_MAP_P05 5281
#define PIC_MAP_P06 5282
#define PIC_MAP_P07 5283
#define PIC_MAP_P08 5284
#define PIC_MAP_P09 5285
#define PIC_MAP_P10 5286
#define PIC_MAP_P11 5287
#define PIC_MAP_P12 5288
#define PIC_MAP_P13 5289
#define PIC_MAP_P14 5290
#define PIC_MAP_P15 5291
#define PIC_MAP_P16 5292
#define PIC_MAP_P17 5293
#define PIC_MAP_P18 5294
#define PIC_MAP_S01 5223
#define PIC_MAP_S02 5224
#define PIC_MAP_S03 5225
#define PIC_MAP_S04 5226
#define PIC_MAP_S05 5227
#define PIC_MAP_S06 5228
#define PIC_MAP_S07 5229
#define PIC_MAP_S08 5231
#define PIC_MAP_S09 5230
#define PIC_MAP_S10 5232
#define PIC_MAP_S11 5233
#define PIC_MAP_S12 5234
#define PIC_MAP_S13 5235
#define PIC_MAP_S14 5236
#define PIC_MAP_S15 5237
#define PIC_MAP_S16 5238
#define PIC_MAP_S17 5239
#define PIC_MAP_S1819 5240
#define PIC_MAP_S20 5241
#define PIC_MAP_S21 5242
#define PIC_MAP_S22 5243
#define PIC_MAP_S23_1 5244
#define PIC_MAP_S23_2 5245
#define PIC_MAP_S24 5246
#define PIC_MAP_S25 5247
#define PIC_MAP_S26 5248
#define PIC_MAP_S27 5249
#define PIC_MAP_S28 5250
#define PIC_MAP_S29 5251
#define PIC_MAP_S30 5252
#define PIC_MAP_S31_1 5253
#define PIC_MAP_S31_2 5254
#define PIC_MAP_S32_1 5255
#define PIC_MAP_S32_2 5256
#define PIC_MAP_S33 5257
#define PIC_MAP_S34 5258
#define PIC_MAP_S35 5259
#define PIC_MAP_S36 5260
#define PIC_MAP_S37 5261
#define PIC_MAP_S38 5262
#define PIC_MAP_H01 5357
#define PIC_MAP_H02 5358
#define PIC_MAP_H03 5359
#define PIC_MAP_H04 5360
#define PIC_MAP_H05 5361
#define PIC_MAP_H06 5362
#define PIC_MAP_H07 5363
#define PIC_MAP_H08 5364
#define PIC_MAP_H09 5365
#define PIC_MAP_H10 5366
#define PIC_MAP_H11 5367
#define PIC_MAP_H12 5368
#define PIC_MAP_H13 5369
#define PIC_MAP_H14 5370
#define PIC_MAP_H15 5371
#define PIC_MAP_H16 5372
#define PIC_MAP_H17 5373
#define PIC_MAP_H18 5394
#define PIC_MAP_H19 5393
#define PIC_MAP_H20 5374
#define PIC_MAP_H21 5375
#define PIC_MAP_H22 5376
#define PIC_MAP_H23 5377
#define PIC_MAP_H24 5378
#define PIC_MAP_H25 5379
#define PIC_MAP_H26 5380
#define PIC_MAP_H27 5381
#define PIC_MAP_H28 5382
#define PIC_MAP_H29 5383
#define PIC_MAP_H30 5384
#define PIC_MAP_H31 5385
#define PIC_MAP_H32 5386
#define PIC_MAP_H33 5387
#define PIC_MAP_H34 5388
#define PIC_MAP_H35 5389
#define PIC_MAP_H36 5390
#define PIC_MAP_H37 5391
#define PIC_MAP_H38 5392
#define PIC_TTL_CREDITS 5172
#define QU_INTR_STARTINTRO 5133
#define SC_1 301
#define SC_2 302
#define SC_3 303
#define SC_4 304
#define SC_5 305
#define SC_6 649
#define SC_7 650
#define SC_8 651
#define SC_9 652
#define SC_10 653
#define SC_11 654
#define SC_12 655
#define SC_13 1137
#define SC_14 1138
#define SC_15 1139
#define SC_16 1140
#define SC_17 1141
#define SC_18 1142
#define SC_19 1143
#define SC_20 1144
#define SC_21 1546
#define SC_22 1547
#define SC_23 1548
#define SC_24 1549
#define SC_25 1550
#define SC_26 1551
#define SC_27 1552
#define SC_28 2062
#define SC_29 2063
#define SC_30 2064
#define SC_31 2065
#define SC_32 2066
#define SC_33 2067
#define SC_34 2068
#define SC_35 2069
#define SC_36 2070
#define SC_37 2071
#define SC_38 2072
#define SC_COMMON 321
#define SC_DBGMENU 726
#define SC_FINAL1 4999
#define SC_FINAL2 5000
#define SC_FINAL3 5001
#define SC_FINAL4 2460
#define SC_INTRO1 3896
#define SC_INTRO2 3907
#define SC_INV 858
#define SC_LDR 635
#define SC_MAINMENU 4620
#define SC_MAP 5222
#define SC_TITLES 5166
#define SND_CMN_015 3139
#define SND_CMN_031 3516
#define SND_CMN_032 3517
#define SND_CMN_054 4762
#define SND_CMN_055 4763
#define SND_CMN_056 4772
#define SND_CMN_060 4921
#define SND_CMN_061 4922
#define SND_CMN_070 5199
#define SND_INTR_019 5220
#define ST_EGTR_SLIMSORROW 340
#define ST_FLY_FLY 4918
#define ST_LBN_0H 2835
#define ST_LBN_1H 2791
#define ST_LBN_2H 2793
#define ST_LBN_3H 2795
#define ST_LBN_4H 2797
#define ST_LBN_5H 2799
#define ST_LBN_6H 2801
#define ST_LBN_7H 2803
#define ST_LBN_8H 2805
#define ST_LBN_9H 2807
#define ST_LBN_0N 2832
#define ST_LBN_1N 2753
#define ST_LBN_2N 2756
#define ST_LBN_3N 2759
#define ST_LBN_4N 2762
#define ST_LBN_5N 2765
#define ST_LBN_6N 2768
#define ST_LBN_7N 2771
#define ST_LBN_8N 2774
#define ST_LBN_9N 2777
#define ST_LBN_0P 2833
#define ST_LBN_1P 2754
#define ST_LBN_2P 2757
#define ST_LBN_3P 2760
#define ST_LBN_4P 2763
#define ST_LBN_5P 2766
#define ST_LBN_6P 2769
#define ST_LBN_7P 2772
#define ST_LBN_8P 2775
#define ST_LBN_9P 2778
#define ST_LFT_CLOSED 1049
#define ST_LFT_OPEN_NEW 1071
#define ST_MAN_EMPTY 476
#define ST_MAN_GOU 459
#define ST_MAN_RIGHT 325
#define TrubaDown 697
#define TrubaLeft 474
#define TrubaUp 680

// Main Menu
#define PIC_MNU_AUTHORS_L 4624
#define PIC_MNU_CONTINUE_L 4626
#define PIC_MNU_DEBUG_L 4632
#define PIC_MNU_EXIT_L 4622
#define PIC_MNU_LOAD_L 4628
#define PIC_MNU_MUSICSLIDER_D 4914
#define PIC_MNU_MUSICSLIDER_L 4915
#define PIC_MNU_RESTART_L 5299
#define PIC_MNU_SAVE_L 4630
#define PIC_MNU_SLIDER_D 4913
#define PIC_MNU_SLIDER_L 4912

// Query dialog
#define PIC_MEX_BGR 5300
#define PIC_MEX_CANCEL 5302
#define PIC_MEX_OK 5301
#define PIC_MOV_BGR 5343
#define PIC_MOV_CANCEL 5345
#define PIC_MOV_OK 5344

// Saveload dialog
#define PIC_MLD_BGR 4645
#define PIC_MLD_CANCEL_D 4648
#define PIC_MLD_CANCEL_L 4649
#define PIC_MLD_OK_D 4646
#define PIC_MLD_OK_L 4647
#define PIC_MSV_0_D 4643
#define PIC_MSV_0_L 4644
#define PIC_MSV_1_D 4651
#define PIC_MSV_1_L 4660
#define PIC_MSV_2_D 4652
#define PIC_MSV_2_L 4661
#define PIC_MSV_3_D 4653
#define PIC_MSV_3_L 4662
#define PIC_MSV_4_D 4654
#define PIC_MSV_4_L 4663
#define PIC_MSV_5_D 4655
#define PIC_MSV_5_L 4664
#define PIC_MSV_6_D 4656
#define PIC_MSV_6_L 4665
#define PIC_MSV_7_D 4657
#define PIC_MSV_7_L 4666
#define PIC_MSV_8_D 4658
#define PIC_MSV_8_L 4667
#define PIC_MSV_9_D 4659
#define PIC_MSV_9_L 4668
#define PIC_MSV_BGR 4634
#define PIC_MSV_CANCEL_D 4637
#define PIC_MSV_CANCEL_L 4638
#define PIC_MSV_DOTS_D 4670
#define PIC_MSV_DOTS_L 4669
#define PIC_MSV_DOT_D 5188
#define PIC_MSV_DOT_L 5189
#define PIC_MSV_EMPTY_D 4639
#define PIC_MSV_EMPTY_L 4640
#define PIC_MSV_FULL_D 4641
#define PIC_MSV_FULL_L 4642
#define PIC_MSV_OK_D 4635
#define PIC_MSV_OK_L 4636
#define PIC_MSV_SPACE_D 5190
#define PIC_MSV_SPACE_L 5191

// Demo screen
#define PIC_POST_BGR 5396
#define PIC_POST_TEXT 5397
#define PIC_POST_BUTTON 5398
#define SND_CMN_069 4969

// Intro
#define ANI_IN1MAN 5110
#define MSG_INTR_ENDINTRO 5139
#define MSG_INTR_GETUPMAN 5135
#define MSG_INTR_SWITCHTO1 5145
#define MSG_INTR_SWITCHTO2 5134
#define MV_IN1MAN_SLEEP 5111
#define QU_IN2_DO 5144
#define QU_INTR_FINISH 5138
#define QU_INTR_GETUPMAN 5136
#define ST_IN1MAN_SLEEP 5112

// Scene 1
#define ANI_BOOT_1 4231
#define MSG_SC1_SHOWOSK 1019
#define MSG_SC1_SHOWOSK2 468
#define MSG_SC1_UTRUBACLICK 1100
#define PIC_SC1_KUCHKA 1321
#define PIC_SC1_LADDER 1091
#define PIC_SC1_OSK 1018
#define PIC_SC1_OSK2 2932
#define TrubaRight 696

// Scene 2
#define ANI_SC2_BOX 1020
#define ANI_DADAYASHIK 306
#define MSG_SC2_HIDELADDER 1023
#define MSG_SC2_LADDERCLICK 1101
#define MSG_SC2_PUTMANUP 1026
#define MSG_SC2_SHOWLADDER 1027
#define PIC_SC2_DTRUBA 841
#define PIC_SC2_LADDER 412
#define ST_DYAS_LIES 318

// Scene 3
#define ANI_DOMINO_3 2732
#define ANI_EGGEATER 334
#define ANI_INV_COIN 875
#define ANI_INV_EGGAPL 1564
#define ANI_INV_EGGBOOT 1570
#define ANI_INV_EGGCOIN 1567
#define ANI_INV_EGGDOM 1561
#define ANI_INV_EGGGLS 1573
#define MSG_LIFT_CLICKBUTTON 2780
#define MSG_LIFT_CLOSEDOOR 5194
#define MSG_LIFT_EXITLIFT 5187
#define MSG_LIFT_GO 1065
#define MSG_LIFT_STARTEXITQUEUE 5186
#define MSG_SC3_HIDEDOMINO 3177
#define MSG_SC3_ONTAKECOIN 5338
#define MSG_SC3_RELEASEEGG 2681
#define MSG_SC3_TAKEEGG 1583
#define MSG_SC3_TESTFAT 1582
#define MSG_SC3_UTRUBACLICK 1103
#define MV_EGTR_FATASK 5332
#define PIC_SC3_DOMIN 5182
#define PIC_SC3_LADDER 1102
#define ST_EGTR_MID1 2863
#define ST_EGTR_MID2 2869
#define ST_EGTR_SLIM 336
#define QU_EGTR_MD2_SHOW 4698
#define QU_EGTR_MD1_SHOW 4697
#define QU_EGTR_SLIMSHOW 4883
#define QU_SC3_ENTERLIFT 2779
#define QU_SC3_EXITLIFT 2808

// Scene 4
#define ANI_BIGBALL 4923
#define ANI_BUTTON 598
#define ANI_CLOCK 588
#define ANI_HAND 601
#define ANI_KOZAWKA 495
#define ANI_MAMASHA_4 660
#define ANI_PLANK 501
#define ANI_SC4_BOOT 1035
#define ANI_SC4_COIN 690
#define ANI_SPEAKER_4 3275
#define ANI_SPRING 542
#define MSG_GOTOLADDER 618
#define MSG_KOZAWRESTART 546
#define MSG_SC4_COINOUT 2895
#define MSG_SC4_COINPUT 1032
#define MSG_SC4_CLICKLADDER 1439
#define MSG_SC4_DROPBOTTLE 2896
#define MSG_SC4_HANDOVER 2960
#define MSG_SC4_HIDEBOOT 4563
#define MSG_SC4_KOZAWFALL 2858
#define MSG_SC4_MANFROMBOTTLE 2854
#define MSG_SC4_MANTOBOTTLE 2852
#define MSG_SHAKEBOTTLE 584
#define MSG_SHOOTKOZAW 557
#define MSG_STARTHAND 612
#define MSG_CLICKBOTTLE 569
#define MSG_CLICKBUTTON 609
#define MSG_CLICKPLANK 549
#define MSG_LOWERPLANK 540
#define MSG_RAISEPLANK 547
#define MSG_SHOWCOIN 1033
#define MSG_TAKEBOTTLE 614
#define MSG_TAKEKOZAW 611
#define MSG_TESTPLANK 538
#define MSG_UPDATEBOTTLE 613
#define MV_BTN_CLICK 599
#define MV_CLK_GO 589
#define MV_HND_POINT 602
#define MV_KZW_GOR 564
#define rMV_KZW_GOR 566
#define MV_KZW_JUMP 558
#define MV_KZW_JUMPROTATE 561
#define MV_KZW_TOHOLERV 537
#define MV_KZW_WALKPLANK 500
#define MV_KZW_JUMPHIT 2857
#define MV_KZW_JUMPOUT 586
#define MV_KZW_RAISEHEAD 577
#define MV_KZW_STANDUP 563
#define MV_KZW_TURN 562
#define MV_MAN_FROMLADDER 493
#define MV_MAN_GOD 481
#define MV_MAN_GOU 460
#define MV_MAN_JUMPONPLANK 551
#define MV_MAN_LOOKLADDER 520
#define MV_MAN_PLANKTOLADDER 553
#define MV_MAN_STARTLADDERD 457
#define MV_PNK_WEIGHTLEFT 541
#define MV_PNK_WEIGHTRIGHT 502
#define MV_SC4_COIN_default 1029
#define MV_SPK4_PLAY 3276
#define MV_SPR_LOWER 543
#define PIC_SC4_BOTTLE 568
#define PIC_SC4_BOTTLE2 2936
#define PIC_SC4_DOWNTRUBA 619
#define PIC_SC4_LADDER 1438
#define PIC_SC4_LRTRUBA 616
#define PIC_SC4_MASK 585
#define PIC_SC4_PLANK 5183
#define QU_BALL_WALKL 4920
#define QU_BALL_WALKR 4919
#define QU_HND_TAKE0 1440
#define QU_HND_TAKE1 1441
#define QU_HND_TAKE2 1442
#define QU_HND_TAKEBOTTLE 1443
#define QU_KOZAW_WALK 505
#define QU_PNK_CLICK 550
#define QU_SC4_GOCLOCK 595
#define QU_SC4_MANFROMBOTTLE 2851
#define QU_SC4_MANTOBOTTLE 2850
#define SND_4_010 3125
#define SND_4_012 3127
#define SND_4_033 4990
#define ST_CLK_CLOSED 590
#define ST_HND_EMPTY 603
#define ST_KZW_EMPTY 498
#define ST_KZW_JUMPOUT 587
#define ST_KZW_RIGHT 559
#define ST_KZW_SIT 560
#define ST_MAN_GOLADDER 450
#define ST_MAN_GOLADDER2 2843
#define MV_MAN_LOOKLADDERRV 556
#define ST_MAN_LADDERDOWN 521
#define ST_MAN_LOOKPLANK 555
#define ST_MAN_ONPLANK 552
#define ST_MAN_SIT 1164
#define ST_MAN_STANDLADDER 453
#define ST_MAN_UP 449
#define ST_PNK_WEIGHTLEFT 503
#define ST_PNK_WEIGHTRIGHT 504
#define ST_SPR_UP 544

// Scene 5
#define ANI_BIGLUK 909
#define ANI_HANDLE 622
#define ANI_OTMOROZ 419
#define MSG_SC5_BGRSOUNDOFF 5315
#define MSG_SC5_BGRSOUNDON 5314
#define MSG_SC5_HANDLEDOWN 916
#define MSG_SC5_HANDLEUP 915
#define MSG_SC5_HIDEHANDLE 917
#define MSG_SC5_MAKEMANFLIGHT 1136
#define MSG_SC5_MAKEOTMFEEDBACK 1169
#define MSG_SC5_SHOWHANDLE 918
#define MSG_SC5_TESTLUK 914
#define MV_BLK_CLOSE 911
#define MV_BLK_OPEN 910
#define MV_MANHDL_HANDLEDOWN 630
#define MV_MANHDL_HANDLEUP 631
#define MV_OTM_BOXHANDLEDOWN 626
#define MV_OTM_BOXHANDLEUP 627
#define MV_OTM_HANDLEDOWN 620
#define MV_OTM_HANDLEUP 621
#define QU_SC5_MANBUMP 1167
#define QU_SC5_MANFLY 1168
#define SND_5_026 5316
#define ST_BLK_CLOSED 912
#define ST_BLK_OPEN 913
#define ST_HDL_BROKEN 3342
#define ST_HDL_DOWN 625
#define ST_HDL_UP 624
#define ST_OTM_BOX_LEFT 429
#define ST_OTM_GLS_LEFT 421
#define ST_OTM_VNT_LEFT 434

// Scene 6
#define ANI_BALLDROP 2685
#define ANI_BUTTON_6 2988
#define ANI_EGGIE 4929
#define ANI_INV_HANDLE 893
#define ANI_MAMASHA 656
#define ANI_NEWBALL 1073
#define MSG_SC6_BTNPUSH 1017
#define MSG_SC6_ENABLEDROPS 687
#define MSG_SC6_INSTHANDLE 1012
#define MSG_SC6_JUMPBK 2900
#define MSG_SC6_JUMPFW 2901
#define MSG_SC6_RESTORESCROLL 2906
#define MSG_SC6_SHOWNEXTBALL 790
#define MSG_SC6_STARTDROPS 2897
#define MSG_SC6_TAKEBALL 682
#define MSG_SC6_TESTNUMBALLS 2904
#define MSG_SC6_UTRUBACLICK 1105
#define MSG_SPINHANDLE 2398
#define MV_MAN6_TAKEBALL 2691
#define MV_MAN6_THROWBALL 2692
#define MV_MOM_CYCLEBK 3012
#define MV_MOM_JUMPBK 662
#define MV_MOM_JUMPFW 661
#define MV_MOM_STARTBK 3010
#define MV_MOM_STOPBK 3013
#define MV_MOM_TAKE1 2885
#define MV_MOM_TAKE2 2886
#define MV_MOM_TAKE3 2887
#define MV_MOM_TAKE4 2888
#define MV_MOM_TAKE5 2889
#define PIC_SC6_LADDER 1104
#define QU_EGG6_GOL 4936
#define QU_EGG6_GOR 4935
#define QU_MOM_JUMPBK 671
#define QU_MOM_JUMPFW 670
#define QU_MOM_PUTBALL 2903
#define QU_MOM_SITDOWN 685
#define QU_MOM_STANDUP 2899
#define QU_MOM_TOLIFT 2902
#define QU_SC6_DROPS 2898
#define QU_SC6_DROPS3 2955
#define QU_SC6_ENTERLIFT 1054
#define QU_SC6_EXITLIFT 1055
#define QU_SC6_FALLBALL 2690
#define QU_SC6_FALLHANDLE 2995
#define QU_SC6_SHOWHANDLE 1689
#define QU_SC6_SHOWNEXTBALL 2689
#define ST_HDL_PLUGGED 2397
#define ST_MAN6_BALL 2688
#define ST_MOM_SITS 659
#define ST_MOM_STANDS 658
#define ST_NBL_NORM 1076

// Scene 7
#define ANI_CORNERSITTER 711
#define ANI_HOOLIGAN 808
#define ANI_LUKE 803
#define ANI_PLUSMINUS 2938
#define ANI_SC7_BOX 791
#define MSG_SC7_CLOSELUKE 822
#define MSG_SC7_HIDEBOX 817
#define MSG_SC7_HIDELUKE 821
#define MSG_SC7_OPENLUKE 823
#define MSG_SC7_PULL 2943
#define MSG_SC7_SHOWBOX 816
#define MV_CST_CLOSELUKE 807
#define MV_SC7_BOX_default 792
#define QU_CST_CLOSELUKE 820
#define ST_CST_HANDLELESS 794
#define ST_HGN_LOOK 811
#define ST_HGN_LUKE 810
#define ST_LUK_CLOSED 805
#define ST_LUK_OPEN 806
#define ST_PMS_MINUS 2942
#define ST_PMS_PLUS 2941

// Scene 8
#define ANI_BATUTA 737
#define ANI_CLOCK_8 2989
#define ANI_VMYATS 764
#define MSG_SC8_ARCADENOW 1044
#define MSG_SC8_ENTERUP 3037
#define MSG_SC8_GETHIMUP 789
#define MSG_SC8_HIDELADDER_D 1107
#define MSG_SC8_RESUMEFLIGHT 784
#define MSG_SC8_STANDUP 2976
#define MSG_STARTARCADE 781
#define MV_CLK8_GO 2990
#define MV_MAN_FROMLADDERUP 1522
#define MV_MAN_TOLADDERD 1524
#define MV_MAN8_BADLUCK 783
#define MV_MAN8_DRYGDOWN 770
#define MV_MAN8_DRYGUP 768
#define MV_MAN8_HANDSDOWN 772
#define MV_MAN8_HANDSUP 777
#define MV_MAN8_JUMP 775
#define MV_MAN8_JUMPOFF 2969
#define MV_MAN8_SITDOWN 2968
#define MV_VMT_DEF 765
#define PIC_SC8_ARCADENOW 1043
#define PIC_SC8_LADDER 754
#define PIC_SC8_LADDER_D 755
#define PIC_SC8_LADDERD 1106
#define QU_SC8_FINISH 788
#define QU_SC8_STANDUP 2975
#define SND_8_014 3624
#define ST_BTT_CHESHET 746
#define ST_BTT_NOSPOON 739
#define ST_BTT_SLEEPS 748
#define ST_BTT_SPOON 741
#define ST_MAN8_FLYDOWN 771
#define ST_MAN8_FLYUP 769
#define ST_MAN8_HANDSUP 773
#define ST_MAN8_STAND 774
#define ST_VMT_MIN 766

// Scene 9
#define ANI_BALL9 933
#define ANI_GLOTATEL 924
#define ANI_GRIT_9 2719
#define ANI_PLEVATEL 919
#define ANI_VISUNCHIK 904
#define MSG_SC9_EATBALL 941
#define MSG_SC9_FLOWN 943
#define MSG_SC9_FROMLADDER 4207
#define MSG_SC9_PLVCLICK 965
#define MSG_SC9_SETSCROLL 964
#define MSG_SC9_SHOWBALL 936
#define MSG_SC9_STARTTIOTIA 4942
#define MSG_SC9_TOLADDER 4206
#define MV_BALL9_EXPLODE 939
#define MV_GLT_FLYAWAY 931
#define MV_MAN9_SHOOT 922
#define MV_VSN_CYCLE2 2987
#define PIC_SC9_LADDER_R 2700
#define QU_SC9_BALLEXPLODE 938
#define QU_SC9_EATBALL 942
#define QU_TTA9_GOL 4937
#define SND_9_006 3650
#define SND_9_018 4200
#define SND_9_019 4201
#define ST_GLT_SIT 926
#define ST_GRT9_GRIT 2722
#define ST_GRT9_NORM 2721
#define ST_PLV_SIT 921
#define ST_VSN_NORMAL 906

// Scene 10
#define ANI_GUM 978
#define ANI_NADUVATEL 944
#define ANI_PACHKA 975
#define ANI_PACHKA2 3008
#define MSG_SC10_CLICKGUM 992
#define MSG_SC10_HIDEGUM 993
#define MSG_SC10_LADDERTOBACK 3002
#define MSG_SC10_LADDERTOFORE 3004
#define MSG_SC10_SHOWGUM 994
#define MV_NDV_BLOW2 2855
#define MV_NDV_DENIES 952
#define MV_NDV_DENY_NOGUM 3022
#define PIC_SC10_DTRUBA 974
#define PIC_SC10_LADDER 995
#define QU_SC10_ENTERLIFT 1067
#define QU_SC10_EXITLIFT 2809
#define QU_SC10_TAKEGUM 3026
#define ST_NDV_SIT 946

// Scene 11
#define ANI_BOOTS_11 2704
#define ANI_KACHELI 1094
#define ANI_MAN11 1108
#define ANI_SWINGER 1113
#define MSG_SC11_HITMAN 3019
#define MSG_SC11_MANCRY 4691
#define MSG_SC11_MANTOSWING 1128
#define MSG_SC11_PUTBOOT 1117
#define MSG_SC11_RESTARTMAN 1133
#define MSG_SC11_SHOWSWING 1124
#define MSG_SC11_SITSWINGER 5198
#define MV_KCH_MOVE2 1099
#define MV_KCH_START 1121
#define MV_MAN11_JUMPHIT 1129
#define MV_MAN11_JUMPFROMSWING 5209
#define MV_MAN11_JUMPOVER 1131
#define MV_MAN11_SWING_0 1109
#define MV_MAN11_SWING_1 1111
#define MV_MAN11_SWING_2 1112
#define PIC_SC11_HINT 5170
#define QU_SC11_MANFALL 3017
#define QU_SC11_PUTBOOT1 2709
#define QU_SC11_PUTBOOT2 2710
#define QU_SC11_RESTARTMAN 1134
#define QU_SWR_JUMPDOWN 1123
#define SND_11_020 3704
#define SND_11_022 3706
#define SND_11_024 3708
#define SND_11_031 5171
#define ST_BTS11_2 2707
#define ST_BTS11_ONE 2706
#define ST_KCH_0 1096
#define ST_KCH_EMPTY 1132
#define ST_KCH_STATIC 1122
#define ST_MAN_1PIX 518
#define ST_MAN11_EMPTY 1110
#define ST_MAN11_SWING 1127
#define ST_SWR_SIT 1147
#define ST_SWR_SITBALD 1153
#define ST_SWR_STAND3 3014

// Scene 13
#define ANI_BRIDGE 1378
#define ANI_HANDLE_L 1209
#define ANI_HANDLE_R 1196
#define ANI_STOROZH 1172
#define ANI_WHIRLGIG_13 1383
#define MSG_SC13_CHEW 1220
#define MSG_SC13_CLOSEBRIDGE 3046
#define MSG_SC13_CLOSEFAST 1267
#define MSG_SC13_EATGUM 1219
#define MSG_SC13_OPENBRIDGE 3064
#define MSG_SC13_OPENFAST 1266
#define MSG_SC13_SHOWGUM 1215
#define MSG_SC13_STARTWHIRLGIG 1388
#define MSG_SC13_STOPWHIRLGIG 1387
#define MSG_SC13_TESTCLOSE 3065
#define MSG_SC13_TESTOPEN 3048
#define MSG_SC13_UNEATGUM 1218
#define MSG_SC13_UPDATEBRIDGE 1217
#define MV_BDG_CLOSE 1382
#define MV_BDG_OPEN 1379
#define MV_WHR13_SPIN 1384
#define QU_SC13_CLOSEFAIL 3063
#define QU_SC13_CLOSESUCCESS 3062
#define QU_SC13_OPENFAIL 3042
#define QU_SC13_OPENSUCCESS 3047
#define QU_SC13_SHOWGUM 1216
#define QU_STR_CHEW 1190
#define QU_STR_LTOR 3054
#define QU_STR_PLUU 1189
#define QU_STR_RTOL 3053
#define QU_STR_TURNR 1186
#define QU_STR_TURNR_L 3059
#define SND_13_018 3763
#define SND_13_033 4685
#define SND_13_034 4686
#define SND_13_037 5335
#define ST_BDG_CLOSED 1380
#define ST_BDG_OPEN2 1381
#define ST_HDLL_FIRECAN 1310
#define ST_HDLL_HAMMER 3205
#define ST_HDLL_UP 1211
#define ST_HDLR_DOWN 1199
#define ST_HDLR_DOWN_GUM 3044
#define ST_HDLR_GUM 1201
#define ST_STR_LEFT 1175
#define ST_STR_RIGHT 1174

// Scene 14
#define ANI_BALL14 1246
#define ANI_GRANDMA 1227
#define MSG_SC14_ENDARCADE 3250
#define MSG_SC14_GMAJUMP 1250
#define MSG_SC14_GMATOTRUBA 3249
#define MSG_SC14_HIDEBALLLAST 3251
#define MSG_SC14_HIDEPINK 3248
#define MSG_SC14_MANKICKBALL 1257
#define MSG_SC14_RESTORESCROLL 4769
#define MSG_SC14_SCROLLLEFT 4768
#define MSG_SC14_SHOWBALLFLY 1253
#define MSG_SC14_SHOWBALLGMADIVE 1260
#define MSG_SC14_SHOWBALLGMAHIT 1259
#define MSG_SC14_SHOWBALLGMAHIT2 3245
#define MSG_SC14_SHOWBALLLAST 3246
#define MSG_SC14_SHOWBALLMAN 1254
#define MSG_SC14_STARTARCADE 3252
#define MV_BAL14_FALL 1258
#define MV_BAL14_SPIN 1247
#define MV_BAL14_TOGMA 3214
#define MV_GMA_BACKOFF 1233
#define MV_GMA_BACKOFF2 3217
#define MV_GMA_JUMPFW 1230
#define MV_GMA_THROW 1232
#define MV_MAN14_DECLINE 1239
#define MV_MAN14_FALL 1236
#define MV_MAN14_KICK 1237
#define MV_MAN14_KICKAIR 1256
#define MV_MAN14_STEPFW 1240
#define PIC_SC14_RTRUBA 1221
#define ST_GMA_SIT 1229
#define QU_GMA_BLINK 1252
#define QU_GMA_JUMPBK 1251
#define QU_GMA_JUMPFW 1249
#define QU_GMA_THROW 1255
#define QU_SC14_ENDARCADE 1391
#define QU_SC14_ENTERLIFT 1225
#define QU_SC14_EXITLIFT 1226
#define QU_SC14_STARTARCADE 1390
#define QU_SC14_WINARCADE 3247

// Scene 15
#define ANI_BOOT_15 4779
#define ANI_INV_BOOT 881
#define ANI_GRANDMA_ASS 1265
#define MSG_SC15_ASSDRYG 4755
#define MSG_SC15_LADDERTOBACK 3259
#define MSG_SC15_PULL 2940
#define MSG_SC15_STOPCHANTING 4753
#define MV_SWR_SWING 1114
#define PIC_SC15_DTRUBA 1263
#define PIC_SC15_LADDER 3253
#define PIC_SC15_LTRUBA 1261
#define QU_SC15_ENTERLIFT 2811
#define QU_SC15_EXITLIFT 2812
#define SND_15_001 3798
#define SND_15_006 3808
#define SND_15_011 4754
#define ST_GMS_BOOT 1270
#define ST_GMS_BOOTLESS2 3316

// Scene 16
#define ANI_BEARDED_CMN 3420
#define ANI_BOOT_16 3285
#define ANI_BOY 1327
#define ANI_GIRL 1328
#define ANI_JETTIE 1392
#define ANI_MUG 1296
#define ANI_WIRE16 1344
#define MSG_SC16_FILLMUG 1363
#define MSG_SC16_HIDEMAN 1357
#define MSG_SC16_HIDEMUG 1351
#define MSG_SC16_HIDEWIRE 1349
#define MSG_SC16_LAUGHSOUND 4993
#define MSG_SC16_MUGCLICK 1366
#define MSG_SC16_SHOWBEARDED 4956
#define MSG_SC16_SHOWMAN 1358
#define MSG_SC16_SHOWMUG 1352
#define MSG_SC16_SHOWMUGFULL 1396
#define MSG_SC16_SHOWWIRE 1350
#define MSG_SC16_STARTLAUGH 1374
#define MV_BOY_DRINK 1333
#define MV_BT16_FILL 3286
#define MV_GRL_DRINK 1339
#define MV_GRL_FALL 3115
#define MV_GRL_LAUGH_POPA 3278
#define MV_JTI_FLOWBY 1393
#define MV_JTI_FLOWIN 1394
#define MV_MAN16_TAKEMUG 1362
#define PIC_SC16_TUMBA 1368
#define QU_BRD16_STARTBEARDED 4948
#define QU_SC16_BOYKICK 1367
#define QU_SC16_BOYOUT 1364
#define QU_SC16_GIRLLAUGH 1375
#define QU_SC16_GIRLOUT 1365
#define QU_SC16_GOBOY 1347
#define QU_SC16_GOGIRL 1348
#define QU_SC16_MANDRINK 5200
#define QU_SC16_SHOWMUG 1361
#define QU_SC16_TAKEMUG 1435
#define SND_16_034 3854
#define SND_16_035 3855
#define SND_16_037 3857
#define ST_BOY_STAND 1331
#define ST_GRL_LAUGH 1342
#define ST_GRL_STAND 1337
#define ST_MUG_EMPTY 1298
#define ST_MUG_FULL 1360

// Scene 17
#define ANI_BOOT_17 4220
#define ANI_HAND17 1446
#define ANI_INV_BOTTLE 1418
#define ANI_INV_SUGAR 1410
#define ANI_JET_17 2746
#define ANI_MUG_17 2737
#define ANI_SAMOGONSHCHIK 1397
#define MSG_SC17_DROP 3414
#define MSG_SC17_FILLBOTTLE 1436
#define MSG_SC17_HIDESUGAR 1417
#define MSG_SC17_SHOWBOTTLE 1432
#define MSG_SC17_SHOWSUGAR 1416
#define MSG_SC17_TESTTRUBA 1458
#define MSG_SC17_UPDATEHAND 1560
#define MV_HND17_FIGA 1449
#define PIC_SC17_RTRUBA 1323
#define PIC_SC17_RTRUBA2 5297
#define QU_HND17_ASK 1456
#define QU_HND17_ATTRACT 1455
#define QU_HND17_TOCYCLE 1454
#define QU_JET17_DROP 3295
#define QU_JET17_FLOW 3294
#define QU_SC17_FILLBOOT 4237
#define QU_SC17_FILLBOTTLE 1437
#define QU_SC17_FILLMUG 2750
#define QU_SC17_FILLMUG_DROP 3415
#define QU_SC17_SHOWBOTTLE 1429
#define QU_SC17_SHOWSUGAR 1415
#define QU_SMG_FILLBOTTLE 1433
#define ST_HND17_ATTRACT 1451
#define ST_HND17_EMPTY 1448
#define ST_MUG17_EMPTY 2739
#define ST_SMG_SIT 1399

// Scene 18
#define ANI_BOY18 1477
#define ANI_DOMINO_18 3174
#define ANI_GIRL18 1484
#define ANI_KRESLO 1459
#define ANI_WHIRLIGIG_18 829
#define MSG_SC18_CLICKBOARD 3297
#define MSG_SC18_MANCLIMBEDDOWN 1540
#define MSG_SC18_MANCLIMBEDUP 1539
#define MSG_SC18_MANREADY 1507
#define MSG_SC18_SHOWBOYJUMP 1495
#define MSG_SC18_SHOWBOYJUMPTO 1497
#define MSG_SC18_SHOWGIRLJUMP 1496
#define MSG_SC18_SHOWGIRLJUMPTO 1499
#define MSG_SC18_SHOWMANJUMP 1510
#define MSG_SC18_SHOWMANJUMPTO 1508
#define MV_BOY18_JUMPFROM 1478
#define MV_BOY18_JUMPTO 1481
#define MV_GRL18_JUMPFROM 1485
#define MV_GRL18_JUMPTO 1488
#define MV_KSL_CALMDOWN 1476
#define MV_KSL_INBOY 1491
#define MV_KSL_INGIRL 1493
#define MV_KSL_INMAN 1504
#define MV_KSL_JUMPBOY 1473
#define MV_KSL_JUMPGIRL 1475
#define MV_KSL_JUMPMAN 1509
#define MV_KSL_SWING 1460
#define MV_KSL_SWINGBOY 1462
#define MV_KSL_SWINGGIRL 1464
#define MV_KSL_SWINGMAN 1502
#define MV_MAN18_JUMPTOTRUBA 1511
#define MV_MAN18_STANDKRESLO 1500
#define MV_WHR18_SPIN 1300
#define PIC_SC18_DOMIN 5184
#define PIC_SC18_LADDER1 1471
#define PIC_SC18_LADDER2 1472
#define PIC_SC18_LADDER3 3299
#define PIC_SC18_RTRUBA 1520
#define QU_SC19_MANJUMP1 1516
#define QU_SC19_MANJUMP2 1517
#define QU_SC19_MANJUMP3 1518
#define SND_18_006 3906
#define SND_18_010 4994
#define ST_KSL_BOY 1463
#define ST_KSL_GIRL 1465
#define ST_KSL_JUMPBOY 1492
#define ST_KSL_JUMPGIRL 1494
#define ST_KSL_JUMPMAN 1505
#define ST_KSL_MAN 1503
#define ST_KSL_REACT 1474

// Scene 19
#define ANI_CORDIE 1529
#define ANI_WHIRLGIG_19 1302
#define MSG_SC19_UPDATENUMRIDES 5203
#define MV_WHR19_SPIN 1317
#define PIC_SC19_RTRUBA1 1513
#define PIC_SC19_RTRUBA2 1514
#define PIC_SC19_RTRUBA3 1515
#define PIC_SC19_RTRUBA31 5320
#define SND_19_015 3928
#define SND_19_016 4995
#define ST_CDI_EMPTY2 1543
#define ST_KSL_NORM 1461

// Scene 20
#define ANI_GRANDMA_20 2427
#define MSG_SC20_UPDATELOCKABLE 5217
#define ST_GMA20_FLOOR 2429
#define ST_GMA20_STAND 2436
#define ST_GMA20_STOOL 2432

// Scene 21
#define ANI_GIRAFFE_BOTTOM 1633
#define ANI_INV_BOX 890
#define ANI_INV_STOOL 1780
#define MSG_SC21_UPDATEASS 4211
#define PIC_SC21_DTRUBA 1823
#define ST_GRFB_SIT 1687
#define ST_GRFB_HANG 1638

// Scene 22
#define ANI_GIRAFFE_MIDDLE 1981
#define ANI_MESHOK 1754
#define ANI_TABURETTE 1745
#define MSG_SC22_CHECKGMABOOT 4782
#define MSG_SC22_CRANEOUT_GMA 5218
#define MSG_SC22_FROMSTOOL 1799
#define MSG_SC22_HANDLEDOWN 1796
#define MSG_SC22_HIDESTOOL 2503
#define MSG_SC22_ONSTOOL 1798
#define MSG_SC22_SHOWSTOOL 2495
#define QU_MSH_CRANEOUT 1811
#define QU_MSH_CRANEOUT_GMA 5219
#define QU_SC22_FALLBROOM 1786
#define QU_SC22_FALLSACK 1791
#define QU_SC22_FALLSACK_GMA 2613
#define QU_SC22_FROMSTOOL 1800
#define QU_SC22_HANDLEDOWN 1804
#define QU_SC22_PUTSTOOL 1803
#define QU_SC22_SHOWSTOOL 1793
#define QU_SC22_TOSTOOL 1801
#define QU_SC22_TOSTOOL_R 3332
#define QU_SC22_TRYBOX 5311
#define QU_SC22_TRYHANDLE 1802
#define QU_MSH_MOVE 1812
#define rMV_MAN_TURN_SRL 1090
#define ST_GRFM_AFTER 3472
#define ST_GRFM_NORM 1983
#define ST_MSH_SIT 1756

// Scene 23
#define ANI_CALENDWHEEL 1702
#define ANI_GIRAFFE_TOP 1645
#define ANI_GIRAFFEE 1672
#define ANI_HANDLE23 1978
#define ANI_INV_LEVERHANDLE 1777
#define ANI_LUK23_D 1813
#define ANI_LUK23_U 1817
#define MSG_SC23_CLICKBTN1 1736
#define MSG_SC23_CLICKBTN2 1737
#define MSG_SC23_CLICKBTN3 1738
#define MSG_SC23_CLICKBTN4 1739
#define MSG_SC23_FROMSTOOL 3339
#define MSG_SC23_HIDEGIRAFFEE 4650
#define MSG_SC23_ONSTOOL 3334
#define MSG_SC23_SPINWHEEL1 1740
#define MSG_SC23_SPINWHEEL2 1741
#define MSG_SC23_SPINWHEEL3 1742
#define MSG_SC23_SPINWHEEL4 1743
#define MV_CND_0_1 1703
#define MV_CND_1_2 1706
#define MV_CND_2_3 1708
#define MV_CND_3_4 1710
#define MV_CND_4_5 1712
#define MV_CND_5_6 1714
#define MV_CND_6_7 1716
#define MV_CND_7_8 1718
#define MV_CND_8_9 1720
#define MV_CND_9_0 1722
#define MV_MAN23_PUSH1 1724
#define MV_MAN23_PUSH2 1725
#define MV_MAN23_PUSH3 1726
#define MV_MAN23_PUSH4 1727
#define PIC_SC23_BOXCLOSED 1728
#define PIC_SC23_BOXOPEN 1723
#define PIC_SC23_BTN1 1729
#define PIC_SC23_BTN2 1730
#define PIC_SC23_BTN3 1731
#define PIC_SC23_BTN4 1732
#define PIC_SC23_LADDER 1628
#define PIC_SC23_LADDERU 3411
#define QU_GRFU_TURN_UD 1664
#define QU_GRFU_TURN_UL 1662
#define QU_SC23_FROMCALENDAR 1734
#define QU_SC23_FROMCALENDAREXIT 1735
#define QU_SC23_FROMSTOOL 3338
#define QU_SC23_SHOWSTOOL 3335
#define QU_SC23_STARTKISS 1822
#define QU_SC23_TOCALENDAR 1733
#define ST_CND_0 1704
#define ST_CND_1 1705
#define ST_CND_2 1707
#define ST_CND_3 1709
#define ST_CND_4 1711
#define ST_CND_5 1713
#define ST_CND_6 1715
#define ST_CND_7 1717
#define ST_CND_8 1719
#define ST_CND_9 1721
#define ST_GRFG_BALD 1675
#define ST_GRFG_EMPTY 1674
#define ST_GRFU_KISS 1681
#define ST_GRFU_UP 1648
#define ST_LUK23_OPEN 1816
#define ST_LUK23_WHANDLE2 1977
#define ST_LUK23U_CLOSED 1819
#define ST_LUK23U_OPEN 1820

// Scene 24
#define ANI_DROP_24 3505
#define ANI_INV_HAMMER 884
#define ANI_JET24 1837
#define ANI_WATER24 1834
#define MV_MAN_TURN_RL 332
#define MV_WTR24_FLOW 1835
#define MV_WTR24_FLOWLOWER 1844
#define MV_JET24_FLOW 1838
#define QU_DRP24_TOFLOOR 3510
#define QU_DRP24_TOWATER 3509
#define QU_DRP24_TOWATER2 4046
#define SND_24_006 4041
#define SND_24_007 4042
#define ST_DRP24_EMPTY 3507
#define ST_WTR24_FLOWLOWER 1843

// Scene 25
#define ANI_BOARD25 1898
#define ANI_DROP_25 3499
#define ANI_INV_BOARD 1872
#define ANI_INV_BROOM 1774
#define ANI_INV_LOPAT 1920
#define ANI_INV_SWAB 1917
#define ANI_WATER25 1856
#define MSG_BRD_TURN 4877
#define MSG_SC25_ENTERMAN 1861
#define MSG_SC25_ENTERTRUBA 4214
#define MSG_SC25_STARTBEARDEDS 3423
#define MSG_SC25_STOPBEARDEDS 3424
#define MSG_SC25_TOLADDER 4215
#define MV_MAN_GOLADDERDOWN 455
#define MV_MAN25_CHIH 1886
#define rMV_MAN25_CHIH 3343
#define MV_BRD25_RIGHT 1899
#define rMV_BRD25_RIGHT 1903
#define MV_MAN25_ONBOARD 1885
#define rMV_MAN25_ONBOARD 1966
#define MV_WTR25_FLOW 1857
#define PIC_SC25_LADDERDOWN 1855
#define PIC_SC25_LADDERUP 1854
#define PIC_SC25_RTRUBA 1853
#define QU_DRP25_TOFLOOR 3502
#define QU_DRP25_TOWATER 3504
#define QU_SC25_BACKTOLADDER 1955
#define QU_SC25_BACKTOTRUBA 2061
#define QU_SC25_BEARDED 3425
#define QU_SC25_BEARDED2 3426
#define QU_SC25_BEARDED3 3427
#define QU_SC25_BOARDTOLADDER 1911
#define QU_SC25_ENTERUP_FLOOR 1904
#define QU_SC25_ENTERUP_WATER 1895
#define QU_SC25_LADDERUP 1925
#define QU_SC25_MANTOTRUBA 1905
#define QU_SC25_MANTOTRUBA_R 4218
#define QU_SC25_PUTBOARD 1896
#define QU_SC25_ROWTOLADDER 1910
#define QU_SC25_ROWTOTRUBA 1897
#define QU_SC25_TRUBATOBOARD 1909
#define QU_SC25_TRYBROOM 1912
#define QU_SC25_TRYHAND 4219
#define QU_SC25_TRYROWHAND 3493
#define QU_SC25_TRYROWHAND_R 3494
#define QU_SC25_TRYSPADE 3498
#define QU_SC25_TRYSWAB 1913
#define QU_SC25_TRYWATER 1906
#define SND_25_006 4059
#define SND_25_025 4874
#define SND_25_026 4875
#define SND_25_027 4876
#define SND_25_028 5173
#define SND_25_029 5174
#define SND_25_030 5175
#define ST_BRD25_RIGHT2 1902
#define ST_BRDCMN_EMPTY 3422
#define ST_DRP25_EMPTY 3501
#define ST_MAN_GOLADDERD 456
#define ST_MAN_LADDERDOWN_R 3419
#define ST_MAN25_ONBOARD 1879

// Scene 26
#define ANI_CHHI 1957
#define ANI_DROP_26 3345
#define ANI_INV_SOCK 1698
#define ANI_INV_VENT 1968
#define ANI_LUK26 1867
#define ANI_SOCK_26 4553
#define ANI_VENT 1927
#define MSG_SC26_CLICKVENT 1947
#define MSG_SC26_HIDECHI 1967
#define MSG_SC26_HIDEVENT 1945
#define MSG_SC26_SHOWCHI 3495
#define MSG_SC26_SHOWVENT 1946
#define MSG_SC26_TESTVENT 1952
#define MSG_SC26_UPDATEDROP 3496
#define MSG_SC26_UPDATEPOOL 1956
#define PIC_SC26_LTRUBA 1864
#define PIC_SC26_SOCK 5312
#define QU_CHI_HIDE 1965
#define QU_CHI_SHOW 1964
#define QU_SC26_AUTOCLOSE1 1949
#define QU_SC26_AUTOCLOSE2 1950
#define QU_SC26_AUTOCLOSE3 1951
#define QU_SC26_CLOSE1 1936
#define QU_SC26_CLOSE2 1938
#define QU_SC26_CLOSE3 1940
#define QU_SC26_CLOSE4 1942
#define QU_SC26_CLOSE5 1944
#define QU_SC26_OPEN1 1935
#define QU_SC26_OPEN2 1937
#define QU_SC26_OPEN3 1939
#define QU_SC26_OPEN4 1941
#define QU_SC26_OPEN5 1943
#define SND_26_003 4079
#define SND_26_018 5340
#define SND_26_019 5341
#define SND_26_020 5342
#define ST_CHI_EMPTY 1959
#define ST_CHI_NORM 1960
#define ST_VNT26_RIGHT2 3348
#define ST_VNT26_UP2 1948

// Scene 27
#define ANI_BITA 2026
#define ANI_BITAHANDLER 3349
#define ANI_MAID 2015
#define ANI_VODILLA 1994
#define MSG_SC27_CLICKBET 2048
#define MSG_SC27_HANDLERTOBACK 3372
#define MSG_SC27_HANDLERTOFRONT 3371
#define MSG_SC27_SHOWNEXTBET 3369
#define MSG_SC27_STARTBET 2047
#define MSG_SC27_STARTWIPE 2057
#define MSG_SC27_TAKEVENT 4584
#define MV_BTA_FALL 2049
#define MV_BTH_1_0 3366
#define MV_BTH_2_1 3364
#define MV_BTH_3_2 3362
#define MV_BTH_4_3 3360
#define MV_BTH_5_4 3358
#define MV_MAN27_FLOW 1990
#define MV_MAN27_THROWBET 1989
#define PIC_SC27_HITZONE2 4756
#define QU_DRV_GIVEVENT 2040
#define QU_DRV_PUSHBUTTON 2056
#define QU_DRV_PUSHBUTTON_NOVENT 4578
#define QU_MID_CLEANVENT 4583
#define QU_MID_SWITCHBACK 2044
#define QU_SC27_RESTARTBETS 3370
#define QU_SC27_SHOWBET 3368
#define SND_27_026 4127
#define SND_27_027 4128
#define SND_27_044 4687
#define ST_BTA_FALL 2054
#define ST_BTA_HILITE 2052
#define ST_BTA_NORM 2028
#define ST_BTH_1 3365
#define ST_BTH_2 3363
#define ST_BTH_3 3361
#define ST_BTH_4 3359
#define ST_BTH_5 3357
#define ST_DRV_SITNOVENT 1999
#define ST_DRV_VENT 1996
#define ST_MID_BROOM 2022
#define ST_MID_SPADE 3489
#define ST_MID_SWAB 2017
#define ST_MID_SWAB2 2019

// Scene 28
#define ANI_LIFT 982
#define ANI_LIFT_28 4238
#define ANI_MAN_28 4247
#define ANI_TIOTIA 4286
#define MSG_SC28_CLICKLIFT 4258
#define MSG_SC28_ENDCABIN 3456
#define MSG_SC28_ENDLIFT1 4259
#define MSG_SC28_ENDLIFT6 4244
#define MSG_SC28_LIFT1_SHOWAFTER 4261
#define MSG_SC28_LIFT6INSIDE 5354
#define MSG_SC28_LIFT6MUSIC 5355
#define MSG_SC28_MAKEFACES 4684
#define MSG_SC28_STARTWORK1 4255
#define MSG_SC28_TRYVTORPERS 4961
#define MSG_SC28_TURNOFF_0 4678
#define MSG_SC28_TURNOFF_1 4279
#define MSG_SC28_TURNOFF_2 4277
#define MSG_SC28_TURNOFF_3 4275
#define MSG_SC28_TURNOFF_4 4282
#define MSG_SC28_TURNOFF_6 4273
#define MSG_SC28_TURNON4 4280
#define MSG_SC28_TURNON_0 4677
#define MSG_SC28_TURNON_1 4278
#define MSG_SC28_TURNON_2 4276
#define MSG_SC28_TURNON_3 4274
#define MSG_SC28_TURNON_4 4281
#define MSG_SC28_TURNON_6 4272
#define MV_WMN28_IN_1 3443
#define MV_WMN28_IN_2 3445
#define MV_WMN28_IN_3 3446
#define MV_WMN28_IN_4 3447
#define MV_WMN28_IN_5 3448
#define PIC_SC28_DARK0 4675
#define PIC_SC28_DARK1 4266
#define PIC_SC28_DARK2 4267
#define PIC_SC28_DARK3 4268
#define PIC_SC28_DARK4 4269
#define PIC_SC28_DARK5 4270
#define PIC_SC28_DARK6 4271
#define QU_BRD28_GOL 4960
#define QU_BRD28_GOR 4959
#define QU_GLV28_GOL 4958
#define QU_GLV28_GOR 4957
#define QU_SC28_LIFT0_START 4676
#define QU_SC28_LIFT1_START 4254
#define QU_SC28_LIFT1_WORK 4256
#define QU_SC28_LIFT2_START 4246
#define QU_SC28_LIFT3_START 4245
#define QU_SC28_LIFT5_START 4674
#define QU_SC28_LIFT6_END 3563
#define QU_SC28_LIFT6_START 4243
#define QU_SC28_LIFT6_START2 4295
#define QU_SC28_WMN_START 3452
#define ST_MAN28_RIGHT 4249

// Scene 29
#define ANI_ASS 2120
#define ANI_PORTER 2082
#define ANI_SHELL_GREEN 2116
#define ANI_SHELL_RED 2130
#define ANI_SHOOTER1 2108
#define ANI_SHOOTER2 2111
#define MSG_SC29_DISABLEPORTER 2097
#define MSG_SC29_DISABLERIDEBACK 2106
#define MSG_SC29_ENABLEPORTER 2096
#define MSG_SC29_ENABLERIDEBACK 2105
#define MSG_SC29_LAUGH 4760
#define MSG_SC29_SHOOTGREEN 2119
#define MSG_SC29_SHOOTRED 2137
#define MSG_SC29_SHOWLASTGREEN 2730
#define MSG_SC29_SHOWLASTRED 2731
#define MSG_SC29_STOPRIDE 2107
#define MV_ASS_HITGREEN 2138
#define MV_ASS_HITRED 2139
#define MV_BRDCMN_GOR 4735
#define MV_MAN29_BEND 2091
#define MV_MAN29_HIT 2088
#define MV_MAN29_JUMP 2090
#define MV_MAN29_RUN 2095
#define MV_MAN29_STANDUP 2092
#define MV_MAN29_STANDUP_NORM 2093
#define MV_PTR_MOVEFAST 2102
#define MV_SHG_HITASS 2151
#define MV_SHG_HITMAN 2147
#define MV_SHG_NORM 2117
#define MV_SHR_HITASS 2152
#define MV_SHR_HITMAN 2149
#define MV_SHR_NORM 2131
#define MV_STR1_SHOOT 2109
#define MV_STR2_SHOOT 2112
#define PIC_SC29_LTRUBA 2081
#define QU_SC29_BRD1 4741
#define QU_SC29_BRD2 4742
#define QU_SC29_BRDOUT1 4743
#define QU_SC29_BRDOUT2 4744
#define QU_SC29_ESCAPE 2129
#define QU_SC29_MANFROM_L 2101
#define QU_SC29_MANFROM_R 2104
#define QU_SC29_MANTO_L 2103
#define QU_SC29_MANTO_R 2100
#define SND_29_014 4348
#define SND_29_027 4757
#define SND_29_028 4758
#define SND_29_029 4759
#define ST_ASS_NORM 2122
#define ST_BRDCMN_GOR 4734
#define ST_BRDCMN_RIGHT 4732
#define ST_MAN29_RUNR 2140
#define ST_MAN29_SITR 2141
#define ST_STR1_RIGHT 2143
#define ST_STR2_RIGHT 2144
#define ST_STR1_STAND 2110
#define ST_STR2_STAND 2113

// Scene 30
#define ANI_LEG 2322
#define MSG_SC30_UPDATEPATH 2358
#define PIC_SC30_LTRUBA 2354
#define QU_SC30_ENTERLIFT 2823
#define QU_SC30_EXITLIFT 2824
#define ST_LEG_DOWN 2325
#define ST_LEG_DOWN1 2330
#define ST_LEG_DOWN2 2334
#define ST_LEG_EMPTY 2338
#define ST_LEG_UP 2324

// Scene 31
#define LiftDown 1058
#define LiftUp 1057
#define ANI_CACTUS_31 2456
#define MSG_SC31_PULL 2944
#define MSG_SC31_TESTCACTUS 5095
#define SND_31_001 4377
#define ST_CTS31_GROWN2 2472

// Scene 32
#define ANI_BUTTON_32 5347
#define ANI_CACTUS 2267
#define ANI_FLAG 2257
#define ANI_KADKA 2670
#define ANI_TESTO_BLUE 2659
#define ANI_TESTO_GREEN 2662
#define ANI_TESTO_ORANGE 2656
#define MSG_SC32_ONLADDER 2270
#define MSG_SC32_SPIN 2405
#define MSG_SC32_STARTCACTUS 2414
#define MSG_SC32_STARTFLAGLEFT 2310
#define MSG_SC32_STARTFLAGRIGHT 2309
#define MSG_SC32_STOPFLAG 2311
#define MSG_SC32_TRUBATOBACK 5181
#define MSG_SC32_TRUBATOFRONT 5180
#define MSG_SC32_TRYSIT 2294
#define MV_CTS_DEFAULT 4299
#define MV_FLG_CYCLEL 2262
#define MV_FLG_CYCLER 2266
#define MV_FLG_STARTL 2258
#define MV_FLG_STARTR 2263
#define MV_FLG_STOPL 2261
#define MV_FLG_STOPR 2265
#define MV_MAN32_SITDOWN 2276
#define MV_MAN32_STANDUP 2313
#define MV_TSTG_FLOW 2663
#define MV_TSTO_FLOW 2657
#define PIC_SC32_LADDER 4296
#define PIC_SC32_RTRUBA 2292
#define QU_CTS_BACK 2415
#define QU_CTS_GROW 2416
#define QU_CTS_GROWMAN 2417
#define QU_KBK32_GO 4977
#define QU_KBK32_START 4982
#define QU_KDK_DRIZZLE 4301
#define QU_SC32_ENTERLIFT 2827
#define QU_SC32_EXITLIFT 2828
#define QU_SC32_FALLHANDLE 5351
#define QU_SC32_FROMLADDER 4300
#define QU_SC32_SHOWHANDLE 2399
#define ST_BTN32_OFF 5349
#define ST_BTN32_ON 5350
#define ST_CTS_EMPTY 2269
#define ST_CTS_GROWUP 2467
#define ST_FLG_LEFT 2260
#define ST_FLG_NORM 2259
#define ST_FLG_RIGHT 2264
#define ST_HDL_LAID 3039
#define ST_MAN32_SIT 2277

// Scene 33
#define ANI_KUBIK 4963
#define ANI_JETTIE_FLOW 2627
#define ANI_MUG_33 2623
#define ANI_VENT_33 2637
#define MSG_SC33_HANDLEDOWN 2643
#define MSG_SC33_POUR 2645
#define MSG_SC33_TESTMUG 5185
#define MSG_SC33_TRYKUBIK 4980
#define MSG_SC33_UPDATEKUBIK 5346
#define MV_JTI33_FLOW 2628
#define MV_JTI33_POUR 2630
#define MV_JTI33_POURFULL 4455
#define MV_VNT33_TURND 2638
#define MV_VNT33_TURNR 2641
#define PIC_SC33_LTRUBA 2618
#define PIC_SC33_ZONES 5298
#define QU_KBK33_GO 4978
#define QU_KBK33_START 4983
#define QU_SC33_STARTWATER 2644
#define ST_MUG33_EMPTY 2625
#define ST_MUG33_FULL 2626
#define ST_VNT33_DOWN 2640
#define ST_VNT33_RIGHT 2639

// Scene 34
#define ANI_BOOT_34 4560
#define ANI_BOX_34 2498
#define ANI_CACTUS_34 2381
#define ANI_LUK_34 2541
#define ANI_STOOL_34 2486
#define ANI_VENT_34 2473
#define MSG_SC34_CLIMB 2490
#define MSG_SC34_CLIMBBOX 4571
#define MSG_SC34_FROMCACTUS 4313
#define MSG_SC34_LEAVEBOARD 2576
#define MSG_SC34_ONBOARD 2550
#define MSG_SC34_ONBUMP 5313
#define MSG_SC34_ONCACTUS 2482
#define MSG_SC34_RETRYVENT 5210
#define MSG_SC34_SHOWBOX 2497
#define MSG_SC34_SHOWVENT 2481
#define MSG_SC34_TESTVENT 2557
#define MSG_SC34_UNCLIMB 2492
#define MV_MAN34_TRY 2485
#define MV_MAN34_TRYTABUR 2489
#define MV_MAN34_TURNVENT_L 4307
#define MV_MAN34_TURNVENT_R 2500
#define QU_SC34_ENTERLIFT 2819
#define QU_SC34_EXITLIFT 2820
#define QU_SC34_FROMBOX 2494
#define QU_SC34_FROMBOX_FLOOR 4572
#define QU_SC34_FROMCACTUS 4312
#define QU_SC34_FROMSTOOL 2491
#define QU_SC34_LEAVEBOARD 2575
#define QU_SC34_SHOWSTOOL 2496
#define QU_CTS34_FALLEFT 4316
#define QU_CTS34_FALLRIGHT 4317
#define QU_LUK34_CLOSE 2547
#define QU_LUK34_OPEN 2546
#define ST_CTS34_EMPTY 2383
#define ST_CTS34_GROWNEMPTY2 2475
#define ST_LUK34_CLOSED 2543
#define ST_LUK34_OPEN 2544
#define ST_STL34_BOX2 4305
#define ST_VNT34_RIGHT3 4318
#define ST_VNT34_UP2 4310

// Scene 35
#define ANI_HOSE 2424
#define ANI_PUZODUV 2418
#define MSG_SC35_CHECKPIPESOUND 4761
#define MSG_SC35_PLUGHOSE 2524
#define MSG_SC35_SHRINK 2570
#define MSG_SC35_STARTFLOW 2523
#define MSG_SC35_STOPFLOW 4864
#define MSG_SC35_TRYFLY 4985
#define QU_PDV_SML_BLINK 2553
#define QU_PDV_SML_TRY 2554
#define QU_SC35_EATHOZE 2540
#define QU_SC35_ENTERLIFT 2815
#define QU_SC35_EXITLIFT 2816
#define SND_35_011 4509
#define SND_35_012 4510
#define SND_35_026 4863
#define ST_HZE_NORM 2426
#define ST_PDV_LARGE 2421
#define ST_PDV_SMALL 2420

// Scene 36
#define ANI_SCISSORS_36 2647
#define ANI_ROTOHRUST 2360
#define PIC_SC36_MASK 5221
#define ST_RHT_OPEN 2362

// Scene 37
#define ANI_GUARD_37 2588
#define ANI_RING 2604
#define MSG_SC37_EXITLEFT 5006
#define MSG_SC37_PULL 2945
#define MV_GRD37_PULL 2589
#define MV_RNG_CLOSE 2605
#define MV_RNG_OPEN 4612
#define PIC_SC37_MASK 2608
#define SND_37_007 4547
#define ST_GRD37_STAND 2590
#define ST_RNG_CLOSED2 4865
#define ST_RNG_OPEN 2606

// Scene 38
#define ANI_BOTTLE38 2188
#define ANI_DOMINO38 2200
#define ANI_DOMINOS 3317
#define ANI_DYLDA 2169
#define ANI_GLAVAR 2154
#define ANI_MALYSH 2165
#define MSG_SC38_DRINK 2225
#define MSG_SC38_HMRKICK 2224
#define MSG_SC38_POINT 2226
#define MSG_SC38_POSTHMRKICK 2256
#define MSG_SC38_PROPOSE 2287
#define MSG_SC38_TRYTAKEBOTTLE 3179
#define MV_DMS_FOUR 3322
#define MV_DMS_THREE 3321
#define MV_GLV_LOOKMAN 2167
#define ST_BTL38_FULL 3172
#define ST_DMN38_6 2288
#define ST_DMN38_NORM3 2251
#define ST_DMN38_NORM4 2253
#define ST_DMS_3 3319
#define ST_DMS_4 3320
#define ST_GLV_HAMMER 2156
#define ST_GLV_NOHAMMER 2159
#define ST_GLV_SLEEP2 2166
#define ST_MLS_LEFT2 2291
#define ST_MLS_RIGHT2 3323
#define QU_DLD_BLINK 2216
#define QU_DLD_DENY 2218
#define QU_DLD_GLOT 2217
#define QU_DLD_ICK 2219
#define QU_DLD_TAKE1 2214
#define QU_DLD_TAKE2 2215
#define QU_GLV_DRINK 2210
#define QU_GLV_DRINKBOTTLE 2286
#define QU_GLV_DRINK_NOHMR 2211
#define QU_GLV_HMRKICK 2207
#define QU_GLV_PROPOSE 2280
#define QU_GLV_PROPOSE_NOHMR 2281
#define QU_GLV_TAKEDOMINO 2170
#define QU_GLV_TAKEDOMINO_NOHMR 3182
#define QU_GLV_TOSMALL 2208
#define QU_GLV_TOSMALL_NOHMR 2209
#define QU_MLS_BLINK 2222
#define QU_MLS_HAND 2223
#define QU_MLS_TURNL 2220
#define QU_MLS_TURNR 2221
#define QU_SC38_SHOWBOTTLE 2199
#define QU_SC38_SHOWBOTTLE_ONTABLE 2838
#define QU_SC38_ENTERLIFT 2836
#define QU_SC38_EXITLIFT 2837

// Final scene
#define ANI_FIN_COIN 5014
#define MSG_FIN_ENDFINAL 5109
#define MSG_FIN_GOTO2 5024
#define MSG_FIN_GOTO3 5071
#define MSG_FIN_GOTO4 5075
#define MSG_FIN_STARTFINAL 5025
#define MSG_FN4_STARTMUSIC 5356
#define QU_FIN1_FALLCOIN 5018
#define QU_FIN1_TAKECOIN 5023
#define QU_FN2_DOFINAL 5066
#define QU_FN3_DOFINAL 5072
#define QU_FN4_DOFINAL 5108
#define ST_FCN_NORM 5017

// Debug scene
#define MSG_RESTARTGAME 4767
#define PIC_SCD_1 727
#define PIC_SCD_2 728
#define PIC_SCD_3 729
#define PIC_SCD_4 730
#define PIC_SCD_5 731
#define PIC_SCD_6 732
#define PIC_SCD_7 733
#define PIC_SCD_8 756
#define PIC_SCD_9 907
#define PIC_SCD_10 981
#define PIC_SCD_11 1098
#define PIC_SCD_12 857
#define PIC_SCD_13 1195
#define PIC_SCD_14 1224
#define PIC_SCD_15 1278
#define PIC_SCD_16 1299
#define PIC_SCD_17 1305
#define PIC_SCD_18 1306
#define PIC_SCD_19 1319
#define PIC_SCD_20 1622
#define PIC_SCD_21 1623
#define PIC_SCD_22 1624
#define PIC_SCD_23 1625
#define PIC_SCD_24 1845
#define PIC_SCD_25 1846
#define PIC_SCD_26 1847
#define PIC_SCD_27 1916
#define PIC_SCD_28 2098
#define PIC_SCD_29 2099
#define PIC_SCD_30 2359
#define PIC_SCD_31 2566
#define PIC_SCD_32 2312
#define PIC_SCD_33 2636
#define PIC_SCD_34 2389
#define PIC_SCD_35 2412
#define PIC_SCD_36 2567
#define PIC_SCD_37 2568
#define PIC_SCD_38 2228
#define PIC_SCD_FIN 5026
#define PIC_SCD_SEL 734

} // End of namespace Fullpipe

#endif /* FULLPIPE_CONSTANTS_H */
