(use gauche.test)
(use srfi-1)

(test-start "scmail.mailbox")
(use scmail.mailbox)
(use scmail.mh)
(use scmail.maildir)

(test-module 'scmail.mailbox)

(define mailbox-table
  '((mh      #f "Mail"    "inbox")
    (maildir #f "Maildir" "")))

(define (mailbox-list)
  (map second mailbox-table))

(define type-of     first)
(define object-of   second)
(define location-of third)
(define inbox-of    fourth)

(test "make-scmail-mailbox" #t
      (lambda ()
        (for-each (lambda (mailbox)
                    (let ((type (type-of mailbox))
                          (location (location-of  mailbox)))
                      (set-car! (cdr mailbox)
                                (make-scmail-mailbox type location))))
                  mailbox-table)
        (with-error-handler
         (lambda (e)
           ;; error should be occurred
           (print (ref e 'message))
           #t)
         (lambda ()
           (set! xxx-mailbox (make-scmail-mailbox 'xxx "/dev/null"))
           #f))))

(test "scmail-mailbox-mail-list" #t
      (lambda ()
        (every
         (lambda (mailbox)
           (= (length (scmail-mailbox-mail-list (object-of mailbox)
                                                (inbox-of mailbox)))
              8))
         mailbox-table)))


(test-end)
