# -*- warn-indent:false;  -*-

# line 1 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"

# line 710 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"


# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
# This file was generated from lib/regexp_parser/scanner/scanner.rl

class Regexp::Scanner
  # General scanner error (catch all)
  class ScannerError < StandardError; end

  # Base for all scanner validation errors
  class ValidationError < StandardError
    def initialize(reason)
      super reason
    end
  end

  # Unexpected end of pattern
  class PrematureEndError < ScannerError
    def initialize(where = '')
      super "Premature end of pattern at #{where}"
    end
  end

  # Invalid sequence format. Used for escape sequences, mainly.
  class InvalidSequenceError < ValidationError
    def initialize(what = 'sequence', where = '')
      super "Invalid #{what} at #{where}"
    end
  end

  # Invalid group. Used for named groups.
  class InvalidGroupError < ValidationError
    def initialize(what, reason)
      super "Invalid #{what}, #{reason}."
    end
  end

  # Invalid groupOption. Used for inline options.
  class InvalidGroupOption < ValidationError
    def initialize(option, text)
      super "Invalid group option #{option} in #{text}"
    end
  end

  # Invalid back reference. Used for name a number refs/calls.
  class InvalidBackrefError < ValidationError
    def initialize(what, reason)
      super "Invalid back reference #{what}, #{reason}"
    end
  end

  # The property name was not recognized by the scanner.
  class UnknownUnicodePropertyError < ValidationError
    def initialize(name)
      super "Unknown unicode character property name #{name}"
    end
  end

  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, &block)
    new.scan(input_object, &block)
  end

  def scan(input_object, &block)
    self.literal = nil
    stack = []

    if input_object.is_a?(Regexp)
      input = input_object.source
      self.free_spacing = (input_object.options & Regexp::EXTENDED != 0)
    else
      input = input_object
      self.free_spacing = false
    end


    data  = input.unpack("c*") if input.is_a?(String)
    eof   = data.length

    self.tokens = []
    self.block  = block_given? ? block : nil

    self.in_group = false
    self.group_depth = 0
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    in_set = false
    set_depth = 0
    in_conditional = false
    conditional_depth = 0
    conditional_stack = []

    
# line 104 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
	0, 0, -128, -65, -128, -65, 
	-128, -65, -128, -65, -128, 
	-65, -128, -65, 10, 10, 
	33, 126, 41, 41, 39, 122, 
	33, 122, 48, 122, 39, 
	60, 39, 122, 48, 57, 
	39, 57, 48, 57, 39, 57, 
	39, 122, 43, 122, 48, 
	57, 48, 62, 48, 57, 
	43, 62, 43, 122, 44, 125, 
	48, 125, 123, 123, 9, 
	122, 9, 125, 9, 122, 
	-128, -65, -128, -65, 38, 38, 
	45, 122, 45, 122, 93, 
	93, 94, 120, 97, 120, 
	108, 115, 110, 112, 117, 117, 
	109, 109, 58, 58, 93, 
	93, 104, 104, 97, 97, 
	99, 99, 105, 105, 105, 105, 
	108, 108, 97, 97, 110, 
	110, 107, 107, 110, 110, 
	116, 116, 114, 114, 108, 108, 
	105, 105, 103, 103, 105, 
	105, 116, 116, 114, 114, 
	97, 97, 112, 112, 104, 104, 
	111, 111, 119, 119, 101, 
	101, 114, 114, 114, 117, 
	105, 105, 110, 110, 110, 110, 
	99, 99, 112, 112, 97, 
	97, 99, 99, 101, 101, 
	112, 112, 112, 112, 111, 111, 
	114, 114, 100, 100, 100, 
	100, 65, 122, 61, 61, 
	93, 93, 45, 45, 77, 77, 
	45, 45, 45, 45, 67, 
	99, 45, 45, 77, 77, 
	45, 45, 48, 123, 48, 102, 
	48, 102, 48, 102, 48, 
	102, 9, 125, 9, 125, 
	9, 125, 9, 125, 9, 125, 
	9, 125, 48, 123, 41, 
	41, 39, 122, 41, 57, 
	48, 122, -62, 127, -62, -33, 
	-32, -17, -16, -12, 1, 
	127, 1, 127, 9, 32, 
	33, 126, 10, 126, 63, 63, 
	43, 63, 43, 63, 43, 
	63, 65, 122, 43, 63, 
	68, 119, 80, 112, -62, 125, 
	-128, -65, -128, -65, -128, 
	-65, 38, 38, 38, 93, 
	46, 61, 48, 122, 36, 125, 
	48, 55, 48, 55, 92, 
	92, 92, 92, 92, 92, 
	48, 102, 39, 60, 39, 122, 
	49, 57, 41, 57, 48, 
	122, 0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
	0, 64, 64, 64, 64, 64, 64, 1, 
	94, 1, 84, 90, 75, 22, 84, 10, 
	19, 10, 19, 84, 80, 10, 15, 10, 
	20, 80, 82, 78, 1, 114, 117, 114, 
	64, 64, 1, 78, 78, 1, 27, 24, 
	8, 3, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 4, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 58, 1, 
	1, 1, 1, 1, 1, 33, 1, 1, 
	1, 76, 55, 55, 55, 55, 117, 117, 
	117, 117, 117, 117, 76, 1, 84, 17, 
	75, 190, 30, 16, 5, 127, 127, 24, 
	94, 117, 1, 21, 21, 21, 58, 21, 
	52, 33, 188, 64, 64, 64, 1, 56, 
	16, 75, 90, 8, 8, 1, 1, 1, 
	55, 22, 84, 9, 17, 75
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
	0, 0, 65, 130, 195, 260, 325, 390, 
	392, 487, 489, 574, 665, 741, 764, 849, 
	860, 880, 891, 911, 996, 1077, 1088, 1104, 
	1115, 1136, 1217, 1300, 1379, 1381, 1496, 1614, 
	1729, 1794, 1859, 1861, 1940, 2019, 2021, 2049, 
	2074, 2083, 2087, 2089, 2091, 2093, 2095, 2097, 
	2099, 2101, 2103, 2105, 2107, 2109, 2111, 2113, 
	2115, 2117, 2119, 2121, 2123, 2125, 2127, 2129, 
	2131, 2133, 2135, 2137, 2139, 2141, 2143, 2145, 
	2150, 2152, 2154, 2156, 2158, 2160, 2162, 2164, 
	2166, 2168, 2170, 2172, 2174, 2176, 2178, 2237, 
	2239, 2241, 2243, 2245, 2247, 2249, 2283, 2285, 
	2287, 2289, 2366, 2422, 2478, 2534, 2590, 2708, 
	2826, 2944, 3062, 3180, 3298, 3375, 3377, 3462, 
	3480, 3556, 3747, 3778, 3795, 3801, 3929, 4057, 
	4082, 4177, 4295, 4297, 4319, 4341, 4363, 4422, 
	4444, 4497, 4531, 4720, 4785, 4850, 4915, 4917, 
	4974, 4991, 5067, 5158, 5167, 5176, 5178, 5180, 
	5182, 5238, 5261, 5346, 5356, 5374
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 0, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 0, 9, 8, 
	11, 10, 12, 10, 10, 10, 13, 14, 
	10, 10, 10, 10, 15, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 16, 10, 17, 11, 16, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	15, 10, 10, 15, 10, 10, 10, 10, 
	15, 10, 10, 10, 15, 10, 10, 10, 
	10, 10, 10, 10, 15, 10, 10, 15, 
	10, 10, 10, 10, 10, 16, 10, 18, 
	12, 16, 10, 10, 10, 10, 10, 10, 
	10, 10, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 10, 10, 10, 10, 
	10, 10, 10, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 10, 10, 10, 
	10, 13, 10, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 10, 11, 10, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 10, 
	10, 10, 11, 16, 10, 10, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	10, 10, 10, 10, 19, 10, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	10, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 10, 10, 10, 10, 16, 
	10, 10, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 10, 10, 10, 10, 
	19, 10, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 10, 21, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 22, 20, 23, 20, 20, 20, 
	24, 20, 25, 20, 20, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 20, 
	20, 20, 20, 20, 20, 20, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	20, 20, 20, 20, 26, 20, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	20, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 20, 23, 20, 20, 20, 
	20, 20, 20, 20, 20, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 20, 
	27, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 20, 23, 20, 20, 20, 24, 
	20, 24, 20, 20, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 20, 23, 
	20, 20, 20, 24, 20, 24, 20, 20, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 20, 20, 20, 20, 20, 20, 
	20, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 20, 20, 20, 20, 26, 
	20, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 20, 29, 20, 30, 20, 
	20, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 20, 20, 20, 20, 23, 
	20, 20, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 20, 20, 20, 20, 
	31, 20, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 20, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 20, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 20, 20, 20, 20, 23, 20, 
	32, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 20, 29, 20, 29, 20, 20, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 20, 20, 20, 20, 23, 20, 
	29, 20, 29, 20, 20, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 20, 
	20, 20, 20, 23, 20, 20, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	20, 20, 20, 20, 31, 20, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	20, 35, 34, 34, 34, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 37, 34, 35, 35, 35, 35, 
	35, 35, 35, 35, 35, 35, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 37, 34, 38, 39, 40, 40, 40, 
	40, 40, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 40, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 40, 40, 39, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 39, 39, 
	39, 40, 39, 39, 39, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 39, 
	39, 39, 41, 40, 39, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 39, 
	40, 40, 40, 40, 40, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 40, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 40, 40, 39, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 39, 39, 39, 40, 39, 39, 39, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 39, 39, 39, 39, 40, 39, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 39, 39, 42, 39, 40, 40, 
	40, 40, 40, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 40, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 40, 40, 39, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 39, 
	39, 39, 40, 39, 39, 39, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	39, 39, 39, 39, 40, 39, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	39, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 47, 46, 50, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 49, 49, 49, 49, 49, 
	49, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 49, 50, 51, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 49, 49, 49, 49, 49, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 49, 52, 49, 53, 49, 49, 
	54, 55, 56, 57, 49, 49, 58, 49, 
	49, 49, 49, 59, 49, 49, 49, 60, 
	49, 49, 61, 49, 62, 49, 63, 64, 
	49, 54, 55, 56, 57, 49, 49, 58, 
	49, 49, 49, 49, 59, 49, 49, 49, 
	60, 49, 49, 61, 49, 62, 49, 63, 
	64, 49, 65, 49, 49, 49, 49, 49, 
	49, 66, 49, 67, 49, 68, 49, 69, 
	49, 70, 49, 71, 49, 72, 49, 73, 
	49, 70, 49, 74, 49, 75, 49, 70, 
	49, 76, 49, 77, 49, 78, 49, 70, 
	49, 79, 49, 80, 49, 81, 49, 70, 
	49, 82, 49, 83, 49, 84, 49, 70, 
	49, 85, 49, 86, 49, 87, 49, 70, 
	49, 88, 49, 89, 49, 90, 49, 70, 
	49, 91, 49, 49, 92, 49, 93, 49, 
	84, 49, 94, 49, 84, 49, 95, 49, 
	96, 49, 97, 49, 70, 49, 98, 49, 
	89, 49, 99, 49, 100, 49, 70, 49, 
	57, 49, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 49, 49, 49, 49, 
	49, 49, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 49, 102, 49, 103, 
	49, 104, 39, 107, 106, 108, 106, 109, 
	39, 112, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 113, 111, 113, 111, 114, 111, 115, 
	111, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 39, 39, 39, 39, 39, 
	39, 39, 116, 116, 116, 116, 116, 116, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 116, 116, 116, 116, 116, 116, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 117, 39, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	39, 39, 39, 39, 39, 39, 39, 118, 
	118, 118, 118, 118, 118, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 118, 
	118, 118, 118, 118, 118, 39, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	39, 39, 39, 39, 39, 39, 39, 119, 
	119, 119, 119, 119, 119, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 119, 
	119, 119, 119, 119, 119, 39, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	39, 39, 39, 39, 39, 39, 39, 120, 
	120, 120, 120, 120, 120, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 120, 
	120, 120, 120, 120, 120, 39, 121, 121, 
	121, 121, 121, 121, 121, 121, 121, 121, 
	39, 39, 39, 39, 39, 39, 39, 121, 
	121, 121, 121, 121, 121, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 121, 
	121, 121, 121, 121, 121, 39, 117, 117, 
	117, 117, 117, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 117, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 39, 
	39, 39, 39, 39, 39, 39, 122, 122, 
	122, 122, 122, 122, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 122, 122, 
	122, 122, 122, 122, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 120, 39, 117, 117, 117, 117, 
	117, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 117, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 123, 123, 123, 123, 123, 
	123, 123, 123, 123, 123, 39, 39, 39, 
	39, 39, 39, 39, 123, 123, 123, 123, 
	123, 123, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 123, 123, 123, 123, 
	123, 123, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	120, 39, 117, 117, 117, 117, 117, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 117, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 124, 124, 124, 124, 124, 124, 124, 
	124, 124, 124, 39, 39, 39, 39, 39, 
	39, 39, 124, 124, 124, 124, 124, 124, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 124, 124, 124, 124, 124, 124, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 120, 39, 
	117, 117, 117, 117, 117, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 117, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 125, 
	125, 125, 125, 125, 125, 125, 125, 125, 
	125, 39, 39, 39, 39, 39, 39, 39, 
	125, 125, 125, 125, 125, 125, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	125, 125, 125, 125, 125, 125, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 120, 39, 117, 117, 
	117, 117, 117, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 117, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 39, 
	39, 39, 39, 39, 39, 39, 126, 126, 
	126, 126, 126, 126, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 126, 126, 
	126, 126, 126, 126, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 120, 39, 117, 117, 117, 117, 
	117, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 117, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	120, 39, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 127, 127, 127, 127, 
	127, 127, 127, 128, 128, 128, 128, 128, 
	128, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 128, 128, 128, 128, 128, 
	128, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 39, 127, 130, 
	129, 131, 129, 129, 129, 129, 129, 129, 
	129, 129, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 129, 129, 129, 129, 
	129, 129, 129, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 129, 129, 129, 
	129, 132, 129, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 129, 130, 129, 
	129, 129, 129, 129, 129, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 129, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 129, 129, 129, 129, 131, 129, 
	129, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 129, 129, 129, 129, 134, 
	129, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 129, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 137, 137, 137, 137, 137, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 138, 138, 138, 138, 138, 
	138, 138, 138, 139, 139, 139, 139, 139, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 140, 141, 141, 142, 143, 141, 
	141, 141, 144, 145, 146, 147, 141, 141, 
	148, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 149, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 150, 151, 34, 
	152, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 36, 153, 34, 
	141, 138, 34, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 154, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 154, 137, 137, 137, 137, 137, 
	154, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 138, 
	154, 138, 138, 138, 138, 138, 138, 138, 
	138, 139, 139, 139, 139, 139, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	140, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 138, 
	155, 140, 140, 140, 140, 140, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	155, 155, 155, 155, 155, 155, 155, 155, 
	140, 155, 141, 141, 141, 154, 141, 141, 
	141, 154, 154, 154, 154, 141, 141, 154, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	154, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 154, 154, 154, 154, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 154, 154, 154, 141, 
	154, 9, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	142, 142, 142, 8, 142, 142, 142, 8, 
	8, 8, 8, 142, 142, 8, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 8, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 8, 8, 8, 8, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 8, 8, 8, 142, 8, 157, 
	156, 159, 158, 158, 158, 158, 158, 158, 
	158, 158, 158, 158, 158, 158, 158, 158, 
	158, 158, 158, 158, 158, 159, 158, 161, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 161, 160, 163, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 163, 162, 165, 165, 164, 164, 164, 
	164, 165, 164, 164, 164, 166, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 165, 164, 164, 164, 
	164, 164, 164, 164, 165, 164, 164, 164, 
	164, 167, 164, 164, 164, 167, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 165, 164, 169, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 169, 168, 170, 39, 39, 39, 
	170, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 170, 170, 39, 39, 39, 170, 
	170, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 170, 39, 39, 39, 
	170, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 170, 39, 39, 39, 170, 
	39, 171, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 171, 39, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 174, 174, 174, 174, 174, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 175, 44, 176, 
	44, 175, 175, 175, 175, 44, 177, 175, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	175, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 178, 179, 180, 181, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 175, 175, 175, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	182, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 182, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 182, 184, 182, 186, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 187, 185, 190, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 191, 189, 189, 192, 189, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 193, 193, 193, 193, 193, 193, 193, 
	194, 194, 194, 193, 193, 193, 194, 193, 
	193, 193, 194, 193, 194, 193, 193, 193, 
	193, 194, 193, 193, 193, 193, 193, 194, 
	193, 194, 193, 193, 193, 193, 193, 193, 
	193, 193, 194, 193, 193, 193, 194, 193, 
	193, 193, 194, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 194, 193, 196, 195, 195, 195, 196, 
	196, 196, 196, 195, 195, 196, 195, 197, 
	198, 198, 198, 198, 198, 198, 198, 199, 
	199, 195, 195, 195, 195, 195, 196, 195, 
	39, 39, 200, 201, 195, 195, 39, 201, 
	195, 195, 39, 195, 202, 195, 195, 203, 
	195, 201, 201, 195, 195, 195, 201, 201, 
	195, 39, 196, 196, 196, 196, 195, 195, 
	204, 204, 104, 201, 204, 204, 39, 201, 
	195, 195, 39, 195, 195, 204, 195, 203, 
	195, 204, 201, 204, 205, 204, 201, 206, 
	195, 39, 196, 196, 196, 195, 208, 208, 
	208, 208, 208, 208, 208, 208, 207, 210, 
	210, 210, 210, 210, 210, 210, 210, 209, 
	213, 212, 216, 215, 217, 215, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	219, 219, 219, 219, 219, 219, 219, 220, 
	220, 220, 220, 220, 220, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 220, 
	220, 220, 220, 220, 220, 219, 222, 221, 
	221, 221, 221, 221, 223, 221, 221, 221, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 221, 221, 225, 221, 131, 226, 226, 
	226, 226, 226, 226, 226, 226, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	226, 226, 226, 226, 226, 226, 226, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 226, 226, 226, 226, 132, 226, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 132, 132, 132, 132, 132, 132, 132, 
	132, 226, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 226, 130, 226, 226, 226, 
	226, 226, 226, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 226, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	226, 226, 226, 226, 131, 226, 226, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 226, 226, 226, 226, 134, 226, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 226, 0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
	113, 114, 3, 115, 5, 6, 116, 113, 
	7, 113, 113, 113, 9, 10, 113, 113, 
	113, 11, 113, 12, 113, 14, 20, 113, 
	15, 17, 19, 16, 18, 21, 23, 25, 
	22, 24, 0, 27, 26, 127, 29, 0, 
	30, 31, 129, 130, 130, 32, 130, 130, 
	130, 130, 36, 37, 130, 39, 40, 51, 
	55, 59, 63, 67, 71, 76, 80, 82, 
	85, 41, 48, 42, 46, 43, 44, 45, 
	130, 47, 49, 50, 52, 53, 54, 56, 
	57, 58, 60, 61, 62, 64, 65, 66, 
	68, 69, 70, 72, 74, 73, 75, 77, 
	78, 79, 81, 83, 84, 87, 88, 130, 
	141, 138, 138, 91, 138, 142, 138, 138, 
	94, 143, 96, 138, 98, 101, 99, 100, 
	138, 102, 103, 104, 105, 106, 107, 138, 
	144, 145, 145, 109, 110, 111, 112, 1, 
	2, 4, 117, 118, 119, 120, 121, 113, 
	122, 113, 123, 124, 113, 125, 113, 126, 
	113, 113, 113, 113, 113, 8, 113, 113, 
	113, 113, 113, 113, 113, 113, 113, 13, 
	113, 113, 128, 28, 131, 132, 133, 130, 
	134, 135, 136, 130, 130, 130, 130, 33, 
	130, 130, 34, 130, 130, 130, 35, 38, 
	86, 137, 137, 138, 138, 139, 139, 138, 
	89, 138, 92, 138, 138, 97, 108, 138, 
	140, 138, 138, 138, 138, 90, 138, 138, 
	93, 95, 138, 138, 138, 145, 146, 147, 
	148, 149, 145
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
	1, 2, 0, 2, 0, 0, 2, 3, 
	0, 4, 5, 6, 7, 0, 8, 9, 
	10, 0, 11, 0, 12, 0, 0, 13, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 14, 0, 0, 0, 0, 0, 
	0, 0, 16, 17, 18, 0, 19, 20, 
	21, 22, 0, 0, 23, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	24, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 25, 
	26, 27, 28, 0, 29, 26, 30, 31, 
	0, 26, 0, 32, 0, 0, 0, 0, 
	33, 0, 0, 0, 0, 0, 0, 34, 
	0, 35, 36, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 26, 39, 
	40, 41, 0, 0, 42, 0, 43, 26, 
	44, 45, 46, 47, 48, 49, 50, 51, 
	52, 53, 54, 55, 56, 57, 58, 0, 
	59, 60, 62, 0, 0, 26, 26, 63, 
	0, 26, 26, 64, 65, 66, 67, 0, 
	68, 69, 0, 70, 71, 72, 0, 0, 
	0, 73, 74, 75, 76, 77, 78, 79, 
	0, 80, 0, 81, 82, 0, 0, 83, 
	0, 84, 85, 86, 87, 0, 88, 89, 
	0, 0, 90, 91, 92, 93, 26, 26, 
	26, 26, 94
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 37, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	61, 61, 61, 0, 0, 0, 0, 0, 
	0, 61, 61, 0, 0, 0, 0, 0, 
	0, 61, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 38, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	38, 38, 38, 0, 0, 0, 0, 0, 
	0, 38, 38, 0, 0, 0, 0, 0, 
	0, 38, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 14, 14, 15, 15, 15, 15, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 14, 0, 0, 14, 0, 0, 0, 
	0, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 14, 0, 0, 0, 0, 0, 
	0, 0, 14, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 8, 
	11, 11, 11, 11, 11, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 0, 0, 0, 0, 0, 0, 
	44, 44, 47, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 0, 106, 106, 0, 111, 111, 111, 
	111, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 130, 130, 130, 
	130, 0, 155, 155, 155, 155, 156, 156, 
	155, 155, 157, 159, 161, 163, 165, 169, 
	0, 0, 0, 183, 183, 183, 183, 186, 
	189, 0, 0, 208, 210, 212, 215, 215, 
	219, 0, 227, 227, 227, 227
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 113;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 113;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 128;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 129;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 130;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 137;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 138;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 145;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 113;


# line 808 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
    
# line 1131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

# line 809 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
    
# line 1144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs] 
	when 38 then
# line 1 "NONE"
		begin
ts = p
		end
# line 1172 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_re_scanner_trans_keys[_keys] <= _wide && 
			_wide <= _re_scanner_trans_keys[_keys + 1] 
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ] 
		 else 
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 14 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
	when 7 then
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1; in_group = group_depth > 0 ? true : false 		end
	when 26 then
# line 1 "NONE"
		begin
te = p+1
		end
	when 62 then
# line 12 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/char_type.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te, 1).first
      when '\d'; emit(:type, :digit,      text, ts - 1, te)
      when '\D'; emit(:type, :nondigit,   text, ts - 1, te)
      when '\h'; emit(:type, :hex,        text, ts - 1, te)
      when '\H'; emit(:type, :nonhex,     text, ts - 1, te)
      when '\s'; emit(:type, :space,      text, ts - 1, te)
      when '\S'; emit(:type, :nonspace,   text, ts - 1, te)
      when '\w'; emit(:type, :word,       text, ts - 1, te)
      when '\W'; emit(:type, :nonword,    text, ts - 1, te)
      when '\R'; emit(:type, :linebreak,  text, ts - 1, te)
      when '\X'; emit(:type, :xgrapheme,  text, ts - 1, te)
      else
        raise ScannerError.new(
          "Unexpected character in type at #{text} (char #{ts})")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 16 then
# line 16 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/property.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = data[ts+2..te-2].pack('c*').gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      raise UnknownUnicodePropertyError.new(name) unless token

      self.emit(type, token.to_sym, text, ts-1, te)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 65 then
# line 149 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      set_depth -= 1
      in_set = set_depth > 0 ? true : false

      emit(:set, :close, *text(data, ts, te))

      if set_depth == 0
        	begin
		cs = 113
		_goto_level = _again
		next
	end

      else
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      end
     end
		end
	when 70 then
# line 162 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      set_depth -= 1
      in_set = set_depth > 0 ? true : false

      emit(:literal, :literal, copy(data, ts..te-2), ts, te)
      emit(:set, :close, copy(data, ts+1..te-1), ts, te)

      if set_depth == 0
        	begin
		cs = 113
		_goto_level = _again
		next
	end

      else
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      end
     end
		end
	when 20 then
# line 176 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-', ts, te)
      emit(:set, :intersection, '&&', ts, te)
     end
		end
	when 66 then
# line 181 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first
      if tokens.last[1] == :open
        emit(:set, :negate, text, ts, te)
      else
        emit(:literal, :literal, text, ts, te)
      end
     end
		end
	when 68 then
# line 202 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :intersection, *text(data, ts, te))
     end
		end
	when 64 then
# line 206 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 137
		_goto_level = _again
		next
	end

     end
		end
	when 24 then
# line 217 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0].chr == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      emit(type, class_name.to_sym, text, ts, te)
     end
		end
	when 23 then
# line 230 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :collation, *text(data, ts, te))
     end
		end
	when 25 then
# line 234 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :equivalent, *text(data, ts, te))
     end
		end
	when 63 then
# line 238 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:literal, :literal, *text(data, ts, te))
     end
		end
	when 18 then
# line 246 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 69 then
# line 190 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = text(data, ts, te).first
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text, ts, te)
      else
        emit(:set, :range, text, ts, te)
      end
     end
		end
	when 72 then
# line 210 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      set_depth += 1

      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 130
		_goto_level = _again
		next
	end

     end
		end
	when 67 then
# line 246 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 19 then
# line 190 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = text(data, ts, te).first
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text, ts, te)
      else
        emit(:set, :range, text, ts, te)
      end
     end
		end
	when 22 then
# line 210 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      set_depth += 1

      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 130
		_goto_level = _again
		next
	end

     end
		end
	when 17 then
# line 246 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 74 then
# line 256 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 73 then
# line 261 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = 130;
      	begin
		stack[top] = cs
		top+= 1
		cs = 138
		_goto_level = _again
		next
	end

     end
		end
	when 79 then
# line 272 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      emit(:backref, :number, text, ts-1, te)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
# line 278 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 76 then
# line 283 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te, 1).first
      when '\.';  emit(:escape, :dot,               text, ts-1, te)
      when '\|';  emit(:escape, :alternation,       text, ts-1, te)
      when '\^';  emit(:escape, :bol,               text, ts-1, te)
      when '\$';  emit(:escape, :eol,               text, ts-1, te)
      when '\?';  emit(:escape, :zero_or_one,       text, ts-1, te)
      when '\*';  emit(:escape, :zero_or_more,      text, ts-1, te)
      when '\+';  emit(:escape, :one_or_more,       text, ts-1, te)
      when '\(';  emit(:escape, :group_open,        text, ts-1, te)
      when '\)';  emit(:escape, :group_close,       text, ts-1, te)
      when '\{';  emit(:escape, :interval_open,     text, ts-1, te)
      when '\}';  emit(:escape, :interval_close,    text, ts-1, te)
      when '\[';  emit(:escape, :set_open,          text, ts-1, te)
      when '\]';  emit(:escape, :set_close,         text, ts-1, te)
      when "\\\\";
        emit(:escape, :backslash, text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 82 then
# line 304 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = text(data, ts, te, 1).first
      when '\a'; emit(:escape, :bell,           text, ts-1, te)
      when '\b'; emit(:escape, :backspace,      text, ts-1, te)
      when '\e'; emit(:escape, :escape,         text, ts-1, te)
      when '\f'; emit(:escape, :form_feed,      text, ts-1, te)
      when '\n'; emit(:escape, :newline,        text, ts-1, te)
      when '\r'; emit(:escape, :carriage,       text, ts-1, te)
      when '\t'; emit(:escape, :tab,            text, ts-1, te)
      when '\v'; emit(:escape, :vertical_tab,   text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 33 then
# line 320 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      if text[2].chr == '{'
        emit(:escape, :codepoint_list, text, ts-1, te)
      else
        emit(:escape, :codepoint,      text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
# line 330 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 29 then
# line 339 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :control, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("control sequence")
        end
      else
        raise PrematureEndError.new("control sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 32 then
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :meta_sequence, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("meta sequence")
        end
      else
        raise PrematureEndError.new("meta sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 80 then
# line 369 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set ? 130 : 113));
      	begin
		stack[top] = cs
		top+= 1
		cs = 128
		_goto_level = _again
		next
	end

     end
		end
	when 81 then
# line 375 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set ? 130 : 113));
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 75 then
# line 381 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 84 then
# line 278 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
# line 330 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
# line 339 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :control, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("control sequence")
        end
      else
        raise PrematureEndError.new("control sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :meta_sequence, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("meta sequence")
        end
      else
        raise PrematureEndError.new("meta sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
# line 339 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :control, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("control sequence")
        end
      else
        raise PrematureEndError.new("control sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 31 then
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :meta_sequence, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("meta sequence")
        end
      else
        raise PrematureEndError.new("meta sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 83 then
# line 1 "NONE"
		begin
	case act
	when 18 then
	begin begin p = ((te))-1; end

      text = text(data, ts, te, 1).first
      emit(:backref, :number, text, ts-1, te)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 19 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end 
			end
	when 36 then
# line 391 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te-1).first
      emit(:conditional, :condition, text, ts, te-1)
      emit(:conditional, :condition_close, ')', te-1, te)
     end
		end
	when 93 then
# line 397 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 113
		_goto_level = _again
		next
	end

     end
		end
	when 94 then
# line 397 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 113
		_goto_level = _again
		next
	end

     end
		end
	when 35 then
# line 397 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 113
		_goto_level = _again
		next
	end

     end
		end
	when 42 then
# line 410 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:meta, :dot, *text(data, ts, te))
     end
		end
	when 45 then
# line 414 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if in_conditional and conditional_stack.length > 0 and
         conditional_stack.last[1] == group_depth
        emit(:conditional, :separator, *text(data, ts, te))
      else
        emit(:meta, :alternation, *text(data, ts, te))
      end
     end
		end
	when 44 then
# line 425 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :bol, *text(data, ts, te))
     end
		end
	when 39 then
# line 429 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :eol, *text(data, ts, te))
     end
		end
	when 58 then
# line 433 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:keep, :mark, *text(data, ts, te))
     end
		end
	when 57 then
# line 437 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '\\A'; emit(:anchor, :bos,                text, ts, te)
      when '\\z'; emit(:anchor, :eos,                text, ts, te)
      when '\\Z'; emit(:anchor, :eos_ob_eol,         text, ts, te)
      when '\\b'; emit(:anchor, :word_boundary,      text, ts, te)
      when '\\B'; emit(:anchor, :nonword_boundary,   text, ts, te)
      when '\\G'; emit(:anchor, :match_start,        text, ts, te)
      else
        raise ScannerError.new(
          "Unexpected character in anchor at #{text} (char #{ts})")
      end
     end
		end
	when 43 then
# line 453 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      set_depth += 1
      in_set = true

      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 130
		_goto_level = _again
		next
	end

     end
		end
	when 8 then
# line 465 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first

      in_conditional = true unless in_conditional
      conditional_depth += 1
      conditional_stack << [conditional_depth, group_depth]

      emit(:conditional, :open, text[0..-2], ts, te-1)
      emit(:conditional, :condition_open, '(', te-1, te)
      	begin
		stack[top] = cs
		top+= 1
		cs = 145
		_goto_level = _again
		next
	end

     end
		end
	when 9 then
# line 498 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = scan_options(p, data, ts, te)
     end
		end
	when 6 then
# line 508 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '(?=';  emit(:assertion, :lookahead,    text, ts, te)
      when '(?!';  emit(:assertion, :nlookahead,   text, ts, te)
      when '(?<='; emit(:assertion, :lookbehind,   text, ts, te)
      when '(?<!'; emit(:assertion, :nlookbehind,  text, ts, te)
      end
     end
		end
	when 10 then
# line 525 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '(?:';  emit(:group, :passive,      text, ts, te)
      when '(?>';  emit(:group, :atomic,       text, ts, te)
      when '(?~';  emit(:group, :absence,      text, ts, te)

      when /^\(\?<(\w*)>/
        empty_name_error(:group, 'named group (ab)') if $1.empty?

        emit(:group, :named_ab,  text, ts, te)

      when /^\(\?'(\w*)'/
        empty_name_error(:group, 'named group (sq)') if $1.empty?

        emit(:group, :named_sq,  text, ts, te)

      else
        raise ScannerError.new(
          "Unknown subexpression group format '#{text}'")
      end
     end
		end
	when 13 then
# line 577 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when /^\\([gk])<>/ # angle brackets
        empty_backref_error("ref/call (ab)")

      when /^\\([gk])''/ # single quotes
        empty_backref_error("ref/call (sq)")

      when /^\\([gk])<[^\d+-]\w*>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :name_ref_ab, text, ts, te)
        else
          emit(:backref, :name_call_ab, text, ts, te)
        end

      when /^\\([gk])'[^\d+-]\w*'/ #single quotes
        if $1 == 'k'
          emit(:backref, :name_ref_sq, text, ts, te)
        else
          emit(:backref, :name_call_sq, text, ts, te)
        end

      when /^\\([gk])<\d+>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :number_ref_ab, text, ts, te)
        else
          emit(:backref, :number_call_ab, text, ts, te)
        end

      when /^\\([gk])'\d+'/ # single quotes
        if $1 == 'k'
          emit(:backref, :number_ref_sq, text, ts, te)
        else
          emit(:backref, :number_call_sq, text, ts, te)
        end

      when /^\\(?:g<\+|g<-|(k)<-)\d+>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :number_rel_ref_ab, text, ts, te)
        else
          emit(:backref, :number_rel_call_ab, text, ts, te)
        end

      when /^\\(?:g'\+|g'-|(k)'-)\d+'/ # single quotes
        if $1 == 'k'
          emit(:backref, :number_rel_ref_sq, text, ts, te)
        else
          emit(:backref, :number_rel_call_sq, text, ts, te)
        end

      when /^\\k<[^\d+\-]\w*[+\-]\d+>/ # angle-brackets
        emit(:backref, :name_recursion_ref_ab, text, ts, te)

      when /^\\k'[^\d+\-]\w*[+\-]\d+'/ # single-quotes
        emit(:backref, :name_recursion_ref_sq, text, ts, te)

      when /^\\([gk])<[+\-]?\d+[+\-]\d+>/ # angle-brackets
        emit(:backref, :number_recursion_ref_ab, text, ts, te)

      when /^\\([gk])'[+\-]?\d+[+\-]\d+'/ # single-quotes
        emit(:backref, :number_recursion_ref_sq, text, ts, te)

      else
        raise ScannerError.new(
          "Unknown backreference format '#{text}'")
      end
     end
		end
	when 55 then
# line 648 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '?' ;  emit(:quantifier, :zero_or_one,            text, ts, te)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text, ts, te)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text, ts, te)
      end
     end
		end
	when 51 then
# line 656 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '*' ;  emit(:quantifier, :zero_or_more,            text, ts, te)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text, ts, te)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text, ts, te)
      end
     end
		end
	when 53 then
# line 664 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '+' ;  emit(:quantifier, :one_or_more,            text, ts, te)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text, ts, te)
      when '++';  emit(:quantifier, :one_or_more_possessive, text, ts, te)
      end
     end
		end
	when 60 then
# line 672 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:quantifier, :interval, *text(data, ts, te))
     end
		end
	when 4 then
# line 682 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if free_spacing
        emit(:free_space, :comment, *text(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 48 then
# line 547 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = text(data, ts, te).first
      emit(:group, :capture, text, ts, te)
     end
		end
	when 54 then
# line 648 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '?' ;  emit(:quantifier, :zero_or_one,            text, ts, te)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text, ts, te)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text, ts, te)
      end
     end
		end
	when 50 then
# line 656 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '*' ;  emit(:quantifier, :zero_or_more,            text, ts, te)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text, ts, te)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text, ts, te)
      end
     end
		end
	when 52 then
# line 664 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '+' ;  emit(:quantifier, :one_or_more,            text, ts, te)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text, ts, te)
      when '++';  emit(:quantifier, :one_or_more_possessive, text, ts, te)
      end
     end
		end
	when 59 then
# line 672 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:quantifier, :interval, *text(data, ts, te))
     end
		end
	when 56 then
# line 678 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 138
		_goto_level = _again
		next
	end

     end
		end
	when 47 then
# line 690 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :whitespace, *text(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 46 then
# line 705 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 5 then
# line 547 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = text(data, ts, te).first
      emit(:group, :capture, text, ts, te)
     end
		end
	when 12 then
# line 678 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 138
		_goto_level = _again
		next
	end

     end
		end
	when 3 then
# line 705 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      append_literal(data, ts, te)
     end
		end
	when 1 then
# line 1 "NONE"
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 54 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end 
			end
	when 71 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 210 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      set_depth += 1

      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 130
		_goto_level = _again
		next
	end

     end
		end
	when 21 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 210 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      set_depth += 1

      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 130
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 330 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 339 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :control, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("control sequence")
        end
      else
        raise PrematureEndError.new("control sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :meta_sequence, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("meta sequence")
        end
      else
        raise PrematureEndError.new("meta sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 339 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :control, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("control sequence")
        end
      else
        raise PrematureEndError.new("control sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 30 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      if data[te]
        c = data[te].chr
        if c =~ /[\x00-\x7F]/
          emit(:escape, :meta_sequence, copy(data, ts-1..te), ts-1, te+1)
          p += 1
        else
          raise InvalidSequenceError.new("meta sequence")
        end
      else
        raise PrematureEndError.new("meta sequence")
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 34 then
# line 136 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise InvalidSequenceError.new('sequence', text)
  		end
# line 335 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 49 then
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1; in_group = group_depth > 0 ? true : false 		end
# line 142 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1; in_group = true 		end
	when 11 then
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1; in_group = group_depth > 0 ? true : false 		end
# line 483 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:group, :comment, *text(data, ts, te))
     end
		end
	when 41 then
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1; in_group = group_depth > 0 ? true : false 		end
# line 552 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if in_conditional and conditional_stack.last and
         conditional_stack.last[1] == (group_depth + 1)

        emit(:conditional, :close, *text(data, ts, te))
        conditional_stack.pop

        if conditional_stack.length == 0
          in_conditional = false
        end
      else
        if spacing_stack.length > 1 and
          spacing_stack.last[:depth] == (group_depth + 1)
          spacing_stack.pop

          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, *text(data, ts, te))
      end
     end
		end
	when 40 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 142 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1; in_group = true 		end
	when 78 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 272 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 18;		end
	when 77 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 278 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 19;		end
	when 2 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 705 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 54;		end
# line 2680 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs] 
	when 61 then
# line 1 "NONE"
		begin
ts = nil;		end
	when 37 then
# line 1 "NONE"
		begin
ts = nil;		end
# line 1 "NONE"
		begin
act = 0
		end
# line 2698 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 15 then
# line 8 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/property.rl"
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 14 then
# line 130 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 2732 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 810 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"

    if cs == re_scanner_error
      text = ts ? copy(data, ts-1..-1) : data.pack('c*')
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{in_group}:#{group_depth}]") if in_group
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{in_set}:#{set_depth}]") if in_set

    # when the entire expression is a literal run
    emit_literal if literal

    tokens
  end

  # lazy-load property maps when first needed
  require 'yaml'
  PROP_MAPS_DIR = File.expand_path('../scanner/properties', __FILE__)

  def self.short_prop_map
    @short_prop_map ||= YAML.load_file("#{PROP_MAPS_DIR}/short.yml")
  end

  def self.long_prop_map
    @long_prop_map ||= YAML.load_file("#{PROP_MAPS_DIR}/long.yml")
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text, ts, te)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal

    if block
      block.call type, token, text, ts, te
    end

    tokens << [type, token, text, ts, te]
  end

  private

  attr_accessor :tokens, :literal, :block,
                :in_group, :group_depth,
                :free_spacing, :spacing_stack

  # Ragel's regex-based scan of the group options introduced a lot of
  # ambiguity, so we just ask it to find the beginning of what looks
  # like an options run and handle the rest in here.
  def scan_options(p, data, ts, te)
    text = text(data, ts, te).first

    options_char, options_length = true, 0

    # Copy while we have option characters. There is no maximum length,
    # as ruby allows things like '(?xxxxxxxxx-xxxxxxxxxxxxx:abc)'.
    negative_options = false
    while options_char
      if data[te + options_length]
        c = data[te + options_length].chr

        if c =~ /[-mixdau]/
          negative_options = true if c == '-'

          raise InvalidGroupOption.new(c, text) if negative_options and
            c =~ /[dau]/

          text << c ; p += 1 ; options_length += 1
        else
          options_char = false
        end
      else
        raise PrematureEndError.new("expression options `#{text}'")
      end
    end

    if data[te + options_length]
      c = data[te + options_length].chr

      if c == ':'
        # Include the ':' in the options text
        text << c ; p += 1 ; options_length += 1
        emit_options(text, ts, te + options_length)

      elsif c == ')'
        # Don't include the closing ')', let group_close handle it.
        emit_options(text, ts, te + options_length)

      else
        # Plain Regexp reports this as 'undefined group option'
        raise ScannerError.new(
          "Unexpected `#{c}' in options sequence, ':' or ')' expected")
      end
    else
      raise PrematureEndError.new("expression options `#{text}'")
    end

    p # return the new value of the data pointer
  end

  # Copy from ts to te from data as text
  def copy(data, range)
    data[range].pack('c*')
  end

  # Copy from ts to te from data as text, returning an array with the text
  #  and the offsets used to copy it.
  def text(data, ts, te, soff = 0)
    [copy(data, ts-soff..te-1), ts-soff, te]
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal. Contents can be a mix of ASCII and UTF-8.
  def append_literal(data, ts, te)
    self.literal = literal || []
    literal << text(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method,
  # using the total start (ts) and end (te) offsets of the run.
  def emit_literal
    ts, te = literal.first[1], literal.last[2]
    text = literal.map {|t| t[0]}.join

    text.force_encoding('utf-8') if text.respond_to?(:force_encoding)

    self.literal = nil
    emit(:literal, :literal, text, ts, te)
  end

  def emit_options(text, ts, te)
    token = nil

    if text =~ /\(\?([mixdau]*)-?([mix]*)(:)?/
      positive, negative, group_local = $1, $2, $3

      if positive.include?('x')
        self.free_spacing = true
      end

      # If the x appears in both, treat it like ruby does, the second cancels
      # the first.
      if negative.include?('x')
        self.free_spacing = false
      end

      if group_local
        spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
        token = :options
      else
        # switch for parent group level
        spacing_stack.last[:free_spacing] = free_spacing
        token = :options_switch
      end
    end

    emit(:group, token, text, ts, te)
  end

  # Centralizes and unifies the handling of validation related
  # errors.
  def validation_error(type, what, reason)
    case type
    when :group
      error = InvalidGroupError.new(what, reason)
    when :backref
      error = InvalidBackrefError.new(what, reason)
    when :sequence
      error = InvalidSequenceError.new(what, reason)
    else
      error = ValidationError.new('expression')
    end

    raise error # unless @@config.validation_ignore
  end

  # Used for references with an empty name or number
  def empty_backref_error(type, what)
    validation_error(:backref, what, 'ref ID is empty')
  end

  # Used for named expressions with an empty name
  def empty_name_error(type, what)
    validation_error(type, what, 'name is empty')
  end

end # module Regexp::Scanner
