/**********************************************************************
 * $my_monitor2 example -- C source code using TF PLI routines
 *
 * C source to call the misctf routine asynchronously whenever an
 * argument to a system task/function changes value, and then call the
 * misctf synchronously at the end of the simulation time step to
 * process all arguments that changed during that time step.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *   $my_monitor1(<signal_name>,<signal_name>,...);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_MyMonitor2_calltf(),
 *              PLIbook_MyMonitor2_misctf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_MyMonitor2_calltf,     /* calltf routine -/
 *     PLIbook_MyMonitor2_misctf,     /* misctf routine -/
 *     "$my_monitor2",                /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_MyMonitor2_calltf() {
  tf_asynchon();  /* enable asynchronous misctf callbacks */
  return(0); 
}

/**********************************************************************
 * misctf routine
 *********************************************************************/
int PLIbook_MyMonitor2_misctf(int user_data, int reason, int paramvc)
{
  int arg_num;
  
  if (reason == REASON_PARAMVC) {
    /* io_printf("At %s: change detected on tfarg %d\n",
              tf_strgettime(), paramvc); */
    tf_copypvc_flag(paramvc);
    tf_rosynchronize(); /* schedule a callback at end of time step */
  }

  if (reason == REASON_ROSYNCH) {
    io_printf("Reached end of time step %s:\n", tf_strgettime());
    if (tf_movepvc_flag(-1)) { /* only print if something changed */
      arg_num = 0;
      while (arg_num = tf_getpchange(arg_num) ) {
        io_printf("  tfarg %d changed to %s\n",
                  arg_num, tf_strgetp(arg_num,'b'));
      }
    io_printf("\n");
    }
  }
  return(0); 
}
/*********************************************************************/
