      SUBROUTINE AXISL(XLOW1,XHIGH1,XORG1,YLOW1,YHIGH1,YORG1,XTIC1,
     * YTIC1,SMXTC1,SMYTC1,LINTX,LINTY,XUNIT1,YUNIT1,CSIZE,ICODE)
*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
C**    @(#)axisl.f	1.1    3/10/88
C**
C**
C***********************************************************************
C**
C**                 PLOT+ Scientific Graphics System
C**
C***********************************************************************
C**
C**
C
C   SUBROUTINE AXISL WILL DRAW AND LABEL A SET OF AXES.
C   THE PARAMETERS ARE DEFINED AS FOLLOWS:
C   XLOW1,XLOW   -LOW X VALUE IN USER UNITS.
C   XHIGH1,XHIGH -HIGH X VALUE IN USER UNITS.
C   XORG1,XORG   -ORIGIN OF X AXIS (I.E. THE POINT AT WHICH THE Y
C                 AXIS WILL MEET OR CROSS THE X AXIS).
C   YLOW1,YLOW   -LOW Y VALUE IN USER UNITS.
C   YHIGH1,YHIGH -HIGH Y VALUE IN USER UNITS.
C   YORG1,YORG   -ORIGIN OF Y AXIS (I.E. THE POINT AT WHICH THE X
C                 AXIS WILL MEET OR CROSS THE Y AXIS).
C   XTIC1,XTIC   -THE DISTANCE IN USER UNITS BETWEEN MAJOR TICK MARKS
C                 ON THE X AXIS.
C   YTIC1,YTIC   -THE DISTANCE IN USER UNITS BETWEEN MAJOR TICK MARKS
C                 ON THE Y AXIS.
C   SMXTC1,SMXTIC-NUMBER OF MINOR TICKS BETWEEN MAJOR TICKS ON X AXIS.
C   SMYTC1,SMYTIC-NUMBER OF MINOR TICKS BETWEEN MAJOR TICKS ON Y AXIS.
C   LINTX        -LABELING INTERVAL ON THE X AXIS.
C                 IF LINTX = N, LABEL PLACED EVERY N-TH TICK MARK.
C                 IF LINTX = 0, NO LABELS WILL BE DRAWN.
C                 IF LINTX IS NEGATIVE, ONLY END POINTS WILL BE LABELED.
C   LINTY        -LABELING INTERVAL ON THE Y AXIS.
C   XUNIT1,XUNIT -FACTOR TO BE DIVIDED INTO LABELING VALUE ON X AXIS.
C   YUNIT1,YUNIT -FACTOR TO BE DIVIDED INTO LABELING VALUE ON Y AXIS.
C   CSIZE        -THE SIZE OF THE CHARACTERS FOR THE LABELS.
C   ICODE        -THE TYPE OF AXIS TO BE DRAWN
C                 0 = STANDARD X-Y AXIS.
C                 1 = SEMI LOG Y AXIS (X IS LINEAR).
C                 2 = SEMI LOG X AXIS (Y IS LINEAR).
C                 3 = LOG LOG AXIS.
C
C   OTHER VARIABLES USED IN THE ROUTINE ARE DEFINED AS:
C   AINC  -TEMPORARY VARIABLE USED TO COMPUTE LOG SCALE INCREMENTS.
C   BINC  -TEMPORARY VARIABLE USED TO COMPUTE LOG SCALE INCREMENTS.
C   CFLAG -FLAG INDICATING THAT THE LOG INCREMENTS HAVE BEEN COMPUTED.
C   CXSIZE-THE SIZE OF THE CHARACTERS FOR THE LABELS IN EQUIVALENT USER
C          UNITS ON THE X AXIS.
C   CYSIZE-THE SIZE OF THE CHARACTERS FOR THE LABELS IN EQUIVALENT USER
C          UNITS ON THE Y AXIS.
C   INC   -ARRAY OF 9 USED TO STORE THE LOG SCALE INCREMENTS.
C   INDEX -INDEX VARIABLE USED TO COMPARE TO LINTX (OR LINTY) TO
C          SEE THAT THE CORRECT LABELING INTERVAL IS USED.
C   LOGX  -FLAG INDICATING THAT THE X AXIS IS A LOG SCALE (LOGX=1).
C   LOGY  -FLAG INDICATING THAT THE Y AXIS IS A LOG SCALE (LOGY=1).
C   SXFLAG-FLAG WHICH INDICATES THAT THE X LOG AXIS HAS BEEN STARTED.
C          AFTER THE FIRST PART OF THE LOG AXIS IS DRAWN, ONLY WHOLE
C          CYCLES ARE DRAWN, EXCEPT MAYBE A PARTIAL CYCLE AT THE END.
C   SYFLAG-FLAG WHICH INDICATES THAT THE Y LOG AXIS HAS BEEN STARTED.
C          AFTER THE FIRST PART OF THE LOG AXIS IS DRAWN, ONLY WHOLE
C          CYCLES ARE DRAWN, EXCEPT MAYBE A PARTIAL CYCLE AT THE END.
C   TEMP  -TEMPORARY VARIABLE USED SEVERAL TIMES.
C   XHI   -USED TO DRAW X LOG AXIS.  EQUALS ALOG10 OF XHIGH.
C   XINC  -THE DISTANCE IN USER UNITS BETWEEN MINOR TICK MARKS ON
C          THE X AXIS (XTIC/(SMXTIC+1)).
C   XLAB  -CONTAINS THE BCD REPRESENTATION OF THE X LABEL BEING PASSED
C          TO SYMBOL.
C   XOFF  -THE X OFFSET OF LABELS ON THE Y AXIS.
C   XPOS  -THE CURRENT X POSITION, USUALLY EQUALS XPT MINUS A FRACTION
C          OF AN INCH (USED FOR LABELING).
C   XPT   -THE CURRENT X VALUE, USED FOR MANY THINGS.
C   XPTS  -TEMPORARY VARIABLE USED IN LABELING, EQUALS XPT/XUNIT.
C   YHI   -USED TO DRAW Y LOG AXIS.  EQUALS ALOG10 OF YHIGH.
C   YINC  -THE DISTANCE IN USER UNITS BETWEEN MINOR TICK MARKS ON
C          THE Y AXIS (YTIC/(SMYTIC+1)).
C   YLAB  -CONTAINS THE BCD REPRESENTATION OF THE Y LABEL BEING PASSED
C          TO SYMBOL.
C   YOFF  -THE Y OFFSET OF LABELS ON THE X AXIS.
C   YPOS  -THE CURRENT Y POSITION, USUALLY EQUALS YPT MINUS A FRACTION
C          OF AN INCH (USED FOR LABELING).
C   YPT   -THE CURRENT Y VALUE, USED FOR MANY THINGS.
C   YPTS  -TEMPORARY VARIABLE USED IN LABELING, EQUALS YPT/YUNIT.
C
      REAL INC(9)
      INTEGER SXFLAG,SYFLAG,CFLAG,SMXTIC,SMYTIC,SMXTC1,SMYTC1
C
	CHARACTER IFMT*6,XLAB*8,YLAB*8
#ifdef unix
	include 'PLTCOM.DAT'
#else
	include 'pplinc:PLTCOM.DAT'
#endif
C
C******************************************************************
C   AXISL MAKES SEVERAL CHECKS ON THE PARAMETERS TO MAKE SURE THAT
C   THEY ARE VALID.   THEY ARE ALTERED INTERNALLY IF NECESSARY.
C******************************************************************
C
C   TRANSFER THE PARAMETERS TO NEW VARIABLES.
C
      XLOW=XLOW1
      XHIGH=XHIGH1
      XORG=XORG1
      YLOW=YLOW1
      YHIGH=YHIGH1
      YORG=YORG1
      XTIC=ABS(XTIC1)
      YTIC=ABS(YTIC1)
      SMXTIC=SMXTC1
      SMYTIC=SMYTC1
      XUNIT=XUNIT1
      YUNIT=YUNIT1
C
C   GET THE ADJUSTED CHARACTER SIZES.
C
      CXSIZE=CSIZE*FACTOR/XSCALE
      CYSIZE=CSIZE*FACTOR/YSCALE
C
C   CHECK THE CALLING PARAMETERS.  MAKE SURE THEY ARE LEGAL.
C
      IF(SMXTIC .LT. 0) SMXTIC=0
      IF(SMYTIC .LT. 0) SMYTIC=0
      IF(XUNIT .EQ. 0.) XUNIT=1.
      IF(YUNIT .EQ. 0.) YUNIT=1.
C
C   IF THE LOW IS BIGGER THAN THE HIGH, THEN CHANGE THEM.
C
      IF(XLOW .LE. XHIGH) GO TO 10
      TEMP=XLOW
      XLOW=XHIGH
      XHIGH=TEMP
10    IF(YLOW .LE. YHIGH) GO TO 20
      TEMP=YLOW
      YLOW=YHIGH
      YHIGH=TEMP
C
C   MAKE SURE THE ORIGIN IS BETWEEN THE HIGH AND THE LOW.
C
20    IF(XORG .LT. XLOW) XORG=XLOW
      IF(XORG .GT. XHIGH) XORG=XHIGH
      IF(YORG .LT. YLOW) YORG=YLOW
      IF(YORG .GT. YHIGH) YORG=YHIGH
C
C   SET SOME FLAGS
C
      SXFLAG=0
      SYFLAG=0
      CFLAG=0
C
C   SEE IF THE X OR Y AXES ARE LOG SCALES. IF SO, SET A FLAG.
C
      LOGX=0
      LOGY=0
      IF(ICODE.EQ.2 .OR. ICODE.EQ.3) LOGX=1
      IF(ICODE.EQ.1 .OR. ICODE.EQ.3) LOGY=1
C
C   COMPUTE DISTANCE BETWEEN MINOR TICK MARKS
C
      XINC=XTIC
      YINC=YTIC
      IF(SMXTIC .NE. 0) XINC=XTIC/FLOAT(SMXTIC+1)
      IF(SMYTIC .NE. 0) YINC=YTIC/FLOAT(SMYTIC+1)
C
C   SET VECTRS MODE.
C
      CALL VECTRS
      YOFF=CYSIZE+70.0/YSCALE
      IF(LOGX .EQ. 1) GO TO 200
C
C******************************************************************
C   DRAW AND LABEL LINEAR X AXIS
C******************************************************************
C
      IF(LINTX .EQ. 0) GO TO 30
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(XHIGH.GE.99999.995 .OR. XLOW.LE.-9999.995) IFMT='(E8.2)'
      XPT=XTIC*FLOAT(LINTX)
      IF(XPT .LE. 0.) XPT=XHIGH-XLOW
      IF(XPT .LT. 0.00995) IFMT='(E8.2)'
30    YPT=YORG
      IF(LOGY.EQ.1) YPT=ALOG10(YPT)
      YPOS=YORG-YOFF
      IF(LOGY.EQ.1) YPOS=ALOG10(YORG)-YOFF
      XPT=XLOW
      CALL PLOT(XPT,YPT,0,0)
      CALL PLOT(XPT,YPT,1,8)
      IF(LINTX .EQ. 0) GO TO 60
40    XPTS=XPT/XUNIT
	WRITE(XLAB,IFMT)XPTS
      XPOS=XPT-5.*CXSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,XLAB)
      CALL PLOT(XPT,YPT,0,0)
60    IF(XTIC .EQ. 0.) GO TO 90
      INDEX=0
      CALL PLOT(XPT,YPT,0,0)
C
C   DO THE SMALL TICK MARKS, IF ANY.
C
70    IF(SMXTIC .EQ. 0) GO TO 85
      DO 80 I=1,SMXTIC
      XPT=XPT+XINC
      IF(XPT .GT. XHIGH) GO TO 90
80    CALL PLOT(XPT,YPT,1,7)
C
C   NOW DO THE LARGE TICK MARK.
C
85    XPT=XPT+XINC
      IF(XPT .GT. XHIGH) GO TO 90
      CALL PLOT(XPT,YPT,1,8)
C
C   SEE IF IT IS TIME TO LABEL.
C
      IF(LINTX .LE. 0) GO TO 70
      INDEX=INDEX+1
      IF(INDEX .LT. LINTX) GO TO 70
      GO TO 40
C
C   DRAW AND LABEL THE LAST TICK MARK.
C
90    XPT=XHIGH
      CALL PLOT(XPT,YPT,1,8)
      IF(LINTX .GE. 0) GO TO 300
      XPTS=XPT/XUNIT
      GO TO 270
C
C******************************************************************
C   DRAW AND LABEL LOG X AXIS
C******************************************************************
C
C
C   COMPUTE THE INCREMENTS FOR A LOG AXIS.
C
200   AINC=1.
      BINC=2.
      DO 205 I=1,9
      INC(I)=ALOG10(BINC)-ALOG10(AINC)
      AINC=AINC+1.
205   BINC=BINC+1.
      CFLAG=1
      YPT=YORG
      IF(LOGY.EQ.1) YPT=ALOG10(YPT)
      YPOS=YORG-YOFF
      IF(LOGY.EQ.1) YPOS=ALOG10(YORG)-YOFF
      XHI=ALOG10(XHIGH)
      XPT=ALOG10(XLOW)
      CALL PLOT(XPT,YPT,0,0)
      CALL PLOT(XPT,YPT,1,8)
      IF(LINTX .GE. 0) GO TO 220
210   XPTS=(10.**XPT)/XUNIT
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(XPTS.GE.99999.995 .OR. XPTS.LT.0.00995) IFMT='(E8.2)'
	WRITE(XLAB,IFMT)XPTS
      XPOS=XPT-5.*CXSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,XLAB)
      CALL PLOT(XPT,YPT,0,0)
220   IF(XTIC .EQ. 0.) GO TO 260
      INDEX=0
      CALL PLOT(XPT,YPT,0,0)
C
C   WE START THE LOG AXIS AT XPT WHICH CURRENTLY EQUALS ALOG10(XLOW).
C   DRAW AND PUT TICK MARKS ON UNTIL THE FIRST CYCLE IS REACHED (...,
C   0.01,0.1,1.,10.,100.,...).  LABEL THIS FIRST CYCLE AND SET A
C   FLAG INDICATING THE AXIS HAS BEEN STARTED (SXFLAG=1).  THE REST
C   OF THE AXIS WILL BE DRAWN WITH WHOLE LOG CYCLES, EXCEPT OF COURSE
C   THE END WHICH IS FROM THE LAST WHOLE CYCLE UNTIL ALOG10(XHIGH)
C
      IF(SXFLAG .EQ. 1) GO TO 240
      TEMP=IFIX(XPT)
      IF(TEMP .GT. XPT) TEMP=TEMP-1.
      DO 230 I=1,8
      TEMP=TEMP+INC(I)
      IF(TEMP .LT. XPT) GO TO 230
      IF(TEMP .GE. XHI) GO TO 260
      CALL PLOT(TEMP,YPT,1,7)
230   CONTINUE
      XPT=TEMP
      SXFLAG=1
      GO TO 255
C
C   DO THE MINOR TICK MARKS.
C
240   DO 250 I=1,8
      XPT=XPT+INC(I)
      IF(XPT .GT. XHI) GO TO 260
250   CALL PLOT(XPT,YPT,1,7)
C
C   NOW THE MAJOR TICK MARK.
C
255   XPT=XPT+INC(9)
      IF(XPT .GT. XHI) GO TO 260
      CALL PLOT(XPT,YPT,1,8)
C
C   SEE IF IT IS TIME TO LABEL.
C
      IF(LINTX .LE. 0) GO TO 240
      INDEX=INDEX+1
      IF(INDEX .LT. LINTX) GO TO 240
      GO TO 210
C
C   DRAW AND LABEL THE LAST TICK MARK.
C
260   XPT=XHI
      CALL PLOT(XPT,YPT,1,8)
      IF(LINTX .GE. 0) GO TO 300
      XPTS=(10.**XPT)/XUNIT
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(XPTS.GE.99999.995 .OR. XPTS.LT.0.00995) IFMT='(E8.2)'
270	WRITE(XLAB,IFMT)XPTS
      XPOS=XPT-5.*CXSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,XLAB)
300   XOFF=8.0*CXSIZE+100.0/XSCALE
      IF(LOGY .EQ. 1) GO TO 400
C
C******************************************************************
C   DRAW AND LABEL LINEAR Y AXIS
C******************************************************************
C
      IF(LINTY .EQ. 0) GO TO 305
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(YHIGH.GE.99999.995 .OR. YLOW.LE.-9999.995) IFMT='(E8.2)'
      YPT=YTIC*FLOAT(LINTY)
      IF(YPT .LE. 0.) YPT=YHIGH-YLOW
      IF(YPT .LT. 0.00995) IFMT='(E8.2)'
305   XPT=XORG
      IF(LOGX.EQ.1) XPT=ALOG10(XPT)
      XPOS=XORG-XOFF
      IF(LOGX.EQ.1) XPOS=ALOG10(XORG)-XOFF
      YPT=YLOW
      CALL PLOT(XPT,YPT,0,0)
      CALL PLOT(XPT,YPT,1,6)
      IF(LINTY .EQ. 0) GO TO 320
310   YPTS=YPT/YUNIT
	WRITE(YLAB,IFMT)YPTS
      YPOS=YPT-0.5*CYSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,YLAB)
      CALL PLOT(XPT,YPT,0,0)
320   IF(YTIC .EQ. 0.) GO TO 350
      INDEX=0
      CALL PLOT(XPT,YPT,0,0)
C
C   DO THE SMALL TICK MARKS, IF ANY.
C
330   IF(SMYTIC .EQ. 0) GO TO 345
      DO 340 I=1,SMYTIC
      YPT=YPT+YINC
      IF(YPT .GT. YHIGH) GO TO 350
340   CALL PLOT(XPT,YPT,1,5)
C
C   NOW DO THE LARGE TICK MARK.
C
345   YPT=YPT+YINC
      IF(YPT .GT. YHIGH) GO TO 350
      CALL PLOT(XPT,YPT,1,6)
C
C   SEE IF IT IS TIME TO LABEL.
C
      IF(LINTY .LE. 0) GO TO 330
      INDEX=INDEX+1
      IF(INDEX .LT. LINTY) GO TO 330
      GO TO 310
C
C   DRAW AND LABEL THE LAST TICK MARK.
C
350   YPT=YHIGH
      CALL PLOT(XPT,YPT,1,6)
      IF(LINTY .GE. 0) GO TO 500
      YPTS=YPT/YUNIT
      GO TO 470
C
C******************************************************************
C   DRAW AND LABEL LOG Y AXIS
C******************************************************************
C
C
C   COMPUTE THE INCREMENTS FOR A LOG AXIS, IF NECESSARY.
C
400   IF(CFLAG.EQ.1) GO TO 406
      AINC=1.
      BINC=2.
      DO 405 I=1,9
      INC(I)=ALOG10(BINC)-ALOG10(AINC)
      AINC=AINC+1.
405   BINC=BINC+1.
406   XPT=XORG
      IF(LOGX.EQ.1) XPT=ALOG10(XPT)
      XPOS=XORG-XOFF
      IF(LOGX.EQ.1) XPOS=ALOG10(XORG)-XOFF
      YHI=ALOG10(YHIGH)
      YPT=ALOG10(YLOW)
      CALL PLOT(XPT,YPT,0,0)
      CALL PLOT(XPT,YPT,1,6)
      IF(LINTY .GE. 0) GO TO 420
410   YPTS=(10.**YPT)/YUNIT
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(YPTS.GE.99999.995 .OR. YPTS.LT.0.00995) IFMT='(E8.2)'
	WRITE(YLAB,IFMT)YPTS
      YPOS=YPT-0.5*CYSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,YLAB)
      CALL PLOT(XPT,YPT,0,0)
420   IF(YTIC .EQ. 0.) GO TO 460
      INDEX=0
      CALL PLOT(XPT,YPT,0,0)
C
C   WE START THE LOG AXIS AT YPT WHICH CURRENTLY EQUALS ALOG10(YLOW).
C   DRAW AND PUT TICK MARKS ON UNTIL THE FIRST CYCLE IS REACHED (...,
C   0.01,0.1,1.,10.,100.,...).  LABEL THIS FIRST CYCLE AND SET A
C   FLAG INDICATING THE AXIS HAS BEEN STARTED (SYFLAG=1).  THE REST
C   OF THE AXIS WILL BE DRAWN WITH WHOLE LOG CYCLES, EXCEPT OF COURSE
C   THE END WHICH IS FROM THE LAST WHOLE CYCLE UNTIL ALOG10(YHIGH)
C
      IF(SYFLAG .EQ. 1) GO TO 440
      TEMP=IFIX(YPT)
      IF(TEMP .GT. YPT) TEMP=TEMP-1.
      DO 430 I=1,8
      TEMP=TEMP+INC(I)
      IF(TEMP .LT. YPT) GO TO 430
      IF(TEMP .GE. YHI) GO TO 460
      CALL PLOT(XPT,TEMP,1,5)
430   CONTINUE
      YPT=TEMP
      SYFLAG=1
      GO TO 455
C
C   DO THE MINOR TICK MARKS.
C
440   DO 450 I=1,8
      YPT=YPT+INC(I)
      IF(YPT .GT. YHI) GO TO 460
450   CALL PLOT(XPT,YPT,1,5)
C
C   NOW THE MAJOR TICK MARK.
C
455   YPT=YPT+INC(9)
      IF(YPT .GT. YHI) GO TO 460
      CALL PLOT(XPT,YPT,1,6)
C
C   SEE IF IT IS TIME TO LABEL.
C
      IF(LINTY .LE. 0) GO TO 440
      INDEX=INDEX+1
      IF(INDEX .LT. LINTY) GO TO 440
      GO TO 410
C
C   DRAW AND LABEL THE LAST TICK MARK.
C
460   YPT=YHI
      CALL PLOT(XPT,YPT,1,6)
      IF(LINTY .GE. 0) GO TO 500
      YPTS=(10.**YPT)/YUNIT
C
C   IF THE LABEL FITS INTO AN F8.2 FORMAT, USE IT. OTHERWISE USE E8.2
C
      IFMT='(F8.2)'
      IF(YPTS.GE.99999.995 .OR. YPTS.LT.0.00995) IFMT='(E8.2)'
470	WRITE(YLAB,IFMT)YPTS
      YPOS=YPT-0.5*CYSIZE
      CALL SYMBOL(XPOS,YPOS,0.,CSIZE,8,YLAB)
C
C   MOVE TO THE ORIGIN.
C
500   XPT=XORG
      IF(LOGX.EQ.1) XPT=ALOG10(XORG)
      YPT=YORG
      IF(LOGY.EQ.1) YPT=ALOG10(YORG)
      CALL PLOT(XPT,YPT,0,0)
      RETURN
      END
