/*
 *  Copyright © 2017-2020 Wellington Wallace
 *
 *  This file is part of PulseEffects.
 *
 *  PulseEffects is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  PulseEffects is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with PulseEffects.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GST_PEAUTOGAIN_H
#define GST_PEAUTOGAIN_H

#include <ebur128.h>
#include <gst/audio/gstaudiofilter.h>
#include <mutex>

G_BEGIN_DECLS

#define GST_TYPE_PEAUTOGAIN (gst_peautogain_get_type())
#define GST_PEAUTOGAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), GST_TYPE_PEAUTOGAIN, GstPeautogain))
#define GST_PEAUTOGAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), GST_TYPE_PEAUTOGAIN, GstPeautogainClass))
#define GST_IS_PEAUTOGAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), GST_TYPE_PEAUTOGAIN))
#define GST_IS_PEAUTOGAIN_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass), GST_TYPE_PEAUTOGAIN))

struct GstPeautogain {
  GstAudioFilter base_peautogain;

  /* properties */

  float target;     // target loudness level
  int weight_m;     // momentary loudness weight
  int weight_s;     // short term loudness weight
  int weight_i;     // integrated loudness weight
  float momentary;  // momentary value
  float shortterm;  // short term value
  float global;     // integrated value
  float relative;   // relative threshold
  float loudness;   // estimated loudness
  float gain;       // correction gain
  float range;      // loudness range
  bool detect_silence, reset, use_geometric_mean;

  /* < private > */

  bool ready, notify;
  int bpf;   // bytes per frame : channels * bps
  int rate;  // sampling rate

  uint notify_samples;  // number of samples to count before emit a notify
  uint sample_count;
  ebur128_state* ebur_state = nullptr;

  std::mutex lock_guard_ebu;
};

struct GstPeautogainClass {
  GstAudioFilterClass base_peautogain_class;
};

GType gst_peautogain_get_type(void);

G_END_DECLS

#endif
