/* OpenCL built-in library: acos()

   Copyright (c) 2015 Michal Babej / Tampere University of Technology

   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.
*/

#include "hsail_templates.h"

#include "vml_constants.h"

double _CL_OVERLOADABLE _cl_atan2k(double y, double x);

float _CL_OVERLOADABLE _cl_atan2k(float y, float x);

MULSIGN(float, uint, PROPS_FLOAT_SIGNBIT_MASK)

MULSIGN(double, ulong, PROPS_DOUBLE_SIGNBIT_MASK)

IMPLEMENT_EXPR_ALL_SINGLE(acos, V_V, \
  mulsign(_cl_atan2k(sqrt(((vtype)(1.0)+a)*((vtype)(1.0)-a)), fabs(a)), a) \
     + ((a < (vtype)(0.0)) ? (vtype)(M_PI) : (vtype)(0.0)))
