# pgBackRest Test Certificates

The certificates in this directory are used for testing purposes only and are not used for actual services.  They are used only by the unit and integration tests and there should be no reason to modify them unless new tests are required.

## Generating the Test CA (pgbackrest-test-ca.crt/key)

This is a self-signed CA that is used to sign all server certificates.  No intermediate CAs will be generated since they are not needed for testing.

```
cd [pgbackrest-root]/test/certificate
openssl genrsa -out pgbackrest-test-ca.key 4096
openssl req -new -x509 -extensions v3_ca -key pgbackrest-test-ca.key -out pgbackrest-test-ca.crt -days 99999 \
    -subj "/C=US/ST=All/L=All/O=pgBackRest/CN=test.pgbackrest.org"
openssl x509 -in pgbackrest-test-ca.crt -text -noout
```

## Generating the Test Key (pgbackrest-test.key)

This key will be used for all server certificates to keep things simple.

```
cd [pgbackrest-root]/test/certificate
openssl genrsa -out pgbackrest-test.key 4096
```

## Generating the Alt Name Test Certificate (pgbackrest-test-alt-name.crt)

This certificate will include alternate names and will only be used in unit tests to check alternate name verification functionality.

```
cd [pgbackrest-root]/test/certificate
openssl req -new -sha256 -nodes -out pgbackrest-test-alt-name.csr -key pgbackrest-test.key -config pgbackrest-test-alt-name.cnf
openssl x509 -req -in pgbackrest-test-alt-name.csr -CA pgbackrest-test-ca.crt -CAkey pgbackrest-test-ca.key -CAcreateserial \
    -out pgbackrest-test-alt-name.crt -days 99999 -extensions v3_req -extfile pgbackrest-test-alt-name.cnf
openssl x509 -in pgbackrest-test-alt-name.crt -text -noout
```

## Generating the Test Certificate (pgbackrest-test.crt)

This certificate will be used in unit and integration tests.  It is expected to pass verification but won't be subjected to extensive testing.

```
cd [pgbackrest-root]/test/certificate
openssl req -new -sha256 -nodes -out pgbackrest-test.csr -key pgbackrest-test.key -config pgbackrest-test.cnf
openssl x509 -req -in pgbackrest-test.csr -CA pgbackrest-test-ca.crt -CAkey pgbackrest-test-ca.key -CAcreateserial \
    -out pgbackrest-test.crt -days 99999 -extensions v3_req -extfile pgbackrest-test.cnf
openssl x509 -in pgbackrest-test.crt -text -noout
```
