/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.hanim;

import javax.vecmath.Matrix4f;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimObjectParent;

public class HAnimSite
extends HAnimObject {
    private static final String MIN_ARRAY_SIZE_MSG = "The source array is either null or not long enough";
    private float[] center = new float[3];
    private float[] rotation = new float[4];
    private float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    private float[] scaleOrientation = new float[4];
    private float[] translation = new float[3];
    protected Object[] children;
    protected int numChildren;
    protected Matrix4f localMatrix;
    protected Matrix4f globalMatrix;
    private HAnimObjectParent parent;
    private boolean updateSent;
    protected boolean matrixChanged;

    public HAnimSite() {
        this.rotation[2] = 1.0f;
        this.scaleOrientation[2] = 1.0f;
        this.localMatrix = new Matrix4f();
        this.globalMatrix = new Matrix4f();
        this.matrixChanged = false;
        this.updateSent = false;
    }

    public void getCenter(float[] fArray) {
        fArray[0] = this.center[0];
        fArray[1] = this.center[1];
        fArray[2] = this.center[2];
    }

    public void setCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.center[0] = fArray[0];
        this.center[1] = fArray[1];
        this.center[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getScale(float[] fArray) {
        fArray[0] = this.scale[0];
        fArray[1] = this.scale[1];
        fArray[2] = this.scale[2];
    }

    public void setScale(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.scale[0] = fArray[0];
        this.scale[1] = fArray[1];
        this.scale[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getTranslation(float[] fArray) {
        fArray[0] = this.translation[0];
        fArray[1] = this.translation[1];
        fArray[2] = this.translation[2];
    }

    public void setTranslation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.translation[0] = fArray[0];
        this.translation[1] = fArray[1];
        this.translation[2] = fArray[2];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getScaleOrientation(float[] fArray) {
        fArray[0] = this.scaleOrientation[0];
        fArray[1] = this.scaleOrientation[1];
        fArray[2] = this.scaleOrientation[2];
        fArray[3] = this.scaleOrientation[3];
    }

    public void setScaleOrientation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.scaleOrientation[0] = fArray[0];
        this.scaleOrientation[1] = fArray[1];
        this.scaleOrientation[2] = fArray[2];
        this.scaleOrientation[3] = fArray[3];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public void getRotation(float[] fArray) {
        fArray[0] = this.rotation[0];
        fArray[1] = this.rotation[1];
        fArray[2] = this.rotation[2];
        fArray[3] = this.rotation[3];
    }

    public void setRotation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(MIN_ARRAY_SIZE_MSG);
        }
        this.rotation[0] = fArray[0];
        this.rotation[1] = fArray[1];
        this.rotation[2] = fArray[2];
        this.rotation[3] = fArray[3];
        this.matrixChanged = true;
        this.sendUpdateMsg();
    }

    public int numChildren() {
        return this.numChildren;
    }

    public void getChildren(Object[] objectArray) {
        System.arraycopy(this.children, 0, objectArray, 0, this.numChildren);
    }

    public void setChildren(Object[] objectArray, int n) {
        if (this.children == null || this.children.length < n) {
            this.children = new Object[n];
        }
        if (n != 0) {
            System.arraycopy(objectArray, 0, this.children, 0, n);
        }
        for (int i = n; i < this.numChildren; ++i) {
            this.children[i] = null;
        }
        this.numChildren = n;
    }

    public void addChild(Object object) {
        if (this.children == null || this.children.length == this.numChildren) {
            this.children = new Object[this.numChildren];
        }
        this.children[this.numChildren++] = object;
    }

    public void removeChild(Object object) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != object) continue;
            System.arraycopy(this.children, i + 1, this.children, i, this.numChildren - i - 1);
            break;
        }
    }

    protected void setParent(HAnimObjectParent hAnimObjectParent) {
        this.parent = hAnimObjectParent;
    }

    protected void updateLocation(Matrix4f matrix4f, boolean bl) {
        if (this.matrixChanged) {
            HAnimSite.updateMatrix(this.center, this.rotation, this.scale, this.scaleOrientation, this.translation, this.localMatrix);
        }
        if (bl || this.matrixChanged) {
            this.globalMatrix.mul(matrix4f, this.localMatrix);
        }
        this.updateSent = false;
        this.matrixChanged = false;
    }

    private void sendUpdateMsg() {
        if (!this.updateSent && this.parent != null) {
            this.parent.childUpdateRequired(this);
            this.updateSent = true;
        }
    }
}

